<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class Datosaspirante extends Model
{
    protected $table='AspPostgrado';

    protected $primarykey='id';

    public $timestamps=false;

    protected $fillable =['id','Cedula', 'PrimerNombre', 'discapacidad_id', 
    'SegundoNombre', 'PrimerApellido','SegundoApellido','Nacionalidad',
    'NumPasaporte','EstadoCivil','Genero','FechaNacimiento','Direccion',
    'TelefonoMovil','TelefonoLocal','TelefonOficina', 'Correo','Edad',
    'Peso','Estatura','PaisOrigen_id','Etnias_id','discapacidad_id','Estados_id','Municipios_id',
    'Parroquias_id','PaisNacimiento_id','user_id'];
  
    
protected $guarded=[
];


    public function Aspirantes()
  {
      return $this->hasMany(DatosBasicos::class);
  }

    public function setFechaNacAttribute($value)
   {
       $this->attributes['FechaNacimiento'] = Carbon::createFromFormat('d/m/Y', $value)->toDateString();
   }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     public function selectpais()
  {
      return $this->belongsTo(Pais::class);
  }   
  
  
  public function scopeNombInstituto($query, $NombInstituto){
    if($NombInstituto)
        return $query->where('NombInstituto', 'LIKE', "%$NombInstituto%");

    }

       public function scopeNombEspecialidad($query, $NombEspecialidad)
  {
      //dd("scope: " . $name);
       if($NombEspecialidad)
     return $query->where('NombEspecialidad','LIKE',"%$NombEspecialidad%");
  }

  public function scopeNombProgramas($query, $NombProgramas)
  {
      //dd("scope: " . $name);
       if($NombProgramas)
     return $query->where('NombProgramas','LIKE',"%$NombProgramas%");
  }


}
