<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Deposito;
use App\Banco;
use App\modingress;
use App\DatosBasicos;
use App\Datosaspirante;
use App\Especialidad;
use App\SedeEspecialidades;
use App\sede;
use App\Ofertas;
use App\Oferta;
use App\Programas;
use App\audit;
use App\InstitutoUser;
use App\Http\Requests\DatosBasicosFormRequest;
use Illuminate\Support\Facedes\Redirect;
use DB;
use App\Level;
use Carbon\Carbon;
use Alert;
class DepositoController extends Controller
{
    protected $redirectTo = '/Datosbasicos/create';

   

    public function __construct(){

        $this->middleware('auth:UsuariosAspi');
    }

 public function index(){

 $DatosAspirante = $this->obtenerDatos();

            $id_user=\Auth::user()->id;

    
        //dd($idaspi);

         $Datos=DB::table('DatosBasicos')->where('DatosBasicos.user_id', '=', $id_user)
        ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_id', '=', 'ModoIngreso.id')
        ->leftJoin('Especialidad', 'DatosBasicos.Especialidad_Id', '=', 'Especialidad.Id')
        ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
        ->leftJoin('Programas', 'DatosBasicos.Programas_id', '=', 'Programas.id')
        ->select('ModoIngreso.ModoIngreso','Programas.NombProgramas','Especialidad.NombEspecialidad','Institutos.NombInstituto','DatosBasicos.id')->get($id_user);

        $deposito=DB::table('Deposito')->where('Deposito.user_id', '=', $id_user)
        ->leftJoin('Banco', 'Deposito.Banco_id', '=', 'Banco.id')
        //->leftJoin('Especialidad', 'Deposito.Especialidad_Id', '=', 'Especialidad.Id')
       // ->leftJoin('sede', 'DatosBasicos.sede_id', '=', 'sede.id_sede')
        ->select('Deposito.NumDeposito','Deposito.FechaDeposito','Deposito.id','Banco.NombBanco')->get($id_user); 
    
    $DatosBasicos=DB::table('DatosBasicos')->where('DatosBasicos.user_id', '=', $id_user)
        ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_id', '=', 'ModoIngreso.id')
        ->leftJoin('Especialidad', 'DatosBasicos.Especialidad_Id', '=', 'Especialidad.Id')
        ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
        ->leftJoin('Programas', 'DatosBasicos.Programas_id', '=', 'Programas.id')
        ->select('ModoIngreso.ModoIngreso','Programas.NombProgramas','Especialidad.NombEspecialidad','Institutos.NombInstituto','DatosBasicos.id')->first($id_user);

        $depositodatos=DB::table('Deposito')->where('Deposito.user_id', '=', $id_user)
        ->leftJoin('Banco', 'Deposito.Banco_id', '=', 'Banco.id')
        //->leftJoin('Especialidad', 'Deposito.Especialidad_Id', '=', 'Especialidad.Id')
       // ->leftJoin('sede', 'DatosBasicos.sede_id', '=', 'sede.id_sede')
        ->select('Deposito.NumDeposito','Deposito.FechaDeposito','Deposito.id','Banco.NombBanco')->first($id_user);
  
       /* $fechadepo=$deposito->FechaDeposito;

        $fechad=Carbon::parse($fechadepo)->format('d/m/Y');*/
  ///$deposito=Carbon::parse($request->input('FechaDeposito'))->format('d/m/Y'); 
   // $fecha=Carbon::createFromFormat('d/m/Y');    
    //dd($fechad);


        $aprob = "1";

       
        $modoing =DB::table('ofertas')
        ->where('ofertas.Aprobacion','=',$aprob)
        ->leftJoin('ModoIngreso', 'ofertas.ModoIngreso_Id', '=', 'ModoIngreso.id')
    ->orderBy('id','ASC')->pluck('ModoIngreso','ModoIngreso.Id'); 
 //  dd($modingreso);
        return view('Aspidatos.indexBasico',compact('Datos','modoing','deposito','fechad','banco','sedeofertas','modingreso', 'depositodatos', 'DatosBasicos'));


    }


    

   public function create()
    {
        $aprob = "1";

        $deposito=Deposito::get();
        $banco =Banco::orderBy('NombBanco','ASC')->pluck('NombBanco','id'); 
       
    $sedeofertas=DB::table('ofertas')->where('ofertas.Aprobacion', '=', $aprob)
        ->leftJoin('Especialidad', 'ofertas.Especialidad_Id', '=', 'Especialidad.Id')
        ->leftJoin('Institutos', 'ofertas.Institutos_id', '=', 'Institutos.id')->orderBy('NombInstituto')
        //->groupby('ofertas.sede_id')
        ->orderBy('NombInstituto','ASC')->pluck('NombInstituto','Institutos.id');


        $modingreso= DB::table('ModoIngreso')->where('ofertas.Aprobacion', '=', $aprob)
        ->orderBy('ModoIngreso','ASC')->pluck('ModoIngreso','id'); 
        //dd($modingreso);
        //$deposito=Deposito::get();
        //$banco =Banco::get();
        //$modingreso =modingresos::get();
       // $basico =Datosbasicos::get();
       // $especialidad =Especialidad::get();
       //$sede=sede::get();
       // $asp=Aspirante::get();

        return view('Aspidatos.form', compact('deposito','banco','modingreso','especialidad','sede','sedeofertas'));
    }


    public function getNuevoIngreso($id)
    {
    	 $aprob = "1";


    	 $periodo= DB::table('Periodo')
        ->where('Periodo.Vigente', '=',$aprob)
        ->first();
       $idperiodo=$periodo->id;

      
        $modoingreso =DB::table('ofertas')->where('ofertas.ModoIngreso_Id','=',$id)
       // ->where('ofertas.users_id','=',$idmodo)
        ->where('ofertas.Aprobacion', '=', $aprob)
        ->where('ofertas.Periodo_id', '=', $idperiodo) 
            ->leftJoin('Institutos', 'Institutos.id', '=', 'ofertas.Institutos_id')
            ->pluck("Institutos.NombInstituto","Institutos.id");
           // dd($modoingreso);
            return json_encode($modoingreso);

    }


         public function getprogramas($ingresoId,$sedeId)
            {
                $aprob = "1";
               

    	 $periodo= DB::table('Periodo')
        ->where('Periodo.Vigente', '=',$aprob)
        ->first();
       $idperiodo=$periodo->id;


                $programas =DB::table('ofertas')
               ->where('ofertas.Institutos_id','=',$sedeId)
               ->where('ofertas.Aprobacion', '=', $aprob)
               ->where('ofertas.ModoIngreso_Id','=',$ingresoId)
                 ->where('ofertas.Periodo_id', '=', $idperiodo) 
               // ->where('ofertas.users_id','=',$idmodo)
               ->leftJoin('Programas', 'Programas.id', '=', 'ofertas.Programas_id')
               ->pluck("Programas.NombProgramas","Programas.id");
             //  dd($programas);
                    return json_encode($programas);

            }

    public function Subprogramas($ingresoId,$id,$institutoId)
            {
                $aprob = "1";


    	 $periodo= DB::table('Periodo')
        ->where('Periodo.Vigente', '=',$aprob)
        ->first();
       $idperiodo=$periodo->id;

               $subprograma =DB::table('ofertas')
               ->where('ofertas.ModoIngreso_Id','=',$ingresoId)
               ->where('ofertas.Institutos_id','=',$institutoId)
               ->where('ofertas.Programas_id','=',$id)
                ->where('ofertas.Periodo_id', '=', $idperiodo) 
                ->where('ofertas.Aprobacion', '=', $aprob)
              ->leftJoin('Especialidad', 'Especialidad.id', '=', 'ofertas.Especialidad_id')
               ->groupby('ofertas.Especialidad_id','Especialidad.NombEspecialidad',
               'Especialidad.id')  
               ->pluck('Especialidad.NombEspecialidad','Especialidad.id');
           
          // dd($subprograma);
          
        return json_encode($subprograma);
          

            }

           



    public function store(Request $request ){

          
    //$depofecha=$fechadeposito;
    // dd($depofecha,$fecha);
       $rules = [
            'FechaDeposito' => 'required|date_format:d/m/Y',
            'Banco_id'  =>'required',
            'NumDeposito' =>'required|digits_between:4,20|numeric',
            'Programas_id' =>'required',
            'ModoIngreso_Id' =>'required',
             'Institutos_id' =>'required',
            'Especialidad_id' =>'required'
           
        ];


 $messages = [
    'FechaDeposito.required' => 'Este campo es requerido.',
    'Banco_id.required' => 'Debe seleccionar este campo.',
    'NumDeposito.required' => 'Este campo es requerido.',
            'ModoIngreso_Id.required' => 'Debe seleccionar este campo.',
            'Institutos_id.required' => 'Debe seleccionar este campo.',
            'Especialidad_id.required' => 'Debe seleccionar este campo.',
            'Programas_id.required' => 'Debes seleccionar este campo.',
        
        ];
        
        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->action('DepositoController@FormDatBasicos',$request)
                ->withErrors($validator)
                ->withInput();
        }

        $mytime = Carbon::now();
        $fecha= $mytime; 
         // dd($fecha);
      $fechadeposito= Carbon::createFromFormat( 'd/m/Y', $request->input('FechaDeposito'));


        $id_user=\Auth::user()->id;
        $activo = "1";
        $per= DB::table('Periodo')
        ->where('Periodo.Vigente', '=',$activo)->first();
       $idperiodo=$per->id;     
         
   $Dato =DB::select('SELECT AspPostgrado.id FROM AspPostgrado , UsuariosAspi where   UsuariosAspi.id=user_id and    UsuariosAspi.id ='.$id_user);

  if ($fechadeposito  <= $fecha)  
      # code...Carbon::parse($request->input('FechaDeposito'))->format('d/m/Y'); 
  
   {

        $deposito= new Deposito(request()->all());
        $deposito->user_id= \Auth::user()->id;
        $deposito->FechaDeposito=Carbon::createFromFormat( 'd/m/Y', $request->input('FechaDeposito'));

     

      

        $deposito->AspPostgrado_id = $Dato[0]->id;
        $deposito->Periodo_id=$idperiodo;
       //dd($deposito);
        $deposito->save();

        $basico=new DatosBasicos(request()->all());
        
        $prueba=$basico->ModoIngreso_id;
     
         $basico->user_id= \Auth::user()->id;
         $basico->AspPostgrado_id = $Dato[0]->id;  
         $basico->Periodo_id=$idperiodo;
        //dd($basico);
         $basico->save();
        
         $nombre_especialidad = Especialidad::find($request->input('Especialidad_id'))->NombEspecialidad;
        $modoingreso = modingress::find($request->input('ModoIngreso_Id'))->ModoIngreso;
       $institutos = InstitutoUser::find($request->input('Institutos_id'))->NombInstituto;
        $programas = Programas::find($request->input('Programas_id'))->NombProgramas;
        //dd($nombre_especialidad);
         $info = array(
             ('ModoIngreso') =>  $modoingreso,
             ('Especialidad')=>   $nombre_especialidad,
             ('Programas') =>  $programas,
             ('Institutos')=>  $institutos,
           
            
             );

         
        $array_json = json_encode($info);
       // $array_json->modoingreso->ModoIngreso;
     // dd($array_json);
         $Datobasico =DB::select('SELECT DatosBasicos.id FROM DatosBasicos , UsuariosAspi where   UsuariosAspi.id=user_id and    UsuariosAspi.id ='.$id_user);
         $Acciones="Creacion";
         $fechacreacion = Carbon::now();

         $auditoria=new audit(request()->all());
         $auditoria->datosbasicos_id = $Datobasico[0]->id; 
         $auditoria->accion =$Acciones;  
         $auditoria->Created_at =$fechacreacion;  
        
         $auditoria->Registro =$array_json; 
          
         $auditoria->save();
       
           \Auth::user()->update([
        'datos_basicos' => 1,
       ]);


         alert()->success(' ', 'Sus datos fueron guardados correctamente')->autoclose(2500);
        return redirect()->route('Datosbasicos.index');

    

        } 
      
  else
        {

      alert()->error('Error', 'Fecha de deposito invalida')->autoclose(2500);
           
      return redirect()->action('DepositoController@FormDatBasicos',$request);
        
    }
    }

    public function show($id)
    {

    }


    public function byproyect($id)
    {
       return DatosBasicos::where('sede_id',$id)->get();
    }

     public function edit($id)
    {
        $id_user=\Auth::user()->id;
        
         $deposito=DB::table('Deposito')->where('Deposito.user_id', '=', $id_user)
        ->leftJoin('Banco', 'Deposito.Banco_id', '=', 'Banco.id')
        //->leftJoin('Especialidad', 'Deposito.Especialidad_Id', '=', 'Especialidad.Id')
       // ->leftJoin('sede', 'DatosBasicos.sede_id', '=', 'sede.id_sede')
        ->select('Deposito.NumDeposito','Deposito.FechaDeposito','Deposito.id','Banco.NombBanco')->first($id_user);
  
       $fechadepo=$deposito->FechaDeposito;

        $fechad=Carbon::parse($fechadepo)->format('d/m/Y');

        //$Datos=DatosBasicos::find($id);
        $deposito=Deposito::find($id);
        $banco =Banco::orderBy('NombBanco','ASC')->pluck('NombBanco','id'); 
     
    

        return view('Aspidatos.editDatosDeposito', compact('fechad','deposito','banco'));
    }


    public function datBasicos($id)
    {
     //dd($id);
     $aprob = "1";

       
     $modoing =DB::table('ofertas')
     ->where('ofertas.Aprobacion','=',$aprob)
     ->leftJoin('ModoIngreso', 'ofertas.ModoIngreso_Id', '=', 'ModoIngreso.id')
 ->orderBy('id','ASC')->pluck('ModoIngreso','ModoIngreso.Id'); 
        $Datos=DatosBasicos::find($id);
        return view('Aspidatos.editdatisBasico', compact('modoing'));


    }



    public function geteditDatBasicos($id)
    {
          $id_user=\Auth::user()->id;
        $aprob = "1";


    	 $periodo= DB::table('Periodo')
        ->where('Periodo.Vigente', '=',$aprob)
        ->first();
       $idperiodo=$periodo->id;



           $Datosbasico=DB::table('DatosBasicos')->where('DatosBasicos.user_id', '=', $id_user)
        ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_id', '=', 'ModoIngreso.id')
        ->leftJoin('Especialidad', 'DatosBasicos.Especialidad_Id', '=', 'Especialidad.Id')
        ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
        ->leftJoin('Programas', 'DatosBasicos.Programas_id', '=', 'Programas.id')
        ->select('ModoIngreso.ModoIngreso','Programas.NombProgramas','Especialidad.NombEspecialidad','Institutos.NombInstituto','DatosBasicos.id','DatosBasicos.Programas_id')->first($id_user);
       // dd($idprograma);
       $modoing =DB::table('DatosBasicos')
       ->where('DatosBasicos.user_id', '=', $id_user)
       ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_Id', '=', 'ModoIngreso.id')
       ->first();
       $idIngreso=$modoing->ModoIngreso_Id;

       $institut =DB::table('DatosBasicos')
       ->where('DatosBasicos.user_id', '=', $id_user)
       ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
       ->first();
       $idsede=$institut->Institutos_id;

       $program =DB::table('DatosBasicos')
       ->where('DatosBasicos.user_id', '=', $id_user)
       ->leftJoin('Programas', 'DatosBasicos.Programas_id', '=', 'Programas.id')
       ->first();
       $idpragra=$program->Programas_id;
       //dd($idpragra);


    

        $sedeofertas=DB::table('ofertas')
        ->where('ofertas.Aprobacion', '=', $aprob)
        ->where('ofertas.ModoIngreso_Id','=',$idIngreso)
         ->where('ofertas.Periodo_id', '=', $idperiodo) 
       // ->leftJoin('Especialidad', 'ofertas.Especialidad_Id', '=', 'Especialidad.Id')
        ->leftJoin('Institutos', 'ofertas.Institutos_id', '=', 'Institutos.id')
        ->orderBy('Institutos.id','ASC')
        ->pluck('NombInstituto','Institutos.id'); 
        //->groupby('ofertas.sede_id')
      //  dd($sedeofertas);
        
     $modingreso =DB::table('ofertas')
     ->where('ofertas.Aprobacion', '=', $aprob)
     ->where('ofertas.Periodo_id', '=', $idperiodo) 
     ->where('ofertas.Periodo_id', '=', $idperiodo) 
     ->leftJoin('ModoIngreso', 'ofertas.ModoIngreso_Id', '=', 'ModoIngreso.id')
     ->orderBy('id','ASC')->pluck('ModoIngreso','ModoIngreso.Id');
       
       $especialidades= DB::table('ofertas')
         ->where('ofertas.ModoIngreso_Id','=',$idIngreso)
         ->where('ofertas.Institutos_id','=',$idsede)
         ->where('ofertas.Programas_id','=',$idpragra)
         ->where('ofertas.Periodo_id', '=', $idperiodo) 
         ->leftJoin('Especialidad', 'ofertas.Especialidad_Id', '=', 'Especialidad.Id')
         ->orderBy('NombEspecialidad','ASC')
         ->pluck('NombEspecialidad','Especialidad.Id');
        //dd($especialidades);

       /* $especialidades= DB::table('DatosBasicos')
        ->leftJoin('Especialidad', 'DatosBasicos.Especialidad_Id', '=', 'Especialidad.Id')
        ->orderBy('NombEspecialidad','ASC')
        ->pluck('NombEspecialidad','Especialidad.Id');*/

        $programas= DB::table('ofertas')
        ->leftJoin('Programas', 'ofertas.Programas_id', '=', 'Programas.id')
        ->where('ofertas.ModoIngreso_Id','=',$idIngreso)
        ->where('ofertas.Institutos_id','=',$idsede)
        ->where('ofertas.Periodo_id', '=', $idperiodo) 
        ->orderBy('NombProgramas','ASC')
        ->pluck('NombProgramas','Programas.id');

     //  dd($programas);
        //$especialidad =Especialidad::get();
       // Datos$sedeofertas=sede::get();
        $Datos=DatosBasicos::find($id);
        ///dd($Datos);
       


        return view('Aspidatos.editDatosBasicos', compact('especialidades','Datos','programass','basico','modingreso','programas','sedeofertas'));
    }


     public function getUpdateDatBasicos(Request $request, $id)
    {
      //dd($id);
         $rules = [
            'Programas_id' =>'required',
            'ModoIngreso_Id' =>'required',
             'Institutos_id' =>'required',
            'Especialidad_id' =>'required'
           
        ];


 $messages = [
            'ModoIngreso_Id.required' => 'Debe seleccionar este campo.',
            'Institutos_id.required' => 'Debe seleccionar este campo.',
            'Especialidad_id.required' => 'Debe seleccionar este campo.',
            'Programas_id.required' => 'Debe seleccionar este campo.',
        
        ];


        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->action('DepositoController@getUpdateDatBasicos',$id)
                ->withErrors($validator)
                ->withInput();
        }

        $basico=DatosBasicos::findOrFail($id);
        $basico->ModoIngreso_Id=$request->get('ModoIngreso_Id');
        $basico->Especialidad_id=$request->get('Especialidad_id');  
        
        $basico->Institutos_id=$request->get('Institutos_id'); 
        $basico->Programas_id=$request->get('Programas_id');
        $basico->update(); 
        
        $nombre_especialidad = Especialidad::find($request->input('Especialidad_id'))->NombEspecialidad;
        $modoingreso = modingress::find($request->input('ModoIngreso_Id'))->ModoIngreso;
        $institutos = InstitutoUser::find($request->input('Institutos_id'))->NombInstituto;
        $programas = Programas::find($request->input('Programas_id'))->NombProgramas;
        
        $info = array(
            ('ModoIngreso') =>  $modoingreso,
            ('Especialidad')=>   $nombre_especialidad,
            ('Programas') =>  $programas,
            ('Institutos')=>  $institutos,
          
           
            );
          
            
$array_json = json_encode($info);
       // $array_json->modoingreso->ModoIngreso;
      // dd($array_json);
      
     
      $id_user=\Auth::user()->id;
            
         $Datobasico =DB::select('SELECT DatosBasicos.id FROM DatosBasicos , UsuariosAspi where   UsuariosAspi.id=user_id and    UsuariosAspi.id ='.$id_user);
         $Acciones="Modificacion";
         $fechacreacion = Carbon::now();

         $auditoria=new audit(request()->all());
         $auditoria->datosbasicos_id = $Datobasico[0]->id; 
         $auditoria->accion =$Acciones;  
         $auditoria->Created_at =$fechacreacion;  
        
         $auditoria->Registro =$array_json; 
          
         $auditoria->save();
       

         alert()->success(' ', 'Sus datos fueron actualizados correctamente')->autoclose(2500);
        return redirect()->route('Datosbasicos.index');
    }



    public function update(Request $request, $id)
    {
                    $rules = [
                        'FechaDeposito' => 'required|date_format:d/m/Y',
                        'Banco_id'  =>'required',
                        'NumDeposito' =>'required|digits_between:4,20|numeric',
                    
                    ];


            $messages = [
                'FechaDeposito.required' => 'Este campo es requerido.',
                'Banco_id.required' => 'Debe seleccionar este campo.',
                'NumDeposito.required' => 'Este campo es requerido.',
                    
                    
                    ];


                    $validator = Validator::make($request->all(), $rules, $messages);

                    if ($validator->fails()) {
                        return redirect()->action('DepositoController@edit',$id)
                            ->withErrors($validator)
                            ->withInput();
                    }

                $mytime = Carbon::now();
                $fecha= $mytime; 
                // dd($fecha);
                $fechadeposito= Carbon::createFromFormat( 'd/m/Y', $request->input('FechaDeposito'));
                //dd($fecha,$fechadeposito);
                //$depofecha=$fechadeposito;


                if ($fechadeposito  <= $fecha) 
                # code...
            
            {
                
                    $deposito=Deposito::findOrFail($id);
                    $deposito->NumDeposito=$request->get('NumDeposito');
                    $deposito->FechaDeposito=$request->FechaDeposito= Carbon::createFromFormat( 'd/m/Y', $request->input('FechaDeposito'));  
                    $deposito->Banco_id=$request->get('Banco_id');
                    $deposito->update();


                    alert()->success(' ', 'Sus datos fueron actualizados correctamente')->autoclose(2500);
                    return redirect()->route('Datosbasicos.index');

                }
                    
            else { 
                    alert()->error('Error', 'Fecha de deposito invalida')->autoclose(2500);
                    
                    return redirect()->route('Datosbasicos.edit',$id)->withInput();
                }
        }


        public function FormDatBasicos(Request $request)
        {
           
            $idModoingreso=$request->ModoIngreso_Id;
            $idsede=$request->Institutos_id;
            $idprograma=$request->Programas_id;
            $aprob = "1";
            
     
        $banco =Banco::orderBy('NombBanco','ASC')->pluck('NombBanco','id'); 
            $modoing =DB::table('ofertas')
                    ->where('ofertas.ModoIngreso_Id','=',$idModoingreso)
                    ->leftJoin('ModoIngreso', 'ofertas.ModoIngreso_Id', '=', 'ModoIngreso.id')
                    ->orderBy('ModoIngreso','ASC')->pluck('ModoIngreso','ModoIngreso.Id');
       
         $INstitutos =DB::table('ofertas')
         ->where('ofertas.ModoIngreso_Id','=',$idModoingreso)
         ->where('ofertas.Institutos_id','=',$idsede)
         ->where('ofertas.Aprobacion','=',$aprob)
         ->leftJoin('Institutos', 'ofertas.Institutos_id', '=', 'Institutos.id')
         ->orderBy('id','ASC')->pluck('NombInstituto','Institutos.id');
        

         $programa =DB::table('ofertas')
                ->where('ofertas.ModoIngreso_Id','=',$idModoingreso)
                ->where('ofertas.Institutos_id','=',$idsede)
                ->where('ofertas.Programas_id','=',$idprograma)
                ->leftJoin('Programas', 'ofertas.Programas_id', '=', 'Programas.id')
                ->orderBy('id','ASC')->pluck('NombProgramas','Programas.id');
            

                $Especialidadcurso1 =DB::table('ofertas')
                ->where('ofertas.ModoIngreso_Id','=',$idModoingreso)
                ->where('ofertas.Institutos_id','=',$idsede)
                
                ->where('ofertas.Programas_id','=',$idprograma)
                ->leftJoin('Especialidad', 'ofertas.Especialidad_id', '=', 'Especialidad.id')
                ->orderBy('id','ASC')->pluck('NombEspecialidad','Especialidad.id');
              //  dd($INstitutos, $programa, $Especialidadcurso1, $modoing);
                return view('Aspidatos.form',compact('banco','modoing','programa','INstitutos','Especialidadcurso1'));
    
       
            
        }





}


