<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">
                    Productos
                    <?php if (\Shinobi::can('products.create')): ?>
                    <a href="<?php echo e(route('products.create')); ?>" 
                    class="btn btn-sm btn-primary pull-right">
                        Crear
                    </a>
                    <?php endif; ?>
                </div>

                <div class="panel-body">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th width="10px">ID</th>
                                <th>Nombre</th>
                                <th colspan="3">&nbsp;</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($product->id); ?></td>
                                <td><?php echo e($product->name); ?></td>
                                <?php if (\Shinobi::can('products.show')): ?>
                                <td width="10px">
                                    <a href="<?php echo e(route('products.show', $product->id)); ?>" 
                                    class="btn btn-sm btn-default">
                                        ver
                                    </a>
                                </td>
                                <?php endif; ?>
                                <?php if (\Shinobi::can('products.edit')): ?>
                                <td width="10px">
                                    <a href="<?php echo e(route('products.edit', $product->id)); ?>" 
                                    class="btn btn-sm btn-default">
                                        editar
                                    </a>
                                </td>
                                <?php endif; ?>
                                <?php if (\Shinobi::can('products.destroy')): ?>
                                <td width="10px">
                                    <?php echo Form::open(['route' => ['products.destroy', $product->id], 
                                    'method' => 'DELETE']); ?>

                                        <button class="btn btn-sm btn-danger">
                                            Eliminar
                                        </button>
                                    <?php echo Form::close(); ?>

                                </td>
                                <?php endif; ?>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($products->render()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>