<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;
use DB;
use Alert;
class AspiranteLoginController extends Controller
{
    
	 public function __construct()
    {
        $this->middleware('guest:UsuariosAspi');
    }

   public function showLoginForm()
   {
     
  	return view('authAspirante.login');

   // return view('errors.403'); //comentar esta linea para activar
   }

     

   	public function login(Request $request)
   	{
 

   		$this->validate($request,[
   			'email' => 'required|email',
   			'password' => 'required|min:6'

   		]);

   		if (Auth::guard('UsuariosAspi')->attempt(['email'=> $request->email, 'password' => $request->password, /*'confirmed' => 1*/], $request->remenber))
       {
   			return redirect()->intended(route('DatosAspirante.index'));
   		}
   
       alert()->error(' ', 'Activar cuenta o contraseña incorrecta')->persistent('Cerrar');
   		
   			return redirect()->back()->withInput($request->only('email','remenber'));
   	}



}
