<?php

namespace App\Http\Controllers;

use App\Especialidad;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use Illuminate\Pagination;
use DB;
use Illuminate\Support\Facades\Validator;
use App\SedeEspecialidad;
use App\programas;
use App\Sede;
use App\Periodo;
use App\sedeInstitutos;
use App\Datosaspirante;
use App\DatosBasicos;
use App\Oferta;
use Alert;
class EspecialidadController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()

    {
 
     $this->middleware('permission:Especialidad.index')->only('index');
         
    $this->middleware('permission:Especialidad.create')->only(['create','store']);	
 
    $this->middleware('permission:Especialidad.edit')->only(['edit','update']);
 
    $this->middleware('permission:Especialidad.show')->only('show');
 
    $this->middleware('permission:Especialidad.destroy')->only('destroy');
    
   
}


    public function getsubprogramas(Request $request)
    {
      $programa = Especialidad::where('Programas_id',$request->valor)->get();
      
        return response()->json($programa);

    }

 public function modoingreget($id)
            {
                $aprob = "1";
                
                $per= DB::table('Periodo')
        ->where('Periodo.Vigente', '=',$aprob)->first();
       $idperiodo=$per->id; 


                $modoingreget =DB::table('ofertas')
                ->where('ofertas.Aprobacion','=',$aprob)
               ->where('ofertas.Institutos_id','=',$id)
               ->where('ofertas.Periodo_id', '=', $idperiodo)
              // ->where('ofertas.ModoIngreso_Id','=',$ingresoId)
               // ->where('ofertas.users_id','=',$idmodo)
               ->leftJoin('ModoIngreso', 'ModoIngreso.Id', '=', 'ofertas.ModoIngreso_Id')
               ->pluck("ModoIngreso.ModoIngreso","ModoIngreso.Id");
                    return json_encode($modoingreget);

            }


   public function programasget($institutoId)
            {
                $aprob = "1";
                
                $per= DB::table('Periodo')
        ->where('Periodo.Vigente', '=',$aprob)->first();
       $idperiodo=$per->id; 


                $programas =DB::table('ofertas')
                ->where('ofertas.Aprobacion','=',$aprob)
               ->where('ofertas.Institutos_id','=',$institutoId)
               ->where('ofertas.Periodo_id', '=', $idperiodo)
         	//->where('ofertas.ModoIngreso_Id','=',$modoingreId)
               // ->where('ofertas.users_id','=',$idmodo)
               ->leftJoin('Programas', 'Programas.id', '=', 'ofertas.Programas_id')
               ->pluck("Programas.NombProgramas","Programas.id");
                    return json_encode($programas);

            }

    public function getMension($programasId,$institutoId)
            {
            
            //dd($institutoId,$modoingreId,$programasId);
                $aprob = "1";

                $per= DB::table('Periodo')
                ->where('Periodo.Vigente', '=',$aprob)->first();
               $idperiodo=$per->id; 
        
               $subprograma =DB::table('ofertas')
               ->where('ofertas.Aprobacion','=',$aprob)
               ->where('ofertas.Institutos_id','=',$institutoId)
             // ->where('ofertas.ModoIngreso_Id','=',$modoingreId)
               ->where('ofertas.Programas_id','=',$programasId)
               ->where('ofertas.Periodo_id', '=', $idperiodo)
               ->leftJoin('Especialidad', 'Especialidad.id', '=', 'ofertas.Especialidad_id')
               ->groupby('Especialidad.NombEspecialidad',
               'Especialidad.id') 
               ->pluck('Especialidad.NombEspecialidad','Especialidad.id');
           
          
        return json_encode($subprograma);
          

            }

    public function index(Request $request)
    {   

        $idusuario = Auth::user()->id;
      /*  if (Auth::user()->users_id == '1'){

        
 $consultas=DB::table('sede_especialidads')->orderby('id','ASC')
            ->leftJoin('Periodo', 'sede_especialidads.Periodo_id', '=', 'Periodo.id')
          //  ->leftJoin('sede', 'sede_especialidads.sede_id', '=', 'sede.id_sede')  
            ->leftJoin('Especialidad', 'sede_especialidads.Especialidad_id', '=', 'Especialidad.id')
            ->leftJoin('Programas', 'sede_especialidads.Programas_id', '=', 'Programas.Id')
             ->leftJoin('Institutos', 'sede_especialidads.Institutos_id', '=', 'Institutos.id')
            ->select('Periodo.NombrePeriodo','Periodo.Lapso', 'Especialidad.NombEspecialidad',
            'sede_especialidads.id','sede_especialidads.Vigente', 'Programas.NombProgramas', 'Institutos.NombInstituto',
            'sede_especialidads.created_at')->paginate(4);
        }  else { */
     

            $aprob = "1";


       $periodo= DB::table('Periodo')
        ->where('Periodo.Vigente', '=',$aprob)
        ->first();
       $idperiodo=$periodo->id;


$instituto=DB::table('sede_especialidads')

          ->leftJoin('Institutos', 'sede_especialidads.Institutos_id', '=', 'Institutos.id')
         // ->select('Institutos.NombInstituto')
          ->orderBy('Institutos.id','ASC')
          ->pluck('NombInstituto','Institutos.NombInstituto');
//dd($instituto);

    $NombInstituto  = $request->get('NombInstituto');
   //dd($NombInstituto);

//$aprobar=Oferta::where('ofertas.Aprobacion', '=', $siaprob)
 $consultas=SedeEspecialidad::orderby('id','ASC')
          ->leftJoin('Periodo', 'sede_especialidads.Periodo_id', '=', 'Periodo.id')
           ->where('sede_especialidads.Periodo_id', '=', $idperiodo) 
        //  ->leftJoin('sede', 'sede_especialidads.sede_id', '=', 'sede.id_sede')  
          ->leftJoin('Especialidad', 'sede_especialidads.Especialidad_id', '=', 'Especialidad.id')
          ->leftJoin('Programas', 'sede_especialidads.Programas_id', '=', 'Programas.Id')
           ->leftJoin('Institutos', 'sede_especialidads.Institutos_id', '=', 'Institutos.id')
          ->select('Periodo.NombrePeriodo','Periodo.Lapso', 'Especialidad.NombEspecialidad',
          'sede_especialidads.id','sede_especialidads.Vigente', 'Programas.NombProgramas', 'Institutos.NombInstituto',
          'sede_especialidads.created_at')
          ->NombInstituto($NombInstituto)        
          ->paginate(25);
           
    return view('especialidad.index',compact('consultas', 'instituto'));   
    
}



    public function listas()
    {
        $consultas= DB::table('sede_especialidads')->where('id_sede', '=', \Auth::user()->sede_id)
        ->leftJoin('Especialidad', 'sede_especialidads.Especialidad_id', '=', 'Especialidad.Id')
        ->leftJoin('sede', 'sede_especialidads.Sede_Id', '=', 'sede.id_sede')
        ->leftJoin('sede', 'sede_especialidads.Sede_Id', '=', 'sede.id_sede')
        ->leftJoin('sede', 'sede_especialidads.Sede_Id', '=', 'sede.Sede_Id')->get();
    return view('especialidad/prueba',compact('consultas'));    
    }

    public function show($id)
    {
        $especialidad= DB::table('sede_especialidads')->where('sede_especialidads.id', '=', $id)
        ->leftJoin('Especialidad', 'sede_especialidads.Especialidad_id', '=', 'Especialidad.Id')
        ->leftJoin('sede', 'sede_especialidads.sede_id', '=', 'sede.id_sede')
        ->leftJoin('Periodo', 'sede_especialidads.Periodo_id', '=', 'Periodo.id')
         ->select('Especialidad.NombEspecialidad','sede.NombSede','sede_especialidads.Vigente','sede_especialidads.Periodo_id')
        ->first();
  
    return view('especialidad.show',compact('especialidad'));    
    }

   public function create()
    {

     
         $idusuario = Auth::user()->id;

           $sedes= DB::table('Institutos')->orderby('id','ASC')->pluck('NombInstituto','id');

       /* $sedes=DB::table('sedeInstitutos')
        ->leftJoin('Institutos', 'sedeInstitutos.Institutos_id', '=', 'Institutos.id')
        ->orderBy('NombInstituto','ASC')->pluck('NombInstituto','Institutos.id');
      //  dd($nucleos);*/

        $especialidades= DB::table('Especialidad')->orderby('NombEspecialidad','ASC')->pluck('NombEspecialidad','id');
        $programas= DB::table('Programas')->orderby('NombProgramas','ASC')->pluck('NombProgramas','id');

        $activo = "1";
       /* $ofertas=DB::table('ofertas')->where('ofertas.Aprobacion', '=', $noaprob)
        ->leftJoin('ModoIngreso', 'ofertas.ModoIngreso_Id', '=', 'ModoIngreso.Id')
        ->leftJoin('Institutos', 'ofertas.Institutos_id', '=', 'Institutos.id')
        ->leftJoin('Especialidad', 'ofertas.Especialidad_id', '=', 'Especialidad.Id')
        ->leftJoin('Programas', 'ofertas.Programas_id', '=', 'Programas.id')
        //->leftJoin('tipo_admision', 'ofertas.Id_Tipo', '=', 'tipo_admision.id_tipo')
        ->select('ModoIngreso.ModoIngreso','Institutos.NombInstituto', 'Especialidad.NombEspecialidad','ofertas.Cuposupel','ofertas.nroresolucion','ofertas.id','ofertas.created_at','Programas.NombProgramas')*/




        $per= DB::table('Periodo')
        ->where('Periodo.Vigente', '=',$activo)
        ->orderby('Lapso','ASC')->pluck('Lapso','id');
      // dd($per);
       // $nucleos=DB::table('sedeInstitutos')->where('id', '=', \Auth::user()->Institutos_id)->get();

   
        return view('especialidad.create',compact('especialidades','per','sedes','Sedee','programas'));
    }

  /*  $id_user=\Auth::user()->id;
 
        $user=DB::table('sedeInstitutos')->where('sedeInstitutos.users_id', '=', $id_user)
        ->leftJoin('sede', 'sedeInstitutos.sede_id', '=', 'sede.id_sede')
       // ->leftJoin('tipo_admision', 'users.Id_Tipo', '=', 'tipo_admision.id_tipo')
        ->leftJoin('Institutos', 'sedeInstitutos.Institutos_id', '=', 'Institutos.id')
        ->select('sede.NombSede','Institutos.NombInstituto','sedeInstitutos.sede_id', 'sedeInstitutos.Institutos_id')
        ->first();
        $sedeid=$user->sede_id;
    // dd($sedeid);*/


    public function store(Request  $request)
    {

         $rules = [
            // 'seleccione' => 'required', 
            'Institutos_id' => 'required',
            'Programas_id' => 'required',
            'Especialidad_id' => 'required',
            'Periodo_id' => 'required',
            'Vigente' => 'required',
           /* 'nucleos' => 'required',
            'rols_id' => 'required',
            'Apellidos' => 'required|max:20|alpha',
            'cedula' =>  'required|numeric|unique:users|digits_between:7,8',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6|confirmed',*/
            
        ];

        $messages = [
           // 'seleccione.required' => 'Este campo es Obligatorio.',
          'Institutos_id.required' => 'Este campo es requerido.',
         'Programas_id.required' => 'Este campo es requerido.',
            'Especialidad_id.required' => 'Este campo es requerido.',
            'Periodo_id.required' => 'Este campo es requerido.',
            'Vigente.required' => 'Este campo es requerido.',
           /* 'nucleos.required' => 'Este campo es Obligatorio.',
            'rols_id.required' => 'Este campo es Obligatorio.',
            'Apellidos.required' => 'Este campo es Obligatorio.',
            'cedula.required' => 'Este campo es Obligatorio.',
            'email.required' => 'Este campo es Obligatorio.',
            'email.required' => 'Este campo es Obligatorio.',
            'password.required' => 'Este campo es Obligatorio.',
           
            
*/
        ];


        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->action('EspecialidadController@create')
                ->withErrors($validator)->withInput();
        }

          /*  $data = array(
            $request->input('Programas_id') => $request->input('Especialidad_id'),

           
        );

        
        foreach ($data as $key => $value) {
            //dd($value);
            foreach ($value as $instituto){
             //dd($instituto);*/
           
   
$data = array(
            $request->input('Institutos_id') => $request->input('Especialidad_id')

          
        ); 




           foreach ($data as $key => $value) {
     foreach ($value as $Especialidad){

 $resultado=DB::table('sede_especialidads')
    ->where('sede_especialidads.Especialidad_id', $Especialidad)
    ->where('sede_especialidads.Institutos_id', $request->input('Institutos_id'))
    ->where('sede_especialidads.Periodo_id', $request->input('Periodo_id'))
    ->exists();
//dd($resultado);

if ($resultado) {
            
    Alert::error('Error el programa para este instituto ya existe')->autoclose(3500);
    return redirect()->route('Especialidad.create')->withInput();

}
      //dd($Especialidad);
         $datosSocio = new SedeEspecialidad;
            $user = Auth::user();
            $datosSocio->Programas_id       = $request->Programas_id;
            $datosSocio->users_id           = $user->id;
            //$datosSocio->sede_id            = $request->sede_id;
            $datosSocio->Vigente            = $request->Vigente;
            $datosSocio->Periodo_id         = $request->Periodo_id;
            $datosSocio->Institutos_id      = $request->Institutos_id;
            $datosSocio->Especialidad_id    = $Especialidad;
      

           // dd($datosSocio);
            $datosSocio->save();
        
          }
       };



           
    Alert::success('Programa Asignado con éxito')->autoclose(3500);

        return redirect()->route('Especialidad.index');
    }

    public function form()
    {
        $sedes= DB::table('sedes')->where('Id', '=', \Auth::user()->id_sede)->get();
        $especialidades= DB::table('Especialidad')->get();
         $programas= DB::table('Programas')->get();
        return view('especialidad/fragment/form',compact('sedes','especialidades','programas'));
    }





public function edit($id)
    {

      
       $especialidad= SedeEspecialidad::find($id);
       $subprograma=$especialidad->Especilidad_id;
        $idusuario = Auth::user()->id;
       $sedes= DB::table('Institutos')->orderby('id','ASC')->pluck('NombInstituto','id');
     /*   $sedes=DB::table('sedeInstitutos')
        ->leftJoin('Institutos', 'sedeInstitutos.Institutos_id', '=', 'Institutos.id')
        ->orderBy('NombInstituto','ASC')->pluck('NombInstituto','Institutos.id');*/

        $especialidades= DB::table('Especialidad')->orderby('NombEspecialidad','ASC')->pluck('NombEspecialidad','id');
        $programas= DB::table('Programas')->orderby('NombProgramas','ASC')->pluck('NombProgramas','id');
  $activo = "1";
        $per= DB::table('Periodo')
        ->where('Periodo.Vigente', '=',$activo)
        ->orderby('Lapso','ASC')->pluck('Lapso','id');
    
        return view('especialidad.edit',compact('especialidad','sedes','especialidades','programas','subprograma','per','Sedee'));    
    }
    public function update(Request $request, $id)
    {


        
        /*   $data = array(
            $request->input('Programas_id') => $request->input('Especialidad_id '),

           
        );

        $user = Auth::user();
        foreach ($data as $key => $value) {
            //dd($value);
            foreach ($value as $instituto){
             //dd($instituto);
           
            $especialidad = SedeEspecialidad::find($id);
            $especialidad->Programas_id = $key;
            $especialidad->users_id           = $user->id;
            $especialidad->sede_id            = $request->sede_id;
            $especialidad->Vigente            = $request->Vigente;
            $especialidad->Periodo_id         = $request->Periodo_id;
            $especialidad->Especialidad_id = $instituto;
            $especialidad->update();
           }
        }*/
        

        $user = Auth::user();
         $especialidad = SedeEspecialidad::find($id);
           $especialidad->Programas_id = $request->Programas_id;
            $especialidad->users_id           = $user->id;
           // $especialidad->sede_id            = $request->sede_id;
            $especialidad->Vigente            = $request->Vigente;
            $especialidad->Periodo_id         = $request->Periodo_id;
            $especialidad->Institutos_id      = $request->Institutos_id;
            $especialidad->Especialidad_id  = $request->Especialidad_id;

            $especialidad->update();
           // dd($especialidad);  

             Alert::success('Programa Actualizado con éxito')->autoclose(3500);
        return redirect()->route('Especialidad.index');
    }
        
    


public function destroy($id)
    {
    $especialidad = SedeEspecialidad::find($id);
        
        $especialidad->delete(); 
   
     Alert::success('Programa Eliminado con éxito')->autoclose(3500);

     return redirect()->route('Especialidad.index');
    }
    

					/////Inavilita y habilita//////////



    public function deactivateEspe(Request  $request)
    {
      $aprob = "1";
      
       $vigente="1";
   
   $exiteperiodo=DB::table('Periodo')
->where('Periodo.Vigente', '=', $vigente) 
 ->select('Periodo.id')
->exists();
	//dd($exiteperiodo);
	
$per=DB::table('Periodo')
->where('Periodo.Vigente', '=', $vigente) 
 ->select('Periodo.id')
->first();

$idperiodo=$per->id;

     /* $sedeofertas=DB::table('ofertas')
        ->where('ofertas.Aprobacion', '=', $aprob)
        ->leftJoin('Institutos', 'ofertas.Institutos_id', '=', 'Institutos.id')
        ->orderBy('Institutos.id', 'ASC')->pluck('NombInstituto','Institutos.id');*/

        $sedeofertas=DB::table('ofertas')
        ->where('ofertas.Periodo_id', '=', $idperiodo)
        ->where('ofertas.Aprobacion', '=', $aprob)
        ->leftJoin('Institutos', 'ofertas.Institutos_id', '=', 'Institutos.id')
        ->select('Institutos.NombInstituto','Institutos.id')
        ->distinct('Institutos.id')
        ->orderBy('Institutos.id', 'ASC')->pluck('NombInstituto','Institutos.id');
      //dd($sedeofertas);
       
        $valor="1";
// inicio de @rownum
DB::statement(DB::raw('SET @rownum = 0'));
        
        if($exiteperiodo == true){
        
      //  dd($NombEspecialidad);
    $datos=Datosaspirante::where('UsuariosAspi.datos_personales', '=', $valor)
       ->where('UsuariosAspi.datos_basicos', '=', $valor)
       ->where('UsuariosAspi.datos_academico', '=', $valor)
       ->where('UsuariosAspi.datos_socioEconomico', '=', $valor)
      // ->where('UsuariosAspi.datos_vocacional', '=', $valor)
       ->leftJoin('UsuariosAspi', 'AspPostgrado.user_id', '=', 'UsuariosAspi.id')
       ->leftJoin('DatosBasicos', 'DatosBasicos.AspPostgrado_id', '=', 'AspPostgrado.id') 
       ->where('DatosBasicos.Especialidad_id', '=', $request->input('Especialidad_id'))
       ->where('DatosBasicos.Institutos_id','=',$request->input('Institutos_id'))
   //   ->where('DatosBasicos.ModoIngreso_Id','=',$request->input('ModoIngreso_Id'))
       ->where('DatosBasicos.Programas_id','=',$request->input('Programas_id'))
       ->select(DB::raw('count(*) as total'))
       ->get();

   //dd($datos);

      $desactiva =DB::table('ofertas')->where('ofertas.Aprobacion', '=', $aprob)
      ->where('ofertas.Periodo_id', '=', $idperiodo)
      ->leftJoin('ModoIngreso', 'ofertas.ModoIngreso_Id', '=', 'ModoIngreso.id')
      ->leftJoin('Especialidad', 'ofertas.Especialidad_Id', '=', 'Especialidad.id')
      ->leftJoin('Institutos', 'ofertas.Institutos_id', '=', 'Institutos.id')
       ->leftJoin('Programas', 'ofertas.Programas_id', '=', 'Programas.id')
      ->where('ofertas.Institutos_id','=',$request->input('Institutos_id'))
    //  ->where('ofertas.ModoIngreso_Id','=',$request->input('ModoIngreso_Id'))
      ->where('ofertas.Programas_id','=',$request->input('Programas_id'))
      ->where('ofertas.Especialidad_id','=',$request->input('Especialidad_id'))
      ->select('ModoIngreso.ModoIngreso','Institutos.NombInstituto','Especialidad.NombEspecialidad','ofertas.VigenteAct','ofertas.id','ofertas.Cuposupel','ofertas.Especialidad_Id','Programas.NombProgramas')
        ->get();
        
        } 
         
      // dd($desactiva);
      return view('especialidad.desactivarEspecialidad',compact('desactiva','sedeofertas','datos'));
    }



    public function inavilitar(Request  $request)
    {

      
      //dd($request->console_event, $request->aspirante);

      $dataid=$request->aspirante;
      
      $validar=$request->console_event;
     
       // dd($validar);
        if ($validar == true) {
         // dd($validar);
          //ACTUALIZO EN LA TABLA ORIGINAL
        $actual =Oferta::find($dataid);
       //dd($actual);
        $actual->VigenteAct= 'Inactivo';
        $actual->update();

        Alert::success('Especialidad desactivada con éxito')->autoclose(3500);

        return redirect()->route('deactivate');
        }else {

          $actual =Oferta::find($dataid);
         // dd($actual);
          $actual->VigenteAct= 'Activo';
          $actual->update();

          Alert::success('Especialidad activada con éxito')->autoclose(3500);

        return redirect()->route('deactivate');
        }
      
       
      
    }
    
    
        public function Cambioprograma(Request  $request)
    {
      $valor="1";
      $acto='Apto';
      $admitido='Admitido';
      $proceso='En_Proceso';
      $sedeofertas=DB::table('ofertas')
      ->where('ofertas.Aprobacion', '=', $valor)
      ->leftJoin('Institutos', 'ofertas.Institutos_id', '=', 'Institutos.id')
      ->select('Institutos.NombInstituto','Institutos.id')
      ->distinct('Institutos.id')
      ->orderBy('Institutos.id', 'ASC')->get();
      
      
      $cedulauser= $request->input('Cedula');
//dd($cedulauser);
    $per=DB::table('Periodo')
	->where('Periodo.Vigente', '=', $valor) 
	 ->select('Periodo.id')
	->first();
//dd($per);
if ($per == null) {
  Alert::error('Periodo inactivo')->autoclose(3500);
  return redirect()->route('home');
}
$idperiodo=$per->id;
      
       if ($cedulauser == true){
        $datosCambioaspi=DB::table('AspPostgrado')
        ->where('AspPostgrado.Cedula', '=', $cedulauser)
      ->where('UsuariosAspi.datos_personales', '=', $valor)
      ->where('UsuariosAspi.datos_basicos', '=', $valor)
      ->where('UsuariosAspi.datos_academico', '=', $valor)
      ->where('UsuariosAspi.datos_socioEconomico', '=', $valor)
      ->leftJoin('UsuariosAspi', 'AspPostgrado.user_id', '=', 'UsuariosAspi.id')
      ->leftJoin('DatosBasicos', 'DatosBasicos.AspPostgrado_id', '=', 'AspPostgrado.id') 
      ->where('DatosBasicos.Periodo_id', '=', $idperiodo)
      ->doesntExist();
//dd($datosCambioaspi);

if ($datosCambioaspi) {
            
    Alert::error('Aspirante no existe')->autoclose(3500);
    return Redirect::back();
}

 
}
      
      $datosCambiosss=Datosaspirante::where('AspPostgrado.Cedula', '=', $cedulauser)
      ->where('UsuariosAspi.datos_personales', '=', $valor)
      ->where('UsuariosAspi.datos_basicos', '=', $valor)
      ->where('UsuariosAspi.datos_academico', '=', $valor)
      ->where('UsuariosAspi.datos_socioEconomico', '=', $valor)
      ->leftJoin('UsuariosAspi', 'AspPostgrado.user_id', '=', 'UsuariosAspi.id')
      ->leftJoin('DatosBasicos', 'DatosBasicos.AspPostgrado_id', '=', 'AspPostgrado.id') 
      ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_Id', '=', 'ModoIngreso.id')
       ->leftJoin('Programas', 'DatosBasicos.Programas_id', '=', 'Programas.id')
      ->leftJoin('Especialidad', 'DatosBasicos.Especialidad_Id', '=', 'Especialidad.id')
      ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
      ->where('DatosBasicos.Periodo_id', '=', $idperiodo)
      ->select('AspPostgrado.Cedula','AspPostgrado.PrimerNombre','AspPostgrado.SegundoNombre','AspPostgrado.PrimerApellido','AspPostgrado.SegundoApellido','DatosBasicos.id',
      'DatosBasicos.Institutos_id','DatosBasicos.Especialidad_Id','Programas.NombProgramas', 'DatosBasicos.ModoIngreso_Id','ModoIngreso.ModoIngreso','Institutos.NombInstituto','Especialidad.NombEspecialidad')
      ->first();
      
   
//dd($datosCambiosss);
     

     // $pry=$datosCambio->Cedula;
    //dd($datosCambio);
  
    /* $aspiranteadmitido=Datosaspirante::where('UsuariosAspi.datos_personales', '=', $valor)
      ->where('UsuariosAspi.datos_basicos', '=', $valor)
      ->where('UsuariosAspi.datos_academico', '=', $valor)
      ->where('UsuariosAspi.datos_socioEconomico', '=', $valor)
      ->where('UsuariosAspi.datos_vocacional', '=', $valor)
      ->leftJoin('UsuariosAspi', 'AspPostgrado.user_id', '=', 'UsuariosAspi.id')
      ->leftJoin('DatosBasicos', 'DatosBasicos.AspPostgrado_id', '=', 'AspPostgrado.id') 
      ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_Id', '=', 'ModoIngreso.id')
      ->leftJoin('Especialidad', 'DatosBasicos.Especialidad_Id', '=', 'Especialidad.id')
      ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
      ->leftJoin('Especialidad as a', 'DatosBasicos.Especialidad_a_cursar2_id', '=', 'a.id')
      ->leftJoin('Especialidad as b', 'DatosBasicos.Especialidad_a_cursar3_id', '=', 'b.id')
      ->leftJoin('resultadosPrueba', 'resultadosPrueba.AspPostgrado_id', '=', 'AspPostgrado.id')
      ->where('resultadosPrueba.estatus', '=',  $acto)
      ->where('resultadosPrueba.condicion', '=',  $admitido)
      ->where('AspPostgrado.Cedula', '=', $cedulauser)
    
      ->select('AspPostgrado.Cedula','resultadosPrueba.estatus','resultadosPrueba.condicion','AspPostgrado.PrimerNombre','AspPostgrado.SegundoNombre','AspPostgrado.PrimerApellido','AspPostgrado.SegundoApellido','DatosBasicos.id',
      'DatosBasicos.Institutos_id','DatosBasicos.Especialidad_Id','a.NombEspecialidad as curso2','b.NombEspecialidad as curso3', 'DatosBasicos.ModoIngreso_Id','ModoIngreso.ModoIngreso','Institutos.NombInstituto','Especialidad.NombEspecialidad')
      ->exists();*/
     
      /*if ($cedulauser == true) {
        Alert::error('El aspirante fue admitido')->autoclose(3500);
       
       return redirect()->route('CambioEspecialidad.index');
      }*/
//dd($datosCambio);
      return view('especialidad.CambioEspeInstitutos',compact('cedulauser','aspiranteadmitido','datosCambiosss','sedeofertas'));
    
      
    }
    
    
        public function CambioProgramaEUpdateee(Request  $request)
    {

      
     // dd($request->aspirante, $request->Institutos_id,$request->Especialidad_id);

      $idatobasico=$request->aspirante;
      $insitutoos= $request->Institutos_id;
      $modoingre=$request->ModoIngreso_Id;
      $espec=$request->Especialidad_id;
      $programa=$request->Programas_id;
      
        // dd($validar);
         //ACTUALIZO EN LA TABLA ORIGINAL
       $actual =DatosBasicos::find($idatobasico);
      //dd($actual);
       $actual->Institutos_id= $insitutoos;
       $actual->ModoIngreso_Id= $modoingre;
       $actual->Especialidad_Id= $espec;
       $actual->Programas_id= $programa;
       //dd($actual);
       $actual->update();

       Alert::success('Cambios actualizados')->autoclose(3500);


       return redirect()->route('Cambioprograma.index');
      
    }



}
