<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\ExpeLaboralmodel;
use App\Http\Requests\ExperienciaFormRequest;
use DB; 
use Alert;
class ExpeLaboralController extends Controller
{

      public function __construct(){

        $this->middleware('auth:UsuariosAspi');
    }

   // 
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
       //  $datoacademico = $this->obtenerDatosAcademico();

        $id_user=\Auth::user()->id;
        //dd($id_user);

          $Esperiencia=DB::table('ExperienciaLaboral')->where('ExperienciaLaboral.user_id', '=', $id_user)
        
        ->select('ExperienciaLaboral.NombreInstitucion','ExperienciaLaboral.Direccion','ExperienciaLaboral.AñoServicio','ExperienciaLaboral.tipoOrganizacion','ExperienciaLaboral.id')->get($id_user);

        /*$Esperiencia=DB::select('select * FROM ExperienciaLaboral where user_id ='.$id_user);*/
       // dd($Esperiencia);
        //ExpeLaboralmodel::orderBy('id', 'DESD')->paginate();

        //$Esperiencia= \Auth::user()->ExperienciaLaboral()-> withoutGroup()->get();
        return view('Aspidatos.indexExper',compact('Esperiencia'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    
        
        return view('Aspidatos.createExpe');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
          $rules = [
            'NombreInstitucion' => 'required|regex:/^[\pL\s\-]+$/u',
            'Direccion'  =>'required|regex:/^[\pL\s\-]+$/u',
            'AñoServicio' =>'required',
            'tipoOrganizacion' =>'required',
           
        ];


        $messages = [
            'NombreInstitucion.required' => 'Este campo es requerido',
           'Direccion.required' => 'Este campo es requerido',
           'AñoServicio.required' => 'Debe seleccionar este campo',
           'tipoOrganizacion.required' => 'Debe seleccionar este campo',
       ];


        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->action('ExpeLaboralController@index')
                ->withErrors($validator)
                ->withInput();
        }       



        $id_user=\Auth::user()->id;
        $Dato =DB::select('SELECT AspPostgrado.id FROM AspPostgrado , UsuariosAspi where   UsuariosAspi.id=user_id and    UsuariosAspi.id ='.$id_user);
        $activo="1"; 
       $per= DB::table('Periodo')
       ->where('Periodo.Vigente', '=',$activo)->first();
      $idperiodo=$per->id;  
      

        $Esperiencia= new ExpeLaboralmodel(request()->all());
        $Esperiencia->user_id= \Auth::user()->id; 
        $Esperiencia->AspPostgrado_id = $Dato[0]->id;
        $Esperiencia->Periodo_id= $idperiodo;
        
        $Esperiencia->save();

         \Auth::user()->update([
        'datos_Experiencia' => 1,
       ]);
        alert()->success(' ', 'Sus datos fueron guardados correctamente')->autoclose(2500);
        return redirect()->route('Experiencia.index');
               
   

    }

    public function CreateExp(Request $request)
    {
        
        $rules = [
            'NombreInstitucion' => 'required|regex:/^[\pL\s\-]+$/u',
            'Direccion'  =>'required|regex:/^[\pL\s\-]+$/u',
            'AñoServicio' =>'required',
            'tipoOrganizacion' =>'required',
           
        ];


        $messages = [
            'NombreInstitucion.required' => 'Este campo es requerido',
           'Direccion.required' => 'Este campo es requerido',
           'AñoServicio.required' => 'Debe seleccionar este campo',
           'tipoOrganizacion.required' => 'Debe seleccionar este campo',
       ];


        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->action('ExpeLaboralController@create')
                ->withErrors($validator)
                ->withInput();
        }       



        $id_user=\Auth::user()->id;
        $Dato =DB::select('SELECT AspPostgrado.id FROM AspPostgrado , UsuariosAspi where   UsuariosAspi.id=user_id and    UsuariosAspi.id ='.$id_user);
        $activo="1"; 
       $per= DB::table('Periodo')
       ->where('Periodo.Vigente', '=',$activo)->first();
      $idperiodo=$per->id;  
      

        $Esperiencia= new ExpeLaboralmodel(request()->all());
        $Esperiencia->user_id= \Auth::user()->id; 
        $Esperiencia->AspPostgrado_id = $Dato[0]->id;
        $Esperiencia->Periodo_id= $idperiodo;
        
        $Esperiencia->save();

         \Auth::user()->update([
        'datos_Experiencia' => 1,
       ]);
        alert()->success(' ', 'Sus datos fueron guardados correctamente')->autoclose(2500);
        return redirect()->route('Experiencia.index');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {


    $Esperiencia=ExpeLaboralmodel::find($id);

    return view('Aspidatos.editExperiencia', compact('Esperiencia'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $rules = [
            'NombreInstitucion' => 'required|regex:/^[\pL\s\-]+$/u',
            'Direccion'  =>'required|filled',
            'AñoServicio' =>'required',
            'tipoOrganizacion' =>'required|filled',
           
        ];


         $messages = [
            'NombreInstitucion.required' => 'Este campo solo debe contener letras y es requerido.',
            'Direccion.required' => 'La dirección es requerido.',
            'AñoServicio.required' => 'Este campo es requerido.',
            'tipoOrganizacion.required' => 'Este campo es requerido.',
       
        ];


        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->action('ExpeLaboralController@edit',$id)
                ->withErrors($validator)
                ->withInput();
        }   


       $Esperiencia= ExpeLaboralmodel::findOrFail($id);
       $Esperiencia->NombreInstitucion = $request->get('NombreInstitucion');
       $Esperiencia->Direccion = $request->get('Direccion');
       $Esperiencia->AñoServicio = $request->get('AñoServicio');
       $Esperiencia->tipoOrganizacion = $request->get('tipoOrganizacion');
       $Esperiencia->update();

        alert()->success(' ', 'Sus datos fueron actualizados correctamente')->autoclose(3500);
        return redirect()->route('Experiencia.index');
                

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
