<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Caffeinated\Shinobi\Models\Role;
use App\Sede;
use App\Rols;
use App\InstitutoUser;
use App\sedeInstitutos;
use App\UsuariosAspi;
use Illuminate\Foundation\Auth\RegistersUsers;
use Alert;
use Carbon\Carbon;
use App\Datosaspirante;
use App\DatosBasicos;
class UserController extends Controller
{
    
   // private $x;
   public function __construct()

   {

    $this->middleware('permission:users.index')->only('index');
		
   $this->middleware('permission:users.create')->only(['create','store']);	

   $this->middleware('permission:users.edit')->only(['edit','update']);

   $this->middleware('permission:users.show')->only('show');

   $this->middleware('permission:users.destroy')->only('destroy');


   $this->middleware('permission:aspiante')->only('getaspirante');
   $this->middleware('permission:aspiranteAct')->only('getaspiranteAct');
	
   $this->middleware('permission:ReporteConsulta.Aspirante')->only('AspiConsulta');

   $this->middleware('permission:AspiUser.destroy')->only('eliminarAspirantes');


		 $this->middleware('permission:Aspirante.Pasado')->only(['PeridoPasado']);
	 $this->middleware('permission:Aspirante.Pasadolist')->only('AspiPasadoList','PeridoPasadoStore');

   }

     public function getsede($id)
        {
           return Sede::where('sede_id',$id)->get();//pluck("NombSede","id");
             //json_encode($sedes);
        }

         public function getnucleos(Request $request)
        {
          $nucleo = InstitutoUser::where('sede_id',$request->valor)->get();
          
            return response()->json($nucleo);



           /* $especialidades =DB::table('sede_especialidads')->where('sede_especialidads.sede_id','=',$id)
            ->leftJoin('Especialidad', 'Especialidad.Id', '=', 'sede_especialidads.Especialidad_Id')
            ->pluck("Especialidad.NombEspecialidad","Especialidad.Id");
            return json_encode($especialidades);*/
        }


   public function index(Request $request)
    { 
               
      $id_user=\Auth::user()->id;

  $iduser_sede=\Auth::user()->sede_id;
///dd($iduser_sede);

  $name  = $request->get('name');



if(\Auth::user()->role_id == '2' ){


      $users = User::withCount(['institutos'])->orderby('id','ASC')
                    ->with(['rols'])
                    ->with(['sede'])
                    ->where('id', '>=', 4)
                    ->name($name)
                    ->paginate(10);
 
  // dd($users);
    $role =DB::table('role_user')//->where('role_user.users_id','=',$id_user)
     ->leftJoin('roles', 'role_user.role_id', '=', 'roles.id')
      ->select('roles.name')->get();
  
        return view('users.index',compact('users','nucleo','role','Datosboton'));
        

}

if(\Auth::user()->role_id == '4' ){


      $users = User::withCount(['institutos'])->orderby('id','ASC')
                    ->with(['rols'])
                    ->with(['sede'])
                    ->where('sede_id', '=', $iduser_sede)
                    ->name($name)
                    ->paginate(10);
 
  // dd($users);
    $role =DB::table('role_user')//->where('role_user.users_id','=',$id_user)
     ->leftJoin('roles', 'role_user.role_id', '=', 'roles.id')
      ->select('roles.name')->get();
  
        return view('users.index',compact('users','nucleo','role','Datosboton'));
        

}


      $users = User::withCount(['institutos'])->orderby('id','ASC')
                    ->with(['rols'])
                    ->with(['sede'])
                    //->where('id', '>=', 3)
                    ->name($name)
                    ->paginate(10);
 
    // dd($users);
    $role =DB::table('role_user')//->where('role_user.users_id','=',$id_user)
     ->leftJoin('roles', 'role_user.role_id', '=', 'roles.id')
      ->select('roles.name')->get();
  
        return view('users.index',compact('users','nucleo','role','Datosboton'));
        
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    
         $idusuario = Auth::user()->id;
        if($idusuario = 1){ 
       // $sedes= DB::table('sede')->get();
        $institutos = DB::table('Institutos')->get();
        $roli= DB::table('roles')->where('id', '>=', 3)->orderBy('name','ASC')->pluck('name','id');
        $rols= DB::table('roles')->orderBy('name','ASC')->pluck('name','id');
       // dd($roli);
        $sed = Sede::orderBy('NombSede','ASC')->pluck('NombSede','id_sede');
      
      //  $tipos= DB::table('tipo_admision')->get();
    return view('users.create',compact('sedes','roli','rols','institutos','sed')); 
        } 
        else
        {
            return view ('vendor.errors.404');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      $rules = [
            'sede_id' => 'required',
            'name' => 'required|max:20|regex:/^[\pL\s\-]+$/u',
         //  'nucleos' => 'required',
           // 'rols_id' => 'required',
            'Apellidos' => 'required|max:20|regex:/^[\pL\s\-]+$/u',
            'cedula' =>  'required|numeric|unique:users|digits_between:7,8',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6|confirmed',
            
        ];

        $messages = [
            'sede_id.required' => 'Este campo es Obligatorio.',
            'name.required' => 'Este campo es Obligatorio.',
           // 'nucleos.required' => 'Este campo es Obligatorio.',
            //'rols_id.required' => 'Este campo es Obligatorio.',
            'Apellidos.required' => 'Este campo es Obligatorio.',
            'cedula.required' => 'Este campo es Obligatorio.',
            'email.required' => 'Este campo es Obligatorio.',
            'email.required' => 'Este campo es Obligatorio.',
            'password.required' => 'Este campo es Obligatorio.',
           
            


        ];


        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->action('UserController@create')
                ->withErrors($validator)->withInput();
        }

     $data=array(
$request->input('sede_id') => $request->input('roles'),
);
       foreach ($data as $key => $value) {
       
          foreach ($value as $rol){
        $user = new  User(request()->all());
 	$user->password =bcrypt($request->password);
 	 $user->role_id = $rol;
        $user->save($request->all());
        $user->roles()->sync($request->get('roles'));
       }
      };


       Alert::success( 'Usuario creado con éxito')->autoclose(3500);
        return redirect()->route('users.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) 
    {  

       
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
   
        $user = User::with('roles')->findOrFail($id);
      
        
        $roles = Role::query()
                    ->orderBy('name')
                    ->get();

      $rol = Role::query()
                    ->where('id', '>=', 3)
                    ->orderBy('name')
                    ->get();            

       $users = User::withCount(['institutos'])->orderby('id','ASC')
                    ->with(['rols'])
                    ->with(['sede'])
                    ->where('id', '=', $id)
                    
                    ->first();

        $sed = DB::table('sede')->orderby('NombSede','ASC')->pluck('NombSede','id_sede');
      
      //  $tipos= DB::table('tipo_admision')->get();
    return view('users.edit',compact('usuarios','roles','user','sed','users','rol')); 
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

       $users = User::withCount(['institutos'])->orderby('id','ASC')
                    ->with(['rols'])
                    ->with(['sede'])
                    ->where('id', '=', $id)
                    
                    ->first();
        
   if ($users->institutos_count > 0)   {
      $rules = [
            
            'name' => 'required|max:20|regex:/^[\pL\s\-]+$/u',
         //  'nucleos' => 'required',
          //  'rols_id' => 'required',
            'Apellidos' => 'required|max:20|regex:/^[\pL\s\-]+$/u',
             'cedula' => 'required|numeric|digits_between:7,8',
            //'cedula' =>  'required|unique:users,cedula,id,' . $request->get($id),
            'email' => 'nullable|string|email|max:255',
          'password' => 'nullable|string|min:6|confirmed',
            
        ];


        $messages = [
          
            'name.required' => 'Este campo es requerido.',
           // 'nucleos.required' => 'Este campo es Obligatorio.',
           // 'rols_id.required' => 'Este campo es Obligatorio.',
            'Apellidos.required' => 'Este campo es requerido.',
            'cedula.required' => 'Este campo es requerido.',
            'email.required' => 'Este campo es requerido.',
            'email.required' => 'Este campo es requerido.',
            'password.required' => 'Este campo es Obligatorio.',
          
       ];
 $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->action('UserController@edit',$id)
                ->withErrors($validator)->withInput();
        }

        

}
  
     else{ 

       $rules = [
            'sede_id' => 'nullable|required',
            'name' => 'required|max:20|regex:/^[\pL\s\-]+$/u',
         //  'nucleos' => 'required',
          //  'rols_id' => 'required',
            'Apellidos' => 'required|max:20|regex:/^[\pL\s\-]+$/u',
             'cedula' => 'required|numeric|digits_between:7,8',
            //'cedula' =>  'required|unique:users,cedula,id,' . $request->get($id),
            'email' => 'nullable|string|email|max:255',
          'password' => 'nullable|string|min:6|confirmed',
            
        ];

            $messages = [
          
           'sede_id.required' => 'Este campo es Obligatorio.',
            'name.required' => 'Este campo es requerido.',
           // 'nucleos.required' => 'Este campo es Obligatorio.',
           // 'rols_id.required' => 'Este campo es Obligatorio.',
            'Apellidos.required' => 'Este campo es requerido.',
            'cedula.required' => 'Este campo es requerido.',
            'email.required' => 'Este campo es requerido.',
            'email.required' => 'Este campo es requerido.',
            'password.required' => 'Este campo es Obligatorio.',
          
        ];
 $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->action('UserController@edit',$id)
                ->withErrors($validator)->withInput();
        }

       
           
            }


        $user =User::find($id);
    
      
      $user->role_id =  $request->get('role'); 
//dd($user);
   $user->syncRoles([$request->role]);
     // dd($user);
     // $user->roles()->sync($request->get('roles'));

       $user->password = bcrypt($request->password); 
       //$user->password=$request->bcrypt('password'); 
  
//dd($user);
        //$user->password = $password;

        
       $user->update();


       Alert::success( 'Usuario actualizados con éxito')->autoclose(3500);
        return redirect()->route('users.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
      $user  = User::find($id);
           
      $user->delete(); 
  
   Alert::success('Usuario Eliminado con éxito')->autoclose(3500);

   return redirect()->route('users.index');
    }


    public function asignar()
    {
         $user=DB::table('users')
        ->leftJoin('sede', 'users.sede_id', '=', 'sede.id_sede')
       // ->leftJoin('tipo_admision', 'users.Id_Tipo', '=', 'tipo_admision.id_tipo')
       
        ->select('sede.NombSede','rols.descripcion','users.name', 'users.Apellidos','users.cedula','users.email','users.id','users.sede_id','users.rols_id')
        ->first();
         //$sed=$user->sede_id;
        $sed = Sede::orderBy('NombSede','ASC')->pluck('NombSede','id_sede');

        return view('users.AsignarNucleos',compact('sedes','user','institutos','sed')); 
    }


      public function guardar(Request $request)
    {
          $data = array(
            $request->input('sede_id') => $request->input('nucleos')

          
        ); 

        foreach ($data as $key => $value) {
               
                                     
            foreach ($value as $instituto){
       
            $datosSocio =sedeInstitutos::find($id);
            $datosSocio->sede_id = $key;
             $datosSocio->users_id= $user->id;
            $datosSocio->Institutos_id = $instituto;
            $datosSocio->save();
        }
       };


       Alert::success( 'Usuario actualizados con éxito')->autoclose(3500);
        return redirect()->route('Usuarios.index');
    }



		public function getaspirante(Request  $request)
	{
	
	$valor="1";
	 $cedula = $request->input('Cedula'); 
	 
	// dd($cedula);
	if($cedula == true){
	 $siexiste=UsuariosAspi::  where('UsuariosAspi.cedula', '=', $cedula)
	 ->where('UsuariosAspi.datos_personales', '<=', $valor)
 //  ->where('UsuariosAspi.datos_basicos', '<=', $valor)
 //->where('UsuariosAspi.datos_academico', '<=', $valor)
//->where('UsuariosAspi.datos_Experiencia', '<=', $valor)
 //->where('UsuariosAspi.datos_socioEconomico', '<=', $valor)
 //->where('UsuariosAspi.datos_vocacional', '<=', $valor)
 //->where('DatosBasicos.Periodo_id', '=', $idperiodo)
    ->leftJoin('AspPostgrado', 'AspPostgrado.user_id', '=', 'UsuariosAspi.id')
    ->leftJoin('DatosBasicos', 'DatosBasicos.AspPostgrado_id', '=', 'AspPostgrado.id') 
    ->leftJoin('Deposito', 'Deposito.AspPostgrado_id', '=', 'AspPostgrado.id')
    ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_Id', '=', 'ModoIngreso.Id')
    ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
  //  ->leftJoin('resultadosPrueba', 'resultadosPrueba.AspPostgrado_id', '=', 'AspPostgrado.id')
    ->leftJoin('Periodo', 'DatosBasicos.Periodo_id', '=', 'Periodo.id')
//    ->leftJoin('Especialidad as a', 'DatosBasicos.Especialidad_a_cursar2_id', '=', 'a.id')
   // ->leftJoin('Especialidad as b', 'DatosBasicos.Especialidad_a_cursar3_id', '=', 'b.id')
   
    ->select('UsuariosAspi.id','AspPostgrado.Cedula','AspPostgrado.PrimerNombre','AspPostgrado.SegundoNombre',
    'AspPostgrado.PrimerApellido','AspPostgrado.SegundoApellido',
    'AspPostgrado.FechaNacimiento','AspPostgrado.EstadoCivil','AspPostgrado.Genero','AspPostgrado.Direccion','AspPostgrado.TelefonoMovil',
    'AspPostgrado.TelefonoLocal','AspPostgrado.TelefonOficina',
    'UsuariosAspi.email','Deposito.NumDeposito','UsuariosAspi.cedula','UsuariosAspi.password','UsuariosAspi.name',
'DatosBasicos.Institutos_id','Institutos.NombInstituto','DatosBasicos.ModoIngreso_Id','ModoIngreso.ModoIngreso'/*,'a.NombEspecialidad as curso2','b.NombEspecialidad as curso3'*/) 

->doesntExist();
//dd($siexiste);
	if ($siexiste == true ){
	
		 Alert::error('Aspirante no se encuentra registrado')->autoclose(2500);
                return  redirect()->route('aspiante');

	}
	} 
	$datos=UsuariosAspi::  where('UsuariosAspi.cedula', '=', $cedula)
	 ->where('UsuariosAspi.datos_personales', '<=', $valor)
 //  ->where('UsuariosAspi.datos_basicos', '<=', $valor)
 //->where('UsuariosAspi.datos_academico', '<=', $valor)
//->where('UsuariosAspi.datos_Experiencia', '<=', $valor)
 //->where('UsuariosAspi.datos_socioEconomico', '<=', $valor)
 //->where('UsuariosAspi.datos_vocacional', '<=', $valor)
 //->where('DatosBasicos.Periodo_id', '=', $idperiodo)
    ->leftJoin('AspPostgrado', 'AspPostgrado.user_id', '=', 'UsuariosAspi.id')
    ->leftJoin('DatosBasicos', 'DatosBasicos.AspPostgrado_id', '=', 'AspPostgrado.id') 
    ->leftJoin('Deposito', 'Deposito.AspPostgrado_id', '=', 'AspPostgrado.id')
    ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_Id', '=', 'ModoIngreso.Id')
    ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
   // ->leftJoin('resultadosPrueba', 'resultadosPrueba.AspPostgrado_id', '=', 'AspPostgrado.id')
    ->leftJoin('Periodo', 'DatosBasicos.Periodo_id', '=', 'Periodo.id')
//    ->leftJoin('Especialidad as a', 'DatosBasicos.Especialidad_a_cursar2_id', '=', 'a.id')
   // ->leftJoin('Especialidad as b', 'DatosBasicos.Especialidad_a_cursar3_id', '=', 'b.id')
    ->select('UsuariosAspi.id','AspPostgrado.Cedula','AspPostgrado.PrimerNombre','AspPostgrado.SegundoNombre',
    'AspPostgrado.PrimerApellido','AspPostgrado.SegundoApellido',
    'AspPostgrado.FechaNacimiento','AspPostgrado.EstadoCivil','AspPostgrado.Genero','AspPostgrado.Direccion','AspPostgrado.TelefonoMovil',
    'AspPostgrado.TelefonoLocal','AspPostgrado.TelefonOficina','UsuariosAspi.confirmed',
    'UsuariosAspi.email','Deposito.NumDeposito','UsuariosAspi.cedula','UsuariosAspi.password','UsuariosAspi.name',
'DatosBasicos.Institutos_id','Institutos.NombInstituto','DatosBasicos.ModoIngreso_Id','ModoIngreso.ModoIngreso'/*,'a.NombEspecialidad as curso2','b.NombEspecialidad as curso3'*/) 

->first();
	
	//dd($datos);
	
	 return view('users.actualizacionaspirate',compact('datos'));
	 
	 
	
		
	}
	
	
	  public function getaspiranteAct(Request  $request)
    {
	$idatos=$request->aspirante;
	
//dd($idatos);
	 $valor='1';
	$correo=$request->get('email'); 
	$pasw=$request->get('password'); 
	$confirm=$request->get('confirmacion');
	//dd($confirm);
	/*if($correo == null){
	Alert::error( 'Debe seleccionar ambos campos')->autoclose(3500);
        return redirect()->route('aspiante')->withInput();
	}*/
      
	
        $aspiuser =UsuariosAspi::find($idatos);
   // dd($aspiuser);
	if($correo == true){
	$aspiuser->email= $correo;
	}
        
       $aspiuser->confirmed = $confirm;
       $aspiuser->password =bcrypt($pasw);
//dd($aspiuser);
       $aspiuser->update();


       Alert::success( 'Usuario actualizados con éxito')->autoclose(3500);
        return redirect()->route('aspiante');
    }	




	public function PeridoPasado(Request $request)
    {

       $Aprobacion='1';
 $per= DB::table('Periodo')
	->select('Periodo.id','Periodo.Lapso','Periodo.created_at')
        ->where('Periodo.Vigente', '=',$Aprobacion)->first();
//dd($perAnterior);
       $idperiodo=$per->id; 
	$fechaInicio=$per->created_at;
	
	$perAnterior= DB::table('Periodo')
        ->where('Periodo.id', '<=',$idperiodo)->first();

       $perviejo=$perAnterior->id;


	//$endDate = $fechaInicio->subYears(1);
//dd($fechaInicio,$endDate);
        /*$especialidad=DB::table('ofertas')
        ->where('ofertas.Especialidad_id',$request->input('Institutos_id'))
        ->leftJoin('Especialidad', 'ofertas.Especialidad_id', '=', 'Especialidad.id')
        //->leftJoin('Especialidad as a', 'DatosBasicos.Especialidad_a_cursar2_id', '=', 'a.id')
        //->leftJoin('Especialidad as b', 'DatosBasicos.Especialidad_a_cursar3_id', '=', 'b.id')
         ->select('Especialidad.NombEspecialidad')
        ->orderBy('NombEspecialidad', 'DESC')->pluck('NombEspecialidad','Especialidad_id');*/
        if (\Auth::user()->role_id == '1'){
        $sedeofertas=DB::table('ofertas')
        ->where('ofertas.Aprobacion', '=', $Aprobacion)
	->where('ofertas.Periodo_id','=',   $perviejo)
        ->leftJoin('Institutos', 'ofertas.Institutos_id', '=', 'Institutos.id')
        ->orderBy('Institutos.id', 'ASC')->pluck('NombInstituto','Institutos.id');
 	
	$lapso=DB::table('Periodo')
	->where('Periodo.id', '<=', $idperiodo) 
	 //->select('Periodo.id','Periodo.Lapso')
	 ->orderBy('Periodo.id', 'DESC')->pluck('Lapso','Periodo.id');
    }
    else{
        $sedeofertas=DB::table('ofertas')->where('sede_id', '=', \Auth::user()->sede_id)
        ->where('ofertas.Aprobacion', '=', $Aprobacion)
	->where('ofertas.Periodo_id','=',   $perviejo)
        ->leftJoin('Institutos', 'ofertas.Institutos_id', '=', 'Institutos.id')
        ->orderBy('Institutos.id', 'ASC')->pluck('NombInstituto','Institutos.id');

               $lapso=DB::table('Periodo')
	->where('Periodo.id', '=', $perviejo) 
	 //->select('Periodo.id','Periodo.Lapso')
	 ->orderBy('Periodo.id', 'DESC')->pluck('Lapso','Periodo.id');
            }

        return view('users.aspirantespasado', compact('admitidos','sedeofertas','lapso'));
    }






	 public function AspiPasadoList(Request $request)
    {

       
       // dd($NombEspecialidad);
       $idcondicion="En_Proceso";
       $idstatus="Apto";
	
	$idinstituto= $request->Institutos_id;        
        $idmodoingre= $request->ModoIngreso_Id;
        $idEspecial= $request->Especialidad_id;

      $Aprobacion='1';
 $per= DB::table('Periodo')
	->select('Periodo.id','Periodo.Lapso','Periodo.created_at')
        ->where('Periodo.Vigente', '=',$Aprobacion)->first();
       $idperiodo=$per->id; 


	 DB::statement(DB::raw('SET @rownum = 0')); 

       $admitidos=Datosaspirante::
     //  where('resultadosPrueba.condicion', '=', $idcondicion)
       //where('resultadosPrueba.estatus', '=', $idstatus)
	where('DatosBasicos.Periodo_id', '=', $request->input('Periodo_id'))
 	->where('DatosBasicos.Especialidad_a_cursar1_id', '=', $idEspecial)
            ->where('DatosBasicos.Institutos_id', '=', $idinstituto)
            //->where('DatosBasicos.ModoIngreso_Id', '=', $idmodoingre)
      // ->leftJoin('resultadosPrueba', 'resultadosPrueba.AspPostgrado_id', '=', 'AspPostgrado.id')
        ->leftJoin('DatosBasicos', 'DatosBasicos.AspPostgrado_id', '=', 'AspPostgrado.id') 
        ->leftJoin('Deposito', 'Deposito.AspPostgrado_id', '=', 'AspPostgrado.id')
        ->leftJoin('Especialidad', 'DatosBasicos.Especialidad_a_cursar1_id', '=', 'Especialidad.id')
        //->leftJoin('Especialidad as a', 'DatosBasicos.Especialidad_a_cursar2_id', '=', 'a.id')
        //->leftJoin('Especialidad as b', 'DatosBasicos.Especialidad_a_cursar3_id', '=', 'b.id')
        ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_Id', '=', 'ModoIngreso.Id')
        ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
         ->select('AspPostgrado.id as AspiID','AspPostgrado.Cedula','AspPostgrado.PrimerNombre','AspPostgrado.SegundoNombre',
        'AspPostgrado.PrimerApellido','AspPostgrado.SegundoApellido',
        'AspPostgrado.FechaNacimiento','AspPostgrado.Edad','AspPostgrado.Peso','AspPostgrado.Estatura',
        'AspPostgrado.Nacionalidad','AspPostgrado.NumPasaporte','AspPostgrado.EstadoCivil',
        'AspPostgrado.Genero','AspPostgrado.Direccion','AspPostgrado.TelefonoMovil',
        'AspPostgrado.TelefonoLocal','AspPostgrado.TelefonOficina','AspPostgrado.Estados_id',
        'AspPostgrado.Municipios_id','AspPostgrado.Parroquias_id','AspPostgrado.PaisOrigen_id',
        'AspPostgrado.Correo','AspPostgrado.user_id as UsuarioID','resultadosPrueba.condicion',
        'Especialidad.NombEspecialidad','Deposito.NumDeposito',
          'DatosBasicos.Institutos_id','Institutos.NombInstituto',
          'DatosBasicos.ModoIngreso_Id','ModoIngreso.ModoIngreso')

          //->NombInstituto($NombInstituto)
             //  ->NombEspecialidad($NombEspecialidad)
               
               ->get();
            // dd($admitidos);

	 $ladilla=DB::table('DatosBasicos')
            //->leftJoin('AspPostgrado', 'resultadosPrueba.AspPostgrado_id', '=', 'AspPostgrado.id')
            ->leftJoin('Especialidad', 'DatosBasicos.Especialidad_a_cursar1_id', '=', 'Especialidad.id')
            ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
            ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_Id', '=', 'ModoIngreso.Id')
   	    ->leftJoin('Periodo', 'DatosBasicos.Periodo_id', '=', 'Periodo.id')
            ->select(DB::raw( '@rownum := @rownum + 1 as posicion '), 			'Especialidad.NombEspecialidad','Institutos.NombInstituto','Periodo.Lapso')
            ->where('DatosBasicos.Especialidad_a_cursar1_id', '=', $idEspecial)
            ->where('DatosBasicos.Institutos_id', '=', $idinstituto)
           /// ->where('DatosBasicos.ModoIngreso_Id', '=', $idmodoingre)
	->where('DatosBasicos.Periodo_id', '=', $request->input('Periodo_id'))	
           ->orderBy('posicion', 'ASC')
            //->orderByRaw(DB::raw("FIELD(posicion, ">=", ".$IndiceDA." ) DESC"))
           // ->LIMIT($cupoofertas) 
            //->orderBy('idparticipante', 'desc')
            ->first();
          // dd($ladilla);
            if ($ladilla === null) {
                Alert::error('Sin Aspirantes')->autoclose(3500);
                return  redirect()->route('Aspirante.Pasado');
            }

        return view('users.NoAptos', compact('admitidos','ladilla','per'));
    }



    public function PeridoPasadoStore(Request $request)
    {
        $var="Admitido";
	$valor='1';
        $data = $request->aspirante;
     // dd($data);
 	$per= DB::table('Periodo')
	->select('Periodo.id','Periodo.Lapso','Periodo.created_at')
        ->where('Periodo.Vigente', '=',$valor)->first();
       $idperiodo=$per->id;
        
$OBSERVACION='Aspirante apto del periodo anterior actualizado y en espera para ser admitido';

                
       foreach ($data as  $key => $idkey) {

//dd($idkey);
//ACTUALIZAR EN LA TABLA datosbasicos
                  $p = DatosBasicos::where('AspPostgrado_id', '=', [$idkey])->firstOrFail();
                  $p->Periodo_id =$idperiodo;
                  $p->update();
  
//ACTUALIZAR EN LA TABLA REPUESTAPRUEBA
		  $R = repuestaPrueba::where('AspPostgrado_id', '=', [$idkey])->firstOrFail();
                  $R->observacion = $OBSERVACION;
 		  $R->Periodo_id =$idperiodo;
                  $R->update();
              }

              
/* $p=DatosBasicos::where('AspPostgrado_id', '=', $data)->firstOrFail();
 //	 dd($p);
                 /// $p->condicion = $var;
                  $p->Periodo_id =$idperiodo;
                  $p->update();
  */
 
             
       Alert::success('Cambio con Exito')->autoclose(3500);
       return  redirect()->route('Aspirante.Pasado');
    }

////////////////////////////////////////////////////////new/////////////

    public function AspiConsulta(Request $request)
    {
     $fecha = Carbon::now();
      $fechas= $fecha->format('d/m/Y h:i:s A');
      $valor="1";
        $per= DB::table('Periodo')
        ->where('Periodo.Vigente', '=',$valor)->first();
       $idperiodo=$per->id; 
      $cedula=$request->input('Cedula');
     
     /* $aspiuser =UsuariosAspi::where('cedula', '=', $cedula)
      ->where('UsuariosAspi.datos_personales', '<', $valor)
   ->where('UsuariosAspi.datos_basicos', '<', $valor)
 ->where('UsuariosAspi.datos_academico', '<', $valor)
->where('UsuariosAspi.datos_Experiencia', '<', $valor)
 ->where('UsuariosAspi.datos_socioEconomico', '<', $valor)
 ->where('UsuariosAspi.datos_vocacional', '<', $valor)
      ->exists();*/
    
     

      

      $useraspi =Datosaspirante::where('Cedula','=',$cedula)->first();
     // dd($useraspi);
      if ($useraspi == null) {
         $aspiconsulta=UsuariosAspi::  where('UsuariosAspi.datos_personales', '<=', $valor)
   ->where('UsuariosAspi.datos_basicos', '<=', $valor)
 ->where('UsuariosAspi.datos_academico', '<=', $valor)
->where('UsuariosAspi.datos_Experiencia', '<=', $valor)
 ->where('UsuariosAspi.datos_socioEconomico', '<=', $valor)
 //->where('UsuariosAspi.datos_vocacional', '<=', $valor)
 //->where('DatosBasicos.Periodo_id', '<=', $idperiodo)
 ->where('UsuariosAspi.cedula', '=', $cedula)
    ->leftJoin('AspPostgrado', 'AspPostgrado.user_id', '=', 'UsuariosAspi.id')
    ->leftJoin('DatosBasicos', 'DatosBasicos.AspPostgrado_id', '=', 'AspPostgrado.id') 
    ->leftJoin('Deposito', 'Deposito.AspPostgrado_id', '=', 'AspPostgrado.id')
    ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_Id', '=', 'ModoIngreso.Id')
    ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
   // ->leftJoin('resultadosPrueba', 'resultadosPrueba.AspPostgrado_id', '=', 'AspPostgrado.id')
    ->leftJoin('Periodo', 'DatosBasicos.Periodo_id', '=', 'Periodo.id')
 ->leftJoin('Especialidad', 'DatosBasicos.Especialidad_Id', '=', 'Especialidad.id')
   // ->leftJoin('Especialidad as b', 'DatosBasicos.Especialidad_a_cursar3_id', '=', 'b.id')
    ->select('AspPostgrado.id as idaspi','AspPostgrado.Cedula','AspPostgrado.PrimerNombre','AspPostgrado.SegundoNombre',
    'AspPostgrado.PrimerApellido','AspPostgrado.SegundoApellido',
    'AspPostgrado.FechaNacimiento','AspPostgrado.EstadoCivil','AspPostgrado.Genero','AspPostgrado.Direccion','AspPostgrado.TelefonoMovil',
    'AspPostgrado.TelefonoLocal','AspPostgrado.TelefonOficina',    'AspPostgrado.Correo','Deposito.NumDeposito','UsuariosAspi.datos_personales','UsuariosAspi.datos_basicos','UsuariosAspi.datos_academico','UsuariosAspi.datos_Experiencia',
    'UsuariosAspi.datos_socioEconomico', /*'UsuariosAspi.datos_vocacional',*/'UsuariosAspi.id as UserID','UsuariosAspi.name','UsuariosAspi.cedula','UsuariosAspi.email',
'DatosBasicos.Institutos_id','DatosBasicos.Periodo_id','Periodo.Lapso','Institutos.NombInstituto','DatosBasicos.ModoIngreso_Id','ModoIngreso.ModoIngreso',
'DatosBasicos.Especialidad_Id','Especialidad.NombEspecialidad'/*,'b.NombEspecialidad as curso3','resultadosPrueba.condicion'*/)
 
    ->first();

    //dd($aspiconsulta);
    return view('reporteChart.aspirateconsulta', compact('aspiconsulta'));
      }

      $idaspirante = $useraspi->id;
        
        $userDatbasico =DatosBasicos::where('AspPostgrado_id','=',$idaspirante)
        ->where('Periodo_id','<=',$idperiodo)->exists();
  //dd($userDatbasico); 
      if ($userDatbasico == true) {
        $aspiconsulta=UsuariosAspi::  where('UsuariosAspi.datos_personales', '<=', $valor)
   ->where('UsuariosAspi.datos_basicos', '<=', $valor)
 ->where('UsuariosAspi.datos_academico', '<=', $valor)
->where('UsuariosAspi.datos_Experiencia', '<=', $valor)
 ->where('UsuariosAspi.datos_socioEconomico', '<=', $valor)
 //->where('UsuariosAspi.datos_vocacional', '<=', $valor)
 //->where('DatosBasicos.Periodo_id', '=', $idperiodo)
 ->where('UsuariosAspi.cedula', '=', $cedula)
    ->leftJoin('AspPostgrado', 'AspPostgrado.user_id', '=', 'UsuariosAspi.id')
    ->leftJoin('DatosBasicos', 'DatosBasicos.AspPostgrado_id', '=', 'AspPostgrado.id') 
    ->leftJoin('Deposito', 'Deposito.AspPostgrado_id', '=', 'AspPostgrado.id')
    ->leftJoin('ModoIngreso', 'DatosBasicos.ModoIngreso_Id', '=', 'ModoIngreso.Id')
    ->leftJoin('Institutos', 'DatosBasicos.Institutos_id', '=', 'Institutos.id')
   // ->leftJoin('resultadosPrueba', 'resultadosPrueba.AspPostgrado_id', '=', 'AspPostgrado.id')
    ->leftJoin('Periodo', 'DatosBasicos.Periodo_id', '=', 'Periodo.id')
 ->leftJoin('Especialidad', 'DatosBasicos.Especialidad_Id', '=', 'Especialidad.id')
   // ->leftJoin('Especialidad as b', 'DatosBasicos.Especialidad_a_cursar3_id', '=', 'b.id')
    ->select('AspPostgrado.id as idaspi','AspPostgrado.Cedula','AspPostgrado.PrimerNombre','AspPostgrado.SegundoNombre',
    'AspPostgrado.PrimerApellido','AspPostgrado.SegundoApellido',
    'AspPostgrado.FechaNacimiento','AspPostgrado.EstadoCivil','AspPostgrado.Genero','AspPostgrado.Direccion','AspPostgrado.TelefonoMovil',
    'AspPostgrado.TelefonoLocal','AspPostgrado.TelefonOficina',    'AspPostgrado.Correo','Deposito.NumDeposito','UsuariosAspi.datos_personales','UsuariosAspi.datos_basicos','UsuariosAspi.datos_academico','UsuariosAspi.datos_Experiencia',
    'UsuariosAspi.datos_socioEconomico', /*'UsuariosAspi.datos_vocacional',*/'UsuariosAspi.id as UserID','UsuariosAspi.name','UsuariosAspi.cedula','UsuariosAspi.email',
'DatosBasicos.Institutos_id','DatosBasicos.Periodo_id','Periodo.Lapso','Institutos.NombInstituto','DatosBasicos.ModoIngreso_Id','ModoIngreso.ModoIngreso',
'DatosBasicos.Especialidad_Id','Especialidad.NombEspecialidad'/*,'b.NombEspecialidad as curso3','resultadosPrueba.condicion'*/)
 
    ->first();

  /* if ($aspiconsulta == 0) {
       
Alert::success('Usuario no existe')->autoclose(3500);
        return Redirect::back();
  

    }*/


     
         return view('reporteChart.aspirateconsulta', compact('aspiconsulta'));

      } 
      else{

    return view('reporteChart.aspirateconsulta');
      }
     

  
      
       
    }
    


	  public function eliminarAspirantes(Request  $request)
    {
	$idatos=$request->aspirante;

	//dd($idatos);



	$useraspi =UsuariosAspi::where('id','=',[$idatos])->first();
	//$userbasico =DatosBasicos::where('user_id','=',$idatos)->first();
	//$userAcademico =DatosAcademico::where('user_id','=',$idatos)->get();
	//$userLaboral =ExpeLaboralmodel::where('user_id','=',[$idatos])->get();
//	$userAcademico2 =Academico::where('user_id','=',[$idatos])->get();
	//$userEvaluacion =repuestadiagnostico::where('user_id','=',[$idatos])->get();

	//$userAspirante =Datosaspirante::where('user_id','=',[$idatos])->first();
	//$userresultado =repuestaPrueba::where('AspPostgrado_id','=',$userAspirante->id)->get();
	//$datosuser=$useraspi->datos_basicos;
//dd($userAcademico);
    if ($useraspi != null ) {
    	 // $userbasico->delete();
    	  // $userAcademico->delete();
    	 //  $userLaboral->delete();
    	  // $userAcademico2->delete();
    	   // $userEvaluacion->delete();
    	   // $userresultado->delete();
    	  //   $userAspirante->delete();
        $useraspi->delete();
	
/*&& $datosuser==false
	$Aspregrado =Datosaspirante::where('user_id','=',[$idatos])->first();	
	$Aspregrado->delete();*/
	
	
Alert::success('Usuario Eliminado')->autoclose(3500);
        return redirect()->route('ReporteConsulta.Aspirante');
	

    }

Alert::error('Error identificación incorrecta')->autoclose(3500);
    return redirect()->route('ReporteConsulta.Aspirante');


    }  


}//finAL
