/** 
 * @overview datejs
 * @version 1.0.0-beta-2014-03-25
 * @author Gregory Wild-Smith <gregory@wild-smith.com>
 * @copyright 2014 Gregory Wild-Smith
 * @license MIT
 * @homepage https://github.com/abritinthebay/datejs
 */
/*
 2014 Gregory Wild-Smith
 @license MIT
 @homepage https://github.com/abritinthebay/datejs
 2014 Gregory Wild-Smith
 @license MIT
 @homepage https://github.com/abritinthebay/datejs
*/
Date.CultureStrings=Date.CultureStrings||{};
Date.CultureStrings["en-US"]={name:"en-US",englishName:"English (United States)",nativeName:"English (United States)",Sunday:"Sunday",Monday:"Monday",Tuesday:"Tuesday",Wednesday:"Wednesday",Thursday:"Thursday",Friday:"Friday",Saturday:"Saturday",Sun:"Sun",Mon:"Mon",Tue:"Tue",Wed:"Wed",Thu:"Thu",Fri:"Fri",Sat:"Sat",Su:"Su",Mo:"Mo",Tu:"Tu",We:"We",Th:"Th",Fr:"Fr",Sa:"Sa",S_Sun_Initial:"S",M_Mon_Initial:"M",T_Tue_Initial:"T",W_Wed_Initial:"W",T_Thu_Initial:"T",F_Fri_Initial:"F",S_Sat_Initial:"S",January:"January",
February:"February",March:"March",April:"April",May:"May",June:"June",July:"July",August:"August",September:"September",October:"October",November:"November",December:"December",Jan_Abbr:"Jan",Feb_Abbr:"Feb",Mar_Abbr:"Mar",Apr_Abbr:"Apr",May_Abbr:"May",Jun_Abbr:"Jun",Jul_Abbr:"Jul",Aug_Abbr:"Aug",Sep_Abbr:"Sep",Oct_Abbr:"Oct",Nov_Abbr:"Nov",Dec_Abbr:"Dec",AM:"AM",PM:"PM",firstDayOfWeek:0,twoDigitYearMax:2049,mdy:"mdy","M/d/yyyy":"M/d/yyyy","dddd, MMMM dd, yyyy":"dddd, MMMM dd, yyyy","h:mm tt":"h:mm tt",
"h:mm:ss tt":"h:mm:ss tt","dddd, MMMM dd, yyyy h:mm:ss tt":"dddd, MMMM dd, yyyy h:mm:ss tt","yyyy-MM-ddTHH:mm:ss":"yyyy-MM-ddTHH:mm:ss","yyyy-MM-dd HH:mm:ssZ":"yyyy-MM-dd HH:mm:ssZ","ddd, dd MMM yyyy HH:mm:ss":"ddd, dd MMM yyyy HH:mm:ss","MMMM dd":"MMMM dd","MMMM, yyyy":"MMMM, yyyy","/jan(uary)?/":"jan(uary)?","/feb(ruary)?/":"feb(ruary)?","/mar(ch)?/":"mar(ch)?","/apr(il)?/":"apr(il)?","/may/":"may","/jun(e)?/":"jun(e)?","/jul(y)?/":"jul(y)?","/aug(ust)?/":"aug(ust)?","/sep(t(ember)?)?/":"sep(t(ember)?)?",
"/oct(ober)?/":"oct(ober)?","/nov(ember)?/":"nov(ember)?","/dec(ember)?/":"dec(ember)?","/^su(n(day)?)?/":"^su(n(day)?)?","/^mo(n(day)?)?/":"^mo(n(day)?)?","/^tu(e(s(day)?)?)?/":"^tu(e(s(day)?)?)?","/^we(d(nesday)?)?/":"^we(d(nesday)?)?","/^th(u(r(s(day)?)?)?)?/":"^th(u(r(s(day)?)?)?)?","/^fr(i(day)?)?/":"^fr(i(day)?)?","/^sa(t(urday)?)?/":"^sa(t(urday)?)?","/^next/":"^next","/^last|past|prev(ious)?/":"^last|past|prev(ious)?","/^(\\+|aft(er)?|from|hence)/":"^(\\+|aft(er)?|from|hence)","/^(\\-|bef(ore)?|ago)/":"^(\\-|bef(ore)?|ago)",
"/^yes(terday)?/":"^yes(terday)?","/^t(od(ay)?)?/":"^t(od(ay)?)?","/^tom(orrow)?/":"^tom(orrow)?","/^n(ow)?/":"^n(ow)?","/^ms|milli(second)?s?/":"^ms|milli(second)?s?","/^sec(ond)?s?/":"^sec(ond)?s?","/^mn|min(ute)?s?/":"^mn|min(ute)?s?","/^h(our)?s?/":"^h(our)?s?","/^w(eek)?s?/":"^w(eek)?s?","/^m(onth)?s?/":"^m(onth)?s?","/^d(ay)?s?/":"^d(ay)?s?","/^y(ear)?s?/":"^y(ear)?s?","/^(a|p)/":"^(a|p)","/^(a\\.?m?\\.?|p\\.?m?\\.?)/":"^(a\\.?m?\\.?|p\\.?m?\\.?)","/^((e(s|d)t|c(s|d)t|m(s|d)t|p(s|d)t)|((gmt)?\\s*(\\+|\\-)\\s*\\d\\d\\d\\d?)|gmt|utc)/":"^((e(s|d)t|c(s|d)t|m(s|d)t|p(s|d)t)|((gmt)?\\s*(\\+|\\-)\\s*\\d\\d\\d\\d?)|gmt|utc)",
"/^\\s*(st|nd|rd|th)/":"^\\s*(st|nd|rd|th)","/^\\s*(\\:|a(?!u|p)|p)/":"^\\s*(\\:|a(?!u|p)|p)",LINT:"LINT",TOT:"TOT",CHAST:"CHAST",NZST:"NZST",NFT:"NFT",SBT:"SBT",AEST:"AEST",ACST:"ACST",JST:"JST",CWST:"CWST",CT:"CT",ICT:"ICT",MMT:"MMT",BIOT:"BST",NPT:"NPT",IST:"IST",PKT:"PKT",AFT:"AFT",MSK:"MSK",IRST:"IRST",FET:"FET",EET:"EET",CET:"CET",UTC:"UTC",GMT:"GMT",CVT:"CVT",GST:"GST",BRT:"BRT",NST:"NST",AST:"AST",EST:"EST",CST:"CST",MST:"MST",PST:"PST",AKST:"AKST",MIT:"MIT",HST:"HST",SST:"SST",BIT:"BIT",
CHADT:"CHADT",NZDT:"NZDT",AEDT:"AEDT",ACDT:"ACDT",AZST:"AZST",IRDT:"IRDT",EEST:"EEST",CEST:"CEST",BST:"BST",PMDT:"PMDT",ADT:"ADT",NDT:"NDT",EDT:"EDT",CDT:"CDT",MDT:"MDT",PDT:"PDT",AKDT:"AKDT",HADT:"HADT"};Date.CultureStrings.lang="en-US";
(function(){var f=Date,g=Date.CultureStrings?Date.CultureStrings.lang:null,c={},a=function(a,e){var b,h,f,m=e?e:g;if(Date.CultureStrings&&Date.CultureStrings[m]&&Date.CultureStrings[m][a])b=Date.CultureStrings[m][a];else switch(a){case "name":b="en-US";break;case "englishName":b="English (United States)";break;case "nativeName":b="English (United States)";break;case "twoDigitYearMax":b=2049;break;case "firstDayOfWeek":b=0;break;default:if(b=a,h=a.split("_"),f=h.length,1<f&&"/"!==a.charAt(0)&&(f=h[f-
1].toLowerCase(),"initial"===f||"abbr"===f))b=h[0]}"/"===a.charAt(0)&&(b=Date.CultureStrings&&Date.CultureStrings[m]&&Date.CultureStrings[m][a]?RegExp(Date.CultureStrings[m][a],"i"):RegExp(a.replace(RegExp("/","g"),""),"i"));c[a]=a;return b},b=function(a){a=Date.Config.i18n+a+".js";var e=document.getElementsByTagName("head")[0]||document.documentElement,b=document.createElement("script");b.src=a;var h={done:function(){}};b.onload=b.onreadystatechange=function(){this.readyState&&"loaded"!==this.readyState&&
"complete"!==this.readyState||(done=!0,h.done(),e.removeChild(b))};setTimeout(function(){e.insertBefore(b,e.firstChild)},0);return{done:function(a){h.done=function(){a&&a()}}}},e=function(){var e={name:a("name"),englishName:a("englishName"),nativeName:a("nativeName"),dayNames:[a("Sunday"),a("Monday"),a("Tuesday"),a("Wednesday"),a("Thursday"),a("Friday"),a("Saturday")],abbreviatedDayNames:[a("Sun"),a("Mon"),a("Tue"),a("Wed"),a("Thu"),a("Fri"),a("Sat")],shortestDayNames:[a("Su"),a("Mo"),a("Tu"),a("We"),
a("Th"),a("Fr"),a("Sa")],firstLetterDayNames:[a("S_Sun_Initial"),a("M_Mon_Initial"),a("T_Tues_Initial"),a("W_Wed_Initial"),a("T_Thu_Initial"),a("F_Fri_Initial"),a("S_Sat_Initial")],monthNames:[a("January"),a("February"),a("March"),a("April"),a("May"),a("June"),a("July"),a("August"),a("September"),a("October"),a("November"),a("December")],abbreviatedMonthNames:[a("Jan_Abbr"),a("Feb_Abbr"),a("Mar_Abbr"),a("Apr_Abbr"),a("May_Abbr"),a("Jun_Abbr"),a("Jul_Abbr"),a("Aug_Abbr"),a("Sep_Abbr"),a("Oct_Abbr"),
a("Nov_Abbr"),a("Dec_Abbr")],amDesignator:a("AM"),pmDesignator:a("PM"),firstDayOfWeek:a("firstDayOfWeek"),twoDigitYearMax:a("twoDigitYearMax"),dateElementOrder:a("mdy"),formatPatterns:{shortDate:a("M/d/yyyy"),longDate:a("dddd, MMMM dd, yyyy"),shortTime:a("h:mm tt"),longTime:a("h:mm:ss tt"),fullDateTime:a("dddd, MMMM dd, yyyy h:mm:ss tt"),sortableDateTime:a("yyyy-MM-ddTHH:mm:ss"),universalSortableDateTime:a("yyyy-MM-dd HH:mm:ssZ"),rfc1123:a("ddd, dd MMM yyyy HH:mm:ss"),monthDay:a("MMMM dd"),yearMonth:a("MMMM, yyyy")},
regexPatterns:{inTheMorning:a("/( in the )(morn(ing)?)\\b/"),thisMorning:a("/(this )(morn(ing)?)\\b/"),amThisMorning:a("/(\b\\d(am)? )(this )(morn(ing)?)/"),inTheEvening:a("/( in the )(even(ing)?)\\b/"),thisEvening:a("/(this )(even(ing)?)\\b/"),pmThisEvening:a("/(\b\\d(pm)? )(this )(even(ing)?)/"),jan:a("/jan(uary)?/"),feb:a("/feb(ruary)?/"),mar:a("/mar(ch)?/"),apr:a("/apr(il)?/"),may:a("/may/"),jun:a("/jun(e)?/"),jul:a("/jul(y)?/"),aug:a("/aug(ust)?/"),sep:a("/sep(t(ember)?)?/"),oct:a("/oct(ober)?/"),
nov:a("/nov(ember)?/"),dec:a("/dec(ember)?/"),sun:a("/^su(n(day)?)?/"),mon:a("/^mo(n(day)?)?/"),tue:a("/^tu(e(s(day)?)?)?/"),wed:a("/^we(d(nesday)?)?/"),thu:a("/^th(u(r(s(day)?)?)?)?/"),fri:a("/fr(i(day)?)?/"),sat:a("/^sa(t(urday)?)?/"),future:a("/^next/"),past:a("/last|past|prev(ious)?/"),add:a("/^(\\+|aft(er)?|from|hence)/"),subtract:a("/^(\\-|bef(ore)?|ago)/"),yesterday:a("/^yes(terday)?/"),today:a("/^t(od(ay)?)?/"),tomorrow:a("/^tom(orrow)?/"),now:a("/^n(ow)?/"),millisecond:a("/^ms|milli(second)?s?/"),
second:a("/^sec(ond)?s?/"),minute:a("/^mn|min(ute)?s?/"),hour:a("/^h(our)?s?/"),week:a("/^w(eek)?s?/"),month:a("/^m(onth)?s?/"),day:a("/^d(ay)?s?/"),year:a("/^y(ear)?s?/"),shortMeridian:a("/^(a|p)/"),longMeridian:a("/^(a\\.?m?\\.?|p\\.?m?\\.?)/"),timezone:a("/^((e(s|d)t|c(s|d)t|m(s|d)t|p(s|d)t)|((gmt)?\\s*(\\+|\\-)\\s*\\d\\d\\d\\d?)|gmt|utc)/"),ordinalSuffix:a("/^\\s*(st|nd|rd|th)/"),timeContext:a("/^\\s*(\\:|a(?!u|p)|p)/")},timezones:[],abbreviatedTimeZoneDST:{},abbreviatedTimeZoneStandard:{}};e.abbreviatedTimeZoneDST[a("CHADT")]=
"+1345";e.abbreviatedTimeZoneDST[a("NZDT")]="+1300";e.abbreviatedTimeZoneDST[a("AEDT")]="+1100";e.abbreviatedTimeZoneDST[a("ACDT")]="+1030";e.abbreviatedTimeZoneDST[a("AZST")]="+0500";e.abbreviatedTimeZoneDST[a("IRDT")]="+0430";e.abbreviatedTimeZoneDST[a("EEST")]="+0300";e.abbreviatedTimeZoneDST[a("CEST")]="+0200";e.abbreviatedTimeZoneDST[a("BST")]="+0100";e.abbreviatedTimeZoneDST[a("PMDT")]="-0200";e.abbreviatedTimeZoneDST[a("ADT")]="-0300";e.abbreviatedTimeZoneDST[a("NDT")]="-0230";e.abbreviatedTimeZoneDST[a("EDT")]=
"-0400";e.abbreviatedTimeZoneDST[a("CDT")]="-0500";e.abbreviatedTimeZoneDST[a("MDT")]="-0600";e.abbreviatedTimeZoneDST[a("PDT")]="-0700";e.abbreviatedTimeZoneDST[a("AKDT")]="-0800";e.abbreviatedTimeZoneDST[a("HADT")]="-0900";e.abbreviatedTimeZoneStandard[a("LINT")]="+1400";e.abbreviatedTimeZoneStandard[a("TOT")]="+1300";e.abbreviatedTimeZoneStandard[a("CHAST")]="+1245";e.abbreviatedTimeZoneStandard[a("NZST")]="+1200";e.abbreviatedTimeZoneStandard[a("NFT")]="+1130";e.abbreviatedTimeZoneStandard[a("SBT")]=
"+1100";e.abbreviatedTimeZoneStandard[a("AEST")]="+1000";e.abbreviatedTimeZoneStandard[a("ACST")]="+0930";e.abbreviatedTimeZoneStandard[a("JST")]="+0900";e.abbreviatedTimeZoneStandard[a("CWST")]="+0845";e.abbreviatedTimeZoneStandard[a("CT")]="+0800";e.abbreviatedTimeZoneStandard[a("ICT")]="+0700";e.abbreviatedTimeZoneStandard[a("MMT")]="+0630";e.abbreviatedTimeZoneStandard[a("BST")]="+0600";e.abbreviatedTimeZoneStandard[a("NPT")]="+0545";e.abbreviatedTimeZoneStandard[a("IST")]="+0530";e.abbreviatedTimeZoneStandard[a("PKT")]=
"+0500";e.abbreviatedTimeZoneStandard[a("AFT")]="+0430";e.abbreviatedTimeZoneStandard[a("MSK")]="+0400";e.abbreviatedTimeZoneStandard[a("IRST")]="+0330";e.abbreviatedTimeZoneStandard[a("FET")]="+0300";e.abbreviatedTimeZoneStandard[a("EET")]="+0200";e.abbreviatedTimeZoneStandard[a("CET")]="+0100";e.abbreviatedTimeZoneStandard[a("GMT")]="+0000";e.abbreviatedTimeZoneStandard[a("UTC")]="+0000";e.abbreviatedTimeZoneStandard[a("CVT")]="-0100";e.abbreviatedTimeZoneStandard[a("GST")]="-0200";e.abbreviatedTimeZoneStandard[a("BRT")]=
"-0300";e.abbreviatedTimeZoneStandard[a("NST")]="-0330";e.abbreviatedTimeZoneStandard[a("AST")]="-0400";e.abbreviatedTimeZoneStandard[a("EST")]="-0500";e.abbreviatedTimeZoneStandard[a("CST")]="-0600";e.abbreviatedTimeZoneStandard[a("MST")]="-0700";e.abbreviatedTimeZoneStandard[a("PST")]="-0800";e.abbreviatedTimeZoneStandard[a("AKST")]="-0900";e.abbreviatedTimeZoneStandard[a("MIT")]="-0930";e.abbreviatedTimeZoneStandard[a("HST")]="-1000";e.abbreviatedTimeZoneStandard[a("SST")]="-1100";e.abbreviatedTimeZoneStandard[a("BIT")]=
"-1200";for(var d in e.abbreviatedTimeZoneStandard)e.abbreviatedTimeZoneStandard.hasOwnProperty(d)&&e.timezones.push({name:d,offset:e.abbreviatedTimeZoneStandard[d]});for(d in e.abbreviatedTimeZoneDST)e.abbreviatedTimeZoneDST.hasOwnProperty(d)&&e.timezones.push({name:d,offset:e.abbreviatedTimeZoneDST[d],dst:!0});return e};f.i18n={__:function(e,d){return a(e,d)},currentLanguage:function(){return g||"en-US"},setLanguage:function(a,d){if(d||"en-US"===a||Date.CultureStrings&&Date.CultureStrings[a])g=
a,Date.CultureStrings.lang=a,Date.CultureInfo=e();else if(!Date.CultureStrings||!Date.CultureStrings[a])if("undefined"!==typeof exports&&this.exports!==exports)try{require("../i18n/"+a+".js"),g=a,Date.CultureStrings.lang=a,Date.CultureInfo=e()}catch(c){throw Error("The DateJS IETF language tag '"+a+"' could not be loaded by Node. It likely does not exist.");}else Date.Config&&Date.Config.i18n?b(a).done(function(){g=a;Date.CultureStrings.lang=a;Date.CultureInfo=e()}):Date.console.error("The DateJS IETF language tag '"+
a+"' is not available and has not been loaded.")},getLoggedKeys:function(){return c},updateCultureInfo:function(){Date.CultureInfo=e()}};f.i18n.updateCultureInfo()})();
(function(){var f=Date,g=f.prototype,c=function(a,b){b||(b=2);return("000"+a).slice(-1*b)};f.console="undefined"!==typeof window&&"undefined"!==typeof window.console&&"undefined"!==typeof window.console.log?console:{log:function(){},error:function(){}};f.Config={};f.initOverloads=function(){f.now?f._now||(f._now=f.now):f._now=function(){return(new Date).getTime()};f.now=function(a){return a?f.present():f._now()};g.toISOString||(g.toISOString=function(){return this.getUTCFullYear()+"-"+c(this.getUTCMonth()+
1)+"-"+c(this.getUTCDate())+"T"+c(this.getUTCHours())+":"+c(this.getUTCMinutes())+":"+c(this.getUTCSeconds())+"."+String((this.getUTCMilliseconds()/1E3).toFixed(3)).slice(2,5)+"Z"});void 0===g._toString&&(g._toString=g.toString)};f.initOverloads();g.clearTime=function(){this.setHours(0);this.setMinutes(0);this.setSeconds(0);this.setMilliseconds(0);return this};g.setTimeToNow=function(){var a=new Date;this.setHours(a.getHours());this.setMinutes(a.getMinutes());this.setSeconds(a.getSeconds());this.setMilliseconds(a.getMilliseconds());
return this};f.today=function(){return(new Date).clearTime()};f.present=function(){return new Date};f.compare=function(a,b){if(isNaN(a)||isNaN(b))throw Error(a+" - "+b);if(a instanceof Date&&b instanceof Date)return a<b?-1:a>b?1:0;throw new TypeError(a+" - "+b);};f.equals=function(a,b){return 0===a.compareTo(b)};f.getDayName=function(a){return Date.CultureInfo.dayNames[a]};f.getDayNumberFromName=function(a){var b=Date.CultureInfo.dayNames,d=Date.CultureInfo.abbreviatedDayNames,c=Date.CultureInfo.shortestDayNames;
a=a.toLowerCase();for(var h=0;h<b.length;h++)if(b[h].toLowerCase()===a||d[h].toLowerCase()===a||c[h].toLowerCase()===a)return h;return-1};f.getMonthNumberFromName=function(a){var b=Date.CultureInfo.monthNames,d=Date.CultureInfo.abbreviatedMonthNames;a=a.toLowerCase();for(var c=0;c<b.length;c++)if(b[c].toLowerCase()===a||d[c].toLowerCase()===a)return c;return-1};f.getMonthName=function(a){return Date.CultureInfo.monthNames[a]};f.isLeapYear=function(a){return 0===a%4&&0!==a%100||0===a%400};f.getDaysInMonth=
function(a,b){!b&&f.validateMonth(a)&&(b=a,a=Date.today().getFullYear());return[31,f.isLeapYear(a)?29:28,31,30,31,30,31,31,30,31,30,31][b]};f.getTimezoneAbbreviation=function(a,b){var d,c=b?Date.CultureInfo.abbreviatedTimeZoneDST:Date.CultureInfo.abbreviatedTimeZoneStandard;for(d in c)if(c.hasOwnProperty(d)&&c[d]===a)return d;return null};f.getTimezoneOffset=function(a,b){var d,c=[],h=Date.CultureInfo.timezones;a||(a=(new Date).getTimezone());for(d=0;d<h.length;d++)h[d].name===a.toUpperCase()&&c.push(d);
if(!h[c[0]])return null;if(1!==c.length&&b)for(d=0;d<c.length;d++){if(h[c[d]].dst)return h[c[d]].offset}else return h[c[0]].offset};f.getQuarter=function(a){a=a||new Date;return[1,2,3,4][Math.floor(a.getMonth()/3)]};f.getDaysLeftInQuarter=function(a){a=a||new Date;var b=new Date(a);b.setMonth(b.getMonth()+3-b.getMonth()%3,0);return Math.floor((b-a)/864E5)};g.clone=function(){return new Date(this.getTime())};g.compareTo=function(a){return Date.compare(this,a)};g.equals=function(a){return Date.equals(this,
void 0!==a?a:new Date)};g.between=function(a,b){return this.getTime()>=a.getTime()&&this.getTime()<=b.getTime()};g.isAfter=function(a){return 1===this.compareTo(a||new Date)};g.isBefore=function(a){return-1===this.compareTo(a||new Date)};g.isToday=g.isSameDay=function(a){return this.clone().clearTime().equals((a||new Date).clone().clearTime())};g.addMilliseconds=function(a){if(!a)return this;this.setTime(this.getTime()+1*a);return this};g.addSeconds=function(a){return a?this.addMilliseconds(1E3*a):
this};g.addMinutes=function(a){return a?this.addMilliseconds(6E4*a):this};g.addHours=function(a){return a?this.addMilliseconds(36E5*a):this};g.addDays=function(a){if(!a)return this;this.setDate(this.getDate()+1*a);return this};g.addWeekdays=function(a){if(!a)return this;var b=this.getDay(),d=Math.ceil(Math.abs(a)/7);(0===b||6===b)&&0<a&&(this.next().monday(),this.addDays(-1));if(0>a){for(;0>a;)this.addDays(-1),b=this.getDay(),0!==b&&6!==b&&a++;return this}if(5<a||6-b<=a)a+=2*d;return this.addDays(a)};
g.addWeeks=function(a){return a?this.addDays(7*a):this};g.addMonths=function(a){if(!a)return this;var b=this.getDate();this.setDate(1);this.setMonth(this.getMonth()+1*a);this.setDate(Math.min(b,f.getDaysInMonth(this.getFullYear(),this.getMonth())));return this};g.addQuarters=function(a){return a?this.addMonths(3*a):this};g.addYears=function(a){return a?this.addMonths(12*a):this};g.add=function(a){if("number"===typeof a)return this._orient=a,this;a.day&&0!==a.day-this.getDate()&&this.setDate(a.day);
a.milliseconds&&this.addMilliseconds(a.milliseconds);a.seconds&&this.addSeconds(a.seconds);a.minutes&&this.addMinutes(a.minutes);a.hours&&this.addHours(a.hours);a.weeks&&this.addWeeks(a.weeks);a.months&&this.addMonths(a.months);a.years&&this.addYears(a.years);a.days&&this.addDays(a.days);return this};g.getWeek=function(a){var b=new Date(this.valueOf());a?(b.addMinutes(b.getTimezoneOffset()),a=b.clone()):a=this;a=(a.getDay()+6)%7;b.setDate(b.getDate()-a+3);a=b.valueOf();b.setMonth(0,1);4!==b.getDay()&&
b.setMonth(0,1+(4-b.getDay()+7)%7);return 1+Math.ceil((a-b)/6048E5)};g.getISOWeek=function(){return c(this.getWeek(!0))};g.setWeek=function(a){return 0===a-this.getWeek()?1!==this.getDay()?this.moveToDayOfWeek(1,1<this.getDay()?-1:1):this:this.moveToDayOfWeek(1,1<this.getDay()?-1:1).addWeeks(a-this.getWeek())};g.setQuarter=function(a){a=Math.abs(3*(a-1)+1);return this.setMonth(a,1)};g.getQuarter=function(){return Date.getQuarter(this)};g.getDaysLeftInQuarter=function(){return Date.getDaysLeftInQuarter(this)};
var a=function(a,b,d,c){if("undefined"===typeof a)return!1;if("number"!==typeof a)throw new TypeError(a+" is not a Number.");return a<b||a>d?!1:!0};f.validateMillisecond=function(e){return a(e,0,999,"millisecond")};f.validateSecond=function(e){return a(e,0,59,"second")};f.validateMinute=function(e){return a(e,0,59,"minute")};f.validateHour=function(e){return a(e,0,23,"hour")};f.validateDay=function(e,b,d){return a(e,1,f.getDaysInMonth(b,d),"day")};f.validateWeek=function(e){return a(e,0,53,"week")};
f.validateMonth=function(e){return a(e,0,11,"month")};f.validateYear=function(e){return a(e,-271822,275760,"year")};g.set=function(a){f.validateMillisecond(a.millisecond)&&this.addMilliseconds(a.millisecond-this.getMilliseconds());f.validateSecond(a.second)&&this.addSeconds(a.second-this.getSeconds());f.validateMinute(a.minute)&&this.addMinutes(a.minute-this.getMinutes());f.validateHour(a.hour)&&this.addHours(a.hour-this.getHours());f.validateMonth(a.month)&&this.addMonths(a.month-this.getMonth());
f.validateYear(a.year)&&this.addYears(a.year-this.getFullYear());f.validateDay(a.day,this.getFullYear(),this.getMonth())&&this.addDays(a.day-this.getDate());a.timezone&&this.setTimezone(a.timezone);a.timezoneOffset&&this.setTimezoneOffset(a.timezoneOffset);a.week&&f.validateWeek(a.week)&&this.setWeek(a.week);return this};g.moveToFirstDayOfMonth=function(){return this.set({day:1})};g.moveToLastDayOfMonth=function(){return this.set({day:f.getDaysInMonth(this.getFullYear(),this.getMonth())})};g.moveToNthOccurrence=
function(a,b){if("Weekday"===a){if(0<b)this.moveToFirstDayOfMonth(),this.is().weekday()&&(b-=1);else if(0>b)this.moveToLastDayOfMonth(),this.is().weekday()&&(b+=1);else return this;return this.addWeekdays(b)}var d=0;if(0<b)d=b-1;else if(-1===b)return this.moveToLastDayOfMonth(),this.getDay()!==a&&this.moveToDayOfWeek(a,-1),this;return this.moveToFirstDayOfMonth().addDays(-1).moveToDayOfWeek(a,1).addWeeks(d)};g.moveToDayOfWeek=function(a,b){var d=(a-this.getDay()+7*(b||1))%7;return this.addDays(0===
d?d+7*(b||1):d)};g.moveToMonth=function(a,b){var d=(a-this.getMonth()+12*(b||1))%12;return this.addMonths(0===d?d+12*(b||1):d)};g.getOrdinate=function(){var a=this.getDate();return b(a)};g.getOrdinalNumber=function(){return Math.ceil((this.clone().clearTime()-new Date(this.getFullYear(),0,1))/864E5)+1};g.getTimezone=function(){return f.getTimezoneAbbreviation(this.getUTCOffset(),this.isDaylightSavingTime())};g.setTimezoneOffset=function(a){var b=this.getTimezoneOffset();return(a=-6*Number(a)/10)||
0===a?this.addMinutes(a-b):this};g.setTimezone=function(a){return this.setTimezoneOffset(f.getTimezoneOffset(a))};g.hasDaylightSavingTime=function(){return Date.today().set({month:0,day:1}).getTimezoneOffset()!==Date.today().set({month:6,day:1}).getTimezoneOffset()};g.isDaylightSavingTime=function(){return Date.today().set({month:0,day:1}).getTimezoneOffset()!==this.getTimezoneOffset()};g.getUTCOffset=function(a){a=-10*(a||this.getTimezoneOffset())/6;if(0>a)return a=(a-1E4).toString(),a.charAt(0)+
a.substr(2);a=(a+1E4).toString();return"+"+a.substr(1)};g.getElapsed=function(a){return(a||new Date)-this};var b=function(a){switch(1*a){case 1:case 21:case 31:return"st";case 2:case 22:return"nd";case 3:case 23:return"rd";default:return"th"}};g.toString=function(a,f){var d=this;if(!f&&a&&1===a.length){var g,h=Date.CultureInfo.formatPatterns;d.t=d.toString;switch(a){case "d":return d.t(h.shortDate);case "D":return d.t(h.longDate);case "F":return d.t(h.fullDateTime);case "m":return d.t(h.monthDay);
case "r":case "R":return g=d.clone().addMinutes(d.getTimezoneOffset()),g.toString(h.rfc1123)+" GMT";case "s":return d.t(h.sortableDateTime);case "t":return d.t(h.shortTime);case "T":return d.t(h.longTime);case "u":return g=d.clone().addMinutes(d.getTimezoneOffset()),g.toString(h.universalSortableDateTime);case "y":return d.t(h.yearMonth)}}return a?a.replace(/((\\)?(dd?d?d?|MM?M?M?|yy?y?y?|hh?|HH?|mm?|ss?|tt?|S|q|Q|WW?W?W?)(?![^\[]*\]))/g,function(a){if("\\"===a.charAt(0))return a.replace("\\","");
d.h=d.getHours;switch(a){case "hh":return c(13>d.h()?0===d.h()?12:d.h():d.h()-12);case "h":return 13>d.h()?0===d.h()?12:d.h():d.h()-12;case "HH":return c(d.h());case "H":return d.h();case "mm":return c(d.getMinutes());case "m":return d.getMinutes();case "ss":return c(d.getSeconds());case "s":return d.getSeconds();case "yyyy":return c(d.getFullYear(),4);case "yy":return c(d.getFullYear());case "dddd":return Date.CultureInfo.dayNames[d.getDay()];case "ddd":return Date.CultureInfo.abbreviatedDayNames[d.getDay()];
case "dd":return c(d.getDate());case "d":return d.getDate();case "MMMM":return Date.CultureInfo.monthNames[d.getMonth()];case "MMM":return Date.CultureInfo.abbreviatedMonthNames[d.getMonth()];case "MM":return c(d.getMonth()+1);case "M":return d.getMonth()+1;case "t":return 12>d.h()?Date.CultureInfo.amDesignator.substring(0,1):Date.CultureInfo.pmDesignator.substring(0,1);case "tt":return 12>d.h()?Date.CultureInfo.amDesignator:Date.CultureInfo.pmDesignator;case "S":return b(d.getDate());case "W":return d.getWeek();
case "WW":return d.getISOWeek();case "Q":return"Q"+d.getQuarter();case "q":return String(d.getQuarter());default:return a}}).replace(/\[|\]/g,""):this._toString()}})();
(function(){Date.Parsing={Exception:function(a){this.message="Parse error at '"+a.substring(0,10)+" ...'"}};var f=Date.Parsing,g=[0,31,59,90,120,151,181,212,243,273,304,334],c=[0,31,60,91,121,152,182,213,244,274,305,335];f.isLeapYear=function(a){return 0===a%4&&0!==a%100||0===a%400};f.processTimeObject=function(a){var b,e;b=new Date;e=f.isLeapYear(a.year)?c:g;a.hours=a.hours?a.hours:0;a.minutes=a.minutes?a.minutes:0;a.seconds=a.seconds?a.seconds:0;a.milliseconds=a.milliseconds?a.milliseconds:0;a.year||
(a.year=b.getFullYear());if(a.month||!a.week&&!a.dayOfYear)a.month=a.month?a.month:0,a.day=a.day?a.day:1,a.dayOfYear=e[a.month]+a.day;else for(a.dayOfYear||(a.weekDay=a.weekDay||0===a.weekDay?a.weekDay:1,b=new Date(a.year,0,4),b=0===b.getDay()?7:b.getDay(),a.dayOfYear=7*a.week+(0===a.weekDay?7:a.weekDay)-(b+3)),b=0;b<=e.length;b++)if(a.dayOfYear<e[b]||b===e.length){a.day=a.day?a.day:a.dayOfYear-e[b-1];break}else a.month=b;e=new Date(a.year,a.month,a.day,a.hours,a.minutes,a.seconds,a.milliseconds);
a.zone&&("Z"===a.zone.toUpperCase()||0===a.zone_hours&&0===a.zone_minutes?b=-e.getTimezoneOffset():(b=60*a.zone_hours+(a.zone_minutes?a.zone_minutes:0),"+"===a.zone_sign&&(b*=-1),b-=e.getTimezoneOffset()),e.setMinutes(e.getMinutes()+b));return e};f.ISO={regex:/^([\+-]?\d{4}(?!\d{2}\b))((-?)((0[1-9]|1[0-2])(\3([12]\d|0[1-9]|3[01]))?|W([0-4]\d|5[0-3])(-?[1-7])?|(00[1-9]|0[1-9]\d|[12]\d{2}|3([0-5]\d|6[1-6])))([T\s]((([01]\d|2[0-4])((:?)[0-5]\d)?|24\:?00)([\.,]\d+(?!:))?)?(\17[0-5]\d([\.,]\d+)?)?\s?([zZ]|([\+-])([01]\d|2[0-3]):?([0-5]\d)?)?)?)?$/,
parse:function(a){a=a.match(this.regex);if(!a||!a.length)return null;var b={year:a[1]?Number(a[1]):a[1],month:a[5]?Number(a[5])-1:a[5],day:a[7]?Number(a[7]):a[7],week:a[8]?Number(a[8]):a[8],weekDay:a[9]?7===Math.abs(Number(a[9]))?0:Math.abs(Number(a[9])):a[9],dayOfYear:a[10]?Number(a[10]):a[10],hours:a[15]?Number(a[15]):a[15],minutes:a[16]?Number(a[16].replace(":","")):a[16],seconds:a[19]?Math.floor(Number(a[19].replace(":","").replace(",","."))):a[19],milliseconds:a[20]?1E3*Number(a[20].replace(",",
".")):a[20],zone:a[21],zone_sign:a[22],zone_hours:a[23]&&"undefined"!==typeof a[23]?Number(a[23]):a[23],zone_minutes:a[24]&&"undefined"!==typeof a[23]?Number(a[24]):a[24]};a[18]&&((a[18]=60*Number(a[18].replace(",",".")),b.minutes)?b.seconds||(b.seconds=a[18]):b.minutes=a[18]);return b.year&&(b.year||b.month||b.day||b.week||b.dayOfYear)?f.processTimeObject(b):null}};f.Numeric={isNumeric:function(a){return!isNaN(parseFloat(a))&&isFinite(a)},regex:/\b([0-1]?[0-9])([0-3]?[0-9])([0-2]?[0-9]?[0-9][0-9])\b/i,
parse:function(a){var b,e={},c=Date.CultureInfo.dateElementOrder.split("");if(!this.isNumeric(a)||"+"===a[0]&&"-"===a[0])return null;if(5>a.length)return e.year=a,f.processTimeObject(e);a=a.match(this.regex);if(!a||!a.length)return null;for(b=0;b<c.length;b++)switch(c[b]){case "d":e.day=a[b+1];break;case "m":e.month=a[b+1]-1;break;case "y":e.year=a[b+1]}return f.processTimeObject(e)}};f.Normalizer={parse:function(a){var b=Date.CultureInfo.regexPatterns,e=Date.i18n.__;a=a.replace(b.jan.source,"January");
a=a.replace(b.feb,"February");a=a.replace(b.mar,"March");a=a.replace(b.apr,"April");a=a.replace(b.may,"May");a=a.replace(b.jun,"June");a=a.replace(b.jul,"July");a=a.replace(b.aug,"August");a=a.replace(b.sep,"September");a=a.replace(b.oct,"October");a=a.replace(b.nov,"November");a=a.replace(b.dec,"December");a=a.replace(b.tomorrow,Date.today().addDays(1).toString("d"));a=a.replace(b.yesterday,Date.today().addDays(-1).toString("d"));a=a.replace(/\bat\b/gi,"");a=a.replace(/\s{2,}/," ");a=a.replace(RegExp("(\\b\\d\\d?("+
e("AM")+"|"+e("PM")+")? )("+b.tomorrow.source.slice(1)+")","i"),function(a,b,e,d,c){return Date.today().addDays(1).toString("d")+" "+b});a=a.replace(RegExp("(("+b.past.source+")\\s("+b.mon.source+"))"),Date.today().last().monday().toString("d"));a=a.replace(RegExp("(("+b.past.source+")\\s("+b.tue.source+"))"),Date.today().last().tuesday().toString("d"));a=a.replace(RegExp("(("+b.past.source+")\\s("+b.wed.source+"))"),Date.today().last().wednesday().toString("d"));a=a.replace(RegExp("(("+b.past.source+
")\\s("+b.thu.source+"))"),Date.today().last().thursday().toString("d"));a=a.replace(RegExp("(("+b.past.source+")\\s("+b.fri.source+"))"),Date.today().last().friday().toString("d"));a=a.replace(RegExp("(("+b.past.source+")\\s("+b.sat.source+"))"),Date.today().last().saturday().toString("d"));a=a.replace(RegExp("(("+b.past.source+")\\s("+b.sun.source+"))"),Date.today().last().sunday().toString("d"));a=a.replace(b.amThisMorning,function(a,b){return b});a=a.replace(b.inTheMorning,"am");a=a.replace(b.thisMorning,
"9am");a=a.replace(b.amThisEvening,function(a,b){return b});a=a.replace(b.inTheEvening,"pm");a=a.replace(b.thisEvening,"7pm");try{var c=a.split(/([\s\-\.\,\/\x27]+)/);3===c.length&&f.Numeric.isNumeric(c[0])&&f.Numeric.isNumeric(c[2])&&4<=c[2].length&&"d"===Date.CultureInfo.dateElementOrder[0]&&(a="1/"+c[0]+"/"+c[2])}catch(d){}return a}}})();
(function(){for(var f=Date.Parsing,g=f.Operators={rtoken:function(a){return function(b){var d=b.match(a);if(d)return[d[0],b.substring(d[0].length)];throw new f.Exception(b);}},token:function(a){return function(a){return g.rtoken(RegExp("^s*"+a+"s*"))(a)}},stoken:function(a){return g.rtoken(RegExp("^"+a))},until:function(a){return function(b){for(var d=[],c=null;b.length;){try{c=a.call(this,b)}catch(h){d.push(c[0]);b=c[1];continue}break}return[d,b]}},many:function(a){return function(b){for(var d=[],
c=null;b.length;){try{c=a.call(this,b)}catch(h){break}d.push(c[0]);b=c[1]}return[d,b]}},optional:function(a){return function(b){var d=null;try{d=a.call(this,b)}catch(c){return[null,b]}return[d[0],d[1]]}},not:function(a){return function(b){try{a.call(this,b)}catch(d){return[null,b]}throw new f.Exception(b);}},ignore:function(a){return a?function(b){var d=null,d=a.call(this,b);return[null,d[1]]}:null},product:function(){for(var a=arguments[0],b=Array.prototype.slice.call(arguments,1),d=[],c=0;c<a.length;c++)d.push(g.each(a[c],
b));return d},cache:function(a){var b={},d=null;return function(c){try{d=b[c]=b[c]||a.call(this,c)}catch(h){d=b[c]=h}if(d instanceof f.Exception)throw d;return d}},any:function(){var a=arguments;return function(b){for(var d=null,c=0;c<a.length;c++)if(null!=a[c]){try{d=a[c].call(this,b)}catch(h){d=null}if(d)return d}throw new f.Exception(b);}},each:function(){var a=arguments;return function(b){for(var d=[],c=null,h=0;h<a.length;h++)if(null!=a[h]){try{c=a[h].call(this,b)}catch(g){throw new f.Exception(b);
}d.push(c[0]);b=c[1]}return[d,b]}},all:function(){var a=a;return a.each(a.optional(arguments))},sequence:function(a,b,d){b=b||g.rtoken(/^\s*/);d=d||null;return 1==a.length?a[0]:function(c){for(var h=null,g=null,m=[],n=0;n<a.length;n++){try{h=a[n].call(this,c)}catch(p){break}m.push(h[0]);try{g=b.call(this,h[1])}catch(s){g=null;break}c=g[1]}if(!h)throw new f.Exception(c);if(g)throw new f.Exception(g[1]);if(d)try{h=d.call(this,h[1])}catch(t){throw new f.Exception(h[1]);}return[m,h?h[1]:c]}},between:function(a,
b,d){d=d||a;var c=g.each(g.ignore(a),b,g.ignore(d));return function(a){a=c.call(this,a);return[[a[0][0],r[0][2]],a[1]]}},list:function(a,b,d){b=b||g.rtoken(/^\s*/);d=d||null;return a instanceof Array?g.each(g.product(a.slice(0,-1),g.ignore(b)),a.slice(-1),g.ignore(d)):g.each(g.many(g.each(a,g.ignore(b))),px,g.ignore(d))},set:function(a,b,d){b=b||g.rtoken(/^\s*/);d=d||null;return function(c){for(var h=null,k=h=null,m=null,n=[[],c],p=!1,s=0;s<a.length;s++){h=k=null;p=1==a.length;try{h=a[s].call(this,
c)}catch(t){continue}m=[[h[0]],h[1]];if(0<h[1].length&&!p)try{k=b.call(this,h[1])}catch(u){p=!0}else p=!0;p||0!==k[1].length||(p=!0);if(!p){h=[];for(p=0;p<a.length;p++)s!=p&&h.push(a[p]);h=g.set(h,b).call(this,k[1]);0<h[0].length&&(m[0]=m[0].concat(h[0]),m[1]=h[1])}m[1].length<n[1].length&&(n=m);if(0===n[1].length)break}if(0===n[0].length)return n;if(d){try{k=d.call(this,n[1])}catch(v){throw new f.Exception(n[1]);}n[1]=k[1]}return n}},forward:function(a,b){return function(d){return a[b].call(this,
d)}},replace:function(a,b){return function(d){d=a.call(this,d);return[b,d[1]]}},process:function(a,b){return function(d){d=a.call(this,d);return[b.call(this,d[0]),d[1]]}},min:function(a,b){return function(d){var c=b.call(this,d);if(c[0].length<a)throw new f.Exception(d);return c}}},c=function(a){return function(){var b=null,d=[],c;1<arguments.length?b=Array.prototype.slice.call(arguments):arguments[0]instanceof Array&&(b=arguments[0]);if(b){if(c=b.shift(),0<c.length)return b.unshift(c[void 0]),d.push(a.apply(null,
b)),b.shift(),d}else return a.apply(null,arguments)}},a="optional not ignore cache".split(/\s/),b=0;b<a.length;b++)g[a[b]]=c(g[a[b]]);c=function(a){return function(){return arguments[0]instanceof Array?a.apply(null,arguments[0]):a.apply(null,arguments)}};a="each any all".split(/\s/);for(b=0;b<a.length;b++)g[a[b]]=c(g[a[b]])})();
(function(){var f=Date,g=function(a){for(var b=[],c=0;c<a.length;c++)a[c]instanceof Array?b=b.concat(g(a[c])):a[c]&&b.push(a[c]);return b};f.Grammar={};f.Translator={hour:function(a){return function(){this.hour=Number(a)}},minute:function(a){return function(){this.minute=Number(a)}},second:function(a){return function(){this.second=Number(a)}},secondAndMillisecond:function(a){return function(){var b=a.match(/^([0-5][0-9])\.([0-9]{1,3})/);this.second=Number(b[1]);this.millisecond=Number(b[2])}},meridian:function(a){return function(){this.meridian=
a.slice(0,1).toLowerCase()}},timezone:function(a){return function(){var b=a.replace(/[^\d\+\-]/g,"");b.length?this.timezoneOffset=Number(b):this.timezone=a.toLowerCase()}},day:function(a){var b=a[0];return function(){this.day=Number(b.match(/\d+/)[0]);if(1>this.day)throw"invalid day";}},month:function(a){return function(){this.month=3===a.length?"jan feb mar apr may jun jul aug sep oct nov dec".indexOf(a)/4:Number(a)-1;if(0>this.month)throw"invalid month";}},year:function(a){return function(){var b=
Number(a);this.year=2<a.length?b:b+(b+2E3<Date.CultureInfo.twoDigitYearMax?2E3:1900)}},rday:function(a){return function(){switch(a){case "yesterday":this.days=-1;break;case "tomorrow":this.days=1;break;case "today":this.days=0;break;case "now":this.days=0,this.now=!0}}},finishExact:function(a){a=a instanceof Array?a:[a];for(var b=0;b<a.length;b++)a[b]&&a[b].call(this);a=new Date;!this.hour&&!this.minute||this.month||this.year||this.day||(this.day=a.getDate());this.year||(this.year=a.getFullYear());
this.month||0===this.month||(this.month=a.getMonth());this.day||(this.day=1);this.hour||(this.hour=0);this.minute||(this.minute=0);this.second||(this.second=0);this.millisecond||(this.millisecond=0);if(this.meridian&&(this.hour||0===this.hour)){if("a"==this.meridian&&11<this.hour&&Date.Config.strict24hr)throw"Invalid hour and meridian combination";if("p"==this.meridian&&12>this.hour&&Date.Config.strict24hr)throw"Invalid hour and meridian combination";"p"==this.meridian&&12>this.hour?this.hour+=12:
"a"==this.meridian&&12==this.hour&&(this.hour=0)}if(this.day>f.getDaysInMonth(this.year,this.month))throw new RangeError(this.day+" is not a valid value for days.");a=new Date(this.year,this.month,this.day,this.hour,this.minute,this.second,this.millisecond);100>this.year&&a.setFullYear(this.year);this.timezone?a.set({timezone:this.timezone}):this.timezoneOffset&&a.set({timezoneOffset:this.timezoneOffset});return a},finish:function(a){a=a instanceof Array?g(a):[a];if(0===a.length)return null;for(var b=
0;b<a.length;b++)"function"==typeof a[b]&&a[b].call(this);a=f.today();if(!this.now||this.unit||this.operator)this.now&&(a=new Date);else return new Date;var b=!!(this.days&&null!==this.days||this.orient||this.operator),c,d,e;e="past"==this.orient||"subtract"==this.operator?-1:1;this.now||-1=="hour minute second".indexOf(this.unit)||a.setTimeToNow();this.month&&"week"==this.unit&&(this.value=this.month+1,delete this.month,delete this.day);!this.month&&0!==this.month||-1=="year day hour minute second".indexOf(this.unit)||
(this.value||(this.value=this.month+1),this.month=null,b=!0);b||!this.weekday||this.day||this.days||(c=Date[this.weekday](),this.day=c.getDate(),this.month||(this.month=c.getMonth()),this.year=c.getFullYear());b&&this.weekday&&"month"!=this.unit&&"week"!=this.unit&&(this.unit="day",c=f.getDayNumberFromName(this.weekday)-a.getDay(),d=7,this.days=c?(c+e*d)%d:e*d);this.month&&"day"==this.unit&&this.operator&&(this.value||(this.value=this.month+1),this.month=null);null!=this.value&&null!=this.month&&
null!=this.year&&(this.day=1*this.value);this.month&&!this.day&&this.value&&(a.set({day:1*this.value}),b||(this.day=1*this.value));this.month||!this.value||"month"!=this.unit||this.now||(this.month=this.value,b=!0);b&&(this.month||0===this.month)&&"year"!=this.unit&&(this.unit="month",c=this.month-a.getMonth(),d=12,this.months=c?(c+e*d)%d:e*d,this.month=null);this.unit||(this.unit="day");if(!this.value&&this.operator&&null!==this.operator&&this[this.unit+"s"]&&null!==this[this.unit+"s"])this[this.unit+
"s"]=this[this.unit+"s"]+("add"==this.operator?1:-1)+(this.value||0)*e;else if(null==this[this.unit+"s"]||null!=this.operator)this.value||(this.value=1),this[this.unit+"s"]=this.value*e;if(this.meridian&&(this.hour||0===this.hour)){if("a"==this.meridian&&11<this.hour&&Date.Config.strict24hr)throw"Invalid hour and meridian combination";if("p"==this.meridian&&12>this.hour&&Date.Config.strict24hr)throw"Invalid hour and meridian combination";"p"==this.meridian&&12>this.hour?this.hour+=12:"a"==this.meridian&&
12==this.hour&&(this.hour=0)}!this.weekday||"week"===this.unit||this.day||this.days||(c=Date[this.weekday](),this.day=c.getDate(),c.getMonth()!==a.getMonth()&&(this.month=c.getMonth()));!this.month&&0!==this.month||this.day||(this.day=1);if(!this.orient&&!this.operator&&"week"==this.unit&&this.value&&!this.day&&!this.month)return Date.today().setWeek(this.value);if("week"==this.unit&&this.weeks&&!this.day&&!this.month)return a=Date[this.weekday?this.weekday:"today"]().addWeeks(this.weeks),this.now&&
a.setTimeToNow(),a;b&&this.timezone&&this.day&&this.days&&(this.day=this.days);return b?a.add(this):a.set(this)}};var c=f.Parsing.Operators,a=f.Grammar,b=f.Translator,e;a.datePartDelimiter=c.rtoken(/^([\s\-\.\,\/\x27]+)/);a.timePartDelimiter=c.stoken(":");a.whiteSpace=c.rtoken(/^\s*/);a.generalDelimiter=c.rtoken(/^(([\s\,]|at|@|on)+)/);var q={};a.ctoken=function(a){var b=q[a];if(!b){for(var b=Date.CultureInfo.regexPatterns,d=a.split(/\s+/),e=[],f=0;f<d.length;f++)e.push(c.replace(c.rtoken(b[d[f]]),
d[f]));b=q[a]=c.any.apply(null,e)}return b};a.ctoken2=function(a){return c.rtoken(Date.CultureInfo.regexPatterns[a])};a.h=c.cache(c.process(c.rtoken(/^(0[0-9]|1[0-2]|[1-9])/),b.hour));a.hh=c.cache(c.process(c.rtoken(/^(0[0-9]|1[0-2])/),b.hour));a.H=c.cache(c.process(c.rtoken(/^([0-1][0-9]|2[0-3]|[0-9])/),b.hour));a.HH=c.cache(c.process(c.rtoken(/^([0-1][0-9]|2[0-3])/),b.hour));a.m=c.cache(c.process(c.rtoken(/^([0-5][0-9]|[0-9])/),b.minute));a.mm=c.cache(c.process(c.rtoken(/^[0-5][0-9]/),b.minute));
a.s=c.cache(c.process(c.rtoken(/^([0-5][0-9]|[0-9])/),b.second));a.ss=c.cache(c.process(c.rtoken(/^[0-5][0-9]/),b.second));a["ss.s"]=c.cache(c.process(c.rtoken(/^[0-5][0-9]\.[0-9]{1,3}/),b.secondAndMillisecond));a.hms=c.cache(c.sequence([a.H,a.m,a.s],a.timePartDelimiter));a.t=c.cache(c.process(a.ctoken2("shortMeridian"),b.meridian));a.tt=c.cache(c.process(a.ctoken2("longMeridian"),b.meridian));a.z=c.cache(c.process(c.rtoken(/^((\+|\-)\s*\d\d\d\d)|((\+|\-)\d\d\:?\d\d)/),b.timezone));a.zz=c.cache(c.process(c.rtoken(/^((\+|\-)\s*\d\d\d\d)|((\+|\-)\d\d\:?\d\d)/),
b.timezone));a.zzz=c.cache(c.process(a.ctoken2("timezone"),b.timezone));a.timeSuffix=c.each(c.ignore(a.whiteSpace),c.set([a.tt,a.zzz]));a.time=c.each(c.optional(c.ignore(c.stoken("T"))),a.hms,a.timeSuffix);a.d=c.cache(c.process(c.each(c.rtoken(/^([0-2]\d|3[0-1]|\d)/),c.optional(a.ctoken2("ordinalSuffix"))),b.day));a.dd=c.cache(c.process(c.each(c.rtoken(/^([0-2]\d|3[0-1])/),c.optional(a.ctoken2("ordinalSuffix"))),b.day));a.ddd=a.dddd=c.cache(c.process(a.ctoken("sun mon tue wed thu fri sat"),function(a){return function(){this.weekday=
a}}));a.M=c.cache(c.process(c.rtoken(/^(1[0-2]|0\d|\d)/),b.month));a.MM=c.cache(c.process(c.rtoken(/^(1[0-2]|0\d)/),b.month));a.MMM=a.MMMM=c.cache(c.process(a.ctoken("jan feb mar apr may jun jul aug sep oct nov dec"),b.month));a.y=c.cache(c.process(c.rtoken(/^(\d\d?)/),b.year));a.yy=c.cache(c.process(c.rtoken(/^(\d\d)/),b.year));a.yyy=c.cache(c.process(c.rtoken(/^(\d\d?\d?\d?)/),b.year));a.yyyy=c.cache(c.process(c.rtoken(/^(\d\d\d\d)/),b.year));e=function(){return c.each(c.any.apply(null,arguments),
c.not(a.ctoken2("timeContext")))};a.day=e(a.d,a.dd);a.month=e(a.M,a.MMM);a.year=e(a.yyyy,a.yy);a.orientation=c.process(a.ctoken("past future"),function(a){return function(){this.orient=a}});a.operator=c.process(a.ctoken("add subtract"),function(a){return function(){this.operator=a}});a.rday=c.process(a.ctoken("yesterday tomorrow today now"),b.rday);a.unit=c.process(a.ctoken("second minute hour day week month year"),function(a){return function(){this.unit=a}});a.value=c.process(c.rtoken(/^([-+]?\d+)?(st|nd|rd|th)?/),
function(a){return function(){this.value=a.replace(/\D/g,"")}});a.expression=c.set([a.rday,a.operator,a.value,a.unit,a.orientation,a.ddd,a.MMM]);e=function(){return c.set(arguments,a.datePartDelimiter)};a.mdy=e(a.ddd,a.month,a.day,a.year);a.ymd=e(a.ddd,a.year,a.month,a.day);a.dmy=e(a.ddd,a.day,a.month,a.year);a.date=function(b){return(a[Date.CultureInfo.dateElementOrder]||a.mdy).call(this,b)};a.format=c.process(c.many(c.any(c.process(c.rtoken(/^(dd?d?d?(?!e)|MM?M?M?|yy?y?y?|hh?|HH?|mm?|ss?|tt?|zz?z?)/),
function(b){if(a[b])return a[b];throw f.Parsing.Exception(b);}),c.process(c.rtoken(/^[^dMyhHmstz]+/),function(a){return c.ignore(c.stoken(a))}))),function(a){return c.process(c.each.apply(null,a),b.finishExact)});var d={},l=function(b){d[b]=d[b]||a.format(b)[0];return d[b]};a.allformats=function(a){var b=[];if(a instanceof Array)for(var c=0;c<a.length;c++)b.push(l(a[c]));else b.push(l(a));return b};a.formats=function(a){if(a instanceof Array){for(var b=[],d=0;d<a.length;d++)b.push(l(a[d]));return c.any.apply(null,
b)}return l(a)};a._formats=a.formats('"yyyy-MM-ddTHH:mm:ssZ";yyyy-MM-ddTHH:mm:ss.sz;yyyy-MM-ddTHH:mm:ssZ;yyyy-MM-ddTHH:mm:ssz;yyyy-MM-ddTHH:mm:ss;yyyy-MM-ddTHH:mmZ;yyyy-MM-ddTHH:mmz;yyyy-MM-ddTHH:mm;ddd, MMM dd, yyyy H:mm:ss tt;ddd MMM d yyyy HH:mm:ss zzz;MMddyyyy;ddMMyyyy;Mddyyyy;ddMyyyy;Mdyyyy;dMyyyy;yyyy;Mdyy;dMyy;d'.split(";"));a._start=c.process(c.set([a.date,a.time,a.expression],a.generalDelimiter,a.whiteSpace),b.finish);a.start=function(b){try{var c=a._formats.call({},b);if(0===c[1].length)return c}catch(d){}return a._start.call({},
b)};f._parse||(f._parse=f.parse);f.parse=function(a){var b,c,d=null;if(!a)return null;if(a instanceof Date)return a.clone();4<=a.length&&"0"!==a.charAt(0)&&"+"!==a.charAt(0)&&"-"!==a.charAt(0)&&(b=f.Parsing.ISO.parse(a)||f.Parsing.Numeric.parse(a));if(b instanceof Date&&!isNaN(b.getTime()))return b;a=(b=a.match(/\b(\d+)(?:st|nd|rd|th)\b/))&&2===b.length?a.replace(b[0],b[1]):a;a=f.Parsing.Normalizer.parse(a);try{d=f.Grammar.start.call({},a.replace(/^\s*(\S*(\s+\S+)*)\s*$/,"$1"))}catch(e){return null}b=
0===d[1].length?d[0]:null;if(null!==b)return b;try{return(c=Date._parse(a))||0===c?new Date(c):null}catch(g){return null}};Date.getParseFunction=function(a){var b=Date.Grammar.allformats(a);return function(a){for(var c=null,d=0;d<b.length;d++){try{c=b[d].call({},a)}catch(e){continue}if(0===c[1].length)return c[0]}return null}};f.parseExact=function(a,b){return f.getParseFunction(b)(a)}})();
(function(){var f=Date,g=f.prototype,c=Number.prototype;g._orient=1;g._nth=null;g._is=!1;g._same=!1;g._isSecond=!1;c._dateElement="days";g.next=function(){this._move=!0;this._orient=1;return this};f.next=function(){return f.today().next()};g.last=g.prev=g.previous=function(){this._move=!0;this._orient=-1;return this};f.last=f.prev=f.previous=function(){return f.today().last()};g.is=function(){this._is=!0;return this};g.same=function(){this._same=!0;this._isSecond=!1;return this};g.today=function(){return this.same().day()};
g.weekday=function(){return this._nth?l("Weekday").call(this):this._move?this.addWeekdays(this._orient):this._is?(this._is=!1,!this.is().sat()&&!this.is().sun()):!1};g.weekend=function(){return this._is?(this._is=!1,this.is().sat()||this.is().sun()):!1};g.at=function(a){return"string"===typeof a?f.parse(this.toString("d")+" "+a):this.set(a)};c.fromNow=c.after=function(a){var b={};b[this._dateElement]=this;return(a?a.clone():new Date).add(b)};c.ago=c.before=function(a){var b={};b["s"!==this._dateElement[this._dateElement.length-
1]?this._dateElement+"s":this._dateElement]=-1*this;return(a?a.clone():new Date).add(b)};var a="sunday monday tuesday wednesday thursday friday saturday".split(/\s/),b="january february march april may june july august september october november december".split(/\s/),e="Millisecond Second Minute Hour Day Week Month Year Quarter Weekday".split(/\s/),q="Milliseconds Seconds Minutes Hours Date Week Month FullYear Quarter".split(/\s/),d="final first second third fourth fifth".split(/\s/);g.toObject=function(){for(var a=
{},b=0;b<e.length;b++)this["get"+q[b]]&&(a[e[b].toLowerCase()]=this["get"+q[b]]());return a};f.fromObject=function(a){a.week=null;return Date.today().set(a)};for(var l=function(a){return function(){if(this._is)return this._is=!1,this.getDay()===a;this._move&&(this._move=null);if(null!==this._nth){this._isSecond&&this.addSeconds(-1*this._orient);this._isSecond=!1;var b=this._nth;this._nth=null;var c=this.clone().moveToLastDayOfMonth();this.moveToNthOccurrence(a,b);if(this>c)throw new RangeError(f.getDayName(a)+
" does not occur "+b+" times in the month of "+f.getMonthName(c.getMonth())+" "+c.getFullYear()+".");return this}return this.moveToDayOfWeek(a,this._orient)}},h=function(a){return function(){var b=f.today(),c=a-b.getDay();0===a&&1===Date.CultureInfo.firstDayOfWeek&&0!==b.getDay()&&(c+=7);return b.addDays(c)}},k=0;k<a.length;k++)f[a[k].toUpperCase()]=f[a[k].toUpperCase().substring(0,3)]=k,f[a[k]]=f[a[k].substring(0,3)]=h(k),g[a[k]]=g[a[k].substring(0,3)]=l(k);a=function(a){return function(){return this._is?
(this._is=!1,this.getMonth()===a):this.moveToMonth(a,this._orient)}};h=function(a){return function(){return f.today().set({month:a,day:1})}};for(k=0;k<b.length;k++)f[b[k].toUpperCase()]=f[b[k].toUpperCase().substring(0,3)]=k,f[b[k]]=f[b[k].substring(0,3)]=h(k),g[b[k]]=g[b[k].substring(0,3)]=a(k);a=function(a){return function(b){if(this._isSecond)return this._isSecond=!1,this;if(this._same){this._same=this._is=!1;var c=this.toObject();b=(b||new Date).toObject();for(var d="",f=a.toLowerCase(),f="s"===
f[f.length-1]?f.substring(0,f.length-1):f,g=e.length-1;-1<g;g--){d=e[g].toLowerCase();if(c[d]!==b[d])return!1;if(f===d)break}return!0}"s"!==a.substring(a.length-1)&&(a+="s");this._move&&(this._move=null);return this["add"+a](this._orient)}};h=function(a){return function(){this._dateElement=a;return this}};for(k=0;k<e.length;k++)b=e[k].toLowerCase(),"weekday"!==b&&(g[b]=g[b+"s"]=a(e[k]),c[b]=c[b+"s"]=h(b+"s"));g._ss=a("Second");c=function(a){return function(b){if(this._same)return this._ss(b);if(b||
0===b)return this.moveToNthOccurrence(b,a);this._nth=a;return 2!==a||void 0!==b&&null!==b?this:(this._isSecond=!0,this.addSeconds(this._orient))}};for(b=0;b<d.length;b++)g[d[b]]=0===b?c(-1):c(b)})();
(function(){var f=Date,g=f.prototype,c=[],a=function(a,c){c||(c=2);return("000"+a).slice(-1*c)};f.normalizeFormat=function(a){return a};f.strftime=function(a,c){return(new Date(1E3*c)).$format(a)};f.strtotime=function(a){a=f.parse(a);a.addMinutes(-1*a.getTimezoneOffset());return Math.round(f.UTC(a.getUTCFullYear(),a.getUTCMonth(),a.getUTCDate(),a.getUTCHours(),a.getUTCMinutes(),a.getUTCSeconds(),a.getUTCMilliseconds())/1E3)};g.$format=function(b){var e=this,g,d=function(a,b){c.push(a);return e.toString(a,
b)};return b?b.replace(/(%|\\)?.|%%/g,function(b){if("\\"===b.charAt(0)||"%%"===b.substring(0,2))return b.replace("\\","").replace("%%","%");switch(b){case "d":case "%d":return d("dd");case "D":case "%a":return d("ddd");case "j":case "%e":return d("d",!0);case "l":case "%A":return d("dddd");case "N":case "%u":return e.getDay()+1;case "S":return d("S");case "w":case "%w":return e.getDay();case "z":return e.getOrdinalNumber();case "%j":return a(e.getOrdinalNumber(),3);case "%U":b=e.clone().set({month:0,
day:1}).addDays(-1).moveToDayOfWeek(0);var h=e.clone().addDays(1).moveToDayOfWeek(0,-1);return h<b?"00":a((h.getOrdinalNumber()-b.getOrdinalNumber())/7+1);case "W":case "%V":return e.getISOWeek();case "%W":return a(e.getWeek());case "F":case "%B":return d("MMMM");case "m":case "%m":return d("MM");case "M":case "%b":case "%h":return d("MMM");case "n":return d("M");case "t":return f.getDaysInMonth(e.getFullYear(),e.getMonth());case "L":return f.isLeapYear(e.getFullYear())?1:0;case "o":case "%G":return e.setWeek(e.getISOWeek()).toString("yyyy");
case "%g":return e.$format("%G").slice(-2);case "Y":case "%Y":return d("yyyy");case "y":case "%y":return d("yy");case "a":case "%p":return d("tt").toLowerCase();case "A":return d("tt").toUpperCase();case "g":case "%I":return d("h");case "G":return d("H");case "h":return d("hh");case "H":case "%H":return d("HH");case "i":case "%M":return d("mm");case "s":case "%S":return d("ss");case "u":return a(e.getMilliseconds(),3);case "I":return e.isDaylightSavingTime()?1:0;case "O":return e.getUTCOffset();case "P":return g=
e.getUTCOffset(),g.substring(0,g.length-2)+":"+g.substring(g.length-2);case "e":case "T":case "%z":case "%Z":return e.getTimezone();case "Z":return-60*e.getTimezoneOffset();case "B":return b=new Date,Math.floor((3600*b.getHours()+60*b.getMinutes()+b.getSeconds()+60*(b.getTimezoneOffset()+60))/86.4);case "c":return e.toISOString().replace(/\"/g,"");case "U":return f.strtotime("now");case "%c":return d("d")+" "+d("t");case "%C":return Math.floor(e.getFullYear()/100+1);case "%D":return d("MM/dd/yy");
case "%n":return"\\n";case "%t":return"\\t";case "%r":return d("hh:mm tt");case "%R":return d("H:mm");case "%T":return d("H:mm:ss");case "%x":return d("d");case "%X":return d("t");default:return c.push(b),b}}):this._toString()};g.format||(g.format=g.$format)})();
var TimeSpan=function(f,g,c,a,b){for(var e="days hours minutes seconds milliseconds".split(/\s+/),q=function(a){return function(){return this[a]}},d=function(a){return function(b){this[a]=b;return this}},l=0;l<e.length;l++){var h=e[l],k=h.slice(0,1).toUpperCase()+h.slice(1);TimeSpan.prototype[h]=0;TimeSpan.prototype["get"+k]=q(h);TimeSpan.prototype["set"+k]=d(h)}4===arguments.length?(this.setDays(f),this.setHours(g),this.setMinutes(c),this.setSeconds(a)):5===arguments.length?(this.setDays(f),this.setHours(g),
this.setMinutes(c),this.setSeconds(a),this.setMilliseconds(b)):1===arguments.length&&"number"===typeof f&&(e=0>f?-1:1,this.setMilliseconds(Math.abs(f)),this.setDays(Math.floor(this.getMilliseconds()/864E5)*e),this.setMilliseconds(this.getMilliseconds()%864E5),this.setHours(Math.floor(this.getMilliseconds()/36E5)*e),this.setMilliseconds(this.getMilliseconds()%36E5),this.setMinutes(Math.floor(this.getMilliseconds()/6E4)*e),this.setMilliseconds(this.getMilliseconds()%6E4),this.setSeconds(Math.floor(this.getMilliseconds()/
1E3)*e),this.setMilliseconds(this.getMilliseconds()%1E3),this.setMilliseconds(this.getMilliseconds()*e));this.getTotalMilliseconds=function(){return 864E5*this.getDays()+36E5*this.getHours()+6E4*this.getMinutes()+1E3*this.getSeconds()};this.compareTo=function(a){var b=new Date(1970,1,1,this.getHours(),this.getMinutes(),this.getSeconds());a=null===a?new Date(1970,1,1,0,0,0):new Date(1970,1,1,a.getHours(),a.getMinutes(),a.getSeconds());return b<a?-1:b>a?1:0};this.equals=function(a){return 0===this.compareTo(a)};
this.add=function(a){return null===a?this:this.addSeconds(a.getTotalMilliseconds()/1E3)};this.subtract=function(a){return null===a?this:this.addSeconds(-a.getTotalMilliseconds()/1E3)};this.addDays=function(a){return new TimeSpan(this.getTotalMilliseconds()+864E5*a)};this.addHours=function(a){return new TimeSpan(this.getTotalMilliseconds()+36E5*a)};this.addMinutes=function(a){return new TimeSpan(this.getTotalMilliseconds()+6E4*a)};this.addSeconds=function(a){return new TimeSpan(this.getTotalMilliseconds()+
1E3*a)};this.addMilliseconds=function(a){return new TimeSpan(this.getTotalMilliseconds()+a)};this.get12HourHour=function(){return 12<this.getHours()?this.getHours()-12:0===this.getHours()?12:this.getHours()};this.getDesignator=function(){return 12>this.getHours()?Date.CultureInfo.amDesignator:Date.CultureInfo.pmDesignator};this.toString=function(a){this._toString=function(){return null!==this.getDays()&&0<this.getDays()?this.getDays()+"."+this.getHours()+":"+this.p(this.getMinutes())+":"+this.p(this.getSeconds()):
this.getHours()+":"+this.p(this.getMinutes())+":"+this.p(this.getSeconds())};this.p=function(a){return 2>a.toString().length?"0"+a:a};var b=this;return a?a.replace(/dd?|HH?|hh?|mm?|ss?|tt?/g,function(a){switch(a){case "d":return b.getDays();case "dd":return b.p(b.getDays());case "H":return b.getHours();case "HH":return b.p(b.getHours());case "h":return b.get12HourHour();case "hh":return b.p(b.get12HourHour());case "m":return b.getMinutes();case "mm":return b.p(b.getMinutes());case "s":return b.getSeconds();
case "ss":return b.p(b.getSeconds());case "t":return(12>b.getHours()?Date.CultureInfo.amDesignator:Date.CultureInfo.pmDesignator).substring(0,1);case "tt":return 12>b.getHours()?Date.CultureInfo.amDesignator:Date.CultureInfo.pmDesignator}}):this._toString()};return this};Date.prototype.getTimeOfDay=function(){return new TimeSpan(0,this.getHours(),this.getMinutes(),this.getSeconds(),this.getMilliseconds())};
var TimePeriod=function(f,g,c,a,b,e,q){for(var d="years months days hours minutes seconds milliseconds".split(/\s+/),l=function(a){return function(){return this[a]}},h=function(a){return function(b){this[a]=b;return this}},k=0;k<d.length;k++){var m=d[k],n=m.slice(0,1).toUpperCase()+m.slice(1);TimePeriod.prototype[m]=0;TimePeriod.prototype["get"+n]=l(m);TimePeriod.prototype["set"+n]=h(m)}if(7===arguments.length)this.years=f,this.months=g,this.setDays(c),this.setHours(a),this.setMinutes(b),this.setSeconds(e),
this.setMilliseconds(q);else if(2===arguments.length&&arguments[0]instanceof Date&&arguments[1]instanceof Date){d=f.clone();l=g.clone();h=d.clone();k=d>l?-1:1;this.years=l.getFullYear()-d.getFullYear();h.addYears(this.years);1===k?h>l&&0!==this.years&&this.years--:h<l&&0!==this.years&&this.years++;d.addYears(this.years);if(1===k)for(;d<l&&d.clone().addMonths(1)<=l;)d.addMonths(1),this.months++;else for(;d>l&&d.clone().addDays(-d.getDaysInMonth())>l;)d.addMonths(-1),this.months--;d=l-d;0!==d&&(d=new TimeSpan(d),
this.setDays(d.getDays()),this.setHours(d.getHours()),this.setMinutes(d.getMinutes()),this.setSeconds(d.getSeconds()),this.setMilliseconds(d.getMilliseconds()))}return this};
