<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('authAspirante.login');
});


Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

Route::middleware(['auth'])->group(function () {
	//Roles
	Route::post('roles/store', 'RoleController@store')->name('roles.store')
		->middleware('permission:roles.create');

	Route::get('roles', 'RoleController@index')->name('roles.index')
		->middleware('permission:roles.index');

	Route::get('roles/create', 'RoleController@create')->name('roles.create')
		->middleware('permission:roles.create');

	Route::put('roles/{role}', 'RoleController@update')->name('roles.update')
		->middleware('permission:roles.edit');

	Route::get('roles/{role}', 'RoleController@show')->name('roles.show')
		->middleware('permission:roles.show');

	Route::delete('roles/{role}', 'RoleController@destroy')->name('roles.destroy')
		->middleware('permission:roles.destroy');

	Route::get('roles/{role}/edit', 'RoleController@edit')->name('roles.edit')
		->middleware('permission:roles.edit');
	//Users
	Route::resource('users', 'UserController');
	Route::resource('nucleosAgsinados', 'AgsinarNucleoController');
	Route::get('get-nucleos','UserController@getnucleos')->name('get-nucleos');
	Route::get('Aspirante','UserController@getaspirante')->name('aspiante');
	Route::POST('Aspirante/Update','UserController@getaspiranteAct')->name('aspiranteAct');
	Route::get('ReporteConsulta', 'UserController@AspiConsulta')->name('ReporteConsulta.Aspirante');
	Route::delete('AspiUser', 'UserController@eliminarAspirantes')->name('AspiUser.destroy');

	Route::get('Aspirante/Pasado', 'UserController@PeridoPasado')->name('Aspirante.Pasado');
	Route::get('Aspirante/Pasado/list', 'UserController@AspiPasadoList')->name('Aspirante.Pasadolist');
	Route::POST('Aspirante/Pasado/store', 'UserController@PeridoPasadoStore')->name('no_Aptos.store');


	//RUTAS PARA ELIMINAR ASPIRANTES CON DATOS VACIOS
	Route::get('ReporteConsulta', 'UserController@AspiConsulta')->name('ReporteConsulta.Aspirante');
	Route::delete('AspiUser', 'UserController@eliminarAspirantes')->name('AspiUser.destroy');

	//Ofertas
	Route::resource('ofertas', 'OfertaController');
	Route::get('get-cupos','OfertaController@getTipoIngreso')->name('get-cupos');	
	Route::get('Program/{id}','OfertaController@getprogramas');
	Route::get('mensionn/{programaId}/{institutoId}','OfertaController@getsubprogramas');
	Route::get('programaoferta/{institutoId}','OfertaController@programasget');
	Route::get('mensionoferta/{programasId}/{institutoId}','OfertaController@getMension');
	//Route::POST('/store', 'OfertaController@checkbox')->name('store');
	Route::get('oferta/Consulta', 'OfertaController@consultaAprobacion')->name('ofertas.consultaAprobacion')
		->middleware('permission:ofertas.consultaAprobacion');

	Route::POST('oferta/aprobar', 'OfertaController@Aprobar')->name('ofertas.aprobar');
		
	Route::get('oferta/desaprobar', 'OfertaController@ofertasdesaprobadas')->name('ofertas.desAprobarindex');
		
	Route::POST('oferta/desaprobar', 'OfertaController@desAprobar')->name('ofertas.desaprobar');

	//reporte oferta

	Route::get('oferta', 'OfertaController@oferta')->name('oferta.reporte');

	Route::get('oferta/export', 'OfertaController@ofertaExport')->name('oferta.export');


	//Especialidad
	Route::resource('Especialidad', 'EspecialidadController');
	Route::get('get-subprograma','EspecialidadController@getsubprogramas')->name('get-subprograma');
	Route::get('programa/{id}','EspecialidadController@getprograma');
	
	Route::resource('NuevaEspecialidad','CrearEspecialidadController');
	
	
	route::get('desactivar','EspecialidadController@deactivateEspe')->name('deactivate');
	
	Route::POST('deactivate/list', 'EspecialidadController@inavilitar')->name('inavilitar');
	Route::get('modoingre/{id}','EspecialidadController@modoingreget');
	//Route::get('programasEspecialidad/{institutoId}/{modoingreId}','EspecialidadController@programasget');
	Route::get('programasEspecialidad/{institutoId}','EspecialidadController@programasget');
	Route::get('mension/{programasId}/{institutoId}','EspecialidadController@getMension');
	
	route::get('CambioPrograma/index','EspecialidadController@Cambioprograma')->name('Cambioprograma.index');
	route::POST('Cambio/Programa/Aptos', 'EspecialidadController@CambioProgramaEUpdateee')->name('Cambiar.Aptoss');

//Periodo

	Route::resource('periodo','PeriodoController');

//Reportes Charts
	Route::resource('charts','DeshboardController');
	route::get('listall/{page?}','DeshboardController@listall')->name('listall');
	route::get('Datos/{page?}','DeshboardController@datosIncompleto')->name('Datos');
// Reporte Excel

Route::get('ReporteExcel', function()
{
	return (new UsersExports)->download('products.xlsx');
});



});
Route::get('consulta', 'ExcelController@index')->name('consulta.index');

Route::get('InscritosInternet', 'ExcelController@totalReg')->name('InscritosInternet.totalAsp');
Route::get('InscritosInternet/export', 'ExcelController@totalRegAspi')->name('InscritosInternet.export');

Route::get('InscritosInternet/lista', 'ExcelController@totalRegistrados')->name('InscritosInternet.lista');

//ASPIRANTES REGISTRADOS
Route::get('AspRegister/export', 'ExcelController@AspRegister')->name('AspRegister.export');
Route::get('AspRegistrados/list', 'ExcelController@listaspiregistrados')->name('AspRegister.list');
Route::get('ReportePost', 'ExcelController@ApirantePostgrado')->name('ReportePost.Aspirante');
Route::get('aspReg/export', 'ExcelController@AspirantesReg')->name('aspReg.export');




//

Route::get('aspirantesCupo', 'ExcelController@aspirantesCupo')->name('aspirantesCupo.AspCupo');



Route::get('aspirantesCupo/export', 'ExcelController@totalcuposAspi')->name('aspirantesCupo.export');



Route::get('consulta/export', 'ExcelController@excel')->name('consulta.export');

Route::get('Exportar', 'ExcelController@AspiranteReporte')->name('Exportar.AspiranteReporte');


Route::get('modoingreReport/{id}','ExcelController@modoingregetreport');
Route::get('programas/{institutoId}/{modoingreId}','ExcelController@programasget');
Route::get('Especialidades/{modoingreId}/{programasId}/{institutoId}','ExcelController@getMension');



Route::resource('Postgrado','PostgradosystemController');
Route::get('EspecialidadesPost/{institutoId}','PostgradosystemController@getEspecialidadd');
Route::get('validarcertificado', 'PostgradosystemController@MigrarAspiPostgrado')->name('validarcertificado');


























Route::prefix('Aspirante')->group(function(){ 

	Route::get('/login', 'Auth\AspiranteLoginController@showLoginForm')->name('Aspirante.login');
	
	Route::get('/listas', 'Auth\AspiranteLoginController@viewlistasOfertas')->name('Aspirante.lista');
	
	Route::post('/login', 'Auth\AspiranteLoginController@login')->name('Aspirante.login.submit');
	Route::get('/register','Auth\AspiranteRegisterController@showRegistrationForm')->name('Aspirante.registrar');
	
	
	Route::post('/register','Auth\AspiranteRegisterController@register')->name('Aspirante.registrar');
	
	Route::get('/register/verify/{code}', 'Auth\AspiranteRegisterController@verify');	
	//Route::get('/Aspirante', 'DatosAspiranteController@index')->name('Aspirante');
	//PASSWORD RESET
	Route::post('/password/email','Auth\AspiranteForgotPasswordController@sendResetLinkEmail')->name('Aspirante.password.email');
	
	Route::get('/password/reset','Auth\AspiranteForgotPasswordController@showLinkRequestForm')->name('Aspirante.password.request');
	
	Route::post('/password/reset','Auth\AspiranteResetPasswordController@reset');
	
	Route::get('/password/reset/{token}','Auth\AspiranteResetPasswordController@showResetForm')->name('Aspirante.password.reset');
	
		Route::get('/Perfil', 'AvatarAspiranteController@profile');
	Route::post('/Perfil', 'AvatarAspiranteController@update_avatar');
	
		
	
	});


Route::resource('DatosAspirante','DatosAspiranteController');

Route::resource('Datosbasicos','DepositoController');
Route::get('editDatBasicos/{id}','DepositoController@geteditDatBasicos')->name('editDatBasicos');
Route::put('datosBasicos/{id}','DepositoController@getUpdateDatBasicos')->name('datosBasicos');
Route::get('editDatBasicos/{id}','DepositoController@geteditDatBasicos')->name('editDatBasicos');
Route::get('programas/{ingresoId}/{sedeId}','DepositoController@getprogramas');
Route::get('EspecialidadesMension/{ingresoId}/{id}/{institutoId}','DepositoController@Subprogramas');

//Route::get('especialiadad','DepositoController@getSubprogramas')->name('especialiadad');

Route::get('/RegistroIngreso','DepositoController@FormDatBasicos')->name('get-FormDatBasicos');
Route::get('/Seleccione/{id}','DepositoController@datBasicos')->name('get-datosbasicos');

Route::get('get-cursos','DepositoController@getSubprogramas')->name('get-cursos');
Route::get('NuevoIngreso/{id}','DepositoController@getNuevoIngreso');

Route::resource('listas', 'OfertaAprobadasController');

Route::resource('DatosAcademicos','AcademicoController');
Route::get('Academico','AcademicoController@getAcademicoUser')->name('Academico');
Route::POST('/store','AcademicoController@Createguardar')->name('create-store');


Route::resource('Experiencia','ExpeLaboralController');
Route::POST('/ExpStore','ExpeLaboralController@CreateExp')->name('create-Exp');


Route::resource('Diagnostico','diagnosticoController');

Route::get('vocacional/{id}','diagnosticoController@getresolver')->name('vocacional');

Route::resource('SocioEconomico','SocioEconomicoController');
Route::get('editMadre/{id}','SocioEconomicoController@getEditMadre')->name('editMadre');
Route::put('Economico/{id}','SocioEconomicoController@getEditUpdate')->name('Economico');

Route::get('corregir/{padre}','SocioEconomicoController@getEditPadre')->name('corregir');
Route::put('PadreUpdate/{id}','SocioEconomicoController@getUpdatePadre')->name('PadreUpdate');

Route::get('FuenteIngreso/{id}','SocioEconomicoController@getEditFuenteI')->name('FuenteIngreso');
Route::put('IngresoUpdate/{id}','SocioEconomicoController@getUpdateFuenteI')->name('IngresoUpdate');

Route::get('NivelIngreso/{id}','SocioEconomicoController@getEditNivelI')->name('NivelIngreso');
Route::put('NivelIngreso/{id}','SocioEconomicoController@getUpdateNivelI')->name('NivelIngreso');

Route::get('Condicones/{id}','SocioEconomicoController@getEditCondiciones')->name('Condicones');
Route::put('Condicones/{id}','SocioEconomicoController@getUpdateCondiciones')->name('Condicones');

Route::get('Traslado/{id}','SocioEconomicoController@getEditTraslado')->name('Traslado');
Route::put('Traslado/{id}','SocioEconomicoController@getUpdateTraslado')->name('Traslado');

Route::get('N°Hijos/{id}','SocioEconomicoController@getEditHijos')->name('N°Hijos');
Route::put('N°Hijos/{id}','SocioEconomicoController@getUpdaHijos')->name('N°Hijos');

Route::get('CosteoPostgrado/{id}','SocioEconomicoController@getEditCosteoPost')->name('CosteoPostgrado');
Route::put('CosteoPostgrado/{id}','SocioEconomicoController@getUpdaCosteoPost')->name('CosteoPostgrado');

//Route::get('get-sede','DepositoController@getsede')->name('get-sede');




//Route::get('get-especialidad','DepositoController@getEspecialidad')->name('get-especialidad');
//Route::get('get-programas','DepositoController@getProgramas')->name('get-programas');
Route::get('get-Estado','DatosAspiranteController@getEstado')->name('get-Estado');

Route::get('get-Parroquias','DatosAspiranteController@getParroquias')->name('get-Parroquias');

Route::get('get-Municipios','DatosAspiranteController@getMunicipios')->name('get-Municipios');



Route::get('Reporte','PDFController@index');
Auth::routes();

//Route::get('/home', 'HomeController@index')->name('home');

Route::get('veReporte',array(
    'as'=>'veReporte',
    'uses'=>'PDFController@veReporte'
));

Route::get('reporte',array(
    'as'=>'vistaHTMLPDF',
    'uses'=>'PDFController@vistaHTMLPDF'
));

Route::get('planillapdf',array(
    'as'=>'modingresos',
    'uses'=>'DatosAspiranteController@modingresos'
));
