/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.6.24-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: admision_sige_bdrectorado
-- ------------------------------------------------------
-- Server version	10.6.24-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `EspecialidadToda`
--

DROP TABLE IF EXISTS `EspecialidadToda`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `EspecialidadToda` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `programa_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ACB064F920332D99` (`codigo`),
  KEY `IDX_ACB064F9FD8A7328` (`programa_id`),
  KEY `IDX_ACB064F9E19F41BF` (`sede_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `EspecialidadToda`
--

LOCK TABLES `EspecialidadToda` WRITE;
/*!40000 ALTER TABLE `EspecialidadToda` DISABLE KEYS */;
INSERT INTO `EspecialidadToda` VALUES (1,1,1,'AES','Artes Escénicas'),(2,1,1,'APL','Artes Plásticas'),(3,1,1,'BIO','Biología'),(4,1,1,'CTI','Ciencias de la Tierra'),(5,1,1,'DTE','Dibujo Técnico'),(6,1,1,'EAG','Educación Agropecuaria'),(7,1,1,'ECO','Educación Comercial'),(8,1,1,'EFI','Educación Física'),(9,1,1,'EIB','Educación Intercultural Bilingue'),(10,1,1,'EDP','Educación Primaria'),(11,1,1,'EMU','Educación Musical'),(12,1,1,'EDI','Educación Inicial'),(13,1,1,'ERU','Educación Rural'),(14,1,1,'ETI','Electricidad Industrial'),(15,1,1,'ETO','Electrónica Industrial'),(16,1,1,'FIS','Física'),(17,1,1,'FRA','Francés como Lengua Extranjera'),(18,1,1,'GHI','Geografia e Historia'),(19,1,1,'INF','Educación Informática'),(20,1,1,'ING','Inglés como Lengua Extranjera'),(21,1,1,'LLI','Lengua y Literatura'),(22,1,1,'MAT','Matemática'),(23,1,1,'MIN','Mecánica Industrial'),(24,1,1,'ESP','Educación Socioproductiva'),(25,1,1,'QUI','Química'),(26,1,1,'LEX','Lenguas Extranjeras'),(27,1,1,'EES','Educación Especial para Sordos'),(28,1,1,'DID','Educación Especial para Personas con Discapacidad Intelectual y del Desarrollo'),(29,1,1,'PSD','Educación Especial para Personas en Situación en Discapacidad');
/*!40000 ALTER TABLE `EspecialidadToda` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `RecibosPago`
--

DROP TABLE IF EXISTS `RecibosPago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `RecibosPago` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `codigo_recibo` varchar(30) NOT NULL,
  `fecha` datetime NOT NULL,
  `tipo_pago` varchar(30) NOT NULL,
  `nro_operacion` varchar(50) NOT NULL,
  `cedula` varchar(12) NOT NULL,
  `concepto` varchar(255) NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `lapso` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_F881498C59590C39` (`estudiante_id`),
  CONSTRAINT `FK_F881498C59590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `estudiante` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `RecibosPago`
--

LOCK TABLES `RecibosPago` WRITE;
/*!40000 ALTER TABLE `RecibosPago` DISABLE KEYS */;
/*!40000 ALTER TABLE `RecibosPago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ambiente`
--

DROP TABLE IF EXISTS `ambiente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ambiente` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cod_ambiente` varchar(255) NOT NULL,
  `descripcion` varchar(255) NOT NULL,
  `vigente` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=350 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ambiente`
--

LOCK TABLES `ambiente` WRITE;
/*!40000 ALTER TABLE `ambiente` DISABLE KEYS */;
INSERT INTO `ambiente` VALUES (1,'pasig','Por Asignar','1'),(2,'None','286-280','1'),(3,'002','242-B O  LAB','1'),(4,'003','217-O','1'),(5,'004','220 O','1'),(6,'005','252 O','1'),(7,'006','277 O','1'),(8,'007','278 O','1'),(9,'008','162 E','1'),(10,'009','234 O','1'),(11,'010','031 O LAB','1'),(12,'011','230 O','1'),(13,'012','167 E','1'),(14,'013','159 E','1'),(15,'014','210 E LAB','1'),(16,'015','163 E','1'),(17,'016','152 E','1'),(18,'017','154 E','1'),(19,'018','30','0'),(20,'019','35','0'),(21,'020','28','0'),(22,'021','43','0'),(23,'022','212 E','1'),(24,'023','210','0'),(25,'024','203 E','1'),(26,'025','226 E LAB','1'),(27,'026','204 E','1'),(28,'027','307 O','1'),(29,'028','327 O','1'),(30,'029','029 O','0'),(31,'030','335 O','1'),(32,'031','031 O','1'),(33,'032','329 O','1'),(34,'033','314 O','1'),(35,'034','315 O','1'),(36,'035','035 O','1'),(37,'036','165 E','1'),(38,'037','161 E','1'),(39,'038','370 O','1'),(40,'373 O','373 O','1'),(41,'039','371 O','1'),(42,'040','260 O','1'),(43,'041','272 O','1'),(44,'042','273 O lab','1'),(45,'043','241 O','1'),(46,'053','261 O','1'),(47,'054','262 O','1'),(48,'055','274 O','1'),(49,'057','376 O','1'),(50,'058','377 O','1'),(51,'059','380 O','1'),(52,'060','378 O','1'),(53,'061','386 O Sala Prof. CsSoc','1'),(54,'062','312 O','1'),(55,'063','313 O','1'),(56,'064','316 O','1'),(57,'066','319 O LAB','1'),(58,'067','320 O LAB','1'),(59,'070','322 O LAB','1'),(60,'071','323 O LAB','1'),(61,'074','324 O LAB','1'),(62,'076','325 O','1'),(63,'077','326 O LAB','1'),(64,'078','328 O LAB','1'),(65,'079','330 O LAB','1'),(66,'080','30 O  EF','1'),(67,'081','35  O EF','1'),(68,'083','28 O  EF','1'),(69,'084','43 O EF','1'),(70,'085','31 O  EF','1'),(71,'086','27 O  EF','1'),(72,'087','33 O  EF','1'),(73,'089','332 O LAB','1'),(74,'088','333 O LAB','1'),(75,'090','155E','1'),(76,'091','156E','1'),(77,'092','339','0'),(78,'094','344 O LAB','1'),(79,'095','348 O LAB','1'),(80,'097','352 O','1'),(81,'098','359 O','1'),(82,'099','361 O LAB','1'),(83,'100','363 O','1'),(84,'101','365 O LAB','1'),(85,'102','366 O LAB','1'),(86,'103','367 O','1'),(87,'104','368 O','1'),(88,'105','369 O LAB','1'),(89,'106','372 O','1'),(90,'107','374 O LAB','1'),(91,'110','379 O','1'),(92,'111','383 O','1'),(93,'112','381 O LAB','1'),(94,'113','387 O LAB','0'),(95,'303','303 O','1'),(96,'Dibujo','Lab de Dibujo','1'),(97,'155E','aula','1'),(98,'153','153B E','1'),(99,'151','153BE','1'),(100,'Cine','Cine Foro','1'),(101,'151B','151B E','1'),(102,'152A','151A E','1'),(103,'153A','153A E','1'),(104,'149','149E','1'),(105,'093','289','1'),(106,'231','231 O','1'),(107,'233','233 O','1'),(108,'232','232 O','1'),(109,'253','253 O','1'),(110,'251','251 O','1'),(111,'254','254 O','0'),(112,'206','206 E','1'),(113,'150','150E','1'),(114,'123','123E Coord','1'),(115,'069','069 O','1'),(116,'272-273','272-273 O','1'),(117,'364','364 O Lab','1'),(118,'364 O','LAB.','1'),(119,'029A','029A O','1'),(120,'Sala','Sala de Lectura','1'),(121,'305','305 E','1'),(122,'Lab 02','Lab 02 O','1'),(123,'306','306 O','1'),(124,'309','309 Lab E','1'),(125,'304','304 E','1'),(126,'Lab 04 E','Lab 04 O','1'),(127,'Lab 01 E','Lab 01 O','1'),(128,'164','164','1'),(129,'207','207 E','1'),(130,'302','302','1'),(131,'360','360','1'),(132,'244','244','1'),(133,'240','240 O','1'),(134,'245','245','1'),(135,'237','237 O','1'),(136,'235','235 O','1'),(137,'245-244','245-244 O','1'),(138,'242A-242B','242A-242B O','1'),(139,'237-235','237-235 O','1'),(140,'242 A','242 A O','1'),(141,'160','279 O','1'),(142,'161','286 O','1'),(143,'162','280 O','1'),(144,'163','052 O','1'),(145,'247','247','1'),(146,'166','285 O','1'),(147,'241-247','241-247 O','1'),(148,'242 A-245','242 A-245 O','1'),(149,'334','334 O','1'),(150,'255','255 O','1'),(151,'275','275 O','1'),(152,'221','221 O','1'),(153,'349','349 O','1'),(154,'222','222 O','1'),(155,'255 A','255A O','1'),(156,'255 B','255B O','1'),(157,'226','226 O','1'),(158,'338','338 O','1'),(159,'225 A','225A O','1'),(160,'225 B','225B O','1'),(161,'223','223 O','1'),(162,'167','046 O','1'),(163,'168','053','1'),(164,'29','29 EF','1'),(165,'169','205 E','1'),(166,'43','43 O','1'),(167,'fenix','081 O Sala Fenix','1'),(168,'cancha 1','Cancha 1 EF','1'),(169,'083 PEN','083 O','1'),(170,'043 TEA','043 O','1'),(171,'Cancha 2','Cancha 2 EF','0'),(172,'Cancha 3','Cancha 3 EF','1'),(173,'Cancha 4','Cancha 4 EF','1'),(174,'Cancha E','Cancha Este','1'),(175,'216','216 O','1'),(176,'216 ESTE','216 E','1'),(177,'113E','113 E','1'),(178,'111E','111 E','1'),(179,'134E','134E LAB ZOOLOGIA AGRICOLA','1'),(180,'314E','314 E Coord','1'),(181,'217E','217 E','1'),(182,'218E','218 E','1'),(183,'115E','115 E','1'),(184,'110E','110 E','1'),(185,'106 E','106E','1'),(186,'215','215 O','1'),(187,'219','219 O','1'),(188,'224','224 O','1'),(189,'33','33 O EF','1'),(190,'32','32 O  EF','1'),(191,'PISTA DE A','PISTA DE ATLETISMO O','1'),(192,'LAB 1º AUX','LAB 1º AUXIL  O','1'),(193,'44','44 O EF','1'),(194,'45','45 O EF','1'),(195,'157','157 E','1'),(196,'158','158 E COORD. MUSICA','1'),(197,'160 E','160 E','1'),(198,'180','209E','1'),(199,'185','107E','1'),(200,'186','108E','1'),(201,'187','109E','1'),(202,'188','104E','1'),(203,'308E','308E','1'),(204,'166E','166E','1'),(205,'Lab Maq-H','Lab Maq y Herramientas','1'),(206,'Lab Tecnol','Lab Tecnologia','1'),(207,'Lab Oeste','Lab Oeste','1'),(208,'307 E','307 E','1'),(209,'02','02 EF','1'),(210,'01','01 EF','1'),(211,'306E','306 E','1'),(212,'289 O','289 O','1'),(213,'214 E','214 E','1'),(214,'220','246 O','1'),(215,'229O','229 O','1'),(216,'233A O','233A O','1'),(217,'A conv 1','A convenir 1','1'),(218,'A conv 2','A convenir 2','1'),(219,'A conv 3','A convenir 3','1'),(220,'A conv 4','A convenir 4','1'),(221,'A conv 5','A convenir 5','1'),(222,'A conv 6','A convenir 6','1'),(223,'A conv 8','A convenir 8','1'),(224,'A conv 9','A convenir 9','1'),(225,'A conv 10','A convenir 10','1'),(226,'A conv 11','A convenir 11','1'),(227,'A conv 7','A convenir 7','1'),(228,'A conv 12','A convenir 12','1'),(229,'A conv 13','A convenir 13','1'),(230,'A conv 14','A convenir 14','1'),(231,'A conv 15','A convenir 15','1'),(232,'A conv 16','A convenir 16','1'),(233,'A conv 17','A convenir 17','1'),(234,'A conv 18','A convenir 18','1'),(235,'A conv 19','A convenir 19','1'),(236,'A conv 20','A convenir 20','1'),(237,'A conv 21','A convenir 21','1'),(238,'A conv 22','A convenir 22','1'),(239,'A conv 23','A convenir 23','1'),(240,'A conv 24','A convenir 24','1'),(241,'A conv 25','A convenir 25','1'),(242,'A conv 26','A convenir 26','1'),(243,'A conv 27','A convenir 27','1'),(244,'A conv 28','A convenir 28','1'),(245,'A conv 29','A convenir 29','1'),(246,'A conv 30','A convenir 30','1'),(247,'A conv 31','A convenir 31','1'),(248,'A conv 32','A convenir 32','1'),(249,'A conv 33','A convenir 33','1'),(250,'A conv 34','A convenir 34','1'),(251,'A conv 35','A convenir 35','1'),(252,'A conv 36','A convenir 36','1'),(253,'A conv 37','A convenir 37','1'),(254,'A conv 38','A convenir 38','1'),(255,'A conv 39','A convenir 39','1'),(256,'A conv 40','A convenir 40','1'),(257,'A conv 41','A Convenir 41','1'),(258,'A conv 42','A Convenir 42','1'),(259,'A conv 43','A Convenir 43','1'),(260,'263','263 O','1'),(261,'265','022','1'),(262,'029B','029B O','1'),(263,'212','212 O','1'),(264,'345 O LAB','345 OESTE LABORATORIO','1'),(265,'119E','119 COORD. E','1'),(266,'Lab Dibujo','Lab Dibujo O','1'),(267,'OFIC 1 O','Ofic 1 Talleres O','1'),(268,'Lab. Solda','Lab Soldadura O','1'),(269,'350 O LAB','350 OESTE LABORATORIO','1'),(270,'056','056 O Sala de Estudio','1'),(271,'373/376','AULAS','1'),(272,'378-372','comb','1'),(273,'378-386','D','1'),(274,'420','373/376','1'),(275,'421','373/380','1'),(276,'422','378/373','1'),(277,'424','378/372','1'),(278,'425','316/352','1'),(279,'426','306/314','1'),(280,'46 EF','46 EF','1'),(281,'16 EF','16 EF','1'),(282,'17 EF','17 EF','1'),(283,'Foro Este','Foro Este','1'),(284,'32 EF','32 EF','1'),(285,'105 E Lab','105 E Lab','1'),(286,'ceste','Cancha Este 2','1'),(287,'026 O','026O','1'),(288,'001','001 Subd Docencia','1'),(289,'Lab03','Lab 03 O','1'),(290,'29 O EF','29 O EF','1'),(291,'242BO','Oeste','1'),(292,'Azotea','Azotea O','1'),(293,'AulaSaludE','Aula Salud E','1'),(294,'037O','037 C/Pendiente','1'),(295,'085O','085 C/Pendiente','1'),(296,'157/160','157/160','1'),(297,'159/160 E','159/160 E','1'),(298,'159/167 E','159/167 E','1'),(299,'216/105E','216/105E','1'),(300,'383/376','383/376','1'),(301,'373/378','373/378','1'),(302,'372/378','372/378','1'),(303,'380/373','380/373','1'),(304,'Auditorio','Auditorio Magdalena Seijas de L. Oeste','1'),(305,'Multiamb','351 Multiambiente CsNat O','1'),(306,'campsoftb','camp softb','1'),(307,'01musica','01 Salón Uso Múltiple E','1'),(308,'134ELab','134 E Lab','1'),(309,'Lab05O','Lab 05 O','1'),(310,'Lab06O','Lab 06 O','1'),(311,'101Tecnica','101 Dpto Técnica E','1'),(312,'168E','168E','1'),(313,'47LabEF','47 Lab EF','1'),(314,'376/373','376/373 O','1'),(315,'303E','303 E','1'),(316,'Lab.Integ','Lab Integral (CsNat)','1'),(317,'368/329','368/329 O','1'),(318,'314/329','314/329 O','1'),(319,'316/329','316/329 O','1'),(320,'316/328','316/328 O','1'),(321,'316/366','316/366 O','1'),(322,'314/328','314/328 O','1'),(323,'314/366','314/366 O','1'),(324,'314/327','314/327 O','1'),(325,'315/327','315/327 O','1'),(326,'315/365','315/365 O','1'),(327,'368/365','368/365 O','1'),(328,'367/323','367/323 O','1'),(329,'315/320','315/320 O','1'),(330,'352/324','352/324 O','1'),(331,'352/326','352/326 O','1'),(332,'324','324 O','1'),(333,'326/352','326/352 O','1'),(334,'367/322','367/322 O','1'),(335,'329/316','329/316 O','1'),(336,'329/314','329/314 O','1'),(337,'315/328','315/328 O','1'),(338,'330/315','330/315 O','1'),(339,'315/330','315/330 O','1'),(340,'333/316','333/316 O','1'),(341,'316/333','316/333 O','1'),(342,'314/322','314/322 O','1'),(343,'322/314','322/314 O','1'),(344,'232-231','232-231 O','1'),(345,'252-253','252-253 O','1'),(346,'252-376O','252-376 O','1'),(347,'105E','105 E','1'),(348,'DanzaE','02 Danza E','1'),(349,'253-252O','253-252 O','1');
/*!40000 ALTER TABLE `ambiente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `areas`
--

DROP TABLE IF EXISTS `areas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `areas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `descripcion` varchar(50) NOT NULL,
  `vigente` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_58B0B25C20332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `areas`
--

LOCK TABLES `areas` WRITE;
/*!40000 ALTER TABLE `areas` DISABLE KEYS */;
INSERT INTO `areas` VALUES (1,'1','Por Definir Rectorado',1);
/*!40000 ALTER TABLE `areas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `asesoria`
--

DROP TABLE IF EXISTS `asesoria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `asesoria` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `curso_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `fecharegistro` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_F8126B4759590C39` (`estudiante_id`),
  KEY `IDX_F8126B4787CB4A1F` (`curso_id`),
  KEY `IDX_F8126B4780B24165` (`lapso_id`),
  KEY `IDX_F8126B47613FECDF` (`session_id`),
  CONSTRAINT `FK_F8126B4759590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `FK_F8126B47613FECDF` FOREIGN KEY (`session_id`) REFERENCES `sessiones` (`id`),
  CONSTRAINT `FK_F8126B4780B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_F8126B4787CB4A1F` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `asesoria`
--

LOCK TABLES `asesoria` WRITE;
/*!40000 ALTER TABLE `asesoria` DISABLE KEYS */;
INSERT INTO `asesoria` VALUES (8,3,641,56,NULL,'2023-02-01'),(41,3,292,1,NULL,'2023-04-10'),(42,3,29,1,NULL,'2023-04-10'),(43,3,757,1,NULL,'2023-04-10'),(49,5,641,1,NULL,'2023-04-13'),(50,5,120,1,NULL,'2023-04-13'),(51,5,550,1,NULL,'2023-04-13'),(52,10,120,55,NULL,'2023-05-23'),(53,11,120,55,NULL,'2023-05-23'),(59,7,611,1,NULL,'2023-07-19'),(60,7,498,1,NULL,'2023-07-19'),(76,4,382,1,NULL,'2023-11-16'),(77,4,611,1,NULL,'2023-11-16'),(78,4,286,56,NULL,'2023-11-17'),(82,10,611,1,NULL,'2024-03-09'),(83,10,641,1,NULL,'2024-03-09'),(95,11,641,1,NULL,'2024-03-09'),(96,11,611,1,NULL,'2024-03-09'),(103,13,611,1,NULL,'2024-03-11'),(104,13,641,1,NULL,'2024-03-11'),(105,13,442,1,NULL,'2024-03-11'),(107,2,641,64,NULL,'2024-05-18'),(108,13,497,56,NULL,'2025-04-29'),(111,2,641,1,NULL,'2025-11-24'),(113,2,498,1,NULL,'2025-12-08');
/*!40000 ALTER TABLE `asesoria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auditoria`
--

DROP TABLE IF EXISTS `auditoria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `auditoria` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `curso_id` int(11) DEFAULT NULL,
  `condicion_id` int(11) DEFAULT NULL,
  `programa_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `especialidad_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `matricula_id` int(11) DEFAULT NULL,
  `seccion` varchar(20) NOT NULL,
  `nota` int(11) NOT NULL,
  `fecha_hora` datetime NOT NULL,
  `proceso` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_AF4BB49D59590C39` (`estudiante_id`),
  KEY `IDX_AF4BB49DDB38439E` (`usuario_id`),
  KEY `IDX_AF4BB49D80B24165` (`lapso_id`),
  KEY `IDX_AF4BB49D87CB4A1F` (`curso_id`),
  KEY `IDX_AF4BB49D2A0E31F6` (`condicion_id`),
  KEY `IDX_AF4BB49DFD8A7328` (`programa_id`),
  KEY `IDX_AF4BB49DE19F41BF` (`sede_id`),
  KEY `IDX_AF4BB49D16A490EC` (`especialidad_id`),
  KEY `IDX_AF4BB49D613FECDF` (`session_id`),
  KEY `IDX_AF4BB49D15C84B52` (`matricula_id`),
  CONSTRAINT `FK_AF4BB49D15C84B52` FOREIGN KEY (`matricula_id`) REFERENCES `matricula` (`id`),
  CONSTRAINT `FK_AF4BB49D16A490EC` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`),
  CONSTRAINT `FK_AF4BB49D2A0E31F6` FOREIGN KEY (`condicion_id`) REFERENCES `cod_curso` (`id`),
  CONSTRAINT `FK_AF4BB49D59590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `FK_AF4BB49D613FECDF` FOREIGN KEY (`session_id`) REFERENCES `sessiones` (`id`),
  CONSTRAINT `FK_AF4BB49D80B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_AF4BB49D87CB4A1F` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`),
  CONSTRAINT `FK_AF4BB49DDB38439E` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`),
  CONSTRAINT `FK_AF4BB49DE19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`),
  CONSTRAINT `FK_AF4BB49DFD8A7328` FOREIGN KEY (`programa_id`) REFERENCES `programa` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auditoria`
--

LOCK TABLES `auditoria` WRITE;
/*!40000 ALTER TABLE `auditoria` DISABLE KEYS */;
INSERT INTO `auditoria` VALUES (1,4984,1,1,120,4,1,1,1,NULL,59,'14',2,'2020-07-24 13:50:32','Proceso Inclusion '),(2,4983,1,1,120,4,1,1,3,NULL,58,'14',1,'2020-07-24 13:50:32','Proceso Inclusion '),(3,4983,1,1,120,3,1,1,3,NULL,58,'14',6,'2020-07-24 13:53:43','Proceso Modificacion '),(5,5,1,1,641,3,1,1,1,NULL,66,'1',7,'2023-03-16 16:34:46','Proceso Inclusion '),(6,5,1,1,641,3,1,1,1,NULL,66,'1',8,'2023-03-16 16:35:20','Proceso Modificacion '),(7,5,1,1,641,4,1,1,1,NULL,66,'1',5,'2023-03-16 16:36:33','Proceso Modificacion ');
/*!40000 ALTER TABLE `auditoria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auditoria_espe`
--

DROP TABLE IF EXISTS `auditoria_espe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `auditoria_espe` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usuario_id` int(11) DEFAULT NULL,
  `estudiante_id` int(11) DEFAULT NULL,
  `especialidadini_id` int(11) DEFAULT NULL,
  `especialidadactual_id` int(11) DEFAULT NULL,
  `cohorte_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `ingreso_id` int(11) DEFAULT NULL,
  `fecha_hora` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `estudiante_id` (`estudiante_id`),
  KEY `especialidadini_id` (`especialidadini_id`),
  KEY `especialidadactual_id` (`especialidadactual_id`),
  KEY `cohorte_id` (`cohorte_id`),
  KEY `lapso_id` (`lapso_id`),
  KEY `ingreso_id` (`ingreso_id`),
  CONSTRAINT `auditoria_espe_ibfk_1` FOREIGN KEY (`cohorte_id`) REFERENCES `cohorte` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_espe_ibfk_2` FOREIGN KEY (`especialidadini_id`) REFERENCES `especialidad` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_espe_ibfk_3` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_espe_ibfk_4` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_espe_ibfk_5` FOREIGN KEY (`especialidadactual_id`) REFERENCES `especialidad` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_espe_ibfk_6` FOREIGN KEY (`ingreso_id`) REFERENCES `tipo_ingreso` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_espe_ibfk_7` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auditoria_espe`
--

LOCK TABLES `auditoria_espe` WRITE;
/*!40000 ALTER TABLE `auditoria_espe` DISABLE KEYS */;
INSERT INTO `auditoria_espe` VALUES (1,1,4988,8,8,92,56,1,'2023-02-01 13:43:41'),(2,1,4988,11,11,90,1,1,'2023-02-01 13:49:57'),(3,1,4983,3,8,92,56,1,'2023-02-04 13:32:37'),(5,1,3,12,7,92,56,1,'2023-02-07 14:52:10'),(6,1,3,7,7,92,56,1,'2023-02-07 14:52:49'),(7,1,3,7,8,92,56,1,'2023-02-07 14:53:31'),(9,1,4,11,19,90,1,1,'2023-02-07 21:24:57');
/*!40000 ALTER TABLE `auditoria_espe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auditoria_notas`
--

DROP TABLE IF EXISTS `auditoria_notas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `auditoria_notas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) NOT NULL,
  `matricula_id` int(11) NOT NULL,
  `especialidad_id` int(11) NOT NULL,
  `curso_id` int(11) NOT NULL,
  `condicion_id` int(11) NOT NULL,
  `seccion` varchar(11) NOT NULL,
  `profesor_id` int(11) NOT NULL,
  `lapso_id` int(11) NOT NULL,
  `nota` int(11) NOT NULL,
  `proceso` varchar(50) NOT NULL,
  `nota_actual` int(11) NOT NULL,
  `fecha_hora` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `estudiante_id` (`estudiante_id`),
  KEY `matricula_id` (`matricula_id`),
  KEY `especialidad_id` (`especialidad_id`),
  KEY `curso_id` (`curso_id`),
  KEY `condicion_id` (`condicion_id`),
  KEY `profesor_id` (`profesor_id`),
  KEY `lapso_id` (`lapso_id`),
  CONSTRAINT `auditoria_notas_ibfk_1` FOREIGN KEY (`condicion_id`) REFERENCES `cod_curso` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_notas_ibfk_2` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_notas_ibfk_3` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_notas_ibfk_4` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_notas_ibfk_5` FOREIGN KEY (`matricula_id`) REFERENCES `matricula` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_notas_ibfk_6` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `auditoria_notas_ibfk_7` FOREIGN KEY (`profesor_id`) REFERENCES `profesor` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auditoria_notas`
--

LOCK TABLES `auditoria_notas` WRITE;
/*!40000 ALTER TABLE `auditoria_notas` DISABLE KEYS */;
INSERT INTO `auditoria_notas` VALUES (1,7,87,19,611,4,'1',1230,1,5,'Carga de Notas Actualizada',8,'2023-06-13 09:55:47'),(2,5,77,1,120,3,'1',1789,1,8,'Carga de Notas Actualizada',3,'2023-06-13 11:43:26'),(3,7,87,19,611,4,'1',1230,1,4,'Carga de Notas Actualizada',9,'2023-06-13 13:39:49');
/*!40000 ALTER TABLE `auditoria_notas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auditoria_procesos`
--

DROP TABLE IF EXISTS `auditoria_procesos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `auditoria_procesos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) NOT NULL,
  `curso_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `usuario_id` int(11) NOT NULL,
  `proceso` varchar(255) NOT NULL,
  `fecha_hora` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_estudiante_id` (`estudiante_id`),
  KEY `idx_curso_id` (`curso_id`),
  KEY `idx_lapso_id` (`lapso_id`),
  KEY `idx_usuario_id` (`usuario_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auditoria_procesos`
--

LOCK TABLES `auditoria_procesos` WRITE;
/*!40000 ALTER TABLE `auditoria_procesos` DISABLE KEYS */;
INSERT INTO `auditoria_procesos` VALUES (1,2,NULL,NULL,1,'Modificación de estudiante','2025-11-23 23:48:15'),(2,2,NULL,NULL,1,'Modificación de estudiante','2025-11-24 00:01:52'),(3,2,611,1,1,'Registro de Asesoría','2025-11-24 00:04:34'),(4,2,611,1,1,'Eliminación de asesoría','2025-11-24 00:04:50'),(5,2,611,1,1,'Registro de Asesoría','2025-11-24 00:05:14'),(6,2,641,1,1,'Registro de Asesoría','2025-11-24 00:05:14'),(7,2,498,1,1,'Registro de Asesoría','2025-11-24 00:05:14'),(8,2,611,1,1,'Inscripción de curso','2025-11-24 00:05:39'),(9,2,611,1,1,'Eliminación de Asesoría','2025-12-08 13:27:48'),(10,2,498,1,1,'Eliminación de Asesoría','2025-12-08 13:28:58'),(11,2,498,1,1,'Registro de Asesoría','2025-12-08 13:29:14'),(12,2,641,1,1,'Inscripción de curso','2025-12-08 13:30:27'),(13,2,641,1,1,'Inscripción de curso','2025-12-08 13:33:49'),(14,2,498,1,1,'Inscripción de curso','2025-12-08 13:33:49'),(15,2,NULL,NULL,1,'Editado Datos Básicos de Estudiante','2025-12-08 13:58:09'),(16,2,NULL,NULL,1,'Editado Datos Académicos de Estudiante','2025-12-08 13:58:25');
/*!40000 ALTER TABLE `auditoria_procesos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auditoria_retiro`
--

DROP TABLE IF EXISTS `auditoria_retiro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `auditoria_retiro` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `curso_id` int(11) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha_hora` datetime NOT NULL,
  `tipo` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estudiante_id` (`estudiante_id`),
  KEY `lapso_id` (`lapso_id`),
  KEY `curso_id` (`curso_id`),
  KEY `usuario_id` (`usuario_id`),
  CONSTRAINT `auditoria_retiro_ibfk_1` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `auditoria_retiro_ibfk_2` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `auditoria_retiro_ibfk_3` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`),
  CONSTRAINT `auditoria_retiro_ibfk_4` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auditoria_retiro`
--

LOCK TABLES `auditoria_retiro` WRITE;
/*!40000 ALTER TABLE `auditoria_retiro` DISABLE KEYS */;
INSERT INTO `auditoria_retiro` VALUES (1,3,1,29,1,'2023-03-17 12:01:04','RETIRO DE UNIDAD/EJE CURRICULAR'),(2,5,1,757,1,'2023-03-17 21:26:50','RETIRO DE UNIDAD/EJE CURRICULAR'),(3,5,1,757,1,'2023-03-17 21:34:36','RETIRO DE UNIDAD/EJE CURRICULAR'),(4,4,1,611,1,'2023-03-17 21:47:38','RETIRO DE UNIDAD/EJE CURRICULAR'),(5,3,1,29,1,'2023-03-21 14:05:01','RETIRO DE UNIDAD/EJE CURRICULAR'),(6,3,1,292,1,'2023-03-21 15:10:15','RETIRO DE UNIDAD/EJE CURRICULAR'),(7,5,1,120,1,'2023-03-29 09:09:06','RETIRO DE UNIDAD/EJE CURRICULAR'),(8,3,1,757,1,'2023-04-10 14:12:38','RETIRO DE UNIDAD/EJE CURRICULAR'),(9,3,1,292,1,'2023-04-10 14:12:59','RETIRO DE UNIDAD/EJE CURRICULAR'),(10,3,1,641,1,'2023-04-10 14:24:17','RETIRO DE PERÍODO ACADÉMICO'),(11,3,1,29,1,'2023-04-10 14:24:17','RETIRO DE PERÍODO ACADÉMICO'),(12,3,1,29,1,'2023-04-10 14:26:55','RETIRO DE PERÍODO ACADÉMICO'),(13,3,1,292,1,'2023-04-10 14:26:55','RETIRO DE PERÍODO ACADÉMICO'),(14,3,1,757,1,'2023-04-10 14:26:55','RETIRO DE PERÍODO ACADÉMICO'),(15,4,1,498,1,'2023-07-27 09:23:54','RETIRO DE PERÍODO ACADÉMICO'),(16,4,1,382,1,'2023-11-02 16:00:09','RETIRO DE UNIDAD/EJE CURRICULAR'),(17,4,1,382,1,'2023-11-02 16:04:56','RETIRO DE PERÍODO ACADÉMICO'),(18,10,1,641,86,'2024-03-09 17:56:24','RETIRO DE UNIDAD/EJE CURRICULAR'),(19,10,1,641,86,'2024-03-09 18:00:19','RETIRO DE UNIDAD/EJE CURRICULAR'),(20,10,1,498,86,'2024-03-09 18:02:13','RETIRO DE PERÍODO ACADÉMICO'),(21,10,1,641,86,'2024-03-09 18:02:14','RETIRO DE PERÍODO ACADÉMICO'),(22,10,1,641,86,'2024-03-09 18:27:22','RETIRO DE UNIDAD/EJE CURRICULAR'),(23,10,1,641,86,'2024-03-09 18:29:46','RETIRO DE UNIDAD/EJE CURRICULAR'),(24,5,1,550,86,'2024-03-09 18:46:37','RETIRO DE UNIDAD/EJE CURRICULAR'),(25,11,1,611,86,'2024-03-09 18:54:16','RETIRO DE UNIDAD/EJE CURRICULAR'),(26,11,1,641,86,'2024-03-09 18:54:21','RETIRO DE UNIDAD/EJE CURRICULAR'),(27,13,1,641,1,'2024-03-09 19:19:35','RETIRO DE UNIDAD/EJE CURRICULAR'),(28,11,1,498,1,'2024-03-09 19:22:42','RETIRO DE UNIDAD/EJE CURRICULAR'),(29,13,1,611,1,'2024-03-09 19:26:18','RETIRO DE UNIDAD/EJE CURRICULAR'),(30,13,1,641,1,'2024-03-09 19:26:26','RETIRO DE UNIDAD/EJE CURRICULAR'),(31,13,1,641,1,'2024-03-11 11:38:46','RETIRO DE UNIDAD/EJE CURRICULAR'),(32,11,1,641,1,'2024-03-11 11:44:31','RETIRO DE PERÍODO ACADÉMICO'),(33,7,1,498,1,'2024-03-11 11:46:38','RETIRO DE UNIDAD/EJE CURRICULAR'),(34,2,1,611,1,'2025-12-08 13:32:45','RETIRO DE UNIDAD/EJE CURRICULAR'),(35,2,1,641,1,'2025-12-08 13:32:50','RETIRO DE UNIDAD/EJE CURRICULAR');
/*!40000 ALTER TABLE `auditoria_retiro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auditoria_situacion`
--

DROP TABLE IF EXISTS `auditoria_situacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `auditoria_situacion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `programa_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `estudiante_id` int(11) DEFAULT NULL,
  `especialidad_id` int(11) DEFAULT NULL,
  `cohorte_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `ingreso_id` int(11) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `situa_id` int(11) DEFAULT NULL,
  `proceso` varchar(255) NOT NULL,
  `fecha_hora` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_88B6BB05FD8A7328` (`programa_id`),
  KEY `IDX_88B6BB05E19F41BF` (`sede_id`),
  KEY `IDX_88B6BB0559590C39` (`estudiante_id`),
  KEY `IDX_88B6BB0516A490EC` (`especialidad_id`),
  KEY `IDX_88B6BB05FB30EFA4` (`cohorte_id`),
  KEY `IDX_88B6BB0580B24165` (`lapso_id`),
  KEY `IDX_88B6BB05E70E8ADB` (`ingreso_id`),
  KEY `IDX_88B6BB05DB38439E` (`usuario_id`),
  KEY `IDX_88B6BB05E2C8EC00` (`situa_id`),
  CONSTRAINT `FK_88B6BB0516A490EC` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`),
  CONSTRAINT `FK_88B6BB0559590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `FK_88B6BB0580B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_88B6BB05DB38439E` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`),
  CONSTRAINT `FK_88B6BB05E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`),
  CONSTRAINT `FK_88B6BB05E2C8EC00` FOREIGN KEY (`situa_id`) REFERENCES `cod_situa` (`id`),
  CONSTRAINT `FK_88B6BB05E70E8ADB` FOREIGN KEY (`ingreso_id`) REFERENCES `tipo_ingreso` (`id`),
  CONSTRAINT `FK_88B6BB05FB30EFA4` FOREIGN KEY (`cohorte_id`) REFERENCES `cohorte` (`id`),
  CONSTRAINT `FK_88B6BB05FD8A7328` FOREIGN KEY (`programa_id`) REFERENCES `programa` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auditoria_situacion`
--

LOCK TABLES `auditoria_situacion` WRITE;
/*!40000 ALTER TABLE `auditoria_situacion` DISABLE KEYS */;
/*!40000 ALTER TABLE `auditoria_situacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `autoridades`
--

DROP TABLE IF EXISTS `autoridades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `autoridades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `apellido` varchar(50) NOT NULL,
  `cedula` int(11) NOT NULL,
  `cargo` varchar(60) NOT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `subsede_id` int(11) DEFAULT NULL,
  `titulo` varchar(5) NOT NULL,
  `activo` varchar(15) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_6B4594E5E19F41BF` (`sede_id`),
  KEY `IDX_6B4594E5AAFDE970` (`subsede_id`),
  CONSTRAINT `FK_6B4594E5AAFDE970` FOREIGN KEY (`subsede_id`) REFERENCES `subsede` (`id`),
  CONSTRAINT `FK_6B4594E5E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `autoridades`
--

LOCK TABLES `autoridades` WRITE;
/*!40000 ALTER TABLE `autoridades` DISABLE KEYS */;
INSERT INTO `autoridades` VALUES (1,'Msc. Beatriz Elena','Corvo Mujica',7408190,'12',1,1,'Profe','0'),(2,'Dr. Nelson Silva','PRUEBA',0,'12',1,1,'Docto','1'),(3,'Dra. Gloria Esperanza','Pérez Carucí',3860057,'10',1,1,'Profe','1'),(4,'Prof. Regina','Tavares',0,'7',1,1,'Profe','1'),(5,'Dr. Luis Antonio','Arguelles Quero',12509702,'15',1,1,'Dra.','1'),(7,'Dr. Nelson Silva','',0,'6',1,3,'Docto','1'),(8,'Dra. Gloria Esperanza','Pérez Carucí',3860057,'10',1,3,'Profe','1'),(9,'Prof. Regina','Tavares',0,'7',1,3,'Profe','1'),(10,'Dr. Luis Antonio','Arguelles Quero',12509702,'15',1,3,'Prof.','1'),(12,'Dr. Nelson Silva','',0,'6',1,4,'Docto','1'),(13,'Dra. Gloria Esperanza','Pérez Carucí',3860057,'10',1,4,'Profe','1'),(14,'Prof. Regina','Tavares',0,'7',1,4,'Profe','1'),(15,'Dr. Luis Antonio','Arguelles Quero',12509702,'15',1,4,'Prof.','1'),(17,'Dr. Nelson Silva','',0,'6',1,5,'Docto','1'),(18,'Dra. Gloria Esperanza','Pérez Carucí',3860057,'10',1,5,'Profe','1'),(19,'Prof. Regina','Tavares',0,'7',1,5,'Profe','1'),(20,'Dr. Luis Antonio','Arguelles Quero',12509702,'15',1,5,'Prof.','1'),(22,'Dr. Nelson Silva','',0,'6',1,6,'Docto','1'),(23,'Dra. Gloria Esperanza','Pérez Carucí',3860057,'10',1,6,'Profe','1'),(24,'Prof. Regina','Tavares',0,'7',1,6,'Profe','1'),(25,'Dr. Luis Antonio','Arguelles Quero',12509702,'15',1,6,'Prof.','1'),(26,'Msc. Beatriz Elena','Corvo Mujica',7408190,'12',1,2,'Profe','0'),(27,'Dr. Nelson Silva','',0,'6',1,2,'Docto','1'),(28,'Dra. Gloria Esperanza','Pérez Carucí',3860057,'10',1,2,'Profe','1'),(29,'Prof. Regina','Tavares',0,'7',1,2,'Profe','1'),(30,'Dr. Luis Antonio','Arguelles Quero',12509702,'15',1,2,'Prof.','1'),(32,'Dr. Nelson Silva','',0,'6',1,7,'Docto','1'),(33,'Dra. Gloria Esperanza','Pérez Carucí',3860057,'10',1,7,'Profe','1'),(34,'Prof. Regina','Tavares',0,'7',1,7,'Profe','1'),(35,'Dr. Luis Antonio','Arguelles Quero',12509702,'15',1,7,'Prof.','1'),(37,'Dr. Nelson Silva','',0,'6',1,8,'Docto','1'),(38,'Dra. Gloria Esperanza','Pérez Carucí',3860057,'10',1,8,'Profe','1'),(39,'Prof. Regina','Tavares',0,'7',1,8,'Profe','1'),(40,'Dr. Luis Antonio','Arguelles Quero',12509702,'15',1,8,'Prof.','1'),(41,'Arnaldo','Avilaa',18738560,'12',1,93,'Ingen','1'),(42,'Arnaldo','Avilaa',18738560,'12',1,9,'Ing','1'),(43,'Raúl','López Sayago',3753290,'1',1,1,'Dr.','1'),(44,'Nilva Liuval','Moreno de Tovar',3430403,'5',1,1,'Dra.','1'),(45,'Raúl','López Sayago',3753290,'1',1,2,'Dr.','1'),(46,'Nilva Liuval','Moreno de Tovar',3430403,'5',1,2,'Dra.','1'),(47,'Raúl','López Sayago',3753290,'1',1,3,'Dr.','1'),(48,'Nilva Liuval','Moreno de Tovar',3430403,'5',1,3,'Dra.','1'),(49,'Raúl','López Sayago',3753290,'1',1,4,'Dr.','1'),(50,'Nilva Liuval','Moreno de Tovar',3430403,'5',1,4,'Dra.','1'),(51,'Raúl','López Sayago',3753290,'1',1,5,'Dr.','1'),(52,'Nilva Liuval','Moreno de Tovar',3430403,'5',1,5,'Dra.','1'),(53,'Raúl','López Sayago',3753290,'1',1,6,'Dr.','1'),(54,'Nilva Liuval','Moreno de Tovar',3430403,'5',1,6,'Dra.','1'),(55,'Raúl','López Sayago',3753290,'1',1,7,'Dr.','1'),(56,'Nilva Liuval','Moreno de Tovar',3430403,'5',1,7,'Dra.','1'),(57,'Raúl','López Sayago',3753290,'1',1,8,'Dr.','1'),(58,'Nilva Liuval','Moreno de Tovar',3430403,'5',1,8,'Dra.','1'),(59,'Raúl','López Sayago',3753290,'1',1,9,'Dr.','1'),(60,'Nilva Liuval','Moreno de Tovar',3430403,'5',1,9,'Dra.','1'),(61,'Raúl','López Sayago',3753290,'1',1,10,'Dr.','1'),(62,'Nilva Liuval','Moreno de Tovar',3430403,'5',1,10,'Dra.','1');
/*!40000 ALTER TABLE `autoridades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bloque_horas`
--

DROP TABLE IF EXISTS `bloque_horas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bloque_horas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(2) NOT NULL,
  `desde` varchar(8) NOT NULL,
  `hasta` varchar(8) NOT NULL,
  `vigente` tinyint(1) NOT NULL,
  `sede_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CA38E37FE19F41BF` (`sede_id`),
  CONSTRAINT `FK_CA38E37FE19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bloque_horas`
--

LOCK TABLES `bloque_horas` WRITE;
/*!40000 ALTER TABLE `bloque_horas` DISABLE KEYS */;
INSERT INTO `bloque_horas` VALUES (1,'A','7:00 am','8:00 am',1,1),(2,'B','8:00 am','9:00 am',1,1),(3,'C','9:00 am','10:00 am',1,1),(4,'D','10:00 am','11:00 am',1,1),(5,'E','11:00 am','12:00 pm',1,1),(6,'F','12:00 pm','1:00 pm',1,1),(7,'G','1:00 pm','2:00 pm',1,1),(8,'H','2:00 pm','3:00 pm',1,1),(9,'I','3:00 pm','4:00 pm',1,1),(10,'J','4:00 pm','5:00 pm',1,1),(11,'K','5:00 pm','6:00 pm',1,1),(12,'L','6:00 pm','7:00 pm',1,1),(13,'M','7:00 pm','8:00 pm',1,1),(14,'N','8:00 pm','9:00 pm',1,1),(15,'O','9:00 pm','10:00 pm',1,1),(16,'P','10:00 pm','11:00 pm',1,1);
/*!40000 ALTER TABLE `bloque_horas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cargos`
--

DROP TABLE IF EXISTS `cargos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cargos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  `jerarquia` int(11) NOT NULL,
  `activo` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cargos`
--

LOCK TABLES `cargos` WRITE;
/*!40000 ALTER TABLE `cargos` DISABLE KEYS */;
INSERT INTO `cargos` VALUES (1,'RECTOR',1,1),(2,'VICE RECTOR DE DOCENCIA',2,1),(3,'VICE RECTOR DE INVESTIGACIÓN  Y POST GRADO',2,1),(4,'VICE RECTOR DE EXTENSIÓN',2,1),(5,'SECRETARIA UPEL',2,1),(6,'DIRECTOR DECANO',3,1),(7,'SUB. DIRECTOR DE DOCENCIA',4,1),(8,'SUB. DIRECTOR DE INVESTIGACIÓN  Y POST GRADO',4,1),(9,'SUB. DIRECTOR DE EXTENSIÓN',4,1),(10,'SECRETARIO (A)',4,1),(11,'JEFE  UNIDAD DE ADMISIÓN',5,1),(12,'Jefe(a) de Control de Estudios',5,1),(13,'JEFE DE DEPARTAMENTO',5,1),(14,'JEFE DE SECCIÓN',6,1),(15,'COORDINADOR INSTITUCIONAL DE SERVICIO COMUNITARIO',5,1),(16,'RESPONSABLE DE EVALUACION',6,1),(17,'COORDINADOR(A) DE DOCENCIA',6,1),(18,'COORDINADOR(A) DE SECRETARÍA',6,1),(19,'COORDINADOR(A) DE CENTRO /  NUCLEO / EXTENSIÓN',6,1);
/*!40000 ALTER TABLE `cargos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cierre_grado`
--

DROP TABLE IF EXISTS `cierre_grado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cierre_grado` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lapso_id` int(11) DEFAULT NULL,
  `programa_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fechaCierre` date DEFAULT NULL,
  `promocion_id` int(11) DEFAULT NULL,
  `fecharesolucion` datetime DEFAULT NULL,
  `resolucion` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_53950BF780B24165` (`lapso_id`),
  KEY `IDX_53950BF7FD8A7328` (`programa_id`),
  KEY `IDX_53950BF7E19F41BF` (`sede_id`),
  KEY `IDX_53950BF7DB38439E` (`usuario_id`),
  KEY `IDX_53950BF7B1E453D4` (`promocion_id`),
  CONSTRAINT `FK_53950BF780B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_53950BF7B1E453D4` FOREIGN KEY (`promocion_id`) REFERENCES `promociones` (`id`),
  CONSTRAINT `FK_53950BF7DB38439E` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`),
  CONSTRAINT `FK_53950BF7E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`),
  CONSTRAINT `FK_53950BF7FD8A7328` FOREIGN KEY (`programa_id`) REFERENCES `programa` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cierre_grado`
--

LOCK TABLES `cierre_grado` WRITE;
/*!40000 ALTER TABLE `cierre_grado` DISABLE KEYS */;
/*!40000 ALTER TABLE `cierre_grado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ciudades`
--

DROP TABLE IF EXISTS `ciudades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ciudades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estado_id` int(11) DEFAULT NULL,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_FF7700620332D99` (`codigo`),
  KEY `IDX_FF770069F5A440B` (`estado_id`),
  CONSTRAINT `FK_FF770069F5A440B` FOREIGN KEY (`estado_id`) REFERENCES `estados` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=952 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ciudades`
--

LOCK TABLES `ciudades` WRITE;
/*!40000 ALTER TABLE `ciudades` DISABLE KEYS */;
INSERT INTO `ciudades` VALUES (1,1,'1000','Acanaña'),(2,1,'1001','Cacurí'),(3,1,'1002','Camani'),(4,1,'1003','Comunidad'),(5,1,'1004','Curimacare'),(6,1,'1005','Guarinuma'),(7,1,'1006','Isla Ratón'),(8,1,'1007','La Esmeral'),(9,1,'1008','Laja Lisa'),(10,1,'1009','Limón de P'),(11,1,'1010','Macuruco'),(12,1,'1011','Maroa'),(13,1,'1012','Marueta'),(14,1,'1013','Mavaca'),(15,1,'1014','Munduapo'),(16,1,'1015','Parimabé'),(17,1,'1016','Pendare'),(18,1,'1017','Platanilla'),(19,1,'1018','Puerto Aya'),(20,1,'1019','Puerto Aya'),(21,1,'1020','Samariapo'),(22,1,'1021','San Carlos'),(23,1,'1022','San Fernan'),(24,1,'1023','San Juan d'),(25,1,'1024','San Pedro '),(26,1,'1025','Santa Lucí'),(27,1,'1026','Solano'),(28,1,'1027','Toky-Shama'),(29,1,'1028','Victorino'),(30,2,'1029','Anaco'),(31,2,'1030','Anaco'),(32,2,'1031','Aragua de '),(33,2,'1032','Atapirire'),(34,2,'1033','Barcelona'),(35,2,'1034','Bergantín'),(36,2,'1035','Boca de Ch'),(37,2,'1036','Boca de Uc'),(38,2,'1037','Boca del P'),(39,2,'1038','Cachipo'),(40,2,'1039','Caigua'),(41,2,'1040','Cantaura'),(42,2,'1041','Carapa'),(43,2,'1042','Clarines'),(44,2,'1043','Clarines'),(45,2,'1044','El Carito'),(46,2,'1045','El Chaparr'),(47,2,'1046','El Hatillo'),(48,2,'1047','El Pao de '),(49,2,'1048','El Pilar'),(50,2,'1049','El Tigre'),(51,2,'1050','Guanape'),(52,2,'1051','Guanta'),(53,2,'1052','José Grego'),(54,2,'1053','Lecherías'),(55,2,'1054','Mapire'),(56,2,'1055','Múcura'),(57,2,'1056','Mundo Nuev'),(58,2,'1057','Naricual'),(59,2,'1058','Onoto'),(60,2,'1059','Pariaguán'),(61,2,'1060','Pertigalet'),(62,2,'1061','Píritu'),(63,2,'1062','Pozuelos'),(64,2,'1063','Pueblo Nue'),(65,2,'1064','Puerto La '),(66,2,'1065','Puerto Pír'),(67,2,'1066','Sabana de '),(68,2,'1067','San Diego '),(69,2,'1068','San Franci'),(70,2,'1069','San Joaquí'),(71,2,'1070','San Mateo'),(72,2,'1071','San Miguel'),(73,2,'1072','San Pablo'),(74,2,'1073','Santa Ana'),(75,2,'1074','Santa Bárb'),(76,2,'1075','Santa Clar'),(77,2,'1076','Santa Cruz'),(78,2,'1077','Santa Inés'),(79,2,'1078','Santa Rosa'),(80,2,'1079','Soledad'),(81,2,'1080','Urica'),(82,2,'1081','Uverito'),(83,2,'1082','Valle de G'),(84,2,'1083','Zuata'),(85,3,'1084','Achaguas'),(86,3,'1085','Apurito'),(87,3,'1086','Arichuna'),(88,3,'1087','Biruaca'),(89,3,'1088','Bruzual'),(90,3,'1089','El Amparo'),(91,3,'1090','El Nula'),(92,3,'1091','El Recreo'),(93,3,'1092','El Samán d'),(94,3,'1093','El Yagual'),(95,3,'1094','Elorza'),(96,3,'1095','Guachara'),(97,3,'1096','Guasdualit'),(98,3,'1097','Guasimal'),(99,3,'1098','La Estacad'),(100,3,'1099','La Trinida'),(101,3,'1100','La Victori'),(102,3,'1101','Mantecal'),(103,3,'1102','Palmarito'),(104,3,'1103','Puerto Páe'),(105,3,'1104','Quintero'),(106,3,'1105','San Fernan'),(107,3,'1106','San Fernan'),(108,3,'1107','San Juan d'),(109,3,'1108','San Miguel'),(110,3,'1109','San Rafael'),(111,3,'1110','San Vicent'),(112,4,'1111','19 de Abri'),(113,4,'1112','Barbacoas'),(114,4,'1113','Bella Vist'),(115,4,'1114','Cagua'),(116,4,'1115','Camatagua'),(117,4,'1116','Camatagua'),(118,4,'1117','Caña de Az'),(119,4,'1118','Carmen de '),(120,4,'1119','Choroní'),(121,4,'1120','Chuao'),(122,4,'1121','El Limón'),(123,4,'1122','Francisco '),(124,4,'1123','Güiripa'),(125,4,'1124','La Pica'),(126,4,'1125','La Victori'),(127,4,'1126','Las Guacam'),(128,4,'1127','Las Merced'),(129,4,'1128','Las Peñita'),(130,4,'1129','Las Tejerí'),(131,4,'1130','Los Bagres'),(132,4,'1131','Magdaleno'),(133,4,'1132','Maracay'),(134,4,'1133','Ollas de C'),(135,4,'1134','Palo Negro'),(136,4,'1135','Pao de Zár'),(137,4,'1136','Paraparal'),(138,4,'1137','Rosario de'),(139,4,'1138','San Casimi'),(140,4,'1139','San Franci'),(141,4,'1140','San Franci'),(142,4,'1141','San Joaquí'),(143,4,'1142','Santa Rita'),(144,4,'1143','Taguay'),(145,4,'1144','Tiara'),(146,4,'1145','Tocorón'),(147,4,'1146','Turmero'),(148,4,'1147','Valle Morí'),(149,4,'1148','Villa de C'),(150,4,'1149','Zuata'),(151,5,'1150','Altamira'),(152,5,'1151','Arismendi'),(153,5,'1152','Barinas'),(154,5,'1153','Barinitas'),(155,5,'1154','Barrancas'),(156,5,'1155','Bum-Bum'),(157,5,'1156','Calderas'),(158,5,'1157','Capitanejo'),(159,5,'1158','Chameta'),(160,5,'1159','Ciudad Bol'),(161,5,'1160','Ciudad de '),(162,5,'1161','Curbatí'),(163,5,'1162','Dolores'),(164,5,'1163','El Corozo'),(165,5,'1164','El Real'),(166,5,'1165','El Regalo'),(167,5,'1166','Guadarrama'),(168,5,'1167','La Caramuc'),(169,5,'1168','La Luz'),(170,5,'1169','La Mula'),(171,5,'1170','La Unión'),(172,5,'1171','La Yuca'),(173,5,'1172','Libertad'),(174,5,'1173','Los Guasim'),(175,5,'1174','Maporal'),(176,5,'1175','Masparrito'),(177,5,'1176','Mijagual'),(178,5,'1177','Obispos'),(179,5,'1178','Pedraza La'),(180,5,'1179','Puerto de '),(181,5,'1180','Punta de P'),(182,5,'1181','Quebrada S'),(183,5,'1182','Sabaneta'),(184,5,'1183','San Antoni'),(185,5,'1184','San Rafael'),(186,5,'1185','San Silves'),(187,5,'1186','Santa Bárb'),(188,5,'1187','Santa Cata'),(189,5,'1188','Santa Inés'),(190,5,'1189','Santa Lucí'),(191,5,'1190','Santa Rosa'),(192,5,'1191','Socopó'),(193,5,'1192','Torunos'),(194,5,'1193','Veguitas'),(195,6,'1194','Almacén'),(196,6,'1195','Aripao'),(197,6,'1196','Caicara de'),(198,6,'1197','Ciudad Bol'),(199,6,'1198','Ciudad Gua'),(200,6,'1199','Ciudad Pia'),(201,6,'1200','El Dorado'),(202,6,'1201','El Manteco'),(203,6,'1202','El Miamo'),(204,6,'1203','El Milagro'),(205,6,'1204','El Pao de '),(206,6,'1205','El Rosario'),(207,6,'1206','Guarataro'),(208,6,'1207','Guasipati'),(209,6,'1208','Ikabarú'),(210,6,'1209','La Carolin'),(211,6,'1210','La Paragua'),(212,6,'1211','La Urbana'),(213,6,'1212','Las Bonita'),(214,6,'1213','Las Clarit'),(215,6,'1214','Las Majada'),(216,6,'1215','Maripa'),(217,6,'1216','Moitaco'),(218,6,'1217','Morichalit'),(219,6,'1218','Pozo Verde'),(220,6,'1219','San Franci'),(221,6,'1220','San José d'),(222,6,'1221','Santa Bárb'),(223,6,'1222','Santa Elen'),(224,6,'1223','Santa Rosa'),(225,6,'1224','Tumeremo'),(226,6,'1225','Upata'),(227,7,'1226','Bejuma'),(228,7,'1227','Belén'),(229,7,'1228','Borburata'),(230,7,'1229','Canoabo'),(231,7,'1231','Chirgua'),(232,7,'1230','Central Ta'),(233,7,'1232','Guacara'),(234,7,'1233','Güigüe'),(235,7,'1234','Los Guayos'),(236,7,'1235','Los Naranj'),(237,7,'1236','Mariara'),(238,7,'1237','Miranda'),(239,7,'1238','Montalbán'),(240,7,'1239','Morón'),(241,7,'1240','Naguanagua'),(242,7,'1241','Patanemo'),(243,7,'1242','Puerto Cab'),(244,7,'1243','San Diego'),(245,7,'1244','San Joaquí'),(246,7,'1245','Tocuyito'),(247,7,'1246','Urama'),(248,7,'1247','Valencia'),(249,7,'1248','Valencia'),(250,7,'1249','Yagua'),(251,8,'1250','Apartadero'),(252,8,'1251','Cojedes'),(253,8,'1252','El Amparo'),(254,8,'1253','El Baúl'),(255,8,'1254','El Pao'),(256,8,'1255','La Aguadit'),(257,8,'1256','La Sierra'),(258,8,'1257','Las Vegas'),(259,8,'1258','Libertad'),(260,8,'1259','Macapo'),(261,8,'1260','Manrique'),(262,8,'1261','San Carlos'),(263,8,'1262','Sucre'),(264,8,'1263','Tinaco'),(265,8,'1264','Tinaquillo'),(266,9,'1265','Araguabisi'),(267,9,'1266','Araguaimuj'),(268,9,'1267','Boca de Cu'),(269,9,'1268','Capure'),(270,9,'1269','Carapal de'),(271,9,'1270','Curiapo'),(272,9,'1271','El Triunfo'),(273,9,'1272','Hacienda d'),(274,9,'1273','La Horquet'),(275,9,'1274','Manoa'),(276,9,'1275','Moruca'),(277,9,'1276','Paloma'),(278,9,'1277','Pedernales'),(279,9,'1278','Piacoa'),(280,9,'1279','San Franci'),(281,9,'1280','San Rafael'),(282,9,'1281','Santa Cata'),(283,9,'1282','Sierra Ima'),(284,9,'1283','Tucupita'),(285,9,'1284','Urbanizaci'),(286,9,'1285','Urbanizaci'),(287,10,'1286','Acurigua'),(288,10,'1287','Adaure'),(289,10,'1288','Adícora'),(290,10,'1289','Agua Larga'),(291,10,'1290','Agua Linda'),(292,10,'1291','Aracua'),(293,10,'1292','Araurima'),(294,10,'1293','Baraived'),(295,10,'1294','Bariro'),(296,10,'1295','Boca de Ar'),(297,10,'1296','Boca de To'),(298,10,'1297','Borojó'),(299,10,'1298','Buena Vist'),(300,10,'1299','Cabure'),(301,10,'1300','Capadare'),(302,10,'1301','Capatárida'),(303,10,'1302','Casigua'),(304,10,'1303','Chichirivi'),(305,10,'1304','Churuguara'),(306,10,'1305','Coro'),(307,10,'1306','Curimagua'),(308,10,'1307','El Charal'),(309,10,'1308','El Hato'),(310,10,'1309','El Mananti'),(311,10,'1310','El Mene de'),(312,10,'1311','El Moyepo'),(313,10,'1312','El Paují'),(314,10,'1313','El Tupí'),(315,10,'1314','El Vínculo'),(316,10,'1315','Guaibacoa'),(317,10,'1316','Guajiro'),(318,10,'1317','Jacura'),(319,10,'1318','Jadacaquiv'),(320,10,'1319','Judibana'),(321,10,'1320','La Ciénaga'),(322,10,'1321','La Cruz de'),(323,10,'1322','La Negrita'),(324,10,'1323','La Pastora'),(325,10,'1324','La Peña'),(326,10,'1325','La Soledad'),(327,10,'1326','La Vela de'),(328,10,'1327','Las Calder'),(329,10,'1328','Las Vegas '),(330,10,'1329','Mapararí'),(331,10,'1330','Mene de Ma'),(332,10,'1331','Mitare'),(333,10,'1332','Moruy'),(334,10,'1333','Pecaya'),(335,10,'1334','Pedregal'),(336,10,'1335','Piedra Gra'),(337,10,'1336','Píritu'),(338,10,'1337','Píritu'),(339,10,'1338','Pueblo Cum'),(340,10,'1339','Pueblo Nue'),(341,10,'1340','Pueblo Nue'),(342,10,'1341','Puerto Cum'),(343,10,'1342','Punta Card'),(344,10,'1343','Punto Fijo'),(345,10,'1344','Purureche'),(346,10,'1345','Río Seco'),(347,10,'1346','Sabaneta'),(348,10,'1347','San Félix'),(349,10,'1348','San José d'),(350,10,'1349','San José d'),(351,10,'1350','San Juan d'),(352,10,'1351','San Luis'),(353,10,'1352','San Luis'),(354,10,'1353','Santa Ana'),(355,10,'1354','Santa Ana '),(356,10,'1355','Santa Cruz'),(357,10,'1356','Santa Cruz'),(358,10,'1357','Seque'),(359,10,'1358','Tocuyo de '),(360,10,'1359','Tucacas'),(361,10,'1360','Tupure'),(362,10,'1361','Urumaco'),(363,10,'1362','Zazárida'),(364,11,'1363','Altagracia'),(365,11,'1364','Altamira'),(366,11,'1365','Cabruta'),(367,11,'1366','Calabozo'),(368,11,'1367','Camaguán'),(369,11,'1368','Cantagallo'),(370,11,'1369','Cazorla'),(371,11,'1370','Chaguarama'),(372,11,'1371','El Calvari'),(373,11,'1372','El Rastro'),(374,11,'1373','El Socorro'),(375,11,'1374','El Sombrer'),(376,11,'1375','Espino'),(377,11,'1376','Guardatina'),(378,11,'1377','Guayabal'),(379,11,'1378','La Unión d'),(380,11,'1379','Las Merced'),(381,11,'1380','Lezama'),(382,11,'1381','Libertad d'),(383,11,'1382','Ortiz'),(384,11,'1383','Parapara'),(385,11,'1384','Paso Real '),(386,11,'1385','Puerto Mir'),(387,11,'1386','Sabana Gra'),(388,11,'1387','San Franci'),(389,11,'1388','San Franci'),(390,11,'1389','San José d'),(391,11,'1390','San José d'),(392,11,'1391','San José d'),(393,11,'1392','San Juan d'),(394,11,'1393','San Rafael'),(395,11,'1394','San Rafael'),(396,11,'1395','Santa Marí'),(397,11,'1396','Santa Rita'),(398,11,'1397','Sosa'),(399,11,'1398','Tucupido'),(400,11,'1399','Uverito'),(401,11,'1400','Valle de L'),(402,11,'1401','Zaraza'),(403,12,'1402','Agua Negra'),(404,12,'1403','Agua Viva'),(405,12,'1404','Anzoátegui'),(406,12,'1405','Aregue'),(407,12,'1406','Arenales'),(408,12,'1407','Atarigua'),(409,12,'1408','Barbacoas'),(410,12,'1409','Barquisimeto'),(411,12,'1410','Bobare'),(412,12,'1411','Buena Vista'),(413,12,'1412','Burere'),(414,12,'1413','Cabudare'),(415,12,'1414','Carora'),(416,12,'1415','Cuara'),(417,12,'1416','Cubiro'),(418,12,'1417','Curarigua'),(419,12,'1418','Duaca'),(420,12,'1419','Duaca'),(421,12,'1420','El Empedra'),(422,12,'1421','El Eneal'),(423,12,'1422','El Hato'),(424,12,'1423','El Jabón'),(425,12,'1424','El Parader'),(426,12,'1425','El Tocuyo'),(427,12,'1426','Guaitó'),(428,12,'1427','Guarico'),(429,12,'1428','Humocaro Alto'),(430,12,'1429','Humocaro Bajo'),(431,12,'1430','La Ceiba'),(432,12,'1431','La Escaler'),(433,12,'1432','La Miel'),(434,12,'1433','La Pastora'),(435,12,'1434','Los Rastro'),(436,12,'1435','Manzanita'),(437,12,'1436','Palmarito'),(438,12,'1437','Quebrada A'),(439,12,'1438','Quíbor'),(440,12,'1439','Río Claro'),(441,12,'1440','Río Tocuyo'),(442,12,'1441','San Francisco'),(443,12,'1442','San Miguel'),(444,12,'1443','San Pedro'),(445,12,'1444','Sanare'),(446,12,'1445','Sarare'),(447,12,'1446','Tintorero'),(448,12,'1447','Villanueva'),(449,13,'1448','Acequias'),(450,13,'1449','Arapuey'),(451,13,'1450','Aricagua'),(452,13,'1451','Campo Elía'),(453,13,'1452','Canaguá'),(454,13,'1453','Capurí'),(455,13,'1454','Chacantá'),(456,13,'1455','Ejido'),(457,13,'1456','El Molino'),(458,13,'1457','El Pinar'),(459,13,'1458','El Viento'),(460,13,'1459','El Vigía'),(461,13,'1460','Guaraque'),(462,13,'1461','Jají'),(463,13,'1462','La Blanca '),(464,13,'1463','La Mesa'),(465,13,'1464','La Palmita'),(466,13,'1465','Las Piedra'),(467,13,'1466','Los Naranj'),(468,13,'1467','Mérida'),(469,13,'1468','Mesa Bolív'),(470,13,'1469','Mesa de La'),(471,13,'1470','Mesa de Qu'),(472,13,'1471','Mucuchachí'),(473,13,'1472','Mucujepe'),(474,13,'1473','Mucutuy'),(475,13,'1474','Río Negro'),(476,13,'1475','San Cristó'),(477,13,'1476','San José'),(478,13,'1477','San José d'),(479,13,'1478','Santa Cruz'),(480,13,'1479','Santo Domi'),(481,13,'1480','Torondoy'),(482,13,'1481','Tucaní'),(483,14,'1482','Altagracia'),(484,14,'1483','Aragüita'),(485,14,'1484','Araira'),(486,14,'1485','Capaya'),(487,14,'1486','Carrizal'),(488,14,'1487','Caucagua'),(489,14,'1488','Caucagüita'),(490,14,'1489','Chacao'),(491,14,'1490','Charallave'),(492,14,'1491','Cúa'),(493,14,'1492','Cumbo'),(494,14,'1493','Cúpira'),(495,14,'1494','Curiepe'),(496,14,'1495','El Café'),(497,14,'1496','El Cafetal'),(498,14,'1497','El Cartana'),(499,14,'1498','El Clavo'),(500,14,'1499','El Guapo'),(501,14,'1500','El Hatillo'),(502,14,'1501','El Jarillo'),(503,14,'1502','Fila de Ma'),(504,14,'1503','Guarenas'),(505,14,'1504','Guatire'),(506,14,'1505','Higuerote'),(507,14,'1506','La Democra'),(508,14,'1507','La Dolorit'),(509,14,'1508','Las Brisas'),(510,14,'1509','Las Minas '),(511,14,'1510','Los Dos Ca'),(512,14,'1511','Los Teques'),(513,14,'1512','Los Teques'),(514,14,'1513','Machurucut'),(515,14,'1514','Mamporal'),(516,14,'1515','Marizapa'),(517,14,'1516','Nuestra Se'),(518,14,'1517','Nueva Cúa'),(519,14,'1518','Ocumare de'),(520,14,'1519','Panaquire'),(521,14,'1520','Paparo'),(522,14,'1521','Paracotos'),(523,14,'1522','Petare'),(524,14,'1523','Río Chico'),(525,14,'1524','San Antoni'),(526,14,'1525','San Antoni'),(527,14,'1526','San Diego'),(528,14,'1527','San Fernan'),(529,14,'1528','San Franci'),(530,14,'1529','San José d'),(531,14,'1530','San Pedro'),(532,14,'1531','Santa Bárb'),(533,14,'1532','Santa Lucí'),(534,14,'1533','Santa Tere'),(535,14,'1534','Tacarigua '),(536,14,'1535','Tacarigua '),(537,14,'1536','Tácata'),(538,14,'1537','Tapipa'),(539,15,'1538','Aparicio'),(540,15,'1539','Aragua'),(541,15,'1540','Areo'),(542,15,'1541','Cachipo'),(543,15,'1542','Caicara'),(544,15,'1543','Caripe'),(545,15,'1544','Chaguarama'),(546,15,'1545','El Corozo'),(547,15,'1546','El Furrial'),(548,15,'1547','El Guáchar'),(549,15,'1548','El Pinto'),(550,15,'1549','El Tejero'),(551,15,'1550','Guanaguana'),(552,15,'1551','Jusepín'),(553,15,'1552','La Guanota'),(554,15,'1553','La Pica'),(555,15,'1554','La Toscana'),(556,15,'1555','Las Alhuac'),(557,15,'1556','Los Barran'),(558,15,'1557','Maturín'),(559,15,'1558','Punta de M'),(560,15,'1559','Quiriquire'),(561,15,'1560','Sabana de '),(562,15,'1561','San Agustí'),(563,15,'1562','San Antoni'),(564,15,'1563','San Félix'),(565,15,'1564','San Franci'),(566,15,'1565','San Vicent'),(567,15,'1566','Tabasca'),(568,15,'1567','Taguaya'),(569,15,'1568','Temblador'),(570,15,'1569','Teresén'),(571,15,'1570','Viento Fre'),(572,16,'1571','Altagracia'),(573,16,'1572','Boca del R'),(574,16,'1573','El Guamach'),(575,16,'1574','El Maco'),(576,16,'1575','El Pilar ('),(577,16,'1576','El Valle d'),(578,16,'1577','Güinima'),(579,16,'1578','Juangriego'),(580,16,'1579','La Asunció'),(581,16,'1580','La Guardia'),(582,16,'1581','Los Millan'),(583,16,'1582','Pampatar'),(584,16,'1583','Pedro Gonz'),(585,16,'1584','Punta de P'),(586,16,'1585','San Juan B'),(587,16,'1586','San Pedro '),(588,16,'1587','Santa Ana'),(589,16,'1588','Tacarigua'),(590,16,'1589','Villa Rosa'),(591,17,'1590','Acarigua'),(592,17,'1591','Araure'),(593,17,'1592','Biscucuy'),(594,17,'1593','Boconoito'),(595,17,'1594','Caño Delga'),(596,17,'1595','Colonia Tu'),(597,17,'1596','Córdoba'),(598,17,'1597','El Algarro'),(599,17,'1598','El Playón'),(600,17,'1599','Guanare'),(601,17,'1600','Guanare'),(602,17,'1601','Guanarito'),(603,17,'1602','La Aparici'),(604,17,'1603','La Concepc'),(605,17,'1604','La Estació'),(606,17,'1605','La Misión'),(607,17,'1606','Las Cruces'),(608,17,'1607','Mesa de Ca'),(609,17,'1608','Mijagüito'),(610,17,'1609','Morrones'),(611,17,'1610','Nueva Flor'),(612,17,'1611','Ospino'),(613,17,'1612','Papelón'),(614,17,'1613','Paraíso de'),(615,17,'1614','Payara'),(616,17,'1615','Peña Blanc'),(617,17,'1616','Pimpinela'),(618,17,'1617','Píritu'),(619,17,'1618','Quebrada d'),(620,17,'1619','Río Acarig'),(621,17,'1620','San José d'),(622,17,'1621','San José d'),(623,17,'1622','San Nicolá'),(624,17,'1623','San Rafael'),(625,17,'1624','San Rafael'),(626,17,'1625','Santa Cruz'),(627,17,'1626','Santa Fe'),(628,17,'1627','Trinidad d'),(629,17,'1628','Uveral'),(630,17,'1629','Villa Bruz'),(631,17,'1630','Villa Rosa'),(632,18,'1631','Araya'),(633,18,'1632','Araya'),(634,18,'1633','Arenas'),(635,18,'1634','Aricagua'),(636,18,'1635','Caigüire'),(637,18,'1636','Campo Clar'),(638,18,'1637','Cariaco'),(639,18,'1638','Carúpano'),(640,18,'1639','Casanay'),(641,18,'1640','Catuaro'),(642,18,'1641','Chacopata'),(643,18,'1642','Cumaná'),(644,18,'1643','Cumanacoa'),(645,18,'1644','El Morro d'),(646,18,'1645','El Paujil'),(647,18,'1646','El Pilar'),(648,18,'1647','El Rincón'),(649,18,'1648','Guaraúnos'),(650,18,'1649','Guariquén'),(651,18,'1650','Guayana'),(652,18,'1651','Güiria'),(653,18,'1652','Irapa'),(654,18,'1653','Las Piedra'),(655,18,'1654','Los Altos'),(656,18,'1655','Los Arroyo'),(657,18,'1656','Los Puerto'),(658,18,'1657','Macuro'),(659,18,'1658','Manicuare'),(660,18,'1659','Marabal'),(661,18,'1660','Playa Gran'),(662,18,'1661','Puerto San'),(663,18,'1662','Río Caribe'),(664,18,'1663','Río Casana'),(665,18,'1664','Rio Salado'),(666,18,'1665','Río Seco'),(667,18,'1666','San Antoni'),(668,18,'1667','San José d'),(669,18,'1668','San Juan'),(670,18,'1669','San Juan d'),(671,18,'1670','San Juan d'),(672,18,'1671','San Lorenz'),(673,18,'1672','San Vicent'),(674,18,'1673','Santa Cruz'),(675,18,'1674','Santa Marí'),(676,18,'1675','Soro'),(677,18,'1676','Tunapuicit'),(678,18,'1677','Tunapuy'),(679,18,'1678','Villa Fron'),(680,18,'1679','Villarroel'),(681,18,'1680','Yaguarapar'),(682,18,'1681','Yoco'),(683,19,'1682','Abejales'),(684,19,'1683','Aguas Cali'),(685,19,'1684','Boca de Gr'),(686,19,'1685','Boconó'),(687,19,'1686','Borotá'),(688,19,'1687','Bramón'),(689,19,'1688','Capacho Nu'),(690,19,'1689','Capacho Vi'),(691,19,'1690','Colón'),(692,19,'1691','Coloncito'),(693,19,'1692','El Milagro'),(694,19,'1693','El Pueblit'),(695,19,'1694','El Recreo'),(696,19,'1695','El Valle'),(697,19,'1696','Hato de la'),(698,19,'1697','Hernández'),(699,19,'1698','La Florida'),(700,19,'1699','La Fría'),(701,19,'1700','La Fundaci'),(702,19,'1701','La Grita'),(703,19,'1702','La Palmita'),(704,19,'1703','La Tendida'),(705,19,'1704','Laguna de '),(706,19,'1705','Las Dantas'),(707,19,'1706','Lobatera'),(708,19,'1707','Macanillo'),(709,19,'1708','Mesa del T'),(710,19,'1709','Orope'),(711,19,'1710','Palo Gordo'),(712,19,'1711','Palotal'),(713,19,'1712','Patio Redo'),(714,19,'1713','Peribeca'),(715,19,'1714','Pregonero'),(716,19,'1715','Pueblo Hon'),(717,19,'1716','Puerto Nue'),(718,19,'1717','Puerto Tet'),(719,19,'1718','Queniquea'),(720,19,'1719','Río Chiqui'),(721,19,'1720','Rubio'),(722,19,'1721','Sabana Gra'),(723,19,'1722','San Antoni'),(724,19,'1723','San Cristó'),(725,19,'1724','San Félix'),(726,19,'1725','San Joaquí'),(727,19,'1726','San Lorenz'),(728,19,'1727','San Pablo'),(729,19,'1728','San Pedro '),(730,19,'1729','San Rafael'),(731,19,'1730','San Vicent'),(732,19,'1731','Táriba'),(733,19,'1732','Ureña'),(734,20,'1733','Agua Calie'),(735,20,'1734','Agua Santa'),(736,20,'1735','Altamira d'),(737,20,'1736','Araguaney'),(738,20,'1737','Batatal'),(739,20,'1738','Betijoque'),(740,20,'1739','Boconó'),(741,20,'1740','Bolivia'),(742,20,'1741','Buena Vist'),(743,20,'1742','Burbusay'),(744,20,'1743','Cabimbú'),(745,20,'1744','Campo Aleg'),(746,20,'1745','Campo Elía'),(747,20,'1746','Carache'),(748,20,'1747','Carvajal'),(749,20,'1748','Casa de Ta'),(750,20,'1749','Chejendé'),(751,20,'1750','Chiquinqui'),(752,20,'1751','Cuicas'),(753,20,'1752','El Alto'),(754,20,'1753','El Baño'),(755,20,'1754','El Carmen'),(756,20,'1755','El Cenizo'),(757,20,'1756','El Dividiv'),(758,20,'1757','El Gallo'),(759,20,'1758','El Jagüito'),(760,20,'1759','El Parader'),(761,20,'1760','El Paraíso'),(762,20,'1761','El Zapater'),(763,20,'1762','Escuque'),(764,20,'1763','Flor de Pa'),(765,20,'1764','Granados'),(766,20,'1765','Guaramacal'),(767,20,'1766','Isnotú'),(768,20,'1767','Jajó'),(769,20,'1768','Jalisco'),(770,20,'1769','Juan Ignac'),(771,20,'1770','Junín'),(772,20,'1771','La Beatriz'),(773,20,'1772','La Ceiba'),(774,20,'1773','La Cejita'),(775,20,'1774','La Concepc'),(776,20,'1775','La Cuchill'),(777,20,'1776','La Mata'),(778,20,'1777','La Mesa de'),(779,20,'1778','La Placita'),(780,20,'1779','La Plazuel'),(781,20,'1780','La Puerta'),(782,20,'1781','La Quebrad'),(783,20,'1782','Las Llanad'),(784,20,'1783','Las Meseta'),(785,20,'1784','Las Mesita'),(786,20,'1785','Las Quebra'),(787,20,'1786','Las Rurale'),(788,20,'1787','Los Capric'),(789,20,'1788','Los Cedros'),(790,20,'1789','Matriz'),(791,20,'1790','Mendoza'),(792,20,'1791','Mercedes D'),(793,20,'1792','Minas'),(794,20,'1793','Mitón'),(795,20,'1794','Monay'),(796,20,'1795','Monte Carm'),(797,20,'1796','Mosquey'),(798,20,'1797','Motatán'),(799,20,'1798','Niquitao'),(800,20,'1799','Pampán'),(801,20,'1800','Pampanito'),(802,20,'1801','Pampanito '),(803,20,'1802','Rafael Ran'),(804,20,'1803','Sabana de '),(805,20,'1804','Sabana Gra'),(806,20,'1805','Sabana Lib'),(807,20,'1806','San Jacint'),(808,20,'1807','San Lázaro'),(809,20,'1808','San Luis'),(810,20,'1809','San Miguel'),(811,20,'1810','Santa Ana'),(812,20,'1811','Santa Apol'),(813,20,'1812','Santa Isab'),(814,20,'1813','Santa Rosa'),(815,20,'1814','Santiago'),(816,20,'1815','Torococo'),(817,20,'1816','Tostós'),(818,20,'1817','Tres de Fe'),(819,20,'1818','Tres Esqui'),(820,20,'1819','Trujillo'),(821,20,'1820','Trujillo'),(822,20,'1821','Tuñame'),(823,20,'1822','Valera'),(824,20,'1823','Valerita'),(825,20,'1824','Valmore Ro'),(826,20,'1825','Vega de Gu'),(827,20,'1826','Zona Rica'),(828,21,'1827','Caraballed'),(829,21,'1828','Carayaca'),(830,21,'1829','Catia La M'),(831,21,'1830','El Junko'),(832,21,'1831','La Guaira'),(833,21,'1832','La Sabana'),(834,21,'1833','Macuto'),(835,21,'1834','Maiquetía'),(836,21,'1835','Naiguatá'),(837,22,'1836','Albarico'),(838,22,'1837','Cambural'),(839,22,'1838','Campo Elía'),(840,22,'1839','Casimiro V'),(841,22,'1840','Chivacoa'),(842,22,'1841','Farriar'),(843,22,'1842','Marín'),(844,22,'1843','Nirgua'),(845,22,'1844','Salom'),(846,22,'1845','San Felipe'),(847,22,'1846','Temerla'),(848,22,'1847','Yaritagua'),(849,23,'1848','Bachaquero'),(850,23,'1849','Barranquit'),(851,23,'1850','Bobures'),(852,23,'1851','Cabimas'),(853,23,'1852','Cachirí'),(854,23,'1853','Caja Seca'),(855,23,'1854','Campo Lara'),(856,23,'1855','Carrasquer'),(857,23,'1856','Casigua El'),(858,23,'1857','Ceuta'),(859,23,'1858','Ciudad Oje'),(860,23,'1859','Cojoro'),(861,23,'1860','Concepción'),(862,23,'1861','Concha'),(863,23,'1862','Contreras '),(864,23,'1863','Cuatro Esq'),(865,23,'1864','El Bajo'),(866,23,'1865','El Batey'),(867,23,'1866','El Carmelo'),(868,23,'1867','El Consejo'),(869,23,'1868','El Corozo'),(870,23,'1869','El Cruce'),(871,23,'1870','El Guanába'),(872,23,'1871','El Guayabo'),(873,23,'1872','El Mecocal'),(874,23,'1873','El Mene'),(875,23,'1874','El Molinet'),(876,23,'1875','El Moralit'),(877,23,'1876','El Silenci'),(878,23,'1877','El Tigre'),(879,23,'1878','El Toro'),(880,23,'1879','El Venado'),(881,23,'1880','Encontrado'),(882,23,'1881','Gibraltar'),(883,23,'1882','Jobo Alto '),(884,23,'1883','Kilómetro '),(885,23,'1884','La Concepc'),(886,23,'1885','La Ensenad'),(887,23,'1886','La Paz'),(888,23,'1887','La Sierrit'),(889,23,'1888','La Villa d'),(890,23,'1889','Lagunillas'),(891,23,'1890','Las Parcel'),(892,23,'1891','Las Piedra'),(893,23,'1892','Los Cortij'),(894,23,'1893','Los Naranj'),(895,23,'1894','Los Puerto'),(896,23,'1895','Machiques'),(897,23,'1896','Maracaibo'),(898,23,'1897','Mene Grand'),(899,23,'1898','Palito Bla'),(900,23,'1899','Palmarejo'),(901,23,'1900','Paraguaipo'),(902,23,'1901','Potreritos'),(903,23,'1902','Pueblo Nue'),(904,23,'1903','Pueblo Nue'),(905,23,'1904','Punta Gord'),(906,23,'1905','Quisiro'),(907,23,'1906','Río Negro'),(908,23,'1907','Sabana de '),(909,23,'1908','Sabaneta d'),(910,23,'1909','San Antoni'),(911,23,'1910','San Carlos'),(912,23,'1911','San Carlos'),(913,23,'1912','San Franci'),(914,23,'1913','San Ignaci'),(915,23,'1914','San Isidro'),(916,23,'1915','San José'),(917,23,'1916','San Rafael'),(918,23,'1917','San Rafael'),(919,23,'1918','San Timote'),(920,23,'1919','Santa Bárb'),(921,23,'1920','Santa Cruz'),(922,23,'1921','Santa Cruz'),(923,23,'1922','Santa Marí'),(924,23,'1923','Santa Rita'),(925,23,'1924','Sierra Mae'),(926,23,'1925','Sinamaica'),(927,23,'1926','Sur Améric'),(928,23,'1927','Tamare'),(929,23,'1928','Tía Juana'),(930,24,'1929','23 De Ener'),(931,24,'1930','Altagracia'),(932,24,'1931','Antimano'),(933,24,'1932','Candelaria'),(934,24,'1933','Caricuao'),(935,24,'1934','Catedral'),(936,24,'1935','Coche'),(937,24,'1936','El Junquit'),(938,24,'1937','El Paraiso'),(939,24,'1938','El Recreo'),(940,24,'1939','El Valle'),(941,24,'1940','La Pastora'),(942,24,'1941','La Vega'),(943,24,'1942','Macarao'),(944,24,'1943','San Agusti'),(945,24,'1944','San Bernar'),(946,24,'1945','San Jose'),(947,24,'1946','San Juan'),(948,24,'1947','San Pedro'),(949,24,'1948','Santa Rosa'),(950,24,'1949','Santa Tere'),(951,24,'1950','Sucre');
/*!40000 ALTER TABLE `ciudades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cod_curso`
--

DROP TABLE IF EXISTS `cod_curso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cod_curso` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_4147EFD20332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cod_curso`
--

LOCK TABLES `cod_curso` WRITE;
/*!40000 ALTER TABLE `cod_curso` DISABLE KEYS */;
INSERT INTO `cod_curso` VALUES (2,'IN','INSCRITO'),(3,'APR','APROBADO'),(4,'APLZ','APLAZADO'),(5,'PROC','EN PROCESO'),(7,'EQ','EQUIVALENCIA'),(8,'NOB','NOTA EN OBSERVACION'),(9,'APE','APROBADA POR PRUEBA EXTRAORDINARIA'),(10,'CONV','CONVALIDACION'),(11,'APT','APROBADO POR TRASLADO'),(12,'APC','APROBADO POR CONVENIO'),(13,'APRR','APROBADO POR REVALIDA'),(14,'AAC','APROBADO POR ACREDITACION POR COMPETENCIA'),(15,'RE','APROBADO POR RECONOCIMIENTO DE ESTUDIOS');
/*!40000 ALTER TABLE `cod_curso` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cod_situa`
--

DROP TABLE IF EXISTS `cod_situa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cod_situa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CB54F76B20332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cod_situa`
--

LOCK TABLES `cod_situa` WRITE;
/*!40000 ALTER TABLE `cod_situa` DISABLE KEYS */;
INSERT INTO `cod_situa` VALUES (1,'01','INSCRITO'),(2,'02','SIN INSCRIPCION'),(3,'03','SUSPENDIDO POR REGLAMENTO'),(4,'04','RETIRO PERMANENTE'),(5,'EGR','EGRESADO'),(6,'07','RETIRO POR CANCELACION DE SEMESTRE'),(7,'08','ASESORADO'),(8,'GRD','GRADUANDO'),(9,'10','RETIRO DE SEMESTRE'),(13,'11','RETIRO DE LA INSTITUCION'),(14,'12','RETIRO POR TRASLADO');
/*!40000 ALTER TABLE `cod_situa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cohorte`
--

DROP TABLE IF EXISTS `cohorte`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cohorte` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(30) NOT NULL,
  `sede_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_35697A4B20332D99` (`codigo`),
  KEY `IDX_35697A4BE19F41BF` (`sede_id`),
  CONSTRAINT `FK_35697A4BE19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cohorte`
--

LOCK TABLES `cohorte` WRITE;
/*!40000 ALTER TABLE `cohorte` DISABLE KEYS */;
INSERT INTO `cohorte` VALUES (90,'2017',1),(91,'2018',1),(92,'2019',NULL),(93,'2020',NULL),(94,'2021',NULL),(95,'2022',NULL),(96,'2023',NULL);
/*!40000 ALTER TABLE `cohorte` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `componentes`
--

DROP TABLE IF EXISTS `componentes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `componentes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `descripcion` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_C474BC8820332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `componentes`
--

LOCK TABLES `componentes` WRITE;
/*!40000 ALTER TABLE `componentes` DISABLE KEYS */;
INSERT INTO `componentes` VALUES (1,'CFD','Componente de Formación Docente'),(2,'CFE','Componente de Formación Específico'),(3,'CFC','Componente de Formación Contextualizado'),(4,'EC','Ejes Curriculares');
/*!40000 ALTER TABLE `componentes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cond_depositos`
--

DROP TABLE IF EXISTS `cond_depositos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cond_depositos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(35) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cond_depositos`
--

LOCK TABLES `cond_depositos` WRITE;
/*!40000 ALTER TABLE `cond_depositos` DISABLE KEYS */;
INSERT INTO `cond_depositos` VALUES (1,'Deposito'),(2,'Exonerado');
/*!40000 ALTER TABLE `cond_depositos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_sistema`
--

DROP TABLE IF EXISTS `config_sistema`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_sistema` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `programa_id` int(11) DEFAULT NULL,
  `controlpago` tinyint(1) NOT NULL,
  `montouc` float(11,2) NOT NULL,
  `porcentajeuc` float(11,2) NOT NULL,
  `uc_min` int(11) NOT NULL,
  `uc_max` int(11) NOT NULL,
  `choque` tinyint(1) NOT NULL,
  `cuota1` double NOT NULL,
  `cuota2` double NOT NULL,
  `cuota3` double NOT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `subsede_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E4DE6991FD8A7328` (`programa_id`),
  KEY `IDX_E4DE6991E19F41BF` (`sede_id`),
  KEY `IDX_E4DE6991AAFDE970` (`subsede_id`),
  CONSTRAINT `FK_E4DE6991AAFDE970` FOREIGN KEY (`subsede_id`) REFERENCES `subsede` (`id`),
  CONSTRAINT `FK_E4DE6991E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`),
  CONSTRAINT `FK_E4DE6991FD8A7328` FOREIGN KEY (`programa_id`) REFERENCES `programa` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_sistema`
--

LOCK TABLES `config_sistema` WRITE;
/*!40000 ALTER TABLE `config_sistema` DISABLE KEYS */;
INSERT INTO `config_sistema` VALUES (1,1,0,0.00,0.00,0,6,0,0,0,0,NULL,NULL);
/*!40000 ALTER TABLE `config_sistema` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_pagos`
--

DROP TABLE IF EXISTS `control_pagos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `control_pagos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `cuota` varchar(50) NOT NULL,
  `monto` double NOT NULL,
  `pagado` tinyint(1) NOT NULL,
  `fecha_pago` datetime NOT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `subsede_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_6162A4A259590C39` (`estudiante_id`),
  KEY `IDX_6162A4A280B24165` (`lapso_id`),
  KEY `IDX_6162A4A2E19F41BF` (`sede_id`),
  KEY `IDX_6162A4A2AAFDE970` (`subsede_id`),
  CONSTRAINT `FK_6162A4A259590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `FK_6162A4A280B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_6162A4A2AAFDE970` FOREIGN KEY (`subsede_id`) REFERENCES `subsede` (`id`),
  CONSTRAINT `FK_6162A4A2E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_pagos`
--

LOCK TABLES `control_pagos` WRITE;
/*!40000 ALTER TABLE `control_pagos` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_pagos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credito_graduando`
--

DROP TABLE IF EXISTS `credito_graduando`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credito_graduando` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sede_id` int(11) DEFAULT NULL,
  `especialidad_id` int(11) DEFAULT NULL,
  `uc_obligatoris` int(11) NOT NULL,
  `uc_electivos` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_3429FE15E19F41BF` (`sede_id`),
  KEY `IDX_3429FE1516A490EC` (`especialidad_id`),
  CONSTRAINT `FK_3429FE1516A490EC` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`),
  CONSTRAINT `FK_3429FE15E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credito_graduando`
--

LOCK TABLES `credito_graduando` WRITE;
/*!40000 ALTER TABLE `credito_graduando` DISABLE KEYS */;
/*!40000 ALTER TABLE `credito_graduando` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cursos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(30) NOT NULL,
  `nombre` varchar(255) NOT NULL,
  `uc` int(11) NOT NULL,
  `observacion` longtext DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `had` int(11) NOT NULL,
  `hle` int(11) NOT NULL,
  `componente_id` int(11) DEFAULT NULL,
  `tipocursos_id` int(11) DEFAULT NULL,
  `area_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_B2785A1820332D99` (`codigo`),
  KEY `IDX_B2785A18E19F41BF` (`sede_id`),
  KEY `IDX_B2785A18BFE3F144` (`componente_id`),
  KEY `IDX_B2785A1892FB6433` (`tipocursos_id`),
  KEY `IDX_B2785A18BD0F409C` (`area_id`),
  CONSTRAINT `FK_B2785A1892FB6433` FOREIGN KEY (`tipocursos_id`) REFERENCES `tipocursos` (`id`),
  CONSTRAINT `FK_B2785A18BD0F409C` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`),
  CONSTRAINT `FK_B2785A18BFE3F144` FOREIGN KEY (`componente_id`) REFERENCES `componentes` (`id`),
  CONSTRAINT `FK_B2785A18E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1065 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
INSERT INTO `cursos` VALUES (1,'CIU0201','Ciudadanía, Soberanía y Democracia',2,'',1,2,4,1,2,1),(2,'ACT0202','Actividad Experimental en Física y en su  Enseñanza Aprendizaje',2,NULL,1,2,4,2,2,1),(3,'ACT0403','Actividad Física, Deporte  y Recreación',4,'',1,4,8,3,1,1),(4,'ADM0204','Administración de Centros de Recursos Informáticos',2,NULL,1,2,4,2,2,1),(5,'ADM0405','Administración de Empresas Socioproductivas I',4,'',1,4,8,2,1,1),(6,'ADM0406','Administración de Empresas Socioproductivas II',4,NULL,1,4,8,2,1,1),(7,'ADM0307','Administración del Talento Humano',3,NULL,1,3,6,2,2,1),(8,'CON0308','Contabilidad de Costos',3,NULL,1,3,6,2,2,1),(9,'MER0309','Mercadotecnia',3,NULL,1,3,6,2,2,1),(10,'ADM2010','Administración de Talleres y Laboratorios',2,'',1,2,4,3,2,1),(11,'ADM3011','Administración de Talleres y Laboratorios',3,'',1,3,6,3,2,1),(12,'ADM2012','Administración del Talento Humano',2,NULL,1,2,4,1,2,1),(13,'ADM4013','Administración Financiera',4,NULL,1,4,8,2,1,1),(14,'ADM4014','Administración Tributaria',4,NULL,1,4,8,2,1,1),(15,'ADQ4015','Adquisición y Desarrollo del Lenguaje',4,'',1,4,8,2,1,1),(16,'AGR2016','Agricultura de Subsistencia',2,NULL,1,2,4,3,2,1),(17,'AGR2017','Agroecología',2,'',1,2,4,2,2,1),(18,'AGR4018','Agroecología',4,'',1,4,8,2,1,1),(19,'AGR4019','Agroindustrias Comunitarias',4,NULL,1,4,8,2,1,1),(20,'ÁLG4020','Álgebra Lineal',4,'',1,4,8,2,1,1),(21,'ALI4021','Alimentación Animal',4,'',1,4,8,2,1,1),(22,'ALT4022','Alternativas de Producción Agrícola',4,NULL,1,4,8,2,1,1),(25,'ANÁ4025','Análisis de Elementos Mecánicos',4,'',1,4,8,2,1,1),(26,'ANÁ4026','Análisis del Texto y la Representación Teatral',4,'',1,4,8,2,1,1),(27,'ANÁ4027','Análisis y Organización del Espacio Geográfico',4,'',1,4,8,2,1,1),(28,'ANA4028','Anatomía y Fisiología Animal',4,'',1,4,8,2,1,1),(29,'ANA4029','Anatomía y Fisiología Humana',4,'',1,4,8,2,1,1),(30,'ANA4030','Anatomía y Fisiología Vegetal',4,'',1,4,8,2,1,1),(31,'ANT3031','Antena',3,'',1,3,6,3,2,1),(32,'APR4032','Aprendizaje Matemático I',4,'',1,4,8,2,1,1),(33,'APR4033','Aprendizaje Matemático II',4,'',1,4,8,2,1,1),(34,'ARQ4034','Arquitectura del Computador',4,NULL,1,4,8,2,1,1),(35,'ART4035','Arte Venezolano y Cotidianidad',4,NULL,1,4,8,2,1,1),(37,'ART2037','Arte y Creatividad Educativa',2,'',1,2,4,1,2,1),(38,'ART2038','Arte y Educación',2,'',1,2,4,3,2,1),(39,'AST3039','Astronomía',3,'',1,3,6,2,1,1),(40,'AST2040','Astronomia',2,'',1,2,4,2,2,1),(41,'ATE4041','Atención a Niños y Jóvenes con Discapacidad',4,'',1,4,8,2,1,1),(42,'ATE4042','Atención en Espacios de Familia y Comunidad',4,NULL,1,4,8,2,1,1),(43,'ATE4043','Atención Integral del Infante de 0 a 6 años',4,NULL,1,4,8,2,1,1),(44,'ATE2044','Prevención y Atención Primaria en la Actividad Física',4,NULL,1,4,8,2,1,1),(45,'AUL4045','Aula Cultural Interactiva',4,'',1,4,8,2,1,1),(46,'AUL4046','Aula Musical Interactiva',4,'',1,4,8,2,1,1),(47,'BAL3047','Baloncesto para la Educación',3,'',1,3,6,3,2,1),(48,'BAS3048','Bases Científicas de la Actividad Física',2,NULL,1,2,4,2,2,1),(49,'BIO2049','Biodiversidad',2,'',1,2,4,1,2,1),(50,'BIO2050','Biodiversidad y Acción Social',2,'',1,2,4,3,2,1),(51,'BIO2051','Bioética',2,'',1,2,4,2,2,1),(52,'BIO2052','Bioética',2,'',1,2,4,1,2,1),(53,'BIO2053','Bioética',2,NULL,1,2,4,3,2,1),(54,'BIO4054','Biofísica',4,'',1,4,8,2,1,1),(55,'BIO4055','Biología Animal',4,'',1,4,8,2,1,1),(56,'BIO4056','Biología Celular y Molecular',4,'',1,4,8,2,1,1),(57,'BIO3057','Biología General',3,'',1,3,6,2,1,1),(58,'BIO4058','Biomecánica',4,'',1,4,8,2,1,1),(59,'BIO4059','Bioquímica',4,'',1,4,8,2,1,1),(60,'BIO4060','Bioquímica Estructural',3,NULL,1,3,6,2,1,1),(61,'BIO3061','Bioquímica Metabólica',3,'',1,3,6,2,1,1),(62,'BIO4062','Bioseguridad Animal',4,'',1,4,8,2,1,1),(63,'BIO4063','Bioseguridad Vegetal',4,'',1,4,8,2,1,1),(64,'BOT4064','Botánica',4,'',1,4,8,2,1,1),(65,'BOT2065','Botánica Sistemática',2,'',1,2,4,2,2,1),(66,'CÁL2066','Cálculo',2,'',1,2,4,2,2,1),(67,'CÁL4067','Cálculo de Funciones de Varias Variables',4,'',1,4,8,2,1,1),(68,'CÁL4068','Cálculo Diferencial',4,'',1,4,8,2,1,1),(69,'CÁL4069','Cálculo Integral',4,'',1,4,8,2,1,1),(70,'CAR2070','Cartografía Básica',2,'',1,2,4,2,2,1),(71,'CAR4071','Cartografía y Fotointerpretación',4,'',1,4,8,2,1,1),(72,'CAS2072','Castellano',2,'',1,2,4,3,2,1),(73,'CIE2073','Ciencia y Tecnología',2,'',1,2,4,3,2,1),(74,'BIO2074','Biodiversidad y Acción Social',2,NULL,1,2,4,3,2,1),(77,'DIV2077','Diversidad y Unidad de la Materia',2,NULL,1,2,4,3,2,1),(78,'CIE2078','Ciencia, Tecnología y Sociedad',2,'',1,2,4,3,2,1),(79,'CIE4079','Ciencias De La Naturaleza',4,'',1,4,8,2,1,1),(80,'CIE3080','Ciencias de la Tierra',3,'',1,3,6,2,1,1),(81,'CIE4081','Ciencias Integradas',4,NULL,1,4,8,2,1,1),(82,'CIE3082','Ciencias Naturales',3,'',1,3,6,2,1,1),(83,'CIE4083','Ciencias Naturales',4,'',1,4,8,2,1,1),(84,'CIU2084','Ciudadanía y Democracia',2,'',1,2,4,1,2,1),(85,'CLI4085','Climatología Física',4,'',1,4,8,2,1,1),(86,'COM4086','Comercialización en el Contexto Rural',4,'',1,4,8,2,1,1),(87,'COM2087','Comportamiento y Desarrollo Organizacional',2,NULL,1,2,4,2,2,1),(88,'COM3088','Comprensión de Sistemas Ambientales',3,'',1,3,6,3,2,1),(89,'COM4089','Comprensión de Textos Orales y Escritos',4,'',1,4,8,2,1,1),(90,'COM2090','Comprensión y Producción de Textos en Inglés',2,NULL,1,2,4,2,2,1),(91,'COM4091','Computación Aplicada al Diseño',4,NULL,1,4,8,2,1,1),(92,'COM2092','Comunicaciones I',2,'',1,2,4,2,2,1),(93,'COM3093','Comunicaciones II',3,'',1,3,6,2,2,1),(94,'CON4094','Consolidación de la Comunicación escrita en Francés',4,'',1,4,8,2,1,1),(95,'CON4095','Consolidación de la Comunicación Escrita en Inglés',4,'',1,4,8,2,1,1),(96,'CON4096','Consolidación de la Comunicación Oral en Francés',4,'',1,4,8,2,1,1),(97,'CON4097','Consolidación de la Comunicación Oral en Inglés',4,'',1,4,8,2,1,1),(98,'CON3098','Contexto y Realidad de la Educación Técnica en Venezuela',3,'',1,3,6,1,2,1),(99,'CON2099','Contexto y Realidad de la Educación Técnica en Venezuela',2,'',1,2,4,1,2,1),(100,'CON3100','Contexto y Realidad de la Educación Técnica en Venezuela',3,'',1,3,6,3,2,1),(101,'CON4101','Control de Motores Eléctricos',4,'',1,4,8,2,1,1),(102,'CON3102','Controlador  Lógico Programable (PLC)',3,NULL,1,3,6,3,2,1),(103,'CON2103','Convivencia Escolar',2,'',1,2,4,3,2,1),(104,'COO2104','Cooperativismo como Medio de Vida',2,NULL,1,2,4,3,2,1),(105,'CRE4105','Creación Artística, Identidad y Ciudadanía',4,NULL,1,4,8,2,1,1),(106,'CRE3106','Creatividad Artística',3,'',1,3,6,1,2,1),(109,'EXP3109','Expresión Corporal',3,NULL,1,3,6,1,2,1),(110,'CUL4110','Cultura Anglófona',4,'',1,4,8,2,1,1),(111,'CUL4111','Cultura del Idioma B Francés',4,NULL,1,4,8,2,1,1),(112,'CUL2112','Cultura Regional y Literatura',2,'',1,2,4,3,2,1),(113,'CUL4113','Cultura y Discurso Literario',4,'',1,4,8,2,1,1),(114,'CUN2114','Cunicultura',2,'',1,2,4,2,2,1),(115,'DAN2115','Danza Tradicional Venezolana',2,'',1,2,4,3,2,1),(116,'DEP4116','Deporte Individuales para la Educación',2,NULL,1,2,4,2,2,1),(117,'DES4117','Desarrollo Curricular',4,'',1,4,8,1,1,1),(118,'DES4118','Desarrollo de la Comunicación en Francés',4,'',1,4,8,2,1,1),(119,'DES4119','Desarrollo de la Comunicación en Inglés',4,'',1,4,8,2,1,1),(120,'DES4120','Desarrollo de Procesos Cognitivos',4,'',1,4,8,1,1,1),(121,'DES3121','Desarrollo de Proyectos en la Creación Artística',3,NULL,1,3,6,2,2,1),(122,'DES4122','Desarrollo Endógeno y Contextos Indígenas',4,NULL,1,4,8,2,1,1),(123,'DES4123','Desarrollo Infantil I Maternal',4,NULL,1,4,8,2,1,1),(124,'DES4124','Desarrollo Infantil II Preescolar',4,NULL,1,4,8,2,1,1),(126,'DES2126','Desarrollo Socio-Afectivo y Sexualidad',2,'',1,2,4,2,2,1),(127,'DIB4127','Dibujo Aplicado I',4,NULL,1,4,8,2,1,1),(128,'DIB4128','Dibujo Aplicado II',4,'',1,4,8,2,1,1),(129,'DIB2129','Dibujo Técnico',2,NULL,1,2,4,3,2,1),(130,'DIB2130','Dibujo Electrónico',2,'',1,2,4,2,2,1),(131,'DIB4131','Dibujo Geométrico',4,'',1,4,8,2,1,1),(132,'DIB4132','Dibujo Mecánico',4,'',1,4,8,2,1,1),(133,'DIB4133','Dibujo Técnico',4,'',1,4,8,2,1,1),(134,'DIB2134','Dibujo Técnico',2,'',1,2,4,3,2,1),(135,'DIB4135','Dibujo Técnico Computarizado',4,'',1,4,8,2,1,1),(136,'DID2136','Didáctica Aplicada al Idioma B Francés',2,NULL,1,2,4,1,2,1),(137,'DID3137','Didáctica aplicada al Inglés',3,'',1,3,6,1,2,1),(138,'DID4138','Didáctica de la Educación Comercial',4,NULL,1,4,8,2,1,1),(139,'DID2139','Didáctica de la Educación Industrial',2,'',1,2,4,1,2,1),(140,'DID3140','Didáctica de la Educación Industrial',3,'',1,3,6,1,2,1),(141,'DID4141','Didáctica de la Educación Inicial Maternal',4,NULL,1,4,8,2,1,1),(142,'DID4142','Didáctica de la Educación Preescolar',4,'',1,4,8,2,1,1),(143,'DID4143','Didáctica de la Física',4,NULL,1,4,8,2,1,1),(144,'DID4144','Didáctica de la Geografía y la Historia',4,'',1,4,8,2,1,1),(145,'DID4145','Didáctica de la Informática',4,'',1,4,8,2,1,1),(146,'DID4146','Didáctica de la Lectura y Escritura',4,'',1,4,8,2,1,1),(147,'DID4147','Didáctica de la Matemática',4,'',1,4,8,2,1,1),(148,'DID4148','Didáctica de las Artes Plásticas en sus Diversos Escenarios',4,NULL,1,4,8,2,1,1),(149,'DID2149','Didáctica del Algebra',2,'',1,2,4,2,2,1),(150,'DID3150','Didáctica del Cálculo',3,NULL,1,3,6,2,2,1),(151,'DID4151','Didáctica del Francés',4,NULL,1,4,8,2,1,1),(152,'DID4152','Didáctica del Inglés',4,'',1,4,8,2,1,1),(153,'DID3153','Didáctica del Inglés para Públicos Específicos',3,NULL,1,3,6,1,2,1),(154,'DID4154','Didáctica del Teatro',2,NULL,1,2,4,1,2,1),(155,'DID4155','Didáctica en la Educación Primaria',4,'',1,4,8,2,1,1),(156,'DID4156','Didáctica General',4,'',1,4,8,1,1,1),(157,'DIN2157','Dinámica de los Espacios Fronterizos Venezolanos',2,NULL,1,2,4,2,2,1),(158,'DIN2158','Dinámica del Espacio Geográfico',2,'',1,2,4,1,2,1),(159,'DIN2159','Climatología Aplicada a Venezuela',2,NULL,1,2,4,1,2,1),(160,'DIN2160','Espacio Geográfico Venezolano',2,NULL,1,2,4,1,2,1),(161,'MIC2161','Manejo Integral de Cuencas',2,NULL,1,2,4,1,2,1),(162,'SIG2162','Sistemas de Información Geográfica',2,NULL,1,2,4,1,2,1),(163,'DIS4163','Discurso de la Creación Artística',4,NULL,1,4,8,2,1,1),(164,'DIS4164','Discurso Especializado en Idioma Inglés',4,NULL,1,4,8,3,1,1),(165,'DIS4165','Diseño Instruccional',4,'',1,4,8,2,1,1),(166,'DIV2166','Diversidad Cultural y Lingüística',2,'',1,2,4,3,2,1),(167,'ECO4167','Ecogeografía de Venezuela',4,'',1,4,8,2,1,1),(168,'ECO4168','Ecología',4,'',1,4,8,2,1,1),(169,'ECO4169','Economía Campesina',4,NULL,1,4,8,2,1,1),(170,'ECO4170','Economía del Entorno Organizacional',4,NULL,1,4,8,2,1,1),(171,'ECO3171','Economía y Mercadeo Agrícola',3,'',1,3,6,2,2,1),(172,'ECO3172','Ecopedagogía',3,'',1,3,6,2,2,1),(173,'ECU4173','Ecuaciones Diferenciales',4,'',1,4,8,2,1,1),(174,'EDU2174','Educación  para el desarrollo productivo y sustentable',2,'',1,2,4,2,2,1),(175,'EDU4175','Educación Ambiental',4,'',1,4,8,3,1,1),(176,'EDU2176','Educación Estética',2,'',1,2,4,1,2,1),(177,'EDU3177','Educación Estética',3,'',1,3,6,1,2,1),(178,'EDU4178','Educación Estética',4,'',1,4,8,2,1,1),(179,'EDU2179','Educación Física y Cultura Popular',2,NULL,1,2,4,3,2,1),(180,'EDU4180','Educación Física y Recreación',4,NULL,1,4,8,2,1,1),(181,'EDU3181','Educación Inclusiva',4,NULL,1,4,8,2,1,1),(182,'EDU2182','Educación Intercultural',2,'',1,2,4,3,2,1),(183,'EDU3183','Educación Intercultural Bilingüe',3,'',1,3,6,2,2,1),(184,'EDU2184','Educación no Convencional',2,NULL,1,2,4,2,2,1),(185,'EDU2185','Educación para el Desarrollo Productivo y Sustentable',2,NULL,1,2,4,2,2,1),(186,'EDU3186','Educación para la Diversidad',3,NULL,1,3,6,1,2,1),(187,'EDU4187','Educación para la Participación Comunitaria',4,NULL,1,4,8,2,1,1),(188,'EDU2188','Educación para la Paz',2,'',1,2,4,3,2,1),(189,'EDU3189','Educación para la Promoción de la Salud Integral',3,'',1,3,6,2,1,1),(190,'EDU3190','Educación para la Salud',3,'',1,3,6,3,2,1),(191,'PRI3191','Primeros Auxilios',3,NULL,1,3,6,3,2,1),(194,'EDU4194','Educación para las Artes',4,'',1,4,8,2,1,1),(195,'EDU4195','Educación Rural',4,NULL,1,4,8,2,1,1),(196,'EDU3196','Educación y Derechos Humanos',3,'',1,3,6,3,2,1),(197,'EDU4197','Educación y Emprendimiento Social',4,'',1,4,8,2,1,1),(198,'EJE4198','Ejecución de Estrategias para el Emprendimiento Social',4,'',1,4,8,2,1,1),(199,'EL 2199','El Circo y Pedagogía: Payasos y Manipulación de Objetos Circenses',2,'',1,2,4,2,2,1),(201,'EL 2201','El Juego y la Creatividad',2,'',1,2,4,1,2,1),(203,'EL 3203','El Suelo como Herramienta Didáctica',3,NULL,1,3,6,2,2,1),(204,'EL 4204','El Títere y la Pedagogía',4,'',1,4,8,2,1,1),(205,'ELE3205','Electrónica',3,NULL,1,3,6,2,1,1),(206,'ELE2206','Electrónica Básica',4,NULL,1,4,8,2,1,1),(207,'ELE4207','Electrónica I',4,'',1,4,8,2,1,1),(208,'ELE4208','Electrónica II',4,'',1,4,8,2,1,1),(209,'ELE4209','Electrónica Industrial',4,'',1,4,8,2,1,1),(210,'EMP2210','Emprendimiento en la Educación',2,NULL,1,2,4,3,2,1),(211,'EMP4211','Empresas de Labores Técnicas',4,'',1,4,8,2,1,1),(212,'EMP4212','Empresas de Manufactura',4,'',1,4,8,2,1,1),(213,'ELA2213','Elaboración de Artesanía',2,NULL,1,2,4,2,2,1),(214,'JAR2214','Jardines Ornamentales y Medicinales',2,NULL,1,2,4,2,2,1),(216,'MET2216','Metales y Herrería',2,NULL,1,2,4,2,2,1),(217,'PTE2217','Producción de Textiles',2,NULL,1,2,4,2,2,1),(218,'REC2218','Reciclaje de Materiales',2,NULL,1,2,4,2,2,1),(219,'API2219','Apicultura',2,NULL,1,2,4,2,2,1),(220,'ERA2220','Electricidad y Reparación de Artefactos Eléctricos',2,NULL,1,2,4,2,2,1),(221,'EMP2221','Gastronomía',2,NULL,1,2,4,2,2,1),(222,'HUE2222','Huertos Biointensivos',2,NULL,1,2,4,2,2,1),(223,'MRE2223','Mantenimiento y Reparación Menor  de Edificaciones',2,NULL,1,2,4,2,2,1),(224,'PRO2224','Producción de Especies Menores',2,NULL,1,2,4,2,2,1),(227,'CIE2227','Ciencia y Tecnología de Productos de Frutas y Hortalizas',2,NULL,1,2,4,2,2,1),(228,'CIE2228','Ciencia y Tecnología de Productos Lácteos',2,NULL,1,2,4,2,2,1),(229,'ENF2229','Tendencias en la Actividad Física',2,NULL,1,2,4,1,2,1),(230,'ENF2230','Enfoques y Tendencias Pedagógicas en Educación Inicial',2,NULL,1,2,4,1,2,1),(231,'ENS3231','Ensayos Mecánicos',3,'',1,3,6,2,2,1),(232,'ENS2232','Enseñanza de la Historia de Venezuela con Visión de Género',2,NULL,1,2,4,3,2,1),(233,'ENS3233','Enseñanza de la Literatura',3,'',1,3,6,3,2,1),(234,'INT3234','Introducción a la Literatura',3,NULL,1,3,6,3,2,1),(235,'LIT3235','Literatura para Niños',3,NULL,1,3,6,3,2,1),(237,'ENS4237','Enseñanza de Lenguas Extranjeras\n para niñas y niños',4,'',1,4,8,3,1,1),(238,'ENT3238','Entorno Social de la Matemática',3,NULL,1,3,6,3,2,1),(239,'EPI2239','Epistemología, Historia Y Didáctica De Las Ciencias Naturales',2,'',1,2,4,2,2,1),(240,'ESP4240','Español de Venezuela',4,'',1,4,8,2,1,1),(241,'ESP4241','Español I',4,'',1,4,8,2,1,1),(242,'ESP4242','Español II',4,'',1,4,8,2,1,1),(243,'EST4243','Estadística  y Probabilidad',4,'',1,4,8,2,1,1),(244,'EST4244','Estética y Educación',4,'',1,4,8,2,1,1),(245,'EST2245','Estimulación del Lenguaje Oral',2,NULL,1,2,4,2,2,1),(246,'EST3246','Estrategias Didácticas Creativas',3,'',1,3,6,1,2,1),(248,'EST4248','Estructuras Algebraicas',4,'',1,4,8,2,1,1),(249,'EST4249','Estudio del Discurso Literario en Inglés',4,NULL,1,4,8,2,1,1),(250,'EST3250','Estudios Lingüísticos y Literarios Interculturales',3,'',1,3,6,2,2,1),(251,'ETA2251','Etapas y Desarrollo Emocional Infantil',2,NULL,1,2,4,2,2,1),(252,'ETN2252','Etnología y Manifestaciones Culturales Venezolanas',2,NULL,1,2,4,3,2,1),(253,'ETN2253','Etnomatemática',2,'',1,2,4,2,2,1),(254,'EVA4254','Evaluación de los Procesos de Enseñanza y Aprendizaje del Francés como Lengua Extranjera',4,NULL,1,4,8,2,1,1),(255,'EVA4255','Evaluación de los Procesos de Enseñanza y Aprendizaje del Inglés como Lengua Extranjera',4,'',1,4,8,2,1,1),(256,'EVA4256','Evaluación del Aprendizaje',4,'',1,4,8,1,1,1),(257,'EVO3257','Evolución',3,'',1,3,6,2,1,1),(258,'EXP2258','Expresión Corporal',2,'',1,2,4,3,2,1),(259,'EXP4259','Expresión Creadora',4,'',1,4,8,2,1,1),(260,'EXP4260','Expresión Oral y Escrita',4,'',1,4,8,3,1,1),(261,'EXP2261','Expresión Oral y Escrita',2,'',1,2,4,3,1,1),(262,'EXP2262','Expresión Plástica en el Dibujo Técnico',2,'',1,2,4,2,2,1),(263,'EXP4263','Expresión Plástica en las Etapas del Desarrollo',4,NULL,1,4,8,2,1,1),(264,'FEN3264','Fenómenos De La Química De Trascendencia Aplicativa',3,'',1,3,6,2,2,1),(265,'FÍS4265','Física Aplicada a la Química',3,NULL,1,3,6,2,1,1),(266,'FÍS4266','Física General I',4,'',1,4,8,2,1,1),(267,'FÍS4267','Física General II',4,NULL,1,4,8,2,1,1),(268,'FÍS4268','Física I',4,'',1,4,8,2,1,1),(269,'FÍS2269','Física II',2,'',1,2,4,2,2,1),(270,'FIS4270','Fisicoquímica',4,'',1,4,8,2,1,1),(271,'FLU4271','Fluidos y Termodinámica',4,NULL,1,4,8,2,1,1),(272,'FON3272','Fonética del Idioma B Francés',3,NULL,1,3,6,3,2,1),(273,'FON3273','Fonética del Inglés',3,'',1,3,6,3,2,1),(274,'FON4274','Fonética y Fonología en Inglés',4,'',1,4,8,2,1,1),(275,'FON4275','Fonética y Fonología Francesa',4,NULL,1,4,8,2,1,1),(276,'FOR2276','Formación Moral en la Educación Inicial',2,NULL,1,2,4,1,2,1),(277,'FOR2277','Formación Personal del Docente',2,NULL,1,2,4,1,2,1),(278,'FOR4278','Formulación de Proyectos Socioproductivos.',4,'',1,4,8,2,1,1),(280,'FRO2280','Frontera, Interculturalidad y Educación',2,'',1,2,4,3,2,1),(281,'DER2281','Derecho Internacional, Integración y Frontera',2,NULL,1,2,4,3,2,1),(282,'DIE2282','Dimensión de la Integración en Espacios  Fronterizos',2,NULL,1,2,4,3,2,1),(283,'INT2283','Interculturalidad en Espacios de Frontera',2,NULL,1,2,4,3,2,1),(284,'FUN3284','Fundamentación Epistémica de la Educación Tecnológica en Venezuela.',3,'',1,3,6,3,2,1),(285,'FUN4285','Fundamentos de Àlgebra',4,NULL,1,4,8,2,1,1),(286,'FUN3286','Fundamentos de Ciencias de la Tierra',3,'',1,3,6,2,1,1),(287,'FUN2287','Fundamentos de Economía Agrícola',2,NULL,1,2,4,2,2,1),(288,'FUN4288','Fundamentos de Educación para el Trabajo',4,NULL,1,4,8,2,1,1),(289,'FUN2289','Fundamentos de Educación para el Trabajo',2,'',1,2,4,2,2,1),(290,'FUN4290','Fundamentos de Física Eléctrica',4,NULL,1,4,8,2,1,1),(291,'FUN4291','Fundamentos de Fisicoquímica',4,NULL,1,4,8,2,1,1),(292,'FUN4292','Fundamentos de Educación Física',4,NULL,1,4,8,2,1,1),(293,'FUN4293','Fundamentos de la Educación Inicial',4,'',1,4,8,2,1,1),(294,'FUN4294','Fundamentos de la Educación Primaria',4,'',1,4,8,2,1,1),(295,'FUN3295','Fundamentos para la Enseñanza de la Lectura y la Escritura',3,NULL,1,3,6,1,2,1),(296,'FUN4296','Fundamentos Sociológicos de la Educación Rural',4,NULL,1,4,8,2,1,1),(297,'FUT3297','Futbol Sala para la Educación',3,'',1,3,6,3,2,1),(298,'GEN4298','Genética y Tópicos de Biotecnología',4,'',1,4,8,2,1,1),(299,'GEO3299','Geografía Critica Latinoamericana',3,NULL,1,3,6,2,2,1),(300,'GEO2300','Geografía de la Población',2,'',1,2,4,2,2,1),(301,'GEO4301','Geografía de Venezuela',4,'',1,4,8,2,1,1),(302,'GEO4302','Geografía Económica y Social de Mundo',4,'',1,4,8,2,1,1),(303,'GEO4303','Geografía General',4,'',1,4,8,2,1,1),(304,'GEO4304','Geografía Social y Económica de Venezuela',4,'',1,4,8,2,1,1),(305,'GEO2305','Geología Ambiental',2,'',1,2,4,2,2,1),(306,'GEO3306','Geología de Venezuela',3,'',1,3,6,2,1,1),(307,'GEO4307','Geología Estructural',4,'',1,4,8,2,1,1),(308,'GEO4308','Geología Física',4,'',1,4,8,2,1,1),(309,'GEO4309','Geometría',4,'',1,4,8,2,1,1),(310,'GEO4310','Geometría analítica',4,'',1,4,8,2,1,1),(311,'GEO4311','Geometría Descriptiva',4,'',1,4,8,2,1,1),(312,'GEO4312','Geometría I',4,'',1,4,8,2,1,1),(313,'GEO4313','Geometría II',4,'',1,4,8,2,1,1),(314,'GEO3314','Geomorfología',3,'',1,3,6,2,1,1),(315,'GEO4315','Geoquímica',4,'',1,4,8,2,1,1),(316,'GER3316','Gerencia Financiera',3,NULL,1,3,6,2,2,1),(317,'GER4317','Gerencia y Legislación',4,NULL,1,4,8,1,1,1),(318,'GES2318','Gestión Comunitaria I',2,NULL,1,2,4,3,2,1),(319,'GES4319','Gestión en la Educación Física',3,NULL,1,3,6,2,2,1),(320,'GES4320','Gestión de la Oficina',4,NULL,1,4,8,2,1,1),(321,'GES2321','Gestión de Procesos Comunitarios',2,NULL,1,2,4,3,2,1),(322,'GES3322','Gestión Comunitaria II',3,NULL,1,3,6,3,2,1),(323,'GES2323','Gestión de Riesgo y Seguridad Escolar',2,'',1,2,4,3,2,1),(324,'GES2324','Gestión Moderna de Inventarios',2,NULL,1,2,4,3,2,1),(325,'GES4325','Gestión Organizacional',4,NULL,1,4,8,2,1,1),(326,'GES4326','Gestión Socio  Educativa y Socioproductiva.',4,'',1,4,8,2,1,1),(327,'GRA4327','Gramática',4,'',1,4,8,2,1,1),(328,'GRA4328','Gramática del Inglés',4,'',1,4,8,2,1,1),(329,'GRA4329','Gramática del Francés',4,NULL,1,4,8,2,1,1),(330,'HID4330','Hidrosfera',4,'',1,4,8,2,1,1),(331,'HIG2331','Higiene y Seguridad Laboral',2,'',1,2,4,1,2,1),(332,'HIS2332','Historia de la Educación en Venezuela',2,NULL,1,2,4,1,2,1),(333,'HIS2333','Historia de la Matemática',2,'',1,2,4,3,2,1),(334,'HIS2334','Historia de la Vida Cotidiana',2,NULL,1,2,4,1,2,1),(335,'HIS3335','Historia de las Relaciones Civiles y Militares en Venezuela',3,NULL,1,3,6,3,2,1),(336,'HIS4336','Historia de Venezuela y Ciudadanía',4,'',1,4,8,2,1,1),(337,'HIS4337','Historia del Teatro I',4,'',1,4,8,2,1,1),(338,'HIS4338','Historia del Teatro II',4,'',1,4,8,2,1,1),(339,'HIS2339','Historia Intelectual',2,NULL,1,2,4,1,2,1),(340,'HIS4340','Historia Originaria y Colonial de Venezuela',4,'',1,4,8,2,1,1),(341,'HIS4341','Historia Republicana de Venezuela',4,'',1,4,8,2,1,1),(342,'HUE2342','Huertos Biointensivos',2,'',1,2,4,2,2,1),(343,'IDE2343','Identidad  Nacional',2,'',1,2,4,1,2,1),(344,'IDE3344','Identidad Ciudadana y Democracia',3,NULL,1,3,6,3,2,1),(345,'IDI4345','Idioma B  I',4,'',1,4,8,2,1,1),(346,'IDI4346','Idioma B  II',4,'',1,4,8,2,1,1),(347,'IDI4347','Idioma B  III',4,'',1,4,8,2,1,1),(348,'IDI4348','Idioma B  IV',4,'',1,4,8,2,1,1),(349,'IDI3349','Idioma C Portugués',2,NULL,1,2,4,3,2,1),(350,'INF4350','Informática',4,'',1,4,8,2,1,1),(351,'ING3351','Ingeniería del Software',3,'',1,3,6,2,2,1),(352,'ING4352','Inglés en Educación Inicial',3,NULL,1,3,6,3,2,1),(353,'ING4353','Inglés I',4,'',1,4,8,2,1,1),(354,'ING4354','Inglés II',4,'',1,4,8,2,1,1),(355,'ING4355','Inglés III',4,'',1,4,8,2,1,1),(356,'ING4356','Inglés IV',4,'',1,4,8,2,1,1),(357,'ING2357','Inglés para Niños',2,NULL,1,2,4,1,2,1),(358,'INI4358','Iniciación al lenguaje y Ejecución Musical',4,'',1,4,8,2,1,1),(359,'INI2359','Iniciación de Lectura y Escritura desde la Educación Inicial',2,NULL,1,2,4,3,2,1),(360,'INN3360','Innovación Pedagógica en la Educación Física',3,NULL,1,3,6,1,2,1),(361,'INN3361','Innovaciones Educativas Para La Enseñanza De La Física',3,'',1,3,6,2,1,1),(362,'INS4362','Instalaciones Eléctricas',4,'',1,4,8,2,1,1),(363,'INS2363','Instrumentos de Medición',2,'',1,2,4,3,2,1),(364,'INT2364','Interculturalidad en Espacios de Frontera',2,'',1,2,4,3,2,1),(365,'INT4365','Interpretación de Recursos Cartográficos',4,'',1,4,8,2,1,1),(366,'INT2366','Interpretación y Creatividad Musical',2,'',1,2,4,2,2,1),(367,'INT3367','Introducción a  la Literatura',3,'',1,3,6,3,2,1),(368,'INT4368','Introducción a la Comunicación Escrita en Francés',4,NULL,1,4,8,2,1,1),(369,'INT4369','Introducción a la Comunicación Escrita en Inglés',4,'',1,4,8,2,1,1),(370,'INT4370','Introducción a la Comunicación Oral en Francés',4,'',1,4,8,2,1,1),(371,'INT4371','Introducción a la Comunicación Oral en Inglés',4,'',1,4,8,2,1,1),(372,'FIS4372','Física Moderna',4,NULL,1,4,8,2,1,1),(373,'INT2373','Introducción a la Historia del Arte',2,'',1,2,4,2,2,1),(374,'INT2374','Introducción a la Lectura y Escritura en Inglés',2,NULL,1,2,4,3,2,1),(375,'INT4375','Introducción a la Pedología',4,'',1,4,8,2,1,1),(376,'INT4376','Introducción a la Semiología',4,'',1,4,8,2,1,1),(377,'INT4377','Introducción a los Estudios de la Lengua',4,NULL,1,4,8,2,1,1),(378,'INT4378','Introducción al Estudio del Discurso Literario',4,NULL,1,4,8,2,1,1),(379,'INT4379','Introducción al Estudio del Discurso Literario Francófono',4,NULL,1,4,8,2,1,1),(380,'INV2380','Investigación de la Diversidad en los Ecosistemas',2,'',1,2,4,2,2,1),(381,'INV3381','Investigación de Operaciones',3,'',1,3,6,3,2,1),(382,'INV4382','INVESTIGACIÓN I',4,'',1,4,8,4,3,1),(383,'INV4383','INVESTIGACIÓN II',4,'',1,4,8,4,3,1),(384,'INV4384','INVESTIGACIÓN III',4,'',1,4,8,4,3,1),(385,'INV4385','INVESTIGACIÓN IV',4,'',1,4,8,4,3,1),(386,'LA 2386','La Formación de Género y Sexualidad en Educación Inicial',2,NULL,1,2,4,2,2,1),(387,'LA 2387','La Teatralidad en las Manifestaciones Artístico – Tradicionales Venezolanas',2,'',1,2,4,2,2,1),(388,'LAB4388','Laboratorio de Circuitos',4,'',1,4,8,2,1,1),(389,'LAT4389','Latín',4,'',1,4,8,2,1,1),(390,'LEC4390','Lectura y Escritura de Lenguas Indígenas',4,NULL,1,4,8,2,1,1),(391,'LEC4391','Lectura y Escritura en Educación Inicial',4,NULL,1,4,8,2,1,1),(392,'LEG4392','Legislación Mercantil y Laboral',4,NULL,1,4,8,2,1,1),(393,'LEG4393','Legislación Sociopolítica',4,NULL,1,4,8,2,1,1),(394,'LEG2394','Legistacion Comparada en Contextos Interculturales',2,NULL,1,2,4,3,2,1),(395,'LEN2395','Lenguaje y Sociedad',2,NULL,1,2,4,3,2,1),(396,'LEN4396','Lengua Indígena I',4,'',1,4,8,2,1,1),(397,'LEN4397','Lengua Indígena II',4,'',1,4,8,2,1,1),(398,'LEN4398','Lengua Indígena III',4,'',1,4,8,2,1,1),(399,'LEN4399','Lengua Indígena IV',4,'',1,4,8,2,1,1),(400,'LEN4400','Lengua y Cultura',4,'',1,4,8,2,1,1),(401,'LEN4401','Lengua y Cultura Francófona',4,'',1,4,8,2,1,1),(402,'LEN4402','Lengua, Literatura Y Sociedad',4,'',1,4,8,2,1,1),(403,'LEN4403','Lenguaje y Ejecución Musical',4,'',1,4,8,2,1,1),(404,'LEN4404','Lenguaje y Ejecución Musical Avanzada',4,'',1,4,8,2,1,1),(405,'LÉX4405','Léxico  Semántica y Semiótica',4,NULL,1,4,8,2,1,1),(406,'LID3406','Liderazgo Social y Organizacional',3,NULL,1,3,6,3,2,1),(407,'LÍN3407','Líneas de Transmisión',3,'',1,3,6,3,2,1),(408,'LIN2408','Lingüística Aplicada a la Enseñanza de la Lengua',2,NULL,1,2,4,2,2,1),(409,'LIN2409','Lingüística del Corpus',2,'',1,2,4,3,2,1),(410,'LIN4410','Lingüística del Idioma B Francés',4,NULL,1,4,8,2,1,1),(411,'LIN4411','Lingüística del Inglés',4,'',1,4,8,2,1,1),(412,'LIN4412','Lingüística General',4,'',1,4,8,2,1,1),(413,'LIN4413','Lingüística General',4,NULL,1,4,8,3,1,1),(414,'LIN4414','Lingüística General del Francés',4,'',1,4,8,2,1,1),(415,'LIT4415','Literatura Anglófona',3,NULL,1,3,6,2,1,1),(416,'LIT4416','Literatura del Idioma B Francés',4,NULL,1,4,8,2,1,1),(417,'LIT4417','Literatura Infantil',4,'',1,4,8,2,1,1),(418,'LIT4418','Literatura Juvenil',4,'',1,4,8,2,1,1),(419,'LIT4419','Literatura Latinoamericana y Caribeña',4,'',1,4,8,2,1,1),(420,'LIT3420','Literatura Venezolana',3,'',1,3,6,3,2,1),(421,'LIT4421','Literatura Venezolana',4,'',1,4,8,2,1,1),(422,'LÚD2422','Lúdica en la Lectura y Escritura',2,'',1,2,4,3,2,1),(423,'LÚD2423','Lúdica y Motricidad',2,'',1,2,4,2,2,1),(424,'MAN4424','Manifestaciones Artísticas y Literarias en Contextos Indígenas',4,NULL,1,4,8,2,1,1),(425,'MAN2425','Mantenimiento de Edificaciones Educativas',2,'',1,2,4,3,2,1),(426,'MAN4426','Mantenimiento de Equipos y Máquinas Industriales',4,'',1,4,8,2,1,1),(427,'MAN2427','Mantenimiento de Instituciones Educativas y Empresas Rurales',2,NULL,1,2,4,2,2,1),(428,'MAN2428','Mantenimiento Eléctrico',2,'',1,2,4,2,2,1),(429,'MAQ4429','Maquetas y Modelos Tridimensionales',4,'',1,4,8,2,1,1),(430,'MAQ2430','Maquillaje Teatral',4,NULL,1,4,8,2,1,1),(431,'MAQ4431','Maquinarias Agrícolas',4,NULL,1,4,8,2,1,1),(432,'MAQ4432','Maquinas Eléctricas I',4,'',1,4,8,2,1,1),(433,'MAQ4433','Maquinas Eléctricas II',4,'',1,4,8,2,1,1),(434,'MAT4434','Matemática',4,'',1,4,8,2,1,1),(435,'MAT2435','Matemática Aplicada',2,'',1,2,4,2,2,1),(436,'MAT3436','Matemática Aplicada a la Biología',3,'',1,3,6,2,1,1),(437,'MAT4437','Matemática Aplicada a la Química',3,NULL,1,3,6,2,1,1),(438,'MAT3438','Matemática Aplicada a las Ciencias de la Tierra',3,NULL,1,3,6,2,1,1),(439,'MAT2439','Matemática Aplicada I',2,'',1,2,4,2,1,1),(440,'MAT2440','Matemática Aplicada II',2,NULL,1,2,4,2,1,1),(441,'MAT4441','Matemática Aplicada III',4,NULL,1,4,8,2,1,1),(442,'MAT4442','Matemática Discreta',4,'',1,4,8,2,1,1),(443,'MAT4443','Matemática Financiera',4,NULL,1,4,8,2,1,1),(444,'MAT4444','Matemática para  Mecánica',4,'',1,4,8,2,1,1),(445,'MAT4445','Matemática I',4,NULL,1,4,8,2,1,1),(446,'MAT4446','Matemática II',4,NULL,1,4,8,2,1,1),(447,'MAT4447','Matemática III',4,NULL,1,4,8,2,1,1),(448,'MAT2448','Matemática y Ciencias Naturales',2,NULL,1,2,4,3,2,1),(449,'MAT2449','Matemática y Educación Especial.',2,NULL,1,2,4,2,2,1),(450,'MAT2450','Matemática y Realidad',2,NULL,1,2,4,1,2,1),(451,'MAT4451','Matemáticas para Electrónica I',4,'',1,4,8,2,1,1),(452,'MAT4452','Matemáticas para Electrónica II',4,'',1,4,8,2,1,1),(453,'MAT4453','Matemáticas para Electrónica III',4,'',1,4,8,2,1,1),(454,'MAT3454','Materiales Educativos',3,'',1,3,6,1,2,1),(455,'MEC4455','Mecánica Aplicada',4,'',1,4,8,2,1,1),(456,'MEC2456','Mecánica Básica',2,'',1,2,4,3,2,1),(457,'MEC2457','Mecánica de los Fluidos',2,'',1,2,4,2,2,1),(458,'MEC2458','Mecánica de los Materiales',2,'',1,2,4,2,2,1),(459,'MEC2459','Mecanización Agraria',2,'',1,2,4,2,2,1),(461,'MED4461','Mediación Intercultural',4,NULL,1,4,8,2,1,1),(462,'MED2462','Medición de Parámetros Eléctricos',2,'',1,2,4,2,2,1),(463,'MED4463','Mediciones  Eléctricas',4,'',1,4,8,2,1,1),(464,'MED2464','Medios Didácticos para la Educación Industrial',2,'',1,2,4,1,2,1),(465,'MED4465','Medios Expresivo de la Actuación',4,'',1,4,8,2,1,1),(466,'MEM2466','Memoria y Patrimonio Histórico',2,NULL,1,2,4,3,2,1),(467,'MER4467','Mercadeo y Publicidad',4,NULL,1,4,8,2,1,1),(468,'MET2468','Meteorología',2,'',1,2,4,2,2,1),(469,'MET3469','Meteorología',3,'',1,3,6,3,2,1),(470,'MÉT4470','Método y Didáctica del Dibujo Técnico',4,'',1,4,8,2,1,1),(471,'MET4471','Metrología del Taller',4,'',1,4,8,2,1,1),(472,'MIC4472','Microprocesadores',4,'',1,4,8,2,1,1),(473,'MIN2473','Mineralogía y Petrografía',2,NULL,1,3,4,2,2,1),(474,'MOM2474','Momentos de la Literatura',2,'',1,2,4,2,2,1),(475,'MÚS2475','Música y Contexto',2,'',1,2,4,2,2,1),(476,'MÚS4476','Música y Movimiento',4,'',1,4,8,2,1,1),(477,'MUS2477','Musicología y Etnomusicología',2,'',1,2,4,2,2,1),(478,'NAT2478','Naturaleza y Cultura',2,'',1,2,4,2,2,1),(479,'NEU4479','Neurociencia y Educación',4,NULL,1,4,8,2,1,1),(480,'NEU4480','Neuromúsica',4,'',1,4,8,2,1,1),(481,'NOC4481','Nociones de Contabilidad',4,NULL,1,4,8,2,1,1),(482,'NOC4482','Nociones de Oficina',4,NULL,1,4,8,2,1,1),(483,'OND4483','Ondas',4,'',1,4,8,2,1,1),(484,'ÓPT4484','Óptica',4,'',1,4,8,2,1,1),(485,'ORA2485','Oratoria y Liderazgo',2,NULL,1,2,4,3,2,1),(486,'ORI4486','Orientación Educativa y Diversidad',4,'',1,4,8,1,1,1),(487,'ORI4487','Origen y Evolución de las Artes Plásticas I',4,'',1,4,8,2,1,1),(488,'ORI4488','Origen y Evolución de las Artes Plásticas II',4,NULL,1,4,8,2,1,1),(489,'PED4489','Pedagogía de la Actuación',4,'',1,4,8,2,1,1),(490,'PED4490','Pedagogía de la Dirección Teatral',4,'',1,4,8,2,1,1),(491,'PED4491','Pedagogía de la Música I',4,'',1,4,8,2,1,1),(492,'PED4492','Pedagogía de la Música II',4,'',1,4,8,2,1,1),(493,'PED4493','Pedagogía de la Música III',4,'',1,4,8,2,1,1),(494,'PED3494','Pedagogía Musical',3,'',1,3,6,2,2,1),(495,'PED2495','Pedagogía Musical Infantil',2,NULL,1,2,4,2,2,1),(496,'PEN4496','Pensamiento Bolivariano',4,'',1,4,8,2,1,1),(497,'PEN4497','Pensamiento Filosófico y Pedagógico',4,'',1,4,8,1,1,1),(498,'PEN4498','Pensamiento Lógico Matemático',4,NULL,1,4,8,2,1,1),(499,'PLA4499','Planificación de la Enseñanza y del Aprendizaje',4,'',1,4,8,1,1,1),(501,'PLA2501','Planificación Lingüoeducativa',2,NULL,1,2,4,1,2,1),(502,'PLA2502','Planificación por Proyecto',2,NULL,1,2,4,2,2,1),(503,'PRÁ3503','Práctica del Dibujo Técnico',3,'',1,3,6,2,2,1),(504,'PRÁ4504','Práctica Musical I',4,'',1,4,8,2,1,1),(505,'PRÁ4505','Práctica Musical II',4,'',1,4,8,2,1,1),(506,'PRÁ4506','Práctica Musical III',4,'',1,4,8,2,1,1),(507,'PRÁ8507','PRÁCTICA PROFESIONAL I',8,'',1,6,16,4,3,1),(508,'PRÁ8508','PRÁCTICA PROFESIONAL II',8,'',1,6,16,4,3,1),(509,'PRÁ8509','PRÁCTICA PROFESIONAL III',8,'',1,6,16,4,3,1),(510,'PRÁ8510','PRÁCTICA PROFESIONAL IV',8,'',1,6,16,4,3,1),(511,'PRA4511','Praxiología de las Disciplinas Deportivas Individuales',4,NULL,1,4,8,2,1,1),(512,'PRA4512','Praxis Artística y Problemática Socioeducativa',4,NULL,1,4,8,2,1,1),(513,'PRE2513','Preparación Física Básica',2,'',1,2,4,3,2,1),(514,'PRE2514','Prevención y Gestión de Riesgo',2,'',1,2,4,2,2,1),(515,'PRI2515','Primeros Auxilios',2,'',1,2,4,1,2,1),(516,'PRI2516','Primeros Auxilios',2,'',1,2,4,3,2,1),(517,'PRI4517','Principios Básicos de Mecánica Automotriz',4,'',1,4,8,2,1,1),(518,'PRI3518','Principios de Archivística y Paleografía',3,NULL,1,3,6,1,2,1),(519,'PRI4519','Principios de la Teoría Electromagnética y sus Aplicaciones',4,NULL,1,4,8,2,1,1),(520,'PRI4520','Principios de Mecánica Teórica y Aplicada',4,NULL,1,4,8,2,1,1),(521,'PRO2521','Problemática de la Enseñanza de la Física',2,NULL,1,2,4,2,2,1),(522,'PRO2522','Problemática de la Enseñanza de la Matemática',2,NULL,1,2,4,1,2,1),(523,'PRO3523','Problemática Social y Aprendizaje',3,'',1,3,6,1,2,1),(524,'PRO2524','Problemática Social y Aprendizaje',2,'',1,2,4,1,2,1),(525,'PRO4525','Proceso y Transformación de Productos Agropecuarios',4,'',1,4,8,2,1,1),(526,'PRO4526','Procesos Contables',4,NULL,1,4,8,2,1,1),(527,'PRO4527','Procesos Históricos de América y el Caribe',4,'',1,4,8,2,1,1),(528,'PRO4528','Procesos Históricos del Mundo I',4,'',1,4,8,2,1,1),(529,'PRO4529','Procesos Históricos del Mundo II',4,'',1,4,8,2,1,1),(530,'PRO4530','Procesos Investigativos en las Artes Plásticas',4,NULL,1,4,8,2,1,1),(531,'PRO4531','Procesos y Transformación de  Productos Agropecuarios',4,'',1,4,8,2,1,1),(532,'PRO4532','Producción Animal  Sustentable',4,'',1,4,8,2,1,1),(533,'PRO4533','Producción de Materiales Educativos Multimediales',4,'',1,4,8,2,1,1),(534,'PRO4534','Producción de Monogástricos',4,'',1,4,8,2,1,1),(535,'PRO4535','Producción de Rumiantes',4,'',1,4,8,2,1,1),(536,'PRO4536','Producción Fotográfica',4,'',1,4,8,2,1,1),(537,'PRO4537','Producción Vegetal Sustentable',4,'',1,4,8,2,1,1),(538,'PRO4538','Producción y Puesta en Escena',3,NULL,1,3,6,2,2,1),(539,'EST4539','Estudio del Discurso Literario en Francés',4,NULL,1,4,8,2,1,1),(540,'PRO2540','Programación Aplicada a la Educación',2,'',1,2,4,1,2,1),(542,'PRO4542','Programación I',4,'',1,4,8,2,1,1),(543,'PRO4543','Programación II',4,'',1,4,8,2,1,1),(544,'PRO2544','Programación Orientada a la Web',2,NULL,1,2,4,2,2,1),(545,'PRO2545','Propuestas Artísticas Socioeducativas',2,'',1,2,4,1,2,1),(546,'PRO3546','Proyecto Educativo',3,'',1,3,6,3,2,1),(547,'PRO4547','Proyectos de Emprendimientos Socio-productivos',4,NULL,1,4,8,2,1,1),(548,'PRO3548','Proyectos Educativos',3,'',1,3,6,2,2,1),(549,'PRO4549','Proyectos Informáticos',4,'',1,4,8,2,1,1),(550,'PSI3550','Psicología de la Creación Dramática',3,'',1,3,6,3,2,1),(551,'PSI4551','Psicología del Aprendizaje',4,'',1,4,8,1,1,1),(552,'PSI2552','Psicopedagogía',2,'',1,2,4,1,2,1),(553,'EDU2553','Educación Emocional',2,NULL,1,2,4,1,2,1),(554,'PRO2554','Problemática Social y Aprendizaje',2,NULL,1,2,4,1,2,1),(555,'PUB2555','Publicidad y Mercadeo',2,'',1,2,4,2,2,1),(556,'QUÍ4556','Química Analítica',4,'',1,4,8,2,1,1),(557,'QUÍ4557','Química Analítica Instrumental',4,'',1,4,8,2,1,1),(558,'QUÍ3558','Química Aplicada a la Biología',3,'',1,3,6,2,1,1),(559,'QUÍ3559','Química Básica',3,'',1,3,6,2,1,1),(560,'QUÍ4560','Química Básica',3,NULL,1,3,6,2,1,1),(561,'QUÍ2561','Química General',3,NULL,1,3,6,2,1,1),(562,'QUÍ4562','Química Inorgánica',4,'',1,4,8,2,1,1),(563,'QUÍ4563','Química Inorgánica Avanzada',4,'',1,4,8,2,1,1),(564,'QUÍ4564','Química Orgánica I',4,'',1,4,8,2,1,1),(565,'QUÍ4565','Química Orgánica II',4,NULL,1,4,8,2,1,1),(566,'REC2566','Recreación',2,'',1,2,4,1,2,1),(567,'REC2567','Recursos didácticos para Lenguas Extranjeras',2,NULL,1,2,4,1,2,1),(568,'REC3568','Recursos para el Aprendizaje',3,NULL,1,3,6,3,2,1),(569,'RED4569','Circuitos Eléctricos I',4,NULL,1,4,8,2,1,1),(570,'RED4570','Circuitos Eléctricos II',4,NULL,1,4,8,2,1,1),(571,'RED4571','Redes Eléctricas',3,NULL,1,3,6,2,2,1),(572,'RED4572','Redes Informáticas',4,'',1,4,8,2,1,1),(573,'REF2573','Refrigeración y Aire Acondicionado',2,'',1,2,4,3,2,1),(574,'RES3574','Resolución de Problemas.',3,'',1,3,6,3,2,1),(575,'RIG2575','Rigor y Formalización en Matemática',2,NULL,1,2,4,1,2,1),(576,'ROB3576','Robótica',3,'',1,3,6,3,2,1),(577,'RUR3577','Ruralidad',3,'',1,3,6,3,2,1),(578,'CUL3578','Cultura Campesina Andina',3,NULL,1,3,6,3,2,1),(579,'DES3579','Desarrollo Rural Sustentable',3,NULL,1,3,6,3,2,1),(580,'TEC3580','Tecnologías Campesinas',3,NULL,1,3,6,3,2,1),(581,'SAB2581','Saber, Ambiente y Sustentabilidad',2,'',1,2,4,3,2,1),(582,'AMB2582','Ambiente, Sociedad y Cultura',2,NULL,1,2,4,3,2,1),(584,'SAB2584','Saber Ambiental en Contextos de Cotidianidad',2,NULL,1,2,4,3,2,1),(586,'SAL3586','Salud Integral',3,NULL,1,3,6,3,2,1),(587,'SAL3587','Salud Integral y Espiritualidad',3,'',1,3,6,3,2,1),(588,'SAL3588','Salud Preventiva',3,'',1,3,6,3,2,1),(589,'SEG2589','Seguridad Industrial',2,'',1,2,4,2,2,1),(590,'SEG2590','Seguridad Industrial',2,'',1,2,4,3,2,1),(591,'IDI2591','Idioma B I Francés',4,NULL,1,4,8,2,1,1),(592,'SEM2592','Seminario de Estudios de Caso',2,NULL,1,2,4,2,2,1),(593,'SEM3593','Seminario de Investigación',3,'',1,3,6,3,2,1),(594,'SEM2594','Seminario de Lectura y Escritura',2,'',1,2,4,2,2,1),(595,'SEM3595','Seminario de Teatro',3,NULL,1,3,6,2,2,1),(596,'SEM2596','Seminario de Técnicas de Traducción',2,'',1,2,4,2,2,1),(598,'SEX2598','Sexualidad',2,NULL,1,2,4,3,2,1),(599,'SIM3599','Simulación Empresarial',3,NULL,1,3,6,3,2,1),(600,'SIS3600','Sistemas de Distribución',3,'',1,3,6,3,2,1),(601,'SIS4601','Sistemas de Información',4,'',1,4,8,2,1,1),(602,'SIS3602','Sistemas de Potencia',3,'',1,3,6,2,2,1),(603,'SIS4603','Sistemas de Producción Hortícola',4,'',1,4,8,2,1,1),(604,'SIS4604','Sistemas de Producción Vegetal',4,'',1,4,8,2,1,1),(605,'SIS3605','Sistemas de Protección',3,'',1,3,6,3,2,1),(606,'SIS4606','Sistemas Digitales I',4,'',1,4,8,2,1,1),(607,'SIS4607','Sistemas Digitales II',4,'',1,4,8,2,1,1),(608,'SIS4608','Sistemas Numéricos',4,NULL,1,4,8,2,1,1),(609,'SIS2609','Sistemas Operativos',2,NULL,1,2,4,2,2,1),(610,'SIS4610','Sistemas Productivos Agrícolas',4,NULL,1,4,8,2,1,1),(611,'SOC4611','Sociedad y Educación',4,'',1,4,8,1,1,1),(612,'SUE4612','Suelos y Abonos',4,'',1,4,8,2,1,1),(613,'TAL4613','Taller Básico Rural I',4,'',1,4,8,2,1,1),(614,'TAL4614','Taller Básico Rural II',4,NULL,1,4,8,2,1,1),(615,'TAL2615','Taller de Expresión Artística',2,'',1,2,4,1,2,1),(616,'TAL2616','Taller de Expresión Artística Integral',2,'',1,2,4,1,2,1),(617,'TAL4617','Taller de Expresión Plástica I',4,'',1,4,8,2,1,1),(618,'TAL4618','Taller de Expresión Plástica II',4,NULL,1,4,8,2,1,1),(619,'TAL3619','Taller de Juegos Escénicos',2,NULL,1,2,4,2,2,1),(620,'TAL4620','Taller De Teatro Infantil',4,'',1,4,8,2,1,1),(621,'TAL4621','Taller de Teatro Latinoamericano',4,'',1,4,8,2,1,1),(622,'TAL4622','Taller de Teatro Venezolano',4,NULL,1,4,8,2,1,1),(623,'TEC4623','Tecnología de la Energía',4,'',1,4,8,2,1,1),(624,'TEC4624','Tecnología de la Información Geográfica',4,'',1,4,8,2,1,1),(625,'TEC4625','Tecnología de los Materiales Industriales',4,'',1,4,8,2,1,1),(626,'TEC4626','Tecnología e Innovación Artística',4,NULL,1,4,8,2,1,1),(627,'TEC4627','Tecnología Mecánica I',4,'',1,4,8,2,1,1),(628,'TEC4628','Tecnología Mecánica II',4,'',1,4,8,2,1,1),(629,'TEC4629','Tecnología Mecánica III',4,NULL,1,4,8,2,1,1),(630,'TEC4630','Tecnología Teatral',4,'',1,4,8,2,1,1),(631,'TEC2631','Tecnologías para la Accesibilidad',2,NULL,1,2,4,2,2,1),(632,'TEN4632','Tendencias de la Lingüística',4,'',1,4,8,2,1,1),(633,'TEO4633','Teoría de la Forma',4,'',1,4,8,2,1,1),(634,'TEO2634','Teoría Literaria',2,'',1,2,4,2,2,1),(635,'TEO4635','Teoría y Práctica de la Actividad Física',4,NULL,1,4,8,2,1,1),(636,'TEO4636','Teoría y Práctica de la Motricidad Humana',4,'',1,4,8,2,1,1),(637,'TEO2637','Teoría y Praxis de la Educación Intercultural Bilingüe',2,NULL,1,2,4,2,2,1),(638,'TEO2638','Teoría, Análisis Plástico y Crítica de Arte',2,'',1,2,4,2,2,1),(639,'TEO4639','Teorías Aplicadas al Compromiso con el Emprendimiento Social',4,NULL,1,4,8,2,1,1),(640,'TIC3640','Tic en Educación Inicial',3,NULL,1,3,6,3,2,1),(641,'TIC4641','TIC I',4,'',1,4,8,4,3,1),(642,'TIC4642','TIC II',4,'',1,4,8,4,3,1),(643,'TIC4643','TIC III',4,'',1,4,8,4,3,1),(644,'TIC4644','TIC IV',4,'',1,4,8,4,3,1),(645,'TÓP2645','Tópicos de Trigonometría',2,NULL,1,2,4,2,2,1),(646,'TOP4646','Topografía y riego',4,'',1,4,8,2,1,1),(647,'TRA2647','Trabajo Experimental En El Laboratorio',2,'',1,2,4,2,2,1),(648,'TRA4648','Transición de Preescolar  a Primer Grado',4,NULL,1,4,8,2,1,1),(649,'TUR2649','Turismo Sustentable',2,'',1,2,4,3,2,1),(650,'TUR3650','Turismo y Rentas  Municipales',3,'',1,3,6,3,2,1),(651,'TUR2651','Turismo, Hotelería y Desarrollo Sustentable',2,NULL,1,2,4,2,2,1),(652,'USO3652','Uso y Manejo del suelo como Recurso Natural',3,NULL,1,3,6,3,2,1),(653,'VIS4653','Visiones de la Literatura',4,'',1,4,8,2,1,1),(654,'VOL3654','Voleibol para la Educación',3,'',1,3,6,3,2,1),(655,'ABO2655','Abordaje Pedagógico de la Situación de Discapacidad en la Adolescencia y la Adultez.',4,'',1,4,8,2,1,1),(656,'ABO2656','Abordaje Pedagógico de la Situación de Discapacidad en la Edad Escolar (6 a 12 años)',4,'',1,4,8,2,1,1),(657,'ABO2657','Abordaje Pedagógico de la Situación de Discapacidad en la Primera Infancia (0 a 6 años)',4,'',1,4,8,2,1,1),(658,'ABO3658','Abordaje Pedagógico del Lenguaje',2,NULL,1,2,4,2,2,1),(659,'ABO2659','Abordaje Pedagógico Diferencial I',4,'',1,4,8,2,1,1),(660,'ABO2660','Abordaje Pedagógico Diferencial II',4,'',1,4,8,2,1,1),(661,'ADA2661','Adaptaciones Curriculares',4,'',1,4,8,2,1,1),(662,'ANÁ2662','Análisis Conductual Aplicado a la Educación',4,'',1,4,8,2,1,1),(663,'ASE3663','Asesoramiento Familiar y Ciudadano',2,'',1,2,4,3,2,1),(664,'ASE2664','Asesoría para la Colocación Laboral',3,'',1,3,6,2,2,1),(665,'AUT1665','Autismo',3,'',1,3,6,1,2,1),(666,'BIO1666','Bioética y Diversidad',2,'',1,2,4,1,2,1),(667,'CIC2667','Ciclo Vital y Calidad de Vida',4,'',1,4,8,2,1,1),(668,'COM2668','Comunidad Sorda en Venezuela y el Mundo',2,'',1,2,4,2,1,1),(669,'CUL2669','Cultura Sordera y Educación',3,'',1,3,6,2,2,1),(670,'DES2670','Desarrollo de Procesos Cognitivos de las Personas en Situación de Discapacidad',3,'',1,3,6,2,2,1),(671,'DES2671','Desarrollo Infantil  y sus Desviaciones',4,'',1,4,8,2,1,1),(672,'DES2672','Desarrollo Lingüístico del Sordo',2,NULL,1,2,4,2,2,1),(673,'DES1673','Desarrollo Social y Emocional',2,'',1,2,4,1,2,1),(674,'DES1674','Desarrollo Socioemocional',2,'',1,2,4,1,2,1),(675,'DIS2675','Discapacidad Intelectual y del Desarrollo',4,'',1,4,8,2,1,1),(676,'DIS2676','Discapacidad Visual',2,'',1,2,4,2,2,1),(677,'DIS2677','Discapacidad y Diferencia',4,'',1,4,8,2,1,1),(678,'DIS3678','Discapacidad y Recreación',2,'',1,2,4,3,2,1),(679,'DIS2679','Discapacidades Múltiples',4,'',1,4,8,2,1,1),(680,'DIS3680','Discurso Especializado del Idioma Inglés',4,'',1,4,8,3,2,1),(681,'EDU2681','Educación Corporal',2,'',1,2,4,2,1,1),(682,'EDU2682','Educación Especial',4,'',1,4,8,2,1,1),(683,'EDU3683','Educación Especial y Salud',2,'',1,2,4,3,2,1),(684,'EDU3684','Educación Musical',3,'',1,3,6,3,2,1),(685,'EDU2685','Educación para la Diversidad',4,'',1,4,8,2,1,1),(686,'EDU2686','Educación para Sordos I',4,'',1,4,8,2,1,1),(687,'EDU2687','Educación para Sordos II',4,'',1,4,8,2,1,1),(688,'EDU2688','Educación para Sordos III',4,'',1,4,8,2,1,1),(689,'EDU2689','Educación y Discapacidad en Venezuela',3,NULL,1,3,6,2,2,1),(690,'ESP2690','Español como Segunda Lengua en la \nEducación del Sordo I',4,'',1,4,8,2,1,1),(691,'ESP2691','Español como Segunda Lengua en la Educación del Sordo II',4,'',1,4,8,2,1,1),(692,'EST3692','Estrategias y Recursos para  la  Discapacidad Intelectual y del Desarrollo',2,'',1,2,4,3,2,1),(693,'EVA2693','Evaluación de la Situación de Discapacidad',4,'',1,4,8,2,1,1),(694,'EVA2694','Evaluación del Sordo en \nContextos Educativos',4,'',1,4,8,2,1,1),(695,'FOR2695','Formación Comunitaria en Discapacidad',3,NULL,1,3,6,2,2,1),(696,'FOR2696','Formación del Tutor para la Educación\nInclusiva',4,'',1,4,8,2,1,1),(697,'FOR2697','Formación e Inserción Laboral de Personas con Discapacidad.',3,NULL,1,3,6,2,2,1),(698,'GRA2698','Gramática del Español de Venezuela',2,'',1,2,4,2,2,1),(699,'LA 3699','La Familia en la Escuela de Sordos',3,'',1,3,6,3,2,1),(700,'LEG2700','Legislación de la Educación Especial',4,'',1,4,8,2,1,1),(701,'LEN3701','Lengua de Señas Venezolana',3,'',1,3,6,3,2,1),(702,'LEN2702','Lengua de Señas Venezolana I',4,'',1,4,8,2,1,1),(703,'LEN2703','Lengua de Señas Venezolana II',4,'',1,4,8,2,1,1),(704,'LEN2704','Lengua de Señas Venezolana III',4,'',1,4,8,2,1,1),(705,'LEN2705','Lengua de Señas Venezolana IV',4,'',1,4,8,2,1,1),(706,'LEN2706','Lengua de Señas Venezolana V',4,'',1,4,8,2,1,1),(707,'MED3707','Mediación Lingüística en la Escuela de Sordos',3,'',1,3,6,3,2,1),(708,'MED2708','Medio Físico y Discapacidad',2,'',1,2,4,2,2,1),(709,'NEU2709','Neurociencia',4,'',1,4,8,2,1,1),(710,'NEU2710','Neuropsicología',4,'',1,4,8,2,1,1),(711,'ORI2711','Orientación para  la Atención de Personas \nen Situación de Discapacidad',4,'',1,4,8,2,1,1),(712,'PER1712','Perspectiva  Educativa de la Discapacidad Motora',2,'',1,2,4,1,2,1),(713,'PER2713','Perspectiva de la Situación de Discapacidad',4,'',1,4,8,2,1,1),(714,'PRE2714','Prevención de la Discapacidad',4,'',1,4,8,2,1,1),(715,'PRE1715','Prevención de la Situación de Discapacidad',2,'',1,2,4,1,2,1),(716,'PSI2716','Psicología Evolutiva',4,'',1,4,8,2,1,1),(717,'SEM2717','Seminario de Educación Inicial',2,'',1,2,4,2,2,1),(718,'SIS3718','Sistema Braille',3,'',1,3,6,3,2,1),(719,'SIS3719','Sistemas Aumentativos de Comunicación',3,'',1,3,6,3,2,1),(720,'SOR1720','Sordera y Discapacidades Múltiples',3,'',1,3,6,1,2,1),(721,'SOR2721','Sordera y Salud Pública',4,'',1,4,8,2,1,1),(722,'SOR3722','Sordoceguera',3,'',1,3,6,3,2,1),(723,'TEN2723','Tendencias Actuales y Futuras para la Atención \nde la Persona en Situación de Discapacidad',4,'',1,4,8,2,1,1),(724,'TEO1724','Teorías e Ideas Pedagógicas',2,'',1,2,4,1,2,1),(725,'TRA3725','Trabajo Productivo en la Escuela de Sordos',3,'',1,3,6,3,2,1),(726,'VAL2726','Valoración de las Capacidades de las Personas con DID',4,'',1,4,8,2,1,1),(727,'VEJ1727','Vejez y Desarrollo de la Persona en Situación de Discapacidad',2,'',1,2,4,1,2,1),(728,'VIS2728','Visión Socio Antropológica de la Discapacidad',4,NULL,1,4,8,2,1,1),(756,'LEN3756','Lenguaje y Pensamiento',2,'',1,2,4,3,1,1),(757,'CIU0001','Curso de Iniciación Universitaria',0,NULL,1,0,0,4,2,1),(758,'BAS0506','Base de Datos',4,NULL,1,4,8,2,1,1),(759,'DIS0405','Discapacidad y Diferencia',2,NULL,1,2,4,2,2,1),(760,'REP0296','Repertorio Tradicional Venezolano',2,NULL,1,2,4,3,2,1),(761,'DES2582','Desarrollo del Lenguaje del Niño de 0 a 7 Años',2,NULL,1,2,4,3,2,1),(762,'TOP1412','Tópicos de Trigonometría',2,NULL,1,2,4,3,2,1),(763,'EDU1217','Educación y Escenarios Convencionales y no Convencionales',2,NULL,1,2,4,2,2,1),(764,'INF6448','Infoética y Ciudadanía Digital',2,NULL,1,2,4,3,2,1),(765,'TAL8725','Taller de Lectura y Escritura Académica',2,NULL,1,2,4,2,2,1),(767,'MUS6541','Música Regional',2,NULL,1,2,4,3,2,1),(768,'REC3225','Recursos Didácticos para la Educación Inicial',2,NULL,1,2,4,3,2,1),(769,'LAL5987','Ludoteca',2,NULL,1,2,4,3,2,1),(770,'EDU5486','Educación Musical para Inicial',2,NULL,1,2,4,3,2,1),(771,'EDU0101','Educación Alimentaria y Nutricional',2,NULL,1,2,4,3,2,1),(772,'VEN1208','Venezuela Espacio y Tiempo',4,NULL,1,4,8,1,1,1),(773,'PAT0204','Patrimonio Cultural e Identidad',2,NULL,1,2,4,3,2,1),(774,'MAT4454','Matemática General',2,NULL,NULL,2,4,2,2,1),(775,'IDI2592','Idioma B I Italiano',4,NULL,NULL,4,8,2,1,1),(778,'IDI2593','Idioma B I Portugués',4,NULL,NULL,4,8,2,1,1),(779,'TEC4631','Tecnología de los Materiales Eléctricos',2,NULL,NULL,2,4,2,2,1),(780,'PED2552','Pedagogía Prenatal',2,NULL,NULL,2,4,2,2,1),(782,'PRE4455','Precalculo',2,NULL,NULL,2,4,3,2,1),(783,'MOD2207','Modelos Gerenciales en Electricidad',2,NULL,NULL,2,4,3,2,1),(785,'ETV5487','Educación Técnica en Venezuela',2,NULL,NULL,2,4,3,2,1),(786,'IPR4377','Introducción a la Programación',2,NULL,NULL,2,4,2,2,1),(787,'DIB2140','Dibujo Eléctrico y Electrónico',2,NULL,NULL,2,4,2,2,1),(789,'ELT2207','Electrometría',4,NULL,NULL,4,8,2,1,1),(790,'EMB2210','Embobinado de Máquinas Eléctricas',2,NULL,NULL,2,4,2,2,1),(791,'ELC2211','Teoría Electromagnética',2,NULL,NULL,2,4,2,2,1),(792,'RED4578','Circuitos Eléctricos III',4,NULL,NULL,4,8,2,1,1),(793,'GES4120','Gestión Curricular',2,NULL,NULL,2,4,1,2,1),(794,'EBD4420','Educación Bioética y Derechos Humanos',2,NULL,NULL,2,4,1,2,1),(795,'AFE4421','Articulación, Familia y Escuela',2,NULL,NULL,2,4,1,2,1),(796,'CUL2122','Cultura Regional y Formación Docente',2,NULL,NULL,2,4,3,2,1),(797,'CIRL4022','Circuitos Lógicos',2,NULL,NULL,2,4,2,2,1),(798,'EFE4021','Eficiencia Energética',2,NULL,NULL,2,4,2,2,1),(799,'INS4021','Instrumentación Industrial',2,NULL,NULL,2,4,2,2,1),(800,'DID4149','Didáctica de la Electricidad Industrial',2,NULL,NULL,2,4,3,2,1),(801,'DIS4166','Diseño de Recursos para la Enseñanza de la Electricidad',2,NULL,NULL,2,4,3,2,1),(802,'INN3380','Innovaciones Pedagógicas y Tecnológicas',2,NULL,NULL,2,4,3,2,1),(803,'PRD4543','Programación Didáctica Crítico Constructiva',2,NULL,NULL,2,4,1,2,1),(804,'ETP4422','Ética y Pedagogía Crítica',2,NULL,NULL,2,4,1,2,1),(805,'EST4420','Estimulación y Desarrollo del Humano',2,NULL,NULL,2,4,1,2,1),(806,'PLAE2502','Planificación Prospectiva en la Educación',2,NULL,NULL,2,4,1,2,1),(807,'FUN4423','Fundamentos del Derecho Laboral Educativo',2,NULL,NULL,2,4,1,2,1),(808,'EST3693','Estrategias Metacognitivas para el Aprendizaje',2,NULL,NULL,2,4,1,2,1),(809,'LID3410','Liderazgo Magisterial y Oratoria',3,NULL,NULL,3,6,3,2,1),(810,'MIC4473','Microprocesadores Eléctricos',3,NULL,NULL,3,6,2,2,1),(811,'INS4364','Instalaciones Eléctricas II',3,NULL,NULL,3,6,2,2,1),(812,'SIS4825','Sistema de Puesta a Tierra',3,NULL,NULL,3,6,3,2,1),(813,'MYA2220','Media y Alta Tensión',3,NULL,NULL,3,6,3,2,1),(814,'AII2307','Automatización Inteligente Industrial',3,NULL,NULL,3,6,3,2,1),(815,'MCT2207','Mecatrónica',3,NULL,NULL,3,6,3,2,1),(817,'IEA4466','Interdisciplinariedad en la Enseñanza Aprendizaje de las Ciencias',3,NULL,NULL,3,6,3,2,1),(818,'APRE4522','Aprendizaje Autónomo',3,NULL,NULL,3,6,1,2,1),(819,'COM4522','Competencias Gerenciales en el Contexto Educativo',3,NULL,NULL,3,6,1,2,1),(820,'TEO4452','Teoría del Conocimiento Pedagógico',3,NULL,NULL,3,6,1,2,1),(821,'SIS4425','Sistema Educativo Venezolano',2,NULL,NULL,2,4,3,2,1),(822,'CEN2220','Centrales y SubEstaciones Eléctricas',3,NULL,NULL,3,6,3,2,1),(823,'PER2714','Perspectivas de Análisis Literario',2,NULL,NULL,2,4,2,2,1),(824,'TEO4463','La Teoría Literaria y su Recepción',2,NULL,NULL,2,4,2,2,1),(826,'LEN3702','Lengua de Señas Venezolana Instrumental',2,NULL,NULL,2,4,2,2,1),(827,'BIO4064','Biogeografía',2,NULL,NULL,2,4,2,2,1),(828,'HIS4342','Historia del Pensamiento Político',2,NULL,NULL,2,4,2,2,1),(829,'ADQ4016','Adquisición de una Segunda Lengua',2,NULL,NULL,2,4,3,2,1),(830,'ADQ4017','Adquisición de una Segunda Lengua en Inglés',2,NULL,NULL,2,4,3,2,1),(831,'CIE2079','Ciencia y Cultura en la Realidad Venezolana',2,NULL,NULL,2,4,3,2,1),(832,'EST3694','Estrategias Instruccionales para Lenguas Extranjeras',2,NULL,NULL,2,4,1,2,1),(833,'GEO2301','Geografía Regional y Local',2,NULL,NULL,2,4,2,2,1),(834,'CON3103','Construcciones Geométricas con Regla y Compás',2,NULL,NULL,2,4,2,2,1),(835,'PRI3519','Principios Básicos de Graficación',2,NULL,NULL,2,4,2,2,1),(836,'COR3104','Corrientes Literarias',2,NULL,NULL,2,4,2,2,1),(837,'MET2217','Métodos de Análisis Literarios',2,NULL,NULL,2,4,2,2,1),(838,'MOT2475','Motricidad Humana',2,NULL,NULL,2,4,2,2,1),(839,'PSI2555','Psicomotricidad y Expresión Corporal',2,NULL,NULL,2,4,2,2,1),(840,'EDU5487','Educación Alimentaria y Nutricional para el Niño de 0 a 7 años',2,NULL,NULL,2,4,2,2,1),(841,'ADQ4018','Adquisición de la Lectura y la Escritura',2,NULL,NULL,2,4,3,2,1),(842,'DES2673','Desarrollo de Habilidades para la Escucha',2,NULL,NULL,2,4,3,2,1),(843,'PRO8601','Promoción de la Lectura en el Aula',2,NULL,NULL,2,4,3,2,1),(844,'GEO2302','Geografía Cultural de Venezuela',2,NULL,NULL,2,4,3,2,1),(845,'JUE3201','Juegos de Música y Expresión Corporal',2,NULL,NULL,2,4,3,2,1),(846,'MAN2429','Manifestaciones Artísticas-Culturales Tradicionales y Populares  Venezolanas',2,NULL,NULL,2,4,3,2,1),(847,'IDI2594','Idioma B II Francés',4,NULL,NULL,4,8,2,1,1),(848,'IDI2595','Idioma B II Italiano',4,NULL,NULL,4,8,2,1,1),(849,'IDI2596','Idioma B II Portugués',4,NULL,NULL,4,8,2,1,1),(850,'IDI2597','Idioma B III Francés',4,NULL,NULL,4,8,2,1,1),(851,'IDI2598','Idioma B III Italiano',4,NULL,NULL,4,8,2,1,1),(852,'IDI2599','Idioma B III Portugués',4,NULL,NULL,4,8,2,1,1),(853,'IDI2600','Idioma B IV Francés',4,NULL,NULL,4,8,2,1,1),(854,'IDI2601','Idioma B IV Italiano',4,NULL,NULL,4,8,2,1,1),(855,'IDI2602','Idioma B IV Portugués',4,NULL,NULL,4,8,2,1,1),(856,'DID2150','Didáctica de la Estadística y la Probabilidad',2,NULL,NULL,2,4,1,2,1),(857,'INN3381','Innovación y Aprendizaje de la Matemática',2,NULL,NULL,2,4,2,2,1),(858,'NEU2711','Neuropedagogía',2,NULL,NULL,2,4,3,2,1),(859,'DID2151','Didáctica de la Historia y Geografía',2,NULL,NULL,2,4,3,2,1),(860,'EDU5488','Educación para la Diversidad y la Interculturalidad',3,NULL,NULL,3,6,3,2,1),(861,'COC1001','Cooperativismo y Organización Comunitaria',3,NULL,NULL,3,6,3,2,1),(862,'HIG2333','Higiene y Seguridad Industrial',2,NULL,NULL,2,4,3,2,1),(863,'PRD9001','Productividad',2,NULL,NULL,2,4,3,2,1),(864,'RIT2576','Ritmo y Expresión Corporal',4,NULL,NULL,4,8,2,1,1),(868,'PCD4501','Educación Física para Personas con Discapacidad',4,NULL,NULL,4,8,2,1,1),(869,'PRA4513','Praxiologia de las Disciplinas Deportivas Colectiva',4,NULL,NULL,4,8,2,1,1),(870,'NUT5488','Nutrición en la Educación Física',4,NULL,NULL,4,8,2,1,1),(871,'PED4499','Pedagogía del Movimiento',4,NULL,NULL,4,8,2,1,1),(872,'TES3704','Test y Pruebas de Campo',2,NULL,NULL,2,4,1,2,1),(873,'EFE4022','Educación Física en Espacios no Convencionales',3,NULL,NULL,3,6,3,2,1),(874,'DEP4117','Deportes Colectivos',3,NULL,NULL,3,6,2,2,1),(875,'LEN3703','Lengua de Señas en la Educación Física',2,NULL,NULL,2,4,1,2,1),(876,'ERG3362','Ergonomia del  Movimiento',3,NULL,NULL,3,6,3,2,1),(879,'INT4380','Introducción al Estudio de la Lengua',4,NULL,NULL,4,8,2,1,1),(880,'TEC2632','Técnicas de Laboratorio y Campo Aplicadas al Estudio Vegetal',2,NULL,NULL,2,4,2,2,1),(881,'ESI2634','Educación Integral de la Sexualidad Humana',2,NULL,NULL,2,4,3,2,1),(882,'TEC2633','Técnicas de Laboratorio y Dibujo Biológico',2,NULL,NULL,2,4,2,2,1),(883,'LAB4389','Laboratorio Avanzado',3,NULL,NULL,3,6,2,1,1),(884,'PRO3549','Proyectos Educativos para el Aprendizaje de la Fisica',3,NULL,NULL,3,6,2,1,1),(885,'INT2375','Introducción a la Lectura y Escritura en Francés',2,NULL,NULL,2,4,3,2,1),(886,'COM2091','Comprensión y Producción de Textos Orales y Escritos en Francés',2,NULL,NULL,2,4,2,2,1),(887,'SEM2597','Seminario de Literatura Francesa',3,NULL,NULL,3,6,2,2,1),(888,'PLA2503','Plataforma de Teleformación',2,NULL,NULL,2,4,2,2,1),(890,'GES4321','Gestión en Escenarios Alternativos de Aprendizaje',3,NULL,NULL,3,6,2,2,1),(891,'GES2325','Gestión, Seguridad y Protección Ambiental en el Laboratorio de Química',2,NULL,NULL,2,4,2,2,1),(894,'TEC4632','Tecnología de los Alimentos',2,NULL,NULL,2,4,2,2,1),(895,'QUI2562','Química Industrial y Medio Ambiente',2,NULL,NULL,2,4,2,2,1),(896,'QUI2563','Química Nuclear y Radiactividad',2,NULL,NULL,2,4,2,2,1),(897,'QUI2564','Química Sustentable',2,NULL,NULL,2,4,2,2,1),(899,'PRE2515','Preparación de Disoluciones',2,NULL,NULL,2,4,2,2,1),(900,'RED4579','Redes Eléctricas I',4,NULL,NULL,4,8,2,1,1),(901,'RED4580','Redes Eléctricas II',4,NULL,NULL,4,8,2,1,1),(902,'SEM2718','Seminario de Conversación en Inglés',2,NULL,NULL,2,4,2,2,1),(903,'SEM2719','Seminario de Conversación en Francés',2,NULL,NULL,2,4,2,2,1),(904,'SEM2720','Seminario de Conversación en Portugués',2,NULL,NULL,2,4,2,2,1),(906,'SEM2721','Seminario de Conversación en Italiano',2,NULL,NULL,2,4,2,2,1),(907,'DID2152','Didáctica de la Canción Infantil',2,NULL,NULL,2,4,2,2,1),(908,'EST3695','Estrategias para el Desarrollo de la Comprensión Auditiva en Inglés',2,NULL,NULL,2,4,1,2,1),(909,'INT2376','Introducción a la Fonética y Fonología del Inglés',2,NULL,NULL,2,4,2,2,1),(910,'EST3696','Estrategias para el Desarrollo de Lectura y Escritura en Inglés',2,NULL,NULL,2,4,1,2,1),(911,'SEM2722','Seminario de Inglés con Fines Específicos',2,NULL,NULL,2,4,3,2,1),(912,'DID2137','Didáctica Aplicada al Idioma B Portugués',2,NULL,NULL,2,4,1,2,1),(913,'DID2138','Didáctica Aplicada al Idioma B Italiano',2,NULL,NULL,2,4,1,2,1),(914,'FON3274','Fonética del Idioma B Portugués',3,NULL,NULL,3,6,3,2,1),(915,'FON3275','Fonética del Idioma B Italiano',3,NULL,NULL,3,6,3,2,1),(916,'EST3697','Estrategias Conversacionales en Inglés',2,NULL,NULL,2,4,2,2,1),(918,'COM2093','Comprensión Auditiva del Inglés',2,NULL,NULL,2,4,1,2,1),(919,'CUL2123','Cultura del Mundo Angloparlante',2,NULL,NULL,2,4,3,2,1),(922,'ANÁ2218','Análisis Fonético y Fonológico del Inglés',2,NULL,NULL,2,4,1,2,1),(923,'SEM3594','Seminario de Inmersión Total en Inglés',3,NULL,NULL,3,6,3,2,1),(924,'SEM3596','Seminario de Políticas Educativas del Mundo Angloparlante',3,NULL,NULL,3,6,3,2,1),(925,'TEC2634','Técnicas y Estrategias de la Enseñanza del Inglés en Línea',3,NULL,NULL,3,4,2,2,1),(926,'REC3226','Recursos Didácticos para la Enseñanza de la Geografía',2,NULL,NULL,2,4,3,2,1),(927,'SIM3600','Simbología y Fechas Patrias',2,NULL,NULL,2,4,2,2,1),(928,'GEO2303','Geografía Climática de Venezuela',2,NULL,NULL,2,4,2,2,1),(929,'PEN4499','Pensamiento Latinoamericano y Caribeño',2,NULL,NULL,2,4,3,2,1),(930,'GEO2304','Geografía Médica',2,NULL,NULL,2,4,3,2,1),(932,'GEO2306','Geografía del Turismo',2,NULL,NULL,2,4,2,2,1),(933,'PLA2505','Planificación y Organización del Territorio Venezolano',2,NULL,NULL,2,4,1,2,1),(934,'GEO3300','Geomorfología de Venezuela',3,NULL,NULL,3,6,3,2,1),(935,'CRI3301','Crítica Historiográfica',3,NULL,NULL,3,6,3,2,1),(936,'PER2715','Percusión Afrovenezolana',2,NULL,NULL,2,4,3,2,1),(937,'HEC2330','El Hecho Musical en el Tiempo',2,NULL,NULL,2,4,2,2,1),(938,'MET2218','Métodos de Investigación en la Educación Musical',2,NULL,NULL,2,4,3,2,1),(939,'EST3698','Estrategias de Enseñanza y Aprendizaje en la Educación Musical',2,NULL,NULL,2,4,3,2,1),(942,'DIS4201','Discurso Pedagógico',2,NULL,NULL,2,4,1,2,1),(944,'DID2140','Didáctica del Francés para Públicos Específicos',2,NULL,NULL,2,4,2,2,1),(945,'SEM2723','Seminario de Lingüística Aplicada',2,NULL,NULL,2,4,3,2,1),(946,'DID3154','Didáctica del Español como Lengua Extranjera',3,NULL,NULL,3,6,1,2,1),(947,'GEN4299','Géneros Textuales Académicos',2,NULL,NULL,2,4,3,2,1),(948,'MAN2430','Manifestaciones Escénicas Venezolanas Contemporáneas',2,NULL,NULL,2,4,3,2,1),(949,'ACT0203','Actividad Física y Deporte en Espacios Comunitarios',2,NULL,NULL,2,4,3,2,1),(950,'ESI2635','Educación Integral de la Sexualidad en la Niñez y la Adolescencia',2,NULL,NULL,2,4,2,2,1),(951,'DRA3551','Dramaturgia',4,NULL,NULL,4,8,2,1,1),(953,'SEM2724','Seminario de Comprensión y Producción Oral',2,NULL,NULL,2,4,2,2,1),(954,'ECI2636','Educación para la Ciudadanía',2,NULL,NULL,2,4,2,2,1),(955,'FUN2290','Fundamentos de Economía',2,NULL,NULL,2,4,2,2,1),(956,'FUN2291','Fundamentos de Teoría Política',2,NULL,NULL,2,4,3,2,1),(957,'MET2219','Métodos de la Historia y la Geografía',2,NULL,NULL,2,4,3,2,1),(958,'PET2474','Petróleos y Escenarios Energéticos',2,NULL,NULL,2,4,2,2,1),(959,'HIS4343','Historia y Literatura',2,NULL,NULL,2,4,1,2,1),(960,'ETN2254','Etnohistoria Regional y Local',2,NULL,NULL,2,4,1,2,1),(961,'ENF2231','Enfoque Estratégico Aplicado a la Educación Musical',2,NULL,NULL,2,4,2,2,1),(962,'SEM2725','Semiótica del Discurso',2,NULL,NULL,2,4,2,2,1),(963,'PSI2554','Psicolingüística',2,NULL,NULL,2,4,2,2,1),(964,'PRA4514','Pragmática',2,NULL,NULL,2,4,2,2,1),(965,'COM2094','Competencias Textuales para la Producción de Textos Académicos',2,NULL,NULL,2,4,1,2,1),(966,'FUN2292','Fundamentos del Diseño Industrial',2,NULL,NULL,2,4,2,2,1),(967,'ORI2712','Orientación Vocacional en Educación Inicial',2,NULL,NULL,2,4,3,2,1),(968,'TEC4633','Tecnologías e Innovaciones Educativas',2,NULL,NULL,2,4,1,2,1),(969,'DID2154','Didáctica de la Aritmética',2,NULL,NULL,2,4,2,2,1),(970,'DID2153','Didáctica de la Geometría',2,NULL,NULL,2,4,2,2,1),(972,'EDU5489','Educación Intercultural  en el Nivel Inicial',3,NULL,NULL,3,6,3,2,1),(976,'LIN4415','Lingüística del Idioma B Portugués',4,NULL,NULL,4,8,2,1,1),(978,'LIN4416','Lingüística del Idioma B Italiano',4,NULL,NULL,4,8,2,1,1),(979,'CUL4112','Cultura del Idioma B Portugués',4,NULL,NULL,4,8,2,1,1),(982,'CUL4114','Cultura del Idioma B Italiano',4,NULL,NULL,4,8,2,1,1),(986,'LIT4420','Literatura del Idioma B Portugués',4,NULL,NULL,4,8,2,1,1),(988,'LIT4422','Literatura del Idioma B Italiano',4,NULL,NULL,4,8,2,1,1),(989,'VEN1209','Venezuela Contemporánea',2,NULL,NULL,2,4,1,2,1),(991,'FUN2293','Fundamentos Teóricos y Metodológicos de la Historia',2,NULL,NULL,2,4,1,2,1),(992,'BIO4065','Biomas',2,NULL,NULL,2,4,1,2,1),(993,'ORA2486','Oralidad y Corpus',2,NULL,NULL,2,4,2,2,1),(994,'ANÁ2219','Análisis del Discurso',2,NULL,NULL,2,4,2,2,1),(995,'CAM2071','Cambios Actuales de la Lengua Española',2,NULL,NULL,2,4,2,2,1),(996,'IDI3350','Idioma C Francés',2,NULL,NULL,2,4,3,2,1),(997,'IDI3351','Idioma C Italiano',2,NULL,NULL,2,4,3,2,1),(998,'DCI2155','Del Conflicto Imperial al Conflicto Ideológico: I y II Guerra Mundial',2,NULL,NULL,2,4,2,2,1),(999,'EMB2156','El Mundo Bipolar',3,NULL,NULL,3,6,2,2,1),(1000,'PAV2157','Problemática Agraria Venezolana',3,NULL,NULL,3,6,2,2,1),(1001,'INT2377','Introducción a la Estética',2,NULL,NULL,2,4,2,2,1),(1002,'INT2378','Introducción a la Historia de Arquitectura',2,NULL,NULL,2,4,2,2,1),(1003,'COA2379','Color Aplicado',2,NULL,NULL,2,4,2,2,1),(1004,'SIR2380','Sistema de Representación Axonométrico y Oblicuo',2,NULL,NULL,2,4,2,2,1),(1005,'CSR2381','Cortes, Secciones y Roturas',2,NULL,NULL,2,4,2,2,1),(1006,'EGA2382','Expresión Gráfica Arquitectónica',2,NULL,NULL,2,4,2,2,1),(1007,'ESM2383','Estructuras Metálicas',3,NULL,NULL,3,6,2,2,1),(1008,'SRC2384','Sistema de Representación Cónica',3,NULL,NULL,3,6,2,2,1),(1009,'SRO2385','Sistema de Representación Ortogonal',3,NULL,NULL,3,6,2,2,1),(1010,'CAM2072','Cambios Climáticos',2,NULL,NULL,2,4,2,2,1),(1011,'TAL3620','Taller de Maquetas y Modelos Tridimensionales con Fines Didácticos',2,NULL,NULL,2,4,3,2,1),(1012,'SIS2163','Sistemas Cibernéticos Humanos',2,NULL,NULL,2,4,2,2,1),(1013,'GEO3302','Geohistoria',2,NULL,NULL,2,4,2,2,1),(1014,'TAL3621','Taller de Creación Literaria',2,NULL,NULL,2,4,1,2,1),(1015,'TOP3622','Topónimo e Identidad',2,NULL,NULL,2,4,1,2,1),(1016,'LIT3623','Literatura y Arte',2,NULL,NULL,2,4,1,2,1),(1017,'APA3699','Aproximación al Patrimonio Artístico y Cultural',2,NULL,NULL,2,4,1,2,1),(1018,'PRO2653','Procesos Matemáticos en el Niño de la Etapa Preescolar',2,NULL,NULL,2,4,2,2,1),(1019,'EPT2554','Experiencias Pedagógicas en Integración Artística en Educación Inicial',3,NULL,NULL,3,6,3,2,1),(1020,'CIE2555','Ciencias Naturales en Educación Infantil',3,NULL,NULL,3,6,2,2,1),(1021,'ESI2636','Educación Integral de la Sexualidad en la Infancia',3,NULL,NULL,3,6,2,2,1),(1022,'DCA2674','Desarrollo de la Creatividad en Ambientes Metafóricos',2,NULL,NULL,2,4,3,2,1),(1023,'BIO4066','Bioinorgánica',2,NULL,NULL,2,4,2,2,1),(1024,'DID2155','Didáctica de la Química',2,NULL,NULL,2,4,2,2,1),(1025,'PRO2225','Producción de Eventos Artísticos',2,NULL,NULL,2,4,2,2,1),(1027,'HIS4344','Historia de la Música Venezolana',2,NULL,NULL,2,4,2,2,1),(1028,'MUS6542','Música Venezolana',2,NULL,NULL,2,4,3,2,1),(1029,'CAL2073','Calendario Festivo Venezolano',2,NULL,NULL,2,4,3,2,1),(1030,'SOF3723','Software en Educación Musical',3,NULL,NULL,3,6,2,2,1),(1031,'LEG4394','Legislación Educativa Agraria',3,NULL,NULL,3,6,3,2,1),(1032,'FOR4279','Formulación de Proyectos Agropecuarios',3,NULL,NULL,3,6,1,2,1),(1034,'IMP3700','Improvisación Musical',2,NULL,NULL,2,4,2,2,1),(1035,'SIM3701','Simulación de la Praxis Musical',2,NULL,NULL,2,4,1,2,1),(1036,'CUL3579','Cultura Digital en Comunidades Virtuales',3,NULL,NULL,3,6,3,2,1),(1037,'TOP2221','Topografía Plana',2,NULL,NULL,2,4,2,2,1),(1038,'CIE2229','Cienca y Tecnología de Productos Cárnicos',2,NULL,NULL,2,4,2,2,1),(1039,'DHM2674','Desarrollo de Habilidades Motrices Básicas',2,NULL,NULL,2,4,3,2,1),(1040,'PSD2555','Pensamiento Socio-Deportivo',2,NULL,NULL,2,4,2,2,1),(1041,'FBM4424','Fundamentos Biológicos del Movimieto Humano',2,NULL,NULL,2,4,2,2,1),(1042,'EFE2283','Educación Física para Edad Maternal y Preescolar',2,NULL,NULL,2,4,3,2,1),(1043,'EMC2284','Exploración Motriz, Cuentos y Canciones',2,NULL,NULL,2,4,3,2,1),(1044,'IPC2285','Introducción a Prácticas de Pista y Campo',2,NULL,NULL,2,4,3,2,1),(1045,'AJE2286','Ajedrez Educativo',2,NULL,NULL,2,4,2,2,1),(1046,'IBE2360','Iniciación al Badminton Escolar',2,NULL,NULL,2,4,2,2,1),(1047,'KEF2361','Kinesiología en la Educación Física',2,NULL,NULL,2,4,2,2,1),(1048,'FOD2362','Folklore, Danza Nacionalista y Tradicional Venezolana',2,NULL,NULL,2,4,3,2,1),(1049,'TEE2363','Tenis Educativo',2,NULL,NULL,2,4,2,2,1),(1050,'AAS0204','Actividades Acuáticas para la Salud y el Desarrollo Integral',2,NULL,NULL,2,4,3,2,1),(1051,'BPB3049','Bases Pedagógicas del Balompié',2,NULL,NULL,2,4,2,2,1),(1052,'PNF3520','Principios de la Neuroeducación Física',2,NULL,NULL,2,4,1,2,1),(1053,'BAL3050','Balonmano',3,NULL,NULL,3,3,2,2,1),(1054,'DVF3155','Didáctica para el Voleibol Formativo',3,NULL,NULL,3,6,1,2,1),(1055,'AFA0205','Actividad Física para el Adulto Mayor',3,NULL,NULL,3,6,3,2,1),(1056,'EIC4405','Ejecución Instrumental y Contexto',3,NULL,NULL,3,6,3,2,1),(1057,'TVD2635','Técnica Vocal y Dirección Coral',3,NULL,NULL,3,6,3,2,1),(1058,'STF3597','Seminario de Teatro en Francés',3,NULL,NULL,3,6,2,2,1),(1059,'SDL3598','Seminario de Discurso Literario y Fílmico',3,NULL,NULL,3,6,2,2,1),(1060,'SPN3599','Seminario de Premios Nobel de Literatura en Francés',3,NULL,NULL,3,6,2,2,1),(1061,'STL3600','Seminario: Textos Literarios en la Enseñanza y Aprendizaje del Francés',3,NULL,NULL,3,6,2,2,1),(1062,'IND4118','Inclusión y Deporte',3,NULL,NULL,3,6,3,2,1),(1063,'TMR2364','El Texto de Matemática como Recurso Didáctico',2,NULL,NULL,2,4,2,2,1),(1064,'IAA2365','Inteligencia Artificial (IA) y sus Aplicaciones en la Educación',3,NULL,NULL,3,6,3,2,1);
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_especiales`
--

DROP TABLE IF EXISTS `cursos_especiales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cursos_especiales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curso_id` int(11) DEFAULT NULL,
  `modotranscripcion_id` int(11) DEFAULT NULL,
  `uc` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_67C7AC6E87CB4A1F` (`curso_id`),
  KEY `IDX_67C7AC6E5F2D12C3` (`modotranscripcion_id`),
  CONSTRAINT `FK_67C7AC6E5F2D12C3` FOREIGN KEY (`modotranscripcion_id`) REFERENCES `modo_transcripcion` (`id`),
  CONSTRAINT `FK_67C7AC6E87CB4A1F` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_especiales`
--

LOCK TABLES `cursos_especiales` WRITE;
/*!40000 ALTER TABLE `cursos_especiales` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_especiales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depositos`
--

DROP TABLE IF EXISTS `depositos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `depositos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `conddeposidos_id` int(11) DEFAULT NULL,
  `num_deposito` varchar(10) NOT NULL,
  `monto` double NOT NULL,
  `fecha_deposito` date NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `file_bauche` varchar(100) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `subsede_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_EA8AB28959590C39` (`estudiante_id`),
  KEY `IDX_EA8AB28980B24165` (`lapso_id`),
  KEY `IDX_EA8AB28948B0191A` (`conddeposidos_id`),
  KEY `IDX_EA8AB289613FECDF` (`session_id`),
  KEY `IDX_EA8AB289E19F41BF` (`sede_id`),
  KEY `IDX_EA8AB289AAFDE970` (`subsede_id`),
  CONSTRAINT `FK_EA8AB28948B0191A` FOREIGN KEY (`conddeposidos_id`) REFERENCES `cond_depositos` (`id`),
  CONSTRAINT `FK_EA8AB28959590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `FK_EA8AB289613FECDF` FOREIGN KEY (`session_id`) REFERENCES `sessiones` (`id`),
  CONSTRAINT `FK_EA8AB28980B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_EA8AB289AAFDE970` FOREIGN KEY (`subsede_id`) REFERENCES `subsede` (`id`),
  CONSTRAINT `FK_EA8AB289E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depositos`
--

LOCK TABLES `depositos` WRITE;
/*!40000 ALTER TABLE `depositos` DISABLE KEYS */;
/*!40000 ALTER TABLE `depositos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dias`
--

DROP TABLE IF EXISTS `dias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `dias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(50) NOT NULL,
  `vigente` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dias`
--

LOCK TABLES `dias` WRITE;
/*!40000 ALTER TABLE `dias` DISABLE KEYS */;
INSERT INTO `dias` VALUES (1,'LUNES',1),(2,'MARTES',1),(3,'MIERCOLES',1),(4,'JUEVES',1),(5,'VIERNES',1),(6,'SABADO',1),(7,'DOMINGO',1);
/*!40000 ALTER TABLE `dias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `discapacidades`
--

DROP TABLE IF EXISTS `discapacidades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discapacidades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_615C935920332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `discapacidades`
--

LOCK TABLES `discapacidades` WRITE;
/*!40000 ALTER TABLE `discapacidades` DISABLE KEYS */;
INSERT INTO `discapacidades` VALUES (1,'SD','SIN DISCAPACIDAD'),(2,'S','SENSORIAL'),(3,'FM','FÍSICO-MOTORA'),(4,'I','INTELECTUAL'),(5,'M','MÚLTIPLE');
/*!40000 ALTER TABLE `discapacidades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `espe_estud`
--

DROP TABLE IF EXISTS `espe_estud`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `espe_estud` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `programa_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `especialidad_id` int(11) DEFAULT NULL,
  `cohorte_id` int(11) DEFAULT NULL,
  `ingreso_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `situa_id` int(11) DEFAULT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `activo` tinyint(1) NOT NULL,
  `observacion` longtext DEFAULT NULL,
  `subsede_id` int(11) DEFAULT NULL,
  `indice` double DEFAULT NULL,
  `promocion_id` int(11) DEFAULT NULL,
  `lapsogrado_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_F65B0F9359590C39` (`estudiante_id`),
  KEY `IDX_F65B0F93FD8A7328` (`programa_id`),
  KEY `IDX_F65B0F93E19F41BF` (`sede_id`),
  KEY `IDX_F65B0F9316A490EC` (`especialidad_id`),
  KEY `IDX_F65B0F93FB30EFA4` (`cohorte_id`),
  KEY `IDX_F65B0F93E70E8ADB` (`ingreso_id`),
  KEY `IDX_F65B0F9380B24165` (`lapso_id`),
  KEY `IDX_F65B0F93E2C8EC00` (`situa_id`),
  KEY `IDX_F65B0F93AAFDE970` (`subsede_id`),
  KEY `IDX_F65B0F93B1E453D4` (`promocion_id`),
  KEY `IDX_F65B0F93BCCAB9F8` (`lapsogrado_id`),
  CONSTRAINT `FK_F65B0F9316A490EC` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`),
  CONSTRAINT `FK_F65B0F93AAFDE970` FOREIGN KEY (`subsede_id`) REFERENCES `subsede` (`id`),
  CONSTRAINT `FK_F65B0F93B1E453D4` FOREIGN KEY (`promocion_id`) REFERENCES `promociones` (`id`),
  CONSTRAINT `FK_F65B0F93BCCAB9F8` FOREIGN KEY (`lapsogrado_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_F65B0F93E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`),
  CONSTRAINT `FK_F65B0F93E2C8EC00` FOREIGN KEY (`situa_id`) REFERENCES `cod_situa` (`id`),
  CONSTRAINT `FK_F65B0F93E70E8ADB` FOREIGN KEY (`ingreso_id`) REFERENCES `tipo_ingreso` (`id`),
  CONSTRAINT `FK_F65B0F93FD8A7328` FOREIGN KEY (`programa_id`) REFERENCES `programa` (`id`),
  CONSTRAINT `espe_estud_ibfk_1` FOREIGN KEY (`estudiante_id`) REFERENCES `estudiante` (`id`),
  CONSTRAINT `espe_estud_ibfk_2` FOREIGN KEY (`cohorte_id`) REFERENCES `cohorte` (`id`),
  CONSTRAINT `espe_estud_ibfk_3` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `espe_estud`
--

LOCK TABLES `espe_estud` WRITE;
/*!40000 ALTER TABLE `espe_estud` DISABLE KEYS */;
INSERT INTO `espe_estud` VALUES (1,1096,1,1,8,92,1,56,1,'2017-10-05 08:58:11',1,NULL,65,NULL,NULL,NULL),(2,1101,1,1,19,96,1,64,1,'2024-01-01 00:00:00',1,'mas o menos modificado',1,NULL,NULL,NULL),(3,1102,1,1,8,92,1,56,1,'2023-02-15 00:00:00',0,'Floja jajajaja',1,NULL,NULL,NULL),(4,1103,1,1,4,96,1,64,1,'2025-01-28 00:00:00',1,NULL,1,NULL,NULL,NULL),(5,1104,1,1,1,90,1,1,1,'2023-03-15 00:00:00',0,NULL,13,NULL,NULL,NULL),(6,1105,1,1,12,90,1,64,1,'2022-12-27 00:00:00',0,NULL,1,NULL,NULL,NULL),(7,1102,1,1,19,90,1,1,1,'2023-05-22 00:00:00',1,'prueba',1,NULL,NULL,NULL),(8,1105,1,1,22,96,1,64,1,'2023-05-31 00:00:00',0,NULL,1,NULL,NULL,NULL),(9,1104,1,1,8,96,1,64,1,'2023-05-23 00:00:00',0,NULL,1,NULL,NULL,NULL),(10,1104,1,1,19,91,1,1,1,'2023-06-02 00:00:00',0,NULL,1,NULL,NULL,NULL),(11,1105,1,1,19,91,1,64,1,'2023-05-25 00:00:00',1,NULL,1,NULL,NULL,NULL),(12,1107,1,1,22,90,1,64,1,'2023-11-10 00:00:00',1,NULL,1,NULL,NULL,NULL),(13,1104,1,1,19,96,1,1,1,'2024-02-29 00:00:00',1,NULL,1,NULL,NULL,NULL),(14,1108,1,1,19,96,1,64,1,'2024-02-28 00:00:00',1,NULL,1,NULL,NULL,NULL),(16,1109,1,1,19,90,1,64,1,'2025-12-07 00:00:00',1,NULL,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `espe_estud` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `especialidad`
--

DROP TABLE IF EXISTS `especialidad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `especialidad` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `programa_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ACB064F920332D99` (`codigo`),
  KEY `IDX_ACB064F9FD8A7328` (`programa_id`),
  KEY `IDX_ACB064F9E19F41BF` (`sede_id`),
  CONSTRAINT `FK_ACB064F9E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`),
  CONSTRAINT `FK_ACB064F9FD8A7328` FOREIGN KEY (`programa_id`) REFERENCES `programa` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `especialidad`
--

LOCK TABLES `especialidad` WRITE;
/*!40000 ALTER TABLE `especialidad` DISABLE KEYS */;
INSERT INTO `especialidad` VALUES (1,1,1,'AES','Artes Escénicas'),(2,1,1,'APL','Artes Plásticas'),(3,1,1,'BIO','Biología'),(4,1,1,'CTI','Ciencias de la Tierra'),(5,1,1,'DTE','Dibujo Técnico'),(6,1,1,'EAG','Educación Agropecuaria'),(7,1,1,'ECO','Educación Comercial'),(8,1,1,'EFI','Educación Física'),(9,1,1,'EIB','Educación Intercultural Bilingue'),(10,1,1,'EDP','Educación Primaria'),(11,1,1,'EMU','Educación Musical'),(12,1,1,'EDI','Educación Inicial'),(13,1,1,'ERU','Educación Rural'),(14,1,1,'ETI','Electricidad Industrial'),(15,1,1,'ETO','Electrónica Industrial'),(16,1,1,'FIS','Física'),(17,1,1,'FRA','Francés como Lengua Extranjera'),(18,1,1,'GHI','Geografia e Historia'),(19,1,1,'INF','Educación Informática'),(20,1,1,'ING','Inglés como Lengua Extranjera'),(21,1,1,'LLI','Lengua y Literatura'),(22,1,1,'MAT','Matemática'),(23,1,1,'MIN','Mecánica Industrial'),(24,1,1,'ESP','Educación Socioproductiva'),(25,1,1,'QUI','Química'),(26,1,1,'LEX','Lenguas Extranjeras'),(27,1,1,'EES','Educación Especial para Sordos'),(28,1,1,'DID','Educación Especial para Personas con Discapacidad Intelectual y del Desarrollo'),(29,1,1,'PSD','Educación Especial para Personas en Situación de Discapacidad');
/*!40000 ALTER TABLE `especialidad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estados`
--

DROP TABLE IF EXISTS `estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pais_id` int(11) DEFAULT NULL,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_222B212820332D99` (`codigo`),
  KEY `IDX_222B2128C604D5C6` (`pais_id`),
  CONSTRAINT `FK_222B2128C604D5C6` FOREIGN KEY (`pais_id`) REFERENCES `pais` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estados`
--

LOCK TABLES `estados` WRITE;
/*!40000 ALTER TABLE `estados` DISABLE KEYS */;
INSERT INTO `estados` VALUES (1,66,'0','Amazonas'),(2,66,'1','Anzoátegui'),(3,66,'2','Apure'),(4,66,'3','Aragua'),(5,66,'4','Barinas'),(6,66,'5','Bolívar'),(7,66,'6','Carabobo'),(8,66,'7','Cojedes'),(9,66,'8','Delta Amacuro'),(10,66,'9','Falcón'),(11,66,'10','Guárico'),(12,66,'11','Lara'),(13,66,'12','Mérida'),(14,66,'13','Miranda'),(15,66,'14','Monagas'),(16,66,'15','Nueva Esparta'),(17,66,'16','Portuguesa'),(18,66,'17','Sucre'),(19,66,'18','Táchira'),(20,66,'19','Trujillo'),(21,66,'20','Vargas'),(22,66,'21','Yaracuy'),(23,66,'22','Zulia'),(24,66,'23','Distrito Capital');
/*!40000 ALTER TABLE `estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estu_validados`
--

DROP TABLE IF EXISTS `estu_validados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estu_validados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_495706B659590C39` (`estudiante_id`),
  KEY `IDX_495706B680B24165` (`lapso_id`),
  CONSTRAINT `FK_495706B659590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `FK_495706B680B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estu_validados`
--

LOCK TABLES `estu_validados` WRITE;
/*!40000 ALTER TABLE `estu_validados` DISABLE KEYS */;
/*!40000 ALTER TABLE `estu_validados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estudiante`
--

DROP TABLE IF EXISTS `estudiante`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estudiante` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cedula` varchar(30) NOT NULL,
  `primer_nombre` varchar(50) NOT NULL,
  `segundo_nombre` varchar(50) DEFAULT NULL,
  `primer_apellido` varchar(50) NOT NULL,
  `segundo_apellido` varchar(50) DEFAULT NULL,
  `nacionalidad` varchar(50) DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `sexo` varchar(20) NOT NULL,
  `direccion` longtext DEFAULT NULL,
  `telefono_movil` varchar(12) DEFAULT NULL,
  `telefono_local` varchar(12) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `salf` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `estado_civil` varchar(20) DEFAULT NULL,
  `pais_id` int(11) DEFAULT NULL,
  `estado_id` int(11) DEFAULT NULL,
  `ciudad_id` int(11) DEFAULT NULL,
  `municipio_id` int(11) DEFAULT NULL,
  `etnia_id` int(11) DEFAULT NULL,
  `discapacidad_id` int(11) NOT NULL,
  `twitter` varchar(20) DEFAULT NULL,
  `tiposestudiante_id` int(11) DEFAULT NULL,
  `condi_residencia` varchar(50) DEFAULT NULL,
  `priv_libertad` varchar(50) DEFAULT NULL,
  `plantel_graduado` varchar(150) DEFAULT NULL,
  `clasif_plantel` varchar(100) DEFAULT NULL,
  `fecha_graduado` date DEFAULT NULL,
  `beca` varchar(4) DEFAULT NULL,
  `num_rusnies` varchar(50) DEFAULT NULL,
  `nivel_economico` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_3B3F3FAD7BF39BE0` (`cedula`),
  KEY `IDX_3B3F3FADC604D5C6` (`pais_id`),
  KEY `IDX_3B3F3FAD9F5A440B` (`estado_id`),
  KEY `IDX_3B3F3FADE8608214` (`ciudad_id`),
  KEY `IDX_3B3F3FAD58BC1BE0` (`municipio_id`),
  KEY `IDX_3B3F3FAD594872DC` (`etnia_id`),
  KEY `IDX_3B3F3FAD13DA6592` (`discapacidad_id`),
  KEY `IDX_3B3F3FADBE7BB692` (`tiposestudiante_id`),
  CONSTRAINT `FK_3B3F3FAD13DA6592` FOREIGN KEY (`discapacidad_id`) REFERENCES `discapacidades` (`id`),
  CONSTRAINT `FK_3B3F3FAD58BC1BE0` FOREIGN KEY (`municipio_id`) REFERENCES `municipios` (`id`),
  CONSTRAINT `FK_3B3F3FAD594872DC` FOREIGN KEY (`etnia_id`) REFERENCES `etnias` (`id`),
  CONSTRAINT `FK_3B3F3FAD9F5A440B` FOREIGN KEY (`estado_id`) REFERENCES `estados` (`id`),
  CONSTRAINT `FK_3B3F3FADBE7BB692` FOREIGN KEY (`tiposestudiante_id`) REFERENCES `tipo_estudiante` (`id`),
  CONSTRAINT `FK_3B3F3FADC604D5C6` FOREIGN KEY (`pais_id`) REFERENCES `pais` (`id`),
  CONSTRAINT `FK_3B3F3FADE8608214` FOREIGN KEY (`ciudad_id`) REFERENCES `ciudades` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1110 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estudiante`
--

LOCK TABLES `estudiante` WRITE;
/*!40000 ALTER TABLE `estudiante` DISABLE KEYS */;
INSERT INTO `estudiante` VALUES (1095,'25251415','jose','jose2','jose3','jose4','v','2017-10-10','m','dds','2323','34343','joseest@upel.edu.ve',NULL,'23181','s',66,15,549,180,7,1,'das',3,'1','n','dss','2','2017-10-16','3','232','2'),(1096,'18738560','Arnald','Andre','Avil','madoawda','adaw','2017-10-10','f','aadj','231','1231','arn@upel.edu.ve',NULL,'23181','c',66,7,233,80,5,2,'arn@upel.edu.ve',3,'1','s','adawh','3','2017-09-19','2','awdh','3'),(1097,'1231312','a','a','a','a','a','2017-10-10','f',NULL,'a','a','ar2n@upel.edu.ve',NULL,NULL,'s',NULL,NULL,NULL,NULL,5,2,'a',NULL,'1','n',NULL,'1',NULL,'0',NULL,'1'),(1098,'23181','a','a','a','a','a','2018-03-30','m','awdawda','1313123','12313123','sa@upel.edu.ve',NULL,NULL,'s',66,8,257,90,1,1,'hora',1,'1','n','aawda','1','2018-03-28','0','123123','1'),(1099,'1234567','Gaby',NULL,'Tovar',NULL,'V','2019-06-10','f',NULL,'0124',NULL,'jtovar@gmail.com',NULL,NULL,'s',NULL,NULL,NULL,NULL,NULL,1,NULL,1,'2','n',NULL,'1',NULL,'0',NULL,'1'),(1100,'171913','User',NULL,'Prueba',NULL,'Venezolana',NULL,'m',NULL,NULL,NULL,'userprueba@gmail.com',NULL,NULL,'s',NULL,NULL,NULL,NULL,20,1,NULL,1,'1','n',NULL,'1',NULL,'0',NULL,'1'),(1101,'18755057','Isaaaa',NULL,'T',NULL,'ve','1989-11-08','Masculino','asdfg','12345','123654','hola@gmail.com',NULL,NULL,'s',66,21,835,258,20,1,NULL,1,'1','n','hggj','1','2020-10-08','0','1242352','1'),(1102,'19925248','Wenwen',NULL,'Parra',NULL,'Veneca','1991-08-09','f',NULL,'0414','0212','wenwen@upel.com',NULL,NULL,'Casado(a)',66,19,721,228,20,1,NULL,1,'1','n',NULL,'1','2022-07-20','0','56121361465','1'),(1103,'13537829','Joseline',NULL,'Tovar',NULL,'Venezolana','1978-02-25','f',NULL,'0414','0212','joseline@upel.com',NULL,NULL,'Casado(a)',66,24,NULL,NULL,20,1,NULL,1,'1','n','UE P','1','1111-10-29','0','54354354','1'),(1104,'34123456','Juana',NULL,'Torres',NULL,'Venezolana','2007-06-20','f',NULL,NULL,NULL,'Juana@gmail.com',NULL,NULL,'s',66,24,930,285,20,1,NULL,1,'1','n',NULL,'1',NULL,'0',NULL,'1'),(1105,'35123456','Angel',NULL,'Iriarte',NULL,'v','2009-01-27','m','El Recreo',NULL,'1234567','angel@hotmail.com',NULL,NULL,'Soltero(a)',66,24,939,285,20,1,NULL,1,'1','n','UEN Calixto','2','2022-09-05','0','12345','1'),(1107,'135378299','Joseline',NULL,'Tovar',NULL,'v','2009-09-10','f','coche','12222',NULL,'joselinet@gmail.com',NULL,NULL,'Casado(a)',66,24,936,285,20,1,NULL,3,'1','n','UE M','1',NULL,'0','1273723','1'),(1108,'17148064','David','José','Hidalgo',NULL,'Venezolano',NULL,'m',NULL,'123456','12345','soportes@gmail.com',NULL,NULL,'Casado(a)',66,24,947,285,20,1,NULL,1,'1','n','iu','1','2020-01-28','0','123454','1'),(1109,'6469797','JOHELL',NULL,'RODRIGUEZ',NULL,'venezolano',NULL,'Masculino',NULL,'12345','123654','123@gmail.com',NULL,NULL,'Soltero(a)',66,21,835,258,20,1,NULL,1,'1','n',NULL,'1',NULL,'0',NULL,'1');
/*!40000 ALTER TABLE `estudiante` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estudiantes_aprob`
--

DROP TABLE IF EXISTS `estudiantes_aprob`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estudiantes_aprob` (
  `cedula` int(11) DEFAULT NULL,
  `primer_nombre` varchar(17) DEFAULT NULL,
  `segundo_nombre` varchar(15) DEFAULT NULL,
  `primer_apellido` varchar(11) DEFAULT NULL,
  `segundo_apellido` varchar(11) DEFAULT NULL,
  `nacionalidad` varchar(10) DEFAULT NULL,
  `fecha_nacimiento` varchar(10) DEFAULT NULL,
  `sexo` varchar(1) DEFAULT NULL,
  `direccion` varchar(71) DEFAULT NULL,
  `telefono_movil` varchar(12) DEFAULT NULL,
  `telefono_local` varchar(11) DEFAULT NULL,
  `email` varchar(37) DEFAULT NULL,
  `salf` varchar(10) DEFAULT NULL,
  `password` varchar(10) DEFAULT NULL,
  `estado_civil` varchar(1) DEFAULT NULL,
  `pais_id` int(11) DEFAULT NULL,
  `estado_id` int(11) DEFAULT NULL,
  `ciudad_id` int(11) DEFAULT NULL,
  `municipio_id` int(11) DEFAULT NULL,
  `etnia_id` varchar(10) DEFAULT NULL,
  `discapacidad_id` int(11) DEFAULT NULL,
  `twitter` varchar(4) DEFAULT NULL,
  `universidad_id` varchar(10) DEFAULT NULL,
  `estudiante_id` varchar(10) DEFAULT NULL,
  `programa_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `especialidad_id` int(11) DEFAULT NULL,
  `cohorte_id` int(11) DEFAULT NULL,
  `ingreso_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `situa_id` int(11) DEFAULT NULL,
  `fecha_ingreso` varchar(10) DEFAULT NULL,
  `activo` int(11) DEFAULT NULL,
  `observacion` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estudiantes_aprob`
--

LOCK TABLES `estudiantes_aprob` WRITE;
/*!40000 ALTER TABLE `estudiantes_aprob` DISABLE KEYS */;
INSERT INTO `estudiantes_aprob` VALUES (10844063,'YULIBETH','PATRICIA','AGUIRRE','SUAREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'14pulls59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4360',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11790905,'CARMEN','ELISA','VARELA','MARTINEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'16bugle49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4361',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12023971,'NEILA',NULL,'PASTRAN',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'2lame13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4362',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12111682,'IVETTE','CAROLINA','MALDONADO','GIMENEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17krill22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4363',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12642124,'YLSA','EUNICE','RIVAS','ZAMBRANO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9mends82','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4364',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13181143,'MARIBEL','DEL CARMEN','PEREIRA','HERRERA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15hurl8','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4365',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13268798,'LEXAURA','MERCEDES','PERNIA','ROJAS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4ensue52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4105',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13644815,'JOHAN','JOSE','VISCAYA','PEÑUELA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5typo59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4106',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13775627,'SOL','DEL VALLE','FERNANDEZ','DE TERAN','Venezolano','1975-09-10','m','----','----','----','----',NULL,'1hots7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4366',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14031034,'NUBRASKA','MARGARET','FREITEZ','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9rams6','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4107',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14094237,'DAYANA','FRANCISCA','PEREZ','AGÜERO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13bulks94','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4367',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14176662,'ANGELICA','COROMOTO','MONTILLA','PARRA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5mosey49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4368',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15342184,'ALEJANDRA','KATHERINE','ORTEGA','ACUÑA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8puce1','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4369',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16641763,'ANYELA','MARGARITA','OVIEDO','COLMENAREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5whisk51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4370',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17011892,'BEISI','SOFIA','ALVARADO','VARGAS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2ions49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4108',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17228765,'NUBRATLIS','MARYERLIN','FREITEZ','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6chaps40','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4109',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18059299,'JOHANNA','ROSALI','HURTADO','COHEN','Venezolano','1975-09-11','m','----','----','----','----',NULL,'8wrap81','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4110',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18332603,'ROSANA','KARINA','MONTILLA','MENDOZA','Venezolano','1975-09-12','m','----','----','----','----',NULL,'0crone81','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4371',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18526257,'EDGARDO','JOSE','TORRELAS','SUAREZ','Venezolano','1975-09-13','m','----','----','----','----',NULL,'16bred50','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4372',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18735638,'YURIELISS','KARINA','CARMONA','MENDOZA','Venezolano','1975-09-14','m','----','----','----','----',NULL,'5rejig49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4373',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18737154,'RILEDSY','CARINA','ROJAS','SALAS','Venezolano','1975-09-15','m','----','----','----','----',NULL,'12today68','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4111',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18997722,'FABIOLA','ANDREINA','COLMENAREZ','LANZILLOTTI','Venezolano','1975-09-17','m','----','----','----','----',NULL,'17fresh54','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4374',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19433629,'JHOANA','PATRICIA','CASTILLO','RAMIREZ','Venezolano','1975-09-18','m','----','----','----','----',NULL,'12unmet59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4375',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20010798,'DEYDILMAR','DIANA','RIERA','MENDOZA','Venezolano','1975-09-19','m','----','----','----','----',NULL,'16cover8','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4112',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(6209775,'JUANA','BAUTISTA','TOVAR','PEROZO','Venezolano','1975-09-20','m','----','----','----','----',NULL,'17parch58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4376',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7406775,'CARMEN','ALEXIS','PEREZ','FREITEZ','Venezolano','1975-09-21','m','----','----','----','----',NULL,'4noisy72','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4377',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9607482,'CARMEN','TERESA','ECHEVERRIA','UZCATEGUI','Venezolano','1975-09-22','m','----','----','----','----',NULL,'14refit27','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4378',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10128750,'RUBELIA','INMACULADA','GARCIA','QUERO','Venezolano','1975-09-23','m','----','----','----','----',NULL,'17cony75','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4379',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11262080,'ISBELIS','YARITZA','NAVAS',NULL,'Venezolano','1975-09-24','m','----','----','----','----',NULL,'16avail19','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4380',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11786101,'MARIA','DELMAR','ROA','LOBO','Venezolano','1975-09-25','m','----','----','----','----',NULL,'5conch60','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4381',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11881914,'DAMELYS','MARGOT','DURAN','PEÑA','Venezolano','1975-09-26','m','----','----','----','----',NULL,'2ward32','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4382',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12243619,'OLAINA','PASTORA','PEREZ',NULL,'Venezolano','1975-09-27','m','----','----','----','----',NULL,'3wings46','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4113',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12703231,'ANTUANE','JOSEFI','SANCHEZ','LEON','Venezolano','1975-09-28','m','----','----','----','----',NULL,'0tubas20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4383',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12851937,'HUGO','LUIS','RIVERO','PALACIO','Venezolano','1975-09-29','m','----','----','----','----',NULL,'8rhino9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4384',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12933190,'MARIA','EUGENIA','HEREDIA','CASTILLO','Venezolano','1975-09-30','m','----','----','----','----',NULL,'17speck53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4114',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12933817,'MAUDELINDA','MARILIN','PEROZO','GARCIA','Venezolano','1975-10-01','m','----','----','----','----',NULL,'5extra98','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4385',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12934091,'YOLENNYS','DEL CARMEN','PEÑA','MONTERO','Venezolano','1975-10-02','m','----','----','----','----',NULL,'6reran6','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4386',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12950285,'MERANYER','BEATRIZ','MARTINEZ','RAMOS','Venezolano','1975-10-03','m','----','----','----','----',NULL,'1inane2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4387',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14293082,'JOYVEER','SHIRLEY','MUJICA','TORRES','Venezolano','1975-10-06','m','----','----','----','----',NULL,'13stub9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4388',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15177829,'GLORINAR','YULIBETH','PEREZ','ESCALONA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'7furl20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4389',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15777025,'YSELY','YAMILETH','OJEDA','RODRIGUEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'11hides39','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4390',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16278400,'ANNILENNY','ARROYO','VIVAS',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'4sowed85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4391',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16343395,'LAURA','ANGELICA','LOZANO','LUCENA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'18cissy16','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4392',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16868816,'YANILA','GISELA','DIAZ','GONZALEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'7specs89','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4393',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17308395,'ROSA','MARIA','MENDEZ','CARDENAS','Venezolano','1975-10-06','m','----','----','----','----',NULL,'10emir44','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4394',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17873492,'NORALIS','JOSEFINA','ESCALONA','TOVAR','Venezolano','1975-10-06','m','----','----','----','----',NULL,'13works2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4395',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18104179,'MARIA','JOSEFA','BRIZUELA','GIMENEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'16ovoid47','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4396',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18863826,'LILIMAR','MARIELVIS','MENDOZA','GARCIA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'3eons74','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4397',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19424765,'LILIANA','ANABEL','LUCENA','OLIVO','Venezolano','1975-10-06','m','----','----','----','----',NULL,'8muzzy27','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4398',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10962119,'NAUDY','JOSÉ','GIMÉNEZ','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15cosh55','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4115',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15427549,'KEIBER','YALIDES','RODRÍGUEZ','DAZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9stash97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4116',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20471346,'MARIA','DE LOS ANGELES','AGUILAR','DELGADO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2tines24','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4117',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9570475,'OSWALDO','DE JESUS','JIMENEZ',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'19mist54','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4118',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15667153,'YOLIMAR',NULL,'SUÁREZ','ALEJOS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'10into11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4119',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18811799,'LISSETH','CAROLINA','CASTILLO','MEDINA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'19urban48','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4120',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7463611,'MARINA','DEL CARMEN','GUEVARA','DE LARA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'1lobe24','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4121',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16957737,'MARÍA','CAROLINA','PÉREZ','PÉREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0brook26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4122',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17874285,'FRANCYS','ROSANNY','GUTIERREZ','TORREALBA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0caved60','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4123',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20323088,'YOHANNY','CAROLINA','GONZALEZ','GUEVARA','Venezolano','1975-09-11','m','----','----','----','----',NULL,'11tolls100','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4124',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15273898,'CARMEN','ROSA','CUBAS','REA','Venezolano','1975-09-14','m','----','----','----','----',NULL,'17ennui76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4125',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16736148,'AMARILIS','CAROLINA','PÉREZ','GUEVARA','Venezolano','1975-09-16','m','----','----','----','----',NULL,'18inked22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4126',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16737691,'RAFAEL','MOREN','ECHEGARAY','JIMENEZ','Venezolano','1975-09-17','m','----','----','----','----',NULL,'20face5','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4127',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17101440,'LILIANA',NULL,'COLORADO','VALENZUELA','Venezolano','1975-09-18','m','----','----','----','----',NULL,'19yoga12','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4128',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17727028,'YULIANA','PASTORA','TORRES','VASQUEZ','Venezolano','1975-09-19','m','----','----','----','----',NULL,'15opium33','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4129',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12370822,'ZULMA','DEL VALLE','MUJICA','JIMENEZ','Venezolano','1975-09-21','m','----','----','----','----',NULL,'14cast59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4130',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18137054,'YASMIN','YELITZA','SUÁREZ','PÉREZ','Venezolano','1975-09-23','m','----','----','----','----',NULL,'6newsy57','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4131',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20321085,'ANABEL','CRISTINA','JIMENEZ','LINAREZ','Venezolano','1975-09-24','m','----','----','----','----',NULL,'7revs53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4132',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12370410,'OSMIR','SABRINA','LARA','MUJICA','Venezolano','1975-09-25','m','----','----','----','----',NULL,'15dryad41','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4133',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16736013,'MIRIAN','ROSA','MENDOZA','MENDOZA','Venezolano','1975-09-27','m','----','----','----','----',NULL,'1movie83','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4399',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17639593,'NAYLIANA','MARIA','CASTAÑEDA','CHAVEZ','Venezolano','1975-09-28','m','----','----','----','----',NULL,'13bills47','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4134',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7454150,'LESLIE','MARICELA','TOVAR','MENDOZA','Venezolano','1975-09-30','m','----','----','----','----',NULL,'20feta85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4135',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7457775,'CARLOS','ALBERTO','EREU','GONZALEZ','Venezolano','1975-10-01','m','----','----','----','----',NULL,'2nears39','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4136',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10129680,'DORIS','LUCIA','YUSTIZ','HERNANDEZ','Venezolano','1975-10-02','m','----','----','----','----',NULL,'5sure97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4137',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14810360,'MILEXA','YAQUELINE','RODRÍGUEZ','RODRÍGUEZ','Venezolano','1975-10-04','m','----','----','----','----',NULL,'11gnats75','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4138',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17874226,'YUDESY','ESTER','PÉREZ','JIMÉNEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'12males49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4139',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10126214,'IRENE','NORAIMA','JIMÉNEZ','SILVA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'11aware76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4140',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10956699,'JUANA','JOSEFINA','PÉREZ','DÍAZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'17emir62','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4141',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11584324,'ANA','MARIA','LOVERA',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'20brood78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4142',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13880971,'HEIDY','MARIA','MATHEUS','ALBURJAS','Venezolano','1975-10-06','m','----','----','----','----',NULL,'5arbor52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4143',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17101350,'LEIDIS','COROMOTO','COLMENAREZ','ESCOBAR','Venezolano','1975-10-06','m','----','----','----','----',NULL,'13treks58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4144',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11588908,'CRISALIDA','MERCEDES','LOYO','ARMAO','Venezolano','1975-10-06','m','----','----','----','----',NULL,'6stark76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4145',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12592567,'FRANCY','GREGORIA','PERALTA','MENDOZA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'16sloop85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4146',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12944578,'MARÍA','ELIZABETH','CARUCÍ','GONZÁLEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'1exec76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4147',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17132254,'SARAY','COROMOTO','ESCALONA',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'10sweet11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4148',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7988371,'MARÍA','DEL CARMEN','GARCÍA','PÉREZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'15ideas19','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4149',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9572242,'MIGDALIA','JOSEFINA','ALVARADO','MARTINEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'1untie49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4150',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13867854,'EUSEBIA','DEL CARMEN','PEREZ','ALVARADO','Venezolano','1975-10-06','m','----','----','----','----',NULL,'20bubs67','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4151',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16957364,'YUCELBY','JOSE','ALVARADO','URDANETA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'6envoy12','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4152',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17132374,'DORISMAR','DEL VALLE','GIMENEZ','MACHADO','Venezolano','1975-10-06','m','----','----','----','----',NULL,'1revel55','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4153',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18135651,'JOSÉ','LUIS','RODRÍGUEZ','FLORES','Venezolano','1975-10-06','m','----','----','----','----',NULL,'1stows2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4154',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(4730804,'ANGELA','RENATA','SOTELDO','RAMOS','Venezolano','1975-10-06','m','----','----','----','----',NULL,'7acme83','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4155',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17132602,'YURI','SOPHIA','RODRIGUEZ','ORTIZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'2strop11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4156',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16239156,'YOSMAR','CAROLINA','BARRIOS','PÉREZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'20mousy20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4157',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17620126,'FATIMA','CAROLINA','RODRIGUES','LOPES','Venezolano','1975-10-06','m','----','----','----','----',NULL,'17para84','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4158',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19572182,'ERNILE','ANTONIO','JIMÉNEZ','DUIN','Venezolano','1975-10-06','m','----','----','----','----',NULL,'0fuzzy40','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4159',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13679889,'MARÍA','ELENA','FREITEZ','RODRÍGUEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'14fink3','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4160',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16736684,'JUAN','DARIEN','RODRÍGUEZ','PEREZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'15shots19','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4161',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13867086,'NEIDIMAR','LISET','LARA','TOVAR','Venezolano','1975-10-06','m','----','----','----','----',NULL,'9balls33','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4162',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15272453,'KARELYS','JOSE','LISCANO','PAEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'19split21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4163',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18135233,'BILLY','JOSE','LOPEZ','MOFFI','Venezolano','1975-10-06','m','----','----','----','----',NULL,'10adzes54','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4164',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(4586291,'LUIS','JOSÉ','PARADA',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'16avail61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3661',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(5932016,'PROVIDENCIA','JOSEFINA','PERNALETE','PARRA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0revs58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4025',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7114704,'MARÍA','TERESA','GONZALEZ','GONZALEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15scion26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4026',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7426000,'MILAGROS','YULEIMA','TORREALBA','MEDINA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2video11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4027',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12535199,'GLORIA','ALICIA','ATEHORTUA','DE ROJAS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'18heeds54','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4063',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13343330,'NORELYS','DEL ROSARIO','LOPEZ','SANCHEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15profs46','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4104',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13619416,'CARMEN','MARIA','CASTELLANOS','VASQUEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'16stiff42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4028',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13645684,'MARIA','ELIODINA','PEREZ','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15inane51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4029',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14175842,'MARIA','DUILIAN','ARICUCO','CARRILLO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17dandy76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4030',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14269828,'AUDRA','YAMIR','AMBROCIO','MEDINA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8chili76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4031',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14426833,'PEDRO','JESUS','PEROZO','CAMACARO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13sups12','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4032',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14482226,'ZULKALIN','COROMOTO','CHIRINOS','SANTELIZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2gulfs89','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4033',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14938209,'DENNYS','ALI','BECERRA','MERCHAN','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6hate42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4034',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15017436,'MARIA','ESPERANZA','BRACHO','OLLARVES','Venezolano','1975-09-10','m','----','----','----','----',NULL,'11strop78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4035',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15188746,'LUIS','GERARDO','MENDEZ','VALERO','Venezolano','1975-09-11','m','----','----','----','----',NULL,'15inept95','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4036',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15412830,'JOVANNY','RAMÓN','MARIN','SÁNCHEZ','Venezolano','1975-09-12','m','----','----','----','----',NULL,'20five63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4037',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15424216,'LEIDY','MARYULI','GUTIERREZ','RODRÍGUEZ','Venezolano','1975-09-13','m','----','----','----','----',NULL,'5stab3','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4038',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15448147,'YESSICA','SOLIMAR','OROPEZA','RODRÍGUEZ','Venezolano','1975-09-14','m','----','----','----','----',NULL,'15mold16','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4039',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15731129,'ROSA','VIRGINIA','PARRAGA','MENDOZA','Venezolano','1975-09-15','m','----','----','----','----',NULL,'11ensue53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4040',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16592807,'LUIS','ALBERTO','PARADA','SIBRIAN','Venezolano','1975-09-16','m','----','----','----','----',NULL,'10wart61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4041',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17012556,'ARMANDO','LUIS','GARCIA','GOMEZ','Venezolano','1975-09-17','m','----','----','----','----',NULL,'2ecru77','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4042',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17019089,'MARY','CHIQUINQUIRA','SISIRUCA','GOMEZ','Venezolano','1975-09-18','m','----','----','----','----',NULL,'13foul59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4043',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17227673,'LINOSKY','RAFBEK','VARGAS','GONZALES','Venezolano','1975-09-19','m','----','----','----','----',NULL,'19break45','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4044',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17465040,'LADY','DIANA','PERNALETE','ANAYA','Venezolano','1975-09-20','m','----','----','----','----',NULL,'13telly99','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4045',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17572203,'NATHALÍ','CRISTINA','SUÁREZ','GARCIA','Venezolano','1975-09-21','m','----','----','----','----',NULL,'12nice87','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4046',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18493151,'JENNITSSE','DEL CARMEN','CASTILLO','VARGAS','Venezolano','1975-09-22','m','----','----','----','----',NULL,'16foals94','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4047',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18669974,'DIANA','DEL VALLE','CASTILLO','MARQUEZ','Venezolano','1975-09-23','m','----','----','----','-@j.com',NULL,'17prude18','s',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,'4266',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18812518,'TAIANA','PASTORA','DAZA','TORREALBA','Venezolano','1975-09-25','m','----','----','----','----',NULL,'13coupe9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4049',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18861646,'ELISAUL','JOSÉ','MÉNDEZ','VARGAS','Venezolano','1975-09-26','m','----','----','----','----',NULL,'12inked31','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4050',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18871021,'DANELYS','ELIENNIS','ROMANO','TORREALBA','Venezolano','1975-09-27','m','----','----','----','----',NULL,'16decor88','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4051',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18897140,'MARIANGEL','NOHEMI','JAYARO','RIVERO','Venezolano','1975-09-28','m','----','----','----','----',NULL,'13outer94','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4052',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19264357,'YACSELIS','ENEDINA','BELLO','MEJIAS','Venezolano','1975-09-29','m','----','----','----','----',NULL,'12masts6','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4053',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19265348,'ANGGIE','MICHELLE','MORA','COLMENAREZ','Venezolano','1975-09-30','m','----','----','----','----',NULL,'4stank22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4054',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19348727,'CECILIA','MARIA','GARCIA','CRISOSTOMO','Venezolano','1975-10-01','m','----','----','----','----',NULL,'7dhoti2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4055',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19430791,'AURISBELLA','LLOSEFINA','AGUILAR','MIGUILENA','Venezolano','1975-10-02','m','----','----','----','----',NULL,'18bacon30','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4056',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19779287,'MARIANNY','CAROLINA','GUÉDEZ','GIL','Venezolano','1975-10-03','m','----','----','----','----',NULL,'7waxy48','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4057',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20010171,'MARIA','DE LOS ANGELES','PEROZO','CAMACARO','Venezolano','1975-10-04','m','----','----','----','----',NULL,'19attic88','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4058',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20015868,'YOANGELIS','ANTONELLA','SEQUERA','FIGUEROA','Venezolano','1975-10-05','m','----','----','----','----',NULL,'6bloke84','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4059',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20469275,'KAREN','ELENA','PINEDA','SANCHEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'13marks22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4060',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20539128,'VIRGINIA','COROMOTO','MENDEZ','RODRIGUEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'9cosy76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4061',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(23487093,'ROSA','ANGELA','VARGAS','ROMERO','Venezolano','1975-10-06','m','----','----','----','----',NULL,'17cells7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4062',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18737148,'RIDSER','CAROLINA','ROJAS','SALAS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'11grim21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3927',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17196559,'LIGIA','ELENA','SEIDEL','GIMENEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5chimp27','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3928',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15767360,'MARIA','JOSE','CORONEL','GUTIERREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9choc37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3929',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10854775,'ARACELIS','COROMOTO','REAÑEZ','COLMENAREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8tack78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3930',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19779205,'MILAGROS','COROMOTO','BENITEZ','HERNANDEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15extra9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3931',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13265586,'RHOSTY','YANETH','HEREDIA','AREVALO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'19incur85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3932',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16385669,'NORMEDIS','MARION','MORILLO','RAMOS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'11depth69','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3933',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15264325,'ANA','MERCEDES','MATHEUS','LOPEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0magma14','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3934',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18785593,'JESSICA','YAILIN','PEREZ','MONTERO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'11cliff70','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3935',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17196360,'LEIDY','CAROLINA','HERNANDEZ','PEÑA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6proud78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3936',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16387660,'MAGDANUELY',NULL,'QUEVEDO','GARCIA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2inky2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3937',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7434990,'ANGELICA','DEL CARMEN','ARRIECHE','ZAVARCE','Venezolano','1975-09-10','m','----','----','----','----',NULL,'14sever95','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3938',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12698383,'YISMARY','LUCIA','FRIAS','ALVAREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2recto64','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3939',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15997991,'DUBINAY','DE LOS ANGELES','SALON','LOYO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13depot97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3940',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16402987,'IRIS','YANETH','MUJICA','VALERA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'1cube26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3941',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13556381,'YARITZA','BETSABETH','SEGOVIA','VALERO','Venezolano','1975-09-11','m','----','----','----','----',NULL,'14palls64','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4400',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17227752,'KIRA',NULL,'MORENO','CHIRINOS','Venezolano','1975-09-11','m','----','----','----','----',NULL,'16debar86','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3942',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15444561,'MARÍA','ANDREINA','FLORES','RODRÍGUEZ','Venezolano','1975-09-11','m','----','----','----','----',NULL,'9graph78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3424',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13264219,'RANFIS','RODOLFO','RAMOS','MENDEZ','Venezolano','1975-09-11','m','----','----','----','----',NULL,'16moss97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3943',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14093331,'GIAN','FRANCO','MARULLO','DURAN','Venezolano','1975-09-11','m','----','----','----','----',NULL,'20drake87','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3944',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15886212,'JECKSSON','JAVIER','TORRES','GARCÍA','Venezolano','1975-09-11','m','----','----','----','----',NULL,'2into80','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3945',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13408024,'DEIVI','EMILIO','BRICEÑO','SAAVEDRA','Venezolano','1975-09-11','m','----','----','----','----',NULL,'5forty52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3946',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18897019,'RAFAEL','ANTONIO','BENITEZ','INFANTE','Venezolano','1975-09-11','m','----','----','----','----',NULL,'2ribs67','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4401',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7360392,'CESAR','ANTONIO','MENDEZ','BARAZARTE','Venezolano','1975-09-11','m','----','----','----','----',NULL,'17coir78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3947',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17034012,'KARLA','PATRICIA','MENDOZA','CORDERO','Venezolano','1975-09-11','m','----','----','----','----',NULL,'18ditzy76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3948',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17506558,'DAYANA','KAROLINA','TORREALBA','RAMOS','Venezolano','1975-09-11','m','----','----','----','----',NULL,'13effed82','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3949',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7575191,'SAMUEL','EDUARDO','PARRA','BAEZ','Venezolano','1975-09-11','m','----','----','----','----',NULL,'3wound37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3950',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18334543,'JOSE','ANTONIO','HERNANDEZ',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'6pints22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3951',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18950634,'MANUEL','R.','PEREZ','CORDERO','Venezolano','1975-09-11','m','----','----','----','----',NULL,'4merit75','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3952',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16378341,'CARLOS',NULL,'VALE',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'18bags63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3863',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9627845,'NOEL','ARMANDO','RODRIGUEZ','CARRASCO','Venezolano','1975-09-11','m','----','----','----','----',NULL,'10thins45','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3953',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14825049,'SUSAN',NULL,'GIMENEZ',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'19caber61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3954',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20187514,'RAFAEL','EDUARDO','ROMERO','ARANGU','Venezolano','1975-09-11','m','----','----','----','----',NULL,'12deify36','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3955',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19166724,'MARCO','VINICIO','HERNÁNDEZ','RODRÍGUEZ','Venezolano','1975-09-11','m','----','----','----','----',NULL,'7canoe5','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3956',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16139114,'JESSICCA','CARMEN','PEREZ','DURAN','Venezolano','1975-09-11','m','----','----','----','----',NULL,'10homed20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3957',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19170398,'ELBA','DAMARYS','AZUAJE','VILLEGAS','Venezolano','1975-09-11','m','----','----','----','----',NULL,'5nouns73','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3958',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14333319,'Carlos','Enrique','Piña',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'8cloud42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3900',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13529582,'Americo','Antonio','Delfines','Castañeda','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2cony42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3901',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18250384,'Nancy','Gregoria','Barazarte','Torres','Venezolano','1975-09-10','m','----','----','----','----',NULL,'20iota34','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3902',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12243764,'Edgar','Mariano','Parra','Guaido','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17adobe73','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3903',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12436116,'Danny','Enrique','Medina','Urquiola','Venezolano','1975-09-10','m','----','----','----','----',NULL,'18extra7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3904',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17451745,'Cristina','Elizabeth','Mendoza','Sandoval','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15ditch89','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3905',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16737430,'Johan','Manuel','Luna','Leon','Venezolano','1975-09-10','m','----','----','----','----',NULL,'20verb85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3906',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20924285,'Luisangelis','Beresther','Pereira','Arrieche','Venezolano','1975-09-10','m','----','----','----','----',NULL,'20lawn27','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3907',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15729430,'Hector','Ruben','Monasterios','Gimenez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17reps21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3908',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12594000,'Juan','Carlos','Perez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'15bells26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3909',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11882196,'Rafael','Antonio','Sira','Alvarez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8uncle16','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3910',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17852349,'Hernan','Alirio','Rodriguez','Torrealba','Venezolano','1975-09-10','m','----','----','----','----',NULL,'16traps52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3911',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12784341,'Yeside','Yajir','Yanez','Arroyo','Venezolano','1975-09-10','m','----','----','----','----',NULL,'18bland56','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3912',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16415357,'Jackson','Miguel','Escobar','Mujica','Venezolano','1975-09-10','m','----','----','----','----',NULL,'14picky45','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3913',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17992465,'Jesus','Octavio','Castillo','Duarte','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6labs78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3914',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11788585,'Maria','Yolaiza','Sanches','Escalona','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8prep39','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3915',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7450663,'Jesus','Maria','Anza','Pineda','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0enema83','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3916',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18689610,'Carmen','Sofia','Gonzalez','Perez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'18wedge61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3917',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17872717,'Daniel','Jose','Soto','Teran','Venezolano','1975-09-11','m','----','----','----','----',NULL,'15need81','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3918',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17638195,'Ana','Karina','Castillo','Torres','Venezolano','1975-09-11','m','----','----','----','----',NULL,'14digit96','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4165',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7354822,'Carmen','Lorenza','Melendez',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'12shame50','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3919',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10856121,'Lissette','Leticia','Torrealba','Mujica','Venezolano','1975-09-11','m','----','----','----','----',NULL,'1mugs88','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3920',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11426923,'Griselda','Beatriz','Perez','Ojeda','Venezolano','1975-09-11','m','----','----','----','----',NULL,'15geed61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3921',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9541406,'Mayanis','Morella','Rodriguez','Suarez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'11ingot23','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3922',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9620289,'Yelitza','Zenaida','Soto','Castellanos','Venezolano','1975-09-11','m','----','----','----','----',NULL,'20imply95','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3923',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9722918,'Andreina',NULL,'Alcantara','Hernandez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'6grace76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3925',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10842503,'Juan',NULL,'Lopez',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'11cony37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3926',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9542607,'Jose','Luis','Ochoa','Suarez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'12downs98','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4166',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18737048,'Crely','Virginia','Liscano','Silva','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2staff30','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4167',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19106913,'Jose','Miguel','Antequera','Mendoza','Venezolano','1975-09-10','m','----','----','----','----',NULL,'3works18','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4168',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(21104291,'Jean','Carlos','Lopez','Sanchez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13glam71','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4169',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19779401,'Frangy','Arlimar','Alvarado','Gonzalez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15kilos100','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4170',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11595284,'Giovanni','de Jesus','Saavedra','Rodriguez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'14dolt79','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4171',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20921675,'Antony','Javier','Leal','Gonzalez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2unify38','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4172',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15447181,'Rafael','Anguel','Liscano','Rivero','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17tarns73','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4402',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15424376,'Yorvin','Alexis','Torrealba','Escalona','Venezolano','1975-09-10','m','----','----','----','----',NULL,'14scion80','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4173',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15424377,'Jhomer','Alexander','Torrealba','Escalona','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4noted7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4174',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15307411,'Jairo','Jesus','Escalona','Jimenez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9apse93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4175',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18334272,'Gabriela','Isbeth','Suarez','Juarez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'1bugle63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4176',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9615124,'Jose','Gregorio','Arroyo','Barahona','Venezolano','1975-09-11','m','----','----','----','----',NULL,'5quads30','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4177',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19323842,'Rosa','Maria','Principal','Molina','Venezolano','1975-09-11','m','----','----','----','----',NULL,'9unmet28','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4403',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20351627,'Indhira','Lizz','Almao','Hernandez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'6cony3','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4178',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20189730,'Luis','Alberto','Jimenez','Sarmiento','Venezolano','1975-09-11','m','----','----','----','----',NULL,'11mate74','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4179',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17727291,'Isrrael','David','Valera','Tua','Venezolano','1975-09-11','m','----','----','----','----',NULL,'4pouts74','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4180',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17356811,'Maria','Ismely Fernanda','Escobar','Peña','Venezolano','1975-09-11','m','----','----','----','----',NULL,'5gift2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4181',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16404072,'Juan','Gillermo','Torres','Perez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'6group17','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4182',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13464332,'Edyer','Pastor','Barradas','Linarez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'20audio1','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4183',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15229973,'Devy','Jose','Canelon','Sanchez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'12false51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4184',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12882658,'ELYS',',','JIMENEZ',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'9melts87','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4088',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(19571417,'ROSMERY',',','GUEDEZ',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'10emcee96','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4089',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(18656580,'JESUS',',','TORRES',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'8thrum78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4090',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(16966055,'MAIRA',',','CARVAJAL',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'5flask59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4091',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(19423380,'ROCIO',',','RODRIGUEZ',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'20flask19','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4092',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(14558401,'ILIANA',',','GOMEZ',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'7mayor54','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4094',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(12702301,'ANA',',','DEL DUCA',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'2urban81','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4095',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(19883725,'DIRSO',',','BARRADAS',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'7coon43','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4096',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(17574564,'YOSMARY',',','OVIEDO',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'1apron21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4097',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(18105281,'CRUZ',',','RODRIGUEZ',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'15rids31','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4098',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(17783551,'YESIKA',',','LUCENA',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'6conks88','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4099',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(18301053,'ANTHONY',',','ASUAJE',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'18diets27','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4100',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(20642182,'Merymark',NULL,'Peña','Timaure','Venezolano','1975-09-10','m','----','----','----','----',NULL,'10fogey64','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3883',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17858562,'Jenyred','Herminia','Medina','Adames','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0warms69','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3884',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10258486,'Berna','Coromoto','Araujo','Montilla','Venezolano','1975-09-10','m','----','----','----','----',NULL,'3imps82','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3885',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18525470,'Greiz','Elizabeth','Santaella','Duarte','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17ribs56','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3886',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20500946,'Diosmary','Josefina','Torres','Rodríguez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15syrup23','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3887',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18672860,'Greta','Milagro','Valbuena',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'4trees81','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3888',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18891130,'Elismar','Coromoto','Valera','Montilla','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0moor11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3889',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16794496,'Florelia','Alejandra','Daza','Piñero','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5hippy39','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3890',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17853466,'Zorenis','Yamileth','Oviedo','Franco','Venezolano','1975-09-10','m','----','----','----','----',NULL,'7cony15','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3891',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19551796,'Jhonnarlyn','José','Niazoa','Giménez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15away14','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3892',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17593040,'Ladys','Johana','Montenegro','Barreto','Venezolano','1975-09-10','m','----','----','----','----',NULL,'7dodgy15','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3894',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11084317,'Janine','Nguyen','González','Ortiz','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17choc9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3895',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11880371,'Ángela','Beatriz','Sivira','Rojas','Venezolano','1975-09-10','m','----','----','----','----',NULL,'1recur46','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3896',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18735275,'Darling','Yiselt','Torrealba','Álvarez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'14imply12','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3897',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(83634400,'Nelly','Judith','Bohada','Jiménez','Venezolano','1975-09-13','m','----','----','----','----',NULL,'3horsy85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2942',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20667094,'Maria','lyLibe','Colmenares','Soto','Venezolano','1975-09-13','m','----','----','----','----',NULL,'12bebop83','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3898',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19818169,'Yuleidys','Milagros','Torrealba','Pérez','Venezolano','1975-09-13','m','----','----','----','----',NULL,'3racy1','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3899',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12725827,'María','de los Angeles','Piña','Petit','Venezolano','1975-09-10','m','----','0412-1744515','----','Petitmariap77@gmail.com',NULL,'20jazz61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4185',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13842562,'Mackensy','Carmen','Villegas','Bullones','Venezolano','1975-09-10','m','----','0416-5549755','----','mackensyv@hotmail.com',NULL,'14rend9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4186',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15918915,'Josdaly',NULL,'Querales','Goyo','Venezolano','1975-09-10','m','----','0426-9508329','----','josdalydesandoval@hotmail.com',NULL,'5straw5','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4187',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(22600738,'Emiro','Alfonzo','Colina','Medina','Venezolano','1975-09-10','m','----','0416-3693673','----','Emiroalf93@gmail.com',NULL,'10trend73','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4188',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(21157861,'Jennifer','Carolina','Moller','Salas','Venezolano','1975-09-10','m','----','0426-1537961','----','jennimoller@gmail.com',NULL,'9qualm53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4189',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14293847,'Carlos','Javier','Martínez','Arrieta','Venezolano','1975-09-10','m','----','0416-8569100','----','Carlosmartinezarrieta1998@hotmail.com',NULL,'9sand77','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4190',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13905485,'Eduardo','Antonio','Humbría','Moncada','Venezolano','1975-09-10','m','----','0424-5119955','----','eduardohumbri@hotmail.com',NULL,'8unmet42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4191',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13464520,'Eglee','Edelwis','Carruido','Tua','Venezolano','1975-09-10','m','----','0424-5145558','----','egleecarruido@hotmail.com',NULL,'20crew2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4192',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13267866,'Lilianyela','Ramona','Castillo','Amaro','Venezolano','1975-09-10','m','----','0426-5134652','----','lilianyelaramona@gmail.com',NULL,'8jogs83','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4193',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14160395,'Heylin','Marina','Mogollón','Pineda','Venezolano','1975-09-10','m','----','0416-1545297','----','heylfranco@yahoo.com',NULL,'10dicey93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4194',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16584285,'María','Antonieta','Gallardo','Silva','Venezolano','1975-09-10','m','----','0416-1546835','----','Mariagallardo2706@gmail.com',NULL,'10coon73','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4195',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11262576,'Lisbelia','Josefina','Alvarado','Rodríguez','Venezolano','1975-09-10','m','----','0412-1641135','----','lisbeliaalvarado@gmail.com',NULL,'2chomp20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4196',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17858149,'Gissell','Nahir','Alvarado','Soto','Venezolano','1975-09-10','m','----','0426-3085666','----','Gissell.alvarado@gmail.com',NULL,'11dawn63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4197',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16899641,'Yexsi','carolina','Alvarado','Soto','Venezolano','1975-09-10','m','----','0426-2557809','----','Yexsi.alvarado@gmail.com',NULL,'4packs44','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4198',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11261606,'Jairo','Meranel','Brijaldo','Acosta','Venezolano','1975-09-10','m','----','0416-1217000','----','brijaldo@yahoo.com',NULL,'8debs11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4199',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7504912,'Yony','Gregorio','Osorio','Gudiño','Venezolano','1975-09-11','m','----','0416-1056102','----','Yonyosorio75@gmail.com',NULL,'20joust29','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4200',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7594072,'Radames','Laerte','Gimenez','Segura','Venezolano','1975-09-13','m','----','0416-4525528','----','calparmo@gmail.com',NULL,'8monk29','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4201',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13996806,'Gilberto',NULL,'Briceño',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'2nanny41','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4404',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7389671,'Carmen',NULL,'Colmenarez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'5hippy72','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4405',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17782313,'Annabel',NULL,'Cumare',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'11horsy78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4406',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9618662,'Yamilet',NULL,'Escalona',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'20batch47','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4407',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17195337,'Gerardo',NULL,'Gómez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'10puce53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4408',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7436802,'Moraima',NULL,'González',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'16coon51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4409',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15777458,'Rafael','A.','Linárez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'13scion13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4410',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14937552,'Walter',NULL,'López',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'17negro37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4411',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7417249,'Jenny','P','Mendoza',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'19occur59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4412',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11878104,'Arelis',NULL,'Montilla','Parra','Venezolano','1975-09-10','m','----','----','----','----',NULL,'12teed31','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4413',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20046116,'Juan  Clerismar',NULL,'San',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'9coup99','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4414',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7125424,'Beatriz',NULL,'Páez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'4idiot68','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4415',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9836789,'José',NULL,'Parra','T.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0nosed48','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4416',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13083471,'Joxis',NULL,'Perez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'1lards55','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4417',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12369201,'Juan',NULL,'Pérez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'2canny53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4418',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15543342,'Noremis',NULL,'Pérez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'9mules93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4419',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12536314,'Omaira',NULL,'Salas',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'4limey35','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4420',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16139982,'Yarismar',NULL,'Torrealba',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'5sops21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4421',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16112344,'Wilcar',NULL,'Rojas',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'0craze57','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4422',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12247281,'Darwin',NULL,'Ortiz',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'17pros5','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4423',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17033177,'Caribay','A.','Linárez',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'3sera42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4424',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19347275,'Johancy',NULL,'Romero',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'10entry70','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4425',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18422039,'Yohender',NULL,'Romero',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'2burgh86','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1782',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11477929,'Roland',NULL,'Chirinos',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'6ditch20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4426',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19686568,'YANNALYT,','C','MENDOZA,','M','Venezolano','1975-09-27','f','----','----','----','mendoza@hotmai.com',NULL,'17hewed8','s',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,'4427',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7447200,'YASMIN','COROMOTO','SANTANA',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'6since61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4428',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7458465,'NELLYS','ELOIDA','PERDOMO','SEQUERA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6overt38','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4429',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7466106,'DEISY','COROMOTO','GARCIA','MONTILLA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0into9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4430',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9573218,'FLORA','ELIGIA','BOQUILLO','FALCON','Venezolano','1975-09-10','m','----','----','----','----',NULL,'1chomp55','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4431',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10126759,'FARIDA','ALTAGRACIA','RODRIGUEZ','RAGA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8bevy78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4432',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12882597,'YENNY','COROMOTO','RODRIGUEZ','DE TOVAR','Venezolano','1975-09-18','m','----','----','----','----',NULL,'20bent85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4433',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12882649,'IDALIA','CONCEPCION','RODRIGUEZ','PERALTA','Venezolano','1975-09-19','m','----','----','----','----',NULL,'18traps33','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4434',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13196571,'SANDY','LISBETH','LEON','PEROZA','Venezolano','1975-09-21','m','----','----','----','----',NULL,'3lens38','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4435',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13723584,'JACQUELINE','MARGARITA','CORDONES','COLINA','Venezolano','1975-09-24','m','----','----','----','----',NULL,'14rejig51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4436',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13867430,'YULYS','MARYELIS','MENDEZ','MENDOZA','Venezolano','1975-09-25','m','----','----','----','----',NULL,'0rouse89','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4437',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14592560,'IRAILIS','ALEJANDRA','GIMENEZ','MARTINEZ','Venezolano','1975-09-30','m','----','----','----','----',NULL,'14aces37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4438',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15444666,'MILARYS','IDANIA','DAZA','PEREZ','Venezolano','1975-10-04','m','----','----','----','----',NULL,'5amid52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4439',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15918880,'NELMAR','SOLEDAD','PEREZ','VEGA','Venezolano','1975-10-07','m','----','----','----','----',NULL,'5testy97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4440',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15919662,'MAYERLIN','ADRIANA','GUEDEZ','MEDINA','Venezolano','1975-10-08','m','----','----','----','----',NULL,'11wised52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4441',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16735605,'CLAUDIA','MAIKELY','LUCENA','LEON','Venezolano','1975-10-12','m','----','----','----','----',NULL,'18condo72','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4442',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16956676,'YURI','MAIKELI','FLORES','TORRES','Venezolano','1975-10-13','m','----','----','----','----',NULL,'3naval98','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4443',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17639587,'YAMILET','DEL CARMEN','LINAREZ','MENDOZA','Venezolano','1975-10-15','m','----','----','----','----',NULL,'20condo53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4444',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18431678,'NAIROBIS','LISBETH','GIL','ARBUJAS','Venezolano','1975-10-17','m','----','----','----','----',NULL,'4skunk26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4445',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17506971,'DAILETH','JOSEFINA,','FONSECA','RODRIGUEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4inked50','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4267',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11693143,'ZIBEL','MARGARITA,','RODRIGUEZ','DIAZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5dryad92','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4268',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7985931,'MARGARITA','DEL CARMEN','MENDOZA','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5condo16','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4269',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15886082,'JENNIFER','CRISTINA,','YZARRA','ESCALONA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15curse14','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4270',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18288046,'JOSE','GREGORIO','CALDERON','GARCIA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6titty70','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4271',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19264698,'YELIXA','DEL','CARMEN','SANCHEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8humid49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4272',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18438345,'NEIDA','MARIA','ALVARADO','SILVA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'3gild43','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4273',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18105180,'NELSON','JOSE,','PARADAS','SANTELIZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17masts85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4274',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14030479,'DALIMAR','YOLEIDA,','SANCHEZ','YANEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2until26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4275',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16585947,'YOLIMAR','CRISTINA','PEÑA','MOGOLLON','Venezolano','1975-09-10','m','----','----','----','----',NULL,'3ditzy61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4276',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15960705,'RAMON','EGIDIO',NULL,'DURAN','Venezolano','1975-09-11','m','----','----','----','----',NULL,'1midst60','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4277',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20015610,'DARIELY','ANGELICA','MENDEZ','MENDEZ','Venezolano','1975-09-12','m','----','----','----','----',NULL,'7couch40','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4278',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13605770,'YULIBETH','TERESA,','CANTILLO','SANCHEZ','Venezolano','1975-09-13','m','----','----','----','----',NULL,'13ache59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4279',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14000579,'SILENY','SARAHIT','PARADAS','DE CARRASCO','Venezolano','1975-09-14','m','----','----','----','----',NULL,'12snowy6','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4280',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17573286,'CARLA','PASTORA','MARTINEZ','PINEDA','Venezolano','1975-09-15','m','----','----','----','----',NULL,'13bacon34','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4281',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16089881,'MARIA','LAURA','OVALLES','GOMEZ','Venezolano','1975-09-16','m','----','----','----','----',NULL,'19enema29','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4282',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13644871,'JORGE','JOSE','OCHOA','GARCIA','Venezolano','1975-09-17','m','----','----','----','----',NULL,'12brigs52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4283',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17795629,'YOLANDA','CAROLINA','PETIT','DE SOTO','Venezolano','1975-09-18','m','----','----','----','----',NULL,'14trite95','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4284',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(6355884,'MONICA',NULL,'GIMENEZ',NULL,'Venezolano','1975-09-19','m','----','----','----','----',NULL,'10posts39','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4285',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14649536,'FLOR','DEL VALLE','MOGOLLON','CAMACHO','Venezolano','1975-09-20','m','----','----','----','----',NULL,'8scion41','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4286',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15412897,'RAFAEL','RAMON,','FREITEZ','ALVAREZ','Venezolano','1975-09-21','m','----','----','----','----',NULL,'8split99','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4287',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7419955,'EDITH','DEL ROSARIO','CUICAS','SANCHEZ','Venezolano','1975-09-22','m','----','----','----','----',NULL,'19until97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4288',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15307840,'ROBERTH','ANTONIO,','HEREDIA','MENDOZA','Venezolano','1975-09-23','m','----','----','----','----',NULL,'11trap9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4289',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17620597,'MARIANGEL',NULL,'ESCALONA','ALVAREZ','Venezolano','1975-09-24','m','----','----','----','----',NULL,'4raise22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4290',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19883835,'NELMALY','MACARENA,','PEREZ','HERNANDEZ','Venezolano','1975-09-25','m','----','----','----','----',NULL,'9cocoa15','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4291',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19104562,'KEYLIN','DESSIRE','MARQUEZ','GIMENEZ','Venezolano','1975-09-26','m','----','----','----','----',NULL,'1trews91','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4292',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15731431,'MIGDALIA','YACKELINE','ORO','PERDOMO','Venezolano','1975-09-27','m','----','----','----','----',NULL,'8fret72','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4293',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12247162,'YADIRA','JOSEFINA,','ESCALONA','RIVERO','Venezolano','1975-09-28','m','----','----','----','----',NULL,'15fours20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4294',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18950584,'YAISYR','WILMARY,','ARRIECHE','APOSTOL','Venezolano','1975-09-29','m','----','----','----','----',NULL,'8audio71','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4295',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16796662,'EUCARIS','PATRICIA','SUAREZ','SIVIRA','Venezolano','1975-09-30','m','----','----','----','----',NULL,'2worm99','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4296',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19433665,'WILLIAM','PASTOR','LOYO','LEON','Venezolano','1975-10-01','m','----','----','----','----',NULL,'7gored67','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4297',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11433908,'GEORGET','PASTORA,','GONZALEZ','GUTIERREZ','Venezolano','1975-10-02','m','----','----','----','----',NULL,'2mangy89','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4298',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12703271,'MARY','TRINI,','SANCHEZ','TORRES','Venezolano','1975-10-03','m','----','----','----','----',NULL,'1unfit93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4299',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19180802,'MAYRIM','LUISANA','PIÑA','ROJAS','Venezolano','1975-10-05','m','----','----','----','----',NULL,'8flask58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4300',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17034918,'DANIELA','COROMOTO','ORELLANA','NAGERA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'11paras8','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4301',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12851859,'LISSETH','COROMOTO,','TORBELLO','MEDINA','Venezolano','1975-10-07','m','----','----','----','----',NULL,'18cums13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4302',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17574735,'YOHANNY','JOSEFINA','HERNANDEZ','LLAMOZAS','Venezolano','1975-10-08','m','----','----','----','----',NULL,'8artsy99','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4303',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10125346,'MIRIAM,','SAN','JUA','PEREZ','Venezolano','1975-10-09','m','----','----','----','----',NULL,'8suds34','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4304',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13881504,'IGORD','JOSE,','ARTEAGA',NULL,'Venezolano','1975-10-10','m','----','----','----','----',NULL,'16retry90','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4305',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15667823,'BENJAMIN','DE JESUS','ROMERO','MORALES','Venezolano','1975-10-11','m','----','----','----','----',NULL,'14tribe48','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3395',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10218815,'DAMELIS','JOSEFINA','MUJICA','UGAS','Venezolano','1975-10-12','m','----','----','----','----',NULL,'8mealy17','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4306',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12020077,'MARIA','EUGENIA','PACHECO','SANCHEZ','Venezolano','1975-10-13','m','----','----','----','----',NULL,'8imps7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4307',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18785613,'YANETZY','DEL ROSARIO','MONTILLA','VALERA','Venezolano','1975-10-14','m','----','----','----','----',NULL,'12mare67','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4308',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18862069,'RAQUEL','SARAHI,','PEREZ','JIMENEZ','Venezolano','1975-10-15','m','----','----','----','----',NULL,'18cove47','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4309',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11596385,'NOIDAILYCHT','DE LOS ANGELES','CRESPO','MONTERO','Venezolano','1975-10-16','m','----','----','----','----',NULL,'15bilge4','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4310',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19887653,'MARILYN','PASTORA,','GODOY','LINARES','Venezolano','1975-10-17','m','----','----','----','----',NULL,'5aria13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4311',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18525603,'ALEXANDRA','MARIA','CASTILLO','ARRIECHE','Venezolano','1975-10-18','m','----','----','----','----',NULL,'19tends34','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4312',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9545461,'NORMA','ELOISA','RAMIREZ',NULL,'Venezolano','1975-10-19','m','----','----','----','----',NULL,'18detox3','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4313',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7358202,'YRIS','COROMOTO,','LOPEZ','DE VALERA','Venezolano','1975-10-20','m','----','----','----','----',NULL,'1inane43','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4314',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18376731,'KATIUSKA','DEL VALLE','BRICEÑO','ESCALONA','Venezolano','1975-10-21','m','----','----','----','----',NULL,'8imply91','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4315',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10770737,'ELVIA','EVELYN','APONTE','SEQUERA','Venezolano','1975-10-22','m','----','----','----','----',NULL,'7liven41','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4316',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12025217,'YOLEIDA','JOSEFINA','MORILLO','CORDERO','Venezolano','1975-10-23','m','----','----','----','----',NULL,'4silly41','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4317',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(5939079,'ALVIN','JOSÉ','MARCHÁN',NULL,'Venezolano','1975-09-10','m','----','0416-5598303','----','----',NULL,'0unify71','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4202',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17017440,'FREDDY','JESUS,','ANGULO','LOZADA','Venezolano','1975-09-10','m','----','0426-7071677','----','----',NULL,'16dick85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4203',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15673908,'YUNANCY','RAMONA','OCANTO',NULL,'Venezolano','1975-09-10','m','----','0252-4440829','----','----',NULL,'18shots63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4204',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16442255,'EDUARD','RAMON','CONTRERAS','BARRIOS','Venezolano','1975-09-10','m','----','0252-4440829','----','----',NULL,'12homy53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4205',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11702005,'FRANCISCO','ANTONIO','RODRIGUEZ','OCANTO','Venezolano','1975-09-10','m','----','0414-3733987','----','----',NULL,'11whiz96','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4206',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16441877,'MIRTHA','ZOLEIDA','MARTINEZ','ARROYO','Venezolano','1975-09-10','m','----','0416-7549868','----','----',NULL,'5fishy28','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4207',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14003931,'CARLOS','ALONSO','ALMAO','LOZADA','Venezolano','1975-09-10','m','----','0426-7554301','----','----',NULL,'20devil13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4208',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12691783,'SARA','DE LOS ANGELES','DIAZ','MELENDEZ','Venezolano','1975-09-10','m','----','0416-3852648','----','----',NULL,'3laced26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4209',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16441139,'OSWALDO','ANTONIO','PIÑA','PEREZ','Venezolano','1975-09-10','m','----','0416-9378518','----','----',NULL,'8suds63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4210',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13179847,'MISAEL','JOSE','PIÑA','PADILLA','Venezolano','1975-09-10','m','----','0416-6523037','----','----',NULL,'8tabby96','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4211',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12691764,'NAY','ENRIQUE','ECHETO','JALLER','Venezolano','1975-09-11','m','----','0414-0719554','----','----',NULL,'0acme91','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4212',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11702411,'PEDRO','DOMINGO','CORDERO','ROJAS','Venezolano','1975-09-12','m','----','0426-1596516','----','----',NULL,'3motto18','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4213',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11695444,'ANDHERSON','PASTOR','ALVAREZ','NIEVES','Venezolano','1975-09-13','m','----','0426-3567040','----','----',NULL,'0atlas58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4214',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17342621,'YUBISAY','COROMOTO','ALMAO','DE CORONEL','Venezolano','1975-09-14','m','----','0416-1528167','----','----',NULL,'4hemp94','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4215',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15263086,'ELIMAR','GREGORIA','ARROYO','QUERALES','Venezolano','1975-09-16','m','----','0416-1225190','----','----',NULL,'20overs34','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4216',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13520265,'FRANCIS','MARBELIA','FALCON','HEREDIA','Venezolano','1975-09-17','m','----','0426-4035076','----','----',NULL,'17eves26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4217',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(5931325,'RAMON','GERARDO','GUTIERREZ',NULL,'Venezolano','1975-09-18','m','----','0416-1271589','----','----',NULL,'19fudge7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4218',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13777224,'DANIS','LUCIA','LEGETT','COLOMBO','Venezolano','1975-09-19','m','----','0416-5166844','----','----',NULL,'13spas58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4219',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11698039,'YANILETH','DEL CARMEN','TIMAURE','CARRASQUERO','Venezolano','1975-09-20','m','----','0414-5048828','----','----',NULL,'17jazz50','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4220',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20250292,'ANGELA','MARIANIS','NOGUERA','VASQUEZ','Venezolano','1975-09-21','m','----','0426-2084479','----','----',NULL,'20bends28','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4221',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16769647,'ELIZABETH','CAROLINA','SUAREZ','MENDOZA','Venezolano','1975-09-22','m','----','0426-7593250','----','----',NULL,'0ache29','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4222',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13345587,'MARIO','RAFAEL,','QUINTERO','CARRASCO','Venezolano','1975-09-23','m','----','----','----','----',NULL,'10optic2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4223',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19149142,'CARMEN','--','ALVAREZ','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0volt4','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4232',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13527711,'MARLING','--','BRITO','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'11indie29','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4233',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20236031,'YEIBER','--','FERNANDEZ','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2gamma36','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4234',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14030379,'CARLOS','--','FIGUEROA','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9paces10','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4235',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(4412863,'OSCAR','--','GUEDEZ','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9guilt48','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4236',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19105041,'PEDRO','--','MURO','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15coops58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4237',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20235481,'LEONARDO','--','PEREZ','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'12stein44','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4238',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19164760,'OSCAR','--','PEREZ','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6broil93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4239',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20321339,'IRENE','--','PINEDA','--','Venezolano','1975-09-11','m','----','----','----','----',NULL,'15pally69','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4240',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(5916859,'GLORIA','--','RUIZ','--','Venezolano','1975-09-13','m','----','----','----','----',NULL,'3coon4','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4241',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13543069,'hembert','antonio','sanchez','suarez','V','1977-09-10','m','calle 4 entre 5 y 6 la playa de santa isabel casa numero cuatro(4) # 35','02514433802','02514433802','hsanchez_10@live.com',NULL,'10park28','s',66,12,410,140,NULL,NULL,NULL,NULL,'4242',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16001401,'CEINA','--','VILLALONGA','--','Venezolano','1975-09-22','m','----','----','----','----',NULL,'8trail15','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4243',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9613287,'PEREZ','--','ISBELYS','--','Venezolano','1975-09-27','m','----','----','----','----',NULL,'17shat65','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4244',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19551449,'Daniela','Carolina','Diaz','Briceño','Venezolano','1975-09-10','m','----','----','----','----',NULL,'12bide78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4010',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16233288,'Doris','Hortencia','León','Pantaleón','Venezolano','1975-09-10','m','----','----','----','----',NULL,'7beard51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2959',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17328491,'Leana','Gabriela','Salcedo','Aular','Venezolano','1975-09-10','m','----','----','----','----',NULL,'19imply35','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4011',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15866851,'Victor','Antonio','Alvarado','Oropeza','Venezolano','1975-09-10','m','----','----','----','----',NULL,'7wacky19','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4012',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16950558,'Rosa','Angela','Salazar','Viveros','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4chili30','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4013',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19348447,'Jesús',NULL,'Tobozo',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'14pens49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3263',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19887839,'Jessica',NULL,'Colmenares',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'7front62','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3254',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20349627,'Yulimar','Beatriz','Chambuco','Freitez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'16proof1','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4014',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17037277,'Desiree','Daniela','Sosa','Linares','Venezolano','1975-09-10','m','----','----','----','----',NULL,'3regal90','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4016',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18733429,'German','José','Azuaje',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'10tower74','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4017',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16739325,'José','de Jesus','Franco','Briceño','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5anew7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4018',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13645982,'María','Teresa','Sivira',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'11conch36','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4019',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13637449,'Edwin','Alexnader','Antiche','Garzón','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6pane80','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4020',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16402894,'Dixon',NULL,'Romero',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'7matzo37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4021',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14797002,'Omar',NULL,'Lozada',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'8outre76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3297',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15961277,'Jesus','Alberto','Gonzalez','Castillo','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8colon97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4022',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10844155,'Vigadalina',NULL,'Querales',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'17matey11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4023',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12851340,'BRONNY','.','RODRIGUEZ','.','Venezolano','1970-09-01','m','.','.','.','-@j.com',NULL,'8busk50','s',66,12,410,140,NULL,1,'-',NULL,'4245',1,1,12,85,1,44,2,'2014-10-24',1,'NUEVO INGRESO 2014-3'),(19687592,'JOSE','.','LUCENA','.','Venezolano','1970-09-01','m','.','.','.','-@j.com',NULL,'17apron19','s',66,12,410,140,NULL,1,'-',NULL,'4246',1,1,12,85,1,44,2,'2014-10-24',1,'NUEVO INGRESO 2014-3'),(19240681,'ENRIQUE','.','MENDOZA','.','Venezolano','1970-09-01','m','-','.','.','-@j.com',NULL,'4inure50','s',66,12,410,140,NULL,1,'-',NULL,'4247',1,1,12,85,1,44,2,'2014-10-24',1,'NUEVO INGRESO 2014-3'),(19113604,'MARÍA','JOSÉ','MENDOZA','F.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15optic6','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4446',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18689695,'JOSE','GREGORIO','FALCÓN',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'19study20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4447',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17355159,'MIRIAM','DEL R.','MANZANO','T.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'7rerun84','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4448',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9626236,'CARLOS',NULL,'HERNÁNDEZ','ABBATE','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2preen69','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4449',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10961661,'YOLKA','ADELINA','MARTÍNEZ','BETANCOURT','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13lands12','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4450',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15599590,'TOMÁS','ANTONIO','COLMENARES','P.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2fief67','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4451',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18861944,'MAYRA','ALEJANDRA','SOTO','M.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'12brake96','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4452',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10955442,'YENNYS','DEL C.','LINARES','R.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17conch56','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4453',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7981943,'ISMAEL',NULL,'AGUILAR',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'10preys42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4454',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19344865,'ZULAY','COROMOTO','SEGOVIA','B.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4ditzy9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4455',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16737695,'YEMARY',NULL,'SUÁREZ','ORELLANA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13droop11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4456',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14228102,'O.LOURDES',NULL,'ZAMBRANO','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5irony18','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4457',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17355205,'KEILA','ANDREÍNA','TORRES','ROA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4minim62','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4458',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15776361,'ENDERSON','RAMÓN','URBINA','SÁNCHEZ','Venezolano','1975-09-11','m','----','----','----','----',NULL,'13shake52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4459',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17013254,'MARÍA','REBECA','AZUAJE','RODRIGUEZ','Venezolano','1975-09-12','m','----','----','----','----',NULL,'6occur75','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4460',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12593859,'RAMÓN','AMILKAR','ESCOBAR','E.','Venezolano','1975-09-14','m','----','----','----','----',NULL,'10womb13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4248',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16736709,'ARACELIS','ADRIANA','QUEVEDO','SUÁREZ','Venezolano','1975-09-15','m','----','----','----','----',NULL,'7conk26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4461',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18923466,'YULIMAR','KATIUSKA','QUEVEDO','C.','Venezolano','1975-09-16','m','----','----','----','----',NULL,'4rerun44','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4462',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17354536,'YOLBERT','A.','RODRÍGUEZ','SILVA','Venezolano','1975-09-19','m','----','----','----','----',NULL,'0noun4','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4463',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13678769,'LUZ','MARÍA','P.','REINOSO','Venezolano','1975-09-20','m','----','----','----','----',NULL,'10prods86','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4464',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17873146,'MARÍA','MILAGRO','MUJICA','C.','Venezolano','1975-09-21','m','----','----','----','----',NULL,'4tinny84','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4465',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14014768,'MARÍA','GABRIELA','ESCALONA','NORIEGA','Venezolano','1975-09-23','m','----','----','----','----',NULL,'12dark76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4466',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16059242,'DANYELIS','COROMOTO','RODRÍGUEZ',NULL,'Venezolano','1975-09-24','m','----','----','----','----',NULL,'2stops71','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4467',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12594390,'ELYS',NULL,'FREITES',NULL,'Venezolano','1975-09-28','m','----','----','----','----',NULL,'11scion47','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4468',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10960784,'NORBERTO','JOSÉ','FREITEZ',NULL,'Venezolano','1975-09-30','m','----','----','----','----',NULL,'2untie51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4249',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18812763,'F.','MARÍA','FLORES','RODRÍGUEZ','Venezolano','1975-10-01','m','----','----','----','----',NULL,'12until93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4318',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11586098,'MARIFEL','PASTORA','ALVAREZ',NULL,'Venezolano','1975-10-02','m','----','----','----','----',NULL,'0dozy32','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4469',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16060511,'ADALÍ','ZULAY','FREITEZ','LEÓN','Venezolano','1975-10-06','m','----','----','----','----',NULL,'3bigot98','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4470',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9621273,'MARÍA','ISABEL','DE LA CRUZ',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'19exile84','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4471',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17132975,'BEATRIZ','ADRIANA','VARGAS',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'0humid14','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4472',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19640287,'ESDRAS',NULL,'AGUERO',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'1roman16','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4473',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16239343,'GREISY','GREGORI','PÉREZ','A.','Venezolano','1975-10-06','m','----','----','----','----',NULL,'0lured21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4474',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11582442,'RAFAEL','JOAQUÍN','CEBALLOS','A.','Venezolano','1975-10-06','m','----','----','----','----',NULL,'4glass93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4475',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17134653,'YAIRA',NULL,'MENDOZA',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'8ions10','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4476',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17171785,'EDDY','L.','SÁNCHEZ',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'20meted98','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4477',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13880464,'CARLOS','LUIS','PIÑA',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'3imps86','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4250',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19263638,'Danilo','-','Perozo','-','-','1965-12-12','m','-','-','-','a@gmail.com',NULL,'0tempt75','s',66,12,410,140,NULL,1,'-',NULL,'4015',1,1,15,85,1,44,2,'2014-10-29',1,'NUEVO INGRESO 2014-3'),(9628860,'Marbella',NULL,'Camacho',NULL,'Venezolana','1990-12-12','f','1',NULL,NULL,'marbella@hotmail.com',NULL,'0letup73','s',66,12,410,140,NULL,1,NULL,NULL,'4478',1,1,7,85,1,44,2,'2014-11-06',1,'NUEVO INGRESO 2014-3'),(10960915,'Livia',NULL,'López',NULL,'Venezolana','1990-12-12','f','1',NULL,NULL,'livia@hotmail.com',NULL,'0satyr3','s',66,12,410,140,NULL,1,NULL,NULL,'4479',1,1,7,85,1,44,2,'2014-11-06',1,'NUEVO INGRESO 2014-3'),(14229112,'Omaira',NULL,'Fernandez',NULL,'Venezolana','1990-12-12','f','1',NULL,NULL,'omaira@hotmail.com',NULL,'9girl70','s',66,12,410,140,NULL,1,NULL,NULL,'4480',1,1,7,85,1,44,2,'2014-11-06',1,'NUEVO INGRESO 2014-3'),(16866846,'Joselyn',NULL,'Fuentes',NULL,'Venezolana','1990-12-12','f','1','----','-----','fuentes@hotmail.com',NULL,'17emcee86','s',66,12,410,140,NULL,1,'----',NULL,'4481',1,1,7,85,1,44,2,'2014-11-06',1,'NUEVO INGRESO 2014-3'),(18998785,'YONERKYS',NULL,'GARCIA',NULL,'VENEZOLANA','1990-12-12','f','1',NULL,NULL,'garcia@hotmail.com',NULL,'4fours54','s',66,NULL,NULL,NULL,NULL,1,NULL,NULL,'4482',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10844063,'YULIBETH','PATRICIA','AGUIRRE','SUAREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'14pulls59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4360',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11790905,'CARMEN','ELISA','VARELA','MARTINEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'16bugle49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4361',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12023971,'NEILA',NULL,'PASTRAN',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'2lame13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4362',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12111682,'IVETTE','CAROLINA','MALDONADO','GIMENEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17krill22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4363',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12642124,'YLSA','EUNICE','RIVAS','ZAMBRANO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9mends82','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4364',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13181143,'MARIBEL','DEL CARMEN','PEREIRA','HERRERA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15hurl8','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4365',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13268798,'LEXAURA','MERCEDES','PERNIA','ROJAS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4ensue52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4105',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13644815,'JOHAN','JOSE','VISCAYA','PEÑUELA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5typo59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4106',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13775627,'SOL','DEL VALLE','FERNANDEZ','DE TERAN','Venezolano','1975-09-10','m','----','----','----','----',NULL,'1hots7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4366',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14031034,'NUBRASKA','MARGARET','FREITEZ','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9rams6','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4107',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14094237,'DAYANA','FRANCISCA','PEREZ','AGÜERO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13bulks94','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4367',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14176662,'ANGELICA','COROMOTO','MONTILLA','PARRA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5mosey49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4368',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15342184,'ALEJANDRA','KATHERINE','ORTEGA','ACUÑA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8puce1','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4369',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16641763,'ANYELA','MARGARITA','OVIEDO','COLMENAREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5whisk51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4370',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17011892,'BEISI','SOFIA','ALVARADO','VARGAS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2ions49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4108',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17228765,'NUBRATLIS','MARYERLIN','FREITEZ','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6chaps40','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4109',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18059299,'JOHANNA','ROSALI','HURTADO','COHEN','Venezolano','1975-09-11','m','----','----','----','----',NULL,'8wrap81','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4110',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18332603,'ROSANA','KARINA','MONTILLA','MENDOZA','Venezolano','1975-09-12','m','----','----','----','----',NULL,'0crone81','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4371',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18526257,'EDGARDO','JOSE','TORRELAS','SUAREZ','Venezolano','1975-09-13','m','----','----','----','----',NULL,'16bred50','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4372',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18735638,'YURIELISS','KARINA','CARMONA','MENDOZA','Venezolano','1975-09-14','m','----','----','----','----',NULL,'5rejig49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4373',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18737154,'RILEDSY','CARINA','ROJAS','SALAS','Venezolano','1975-09-15','m','----','----','----','----',NULL,'12today68','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4111',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18997722,'FABIOLA','ANDREINA','COLMENAREZ','LANZILLOTTI','Venezolano','1975-09-17','m','----','----','----','----',NULL,'17fresh54','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4374',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19433629,'JHOANA','PATRICIA','CASTILLO','RAMIREZ','Venezolano','1975-09-18','m','----','----','----','----',NULL,'12unmet59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4375',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20010798,'DEYDILMAR','DIANA','RIERA','MENDOZA','Venezolano','1975-09-19','m','----','----','----','----',NULL,'16cover8','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4112',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(6209775,'JUANA','BAUTISTA','TOVAR','PEROZO','Venezolano','1975-09-20','m','----','----','----','----',NULL,'17parch58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4376',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7406775,'CARMEN','ALEXIS','PEREZ','FREITEZ','Venezolano','1975-09-21','m','----','----','----','----',NULL,'4noisy72','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4377',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9607482,'CARMEN','TERESA','ECHEVERRIA','UZCATEGUI','Venezolano','1975-09-22','m','----','----','----','----',NULL,'14refit27','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4378',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10128750,'RUBELIA','INMACULADA','GARCIA','QUERO','Venezolano','1975-09-23','m','----','----','----','----',NULL,'17cony75','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4379',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11262080,'ISBELIS','YARITZA','NAVAS',NULL,'Venezolano','1975-09-24','m','----','----','----','----',NULL,'16avail19','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4380',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11786101,'MARIA','DELMAR','ROA','LOBO','Venezolano','1975-09-25','m','----','----','----','----',NULL,'5conch60','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4381',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11881914,'DAMELYS','MARGOT','DURAN','PEÑA','Venezolano','1975-09-26','m','----','----','----','----',NULL,'2ward32','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4382',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12243619,'OLAINA','PASTORA','PEREZ',NULL,'Venezolano','1975-09-27','m','----','----','----','----',NULL,'3wings46','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4113',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12703231,'ANTUANE','JOSEFI','SANCHEZ','LEON','Venezolano','1975-09-28','m','----','----','----','----',NULL,'0tubas20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4383',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12851937,'HUGO','LUIS','RIVERO','PALACIO','Venezolano','1975-09-29','m','----','----','----','----',NULL,'8rhino9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4384',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12933190,'MARIA','EUGENIA','HEREDIA','CASTILLO','Venezolano','1975-09-30','m','----','----','----','----',NULL,'17speck53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4114',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12933817,'MAUDELINDA','MARILIN','PEROZO','GARCIA','Venezolano','1975-10-01','m','----','----','----','----',NULL,'5extra98','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4385',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12934091,'YOLENNYS','DEL CARMEN','PEÑA','MONTERO','Venezolano','1975-10-02','m','----','----','----','----',NULL,'6reran6','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4386',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12950285,'MERANYER','BEATRIZ','MARTINEZ','RAMOS','Venezolano','1975-10-03','m','----','----','----','----',NULL,'1inane2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4387',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14293082,'JOYVEER','SHIRLEY','MUJICA','TORRES','Venezolano','1975-10-06','m','----','----','----','----',NULL,'13stub9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4388',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15177829,'GLORINAR','YULIBETH','PEREZ','ESCALONA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'7furl20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4389',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15777025,'YSELY','YAMILETH','OJEDA','RODRIGUEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'11hides39','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4390',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16278400,'ANNILENNY','ARROYO','VIVAS',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'4sowed85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4391',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16343395,'LAURA','ANGELICA','LOZANO','LUCENA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'18cissy16','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4392',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16868816,'YANILA','GISELA','DIAZ','GONZALEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'7specs89','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4393',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17308395,'ROSA','MARIA','MENDEZ','CARDENAS','Venezolano','1975-10-06','m','----','----','----','----',NULL,'10emir44','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4394',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17873492,'NORALIS','JOSEFINA','ESCALONA','TOVAR','Venezolano','1975-10-06','m','----','----','----','----',NULL,'13works2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4395',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18104179,'MARIA','JOSEFA','BRIZUELA','GIMENEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'16ovoid47','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4396',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18863826,'LILIMAR','MARIELVIS','MENDOZA','GARCIA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'3eons74','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4397',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19424765,'LILIANA','ANABEL','LUCENA','OLIVO','Venezolano','1975-10-06','m','----','----','----','----',NULL,'8muzzy27','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4398',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10962119,'NAUDY','JOSÉ','GIMÉNEZ','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15cosh55','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4115',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15427549,'KEIBER','YALIDES','RODRÍGUEZ','DAZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9stash97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4116',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20471346,'MARIA','DE LOS ANGELES','AGUILAR','DELGADO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2tines24','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4117',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9570475,'OSWALDO','DE JESUS','JIMENEZ',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'19mist54','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4118',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15667153,'YOLIMAR',NULL,'SUÁREZ','ALEJOS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'10into11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4119',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18811799,'LISSETH','CAROLINA','CASTILLO','MEDINA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'19urban48','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4120',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7463611,'MARINA','DEL CARMEN','GUEVARA','DE LARA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'1lobe24','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4121',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16957737,'MARÍA','CAROLINA','PÉREZ','PÉREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0brook26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4122',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17874285,'FRANCYS','ROSANNY','GUTIERREZ','TORREALBA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0caved60','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4123',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20323088,'YOHANNY','CAROLINA','GONZALEZ','GUEVARA','Venezolano','1975-09-11','m','----','----','----','----',NULL,'11tolls100','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4124',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15273898,'CARMEN','ROSA','CUBAS','REA','Venezolano','1975-09-14','m','----','----','----','----',NULL,'17ennui76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4125',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16736148,'AMARILIS','CAROLINA','PÉREZ','GUEVARA','Venezolano','1975-09-16','m','----','----','----','----',NULL,'18inked22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4126',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16737691,'RAFAEL','MOREN','ECHEGARAY','JIMENEZ','Venezolano','1975-09-17','m','----','----','----','----',NULL,'20face5','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4127',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17101440,'LILIANA',NULL,'COLORADO','VALENZUELA','Venezolano','1975-09-18','m','----','----','----','----',NULL,'19yoga12','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4128',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17727028,'YULIANA','PASTORA','TORRES','VASQUEZ','Venezolano','1975-09-19','m','----','----','----','----',NULL,'15opium33','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4129',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12370822,'ZULMA','DEL VALLE','MUJICA','JIMENEZ','Venezolano','1975-09-21','m','----','----','----','----',NULL,'14cast59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4130',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18137054,'YASMIN','YELITZA','SUÁREZ','PÉREZ','Venezolano','1975-09-23','m','----','----','----','----',NULL,'6newsy57','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4131',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20321085,'ANABEL','CRISTINA','JIMENEZ','LINAREZ','Venezolano','1975-09-24','m','----','----','----','----',NULL,'7revs53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4132',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12370410,'OSMIR','SABRINA','LARA','MUJICA','Venezolano','1975-09-25','m','----','----','----','----',NULL,'15dryad41','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4133',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16736013,'MIRIAN','ROSA','MENDOZA','MENDOZA','Venezolano','1975-09-27','m','----','----','----','----',NULL,'1movie83','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4399',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17639593,'NAYLIANA','MARIA','CASTAÑEDA','CHAVEZ','Venezolano','1975-09-28','m','----','----','----','----',NULL,'13bills47','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4134',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7454150,'LESLIE','MARICELA','TOVAR','MENDOZA','Venezolano','1975-09-30','m','----','----','----','----',NULL,'20feta85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4135',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7457775,'CARLOS','ALBERTO','EREU','GONZALEZ','Venezolano','1975-10-01','m','----','----','----','----',NULL,'2nears39','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4136',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10129680,'DORIS','LUCIA','YUSTIZ','HERNANDEZ','Venezolano','1975-10-02','m','----','----','----','----',NULL,'5sure97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4137',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14810360,'MILEXA','YAQUELINE','RODRÍGUEZ','RODRÍGUEZ','Venezolano','1975-10-04','m','----','----','----','----',NULL,'11gnats75','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4138',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17874226,'YUDESY','ESTER','PÉREZ','JIMÉNEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'12males49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4139',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10126214,'IRENE','NORAIMA','JIMÉNEZ','SILVA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'11aware76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4140',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10956699,'JUANA','JOSEFINA','PÉREZ','DÍAZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'17emir62','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4141',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11584324,'ANA','MARIA','LOVERA',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'20brood78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4142',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13880971,'HEIDY','MARIA','MATHEUS','ALBURJAS','Venezolano','1975-10-06','m','----','----','----','----',NULL,'5arbor52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4143',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17101350,'LEIDIS','COROMOTO','COLMENAREZ','ESCOBAR','Venezolano','1975-10-06','m','----','----','----','----',NULL,'13treks58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4144',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11588908,'CRISALIDA','MERCEDES','LOYO','ARMAO','Venezolano','1975-10-06','m','----','----','----','----',NULL,'6stark76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4145',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12592567,'FRANCY','GREGORIA','PERALTA','MENDOZA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'16sloop85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4146',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12944578,'MARÍA','ELIZABETH','CARUCÍ','GONZÁLEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'1exec76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4147',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17132254,'SARAY','COROMOTO','ESCALONA',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'10sweet11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4148',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7988371,'MARÍA','DEL CARMEN','GARCÍA','PÉREZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'15ideas19','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4149',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9572242,'MIGDALIA','JOSEFINA','ALVARADO','MARTINEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'1untie49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4150',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13867854,'EUSEBIA','DEL CARMEN','PEREZ','ALVARADO','Venezolano','1975-10-06','m','----','----','----','----',NULL,'20bubs67','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4151',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16957364,'YUCELBY','JOSE','ALVARADO','URDANETA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'6envoy12','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4152',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17132374,'DORISMAR','DEL VALLE','GIMENEZ','MACHADO','Venezolano','1975-10-06','m','----','----','----','----',NULL,'1revel55','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4153',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18135651,'JOSÉ','LUIS','RODRÍGUEZ','FLORES','Venezolano','1975-10-06','m','----','----','----','----',NULL,'1stows2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4154',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(4730804,'ANGELA','RENATA','SOTELDO','RAMOS','Venezolano','1975-10-06','m','----','----','----','----',NULL,'7acme83','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4155',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17132602,'YURI','SOPHIA','RODRIGUEZ','ORTIZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'2strop11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4156',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16239156,'YOSMAR','CAROLINA','BARRIOS','PÉREZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'20mousy20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4157',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17620126,'FATIMA','CAROLINA','RODRIGUES','LOPES','Venezolano','1975-10-06','m','----','----','----','----',NULL,'17para84','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4158',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19572182,'ERNILE','ANTONIO','JIMÉNEZ','DUIN','Venezolano','1975-10-06','m','----','----','----','----',NULL,'0fuzzy40','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4159',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13679889,'MARÍA','ELENA','FREITEZ','RODRÍGUEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'14fink3','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4160',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16736684,'JUAN','DARIEN','RODRÍGUEZ','PEREZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'15shots19','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4161',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13867086,'NEIDIMAR','LISET','LARA','TOVAR','Venezolano','1975-10-06','m','----','----','----','----',NULL,'9balls33','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4162',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15272453,'KARELYS','JOSE','LISCANO','PAEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'19split21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4163',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18135233,'BILLY','JOSE','LOPEZ','MOFFI','Venezolano','1975-10-06','m','----','----','----','----',NULL,'10adzes54','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4164',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(4586291,'LUIS','JOSÉ','PARADA',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'16avail61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3661',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(5932016,'PROVIDENCIA','JOSEFINA','PERNALETE','PARRA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0revs58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4025',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7114704,'MARÍA','TERESA','GONZALEZ','GONZALEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15scion26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4026',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7426000,'MILAGROS','YULEIMA','TORREALBA','MEDINA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2video11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4027',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12535199,'GLORIA','ALICIA','ATEHORTUA','DE ROJAS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'18heeds54','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4063',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13343330,'NORELYS','DEL ROSARIO','LOPEZ','SANCHEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15profs46','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4104',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13619416,'CARMEN','MARIA','CASTELLANOS','VASQUEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'16stiff42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4028',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13645684,'MARIA','ELIODINA','PEREZ','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15inane51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4029',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14175842,'MARIA','DUILIAN','ARICUCO','CARRILLO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17dandy76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4030',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14269828,'AUDRA','YAMIR','AMBROCIO','MEDINA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8chili76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4031',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14426833,'PEDRO','JESUS','PEROZO','CAMACARO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13sups12','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4032',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14482226,'ZULKALIN','COROMOTO','CHIRINOS','SANTELIZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2gulfs89','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4033',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14938209,'DENNYS','ALI','BECERRA','MERCHAN','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6hate42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4034',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15017436,'MARIA','ESPERANZA','BRACHO','OLLARVES','Venezolano','1975-09-10','m','----','----','----','----',NULL,'11strop78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4035',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15188746,'LUIS','GERARDO','MENDEZ','VALERO','Venezolano','1975-09-11','m','----','----','----','----',NULL,'15inept95','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4036',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15412830,'JOVANNY','RAMÓN','MARIN','SÁNCHEZ','Venezolano','1975-09-12','m','----','----','----','----',NULL,'20five63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4037',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15424216,'LEIDY','MARYULI','GUTIERREZ','RODRÍGUEZ','Venezolano','1975-09-13','m','----','----','----','----',NULL,'5stab3','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4038',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15448147,'YESSICA','SOLIMAR','OROPEZA','RODRÍGUEZ','Venezolano','1975-09-14','m','----','----','----','----',NULL,'15mold16','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4039',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15731129,'ROSA','VIRGINIA','PARRAGA','MENDOZA','Venezolano','1975-09-15','m','----','----','----','----',NULL,'11ensue53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4040',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16592807,'LUIS','ALBERTO','PARADA','SIBRIAN','Venezolano','1975-09-16','m','----','----','----','----',NULL,'10wart61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4041',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17012556,'ARMANDO','LUIS','GARCIA','GOMEZ','Venezolano','1975-09-17','m','----','----','----','----',NULL,'2ecru77','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4042',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17019089,'MARY','CHIQUINQUIRA','SISIRUCA','GOMEZ','Venezolano','1975-09-18','m','----','----','----','----',NULL,'13foul59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4043',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17227673,'LINOSKY','RAFBEK','VARGAS','GONZALES','Venezolano','1975-09-19','m','----','----','----','----',NULL,'19break45','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4044',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17465040,'LADY','DIANA','PERNALETE','ANAYA','Venezolano','1975-09-20','m','----','----','----','----',NULL,'13telly99','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4045',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17572203,'NATHALÍ','CRISTINA','SUÁREZ','GARCIA','Venezolano','1975-09-21','m','----','----','----','----',NULL,'12nice87','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4046',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18493151,'JENNITSSE','DEL CARMEN','CASTILLO','VARGAS','Venezolano','1975-09-22','m','----','----','----','----',NULL,'16foals94','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4047',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18669974,'DIANA','DEL VALLE','CASTILLO','MARQUEZ','Venezolano','1975-09-23','m','----','----','----','-@j.com',NULL,'17prude18','s',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,'4266',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18812518,'TAIANA','PASTORA','DAZA','TORREALBA','Venezolano','1975-09-25','m','----','----','----','----',NULL,'13coupe9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4049',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18861646,'ELISAUL','JOSÉ','MÉNDEZ','VARGAS','Venezolano','1975-09-26','m','----','----','----','----',NULL,'12inked31','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4050',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18871021,'DANELYS','ELIENNIS','ROMANO','TORREALBA','Venezolano','1975-09-27','m','----','----','----','----',NULL,'16decor88','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4051',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18897140,'MARIANGEL','NOHEMI','JAYARO','RIVERO','Venezolano','1975-09-28','m','----','----','----','----',NULL,'13outer94','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4052',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19264357,'YACSELIS','ENEDINA','BELLO','MEJIAS','Venezolano','1975-09-29','m','----','----','----','----',NULL,'12masts6','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4053',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19265348,'ANGGIE','MICHELLE','MORA','COLMENAREZ','Venezolano','1975-09-30','m','----','----','----','----',NULL,'4stank22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4054',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19348727,'CECILIA','MARIA','GARCIA','CRISOSTOMO','Venezolano','1975-10-01','m','----','----','----','----',NULL,'7dhoti2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4055',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19430791,'AURISBELLA','LLOSEFINA','AGUILAR','MIGUILENA','Venezolano','1975-10-02','m','----','----','----','----',NULL,'18bacon30','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4056',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19779287,'MARIANNY','CAROLINA','GUÉDEZ','GIL','Venezolano','1975-10-03','m','----','----','----','----',NULL,'7waxy48','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4057',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20010171,'MARIA','DE LOS ANGELES','PEROZO','CAMACARO','Venezolano','1975-10-04','m','----','----','----','----',NULL,'19attic88','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4058',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20015868,'YOANGELIS','ANTONELLA','SEQUERA','FIGUEROA','Venezolano','1975-10-05','m','----','----','----','----',NULL,'6bloke84','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4059',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20469275,'KAREN','ELENA','PINEDA','SANCHEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'13marks22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4060',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20539128,'VIRGINIA','COROMOTO','MENDEZ','RODRIGUEZ','Venezolano','1975-10-06','m','----','----','----','----',NULL,'9cosy76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4061',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(23487093,'ROSA','ANGELA','VARGAS','ROMERO','Venezolano','1975-10-06','m','----','----','----','----',NULL,'17cells7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4062',1,1,17,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18737148,'RIDSER','CAROLINA','ROJAS','SALAS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'11grim21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3927',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17196559,'LIGIA','ELENA','SEIDEL','GIMENEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5chimp27','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3928',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15767360,'MARIA','JOSE','CORONEL','GUTIERREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9choc37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3929',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10854775,'ARACELIS','COROMOTO','REAÑEZ','COLMENAREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8tack78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3930',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19779205,'MILAGROS','COROMOTO','BENITEZ','HERNANDEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15extra9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3931',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13265586,'RHOSTY','YANETH','HEREDIA','AREVALO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'19incur85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3932',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16385669,'NORMEDIS','MARION','MORILLO','RAMOS','Venezolano','1975-09-10','m','----','----','----','----',NULL,'11depth69','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3933',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15264325,'ANA','MERCEDES','MATHEUS','LOPEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0magma14','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3934',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18785593,'JESSICA','YAILIN','PEREZ','MONTERO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'11cliff70','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3935',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17196360,'LEIDY','CAROLINA','HERNANDEZ','PEÑA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6proud78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3936',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16387660,'MAGDANUELY',NULL,'QUEVEDO','GARCIA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2inky2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3937',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7434990,'ANGELICA','DEL CARMEN','ARRIECHE','ZAVARCE','Venezolano','1975-09-10','m','----','----','----','----',NULL,'14sever95','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3938',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12698383,'YISMARY','LUCIA','FRIAS','ALVAREZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2recto64','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3939',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15997991,'DUBINAY','DE LOS ANGELES','SALON','LOYO','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13depot97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3940',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16402987,'IRIS','YANETH','MUJICA','VALERA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'1cube26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3941',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13556381,'YARITZA','BETSABETH','SEGOVIA','VALERO','Venezolano','1975-09-11','m','----','----','----','----',NULL,'14palls64','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4400',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17227752,'KIRA',NULL,'MORENO','CHIRINOS','Venezolano','1975-09-11','m','----','----','----','----',NULL,'16debar86','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3942',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15444561,'MARÍA','ANDREINA','FLORES','RODRÍGUEZ','Venezolano','1975-09-11','m','----','----','----','----',NULL,'9graph78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3424',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13264219,'RANFIS','RODOLFO','RAMOS','MENDEZ','Venezolano','1975-09-11','m','----','----','----','----',NULL,'16moss97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3943',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14093331,'GIAN','FRANCO','MARULLO','DURAN','Venezolano','1975-09-11','m','----','----','----','----',NULL,'20drake87','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3944',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15886212,'JECKSSON','JAVIER','TORRES','GARCÍA','Venezolano','1975-09-11','m','----','----','----','----',NULL,'2into80','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3945',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13408024,'DEIVI','EMILIO','BRICEÑO','SAAVEDRA','Venezolano','1975-09-11','m','----','----','----','----',NULL,'5forty52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3946',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18897019,'RAFAEL','ANTONIO','BENITEZ','INFANTE','Venezolano','1975-09-11','m','----','----','----','----',NULL,'2ribs67','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4401',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7360392,'CESAR','ANTONIO','MENDEZ','BARAZARTE','Venezolano','1975-09-11','m','----','----','----','----',NULL,'17coir78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3947',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17034012,'KARLA','PATRICIA','MENDOZA','CORDERO','Venezolano','1975-09-11','m','----','----','----','----',NULL,'18ditzy76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3948',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17506558,'DAYANA','KAROLINA','TORREALBA','RAMOS','Venezolano','1975-09-11','m','----','----','----','----',NULL,'13effed82','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3949',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7575191,'SAMUEL','EDUARDO','PARRA','BAEZ','Venezolano','1975-09-11','m','----','----','----','----',NULL,'3wound37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3950',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18334543,'JOSE','ANTONIO','HERNANDEZ',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'6pints22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3951',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18950634,'MANUEL','R.','PEREZ','CORDERO','Venezolano','1975-09-11','m','----','----','----','----',NULL,'4merit75','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3952',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16378341,'CARLOS',NULL,'VALE',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'18bags63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3863',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9627845,'NOEL','ARMANDO','RODRIGUEZ','CARRASCO','Venezolano','1975-09-11','m','----','----','----','----',NULL,'10thins45','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3953',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14825049,'SUSAN',NULL,'GIMENEZ',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'19caber61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3954',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20187514,'RAFAEL','EDUARDO','ROMERO','ARANGU','Venezolano','1975-09-11','m','----','----','----','----',NULL,'12deify36','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3955',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19166724,'MARCO','VINICIO','HERNÁNDEZ','RODRÍGUEZ','Venezolano','1975-09-11','m','----','----','----','----',NULL,'7canoe5','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3956',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16139114,'JESSICCA','CARMEN','PEREZ','DURAN','Venezolano','1975-09-11','m','----','----','----','----',NULL,'10homed20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3957',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19170398,'ELBA','DAMARYS','AZUAJE','VILLEGAS','Venezolano','1975-09-11','m','----','----','----','----',NULL,'5nouns73','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3958',1,1,21,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14333319,'Carlos','Enrique','Piña',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'8cloud42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3900',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13529582,'Americo','Antonio','Delfines','Castañeda','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2cony42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3901',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18250384,'Nancy','Gregoria','Barazarte','Torres','Venezolano','1975-09-10','m','----','----','----','----',NULL,'20iota34','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3902',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12243764,'Edgar','Mariano','Parra','Guaido','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17adobe73','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3903',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12436116,'Danny','Enrique','Medina','Urquiola','Venezolano','1975-09-10','m','----','----','----','----',NULL,'18extra7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3904',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17451745,'Cristina','Elizabeth','Mendoza','Sandoval','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15ditch89','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3905',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16737430,'Johan','Manuel','Luna','Leon','Venezolano','1975-09-10','m','----','----','----','----',NULL,'20verb85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3906',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20924285,'Luisangelis','Beresther','Pereira','Arrieche','Venezolano','1975-09-10','m','----','----','----','----',NULL,'20lawn27','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3907',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15729430,'Hector','Ruben','Monasterios','Gimenez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17reps21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3908',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12594000,'Juan','Carlos','Perez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'15bells26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3909',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11882196,'Rafael','Antonio','Sira','Alvarez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8uncle16','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3910',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17852349,'Hernan','Alirio','Rodriguez','Torrealba','Venezolano','1975-09-10','m','----','----','----','----',NULL,'16traps52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3911',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12784341,'Yeside','Yajir','Yanez','Arroyo','Venezolano','1975-09-10','m','----','----','----','----',NULL,'18bland56','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3912',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16415357,'Jackson','Miguel','Escobar','Mujica','Venezolano','1975-09-10','m','----','----','----','----',NULL,'14picky45','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3913',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17992465,'Jesus','Octavio','Castillo','Duarte','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6labs78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3914',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11788585,'Maria','Yolaiza','Sanches','Escalona','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8prep39','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3915',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7450663,'Jesus','Maria','Anza','Pineda','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0enema83','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3916',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18689610,'Carmen','Sofia','Gonzalez','Perez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'18wedge61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3917',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17872717,'Daniel','Jose','Soto','Teran','Venezolano','1975-09-11','m','----','----','----','----',NULL,'15need81','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3918',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17638195,'Ana','Karina','Castillo','Torres','Venezolano','1975-09-11','m','----','----','----','----',NULL,'14digit96','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4165',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7354822,'Carmen','Lorenza','Melendez',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'12shame50','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3919',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10856121,'Lissette','Leticia','Torrealba','Mujica','Venezolano','1975-09-11','m','----','----','----','----',NULL,'1mugs88','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3920',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11426923,'Griselda','Beatriz','Perez','Ojeda','Venezolano','1975-09-11','m','----','----','----','----',NULL,'15geed61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3921',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9541406,'Mayanis','Morella','Rodriguez','Suarez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'11ingot23','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3922',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9620289,'Yelitza','Zenaida','Soto','Castellanos','Venezolano','1975-09-11','m','----','----','----','----',NULL,'20imply95','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3923',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9722918,'Andreina',NULL,'Alcantara','Hernandez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'6grace76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3925',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10842503,'Juan',NULL,'Lopez',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'11cony37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3926',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9542607,'Jose','Luis','Ochoa','Suarez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'12downs98','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4166',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18737048,'Crely','Virginia','Liscano','Silva','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2staff30','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4167',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19106913,'Jose','Miguel','Antequera','Mendoza','Venezolano','1975-09-10','m','----','----','----','----',NULL,'3works18','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4168',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(21104291,'Jean','Carlos','Lopez','Sanchez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13glam71','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4169',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19779401,'Frangy','Arlimar','Alvarado','Gonzalez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15kilos100','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4170',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11595284,'Giovanni','de Jesus','Saavedra','Rodriguez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'14dolt79','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4171',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20921675,'Antony','Javier','Leal','Gonzalez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2unify38','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4172',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15447181,'Rafael','Anguel','Liscano','Rivero','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17tarns73','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4402',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15424376,'Yorvin','Alexis','Torrealba','Escalona','Venezolano','1975-09-10','m','----','----','----','----',NULL,'14scion80','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4173',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15424377,'Jhomer','Alexander','Torrealba','Escalona','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4noted7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4174',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15307411,'Jairo','Jesus','Escalona','Jimenez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9apse93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4175',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18334272,'Gabriela','Isbeth','Suarez','Juarez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'1bugle63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4176',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9615124,'Jose','Gregorio','Arroyo','Barahona','Venezolano','1975-09-11','m','----','----','----','----',NULL,'5quads30','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4177',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19323842,'Rosa','Maria','Principal','Molina','Venezolano','1975-09-11','m','----','----','----','----',NULL,'9unmet28','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4403',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20351627,'Indhira','Lizz','Almao','Hernandez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'6cony3','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4178',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20189730,'Luis','Alberto','Jimenez','Sarmiento','Venezolano','1975-09-11','m','----','----','----','----',NULL,'11mate74','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4179',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17727291,'Isrrael','David','Valera','Tua','Venezolano','1975-09-11','m','----','----','----','----',NULL,'4pouts74','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4180',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17356811,'Maria','Ismely Fernanda','Escobar','Peña','Venezolano','1975-09-11','m','----','----','----','----',NULL,'5gift2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4181',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16404072,'Juan','Gillermo','Torres','Perez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'6group17','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4182',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13464332,'Edyer','Pastor','Barradas','Linarez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'20audio1','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4183',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15229973,'Devy','Jose','Canelon','Sanchez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'12false51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4184',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12882658,'ELYS',',','JIMENEZ',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'9melts87','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4088',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(19571417,'ROSMERY',',','GUEDEZ',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'10emcee96','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4089',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(18656580,'JESUS',',','TORRES',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'8thrum78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4090',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(16966055,'MAIRA',',','CARVAJAL',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'5flask59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4091',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(19423380,'ROCIO',',','RODRIGUEZ',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'20flask19','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4092',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(14558401,'ILIANA',',','GOMEZ',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'7mayor54','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4094',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(12702301,'ANA',',','DEL DUCA',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'2urban81','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4095',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(19883725,'DIRSO',',','BARRADAS',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'7coon43','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4096',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(17574564,'YOSMARY',',','OVIEDO',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'1apron21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4097',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(18105281,'CRUZ',',','RODRIGUEZ',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'15rids31','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4098',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(17783551,'YESIKA',',','LUCENA',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'6conks88','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4099',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(18301053,'ANTHONY',',','ASUAJE',',','Venezolano','0001-12-02','m','----','----','----','----',NULL,'18diets27','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4100',1,1,9,85,1,44,2,'0001-12-02',1,'NUEVO INGRESO 2014-3'),(20642182,'Merymark',NULL,'Peña','Timaure','Venezolano','1975-09-10','m','----','----','----','----',NULL,'10fogey64','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3883',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17858562,'Jenyred','Herminia','Medina','Adames','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0warms69','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3884',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10258486,'Berna','Coromoto','Araujo','Montilla','Venezolano','1975-09-10','m','----','----','----','----',NULL,'3imps82','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3885',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18525470,'Greiz','Elizabeth','Santaella','Duarte','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17ribs56','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3886',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20500946,'Diosmary','Josefina','Torres','Rodríguez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15syrup23','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3887',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18672860,'Greta','Milagro','Valbuena',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'4trees81','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3888',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18891130,'Elismar','Coromoto','Valera','Montilla','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0moor11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3889',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16794496,'Florelia','Alejandra','Daza','Piñero','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5hippy39','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3890',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17853466,'Zorenis','Yamileth','Oviedo','Franco','Venezolano','1975-09-10','m','----','----','----','----',NULL,'7cony15','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3891',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19551796,'Jhonnarlyn','José','Niazoa','Giménez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15away14','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3892',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17593040,'Ladys','Johana','Montenegro','Barreto','Venezolano','1975-09-10','m','----','----','----','----',NULL,'7dodgy15','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3894',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11084317,'Janine','Nguyen','González','Ortiz','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17choc9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3895',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11880371,'Ángela','Beatriz','Sivira','Rojas','Venezolano','1975-09-10','m','----','----','----','----',NULL,'1recur46','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3896',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18735275,'Darling','Yiselt','Torrealba','Álvarez','Venezolano','1975-09-11','m','----','----','----','----',NULL,'14imply12','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3897',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(83634400,'Nelly','Judith','Bohada','Jiménez','Venezolano','1975-09-13','m','----','----','----','----',NULL,'3horsy85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2942',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20667094,'Maria','lyLibe','Colmenares','Soto','Venezolano','1975-09-13','m','----','----','----','----',NULL,'12bebop83','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3898',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19818169,'Yuleidys','Milagros','Torrealba','Pérez','Venezolano','1975-09-13','m','----','----','----','----',NULL,'3racy1','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3899',1,1,22,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12725827,'María','de los Angeles','Piña','Petit','Venezolano','1975-09-10','m','----','0412-1744515','----','Petitmariap77@gmail.com',NULL,'20jazz61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4185',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13842562,'Mackensy','Carmen','Villegas','Bullones','Venezolano','1975-09-10','m','----','0416-5549755','----','mackensyv@hotmail.com',NULL,'14rend9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4186',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15918915,'Josdaly',NULL,'Querales','Goyo','Venezolano','1975-09-10','m','----','0426-9508329','----','josdalydesandoval@hotmail.com',NULL,'5straw5','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4187',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(22600738,'Emiro','Alfonzo','Colina','Medina','Venezolano','1975-09-10','m','----','0416-3693673','----','Emiroalf93@gmail.com',NULL,'10trend73','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4188',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(21157861,'Jennifer','Carolina','Moller','Salas','Venezolano','1975-09-10','m','----','0426-1537961','----','jennimoller@gmail.com',NULL,'9qualm53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4189',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14293847,'Carlos','Javier','Martínez','Arrieta','Venezolano','1975-09-10','m','----','0416-8569100','----','Carlosmartinezarrieta1998@hotmail.com',NULL,'9sand77','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4190',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13905485,'Eduardo','Antonio','Humbría','Moncada','Venezolano','1975-09-10','m','----','0424-5119955','----','eduardohumbri@hotmail.com',NULL,'8unmet42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4191',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13464520,'Eglee','Edelwis','Carruido','Tua','Venezolano','1975-09-10','m','----','0424-5145558','----','egleecarruido@hotmail.com',NULL,'20crew2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4192',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13267866,'Lilianyela','Ramona','Castillo','Amaro','Venezolano','1975-09-10','m','----','0426-5134652','----','lilianyelaramona@gmail.com',NULL,'8jogs83','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4193',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14160395,'Heylin','Marina','Mogollón','Pineda','Venezolano','1975-09-10','m','----','0416-1545297','----','heylfranco@yahoo.com',NULL,'10dicey93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4194',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16584285,'María','Antonieta','Gallardo','Silva','Venezolano','1975-09-10','m','----','0416-1546835','----','Mariagallardo2706@gmail.com',NULL,'10coon73','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4195',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11262576,'Lisbelia','Josefina','Alvarado','Rodríguez','Venezolano','1975-09-10','m','----','0412-1641135','----','lisbeliaalvarado@gmail.com',NULL,'2chomp20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4196',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17858149,'Gissell','Nahir','Alvarado','Soto','Venezolano','1975-09-10','m','----','0426-3085666','----','Gissell.alvarado@gmail.com',NULL,'11dawn63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4197',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16899641,'Yexsi','carolina','Alvarado','Soto','Venezolano','1975-09-10','m','----','0426-2557809','----','Yexsi.alvarado@gmail.com',NULL,'4packs44','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4198',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11261606,'Jairo','Meranel','Brijaldo','Acosta','Venezolano','1975-09-10','m','----','0416-1217000','----','brijaldo@yahoo.com',NULL,'8debs11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4199',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7504912,'Yony','Gregorio','Osorio','Gudiño','Venezolano','1975-09-11','m','----','0416-1056102','----','Yonyosorio75@gmail.com',NULL,'20joust29','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4200',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7594072,'Radames','Laerte','Gimenez','Segura','Venezolano','1975-09-13','m','----','0416-4525528','----','calparmo@gmail.com',NULL,'8monk29','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4201',1,1,23,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13996806,'Gilberto',NULL,'Briceño',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'2nanny41','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4404',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7389671,'Carmen',NULL,'Colmenarez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'5hippy72','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4405',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17782313,'Annabel',NULL,'Cumare',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'11horsy78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4406',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9618662,'Yamilet',NULL,'Escalona',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'20batch47','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4407',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17195337,'Gerardo',NULL,'Gómez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'10puce53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4408',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7436802,'Moraima',NULL,'González',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'16coon51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4409',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15777458,'Rafael','A.','Linárez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'13scion13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4410',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14937552,'Walter',NULL,'López',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'17negro37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4411',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7417249,'Jenny','P','Mendoza',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'19occur59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4412',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11878104,'Arelis',NULL,'Montilla','Parra','Venezolano','1975-09-10','m','----','----','----','----',NULL,'12teed31','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4413',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20046116,'Juan  Clerismar',NULL,'San',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'9coup99','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4414',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7125424,'Beatriz',NULL,'Páez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'4idiot68','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4415',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9836789,'José',NULL,'Parra','T.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0nosed48','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4416',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13083471,'Joxis',NULL,'Perez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'1lards55','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4417',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12369201,'Juan',NULL,'Pérez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'2canny53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4418',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15543342,'Noremis',NULL,'Pérez',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'9mules93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4419',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12536314,'Omaira',NULL,'Salas',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'4limey35','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4420',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16139982,'Yarismar',NULL,'Torrealba',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'5sops21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4421',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16112344,'Wilcar',NULL,'Rojas',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'0craze57','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4422',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12247281,'Darwin',NULL,'Ortiz',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'17pros5','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4423',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17033177,'Caribay','A.','Linárez',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'3sera42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4424',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19347275,'Johancy',NULL,'Romero',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'10entry70','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4425',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18422039,'Yohender',NULL,'Romero',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'2burgh86','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1782',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11477929,'Roland',NULL,'Chirinos',NULL,'Venezolano','1975-09-11','m','----','----','----','----',NULL,'6ditch20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4426',1,1,10,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19686568,'YANNALYT,','C','MENDOZA,','M','Venezolano','1975-09-27','f','----','----','----','mendoza@hotmai.com',NULL,'17hewed8','s',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,'4427',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7447200,'YASMIN','COROMOTO','SANTANA',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'6since61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4428',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7458465,'NELLYS','ELOIDA','PERDOMO','SEQUERA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6overt38','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4429',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7466106,'DEISY','COROMOTO','GARCIA','MONTILLA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0into9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4430',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9573218,'FLORA','ELIGIA','BOQUILLO','FALCON','Venezolano','1975-09-10','m','----','----','----','----',NULL,'1chomp55','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4431',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10126759,'FARIDA','ALTAGRACIA','RODRIGUEZ','RAGA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8bevy78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4432',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12882597,'YENNY','COROMOTO','RODRIGUEZ','DE TOVAR','Venezolano','1975-09-18','m','----','----','----','----',NULL,'20bent85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4433',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12882649,'IDALIA','CONCEPCION','RODRIGUEZ','PERALTA','Venezolano','1975-09-19','m','----','----','----','----',NULL,'18traps33','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4434',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13196571,'SANDY','LISBETH','LEON','PEROZA','Venezolano','1975-09-21','m','----','----','----','----',NULL,'3lens38','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4435',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13723584,'JACQUELINE','MARGARITA','CORDONES','COLINA','Venezolano','1975-09-24','m','----','----','----','----',NULL,'14rejig51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4436',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13867430,'YULYS','MARYELIS','MENDEZ','MENDOZA','Venezolano','1975-09-25','m','----','----','----','----',NULL,'0rouse89','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4437',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14592560,'IRAILIS','ALEJANDRA','GIMENEZ','MARTINEZ','Venezolano','1975-09-30','m','----','----','----','----',NULL,'14aces37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4438',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15444666,'MILARYS','IDANIA','DAZA','PEREZ','Venezolano','1975-10-04','m','----','----','----','----',NULL,'5amid52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4439',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15918880,'NELMAR','SOLEDAD','PEREZ','VEGA','Venezolano','1975-10-07','m','----','----','----','----',NULL,'5testy97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4440',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15919662,'MAYERLIN','ADRIANA','GUEDEZ','MEDINA','Venezolano','1975-10-08','m','----','----','----','----',NULL,'11wised52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4441',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16735605,'CLAUDIA','MAIKELY','LUCENA','LEON','Venezolano','1975-10-12','m','----','----','----','----',NULL,'18condo72','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4442',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16956676,'YURI','MAIKELI','FLORES','TORRES','Venezolano','1975-10-13','m','----','----','----','----',NULL,'3naval98','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4443',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17639587,'YAMILET','DEL CARMEN','LINAREZ','MENDOZA','Venezolano','1975-10-15','m','----','----','----','----',NULL,'20condo53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4444',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18431678,'NAIROBIS','LISBETH','GIL','ARBUJAS','Venezolano','1975-10-17','m','----','----','----','----',NULL,'4skunk26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4445',1,1,7,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17506971,'DAILETH','JOSEFINA,','FONSECA','RODRIGUEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4inked50','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4267',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11693143,'ZIBEL','MARGARITA,','RODRIGUEZ','DIAZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5dryad92','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4268',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7985931,'MARGARITA','DEL CARMEN','MENDOZA','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5condo16','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4269',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15886082,'JENNIFER','CRISTINA,','YZARRA','ESCALONA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15curse14','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4270',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18288046,'JOSE','GREGORIO','CALDERON','GARCIA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6titty70','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4271',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19264698,'YELIXA','DEL','CARMEN','SANCHEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8humid49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4272',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18438345,'NEIDA','MARIA','ALVARADO','SILVA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'3gild43','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4273',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18105180,'NELSON','JOSE,','PARADAS','SANTELIZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17masts85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4274',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14030479,'DALIMAR','YOLEIDA,','SANCHEZ','YANEZ','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2until26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4275',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16585947,'YOLIMAR','CRISTINA','PEÑA','MOGOLLON','Venezolano','1975-09-10','m','----','----','----','----',NULL,'3ditzy61','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4276',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15960705,'RAMON','EGIDIO',NULL,'DURAN','Venezolano','1975-09-11','m','----','----','----','----',NULL,'1midst60','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4277',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20015610,'DARIELY','ANGELICA','MENDEZ','MENDEZ','Venezolano','1975-09-12','m','----','----','----','----',NULL,'7couch40','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4278',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13605770,'YULIBETH','TERESA,','CANTILLO','SANCHEZ','Venezolano','1975-09-13','m','----','----','----','----',NULL,'13ache59','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4279',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14000579,'SILENY','SARAHIT','PARADAS','DE CARRASCO','Venezolano','1975-09-14','m','----','----','----','----',NULL,'12snowy6','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4280',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17573286,'CARLA','PASTORA','MARTINEZ','PINEDA','Venezolano','1975-09-15','m','----','----','----','----',NULL,'13bacon34','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4281',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16089881,'MARIA','LAURA','OVALLES','GOMEZ','Venezolano','1975-09-16','m','----','----','----','----',NULL,'19enema29','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4282',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13644871,'JORGE','JOSE','OCHOA','GARCIA','Venezolano','1975-09-17','m','----','----','----','----',NULL,'12brigs52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4283',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17795629,'YOLANDA','CAROLINA','PETIT','DE SOTO','Venezolano','1975-09-18','m','----','----','----','----',NULL,'14trite95','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4284',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(6355884,'MONICA',NULL,'GIMENEZ',NULL,'Venezolano','1975-09-19','m','----','----','----','----',NULL,'10posts39','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4285',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14649536,'FLOR','DEL VALLE','MOGOLLON','CAMACHO','Venezolano','1975-09-20','m','----','----','----','----',NULL,'8scion41','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4286',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15412897,'RAFAEL','RAMON,','FREITEZ','ALVAREZ','Venezolano','1975-09-21','m','----','----','----','----',NULL,'8split99','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4287',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7419955,'EDITH','DEL ROSARIO','CUICAS','SANCHEZ','Venezolano','1975-09-22','m','----','----','----','----',NULL,'19until97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4288',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15307840,'ROBERTH','ANTONIO,','HEREDIA','MENDOZA','Venezolano','1975-09-23','m','----','----','----','----',NULL,'11trap9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4289',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17620597,'MARIANGEL',NULL,'ESCALONA','ALVAREZ','Venezolano','1975-09-24','m','----','----','----','----',NULL,'4raise22','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4290',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19883835,'NELMALY','MACARENA,','PEREZ','HERNANDEZ','Venezolano','1975-09-25','m','----','----','----','----',NULL,'9cocoa15','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4291',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19104562,'KEYLIN','DESSIRE','MARQUEZ','GIMENEZ','Venezolano','1975-09-26','m','----','----','----','----',NULL,'1trews91','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4292',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15731431,'MIGDALIA','YACKELINE','ORO','PERDOMO','Venezolano','1975-09-27','m','----','----','----','----',NULL,'8fret72','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4293',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12247162,'YADIRA','JOSEFINA,','ESCALONA','RIVERO','Venezolano','1975-09-28','m','----','----','----','----',NULL,'15fours20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4294',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18950584,'YAISYR','WILMARY,','ARRIECHE','APOSTOL','Venezolano','1975-09-29','m','----','----','----','----',NULL,'8audio71','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4295',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16796662,'EUCARIS','PATRICIA','SUAREZ','SIVIRA','Venezolano','1975-09-30','m','----','----','----','----',NULL,'2worm99','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4296',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19433665,'WILLIAM','PASTOR','LOYO','LEON','Venezolano','1975-10-01','m','----','----','----','----',NULL,'7gored67','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4297',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11433908,'GEORGET','PASTORA,','GONZALEZ','GUTIERREZ','Venezolano','1975-10-02','m','----','----','----','----',NULL,'2mangy89','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4298',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12703271,'MARY','TRINI,','SANCHEZ','TORRES','Venezolano','1975-10-03','m','----','----','----','----',NULL,'1unfit93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4299',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19180802,'MAYRIM','LUISANA','PIÑA','ROJAS','Venezolano','1975-10-05','m','----','----','----','----',NULL,'8flask58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4300',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17034918,'DANIELA','COROMOTO','ORELLANA','NAGERA','Venezolano','1975-10-06','m','----','----','----','----',NULL,'11paras8','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4301',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12851859,'LISSETH','COROMOTO,','TORBELLO','MEDINA','Venezolano','1975-10-07','m','----','----','----','----',NULL,'18cums13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4302',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17574735,'YOHANNY','JOSEFINA','HERNANDEZ','LLAMOZAS','Venezolano','1975-10-08','m','----','----','----','----',NULL,'8artsy99','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4303',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10125346,'MIRIAM,','SAN','JUA','PEREZ','Venezolano','1975-10-09','m','----','----','----','----',NULL,'8suds34','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4304',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13881504,'IGORD','JOSE,','ARTEAGA',NULL,'Venezolano','1975-10-10','m','----','----','----','----',NULL,'16retry90','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4305',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15667823,'BENJAMIN','DE JESUS','ROMERO','MORALES','Venezolano','1975-10-11','m','----','----','----','----',NULL,'14tribe48','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3395',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10218815,'DAMELIS','JOSEFINA','MUJICA','UGAS','Venezolano','1975-10-12','m','----','----','----','----',NULL,'8mealy17','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4306',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12020077,'MARIA','EUGENIA','PACHECO','SANCHEZ','Venezolano','1975-10-13','m','----','----','----','----',NULL,'8imps7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4307',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18785613,'YANETZY','DEL ROSARIO','MONTILLA','VALERA','Venezolano','1975-10-14','m','----','----','----','----',NULL,'12mare67','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4308',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18862069,'RAQUEL','SARAHI,','PEREZ','JIMENEZ','Venezolano','1975-10-15','m','----','----','----','----',NULL,'18cove47','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4309',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11596385,'NOIDAILYCHT','DE LOS ANGELES','CRESPO','MONTERO','Venezolano','1975-10-16','m','----','----','----','----',NULL,'15bilge4','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4310',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19887653,'MARILYN','PASTORA,','GODOY','LINARES','Venezolano','1975-10-17','m','----','----','----','----',NULL,'5aria13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4311',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18525603,'ALEXANDRA','MARIA','CASTILLO','ARRIECHE','Venezolano','1975-10-18','m','----','----','----','----',NULL,'19tends34','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4312',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9545461,'NORMA','ELOISA','RAMIREZ',NULL,'Venezolano','1975-10-19','m','----','----','----','----',NULL,'18detox3','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4313',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7358202,'YRIS','COROMOTO,','LOPEZ','DE VALERA','Venezolano','1975-10-20','m','----','----','----','----',NULL,'1inane43','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4314',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18376731,'KATIUSKA','DEL VALLE','BRICEÑO','ESCALONA','Venezolano','1975-10-21','m','----','----','----','----',NULL,'8imply91','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4315',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10770737,'ELVIA','EVELYN','APONTE','SEQUERA','Venezolano','1975-10-22','m','----','----','----','----',NULL,'7liven41','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4316',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12025217,'YOLEIDA','JOSEFINA','MORILLO','CORDERO','Venezolano','1975-10-23','m','----','----','----','----',NULL,'4silly41','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4317',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(5939079,'ALVIN','JOSÉ','MARCHÁN',NULL,'Venezolano','1975-09-10','m','----','0416-5598303','----','----',NULL,'0unify71','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4202',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17017440,'FREDDY','JESUS,','ANGULO','LOZADA','Venezolano','1975-09-10','m','----','0426-7071677','----','----',NULL,'16dick85','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4203',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15673908,'YUNANCY','RAMONA','OCANTO',NULL,'Venezolano','1975-09-10','m','----','0252-4440829','----','----',NULL,'18shots63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4204',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16442255,'EDUARD','RAMON','CONTRERAS','BARRIOS','Venezolano','1975-09-10','m','----','0252-4440829','----','----',NULL,'12homy53','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4205',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11702005,'FRANCISCO','ANTONIO','RODRIGUEZ','OCANTO','Venezolano','1975-09-10','m','----','0414-3733987','----','----',NULL,'11whiz96','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4206',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16441877,'MIRTHA','ZOLEIDA','MARTINEZ','ARROYO','Venezolano','1975-09-10','m','----','0416-7549868','----','----',NULL,'5fishy28','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4207',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14003931,'CARLOS','ALONSO','ALMAO','LOZADA','Venezolano','1975-09-10','m','----','0426-7554301','----','----',NULL,'20devil13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4208',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12691783,'SARA','DE LOS ANGELES','DIAZ','MELENDEZ','Venezolano','1975-09-10','m','----','0416-3852648','----','----',NULL,'3laced26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4209',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16441139,'OSWALDO','ANTONIO','PIÑA','PEREZ','Venezolano','1975-09-10','m','----','0416-9378518','----','----',NULL,'8suds63','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4210',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13179847,'MISAEL','JOSE','PIÑA','PADILLA','Venezolano','1975-09-10','m','----','0416-6523037','----','----',NULL,'8tabby96','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4211',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12691764,'NAY','ENRIQUE','ECHETO','JALLER','Venezolano','1975-09-11','m','----','0414-0719554','----','----',NULL,'0acme91','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4212',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11702411,'PEDRO','DOMINGO','CORDERO','ROJAS','Venezolano','1975-09-12','m','----','0426-1596516','----','----',NULL,'3motto18','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4213',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11695444,'ANDHERSON','PASTOR','ALVAREZ','NIEVES','Venezolano','1975-09-13','m','----','0426-3567040','----','----',NULL,'0atlas58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4214',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17342621,'YUBISAY','COROMOTO','ALMAO','DE CORONEL','Venezolano','1975-09-14','m','----','0416-1528167','----','----',NULL,'4hemp94','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4215',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15263086,'ELIMAR','GREGORIA','ARROYO','QUERALES','Venezolano','1975-09-16','m','----','0416-1225190','----','----',NULL,'20overs34','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4216',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13520265,'FRANCIS','MARBELIA','FALCON','HEREDIA','Venezolano','1975-09-17','m','----','0426-4035076','----','----',NULL,'17eves26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4217',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(5931325,'RAMON','GERARDO','GUTIERREZ',NULL,'Venezolano','1975-09-18','m','----','0416-1271589','----','----',NULL,'19fudge7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4218',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13777224,'DANIS','LUCIA','LEGETT','COLOMBO','Venezolano','1975-09-19','m','----','0416-5166844','----','----',NULL,'13spas58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4219',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11698039,'YANILETH','DEL CARMEN','TIMAURE','CARRASQUERO','Venezolano','1975-09-20','m','----','0414-5048828','----','----',NULL,'17jazz50','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4220',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20250292,'ANGELA','MARIANIS','NOGUERA','VASQUEZ','Venezolano','1975-09-21','m','----','0426-2084479','----','----',NULL,'20bends28','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4221',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16769647,'ELIZABETH','CAROLINA','SUAREZ','MENDOZA','Venezolano','1975-09-22','m','----','0426-7593250','----','----',NULL,'0ache29','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4222',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13345587,'MARIO','RAFAEL,','QUINTERO','CARRASCO','Venezolano','1975-09-23','m','----','----','----','----',NULL,'10optic2','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4223',1,1,24,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19149142,'CARMEN','--','ALVAREZ','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'0volt4','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4232',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13527711,'MARLING','--','BRITO','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'11indie29','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4233',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20236031,'YEIBER','--','FERNANDEZ','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2gamma36','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4234',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14030379,'CARLOS','--','FIGUEROA','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9paces10','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4235',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(4412863,'OSCAR','--','GUEDEZ','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'9guilt48','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4236',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19105041,'PEDRO','--','MURO','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15coops58','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4237',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20235481,'LEONARDO','--','PEREZ','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'12stein44','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4238',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19164760,'OSCAR','--','PEREZ','--','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6broil93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4239',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20321339,'IRENE','--','PINEDA','--','Venezolano','1975-09-11','m','----','----','----','----',NULL,'15pally69','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4240',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(5916859,'GLORIA','--','RUIZ','--','Venezolano','1975-09-13','m','----','----','----','----',NULL,'3coon4','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4241',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13543069,'hembert','antonio','sanchez','suarez','V','1977-09-10','m','calle 4 entre 5 y 6 la playa de santa isabel casa numero cuatro(4) # 35','02514433802','02514433802','hsanchez_10@live.com',NULL,'10park28','s',66,12,410,140,NULL,NULL,NULL,NULL,'4242',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16001401,'CEINA','--','VILLALONGA','--','Venezolano','1975-09-22','m','----','----','----','----',NULL,'8trail15','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4243',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9613287,'PEREZ','--','ISBELYS','--','Venezolano','1975-09-27','m','----','----','----','----',NULL,'17shat65','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4244',1,1,12,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19551449,'Daniela','Carolina','Diaz','Briceño','Venezolano','1975-09-10','m','----','----','----','----',NULL,'12bide78','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4010',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16233288,'Doris','Hortencia','León','Pantaleón','Venezolano','1975-09-10','m','----','----','----','----',NULL,'7beard51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2959',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17328491,'Leana','Gabriela','Salcedo','Aular','Venezolano','1975-09-10','m','----','----','----','----',NULL,'19imply35','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4011',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15866851,'Victor','Antonio','Alvarado','Oropeza','Venezolano','1975-09-10','m','----','----','----','----',NULL,'7wacky19','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4012',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16950558,'Rosa','Angela','Salazar','Viveros','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4chili30','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4013',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19348447,'Jesús',NULL,'Tobozo',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'14pens49','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3263',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19887839,'Jessica',NULL,'Colmenares',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'7front62','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3254',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(20349627,'Yulimar','Beatriz','Chambuco','Freitez','Venezolano','1975-09-10','m','----','----','----','----',NULL,'16proof1','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4014',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17037277,'Desiree','Daniela','Sosa','Linares','Venezolano','1975-09-10','m','----','----','----','----',NULL,'3regal90','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4016',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18733429,'German','José','Azuaje',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'10tower74','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4017',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16739325,'José','de Jesus','Franco','Briceño','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5anew7','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4018',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13645982,'María','Teresa','Sivira',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'11conch36','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4019',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13637449,'Edwin','Alexnader','Antiche','Garzón','Venezolano','1975-09-10','m','----','----','----','----',NULL,'6pane80','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4020',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16402894,'Dixon',NULL,'Romero',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'7matzo37','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4021',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14797002,'Omar',NULL,'Lozada',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'8outre76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3297',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15961277,'Jesus','Alberto','Gonzalez','Castillo','Venezolano','1975-09-10','m','----','----','----','----',NULL,'8colon97','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4022',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10844155,'Vigadalina',NULL,'Querales',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'17matey11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4023',1,1,15,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12851340,'BRONNY','.','RODRIGUEZ','.','Venezolano','1970-09-01','m','.','.','.','-@j.com',NULL,'8busk50','s',66,12,410,140,NULL,1,'-',NULL,'4245',1,1,12,85,1,44,2,'2014-10-24',1,'NUEVO INGRESO 2014-3'),(19687592,'JOSE','.','LUCENA','.','Venezolano','1970-09-01','m','.','.','.','-@j.com',NULL,'17apron19','s',66,12,410,140,NULL,1,'-',NULL,'4246',1,1,12,85,1,44,2,'2014-10-24',1,'NUEVO INGRESO 2014-3'),(19240681,'ENRIQUE','.','MENDOZA','.','Venezolano','1970-09-01','m','-','.','.','-@j.com',NULL,'4inure50','s',66,12,410,140,NULL,1,'-',NULL,'4247',1,1,12,85,1,44,2,'2014-10-24',1,'NUEVO INGRESO 2014-3'),(19113604,'MARÍA','JOSÉ','MENDOZA','F.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'15optic6','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4446',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18689695,'JOSE','GREGORIO','FALCÓN',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'19study20','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4447',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17355159,'MIRIAM','DEL R.','MANZANO','T.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'7rerun84','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4448',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9626236,'CARLOS',NULL,'HERNÁNDEZ','ABBATE','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2preen69','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4449',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10961661,'YOLKA','ADELINA','MARTÍNEZ','BETANCOURT','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13lands12','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4450',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15599590,'TOMÁS','ANTONIO','COLMENARES','P.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'2fief67','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4451',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18861944,'MAYRA','ALEJANDRA','SOTO','M.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'12brake96','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4452',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10955442,'YENNYS','DEL C.','LINARES','R.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'17conch56','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4453',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(7981943,'ISMAEL',NULL,'AGUILAR',NULL,'Venezolano','1975-09-10','m','----','----','----','----',NULL,'10preys42','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4454',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19344865,'ZULAY','COROMOTO','SEGOVIA','B.','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4ditzy9','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4455',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16737695,'YEMARY',NULL,'SUÁREZ','ORELLANA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'13droop11','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4456',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14228102,'O.LOURDES',NULL,'ZAMBRANO','MENDOZA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'5irony18','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4457',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17355205,'KEILA','ANDREÍNA','TORRES','ROA','Venezolano','1975-09-10','m','----','----','----','----',NULL,'4minim62','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4458',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(15776361,'ENDERSON','RAMÓN','URBINA','SÁNCHEZ','Venezolano','1975-09-11','m','----','----','----','----',NULL,'13shake52','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4459',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17013254,'MARÍA','REBECA','AZUAJE','RODRIGUEZ','Venezolano','1975-09-12','m','----','----','----','----',NULL,'6occur75','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4460',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12593859,'RAMÓN','AMILKAR','ESCOBAR','E.','Venezolano','1975-09-14','m','----','----','----','----',NULL,'10womb13','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4248',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16736709,'ARACELIS','ADRIANA','QUEVEDO','SUÁREZ','Venezolano','1975-09-15','m','----','----','----','----',NULL,'7conk26','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4461',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18923466,'YULIMAR','KATIUSKA','QUEVEDO','C.','Venezolano','1975-09-16','m','----','----','----','----',NULL,'4rerun44','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4462',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17354536,'YOLBERT','A.','RODRÍGUEZ','SILVA','Venezolano','1975-09-19','m','----','----','----','----',NULL,'0noun4','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4463',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13678769,'LUZ','MARÍA','P.','REINOSO','Venezolano','1975-09-20','m','----','----','----','----',NULL,'10prods86','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4464',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17873146,'MARÍA','MILAGRO','MUJICA','C.','Venezolano','1975-09-21','m','----','----','----','----',NULL,'4tinny84','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4465',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(14014768,'MARÍA','GABRIELA','ESCALONA','NORIEGA','Venezolano','1975-09-23','m','----','----','----','----',NULL,'12dark76','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4466',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16059242,'DANYELIS','COROMOTO','RODRÍGUEZ',NULL,'Venezolano','1975-09-24','m','----','----','----','----',NULL,'2stops71','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4467',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(12594390,'ELYS',NULL,'FREITES',NULL,'Venezolano','1975-09-28','m','----','----','----','----',NULL,'11scion47','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4468',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(10960784,'NORBERTO','JOSÉ','FREITEZ',NULL,'Venezolano','1975-09-30','m','----','----','----','----',NULL,'2untie51','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4249',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(18812763,'F.','MARÍA','FLORES','RODRÍGUEZ','Venezolano','1975-10-01','m','----','----','----','----',NULL,'12until93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4318',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11586098,'MARIFEL','PASTORA','ALVAREZ',NULL,'Venezolano','1975-10-02','m','----','----','----','----',NULL,'0dozy32','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4469',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16060511,'ADALÍ','ZULAY','FREITEZ','LEÓN','Venezolano','1975-10-06','m','----','----','----','----',NULL,'3bigot98','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4470',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(9621273,'MARÍA','ISABEL','DE LA CRUZ',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'19exile84','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4471',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17132975,'BEATRIZ','ADRIANA','VARGAS',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'0humid14','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4472',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19640287,'ESDRAS',NULL,'AGUERO',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'1roman16','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4473',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(16239343,'GREISY','GREGORI','PÉREZ','A.','Venezolano','1975-10-06','m','----','----','----','----',NULL,'0lured21','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4474',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(11582442,'RAFAEL','JOAQUÍN','CEBALLOS','A.','Venezolano','1975-10-06','m','----','----','----','----',NULL,'4glass93','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4475',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17134653,'YAIRA',NULL,'MENDOZA',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'8ions10','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4476',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(17171785,'EDDY','L.','SÁNCHEZ',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'20meted98','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4477',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(13880464,'CARLOS','LUIS','PIÑA',NULL,'Venezolano','1975-10-06','m','----','----','----','----',NULL,'3imps86','s',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4250',1,1,8,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3'),(19263638,'Danilo','-','Perozo','-','-','1965-12-12','m','-','-','-','a@gmail.com',NULL,'0tempt75','s',66,12,410,140,NULL,1,'-',NULL,'4015',1,1,15,85,1,44,2,'2014-10-29',1,'NUEVO INGRESO 2014-3'),(9628860,'Marbella',NULL,'Camacho',NULL,'Venezolana','1990-12-12','f','1',NULL,NULL,'marbella@hotmail.com',NULL,'0letup73','s',66,12,410,140,NULL,1,NULL,NULL,'4478',1,1,7,85,1,44,2,'2014-11-06',1,'NUEVO INGRESO 2014-3'),(10960915,'Livia',NULL,'López',NULL,'Venezolana','1990-12-12','f','1',NULL,NULL,'livia@hotmail.com',NULL,'0satyr3','s',66,12,410,140,NULL,1,NULL,NULL,'4479',1,1,7,85,1,44,2,'2014-11-06',1,'NUEVO INGRESO 2014-3'),(14229112,'Omaira',NULL,'Fernandez',NULL,'Venezolana','1990-12-12','f','1',NULL,NULL,'omaira@hotmail.com',NULL,'9girl70','s',66,12,410,140,NULL,1,NULL,NULL,'4480',1,1,7,85,1,44,2,'2014-11-06',1,'NUEVO INGRESO 2014-3'),(16866846,'Joselyn',NULL,'Fuentes',NULL,'Venezolana','1990-12-12','f','1','----','-----','fuentes@hotmail.com',NULL,'17emcee86','s',66,12,410,140,NULL,1,'----',NULL,'4481',1,1,7,85,1,44,2,'2014-11-06',1,'NUEVO INGRESO 2014-3'),(18998785,'YONERKYS',NULL,'GARCIA',NULL,'VENEZOLANA','1990-12-12','f','1',NULL,NULL,'garcia@hotmail.com',NULL,'4fours54','s',66,NULL,NULL,NULL,NULL,1,NULL,NULL,'4482',1,1,25,85,1,44,2,'2014-10-01',1,'NUEVO INGRESO 2014-3');
/*!40000 ALTER TABLE `estudiantes_aprob` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `etnias`
--

DROP TABLE IF EXISTS `etnias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `etnias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CCBC73BA20332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `etnias`
--

LOCK TABLES `etnias` WRITE;
/*!40000 ALTER TABLE `etnias` DISABLE KEYS */;
INSERT INTO `etnias` VALUES (1,'1','ACAHUAYO'),(2,'2','ARAHUAC DEL DELTA AMACURO'),(3,'3','ARAHUAC DEL RÍO NEGRO'),(4,'4','BARI'),(5,'5','CARIÑA'),(6,'6','GUAJIBO'),(7,'7','GUAJIRO'),(8,'8','GUARAO O WARAO'),(9,'9','GUAYQUERI'),(10,'10','MAPOYO O YAHUANA'),(11,'11','MAQUIRITARE'),(12,'12','PANARE'),(13,'13','PARAUJANO.'),(14,'14','PEMÓN'),(15,'15','PIAROA'),(16,'16','PUINABE'),(17,'17','YANOMAMI'),(18,'18','YARURO:'),(19,'19','YUCPA'),(20,'20','No Aplica');
/*!40000 ALTER TABLE `etnias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exonerados`
--

DROP TABLE IF EXISTS `exonerados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `exonerados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lapso_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `tipo_id` int(11) DEFAULT NULL,
  `espeestud_id` int(11) DEFAULT NULL,
  `resolucion` varchar(100) NOT NULL,
  `porcentaje` decimal(10,2) NOT NULL,
  `fechainclucion` datetime NOT NULL,
  `subsede_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_717BCA1280B24165` (`lapso_id`),
  KEY `IDX_717BCA12E19F41BF` (`sede_id`),
  KEY `IDX_717BCA12A9276E6C` (`tipo_id`),
  KEY `IDX_717BCA1285179081` (`espeestud_id`),
  KEY `IDX_717BCA12AAFDE970` (`subsede_id`),
  CONSTRAINT `FK_717BCA1280B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_717BCA1285179081` FOREIGN KEY (`espeestud_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `FK_717BCA12A9276E6C` FOREIGN KEY (`tipo_id`) REFERENCES `tipo_exoneracion` (`id`),
  CONSTRAINT `FK_717BCA12AAFDE970` FOREIGN KEY (`subsede_id`) REFERENCES `subsede` (`id`),
  CONSTRAINT `FK_717BCA12E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exonerados`
--

LOCK TABLES `exonerados` WRITE;
/*!40000 ALTER TABLE `exonerados` DISABLE KEYS */;
/*!40000 ALTER TABLE `exonerados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `extensiones_usuarios`
--

DROP TABLE IF EXISTS `extensiones_usuarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `extensiones_usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usuario_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `especialidad_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_1F426C0DB38439E` (`usuario_id`),
  KEY `IDX_1F426C0E19F41BF` (`sede_id`),
  KEY `IDX_1F426C016A490EC` (`especialidad_id`),
  CONSTRAINT `FK_1F426C016A490EC` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`),
  CONSTRAINT `FK_1F426C0DB38439E` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`),
  CONSTRAINT `FK_1F426C0E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `subsede` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `extensiones_usuarios`
--

LOCK TABLES `extensiones_usuarios` WRITE;
/*!40000 ALTER TABLE `extensiones_usuarios` DISABLE KEYS */;
/*!40000 ALTER TABLE `extensiones_usuarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hata`
--

DROP TABLE IF EXISTS `hata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hata` (
  `id` int(11) NOT NULL DEFAULT 0,
  `Codigo Unidad Curricular` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `Nombre Unidad Curricula` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `uc` int(11) NOT NULL,
  `Horas Had` int(11) NOT NULL,
  `Horas Hle` int(11) NOT NULL,
  `Total Horas` bigint(20) NOT NULL DEFAULT 0,
  `componente_id` int(11) DEFAULT NULL,
  `codigocomp` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `descripcioncomp` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tipocursos_id` int(11) DEFAULT NULL,
  `codigotipo` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `descripciontipo` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `area_id` int(11) DEFAULT NULL,
  `descripcionarea` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hata`
--

LOCK TABLES `hata` WRITE;
/*!40000 ALTER TABLE `hata` DISABLE KEYS */;
INSERT INTO `hata` VALUES (1,'CIU0201','Ciudadanía, Soberanía y Democracia',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(2,'ACT0202','Actividad Experimental en Física y en su  Enseñanza aprendizaje',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(3,'ACT0403','Actividad Física, Deporte  y Recreación',4,4,8,12,3,'CFC','Componente de Formación Contextualizado',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(4,'ADM0204','Administración de Centros de Recursos Informáticos',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(5,'ADM0405','Administración de Empresas Socioproductivas I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(6,'ADM0406','Administración de Empresas Socioproductivas II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(7,'ADM0307','Administración del Talento Humano',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(8,'CON0308','Contabilidad de Costos',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(9,'MER0309','Mercadotecnia',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(10,'ADM2010','Administración de Talleres y Laboratorios',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(11,'ADM3011','Administración de Talleres y Laboratorios',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(12,'ADM2012','Administración del Talento Humano',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(13,'ADM4013','Administración Financiera',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(14,'ADM4014','Administración Tributaria',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(15,'ADQ4015','Adquisición y Desarrollo del Lenguaje',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(16,'AGR2016','Agricultura de Subsistencia',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(17,'AGR2017','Agroecología',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(18,'AGR4018','Agroecología',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(19,'AGR4019','Agroindustrias comunitarias',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(20,'ÁLG4020','Álgebra Lineal',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(21,'ALI4021','Alimentación Animal',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(22,'ALT4022','Alternativas de Producción Agrícola',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(23,'AMB3023','Ambiente, Sociedad y Cultura',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(24,'AMB2024','Ambiente, Sociedad y Cultura',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(25,'ANÁ4025','Análisis de Elementos Mecánicos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(26,'ANÁ4026','Análisis del Texto y la Representación Teatral',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(27,'ANÁ4027','Análisis y Organización del Espacio Geográfico',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(28,'ANA4028','Anatomía y Fisiología Animal',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(29,'ANA4029','Anatomía y Fisiología Humana',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(30,'ANA4030','Anatomía y Fisiología Vegetal',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(31,'ANT3031','Antena',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(32,'APR4032','Aprendizaje Matemático I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(33,'APR4033','Aprendizaje Matemático II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(34,'ARQ4034','Arquitectura del Computador',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(35,'ART4035','Arte Venezolano y Cotidianidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(36,'ART3036','Arte y Creatividad Educativa',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(37,'ART2037','Arte y Creatividad Educativa',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(38,'ART2038','Arte y Educación',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(39,'AST3039','Astronomía',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(40,'AST2040','Astronomia',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(41,'ATE4041','Atención a Niños y Jóvenes con Discapacidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(42,'ATE4042','Atención en Espacios de Familia y Comunidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(43,'ATE4043','Atención Integral del Infante de 0 a 6 años',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(44,'ATE2044','Atención Primaria de Emergencias',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(45,'AUL4045','Aula Cultural Interactiva',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(46,'AUL4046','Aula Musical Interactiva',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(47,'BAL3047','Baloncesto para la Educación',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(48,'BAS3048','Bases Bioquímica y Nutricional de la Actividad Física',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(49,'BIO2049','Biodiversidad',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(50,'BIO2050','Biodiversidad y Acción Social',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(51,'BIO2051','Bioética',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(52,'BIO2052','Bioética',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(53,'BIO2053','Bioética',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(54,'BIO4054','Biofísica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(55,'BIO4055','Biología Animal',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(56,'BIO4056','Biología Celular y Molecular',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(57,'BIO3057','Biología General',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(58,'BIO4058','Biomecánica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(59,'BIO4059','Bioquímica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(60,'BIO4060','Bioquímica Estructural',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(61,'BIO3061','Bioquímica Metabólica',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(62,'BIO4062','Bioseguridad Animal',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(63,'BIO4063','Bioseguridad Vegetal',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(64,'BOT4064','Botánica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(65,'BOT2065','Botánica Sistemática',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(66,'CÁL2066','Cálculo',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(67,'CÁL4067','Cálculo de Funciones de Varias Variables',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(68,'CÁL4068','Cálculo Diferencial',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(69,'CÁL4069','Cálculo Integral',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(70,'CAR2070','Cartografía Básica',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(71,'CAR4071','Cartografía y Fotointerpretación',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(72,'CAS2072','Castellano',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(73,'CIE2073','Ciencia y Tecnología',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(74,'BIO2074','Biodiversidad y Acción Social',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(76,'CIE2076','Ciencia, Tecnología y Sociedad',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(77,'DIV2077','Diversidad y Unidad de la Materia',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(78,'CIE2078','Ciencia, Tecnología y Sociedad',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(79,'CIE4079','Ciencias De La Naturaleza',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(80,'CIE3080','Ciencias de la Tierra',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(81,'CIE4081','Ciencias Integradas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(82,'CIE3082','Ciencias Naturales',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(83,'CIE4083','Ciencias Naturales',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(84,'CIU2084','Ciudadanía y Democracia',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(85,'CLI4085','Climatología Física',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(86,'COM4086','Comercialización en el Contexto Rural',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(87,'COM2087','Comportamiento y Desarrollo Organizacional',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(88,'COM3088','Comprensión de Sistemas Ambientales',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(89,'COM4089','Comprensión de Textos Orales y Escritos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(90,'COM2090','Comprensión y Producción de Textos en Inglés',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(91,'COM4091','Computación Aplicada al Diseño',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(92,'COM2092','Comunicaciones I',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(93,'COM3093','Comunicaciones II',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(94,'CON4094','Consolidación de la Comunicación escrita en Francés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(95,'CON4095','Consolidación de la Comunicación Escrita en Inglés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(96,'CON4096','Consolidación de la Comunicación Oral en Francés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(97,'CON4097','Consolidación de la Comunicación Oral en Inglés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(98,'CON3098','Contexto y Realidad de la Educación Técnica en Venezuela',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(99,'CON2099','Contexto y Realidad de la Educación Técnica en Venezuela',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(100,'CON3100','Contexto y Realidad de la Educación Técnica en Venezuela',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(101,'CON4101','Control de Motores Eléctricos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(102,'CON3102','Controlador  Lógico Programable (PLC)',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(103,'CON2103','Convivencia Escolar',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(104,'COO2104','Cooperativismo como Medio de Vida',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(105,'CRE4105','Creación artística, identidad y ciudadanía',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(106,'CRE3106','Creatividad Artística',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(107,'ART3107','Arte y Creatividad Educativa',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(108,'ELJ3108','El Juego y la Creatividad',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(109,'EXP3109','Expresión Corporal',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(110,'CUL4110','Cultura Anglófona',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(111,'CUL4111','Cultura del Idioma B',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(112,'CUL2112','Cultura Regional y Literatura',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(113,'CUL4113','Cultura y Discurso Literario',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(114,'CUN2114','Cunicultura',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(115,'DAN2115','Danza Tradicional Venezolana',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(116,'DEP4116','Deporte como medio de enseñanza y aprendizaje',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(117,'DES4117','Desarrollo Curricular',4,4,8,12,1,'CFD','Componente de Formación Docente',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(118,'DES4118','Desarrollo de la Comunicación en Francés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(119,'DES4119','Desarrollo de la Comunicación en Inglés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(120,'DES4120','Desarrollo de Procesos Cognitivos',4,4,8,12,1,'CFD','Componente de Formación Docente',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(121,'DES3121','Desarrollo de proyectos en la creación artística',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(122,'DES4122','Desarrollo endógeno y contextos indígenas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(123,'DES4123','Desarrollo Infantil I Maternal',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(124,'DES4124','Desarrollo Infantil II Preescolar',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(126,'DES2126','Desarrollo Socio-Afectivo y Sexualidad',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(127,'DIB4127','Dibujo Aplicado',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(128,'DIB4128','Dibujo Aplicado II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(129,'DIB2129','Dibujo Técnico Eléctrico',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(130,'DIB2130','Dibujo Electrónico',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(131,'DIB4131','Dibujo Geométrico',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(132,'DIB4132','Dibujo Mecánico',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(133,'DIB4133','Dibujo Técnico',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(134,'DIB2134','Dibujo Técnico',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(135,'DIB4135','Dibujo Técnico Computarizado',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(136,'DID2136','Didáctica Aplicada al Idioma B',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(137,'DID3137','Didáctica aplicada al Inglés',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(138,'DID4138','Didáctica de la Educación Comercial',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(139,'DID2139','Didáctica de la Educación Industrial',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(140,'DID3140','Didáctica de la Educación Industrial',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(141,'DID4141','Didáctica de la Educación Inicial Maternal',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(142,'DID4142','Didáctica de la Educación Preescolar',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(143,'DID4143','Didáctica De La Física',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(144,'DID4144','Didáctica de la Geografía y la Historia',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(145,'DID4145','Didáctica de la Informática',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(146,'DID4146','Didáctica de la Lectura y Escritura',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(147,'DID4147','Didáctica de la Matemática',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(148,'DID4148','Didáctica de las artes plásticas en sus diversos escenarios',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(149,'DID2149','Didáctica del Algebra',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(150,'DID3150','Didáctica del cálculo',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(151,'DID4151','Didáctica del francés lengua extranjera',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(152,'DID4152','Didáctica del Inglés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(153,'DID3153','Didáctica del Inglés para Públicos Específicos',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(154,'DID4154','Didáctica del Teatro',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(155,'DID4155','Didáctica en la Educación Primaria',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(156,'DID4156','Didáctica General',4,4,8,12,1,'CFD','Componente de Formación Docente',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(157,'DIN2157','Dinámica de los espacios fronterizos venezolanos',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(158,'DIN2158','Dinámica del Espacio Geográfico',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(159,'DIN2159','Climatología Aplicada a Venezuela',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(160,'DIN2160','Espacio Geográfico Venezolano',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(161,'MAN2161','Manejo Integral de Cuencas',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(162,'SIS2162','Sistemas de Información Geográfica',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(163,'DIS4163','Discurso de la creación artística',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(164,'DIS4164','Discurso Especializado en Idioma Inglés',4,4,8,12,3,'CFC','Componente de Formación Contextualizado',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(165,'DIS4165','Diseño Instruccional',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(166,'DIV2166','Diversidad Cultural y Lingüística',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(167,'ECO4167','Ecogeografía de Venezuela',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(168,'ECO4168','Ecología',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(169,'ECO4169','Economía campesina',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(170,'ECO4170','Economía del Entorno Organizacional',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(171,'ECO3171','Economía y Mercadeo Agrícola',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(172,'ECO3172','Ecopedagogía',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(173,'ECU4173','Ecuaciones Diferenciales',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(174,'EDU2174','Educación  para el desarrollo productivo y sustentable',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(175,'EDU4175','Educación Ambiental',4,4,8,12,3,'CFC','Componente de Formación Contextualizado',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(176,'EDU2176','Educación Estética',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(177,'EDU3177','Educación Estética',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(178,'EDU4178','Educación Estética',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(179,'EDU2179','Educación Física Inclusiva',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(180,'EDU4180','Educación Física, Deporte  y Recreación',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(181,'EDU3181','Educación Inclusiva',4,4,8,12,3,'CFC','Componente de Formación Contextualizado',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(182,'EDU2182','Educación Intercultural',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(183,'EDU3183','Educación Intercultural Bilingüe',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(184,'EDU2184','Educación no convencional',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(185,'EDU2185','Educación para el Desarrollo Productivo y Sustentable',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(186,'EDU3186','Educación para la Diversidad',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(187,'EDU4187','Educación para la participación comunitaria',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(188,'EDU2188','Educación para la Paz',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(189,'EDU3189','Educación para la Promoción de la Salud Integral',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(190,'EDU3190','Educación para la Salud',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(191,'PRI3191','Primeros Auxilios',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(192,'EDU3192','Salud Preventiva',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(193,'SEX3193','Sexualidad',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(194,'EDU4194','Educación para las Artes',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(195,'EDU4195','Educación Rural',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(196,'EDU3196','Educación y Derechos Humanos',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(197,'EDU4197','Educación y Emprendimiento Social',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(198,'EJE4198','Ejecución de Estrategias para el Emprendimiento Social',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(199,'EL 2199','El Circo y Pedagogía: Payasos y Manipulación de Objetos Circenses',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(200,'EL 3200','El Juego y la Creatividad',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(201,'EL 2201','El Juego y la Creatividad',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(202,'EL 2202','El Juego y la Creatividad',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(203,'EL 3203','El suelo como herramienta didáctica',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(204,'EL 4204','El Títere y la Pedagogía',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(205,'ELE3205','Electrónica Analógica',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(206,'ELE2206','Electrónica Básica',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(207,'ELE4207','Electrónica I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(208,'ELE4208','Electrónica II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(209,'ELE4209','Electrónica Industrial',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(210,'EMP2210','Emprendimiento en la Educación Física',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(211,'EMP4211','Empresas de Labores Técnicas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(212,'EMP4212','Empresas de Manufactura',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(213,'ELA2213','Elaboración de Artesanía',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(214,'JAR2214','Jardines Ornamentales y Medicinales',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(215,'EMP2215','Empresas Socioproductivas I',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(216,'MET2216','Metales y Herrería',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(217,'PRO2217','Producción de Textiles',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(218,'REC2218','Reciclaje de Materiales',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(219,'API2219','Apicultura',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(220,'ELE2220','Electricidad y Reparación de Artefactos Eléctricos',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(221,'EMP2221','Gastronomía',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(222,'HUE2222','Huertos Biointensivos',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(223,'MAN2223','Mantenimiento y Reparación Menor  de Edificaciones',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(224,'PRO2224','Producción de Especies Menores',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(225,'EMP2225','Empresas Socioproductivas II',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(226,'EMP2226','Empresas Socioproductivas III',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(227,'CIE2227','Ciencia y Tecnología de Productos de Frutas y Hortalizas',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(228,'CIE2228','Ciencia y Tecnología de Productos Lácteos',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(229,'ENF2229','Enfoques y Tendencias en la Actividad Física y la Recreación',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(230,'ENF2230','Enfoques y Tendencias Pedagógicas en Educación Inicial',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(231,'ENS3231','Ensayos Mecánicos',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(232,'ENS2232','Enseñanza de la Historia de Venezuela con visión de género',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(233,'ENS3233','Enseñanza de la Literatura',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(234,'INT3234','Introducción a la Literatura',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(235,'LIT3235','Literatura Infantil',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(237,'ENS4237','Enseñanza de Lenguas Extranjeras\n para niñas y niños',4,4,8,12,3,'CFC','Componente de Formación Contextualizado',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(238,'ENT3238','Entorno social de la matemática',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(239,'EPI2239','Epistemología, Historia Y Didáctica De Las Ciencias Naturales',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(240,'ESP4240','Español de Venezuela',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(241,'ESP4241','Español I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(242,'ESP4242','Español II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(243,'EST4243','Estadística  y Probabilidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(244,'EST4244','Estética y Educación',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(245,'EST2245','Estimulación del Lenguaje Oral',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(246,'EST3246','Estrategias Didácticas Creativas',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(247,'EST2247','Estrategias Didácticas Creativas',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(248,'EST4248','Estructuras Algebraicas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(249,'EST4249','Estudio del Discurso Literario en Inglés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(250,'EST3250','Estudios Lingüísticos y Literarios Interculturales',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(251,'ETA2251','Etapas y Desarrollo emocional infantil',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(252,'ETN2252','Etnología y Manifestaciones Culturales Venezolanas',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(253,'ETN2253','Etnomatemática',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(254,'EVA4254','Evaluación de los Procesos de Enseñanza y Aprendizaje del Francés como Lengua extranjera',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(255,'EVA4255','Evaluación de los Procesos de Enseñanza y Aprendizaje del Inglés como Lengua Extranjera',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(256,'EVA4256','Evaluación del Aprendizaje',4,4,8,12,1,'CFD','Componente de Formación Docente',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(257,'EVO3257','Evolución',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(258,'EXP2258','Expresión Corporal',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(259,'EXP4259','Expresión Creadora',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(260,'EXP4260','Expresión Oral y Escrita',4,4,8,12,3,'CFC','Componente de Formación Contextualizado',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(261,'EXP2261','Expresión Oral y Escrita',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(262,'EXP2262','Expresión Plástica en el Dibujo Técnico',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(263,'EXP4263','Expresión plástica en las etapas del desarrollo',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(264,'FEN3264','Fenómenos De La Química De Trascendencia Aplicativa',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(265,'FÍS4265','Física Aplicada A La Química',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(266,'FÍS4266','Física General I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(267,'FÍS4267','Física General II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(268,'FÍS4268','Física I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(269,'FÍS2269','Física II',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(270,'FIS4270','Fisicoquímica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(271,'FLU4271','Fluidos Y Termodinámica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(272,'FON3272','Fonética del idioma B',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(273,'FON3273','Fonética del Inglés',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(274,'FON4274','Fonética y Fonología en Inglés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(275,'FON4275','Fonética y Fonología francesa',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(276,'FOR2276','Formación Moral en la Educación Inicial',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(277,'FOR2277','Formación personal del docente',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(278,'FOR4278','Formulación de Proyectos Socioproductivos.',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(280,'FRO2280','Frontera, Interculturalidad y Educación',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(281,'DER2281','Derecho Internacional, Integración y Frontera',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(282,'DIM2282','Dimensión de la Integración en Espacios  Fronterizos',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(283,'INT2283','Interculturalidad en Espacios de Frontera',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(284,'FUN3284','Fundamentación Epistémica de la Educación Tecnológica en Venezuela.',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(285,'FUN4285','Fundamentos de Àlgebra',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(286,'FUN3286','Fundamentos de Ciencias de la Tierra',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(287,'FUN2287','Fundamentos de economía agrícola',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(288,'FUN4288','Fundamentos de Educación para el Trabajo',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(289,'FUN2289','Fundamentos de Educación para el Trabajo',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(290,'FUN4290','Fundamentos de Física Eléctrica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(291,'FUN4291','Fundamentos De Fisicoquímica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(292,'FUN4292','Fundamentos de Educación Física',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(293,'FUN4293','Fundamentos de la Educación Inicial',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(294,'FUN4294','Fundamentos de la Educación Primaria',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(295,'FUN3295','Fundamentos para la enseñanza de la lectura y la escritura',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(296,'FUN4296','Fundamentos sociológicos de la educación rural',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(297,'FUT3297','Futbol Sala para la Educación',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(298,'GEN4298','Genética y Tópicos de Biotecnología',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(299,'GEO3299','Geografía critica latinoamericana',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(300,'GEO2300','Geografía de la Población',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(301,'GEO4301','Geografía de Venezuela',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(302,'GEO4302','Geografía Económica y Social de Mundo',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(303,'GEO4303','Geografía General',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(304,'GEO4304','Geografía Social y Económica de Venezuela',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(305,'GEO2305','Geología Ambiental',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(306,'GEO3306','Geología de Venezuela',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(307,'GEO4307','Geología Estructural',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(308,'GEO4308','Geología Física',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(309,'GEO4309','Geometría',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(310,'GEO4310','Geometría analítica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(311,'GEO4311','Geometría Descriptiva',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(312,'GEO4312','Geometría I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(313,'GEO4313','Geometría II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(314,'GEO3314','Geomorfología',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(315,'GEO4315','Geoquímica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(316,'GER3316','Gerencia Financiera',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(317,'GER4317','Gerencia y Legislación',4,4,8,12,1,'CFD','Componente de Formación Docente',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(318,'GES2318','Gestión comunitaria I',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(319,'GES4319','Gestión de Eventos de la Actividad Física',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(320,'GES4320','Gestión de la Oficina',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(321,'GES2321','Gestión de procesos comunitarios',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(322,'GES3322','Gestión de procesos comunitarios II',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(323,'GES2323','Gestión de Riesgo y Seguridad Escolar',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(324,'GES2324','Gestión Moderna de Inventarios',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(325,'GES4325','Gestión Organizacional',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(326,'GES4326','Gestión Socio  Educativa y Socioproductiva.',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(327,'GRA4327','Gramática',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(328,'GRA4328','Gramática del Inglés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(329,'GRA4329','Gramática francesa',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(330,'HID4330','Hidrosfera',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(331,'HIG2331','Higiene y Seguridad Laboral',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(332,'HIS2332','Historia de la educación en Venezuela',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(333,'HIS2333','Historia de la Matemática',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(334,'HIS2334','Historia de la vida cotidiana',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(335,'HIS3335','Historia de las relaciones civiles y militares en Venezuela',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(336,'HIS4336','Historia de Venezuela y Ciudadanía',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(337,'HIS4337','Historia del Teatro I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(338,'HIS4338','Historia del Teatro II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(339,'HIS2339','Historia intelectual',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(340,'HIS4340','Historia Originaria y Colonial de Venezuela',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(341,'HIS4341','Historia Republicana de Venezuela',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(342,'HUE2342','Huertos Biointensivos',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(343,'IDE2343','Identidad  Nacional',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(344,'IDE3344','Identidad Ciudadana y democracia',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(345,'IDI4345','Idioma B  I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(346,'IDI4346','Idioma B  II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(347,'IDI4347','Idioma B  III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(348,'IDI4348','Idioma B  IV',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(349,'IDI3349','Idioma C',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(350,'INF4350','Informática',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(351,'ING3351','Ingeniería del Software',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(352,'ING4352','Inglés en Educación Inicial',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(353,'ING4353','Inglés I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(354,'ING4354','Inglés II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(355,'ING4355','Inglés III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(356,'ING4356','Inglés IV',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(357,'ING2357','Inglés o Idioma B',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(358,'INI4358','Iniciación al lenguaje y Ejecución Musical',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(359,'INI2359','Iniciación de lectura y escritura desde la educación inicial',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(360,'INN3360','Innovación Educativa en la Actividad Física, el Deporte y la Recreación',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(361,'INN3361','Innovaciones Educativas Para La Enseñanza De La Física',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(362,'INS4362','Instalaciones Eléctricas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(363,'INS2363','Instrumentos de Medición',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(364,'INT2364','Interculturalidad en Espacios de Frontera',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(365,'INT4365','Interpretación de Recursos Cartográficos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(366,'INT2366','Interpretación y Creatividad Musical',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(367,'INT3367','Introducción a  la Literatura',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(368,'INT4368','Introducción a la Comunicación Escrita en Francés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(369,'INT4369','Introducción a la Comunicación Escrita en Inglés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(370,'INT4370','Introducción a la Comunicación Oral en Francés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(371,'INT4371','Introducción a la Comunicación Oral en Inglés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(372,'INT4372','Introducción A La Física Moderna',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(373,'INT2373','Introducción a la Historia del Arte',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(374,'INT2374','Introducción a la Lectura y Escritura',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(375,'INT4375','Introducción a la Pedología',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(376,'INT4376','Introducción a la Semiología',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(377,'INT4377','Introducción a los Estudios de la Lengua',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(378,'INT4378','Introducción al Estudio del Discurso Literario',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(379,'INT4379','Introducción al Estudio del Discurso Literario en Francés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(380,'INV2380','Investigación de la Diversidad en los Ecosistemas',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(381,'INV3381','Investigación de Operaciones',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(382,'INV4382','INVESTIGACIÓN I',4,4,8,12,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(383,'INV4383','INVESTIGACIÓN II',4,4,8,12,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(384,'INV4384','INVESTIGACIÓN III',4,4,8,12,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(385,'INV4385','INVESTIGACIÓN IV',4,4,8,12,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(386,'LA 2386','La Formación de Género y Sexualidad en Educación Inicial',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(387,'LA 2387','La Teatralidad en las Manifestaciones Artístico – Tradicionales Venezolanas',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(388,'LAB4388','Laboratorio de Circuitos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(389,'LAT4389','Latín',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(390,'LEC4390','Lectura y escritura de lenguas indígenas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(391,'LEC4391','Lectura y escritura en educación inicial',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(392,'LEG4392','Legislación Mercantil y Laboral',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(393,'LEG4393','Legislación Sociopolítica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(394,'LEG2394','Legistacion comparada en contextos interculturales',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(395,'LEN2395','Leng. y sociedad o Adq. de una lengua',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(396,'LEN4396','Lengua Indígena I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(397,'LEN4397','Lengua Indígena II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(398,'LEN4398','Lengua Indígena III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(399,'LEN4399','Lengua Indígena IV',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(400,'LEN4400','Lengua y Cultura',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(401,'LEN4401','Lengua y Cultura Francófona',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(402,'LEN4402','Lengua, Literatura Y Sociedad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(403,'LEN4403','Lenguaje y Ejecución Musical',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(404,'LEN4404','Lenguaje y Ejecución Musical Avanzada',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(405,'LÉX4405','Léxico  Semántico y Semiótico',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(406,'LID3406','Liderazgo Social y Organizacional',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(407,'LÍN3407','Líneas de Transmisión',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(408,'LIN2408','Lingüística aplicada a la enseñanza de la Lengua',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(409,'LIN2409','Lingüística del Corpus',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(410,'LIN4410','Lingüística del Idioma B',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(411,'LIN4411','Lingüística del Inglés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(412,'LIN4412','Lingüística General',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(413,'LIN4413','Lingüística General',4,4,8,12,3,'CFC','Componente de Formación Contextualizado',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(414,'LIN4414','Lingüística General del Francés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(415,'LIT4415','Literatura Anglófona',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(416,'LIT4416','Literatura del Idioma B',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(417,'LIT4417','Literatura Infantil',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(418,'LIT4418','Literatura Juvenil',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(419,'LIT4419','Literatura Latinoamericana y Caribeña',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(420,'LIT3420','Literatura Venezolana',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(421,'LIT4421','Literatura Venezolana',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(422,'LÚD2422','Lúdica en la Lectura y Escritura',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(423,'LÚD2423','Lúdica y Motricidad',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(424,'MAN4424','Manifestaciones artísticas y literarias en contextos indígenas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(425,'MAN2425','Mantenimiento de Edificaciones Educativas',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(426,'MAN4426','Mantenimiento de Equipos y Máquinas Industriales',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(427,'MAN2427','Mantenimiento de instituciones educativas y empresas rurales',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(428,'MAN2428','Mantenimiento Eléctrico',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(429,'MAQ4429','Maquetas y Modelos Tridimensionales',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(430,'MAQ2430','Maquillaje Teatral',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(431,'MAQ4431','Maquinarias agricolas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(432,'MAQ4432','Maquinas Eléctricas I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(433,'MAQ4433','Maquinas Eléctricas II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(434,'MAT4434','Matemática',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(435,'MAT2435','Matemática Aplicada',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(436,'MAT3436','Matemática Aplicada a la Biología',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(437,'MAT4437','Matemática Aplicada A La Química',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(438,'MAT3438','Matemática Aplicada a las Ciencias de la Tierra',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(439,'MAT2439','Matemática Aplicada I',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(440,'MAT2440','Matemática Aplicada II',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(441,'MAT4441','Matemática Aplicada III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(442,'MAT4442','Matemática Discreta',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(443,'MAT4443','Matemática Financiera',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(444,'MAT4444','Matemática para  Mecánica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(445,'MAT4445','Matemática I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(446,'MAT4446','Matemática II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(447,'MAT4447','Matemática III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(448,'MAT2448','Matemática y ciencias naturales',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(449,'MAT2449','Matemática y educación especial.',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(450,'MAT2450','Matemática y realidad',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(451,'MAT4451','Matemáticas para Electrónica I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(452,'MAT4452','Matemáticas para Electrónica II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(453,'MAT4453','Matemáticas para Electrónica III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(454,'MAT3454','Materiales Educativos',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(455,'MEC4455','Mecánica Aplicada',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(456,'MEC2456','Mecánica Básica',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(457,'MEC2457','Mecánica de los Fluidos',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(458,'MEC2458','Mecánica de los Materiales',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(459,'MEC2459','Mecanización Agraria',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(460,'MED3460','Mediación Intercultural',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(461,'MED4461','Mediación Intercultural',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(462,'MED2462','Medición de Parámetros Eléctricos',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(463,'MED4463','Mediciones  Eléctricas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(464,'MED2464','Medios Didácticos para la Educación Industrial',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(465,'MED4465','Medios Expresivo de la Actuación',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(466,'MEM2466','Memoria y patrimonio histórico',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(467,'MER4467','Mercadeo y Publicidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(468,'MET2468','Meteorología',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(469,'MET3469','Meteorología',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(470,'MÉT4470','Método y Didáctica del Dibujo Técnico',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(471,'MET4471','Metrología del Taller',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(472,'MIC4472','Microprocesadores',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(473,'MIN2473','Mineralogía y Petrografía',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(474,'MOM2474','Momentos de la Literatura',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(475,'MÚS2475','Música y Contexto',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(476,'MÚS4476','Música y Movimiento',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(477,'MUS2477','Musicología y Etnomusicología',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(478,'NAT2478','Naturaleza y Cultura',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(479,'NEU4479','Neurociencia y educación',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(480,'NEU4480','Neuromúsica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(481,'NOC4481','Nociones de Contabilidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(482,'NOC4482','Nociones de Oficina',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(483,'OND4483','Ondas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(484,'ÓPT4484','Óptica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(485,'ORA2485','Oratoria y Liderazgo',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(486,'ORI4486','Orientación Educativa y Diversidad',4,4,8,12,1,'CFD','Componente de Formación Docente',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(487,'ORI4487','Origen y Evolución de las Artes Plásticas I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(488,'ORI4488','Origen y evolución de las artes plásticas II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(489,'PED4489','Pedagogía de la Actuación',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(490,'PED4490','Pedagogía de la Dirección Teatral',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(491,'PED4491','Pedagogía de la Música I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(492,'PED4492','Pedagogía de la Música II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(493,'PED4493','Pedagogía de la Música III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(494,'PED3494','Pedagogía Musical',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(495,'PED2495','Pedagogía Musical Infantil',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(496,'PEN4496','Pensamiento Bolivariano',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(497,'PEN4497','Pensamiento Filosófico y Pedagógico',4,4,8,12,1,'CFD','Componente de Formación Docente',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(498,'PEN4498','Pensamiento Lógico Matemático',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(499,'PLA4499','Planificación de la Enseñanza y del Aprendizaje',4,4,8,12,1,'CFD','Componente de Formación Docente',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(500,'PLA4500','Planificación de la Enseñanza y del Aprendizaje',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(501,'PLA2501','Planificación lingüoeducativa',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(502,'PLA2502','Planificación por proyecto',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(503,'PRÁ3503','Práctica del Dibujo Técnico',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(504,'PRÁ4504','Práctica Musical I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(505,'PRÁ4505','Práctica Musical II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(506,'PRÁ4506','Práctica Musical III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(507,'PRÁ8507','PRÁCTICA PROFESIONAL I',8,6,16,22,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(508,'PRÁ8508','PRÁCTICA PROFESIONAL II',8,6,16,22,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(509,'PRÁ8509','PRÁCTICA PROFESIONAL III',8,6,16,22,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(510,'PRÁ8510','PRÁCTICA PROFESIONAL IV',8,6,16,22,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(511,'PRA4511','Praxiología de las Disciplinas Deportivas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(512,'PRA4512','Praxis artística y problemática socioeducativa',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(513,'PRE2513','Preparación Física Básica',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(514,'PRE2514','Prevención y Gestión de Riesgo',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(515,'PRI2515','Primeros Auxilios',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(516,'PRI2516','Primeros Auxilios',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(517,'PRI4517','Principios Básicos de Mecánica Automotriz',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(518,'PRI3518','Principios de archivística y paleografía',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(519,'PRI4519','Principios De La Teoría Electromagnética Y Sus Aplicaciones',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(520,'PRI4520','Principios De Mecánica Teórica Y Aplicada',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(521,'PRO2521','Problemática De La Enseñanza De La Física',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(522,'PRO2522','Problemática de la Enseñanza de la Matemática',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(523,'PRO3523','Problemática Social y Aprendizaje',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(524,'PRO2524','Problemática Social y Aprendizaje',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(525,'PRO4525','Proceso y Transformación de Productos Agropecuarios',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(526,'PRO4526','Procesos Contables',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(527,'PRO4527','Procesos Históricos de América y el Caribe',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(528,'PRO4528','Procesos Históricos del Mundo I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(529,'PRO4529','Procesos Históricos del Mundo II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(530,'PRO4530','Procesos investigativos en las artes plásticas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(531,'PRO4531','Procesos y Transformación de  Productos Agropecuarios',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(532,'PRO4532','Producción Animal  Sustentable',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(533,'PRO4533','Producción de Materiales Educativos Multimediales',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(534,'PRO4534','Producción de Monogástricos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(535,'PRO4535','Producción de Rumiantes',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(536,'PRO4536','Producción Fotográfica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(537,'PRO4537','Producción Vegetal Sustentable',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(538,'PRO4538','Producción y Puesta en Escena',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(539,'PRO4539','Profundización en el estudio del discurso literario en Francés',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(540,'PRO2540','Programación Aplicada a la Educación',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(541,'PRO3541','Programación Aplicada a la Educación',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(542,'PRO4542','Programación I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(543,'PRO4543','Programación II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(544,'PRO2544','Programación Orientada a la web',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(545,'PRO2545','Propuestas Artísticas Socioeducativas',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(546,'PRO3546','Proyecto Educativo',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(547,'PRO4547','Proyectos de Emprendimientos Socio-productivos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(548,'PRO3548','Proyectos Educativos',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(549,'PRO4549','Proyectos Informáticos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(550,'PSI3550','Psicología de la Creación Dramática',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(551,'PSI4551','Psicología del Aprendizaje',4,4,8,12,1,'CFD','Componente de Formación Docente',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(552,'PSI2552','Psicopedagogía',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(553,'EDU2553','Educación Emocional',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(554,'PRO2554','Problemática Social y Aprendizaje',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(555,'PUB2555','Publicidad y Mercadeo',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(556,'QUÍ4556','Química Analítica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(557,'QUÍ4557','Química Analítica Instrumental',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(558,'QUÍ3558','Química Aplicada a la Biología',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(559,'QUÍ3559','Química Básica',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(560,'QUÍ4560','Química Básica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(561,'QUÍ2561','Química General',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(562,'QUÍ4562','Química Inorgánica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(563,'QUÍ4563','Química Inorgánica Avanzada',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(564,'QUÍ4564','Química Orgánica I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(565,'QUÍ4565','Química Orgánica Ii',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(566,'REC2566','Recreación',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(567,'REC2567','Recursos didácticos para Lenguas Extranjeras o Est. Instruc. Para LE',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(568,'REC3568','Recursos para el aprendizaje',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(569,'RED4569','Circuitos Eléctricos I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(570,'RED4570','Circuitos Eléctricos II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(571,'RED4571','Redes Eléctricas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(572,'RED4572','Redes Informáticas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(573,'REF2573','Refrigeración y Aire Acondicionado',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(574,'RES3574','Resolución de Problemas.',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(575,'RIG2575','Rigor y formalización en matemática',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(576,'ROB3576','Robótica',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(577,'RUR3577','Ruralidad',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(578,'CUL3578','Cultura Campesina Andina',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(579,'DES3579','Desarrollo Rural Sustentable',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(580,'TEC3580','Tecnologías Campesinas',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(581,'SAB2581','Saber, Ambiente y Sustentabilidad',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(582,'AMB2582','Ambiente, Sociedad y Cultura',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(583,'COM2583','Comprensión de Sistemas Ambientales',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(584,'SAB2584','Saber Ambiental en Contextos de Cotidianidad',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(586,'SAL3586','Salud integral',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(587,'SAL3587','Salud Integral y Espiritualidad',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(588,'SAL3588','Salud Preventiva',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(589,'SEG2589','Seguridad Industrial',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(590,'SEG2590','Seguridad Industrial',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(591,'IDI2591','Idioma B Francés',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(592,'SEM2592','Seminario de estudios de caso',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(593,'SEM3593','Seminario de Investigación',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(594,'SEM2594','Seminario de Lectura y Escritura',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(595,'SEM3595','Seminario de Teatro',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(596,'SEM2596','Seminario de Técnicas de Traducción',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(597,'SEX3597','Sexualidad',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(598,'SEX2598','Sexualidad',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(599,'SIM3599','Simulación Empresarial',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(600,'SIS3600','Sistemas de Distribución',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(601,'SIS4601','Sistemas de Información',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(602,'SIS3602','Sistemas de Potencia',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(603,'SIS4603','Sistemas de Producción Hortícola',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(604,'SIS4604','Sistemas de Producción Vegetal',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(605,'SIS3605','Sistemas de Protección',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(606,'SIS4606','Sistemas Digitales I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(607,'SIS4607','Sistemas Digitales II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(608,'SIS4608','Sistemas numéricos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(609,'SIS2609','Sistemas operativos',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(610,'SIS4610','Sistemas productivos agrícolas',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(611,'SOC4611','Sociedad y Educación',4,4,8,12,1,'CFD','Componente de Formación Docente',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(612,'SUE4612','Suelos y Abonos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(613,'TAL4613','Taller Básico Rural I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(614,'TAL4614','Taller básico rural II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(615,'TAL2615','Taller de Expresión Artística',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(616,'TAL2616','Taller de Expresión Artística Integral',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(617,'TAL4617','Taller de Expresión Plástica I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(618,'TAL4618','Taller de expresión plástica II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(619,'TAL3619','Taller de Juegos Escénicos',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(620,'TAL4620','Taller De Teatro Infantil',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(621,'TAL4621','Taller de Teatro Latinoamericano',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(622,'TAL4622','Taller De Teatro Venezolano',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(623,'TEC4623','Tecnología de la Energía',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(624,'TEC4624','Tecnología de la Información Geográfica',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(625,'TEC4625','Tecnología de los Materiales Industriales',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(626,'TEC4626','Tecnología e innovación artística',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(627,'TEC4627','Tecnología Mecánica I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(628,'TEC4628','Tecnología Mecánica II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(629,'TEC4629','Tecnología mecánica III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(630,'TEC4630','Tecnología Teatral',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(631,'TEC2631','Tecnologías para la accesibilidad',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(632,'TEN4632','Tendencias de la Lingüística',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(633,'TEO4633','Teoría de la Forma',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(634,'TEO2634','Teoría Literaria',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(635,'TEO4635','Teoría y Práctica de la Educación  Física',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(636,'TEO4636','Teoría y Práctica de la Motricidad Humana',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(637,'TEO2637','Teoría y Praxis de la educación Intercultural Bilingüe',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(638,'TEO2638','Teoría, Análisis Plástico y Crítica de Arte',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(639,'TEO4639','Teorías Aplicadas al Compromiso con el Emprendimiento Social',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(640,'TIC3640','Tic en Educación Inicial',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(641,'TIC4641','TIC I',4,4,8,12,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(642,'TIC4642','TIC II',4,4,8,12,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(643,'TIC4643','TIC III',4,4,8,12,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(644,'TIC4644','TIC IV',4,4,8,12,4,'SCF','Sin Componente de Formacion',3,'ECU','Eje Curricular',1,'Por Definir Rectorado'),(645,'TÓP2645','Tópicos de Trigonometría',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(646,'TOP4646','Topografía y riego',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(647,'TRA2647','Trabajo Experimental En El Laboratorio',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(648,'TRA4648','Transición de Preescolar  a primer grado',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(649,'TUR2649','Turismo Sustentable',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(650,'TUR3650','Turismo y Rentas  Municipales',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(651,'TUR2651','Turismo, Hotelería y Desarrollo Sustentable',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(652,'USO3652','Uso y manejo del suelo como recurso natural',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(653,'VIS4653','Visiones de la Literatura',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(654,'VOL3654','Voleibol para la Educación',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(655,'ABO2655','Abordaje Pedagógico de la Situación de Discapacidad en la Adolescencia y la Adultez.',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(656,'ABO2656','Abordaje Pedagógico de la Situación de Discapacidad en la Edad Escolar (6 a 12 años)',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(657,'ABO2657','Abordaje Pedagógico de la Situación de Discapacidad en la Primera Infancia (0 a 6 años)',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(658,'ABO3658','Abordaje Pedagógico del Lenguaje',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(659,'ABO2659','Abordaje Pedagógico Diferencial I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(660,'ABO2660','Abordaje Pedagógico Diferencial II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(661,'ADA2661','Adaptaciones Curriculares',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(662,'ANÁ2662','Análisis Conductual Aplicado a la Educación',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(663,'ASE3663','Asesoramiento Familiar y Ciudadano',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(664,'ASE2664','Asesoría para la Colocación Laboral',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(665,'AUT1665','Autismo',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(666,'BIO1666','Bioética y Diversidad',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(667,'CIC2667','Ciclo Vital y Calidad de Vida',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(668,'COM2668','Comunidad Sorda en Venezuela y el Mundo',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(669,'CUL2669','Cultura Sordera y Educación',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(670,'DES2670','Desarrollo de Procesos Cognitivos de las Personas en Situación de Discapacidad',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(671,'DES2671','Desarrollo Infantil  y sus Desviaciones',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(672,'DES2672','Desarrollo Lingüístico del Sordo',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(673,'DES1673','Desarrollo Social y Emocional',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(674,'DES1674','Desarrollo Socioemocional',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(675,'DIS2675','Discapacidad Intelectual y del Desarrollo',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(676,'DIS2676','Discapacidad Visual',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(677,'DIS2677','Discapacidad y Diferencia',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(678,'DIS3678','Discapacidad y Recreación',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(679,'DIS2679','Discapacidades Múltiples',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(680,'DIS3680','Discurso Especializado del Idioma Inglés',4,4,8,12,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(681,'EDU2681','Educación Corporal',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(682,'EDU2682','Educación Especial',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(683,'EDU3683','Educación Especial y Salud',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(684,'EDU3684','Educación Musical',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(685,'EDU2685','Educación para la Diversidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(686,'EDU2686','Educación para Sordos I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(687,'EDU2687','Educación para Sordos II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(688,'EDU2688','Educación para Sordos III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(689,'EDU2689','Educación y Discapacidad en Venezuela',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(690,'ESP2690','Español como Segunda Lengua en la \nEducación del Sordo I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(691,'ESP2691','Español como Segunda Lengua en la Educación del Sordo II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(692,'EST3692','Estrategias y Recursos para  la  Discapacidad Intelectual y del Desarrollo',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(693,'EVA2693','Evaluación de la Situación de Discapacidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(694,'EVA2694','Evaluación del Sordo en \nContextos Educativos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(695,'FOR2695','Formación Comunitaria en Discapacidad',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(696,'FOR2696','Formación del Tutor para la Educación\nInclusiva',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(697,'FOR2697','Formación e Inserción Laboral de Personas con Discapacidad.',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(698,'GRA2698','Gramática del Español de Venezuela',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(699,'LA 3699','La Familia en la Escuela de Sordos',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(700,'LEG2700','Legislación de la Educación Especial',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(701,'LEN3701','Lengua de Señas Venezolana',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(702,'LEN2702','Lengua de Señas Venezolana I',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(703,'LEN2703','Lengua de Señas Venezolana II',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(704,'LEN2704','Lengua de Señas Venezolana III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(705,'LEN2705','Lengua de Señas Venezolana IV',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(706,'LEN2706','Lengua de Señas Venezolana V',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(707,'MED3707','Mediación Lingüística en la Escuela de Sordos',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(708,'MED2708','Medio Físico y Discapacidad',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(709,'NEU2709','Neurociencia',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(710,'NEU2710','Neuropsicología',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(711,'ORI2711','Orientación para  la Atención de Personas \nen Situación de Discapacidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(712,'PER1712','Perspectiva  Educativa de la Discapacidad Motora',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(713,'PER2713','Perspectiva de la Situación de Discapacidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(714,'PRE2714','Prevención de la Discapacidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(715,'PRE1715','Prevención de la Situación de Discapacidad',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(716,'PSI2716','Psicología Evolutiva',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(717,'SEM2717','Seminario de Educación Inicial',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(718,'SIS3718','Sistema Braille',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(719,'SIS3719','Sistemas Aumentativos de Comunicación',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(720,'SOR1720','Sordera y Discapacidades Múltiples',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(721,'SOR2721','Sordera y Salud Pública',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(722,'SOR3722','Sordoceguera',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(723,'TEN2723','Tendencias Actuales y Futuras para la Atención \nde la Persona en Situación de Discapacidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(724,'TEO1724','Teorías e Ideas Pedagógicas',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(725,'TRA3725','Trabajo Productivo en la Escuela de Sordos',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(726,'VAL2726','Valoración de las Capacidades de las Personas con DID',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(727,'VEJ1727','Vejez y Desarrollo de la Persona en Situación de Discapacidad',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(728,'VIS2728','Visión socio Antropológica de la Discapacidad',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(756,'LEN3756','Lenguaje y Pensamiento',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(757,'CIU0001','Curso de Iniciación Universitaria',0,0,0,0,4,'SCF','Sin Componente de Formacion',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(758,'BAS0506','Base de Datos',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(759,'DIS0405','Discapacidad y Diferencia',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(760,'REP0296','Repertorio Tradicional Vanezolano',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(761,'DES2582','Desarrollo del Lenguaje del NIño de 0 a 7 Años',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(762,'TOP1412','Tópicos de Trigonometría',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(763,'EDU1217','Educación y Escenarios Convencionales y No Convencionales',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(764,'INF6448','Infoética y Ciudadanía Digital',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(765,'TAL8725','Taller de Lectura y Escritura Académica',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(766,'DES9687','Desarrollo de Habilidades para la Escucha y Promoción de la Lectura en el Aula por Cultura Regional y Literatura',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(767,'MUS6541','Música Regional',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(768,'REC3225','Recursos Didácticos para la Educación Inicial',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(769,'LAL5987','La Ludoteca',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(770,'EDU5486','Educación Musical para Inicial por Lúdica en la Lectura y Escritura',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(771,'EDU0101','Educación Alimentaria y Nutricional',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(772,'VEN1208','Venezuela Espacio y Tiempo',4,4,8,12,1,'CFD','Componente de Formación Docente',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(773,'PAT0204','Patrimonio Cultural e Identidad',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(774,'MAT4454','Matemática General',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(775,'IDI2592','Idioma B Italiano',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(778,'IDI2593','Idioma B Portugués',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(779,'TEC4631','Tecnología de los Materiales Eléctricos',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(780,'PED2552','Pedagogía Prenatal',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(782,'PRE4455','Precalculo',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(783,'ELE2207','Modelos Gerenciales en Electricidad',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(785,'ETV5487','Educación Técnica en Venezuela',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(786,'IPR4377','Introducción a la Programación',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(787,'DIB2140','Dibujo Eléctrico y Electrónico',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(789,'ELT2207','Electrometría',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(790,'EMB2210','Embobinado de Máquinas Eléctricas',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(791,'ELC2211','Teoría Electromagnética',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(792,'RED4578','Circuitos Eléctricos III',4,4,8,12,2,'CFPE','Componente de Formación Profesional Específico',1,'UNCO','Unidad Curricular Obligatoria',1,'Por Definir Rectorado'),(793,'DESC4120','Gestión Curricular',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(794,'EBI4420','Educación Bioética y Derechos Humanos',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(795,'AFE4421','Articulación, Familia y Escuela',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(796,'CUL2122','Cultura Regional y Formación Docente',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(797,'CIRL4022','Circuitos Lógicos',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(798,'EFE4021','Eficiencia Energética',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(799,'INS4021','Instrumentación Industrial',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(800,'DID4149','Didáctica de la Electricidad Industrial',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(801,'DIS4166','Diseño de Recursos para la Enseñanza de la Electricidad',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(802,'INN3380','Innovaciones Pedagógicas y Tecnológicas',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(803,'DID4543','Programación Didáctica Crítico Constructivista',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(804,'ETP4422','Ética y Pedagogía Crítica',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(805,'EST4420','Estimulación y Motivación del Desarrollo Humano',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(806,'PLAE2502','Planificación Prospectiva en la Educación',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(807,'FUD4423','Fundamentos del Derecho Laboral Educativo',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(808,'EST3693','Estrategias Metacognitivas para el Aprendizaje',2,2,4,6,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(809,'LID3410','Liderazgo Magisterial y Oratoria',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(810,'MCE4473','Microprocesadores Eléctricos',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(811,'INS4364','Instalaciones Eléctricas II',3,3,6,9,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(812,'SIS4825','Sistema de Puesta a Tierra',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(813,'MYA2220','Media y Alta Tensión',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(814,'AII2307','Automatización Inteligente Industrial',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(815,'MCT2207','Mecatrónica',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(817,'IEA4466','Interdisciplinariedad en la Enseñanza Aprendizaje de la Ciencia',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(818,'APR4034','Aprendizaje Autónomo',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(819,'GERE4522','Competencias Gerenciales en el Contexto Educativo',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(820,'TEO4452','Teoría del Conocimiento Pedagógico',3,3,6,9,1,'CFD','Componente de Formación Docente',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(821,'SIS4425','Sistema Educativo Venezolano',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(822,'ELC2220','Centrales y SubEstaciones Eléctricas',3,3,6,9,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(823,'PER2714','Perspectivas de Análisis Literario',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(824,'TEO4463','La Teoría Literaria y su Recepción',2,2,4,6,2,'CFPE','Componente de Formación Profesional Específico',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(826,'LEN3702','Lengua de Señas Venezolana Instrumental',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(827,'BIO4064','Biogeografía',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado'),(828,'HIS4342','Historia del Pensamiento Político',2,2,4,6,3,'CFC','Componente de Formación Contextualizado',2,'UNCLE','Unidad Curricular de Libre Elección',1,'Por Definir Rectorado');
/*!40000 ALTER TABLE `hata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hist_egresado`
--

DROP TABLE IF EXISTS `hist_egresado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hist_egresado` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `promocion_id` int(11) DEFAULT NULL,
  `indice` double DEFAULT NULL,
  `posicion_gen` int(11) DEFAULT NULL,
  `total_gen` int(11) DEFAULT NULL,
  `posicion_esp` int(11) DEFAULT NULL,
  `total_esp` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `nrofolio` varchar(50) NOT NULL,
  `nrotitulo` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_F6D772D359590C39` (`estudiante_id`),
  KEY `IDX_F6D772D3B1E453D4` (`promocion_id`),
  KEY `IDX_F6D772D380B24165` (`lapso_id`),
  CONSTRAINT `FK_F6D772D359590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `FK_F6D772D380B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_F6D772D3B1E453D4` FOREIGN KEY (`promocion_id`) REFERENCES `promociones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hist_egresado`
--

LOCK TABLES `hist_egresado` WRITE;
/*!40000 ALTER TABLE `hist_egresado` DISABLE KEYS */;
/*!40000 ALTER TABLE `hist_egresado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hist_matri`
--

DROP TABLE IF EXISTS `hist_matri`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hist_matri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `curso_id` int(11) DEFAULT NULL,
  `condicion_id` int(11) DEFAULT NULL,
  `programa_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `especialidad_id` int(11) DEFAULT NULL,
  `seccion` varchar(20) NOT NULL,
  `nota` int(11) NOT NULL,
  `uc` int(11) NOT NULL,
  `obs` varchar(255) NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `matricula_id` int(11) DEFAULT NULL,
  `grupo` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_8EFDE2FA59590C39` (`estudiante_id`),
  KEY `IDX_8EFDE2FA80B24165` (`lapso_id`),
  KEY `IDX_8EFDE2FA87CB4A1F` (`curso_id`),
  KEY `IDX_8EFDE2FA2A0E31F6` (`condicion_id`),
  KEY `IDX_8EFDE2FAFD8A7328` (`programa_id`),
  KEY `IDX_8EFDE2FAE19F41BF` (`sede_id`),
  KEY `IDX_8EFDE2FA16A490EC` (`especialidad_id`),
  KEY `IDX_8EFDE2FA613FECDF` (`session_id`),
  KEY `IDX_8EFDE2FA15C84B52` (`matricula_id`),
  CONSTRAINT `FK_8EFDE2FA15C84B52` FOREIGN KEY (`matricula_id`) REFERENCES `matricula` (`id`),
  CONSTRAINT `FK_8EFDE2FA16A490EC` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`),
  CONSTRAINT `FK_8EFDE2FA2A0E31F6` FOREIGN KEY (`condicion_id`) REFERENCES `cod_curso` (`id`),
  CONSTRAINT `FK_8EFDE2FA59590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `FK_8EFDE2FA613FECDF` FOREIGN KEY (`session_id`) REFERENCES `sessiones` (`id`),
  CONSTRAINT `FK_8EFDE2FA80B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_8EFDE2FA87CB4A1F` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`),
  CONSTRAINT `FK_8EFDE2FAE19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`),
  CONSTRAINT `FK_8EFDE2FAFD8A7328` FOREIGN KEY (`programa_id`) REFERENCES `programa` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hist_matri`
--

LOCK TABLES `hist_matri` WRITE;
/*!40000 ALTER TABLE `hist_matri` DISABLE KEYS */;
INSERT INTO `hist_matri` VALUES (3,4986,55,382,3,1,1,10,'1',10,4,'Pasado Matricula 2019-I',NULL,54,NULL),(24,4984,1,120,4,1,1,1,'14',2,4,'Pasado Matricula 2017-II',NULL,59,NULL),(25,4983,1,120,3,1,1,3,'14',6,4,'Pasado Matricula 2017-II',NULL,58,NULL),(27,4,1,641,3,1,1,11,'',8,4,'',NULL,62,NULL),(28,4,55,937,3,1,1,11,'1',9,4,'',NULL,63,NULL),(29,4,56,156,3,1,1,11,'1',8,4,'',NULL,64,NULL),(30,4,1,476,3,1,1,11,'1',6,4,'Pasado Matricula 2017-II',NULL,65,NULL),(31,5,1,641,3,1,1,1,'1',7,4,'Pasado Matricula 2017-II',NULL,66,NULL),(32,3,1,29,3,1,1,8,'1',8,4,'Pasado Matricula 2017-II',NULL,81,NULL),(33,3,1,292,3,1,1,8,'1',7,4,'Pasado Matricula 2017-II',NULL,82,NULL),(34,3,1,757,3,1,1,8,'1',6,0,'Pasado Matricula 2017-II',NULL,83,NULL),(35,10,55,120,3,1,1,19,'1',8,4,'Pasado Matricula 2019-I',NULL,85,NULL),(36,11,55,120,3,1,1,19,'1',7,4,'Pasado Matricula 2019-I',NULL,86,NULL),(37,7,1,611,3,1,1,19,'1',9,4,'Pasado Matricula 2017-II',NULL,87,NULL),(38,5,1,120,4,1,1,1,'1',3,4,'Pasado Matricula 2017-II',NULL,77,NULL);
/*!40000 ALTER TABLE `hist_matri` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hist_matri_egresado`
--

DROP TABLE IF EXISTS `hist_matri_egresado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hist_matri_egresado` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `curso_id` int(11) DEFAULT NULL,
  `condicion_id` int(11) DEFAULT NULL,
  `programa_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `especialidad_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `seccion` varchar(20) DEFAULT NULL,
  `grupo` varchar(1) DEFAULT NULL,
  `nota` int(11) NOT NULL,
  `uc` int(11) NOT NULL,
  `obs` varchar(255) NOT NULL,
  `subsede_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_85FD2BEC59590C39` (`estudiante_id`),
  KEY `IDX_85FD2BEC80B24165` (`lapso_id`),
  KEY `IDX_85FD2BEC87CB4A1F` (`curso_id`),
  KEY `IDX_85FD2BEC2A0E31F6` (`condicion_id`),
  KEY `IDX_85FD2BECFD8A7328` (`programa_id`),
  KEY `IDX_85FD2BECE19F41BF` (`sede_id`),
  KEY `IDX_85FD2BEC16A490EC` (`especialidad_id`),
  KEY `IDX_85FD2BEC613FECDF` (`session_id`),
  KEY `IDX_85FD2BECAAFDE970` (`subsede_id`),
  CONSTRAINT `FK_85FD2BEC16A490EC` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`),
  CONSTRAINT `FK_85FD2BEC2A0E31F6` FOREIGN KEY (`condicion_id`) REFERENCES `cod_curso` (`id`),
  CONSTRAINT `FK_85FD2BEC59590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `FK_85FD2BEC613FECDF` FOREIGN KEY (`session_id`) REFERENCES `sessiones` (`id`),
  CONSTRAINT `FK_85FD2BEC80B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_85FD2BEC87CB4A1F` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`),
  CONSTRAINT `FK_85FD2BECAAFDE970` FOREIGN KEY (`subsede_id`) REFERENCES `subsede` (`id`),
  CONSTRAINT `FK_85FD2BECE19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`),
  CONSTRAINT `FK_85FD2BECFD8A7328` FOREIGN KEY (`programa_id`) REFERENCES `programa` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hist_matri_egresado`
--

LOCK TABLES `hist_matri_egresado` WRITE;
/*!40000 ALTER TABLE `hist_matri_egresado` DISABLE KEYS */;
/*!40000 ALTER TABLE `hist_matri_egresado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `item`
--

DROP TABLE IF EXISTS `item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `item`
--

LOCK TABLES `item` WRITE;
/*!40000 ALTER TABLE `item` DISABLE KEYS */;
INSERT INTO `item` VALUES (1,'Estudiantes'),(2,'Profesores'),(3,'Oferta Académica'),(4,'Gestión de Datos'),(5,'Configuración'),(6,'Reportes'),(7,'Usuarios'),(8,'Estudiante'),(9,'Profesor'),(10,'Calificaciones'),(11,'Graduandos/Egresados');
/*!40000 ALTER TABLE `item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lapso`
--

DROP TABLE IF EXISTS `lapso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `lapso` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `activo` tinyint(1) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `fecha_inicial` varchar(15) DEFAULT NULL,
  `fecha_final` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9494C39BE19F41BF` (`sede_id`),
  CONSTRAINT `FK_9494C39BE19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lapso`
--

LOCK TABLES `lapso` WRITE;
/*!40000 ALTER TABLE `lapso` DISABLE KEYS */;
INSERT INTO `lapso` VALUES (1,'2017-II',1,1,'2017-12-03','31-12-2020'),(55,'2019-I',0,1,'21-06-1913','20-06-2020'),(56,'2019-II',0,1,'2018-11-07','31-12-2020'),(57,'2020-I',0,1,'2018-10-31','2018-11-01'),(58,'2021-I',0,1,'2018-11-07','2018-11-06'),(62,'2022-I',NULL,1,NULL,NULL),(63,'2022-II',NULL,1,NULL,NULL),(64,'2023-I',NULL,1,NULL,NULL);
/*!40000 ALTER TABLE `lapso` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `matricula`
--

DROP TABLE IF EXISTS `matricula`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `matricula` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estudiante_id` int(11) DEFAULT NULL,
  `oferta_id` int(11) DEFAULT NULL,
  `traslado_id` int(11) DEFAULT NULL,
  `condicion_id` int(11) DEFAULT NULL,
  `nota` int(11) NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL,
  `cargas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_15DF188559590C39` (`estudiante_id`),
  KEY `IDX_15DF1885FAFBF624` (`oferta_id`),
  KEY `IDX_15DF18852A0E31F6` (`condicion_id`),
  KEY `IDX_15DF1885613FECDF` (`session_id`),
  KEY `traslado_id` (`traslado_id`),
  CONSTRAINT `FK_15DF18852A0E31F6` FOREIGN KEY (`condicion_id`) REFERENCES `cod_curso` (`id`),
  CONSTRAINT `FK_15DF188559590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `espe_estud` (`id`),
  CONSTRAINT `FK_15DF1885613FECDF` FOREIGN KEY (`session_id`) REFERENCES `sessiones` (`id`),
  CONSTRAINT `FK_15DF1885FAFBF624` FOREIGN KEY (`oferta_id`) REFERENCES `ofer_acade` (`id`),
  CONSTRAINT `matricula_ibfk_1` FOREIGN KEY (`traslado_id`) REFERENCES `traslado` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `matricula`
--

LOCK TABLES `matricula` WRITE;
/*!40000 ALTER TABLE `matricula` DISABLE KEYS */;
INSERT INTO `matricula` VALUES (54,4986,7834,NULL,3,10,NULL,NULL,0),(58,4983,7817,NULL,3,6,NULL,'Modificado',0),(59,4984,7817,NULL,4,2,NULL,'Incluido',0),(62,4,7841,NULL,3,8,NULL,NULL,2),(63,4,7842,NULL,3,9,NULL,NULL,0),(64,4,7843,NULL,3,8,NULL,NULL,0),(65,4,7844,NULL,3,6,NULL,NULL,2),(66,5,7836,NULL,3,7,NULL,'Modificado',1),(77,5,7848,NULL,4,3,NULL,'Actualizado',2),(81,3,7845,NULL,3,8,NULL,NULL,0),(82,3,7846,NULL,3,7,NULL,NULL,0),(83,3,7849,NULL,3,6,NULL,NULL,0),(85,10,7850,NULL,3,8,NULL,NULL,2),(86,11,7850,NULL,3,7,NULL,NULL,2),(87,7,7847,NULL,3,9,NULL,'Actualizado',2),(100,10,7860,NULL,2,1,NULL,NULL,NULL),(107,13,7847,NULL,2,1,NULL,NULL,NULL),(108,13,7865,NULL,2,1,NULL,NULL,NULL),(109,11,7865,NULL,2,1,NULL,NULL,NULL),(110,2,7866,NULL,2,1,NULL,NULL,NULL),(113,2,7860,NULL,2,1,NULL,NULL,NULL),(114,2,7852,NULL,2,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `matricula` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `matriz_horario`
--

DROP TABLE IF EXISTS `matriz_horario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `matriz_horario` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dia_id` int(11) DEFAULT NULL,
  `hora_id` int(11) DEFAULT NULL,
  `codigo` varchar(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_3B6DF91AC1F7597` (`dia_id`),
  KEY `IDX_3B6DF91451F5F98` (`hora_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `matriz_horario`
--

LOCK TABLES `matriz_horario` WRITE;
/*!40000 ALTER TABLE `matriz_horario` DISABLE KEYS */;
/*!40000 ALTER TABLE `matriz_horario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_usuario`
--

DROP TABLE IF EXISTS `menu_usuario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_usuario` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `submenu_id` int(11) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_AABEADE387B541DD` (`submenu_id`),
  KEY `IDX_AABEADE3DB38439E` (`usuario_id`),
  CONSTRAINT `FK_AABEADE387B541DD` FOREIGN KEY (`submenu_id`) REFERENCES `sub_items` (`id`),
  CONSTRAINT `FK_AABEADE3DB38439E` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=718 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_usuario`
--

LOCK TABLES `menu_usuario` WRITE;
/*!40000 ALTER TABLE `menu_usuario` DISABLE KEYS */;
INSERT INTO `menu_usuario` VALUES (1,33,1),(2,1,1),(3,3,1),(5,4,1),(7,6,1),(8,7,1),(9,8,1),(10,9,1),(11,10,1),(12,11,1),(13,12,1),(14,13,1),(15,14,1),(16,15,1),(17,16,1),(18,17,1),(19,18,1),(20,19,1),(21,20,1),(22,21,1),(23,22,1),(25,24,1),(26,25,1),(27,26,1),(28,27,1),(30,29,1),(31,30,1),(33,32,1),(34,33,1),(38,24,48),(39,25,48),(40,26,48),(41,27,48),(42,29,48),(43,30,48),(45,3,48),(46,2,48),(47,1,48),(48,1,49),(49,2,49),(50,3,49),(51,22,49),(52,24,49),(53,25,49),(54,26,49),(56,27,49),(57,30,49),(58,29,49),(60,32,49),(61,33,49),(62,34,49),(63,4,49),(64,5,49),(65,6,49),(66,7,49),(67,9,49),(68,11,49),(69,14,49),(70,13,49),(71,16,49),(72,15,49),(73,17,49),(74,18,49),(75,19,49),(76,20,49),(77,21,49),(78,1,50),(79,2,50),(80,3,50),(81,4,50),(82,5,50),(95,21,50),(96,32,50),(97,33,50),(98,34,50),(100,24,50),(101,25,50),(102,26,50),(103,27,50),(104,29,50),(105,30,50),(106,22,50),(108,2,1),(109,34,1),(114,48,1),(128,49,50),(129,48,50),(130,49,1),(131,5,1),(132,50,1),(135,51,1),(136,50,55),(137,32,57),(138,33,57),(141,49,57),(142,52,1),(143,19,50),(144,52,50),(145,50,50),(146,51,50),(147,20,50),(148,9,50),(149,11,50),(150,13,50),(151,14,50),(152,15,50),(153,17,50),(154,16,50),(155,18,50),(156,22,58),(157,6,58),(158,7,58),(159,51,58),(161,49,58),(162,7,50),(163,6,50),(165,53,1),(166,35,1),(167,36,1),(170,38,1),(171,39,1),(172,28,1),(177,40,1),(178,31,1),(182,46,1),(183,45,1),(184,41,1),(187,54,1),(188,55,1),(189,56,1),(190,42,1),(191,43,1),(194,57,1),(195,1,77),(196,2,77),(197,3,77),(198,40,77),(199,50,77),(200,54,77),(201,57,77),(202,4,77),(203,5,77),(204,42,77),(205,6,77),(206,7,77),(207,51,77),(210,13,77),(211,14,77),(212,15,77),(213,16,77),(214,17,77),(215,18,77),(216,19,77),(217,20,77),(218,21,77),(219,41,77),(220,35,77),(221,36,77),(222,32,77),(223,34,77),(224,33,77),(225,43,77),(226,49,77),(227,24,77),(228,25,77),(229,26,77),(230,27,77),(231,28,77),(232,30,77),(233,29,77),(234,31,77),(235,38,77),(236,39,77),(237,45,77),(238,46,77),(239,48,77),(240,52,77),(241,53,77),(242,55,77),(243,56,77),(244,1,78),(245,2,78),(246,3,78),(247,40,78),(248,50,78),(249,54,78),(250,57,78),(251,4,78),(252,5,78),(253,42,78),(254,6,78),(255,7,78),(256,51,78),(257,13,78),(258,14,78),(259,15,78),(260,16,78),(261,17,78),(262,18,78),(263,19,78),(264,20,78),(265,21,78),(266,41,78),(267,35,78),(268,36,78),(269,32,78),(270,33,78),(271,34,78),(272,49,78),(273,43,78),(274,24,78),(275,25,78),(276,26,78),(277,27,78),(278,28,78),(279,29,78),(280,30,78),(281,38,78),(282,31,78),(283,39,78),(284,45,78),(285,46,78),(286,48,78),(287,52,78),(288,53,78),(289,55,78),(290,56,78),(291,1,79),(292,2,79),(293,3,79),(294,40,79),(295,50,79),(296,54,79),(297,4,79),(298,5,79),(299,57,79),(300,42,79),(301,6,79),(302,51,79),(303,7,79),(304,13,79),(305,14,79),(306,15,79),(307,17,79),(308,18,79),(309,19,79),(310,20,79),(311,21,79),(312,16,79),(313,41,79),(314,35,79),(315,36,79),(316,32,79),(317,33,79),(318,34,79),(319,43,79),(320,49,79),(321,24,79),(322,25,79),(323,26,79),(324,27,79),(325,28,79),(326,29,79),(327,30,79),(328,38,79),(329,31,79),(330,39,79),(331,45,79),(332,46,79),(333,48,79),(334,52,79),(335,53,79),(336,55,79),(337,56,79),(338,1,80),(339,41,80),(340,2,80),(341,3,80),(342,40,80),(343,50,80),(344,54,80),(345,57,80),(346,4,80),(347,5,80),(348,6,80),(349,7,80),(350,51,80),(351,13,80),(352,14,80),(353,15,80),(354,16,80),(355,17,80),(356,18,80),(357,19,80),(358,20,80),(359,21,80),(360,24,80),(361,25,80),(362,26,80),(363,27,80),(364,28,80),(365,29,80),(366,31,80),(367,30,80),(368,38,80),(369,39,80),(370,45,80),(371,46,80),(372,48,80),(373,52,80),(374,53,80),(375,55,80),(376,56,80),(377,32,80),(378,33,80),(379,34,80),(380,43,80),(381,49,80),(382,35,80),(383,36,80),(384,42,80),(385,1,81),(386,3,81),(387,2,81),(388,40,81),(389,54,81),(390,57,81),(391,5,81),(392,4,81),(393,42,81),(394,6,81),(395,7,81),(398,51,81),(399,14,81),(400,50,81),(401,16,81),(402,18,81),(403,19,81),(404,20,81),(405,21,81),(406,41,81),(408,15,81),(409,17,81),(410,13,81),(411,35,81),(412,32,81),(413,33,81),(414,34,81),(415,43,81),(416,49,81),(417,24,81),(418,26,81),(419,27,81),(420,28,81),(421,29,81),(422,25,81),(423,36,81),(424,31,81),(425,39,81),(426,45,81),(427,48,81),(428,52,81),(429,55,81),(430,56,81),(431,30,81),(432,38,81),(433,46,81),(434,53,81),(435,1,82),(436,2,82),(437,3,82),(438,40,82),(439,50,82),(440,54,82),(441,57,82),(442,4,82),(443,5,82),(444,42,82),(445,6,82),(446,51,82),(447,13,82),(448,14,82),(449,16,82),(450,18,82),(451,19,82),(452,20,82),(453,21,82),(454,35,82),(455,36,82),(456,15,82),(457,17,82),(458,7,82),(459,41,82),(460,24,82),(461,25,82),(462,26,82),(463,27,82),(464,28,82),(465,29,82),(466,30,82),(467,31,82),(468,38,82),(469,39,82),(470,45,82),(471,46,82),(472,48,82),(473,52,82),(474,53,82),(475,55,82),(476,56,82),(477,32,82),(478,33,82),(479,34,82),(480,43,82),(481,49,82),(482,1,83),(483,2,83),(484,3,83),(485,40,83),(486,50,83),(487,54,83),(488,57,83),(489,4,83),(490,5,83),(491,6,83),(492,7,83),(493,51,83),(494,13,83),(495,14,83),(496,15,83),(497,16,83),(498,42,83),(499,17,83),(500,18,83),(501,19,83),(502,20,83),(503,21,83),(504,41,83),(505,24,83),(506,25,83),(507,26,83),(508,27,83),(509,28,83),(510,29,83),(511,30,83),(512,31,83),(513,38,83),(514,45,83),(515,46,83),(516,48,83),(517,52,83),(518,53,83),(519,55,83),(520,56,83),(521,39,83),(522,32,83),(523,33,83),(524,34,83),(525,43,83),(526,49,83),(527,35,83),(528,36,83),(529,1,84),(530,2,84),(531,3,84),(532,21,84),(533,41,84),(534,35,84),(535,40,84),(536,50,84),(537,54,84),(538,4,84),(539,5,84),(540,57,84),(541,42,84),(542,6,84),(543,7,84),(544,51,84),(547,13,84),(548,14,84),(549,15,84),(550,16,84),(551,17,84),(552,18,84),(553,20,84),(554,19,84),(555,36,84),(556,32,84),(557,33,84),(558,34,84),(559,43,84),(560,49,84),(561,24,84),(562,25,84),(563,26,84),(564,27,84),(565,28,84),(566,29,84),(567,30,84),(568,31,84),(569,38,84),(570,39,84),(571,45,84),(572,46,84),(573,48,84),(574,52,84),(575,53,84),(576,55,84),(577,56,84),(578,1,85),(579,2,85),(580,3,85),(581,40,85),(582,50,85),(583,54,85),(584,57,85),(585,4,85),(586,5,85),(587,42,85),(588,6,85),(589,7,85),(590,51,85),(591,13,85),(592,14,85),(593,16,85),(594,15,85),(595,17,85),(596,18,85),(597,20,85),(598,41,85),(599,19,85),(600,21,85),(601,24,85),(602,25,85),(603,26,85),(604,27,85),(605,28,85),(606,29,85),(607,30,85),(608,31,85),(609,38,85),(610,45,85),(611,46,85),(612,48,85),(613,52,85),(614,53,85),(615,55,85),(616,56,85),(617,39,85),(618,32,85),(619,33,85),(620,43,85),(621,34,85),(622,49,85),(623,36,85),(624,35,85),(631,17,53),(632,18,53),(633,19,53),(637,41,53),(638,58,1),(639,59,1),(641,7,53),(644,51,53),(651,1,86),(652,2,86),(653,3,86),(654,40,86),(655,50,86),(656,54,86),(657,57,86),(658,58,86),(659,4,86),(660,42,86),(661,7,86),(662,51,86),(663,11,86),(664,59,86),(665,13,86),(666,14,86),(667,16,86),(668,17,86),(669,18,86),(670,20,86),(671,15,86),(672,21,86),(673,41,86),(675,19,86),(676,22,86),(677,5,86),(678,24,86),(679,25,86),(680,27,86),(681,28,86),(682,29,86),(683,30,86),(684,38,86),(685,45,86),(686,46,86),(687,48,86),(688,52,86),(689,53,86),(690,55,86),(691,31,86),(692,39,86),(693,32,86),(694,56,86),(695,34,86),(696,43,86),(697,49,86),(701,6,86),(702,9,86),(704,26,86),(705,33,86),(706,65,49),(707,62,1),(709,64,1),(710,66,1),(711,65,1),(712,63,1),(713,67,1),(714,68,1),(715,69,1),(716,70,1),(717,71,1);
/*!40000 ALTER TABLE `menu_usuario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `modalidad`
--

DROP TABLE IF EXISTS `modalidad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `modalidad` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `modalidad`
--

LOCK TABLES `modalidad` WRITE;
/*!40000 ALTER TABLE `modalidad` DISABLE KEYS */;
INSERT INTO `modalidad` VALUES (1,'Presencial'),(3,'Mixta');
/*!40000 ALTER TABLE `modalidad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `modo_transcripcion`
--

DROP TABLE IF EXISTS `modo_transcripcion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `modo_transcripcion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(25) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `modo_transcripcion`
--

LOCK TABLES `modo_transcripcion` WRITE;
/*!40000 ALTER TABLE `modo_transcripcion` DISABLE KEYS */;
INSERT INTO `modo_transcripcion` VALUES (1,'Cuantitativo'),(2,'Cualitativo');
/*!40000 ALTER TABLE `modo_transcripcion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `monto_curso`
--

DROP TABLE IF EXISTS `monto_curso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `monto_curso` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sede_id` int(11) DEFAULT NULL,
  `monto` double NOT NULL,
  `programa_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E0AFC1ADE19F41BF` (`sede_id`),
  KEY `IDX_E0AFC1ADFD8A7328` (`programa_id`),
  CONSTRAINT `FK_E0AFC1ADE19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`),
  CONSTRAINT `FK_E0AFC1ADFD8A7328` FOREIGN KEY (`programa_id`) REFERENCES `programa` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `monto_curso`
--

LOCK TABLES `monto_curso` WRITE;
/*!40000 ALTER TABLE `monto_curso` DISABLE KEYS */;
/*!40000 ALTER TABLE `monto_curso` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `municipios`
--

DROP TABLE IF EXISTS `municipios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `municipios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `estado_id` int(11) DEFAULT NULL,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_BBFAB58620332D99` (`codigo`),
  KEY `IDX_BBFAB5869F5A440B` (`estado_id`),
  CONSTRAINT `FK_BBFAB5869F5A440B` FOREIGN KEY (`estado_id`) REFERENCES `estados` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=286 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `municipios`
--

LOCK TABLES `municipios` WRITE;
/*!40000 ALTER TABLE `municipios` DISABLE KEYS */;
INSERT INTO `municipios` VALUES (1,1,'100','Municipio Autónomo Alto Orinoco'),(2,1,'101','Municipio Autónomo Atabapo'),(3,1,'102','Municipio Autónomo Atures'),(4,1,'103','Municipio Autónomo Autana'),(5,1,'104','Municipio Autónomo Manapiare'),(6,1,'105','Municipio Autónomo Río Negro'),(7,1,'106','Municipio Maroa'),(8,2,'107','Municipio Anaco'),(9,2,'108','Municipio Aragua'),(10,2,'109','Municipio Fernando de Peñalver'),(11,2,'110','Municipio Francisco de Miranda'),(12,2,'111','Municipio Francisco del Carmen Carvajal'),(13,2,'112','Municipio Guanta'),(14,2,'113','Municipio Independencia'),(15,2,'114','Municipio José Gregorio Monagas'),(16,2,'115','Municipio Juan Antonio Sotillo'),(17,2,'116','Municipio Juan Manuel Cajigal'),(18,2,'117','Municipio Libertad'),(19,2,'118','Municipio Manuel Ezequiel Bruzual'),(20,2,'119','Municipio Pedro María Freites'),(21,2,'120','Municipio Píritu'),(22,2,'121','Municipio San Juan de Capistrano'),(23,2,'122','Municipio Santa Ana'),(24,2,'123','Municipio Simón Bolívar'),(25,2,'124','Municipio Simón Rodríguez'),(26,2,'125','Municipio Sir Arthur Mc Gregor'),(27,2,'126','Municipio Turístico Diego Bautista Urbaneja'),(28,3,'127','Municipio Achaguas'),(29,3,'128','Municipio Biruaca'),(30,3,'129','Municipio Muñoz'),(31,3,'130','Municipio P´ez'),(32,3,'131','Municipio Pedro Camejo'),(33,3,'132','Municipio Pedro María Freites'),(34,3,'133','Municipio Píritu'),(35,3,'134','Municipio Rómulo Gallegos'),(36,3,'135','Municipio San Fernando'),(37,3,'136','Municipio San Juan de Capistrano'),(38,3,'137','Municipio Santa Ana'),(39,3,'138','Municipio Simón Bolívar'),(40,3,'139','Municipio Simón Rodríguez'),(41,3,'140','Municipio Sir Arthur Mc Gregor'),(42,3,'141','Municipio Turístico Diego Bautista Urbaneja'),(43,4,'142','Municipio Camatagua'),(44,4,'143','Municipio Francisco Linares Alcántara'),(45,4,'144','Municipio Girardot'),(46,4,'145','Municipio José Félix Ribas'),(47,4,'151','Municipio Sucre'),(48,4,'146','Municipio Libertador'),(49,4,'147','Municipio Mario Briceño Iragorry'),(50,4,'148','Municipio San Casimiro'),(51,4,'149','Municipio Santiago Mariño'),(52,4,'150','Municipio Santos Michelena'),(53,4,'152','Municipio Urdaneta'),(54,4,'153','Municipio Zamora'),(55,5,'154','Municipio Alberto Arvelo Torrealba'),(56,5,'155','Municipio Andrés Eloy Blanco'),(57,5,'156','Municipio Antonio José de Sucre'),(58,5,'157','Municipio Arismendi'),(59,5,'158','Municipio Barinas'),(60,5,'159','Municipio Bolívar'),(61,5,'160','Municipio Cruz Paredes'),(62,5,'161','Municipio Ezequiel Zamora'),(63,5,'162','Municipio Obispos'),(64,5,'163','Municipio Pedraza'),(65,5,'164','Municipio Rojas'),(66,5,'165','Municipio Sosa'),(67,6,'166','Municipio Caroní'),(68,6,'167','Municipio Cedeño'),(69,6,'168','Municipio Gran Sabana'),(70,6,'169','Municipio Heres'),(71,6,'170','Municipio Piar'),(72,6,'171','Municipio Raúl Leoni'),(73,6,'172','Municipio Roscio'),(74,6,'173','Municipio Sifontes'),(75,6,'174','Municipio Sucre'),(76,7,'175','Municipio Bejuma'),(77,7,'176','Municipio Carlos Arvelo'),(78,7,'177','Municipio Diego Ibarra'),(79,7,'178','Municipio Guacara'),(80,7,'179','Municipio Juan José Mora'),(81,7,'180','Municipio Libertador'),(82,7,'181','Municipio Los Guayos'),(83,7,'182','Municipio Miranda'),(84,7,'183','Municipio Montalbán'),(85,7,'184','Municipio Naguanagua'),(86,7,'185','Municipio Puerto Cabello'),(87,7,'186','Municipio San Diego'),(88,7,'187','Municipio San Joaquín'),(89,7,'188','Municipio Valencia'),(90,8,'189','Municipio Anzoátegui'),(91,8,'190','Municipio Falcón'),(92,8,'191','Municipio Girardot'),(93,8,'192','Municipio Lima Blanco'),(94,8,'193','Municipio Pao de San Juan Bautista'),(95,8,'194','Municipio Ricaurte'),(96,8,'195','Municipio Rómulo Gallegos'),(97,8,'196','Municipio San Carlos'),(98,8,'197','Municipio Tinaco'),(99,9,'198','Municipio Antonio Díaz'),(100,9,'199','Municipio Casacoima'),(101,9,'200','Municipio Pedernales'),(102,9,'201','Municipio Tucupita'),(103,10,'202','Municipio Acosta'),(104,10,'203','Municipio Bolívar'),(105,10,'204','Municipio Buchivacoa'),(106,10,'205','Municipio Carirubana'),(107,10,'206','Municipio Colina'),(108,10,'207','Municipio Democracia'),(109,10,'208','Municipio Falcón'),(110,10,'209','Municipio Federación'),(111,10,'210','Municipio Jacura'),(112,10,'211','Municipio Los Tanques de Mauroa'),(113,10,'212','Municipio Mauroa'),(114,10,'213','Municipio Miranda'),(115,10,'214','Municipio Monseñor Iturriza'),(116,10,'215','Municipio Petit'),(117,10,'216','Municipio Píritu'),(118,10,'217','Municipio Silva'),(119,10,'218','Municipio Sucre'),(120,10,'219','Municipio Unión'),(121,10,'220','Municipio Urumaco'),(122,10,'221','Municipio Zamora'),(123,11,'222','Municipio Camaguán'),(124,11,'223','Municipio Chaguaramas'),(125,11,'224','Municipio El Socorro'),(126,11,'225','Municipio Francisco de Miranda'),(127,11,'226','Municipio José Félix Ribas'),(128,11,'227','Municipio José Tadeo Monagas'),(129,11,'228','Municipio Juan Germán Roscio'),(130,11,'229','Municipio Julián Mellado'),(131,11,'230','Municipio Las Mercedes'),(132,11,'231','Municipio Leonardo Infante'),(133,11,'232','Municipio Ortiz'),(134,11,'233','Municipio Pedro Zaraza'),(135,11,'234','Municipio San Gerónimo de Guayabal'),(136,11,'235','Municipio San José de Guaribe'),(137,11,'236','Municipio Santa María de Ipire'),(138,12,'237','Municipio Andrés Eloy Blanco'),(139,12,'238','Municipio Crespo'),(140,12,'239','Municipio Iribarren'),(141,12,'240','Municipio Jiménez'),(142,12,'241','Municipio Morán'),(143,12,'242','Municipio Palavecino'),(144,12,'243','Municipio Simón Planas'),(145,12,'244','Municipio Torres'),(146,13,'245','Municipio Alberto Adriani'),(147,13,'246','Municipio Antonio Pinto Salinas'),(148,13,'247','Municipio Aricagua'),(149,13,'248','Municipio Arzobispo Chacón'),(150,13,'249','Municipio Campo Elías'),(151,13,'250','Municipio Caracciolo Parra Olmedo'),(152,13,'252','Municipio Guaraque'),(153,13,'251','Municipio Cardenal Quintero'),(154,13,'253','Municipio Julio César Salas'),(155,13,'254','Municipio Justo Briceño'),(156,13,'255','Municipio Libertador'),(157,14,'256','Municipio Acevedo'),(158,14,'257','Municipio Andrés Bello'),(159,14,'258','Municipio Baruta'),(160,14,'259','Municipio Brión'),(161,14,'260','Municipio Buroz'),(162,14,'261','Municipio Carrizal'),(163,14,'262','Municipio Chacao'),(164,14,'263','Municipio Cristóbal Rojas'),(165,14,'264','Municipio El Hatillo'),(166,14,'265','Municipio Guaicaipuro'),(167,14,'266','Municipio Independencia'),(168,14,'267','Municipio Lander'),(169,14,'268','Municipio Los Salias'),(170,14,'269','Municipio Páez'),(171,14,'270','Municipio Paz Castillo'),(172,14,'271','Municipio Pedro Gual'),(173,14,'272','Municipio Plaza'),(174,14,'273','Municipio Simón Bolívar'),(175,14,'274','Municipio Sucre'),(176,14,'275','Municipio Urdaneta'),(177,14,'276','Municipio Zamora'),(178,15,'277','Municipio Acosta'),(179,15,'278','Municipio Caripe'),(180,15,'279','Municipio Cedeño'),(181,15,'280','Municipio Ezequiel Zamora'),(182,15,'281','Municipio Libertador'),(183,15,'282','Municipio Maturín'),(184,15,'283','Municipio Piar'),(185,15,'284','Municipio Punceres'),(186,15,'285','Municipio Sotillo'),(187,16,'286','Municipio Díaz'),(188,16,'287','Municipio García'),(189,16,'288','Municipio Gómez'),(190,16,'289','Municipio Maneiro'),(191,16,'290','Municipio Marcano'),(192,16,'291','Municipio Península de Macanao'),(193,16,'292','Municipio Tubores'),(194,16,'293','Municipio Villalba'),(195,17,'294','Municipio Araure'),(196,17,'295','Municipio Esteller'),(197,17,'296','Municipio Guanare'),(198,17,'297','Municipio Guanarito'),(199,17,'298','Municipio Monseñor José Vicente de Unda'),(200,17,'299','Municipio Ospino'),(201,17,'300','Municipio Páez'),(202,17,'301','Municipio Papelón'),(203,17,'302','Municipio San Genaro de Boconoito'),(204,17,'303','Municipio San Rafael de Onoto'),(205,17,'304','Municipio Santa Rosalía'),(206,17,'305','Municipio Sucre'),(207,17,'306','Municipio Turén'),(208,18,'307','Municipio Andrés Eloy Blanco'),(209,18,'308','Municipio Andrés Mata'),(210,18,'309','Municipio Arismendi'),(211,18,'310','Municipio Benítez'),(212,18,'311','Municipio Bermúdez'),(213,18,'312','Municipio Cajigal'),(214,18,'313','Municipio Cruz Salmerón Acosta'),(215,18,'314','Municipio Libertador'),(216,18,'315','Municipio Mariño'),(217,18,'316','Municipio Montes'),(218,18,'317','Municipio Ribero'),(219,18,'318','Municipio Sucre'),(220,18,'319','Municipio Valdez'),(221,19,'320','Municipio Ayacucho'),(222,19,'321','Municipio Bolívar'),(223,19,'322','Municipio Cárdenas'),(224,19,'323','Municipio Fernández Feo'),(225,19,'324','Municipio García de Hevia'),(226,19,'325','Municipio Independencia'),(227,19,'326','Municipio Jáuregui'),(228,19,'327','Municipio Junín'),(229,19,'328','Municipio Libertad'),(230,19,'329','Municipio Libertador'),(231,19,'330','Municipio Lobatera'),(232,19,'331','Municipio Panamericano'),(233,19,'332','Municipio Pedro María Ureña'),(234,19,'333','Municipio Samuel Darío Maldonado'),(235,19,'334','Municipio San Cristóbal'),(236,19,'335','Municipio Sucre'),(237,19,'336','Municipio Uribante'),(238,20,'337','Municipio Andrés Bello'),(239,20,'338','Municipio Boconó'),(240,20,'339','Municipio Bolívar'),(241,20,'340','Municipio Candelaria'),(242,20,'341','Municipio Carache'),(243,20,'342','Municipio Escuque'),(244,20,'343','Municipio José Felipe Márquez Cañizales'),(245,20,'344','Municipio Juan Vicente Campo Elías'),(246,20,'345','Municipio La Ceiba'),(247,20,'346','Municipio Miranda'),(248,20,'347','Municipio Monte Carmelo'),(249,20,'348','Municipio Motatán'),(250,20,'349','Municipio Pampán'),(251,20,'350','Municipio Pampanito'),(252,20,'351','Municipio Rafael Rangel'),(253,20,'352','Municipio San Rafael de Carvajal'),(254,20,'353','Municipio Sucre'),(255,20,'354','Municipio Trujillo'),(256,20,'355','Municipio Urdaneta'),(257,20,'356','Municipio Valera'),(258,21,'357','Municipio Vargas'),(259,22,'358','Municipio Bruzual'),(260,22,'359','Municipio Nirgua'),(261,22,'360','Municipio Peña'),(262,22,'361','Municipio San Felipe'),(263,22,'362','Municipio Veroes'),(264,23,'363','Municipio Almirante Padilla'),(265,23,'364','Municipio Baralt'),(266,23,'365','Municipio Cabimas'),(267,23,'366','Municipio Catatumbo'),(268,23,'367','Municipio Colón'),(269,23,'368','Municipio Francisco Javier Pulgar'),(270,23,'369','Municipio Jesús Enrique Lossada'),(271,23,'370','Municipio Jesús María Semprún'),(272,23,'371','Municipio La Cañada de Urdaneta'),(273,23,'372','Municipio Lagunillas'),(274,23,'373','Municipio Machiques de Perijá'),(275,23,'374','Municipio Mara'),(276,23,'375','Municipio Maracaibo'),(277,23,'376','Municipio Miranda'),(278,23,'377','Municipio Páez'),(279,23,'378','Municipio Rosario de Perijá'),(280,23,'379','Municipio San Francisco'),(281,23,'380','Municipio Santa Rita'),(282,23,'381','Municipio Simón Bolívar'),(283,23,'382','Municipio Sucre'),(284,23,'383','Municipio Valmore Rodríguez'),(285,24,'384','Municipio Libertador');
/*!40000 ALTER TABLE `municipios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `niveles`
--

DROP TABLE IF EXISTS `niveles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `niveles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `descripcion` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_833F292A20332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `niveles`
--

LOCK TABLES `niveles` WRITE;
/*!40000 ALTER TABLE `niveles` DISABLE KEYS */;
INSERT INTO `niveles` VALUES (1,'FUND','Fundamentación'),(2,'INTEG','Integración'),(3,'PROF','Profundización'),(4,'SNIV','Sin Nivel');
/*!40000 ALTER TABLE `niveles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ofer_acade`
--

DROP TABLE IF EXISTS `ofer_acade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ofer_acade` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curso_id` int(11) DEFAULT NULL,
  `profesor_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `programa_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `seccion` varchar(20) NOT NULL,
  `horario` varchar(255) DEFAULT NULL,
  `cantidad_cupos` int(11) NOT NULL,
  `cantidad_alumnos` int(11) NOT NULL,
  `estado_ofeta` tinyint(1) NOT NULL,
  `fecha_trans` datetime DEFAULT NULL,
  `fecha_inclusion` datetime NOT NULL,
  `impresa` tinyint(1) NOT NULL,
  `numero_acta` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `descripc_horario` varchar(255) DEFAULT NULL,
  `cohorte_id` int(11) DEFAULT NULL,
  `subsede_id` int(11) DEFAULT NULL,
  `modalidad_id` int(11) DEFAULT NULL,
  `especialidad_id` int(11) DEFAULT NULL,
  `ambiente_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_AA6862987CB4A1F` (`curso_id`),
  KEY `IDX_AA68629E52BD977` (`profesor_id`),
  KEY `IDX_AA6862980B24165` (`lapso_id`),
  KEY `IDX_AA68629FD8A7328` (`programa_id`),
  KEY `IDX_AA68629E19F41BF` (`sede_id`),
  KEY `IDX_AA68629613FECDF` (`session_id`),
  KEY `IDX_AA68629FB30EFA4` (`cohorte_id`),
  KEY `IDX_AA68629AAFDE970` (`subsede_id`),
  KEY `IDX_AA686291E092B9F` (`modalidad_id`),
  KEY `IDX_AA6862916A490EC` (`especialidad_id`),
  KEY `IDX_AA68629112F3512` (`ambiente_id`),
  CONSTRAINT `FK_AA68629112F3512` FOREIGN KEY (`ambiente_id`) REFERENCES `ambiente` (`id`),
  CONSTRAINT `FK_AA6862916A490EC` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`),
  CONSTRAINT `FK_AA686291E092B9F` FOREIGN KEY (`modalidad_id`) REFERENCES `modalidad` (`id`),
  CONSTRAINT `FK_AA68629613FECDF` FOREIGN KEY (`session_id`) REFERENCES `sessiones` (`id`),
  CONSTRAINT `FK_AA6862987CB4A1F` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`),
  CONSTRAINT `FK_AA68629AAFDE970` FOREIGN KEY (`subsede_id`) REFERENCES `subsede` (`id`),
  CONSTRAINT `FK_AA68629E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`),
  CONSTRAINT `FK_AA68629E52BD977` FOREIGN KEY (`profesor_id`) REFERENCES `profesor` (`id`),
  CONSTRAINT `FK_AA68629FB30EFA4` FOREIGN KEY (`cohorte_id`) REFERENCES `cohorte` (`id`),
  CONSTRAINT `FK_AA68629FD8A7328` FOREIGN KEY (`programa_id`) REFERENCES `programa` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7868 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ofer_acade`
--

LOCK TABLES `ofer_acade` WRITE;
/*!40000 ALTER TABLE `ofer_acade` DISABLE KEYS */;
INSERT INTO `ofer_acade` VALUES (7817,120,1783,1,1,1,'14','LUNES desde: 7:00 am hasta: 7:30 am',9,9,1,'2020-01-23 10:34:11','2017-10-09 13:49:06',0,NULL,NULL,'1QQ',90,1,1,3,13),(7820,757,1230,1,1,1,'1','LUNES desde: 7:00 am hasta: 8:00 am',30,0,1,NULL,'2017-10-31 10:22:39',0,NULL,NULL,'1AA',90,2,1,1,2),(7821,757,1230,1,1,1,'1',NULL,30,0,1,NULL,'2017-10-31 10:24:31',0,NULL,NULL,NULL,90,7,1,1,4),(7822,757,1230,1,1,1,'1','LUNES desde: 7:00 am hasta: 7:30 am',30,0,1,NULL,'2017-10-31 10:25:53',0,NULL,NULL,'1QQ',90,17,1,12,6),(7823,550,1781,1,1,1,'1','LUNES desde: 8:30 am hasta: 9:00 am LUNES desde: 8:00 am hasta: 8:30 am',4,1,1,'2018-05-07 08:33:17','2017-10-31 10:48:14',0,NULL,NULL,'1QQ',90,1,1,1,2),(7824,757,1230,1,1,1,'1','LUNES desde: 7:00 am hasta: 8:00 am',2,1,1,NULL,'2017-11-10 09:27:04',0,NULL,NULL,'1AA',90,1,1,1,2),(7825,641,1781,1,1,1,'1','LUNES desde: 7:00 am hasta: 8:00 am',2,1,1,'2018-01-24 14:35:49','2017-11-10 09:27:35',0,NULL,NULL,'1AA',90,1,1,1,2),(7826,120,1230,1,1,1,'12','LUNES desde: 12:00 am hasta: 12:00 am',1,0,1,NULL,'2017-11-16 09:15:27',0,NULL,NULL,'1undefinedundefined',90,3,1,2,9),(7827,120,1780,1,1,1,'1','LUNES desde: 7:00 am hasta: 7:30 am',1,0,1,NULL,'2017-12-13 13:38:43',0,NULL,NULL,'1Aundefined',90,1,1,2,1),(7828,382,NULL,1,1,1,'2','LUNES desde: 7:30 am hasta: 8:00 am',1,0,1,NULL,'2017-12-13 13:42:13',0,NULL,NULL,'1undefinedA',90,1,3,3,2),(7829,260,NULL,1,1,1,'3','MARTES desde: 7:00 am hasta: 7:30 am',1,0,1,NULL,'2017-12-13 13:44:12',0,NULL,NULL,'2Aundefined',90,1,3,3,1),(7830,29,NULL,1,1,1,'9','LUNES desde: 8:30 am hasta: 9:00 am',1,0,1,NULL,'2017-12-13 13:54:54',0,NULL,NULL,'1undefinedB',90,2,1,8,8),(7831,199,1230,53,1,1,'1','LUNES desde: 7:00 am hasta: 8:30 am',3,1,1,NULL,'2018-03-16 09:27:58',0,NULL,NULL,'1Aundefined',90,1,1,1,4),(7832,465,1230,53,1,1,'2','LUNES desde: 12:00 am hasta: 12:00 am',1,1,1,NULL,'2018-05-24 14:57:29',0,NULL,NULL,'1undefinedundefined',90,1,1,1,4),(7833,376,1230,54,1,1,'1','LUNES desde: 7:00 am hasta: 10:00 am',16,0,1,NULL,'2018-11-26 09:58:33',0,NULL,NULL,'1AC',91,1,1,5,4),(7834,156,1789,55,1,1,'1',NULL,20,1,1,'2019-06-12 16:14:16','2019-06-12 15:35:47',0,NULL,NULL,NULL,92,1,1,10,1),(7835,771,1783,1,1,1,'5','MARTES desde: 7:30 am hasta: 8:00 am',10,0,1,NULL,'2020-02-03 10:07:24',0,NULL,NULL,'2undefinedA',90,1,1,10,6),(7836,641,1789,1,1,1,'1','LUNES desde: 7:00 am hasta: 9:30 am',5,1,1,'2024-06-10 09:25:18','2020-10-08 13:27:55',0,NULL,NULL,'1Aundefined',90,1,3,1,1),(7837,757,1230,1,1,1,'1','MIÉRCOLES desde: 7:00 am hasta: 8:30 am',5,0,1,NULL,'2020-10-08 13:34:33',0,NULL,NULL,'undefinedAundefined',90,1,1,1,1),(7838,771,1789,55,1,1,'2','SÁBADO desde: 7:00 am hasta: 9:00 am',5,0,1,NULL,'2020-10-08 14:11:41',0,NULL,NULL,'undefinedAB',92,1,1,10,1),(7839,771,1230,1,1,1,'5','JUEVES desde: 12:00 pm hasta: 3:00 pm',28,0,1,NULL,'2020-10-08 14:13:15',0,NULL,NULL,'4FH',92,1,3,10,8),(7840,641,1794,56,1,1,'1','LUNES desde: 7:00 am hasta: 9:00 am',5,-1,1,NULL,'2023-02-06 09:55:38',0,NULL,NULL,'1AB',92,1,3,12,1),(7841,641,1794,1,1,1,'1','LUNES desde: 7:00 am hasta: 9:00 am',5,0,1,'2023-05-22 14:23:10','2023-02-06 11:27:34',0,NULL,NULL,'1AB',90,1,1,11,1),(7842,937,1794,55,1,1,'1','MARTES desde: 7:00 am hasta: 9:00 am',5,0,1,NULL,'2023-02-06 11:28:52',0,NULL,NULL,'2AB',90,1,1,11,1),(7843,156,1794,56,1,1,'1','MIÉRCOLES desde: 7:00 am hasta: 9:00 am',5,0,1,NULL,'2023-02-06 11:29:48',0,NULL,NULL,'undefinedAB',90,1,1,11,1),(7844,476,1794,1,1,1,'1','JUEVES desde: 7:00 am hasta: 9:00 am',5,1,1,'2023-05-22 16:07:30','2023-02-07 20:45:47',0,NULL,NULL,'4AB',90,1,3,11,1),(7845,29,1794,1,1,1,'1','VIERNES desde: 7:00 am hasta: 9:00 am',5,1,1,'2023-04-11 09:47:10','2023-03-17 11:59:23',0,NULL,NULL,'5AB',90,1,1,8,1),(7846,292,1794,1,1,1,'1','JUEVES desde: 7:00 am hasta: 9:00 am',4,1,1,'2023-04-11 09:47:23','2023-03-17 12:31:36',0,NULL,NULL,'4AB',90,1,1,8,1),(7847,611,1230,1,1,1,'1','JUEVES desde: 11:00 am hasta: 11:30 am',25,2,1,'2023-06-13 13:39:49','2023-03-17 21:39:41',0,NULL,NULL,'4Eundefined',92,1,1,19,2),(7848,120,1789,1,1,1,'1','VIERNES desde: 7:00 am hasta: 8:30 am',20,1,1,'2023-06-13 11:43:26','2023-03-18 19:52:06',0,NULL,NULL,'5Aundefined',92,1,1,1,5),(7849,757,1794,1,1,1,'1','SÁBADO desde: 7:00 am hasta: 9:00 am',5,1,1,'2023-04-11 09:47:34','2023-04-10 11:24:29',0,NULL,NULL,'undefinedAB',91,1,1,8,1),(7850,120,1789,55,1,1,'1','MARTES desde: 10:00 am hasta: 10:30 am MARTES desde: 10:30 am hasta: 11:00 am',10,2,1,'2023-05-23 13:30:16','2023-05-23 13:03:46',0,NULL,NULL,'2Dundefined-2undefinedD',90,1,1,19,1),(7851,382,1789,55,1,1,'1',NULL,10,0,1,NULL,'2023-06-01 10:54:22',0,NULL,NULL,NULL,92,1,1,1,1),(7852,498,1789,1,1,1,'1','MIÉRCOLES desde: 10:00 am hasta: 10:30 am MIÉRCOLES desde: 11:00 am hasta: 11:30 am',10,1,1,NULL,'2023-07-19 09:50:01',0,NULL,NULL,'undefinedDundefined-undefinedEundefined',90,1,1,19,2),(7853,120,1789,1,1,1,'1','JUEVES desde: 8:00 am hasta: 8:30 am JUEVES desde: 8:30 am hasta: 9:00 am',10,0,1,NULL,'2023-11-02 15:41:54',0,NULL,NULL,'4Bundefined-4undefinedB',90,1,1,7,2),(7854,611,1789,1,1,1,'1','SÁBADO desde: 10:30 am hasta: 11:00 am DOMINGO desde: 11:00 am hasta: 11:30 am',10,0,1,NULL,'2023-11-02 15:45:34',0,NULL,NULL,'NaND-7Eundefined',90,1,1,7,2),(7855,382,1789,1,1,1,'1','VIERNES desde: 11:00 am hasta: 11:30 am SÁBADO desde: 11:00 am hasta: 11:30 am',5,0,1,NULL,'2023-11-02 15:53:34',0,NULL,NULL,'5Eundefined-undefinedEundefined',90,1,1,4,10),(7856,642,1789,56,1,1,'1',NULL,10,0,1,NULL,'2023-11-16 08:28:44',0,NULL,NULL,NULL,90,1,1,7,1),(7857,117,1789,1,1,1,'1',NULL,10,0,1,NULL,'2023-11-16 08:29:30',0,NULL,NULL,NULL,90,1,1,7,1),(7858,117,1794,56,1,1,'1',NULL,10,0,1,NULL,'2023-11-16 08:44:24',0,NULL,NULL,NULL,90,1,1,7,1),(7859,286,1794,56,1,1,'1',NULL,10,0,1,NULL,'2023-11-17 08:55:55',0,NULL,NULL,NULL,90,1,1,4,2),(7860,641,1789,1,1,1,'1','SÁBADO desde: 7:00 am hasta: 9:00 am',3,2,1,NULL,'2024-03-09 17:50:35',0,NULL,NULL,'undefinedAB',90,1,1,19,2),(7865,641,1789,1,1,1,'1','SÁBADO desde: 7:00 am hasta: 9:00 am',3,2,1,NULL,'2024-03-11 11:25:46',0,NULL,NULL,'undefinedAB',90,1,1,19,2),(7866,350,1794,64,1,1,'8','LUNES desde: 7:00 am hasta: 12:00 pm',5,1,1,NULL,'2024-05-18 23:38:42',0,NULL,NULL,'1AE',96,1,1,19,1),(7867,497,1789,56,1,1,'1','MARTES desde: 7:00 am hasta: 7:30 am MARTES desde: 7:30 am hasta: 8:00 am MARTES desde: 8:00 am hasta: 8:30 am',2,0,1,NULL,'2025-04-29 06:09:45',0,NULL,NULL,'2Aundefined-2undefinedA-2Bundefined',94,1,1,19,1);
/*!40000 ALTER TABLE `ofer_acade` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pais`
--

DROP TABLE IF EXISTS `pais`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pais` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_7E5D2EFF20332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pais`
--

LOCK TABLES `pais` WRITE;
/*!40000 ALTER TABLE `pais` DISABLE KEYS */;
INSERT INTO `pais` VALUES (1,'10001','Afganistán'),(2,'10002','Albania '),(3,'10003','Alemania '),(4,'10004','Angola '),(5,'10005','Antigua y Barbuda'),(6,'10006','Arabia Saudita'),(7,'10007','Argentina '),(8,'10008','Bahrein '),(9,'10009','Barbados '),(10,'10010','Bélgica '),(11,'10011','Belice '),(12,'10012','Bolivia '),(13,'10014','Brasil '),(14,'10015','Bulgaria'),(15,'10016','Canadá '),(16,'10017','Chile '),(17,'10018','China '),(18,'10019','Colombia '),(19,'10020','Costa Rica'),(20,'10021','Croacia '),(21,'10022','Dinamarca '),(22,'10023','Ecuador '),(23,'10024','El Salvado'),(24,'10025','España '),(25,'10026','Estados de'),(26,'10027','Estados Unidos'),(27,'10028','Estonia '),(28,'10029','Filipinas '),(29,'10030','Francia '),(30,'10031','Georgia '),(31,'10032','Ghana '),(32,'10033','Grecia '),(33,'10034','Guatemala '),(34,'10035','Guyana '),(35,'10036','Haití '),(36,'10037','Honduras '),(37,'10038','India '),(38,'10039','Indonesia '),(39,'10040','Irak '),(40,'10041','Islandia '),(41,'10042','Israel '),(42,'10043','Jamaica '),(43,'10044','Japón '),(44,'10045','Jordania '),(45,'10046','Líbano '),(46,'10047','Libia '),(47,'10048','México '),(48,'10049','Namibia '),(49,'10050','Nicaragua '),(50,'10051','Nigeria '),(51,'10052','Noruega '),(52,'10053','Otros'),(53,'10054','Países Bajos'),(54,'10055','Pakistán '),(55,'10056','Panamá '),(56,'10057','Paraguay '),(57,'10058','Perú '),(58,'10059','Portugal '),(59,'10060','República Dominicana'),(60,'10061','Sudáfrica '),(61,'10062','Suecia '),(62,'10063','Suiza '),(63,'10064','Trinidad y Tobago'),(64,'10065','Turquía'),(65,'10066','Uruguay '),(66,'10067','Venezuela '),(67,'10068','Haití'),(68,'10069','Omán'),(69,'10070','República Democrática del Congo'),(70,'10071','Vietnam'),(71,'10072','Andorra');
/*!40000 ALTER TABLE `pais` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `plan_estudio`
--

DROP TABLE IF EXISTS `plan_estudio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `plan_estudio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curso_id` int(11) DEFAULT NULL,
  `especialidad_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `programa_id` int(11) DEFAULT NULL,
  `plan` varchar(20) NOT NULL,
  `semestre` int(11) NOT NULL,
  `nivel_id` int(11) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha_hora` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_1B4522187CB4A1F` (`curso_id`),
  KEY `IDX_1B4522116A490EC` (`especialidad_id`),
  KEY `IDX_1B45221E19F41BF` (`sede_id`),
  KEY `IDX_1B45221FD8A7328` (`programa_id`),
  KEY `IDX_1B45221DA3426AE` (`nivel_id`),
  CONSTRAINT `FK_1B4522116A490EC` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`),
  CONSTRAINT `FK_1B4522187CB4A1F` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`),
  CONSTRAINT `FK_1B45221DA3426AE` FOREIGN KEY (`nivel_id`) REFERENCES `niveles` (`id`),
  CONSTRAINT `FK_1B45221E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`),
  CONSTRAINT `FK_1B45221FD8A7328` FOREIGN KEY (`programa_id`) REFERENCES `programa` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2595 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `plan_estudio`
--

LOCK TABLES `plan_estudio` WRITE;
/*!40000 ALTER TABLE `plan_estudio` DISABLE KEYS */;
INSERT INTO `plan_estudio` VALUES (1,3,1,1,1,'2015',5,2,NULL,NULL),(3,26,1,1,1,'2015',4,2,NULL,NULL),(5,38,1,1,1,'2015',3,2,NULL,NULL),(6,115,1,1,1,'2015',1,1,NULL,NULL),(7,117,1,1,1,'2015',3,2,NULL,NULL),(8,120,1,1,1,'2015',1,1,NULL,NULL),(9,154,1,1,1,'2015',7,3,NULL,NULL),(10,156,1,1,1,'2015',3,2,NULL,NULL),(12,164,1,1,1,'2015',4,2,NULL,NULL),(13,175,1,1,1,'2015',7,3,NULL,NULL),(14,176,1,1,1,'2015',5,2,NULL,NULL),(15,199,1,1,1,'2015',6,3,NULL,NULL),(17,204,1,1,1,'2015',7,3,NULL,NULL),(18,256,1,1,1,'2015',5,2,NULL,NULL),(19,258,1,1,1,'2015',6,3,NULL,NULL),(20,260,1,1,1,'2015',2,1,NULL,NULL),(21,317,1,1,1,'2015',6,3,NULL,NULL),(22,337,1,1,1,'2015',1,1,NULL,NULL),(23,338,1,1,1,'2015',2,1,NULL,NULL),(24,382,1,1,1,'2015',1,1,NULL,NULL),(25,383,1,1,1,'2015',3,2,NULL,NULL),(26,384,1,1,1,'2015',5,2,NULL,NULL),(27,385,1,1,1,'2015',7,3,NULL,NULL),(28,387,1,1,1,'2015',2,1,NULL,NULL),(29,430,1,1,1,'2015',3,2,NULL,NULL),(30,465,1,1,1,'2015',1,1,NULL,NULL),(31,486,1,1,1,'2015',7,3,NULL,NULL),(32,489,1,1,1,'2015',5,2,NULL,NULL),(33,490,1,1,1,'2015',6,3,NULL,NULL),(34,497,1,1,1,'2015',2,1,NULL,NULL),(35,499,1,1,1,'2015',4,2,NULL,NULL),(36,507,1,1,1,'2015',2,1,NULL,NULL),(37,508,1,1,1,'2015',4,2,NULL,NULL),(38,509,1,1,1,'2015',6,3,NULL,NULL),(39,510,1,1,1,'2015',8,3,NULL,NULL),(40,538,1,1,1,'2015',8,3,NULL,NULL),(41,550,1,1,1,'2015',8,3,NULL,NULL),(42,551,1,1,1,'2015',2,1,NULL,NULL),(43,611,1,1,1,'2015',1,1,NULL,NULL),(44,616,1,1,1,'2015',6,3,NULL,NULL),(45,619,1,1,1,'2015',4,2,NULL,NULL),(46,620,1,1,1,'2015',7,3,NULL,NULL),(47,621,1,1,1,'2015',4,2,NULL,NULL),(48,622,1,1,1,'2015',3,2,NULL,NULL),(49,630,1,1,1,'2015',6,3,NULL,NULL),(50,641,1,1,1,'2015',1,1,NULL,NULL),(51,642,1,1,1,'2015',3,2,NULL,NULL),(52,643,1,1,1,'2015',5,2,NULL,NULL),(53,644,1,1,1,'2015',7,3,NULL,NULL),(54,3,2,1,1,'2015',5,2,NULL,NULL),(56,35,2,1,1,'2015',4,2,NULL,NULL),(57,78,2,1,1,'2015',3,2,NULL,NULL),(58,105,2,1,1,'2015',6,3,NULL,NULL),(59,117,2,1,1,'2015',3,2,NULL,NULL),(60,120,2,1,1,'2015',1,1,NULL,NULL),(61,121,2,1,1,'2015',8,3,NULL,NULL),(62,148,2,1,1,'2015',5,2,NULL,NULL),(63,156,2,1,1,'2015',3,2,NULL,NULL),(64,163,2,1,1,'2015',7,3,NULL,NULL),(65,164,2,1,1,'2015',4,2,NULL,NULL),(66,175,2,1,1,'2015',7,3,NULL,NULL),(67,244,2,1,1,'2015',4,2,NULL,NULL),(68,256,2,1,1,'2015',5,2,NULL,NULL),(69,258,2,1,1,'2015',6,3,NULL,NULL),(70,260,2,1,1,'2015',2,1,NULL,NULL),(71,262,2,1,1,'2015',4,2,NULL,NULL),(72,263,2,1,1,'2015',3,2,NULL,NULL),(73,317,2,1,1,'2015',6,3,NULL,NULL),(74,382,2,1,1,'2015',1,1,NULL,NULL),(75,383,2,1,1,'2015',3,2,NULL,NULL),(76,384,2,1,1,'2015',5,2,NULL,NULL),(77,385,2,1,1,'2015',7,3,NULL,NULL),(79,486,2,1,1,'2015',7,3,NULL,NULL),(80,487,2,1,1,'2015',1,1,NULL,NULL),(81,488,2,1,1,'2015',3,2,NULL,NULL),(82,497,2,1,1,'2015',2,1,NULL,NULL),(83,499,2,1,1,'2015',4,2,NULL,NULL),(84,507,2,1,1,'2015',2,1,NULL,NULL),(85,508,2,1,1,'2015',4,2,NULL,NULL),(86,509,2,1,1,'2015',6,3,NULL,NULL),(87,510,2,1,1,'2015',8,3,NULL,NULL),(88,512,2,1,1,'2015',7,3,NULL,NULL),(91,530,2,1,1,'2015',5,2,NULL,NULL),(92,545,2,1,1,'2015',7,3,NULL,NULL),(93,551,2,1,1,'2015',2,1,NULL,NULL),(94,588,2,1,1,'2015',8,3,NULL,NULL),(95,592,2,1,1,'2015',2,1,NULL,NULL),(97,611,2,1,1,'2015',1,1,NULL,NULL),(98,615,2,1,1,'2015',6,3,NULL,NULL),(99,617,2,1,1,'2015',1,1,NULL,NULL),(100,618,2,1,1,'2015',6,3,NULL,NULL),(101,626,2,1,1,'2015',2,1,NULL,NULL),(102,638,2,1,1,'2015',6,3,NULL,NULL),(103,641,2,1,1,'2015',1,1,NULL,NULL),(104,642,2,1,1,'2015',3,2,NULL,NULL),(105,643,2,1,1,'2015',5,2,NULL,NULL),(106,644,2,1,1,'2015',7,3,NULL,NULL),(107,3,3,1,1,'2015',5,2,NULL,NULL),(109,49,3,1,1,'2015',5,2,NULL,NULL),(110,51,3,1,1,'2015',8,3,NULL,NULL),(111,54,3,1,1,'2015',3,2,NULL,NULL),(112,55,3,1,1,'2015',3,2,NULL,NULL),(113,56,3,1,1,'2015',5,2,NULL,NULL),(114,57,3,1,1,'2015',2,1,NULL,NULL),(115,59,3,1,1,'2015',4,2,NULL,NULL),(116,64,3,1,1,'2015',4,2,NULL,NULL),(117,65,3,1,1,'2015',4,2,NULL,NULL),(118,78,3,1,1,'2015',3,2,NULL,NULL),(119,80,3,1,1,'2015',2,1,NULL,NULL),(120,82,3,1,1,'2015',5,2,NULL,NULL),(121,88,3,1,1,'2015',8,3,NULL,NULL),(122,117,3,1,1,'2015',3,2,NULL,NULL),(123,120,3,1,1,'2015',1,1,NULL,NULL),(124,156,3,1,1,'2015',3,2,NULL,NULL),(125,164,3,1,1,'2015',2,1,NULL,NULL),(126,168,3,1,1,'2015',6,3,NULL,NULL),(127,175,3,1,1,'2015',7,3,NULL,NULL),(129,189,3,1,1,'2015',7,3,NULL,NULL),(130,201,3,1,1,'2015',6,3,NULL,NULL),(131,256,3,1,1,'2015',5,2,NULL,NULL),(132,257,3,1,1,'2015',8,3,NULL,NULL),(133,260,3,1,1,'2015',1,1,NULL,NULL),(134,298,3,1,1,'2015',7,3,NULL,NULL),(135,317,3,1,1,'2015',6,3,NULL,NULL),(136,380,3,1,1,'2015',6,3,NULL,NULL),(137,382,3,1,1,'2015',1,1,NULL,NULL),(138,383,3,1,1,'2015',3,2,NULL,NULL),(139,384,3,1,1,'2015',5,2,NULL,NULL),(140,385,3,1,1,'2015',7,3,NULL,NULL),(142,436,3,1,1,'2015',1,1,NULL,NULL),(143,478,3,1,1,'2015',4,2,NULL,NULL),(144,486,3,1,1,'2015',7,3,NULL,NULL),(145,497,3,1,1,'2015',2,1,NULL,NULL),(146,499,3,1,1,'2015',4,2,NULL,NULL),(147,507,3,1,1,'2015',2,1,NULL,NULL),(148,508,3,1,1,'2015',4,2,NULL,NULL),(149,509,3,1,1,'2015',6,3,NULL,NULL),(150,510,3,1,1,'2015',8,3,NULL,NULL),(151,516,3,1,1,'2015',4,2,NULL,NULL),(152,524,3,1,1,'2015',7,3,NULL,NULL),(153,551,3,1,1,'2015',2,1,NULL,NULL),(154,558,3,1,1,'2015',1,1,NULL,NULL),(156,588,3,1,1,'2015',8,3,NULL,NULL),(157,611,3,1,1,'2015',1,1,NULL,NULL),(158,641,3,1,1,'2015',1,1,NULL,NULL),(159,642,3,1,1,'2015',3,2,NULL,NULL),(160,643,3,1,1,'2015',5,2,NULL,NULL),(161,644,3,1,1,'2015',7,3,NULL,NULL),(162,3,4,1,1,'2015',5,2,NULL,NULL),(163,17,4,1,1,'2015',4,2,NULL,NULL),(164,39,4,1,1,'2015',2,1,NULL,NULL),(165,52,4,1,1,'2015',6,3,NULL,NULL),(166,71,4,1,1,'2015',3,2,NULL,NULL),(167,82,4,1,1,'2015',5,2,NULL,NULL),(168,85,4,1,1,'2015',6,3,NULL,NULL),(169,88,4,1,1,'2015',8,3,NULL,NULL),(170,117,4,1,1,'2015',3,2,NULL,NULL),(171,120,4,1,1,'2015',1,1,NULL,NULL),(172,156,4,1,1,'2015',3,2,NULL,NULL),(173,164,4,1,1,'2015',2,1,NULL,NULL),(174,175,4,1,1,'2015',7,3,NULL,NULL),(177,256,4,1,1,'2015',5,2,NULL,NULL),(178,260,4,1,1,'2015',1,1,NULL,NULL),(179,286,4,1,1,'2015',1,1,NULL,NULL),(180,305,4,1,1,'2015',4,2,NULL,NULL),(181,306,4,1,1,'2015',8,3,NULL,NULL),(182,307,4,1,1,'2015',5,2,NULL,NULL),(183,308,4,1,1,'2015',4,2,NULL,NULL),(184,314,4,1,1,'2015',7,3,NULL,NULL),(185,315,4,1,1,'2015',3,2,NULL,NULL),(186,317,4,1,1,'2015',6,3,NULL,NULL),(187,323,4,1,1,'2015',3,2,NULL,NULL),(188,330,4,1,1,'2015',4,2,NULL,NULL),(189,375,4,1,1,'2015',7,3,NULL,NULL),(190,382,4,1,1,'2015',1,1,NULL,NULL),(191,383,4,1,1,'2015',3,2,NULL,NULL),(192,384,4,1,1,'2015',5,2,NULL,NULL),(193,385,4,1,1,'2015',7,3,NULL,NULL),(195,438,4,1,1,'2015',1,1,NULL,NULL),(196,468,4,1,1,'2015',6,3,NULL,NULL),(197,473,4,1,1,'2015',8,3,NULL,NULL),(198,486,4,1,1,'2015',7,3,NULL,NULL),(199,497,4,1,1,'2015',2,1,NULL,NULL),(200,499,4,1,1,'2015',4,2,NULL,NULL),(201,507,4,1,1,'2015',2,1,NULL,NULL),(202,508,4,1,1,'2015',4,2,NULL,NULL),(203,509,4,1,1,'2015',6,3,NULL,NULL),(204,510,4,1,1,'2015',8,3,NULL,NULL),(205,516,4,1,1,'2015',4,2,NULL,NULL),(206,524,4,1,1,'2015',7,3,NULL,NULL),(207,551,4,1,1,'2015',2,1,NULL,NULL),(208,559,4,1,1,'2015',2,1,NULL,NULL),(209,588,4,1,1,'2015',8,3,NULL,NULL),(210,611,4,1,1,'2015',1,1,NULL,NULL),(211,624,4,1,1,'2015',6,3,NULL,NULL),(212,641,4,1,1,'2015',1,1,NULL,NULL),(213,642,4,1,1,'2015',3,2,NULL,NULL),(214,643,4,1,1,'2015',5,2,NULL,NULL),(215,644,4,1,1,'2015',7,3,NULL,NULL),(216,3,5,1,1,'2015',5,2,NULL,NULL),(217,73,5,1,1,'2015',3,2,NULL,NULL),(218,91,5,1,1,'2015',5,2,NULL,NULL),(220,117,5,1,1,'2015',3,2,NULL,NULL),(221,120,5,1,1,'2015',1,1,NULL,NULL),(222,127,5,1,1,'2015',5,2,NULL,NULL),(223,128,5,1,1,'2015',6,3,NULL,NULL),(224,131,5,1,1,'2015',1,1,NULL,NULL),(225,132,5,1,1,'2015',3,2,NULL,NULL),(226,135,5,1,1,'2015',4,2,NULL,NULL),(227,156,5,1,1,'2015',3,2,NULL,NULL),(229,164,5,1,1,'2015',4,2,NULL,NULL),(230,175,5,1,1,'2015',7,3,NULL,NULL),(231,178,5,1,1,'2015',4,2,NULL,NULL),(234,256,5,1,1,'2015',5,2,NULL,NULL),(235,260,5,1,1,'2015',2,1,NULL,NULL),(236,262,5,1,1,'2015',4,2,NULL,NULL),(238,311,5,1,1,'2015',2,1,NULL,NULL),(239,317,5,1,1,'2015',6,3,NULL,NULL),(240,373,5,1,1,'2015',2,1,NULL,NULL),(242,382,5,1,1,'2015',1,1,NULL,NULL),(243,383,5,1,1,'2015',3,2,NULL,NULL),(244,384,5,1,1,'2015',5,2,NULL,NULL),(245,385,5,1,1,'2015',7,3,NULL,NULL),(246,429,5,1,1,'2015',6,3,NULL,NULL),(247,470,5,1,1,'2015',7,3,NULL,NULL),(248,486,5,1,1,'2015',7,3,NULL,NULL),(249,497,5,1,1,'2015',2,1,NULL,NULL),(250,499,5,1,1,'2015',4,2,NULL,NULL),(251,503,5,1,1,'2015',8,3,NULL,NULL),(252,507,5,1,1,'2015',2,1,NULL,NULL),(253,508,5,1,1,'2015',4,2,NULL,NULL),(254,509,5,1,1,'2015',6,3,NULL,NULL),(255,510,5,1,1,'2015',8,3,NULL,NULL),(256,536,5,1,1,'2015',7,3,NULL,NULL),(257,551,5,1,1,'2015',2,1,NULL,NULL),(259,555,5,1,1,'2015',6,3,NULL,NULL),(263,611,5,1,1,'2015',1,1,NULL,NULL),(264,633,5,1,1,'2015',3,2,NULL,NULL),(265,641,5,1,1,'2015',1,1,NULL,NULL),(266,642,5,1,1,'2015',3,2,NULL,NULL),(267,643,5,1,1,'2015',5,2,NULL,NULL),(268,644,5,1,1,'2015',7,3,NULL,NULL),(269,3,6,1,1,'2015',5,2,NULL,NULL),(270,18,6,1,1,'2015',1,1,NULL,NULL),(271,21,6,1,1,'2015',4,2,NULL,NULL),(272,28,6,1,1,'2015',2,1,NULL,NULL),(273,30,6,1,1,'2015',3,2,NULL,NULL),(274,50,6,1,1,'2015',3,2,NULL,NULL),(275,62,6,1,1,'2015',3,2,NULL,NULL),(276,63,6,1,1,'2015',4,2,NULL,NULL),(277,114,6,1,1,'2015',2,1,NULL,NULL),(278,117,6,1,1,'2015',3,2,NULL,NULL),(279,120,6,1,1,'2015',1,1,NULL,NULL),(281,156,6,1,1,'2015',3,2,NULL,NULL),(282,158,6,1,1,'2015',5,2,NULL,NULL),(283,164,6,1,1,'2015',4,2,NULL,NULL),(284,171,6,1,1,'2015',8,3,NULL,NULL),(285,175,6,1,1,'2015',7,3,NULL,NULL),(287,256,6,1,1,'2015',5,2,NULL,NULL),(288,260,6,1,1,'2015',2,1,NULL,NULL),(289,317,6,1,1,'2015',6,3,NULL,NULL),(290,342,6,1,1,'2015',6,3,NULL,NULL),(291,364,6,1,1,'2015',6,3,NULL,NULL),(292,382,6,1,1,'2015',1,1,NULL,NULL),(293,383,6,1,1,'2015',3,2,NULL,NULL),(294,384,6,1,1,'2015',5,2,NULL,NULL),(295,385,6,1,1,'2015',7,3,NULL,NULL),(297,459,6,1,1,'2015',4,2,NULL,NULL),(298,486,6,1,1,'2015',7,3,NULL,NULL),(299,497,6,1,1,'2015',2,1,NULL,NULL),(301,507,6,1,1,'2015',2,1,NULL,NULL),(302,508,6,1,1,'2015',4,2,NULL,NULL),(303,509,6,1,1,'2015',6,3,NULL,NULL),(304,510,6,1,1,'2015',8,3,NULL,NULL),(305,524,6,1,1,'2015',6,3,NULL,NULL),(306,525,6,1,1,'2015',7,3,NULL,NULL),(307,534,6,1,1,'2015',6,3,NULL,NULL),(308,535,6,1,1,'2015',5,2,NULL,NULL),(309,551,6,1,1,'2015',2,1,NULL,NULL),(310,566,6,1,1,'2015',7,3,NULL,NULL),(311,588,6,1,1,'2015',8,3,NULL,NULL),(312,603,6,1,1,'2015',7,3,NULL,NULL),(313,604,6,1,1,'2015',6,3,NULL,NULL),(314,611,6,1,1,'2015',1,1,NULL,NULL),(315,612,6,1,1,'2015',1,1,NULL,NULL),(316,641,6,1,1,'2015',1,1,NULL,NULL),(317,642,6,1,1,'2015',3,2,NULL,NULL),(318,643,6,1,1,'2015',5,2,NULL,NULL),(319,644,6,1,1,'2015',7,3,NULL,NULL),(320,646,6,1,1,'2015',5,2,NULL,NULL),(321,649,6,1,1,'2015',1,1,NULL,NULL),(322,3,7,1,1,'2015',5,2,NULL,NULL),(323,12,7,1,1,'2015',7,3,NULL,NULL),(324,14,7,1,1,'2015',6,3,NULL,NULL),(325,37,7,1,1,'2015',6,3,NULL,NULL),(326,87,7,1,1,'2015',6,3,NULL,NULL),(328,117,7,1,1,'2015',3,2,NULL,NULL),(329,120,7,1,1,'2015',1,1,NULL,NULL),(330,138,7,1,1,'2015',7,3,NULL,NULL),(331,156,7,1,1,'2015',3,2,NULL,NULL),(332,164,7,1,1,'2015',4,2,NULL,NULL),(333,170,7,1,1,'2015',1,1,NULL,NULL),(335,175,7,1,1,'2015',7,3,NULL,NULL),(338,256,7,1,1,'2015',5,2,NULL,NULL),(339,260,7,1,1,'2015',2,1,NULL,NULL),(340,288,7,1,1,'2015',1,1,NULL,NULL),(341,316,7,1,1,'2015',8,3,NULL,NULL),(342,317,7,1,1,'2015',6,3,NULL,NULL),(343,320,7,1,1,'2015',4,2,NULL,NULL),(344,324,7,1,1,'2015',6,3,NULL,NULL),(345,325,7,1,1,'2015',5,2,NULL,NULL),(346,382,7,1,1,'2015',1,1,NULL,NULL),(347,383,7,1,1,'2015',3,2,NULL,NULL),(348,384,7,1,1,'2015',5,2,NULL,NULL),(349,385,7,1,1,'2015',7,3,NULL,NULL),(350,392,7,1,1,'2015',3,2,NULL,NULL),(351,406,7,1,1,'2015',8,3,NULL,NULL),(352,443,7,1,1,'2015',3,2,NULL,NULL),(353,467,7,1,1,'2015',6,3,NULL,NULL),(354,481,7,1,1,'2015',4,2,NULL,NULL),(355,482,7,1,1,'2015',2,1,NULL,NULL),(356,485,7,1,1,'2015',3,2,NULL,NULL),(357,486,7,1,1,'2015',7,3,NULL,NULL),(358,497,7,1,1,'2015',2,1,NULL,NULL),(359,499,7,1,1,'2015',4,2,NULL,NULL),(360,507,7,1,1,'2015',2,1,NULL,NULL),(361,508,7,1,1,'2015',4,2,NULL,NULL),(362,509,7,1,1,'2015',6,3,NULL,NULL),(363,510,7,1,1,'2015',8,3,NULL,NULL),(364,526,7,1,1,'2015',5,2,NULL,NULL),(365,547,7,1,1,'2015',7,3,NULL,NULL),(366,551,7,1,1,'2015',2,1,NULL,NULL),(367,599,7,1,1,'2015',8,3,NULL,NULL),(368,611,7,1,1,'2015',1,1,NULL,NULL),(369,641,7,1,1,'2015',1,1,NULL,NULL),(370,642,7,1,1,'2015',3,2,NULL,NULL),(371,643,7,1,1,'2015',5,2,NULL,NULL),(372,644,7,1,1,'2015',7,3,NULL,NULL),(373,650,7,1,1,'2015',8,3,NULL,NULL),(374,651,7,1,1,'2015',4,2,NULL,NULL),(375,3,8,1,1,'2015',5,2,NULL,NULL),(377,44,8,1,1,'2015',5,2,NULL,NULL),(379,48,8,1,1,'2015',6,3,NULL,NULL),(380,58,8,1,1,'2015',4,2,NULL,NULL),(381,116,8,1,1,'2015',4,2,NULL,NULL),(382,117,8,1,1,'2015',3,2,NULL,NULL),(383,120,8,1,1,'2015',1,1,NULL,NULL),(384,156,8,1,1,'2015',3,2,NULL,NULL),(386,164,8,1,1,'2015',4,2,NULL,NULL),(387,175,8,1,1,'2015',7,3,NULL,NULL),(388,179,8,1,1,'2015',6,3,NULL,NULL),(389,180,8,1,1,'2015',3,2,NULL,NULL),(390,210,8,1,1,'2015',3,2,NULL,NULL),(391,229,8,1,1,'2015',7,3,NULL,NULL),(392,256,8,1,1,'2015',5,2,NULL,NULL),(393,260,8,1,1,'2015',2,1,NULL,NULL),(396,317,8,1,1,'2015',6,3,NULL,NULL),(397,319,8,1,1,'2015',8,3,NULL,NULL),(398,360,8,1,1,'2015',8,3,NULL,NULL),(399,382,8,1,1,'2015',1,1,NULL,NULL),(400,383,8,1,1,'2015',3,2,NULL,NULL),(401,384,8,1,1,'2015',5,2,NULL,NULL),(402,385,8,1,1,'2015',7,3,NULL,NULL),(403,423,8,1,1,'2015',2,1,NULL,NULL),(404,486,8,1,1,'2015',7,3,NULL,NULL),(405,497,8,1,1,'2015',2,1,NULL,NULL),(406,499,8,1,1,'2015',4,2,NULL,NULL),(407,507,8,1,1,'2015',2,1,NULL,NULL),(408,508,8,1,1,'2015',4,2,NULL,NULL),(409,509,8,1,1,'2015',6,3,NULL,NULL),(410,510,8,1,1,'2015',8,3,NULL,NULL),(411,511,8,1,1,'2015',3,2,NULL,NULL),(412,513,8,1,1,'2015',1,1,NULL,NULL),(413,551,8,1,1,'2015',2,1,NULL,NULL),(414,611,8,1,1,'2015',1,1,NULL,NULL),(415,635,8,1,1,'2015',4,2,NULL,NULL),(416,636,8,1,1,'2015',2,1,NULL,NULL),(417,641,8,1,1,'2015',1,1,NULL,NULL),(418,642,8,1,1,'2015',3,2,NULL,NULL),(419,643,8,1,1,'2015',5,2,NULL,NULL),(420,644,8,1,1,'2015',7,3,NULL,NULL),(425,117,9,1,1,'2015',3,2,NULL,NULL),(427,122,9,1,1,'2015',7,3,NULL,NULL),(431,175,9,1,1,'2015',7,3,NULL,NULL),(432,183,9,1,1,'2015',8,3,NULL,NULL),(437,256,9,1,1,'2015',5,2,NULL,NULL),(441,317,9,1,1,'2015',6,3,NULL,NULL),(443,344,9,1,1,'2015',8,3,NULL,NULL),(444,382,9,1,1,'2015',1,1,NULL,NULL),(445,383,9,1,1,'2015',3,2,NULL,NULL),(446,384,9,1,1,'2015',5,2,NULL,NULL),(447,385,9,1,1,'2015',7,3,NULL,NULL),(448,390,9,1,1,'2015',6,3,NULL,NULL),(449,396,9,1,1,'2015',1,1,NULL,NULL),(453,424,9,1,1,'2015',7,3,NULL,NULL),(454,434,9,1,1,'2015',1,1,NULL,NULL),(455,454,9,1,1,'2015',8,3,NULL,NULL),(457,486,9,1,1,'2015',7,3,NULL,NULL),(458,497,9,1,1,'2015',2,1,NULL,NULL),(459,499,9,1,1,'2015',4,2,NULL,NULL),(460,501,9,1,1,'2015',7,3,NULL,NULL),(461,507,9,1,1,'2015',2,1,NULL,NULL),(462,508,9,1,1,'2015',4,2,NULL,NULL),(463,509,9,1,1,'2015',6,3,NULL,NULL),(464,510,9,1,1,'2015',8,3,NULL,NULL),(465,546,9,1,1,'2015',8,3,NULL,NULL),(466,551,9,1,1,'2015',2,1,NULL,NULL),(468,587,9,1,1,'2015',8,3,NULL,NULL),(469,611,9,1,1,'2015',1,1,NULL,NULL),(471,641,9,1,1,'2015',1,1,NULL,NULL),(472,642,9,1,1,'2015',3,2,NULL,NULL),(473,643,9,1,1,'2015',5,2,NULL,NULL),(474,644,9,1,1,'2015',7,3,NULL,NULL),(475,3,10,1,1,'2015',5,2,NULL,NULL),(476,15,10,1,1,'2015',5,2,NULL,NULL),(477,32,10,1,1,'2015',2,1,NULL,NULL),(478,33,10,1,1,'2015',4,2,NULL,NULL),(479,41,10,1,1,'2015',5,2,NULL,NULL),(480,53,10,1,1,'2015',3,2,NULL,NULL),(481,83,10,1,1,'2015',3,2,NULL,NULL),(482,103,10,1,1,'2015',6,3,NULL,NULL),(483,117,10,1,1,'2015',3,2,NULL,NULL),(484,120,10,1,1,'2015',1,1,NULL,NULL),(485,126,10,1,1,'2015',2,1,NULL,NULL),(486,146,10,1,1,'2015',6,3,NULL,NULL),(487,155,10,1,1,'2015',7,3,NULL,NULL),(488,156,10,1,1,'2015',3,2,NULL,NULL),(489,164,10,1,1,'2015',4,2,NULL,NULL),(490,175,10,1,1,'2015',7,3,NULL,NULL),(491,185,10,1,1,'2015',2,1,NULL,NULL),(492,194,10,1,1,'2015',7,3,NULL,NULL),(493,196,10,1,1,'2015',8,3,NULL,NULL),(494,246,10,1,1,'2015',8,3,NULL,NULL),(495,256,10,1,1,'2015',5,2,NULL,NULL),(496,260,10,1,1,'2015',2,1,NULL,NULL),(497,289,10,1,1,'2015',4,2,NULL,NULL),(498,294,10,1,1,'2014',1,1,1,'2023-07-19 09:42:31'),(499,301,10,1,1,'2015',4,2,NULL,NULL),(500,309,10,1,1,'2015',6,3,NULL,NULL),(501,317,10,1,1,'2015',6,3,NULL,NULL),(502,336,10,1,1,'2015',3,2,NULL,NULL),(503,367,10,1,1,'2015',8,3,NULL,NULL),(505,382,10,1,1,'2015',1,1,NULL,NULL),(506,383,10,1,1,'2015',3,2,NULL,NULL),(507,384,10,1,1,'2015',5,2,NULL,NULL),(508,385,10,1,1,'2015',7,3,NULL,NULL),(509,486,10,1,1,'2015',7,3,NULL,NULL),(510,495,10,1,1,'2015',5,2,NULL,NULL),(511,497,10,1,1,'2015',2,1,NULL,NULL),(513,507,10,1,1,'2015',2,1,NULL,NULL),(514,508,10,1,1,'2015',4,2,NULL,NULL),(515,509,10,1,1,'2015',6,3,NULL,NULL),(516,510,10,1,1,'2015',8,3,NULL,NULL),(517,514,10,1,1,'2015',6,3,NULL,NULL),(518,524,10,1,1,'2015',6,3,NULL,NULL),(519,548,10,1,1,'2015',8,3,NULL,NULL),(520,551,10,1,1,'2015',2,1,NULL,NULL),(521,566,10,1,1,'2015',7,3,NULL,NULL),(522,588,10,1,1,'2015',8,3,NULL,NULL),(523,611,10,1,1,'2015',1,1,NULL,NULL),(524,641,10,1,1,'2015',1,1,NULL,NULL),(525,642,10,1,1,'2015',3,2,NULL,NULL),(526,643,10,1,1,'2015',5,2,NULL,NULL),(527,644,10,1,1,'2015',7,3,NULL,NULL),(528,3,11,1,1,'2015',5,2,NULL,NULL),(529,45,11,1,1,'2015',6,3,NULL,NULL),(530,46,11,1,1,'2015',4,2,NULL,NULL),(533,117,11,1,1,'2015',3,2,NULL,NULL),(534,120,11,1,1,'2015',1,1,NULL,NULL),(535,156,11,1,1,'2015',3,2,NULL,NULL),(536,158,11,1,1,'2015',5,2,NULL,NULL),(537,164,11,1,1,'2015',4,2,NULL,NULL),(538,175,11,1,1,'2015',7,3,NULL,NULL),(540,233,11,1,1,'2015',8,3,NULL,NULL),(541,256,11,1,1,'2015',5,2,NULL,NULL),(542,260,11,1,1,'2015',2,1,NULL,NULL),(544,317,11,1,1,'2015',6,3,NULL,NULL),(545,358,11,1,1,'2015',1,1,NULL,NULL),(546,366,11,1,1,'2015',4,2,NULL,NULL),(547,382,11,1,1,'2015',1,1,NULL,NULL),(548,383,11,1,1,'2015',3,2,NULL,NULL),(549,384,11,1,1,'2015',5,2,NULL,NULL),(550,385,11,1,1,'2015',7,3,NULL,NULL),(551,403,11,1,1,'2015',2,1,NULL,NULL),(552,404,11,1,1,'2015',3,2,NULL,NULL),(554,476,11,1,1,'2015',1,1,NULL,NULL),(555,477,11,1,1,'2015',2,1,NULL,NULL),(556,480,11,1,1,'2015',7,3,NULL,NULL),(557,486,11,1,1,'2015',7,3,NULL,NULL),(558,491,11,1,1,'2015',3,2,NULL,NULL),(559,492,11,1,1,'2015',5,2,NULL,NULL),(560,493,11,1,1,'2015',7,3,NULL,NULL),(562,497,11,1,1,'2015',2,1,NULL,NULL),(563,499,11,1,1,'2015',4,2,NULL,NULL),(564,504,11,1,1,'2015',4,2,NULL,NULL),(565,505,11,1,1,'2015',5,2,NULL,NULL),(566,506,11,1,1,'2015',6,3,NULL,NULL),(567,507,11,1,1,'2015',2,1,NULL,NULL),(568,508,11,1,1,'2015',4,2,NULL,NULL),(569,509,11,1,1,'2015',6,3,NULL,NULL),(570,510,11,1,1,'2015',8,3,NULL,NULL),(571,551,11,1,1,'2015',2,1,NULL,NULL),(573,566,11,1,1,'2015',7,3,NULL,NULL),(574,577,11,1,1,'2015',8,3,NULL,NULL),(576,611,11,1,1,'2015',1,1,NULL,NULL),(577,641,11,1,1,'2015',1,1,NULL,NULL),(578,642,11,1,1,'2015',3,2,NULL,NULL),(579,643,11,1,1,'2015',5,2,NULL,NULL),(580,644,11,1,1,'2015',7,3,NULL,NULL),(581,3,12,1,1,'2015',5,2,NULL,NULL),(582,42,12,1,1,'2015',3,2,NULL,NULL),(583,43,12,1,1,'2015',3,2,NULL,NULL),(584,117,12,1,1,'2015',3,2,NULL,NULL),(585,120,12,1,1,'2015',1,1,NULL,NULL),(586,123,12,1,1,'2015',1,1,NULL,NULL),(587,124,12,1,1,'2015',2,1,NULL,NULL),(588,141,12,1,1,'2015',4,2,NULL,NULL),(589,142,12,1,1,'2015',5,2,NULL,NULL),(590,156,12,1,1,'2015',3,2,NULL,NULL),(591,164,12,1,1,'2015',4,2,NULL,NULL),(592,172,12,1,1,'2015',8,3,NULL,NULL),(593,175,12,1,1,'2015',7,3,NULL,NULL),(594,181,12,1,1,'2015',7,3,NULL,NULL),(595,186,12,1,1,'2015',8,3,NULL,NULL),(596,188,12,1,1,'2015',3,2,NULL,NULL),(597,230,12,1,1,'2015',7,3,NULL,NULL),(598,245,12,1,1,'2015',4,2,NULL,NULL),(599,251,12,1,1,'2015',2,1,NULL,NULL),(600,256,12,1,1,'2015',5,2,NULL,NULL),(601,259,12,1,1,'2015',7,3,NULL,NULL),(602,260,12,1,1,'2015',2,1,NULL,NULL),(603,276,12,1,1,'2015',5,2,NULL,NULL),(604,277,12,1,1,'2015',6,3,NULL,NULL),(605,293,12,1,1,'2015',1,1,NULL,NULL),(606,317,12,1,1,'2015',6,3,NULL,NULL),(607,352,12,1,1,'2015',8,3,NULL,NULL),(609,382,12,1,1,'2015',1,1,NULL,NULL),(610,383,12,1,1,'2015',3,2,NULL,NULL),(611,384,12,1,1,'2015',5,2,NULL,NULL),(612,385,12,1,1,'2015',7,3,NULL,NULL),(613,386,12,1,1,'2015',6,3,NULL,NULL),(614,391,12,1,1,'2015',4,2,NULL,NULL),(615,417,12,1,1,'2015',6,3,NULL,NULL),(616,422,12,1,1,'2015',1,1,NULL,NULL),(618,479,12,1,1,'2015',6,3,NULL,NULL),(619,486,12,1,1,'2015',7,3,NULL,NULL),(620,497,12,1,1,'2015',2,1,NULL,NULL),(621,499,12,1,1,'2015',4,2,NULL,NULL),(622,507,12,1,1,'2015',2,1,NULL,NULL),(623,508,12,1,1,'2015',4,2,NULL,NULL),(624,509,12,1,1,'2015',6,3,NULL,NULL),(625,510,12,1,1,'2015',8,3,NULL,NULL),(626,551,12,1,1,'2015',2,1,NULL,NULL),(627,611,12,1,1,'2015',1,1,NULL,NULL),(628,640,12,1,1,'2015',8,3,NULL,NULL),(629,641,12,1,1,'2015',1,1,NULL,NULL),(630,642,12,1,1,'2015',3,2,NULL,NULL),(631,643,12,1,1,'2015',5,2,NULL,NULL),(632,644,12,1,1,'2015',7,3,NULL,NULL),(633,648,12,1,1,'2015',5,2,NULL,NULL),(634,3,13,1,1,'2015',5,2,NULL,NULL),(635,13,13,1,1,'2015',6,3,NULL,NULL),(636,19,13,1,1,'2015',2,1,NULL,NULL),(637,22,13,1,1,'2015',7,3,NULL,NULL),(638,81,13,1,1,'2015',1,1,NULL,NULL),(639,86,13,1,1,'2015',6,3,NULL,NULL),(640,117,13,1,1,'2015',3,2,NULL,NULL),(641,120,13,1,1,'2015',1,1,NULL,NULL),(642,156,13,1,1,'2015',3,2,NULL,NULL),(643,158,13,1,1,'2015',5,2,NULL,NULL),(644,164,13,1,1,'2015',4,2,NULL,NULL),(645,169,13,1,1,'2015',5,2,NULL,NULL),(646,175,13,1,1,'2015',7,3,NULL,NULL),(647,187,13,1,1,'2015',3,2,NULL,NULL),(648,195,13,1,1,'2015',1,1,NULL,NULL),(649,203,13,1,1,'2015',8,3,NULL,NULL),(650,256,13,1,1,'2015',5,2,NULL,NULL),(651,260,13,1,1,'2015',2,1,NULL,NULL),(653,287,13,1,1,'2015',2,1,NULL,NULL),(654,295,13,1,1,'2015',8,3,NULL,NULL),(655,296,13,1,1,'2015',3,2,NULL,NULL),(656,317,13,1,1,'2015',6,3,NULL,NULL),(657,318,13,1,1,'2015',1,1,NULL,NULL),(658,322,13,1,1,'2015',8,3,NULL,NULL),(659,382,13,1,1,'2015',1,1,NULL,NULL),(660,383,13,1,1,'2015',3,2,NULL,NULL),(661,384,13,1,1,'2015',5,2,NULL,NULL),(662,385,13,1,1,'2015',7,3,NULL,NULL),(663,394,13,1,1,'2015',3,2,NULL,NULL),(664,427,13,1,1,'2015',6,3,NULL,NULL),(665,431,13,1,1,'2015',5,2,NULL,NULL),(666,486,13,1,1,'2015',7,3,NULL,NULL),(667,497,13,1,1,'2015',2,1,NULL,NULL),(668,499,13,1,1,'2015',4,2,NULL,NULL),(669,502,13,1,1,'2015',4,2,NULL,NULL),(670,507,13,1,1,'2015',2,1,NULL,NULL),(671,508,13,1,1,'2015',4,2,NULL,NULL),(672,509,13,1,1,'2015',6,3,NULL,NULL),(673,510,13,1,1,'2015',8,3,NULL,NULL),(674,551,13,1,1,'2015',2,1,NULL,NULL),(675,552,13,1,1,'2015',6,3,NULL,NULL),(676,566,13,1,1,'2015',7,3,NULL,NULL),(677,568,13,1,1,'2015',8,3,NULL,NULL),(678,586,13,1,1,'2015',8,3,NULL,NULL),(679,610,13,1,1,'2015',4,2,NULL,NULL),(680,611,13,1,1,'2015',1,1,NULL,NULL),(681,613,13,1,1,'2015',4,2,NULL,NULL),(682,614,13,1,1,'2015',7,3,NULL,NULL),(683,641,13,1,1,'2015',1,1,NULL,NULL),(684,642,13,1,1,'2015',3,2,NULL,NULL),(685,643,13,1,1,'2015',5,2,NULL,NULL),(686,644,13,1,1,'2015',7,3,NULL,NULL),(687,3,14,1,1,'2015',5,2,NULL,NULL),(689,98,14,1,1,'2015',8,3,NULL,NULL),(691,117,14,1,1,'2015',3,2,NULL,NULL),(692,120,14,1,1,'2015',1,1,NULL,NULL),(693,129,14,1,1,'2015',1,1,NULL,NULL),(694,139,14,1,1,'2015',7,3,NULL,NULL),(695,156,14,1,1,'2015',3,2,NULL,NULL),(696,164,14,1,1,'2015',4,2,NULL,NULL),(697,175,14,1,1,'2015',7,3,NULL,NULL),(699,209,14,1,1,'2015',7,3,NULL,NULL),(700,256,14,1,1,'2015',5,2,NULL,NULL),(701,260,14,1,1,'2015',2,1,NULL,NULL),(702,290,14,1,1,'2015',1,1,NULL,NULL),(703,317,14,1,1,'2015',6,3,NULL,NULL),(705,382,14,1,1,'2015',1,1,NULL,NULL),(706,383,14,1,1,'2015',3,2,NULL,NULL),(707,384,14,1,1,'2015',5,2,NULL,NULL),(708,385,14,1,1,'2015',7,3,NULL,NULL),(710,407,14,1,1,'2015',8,3,NULL,NULL),(711,428,14,1,1,'2015',4,2,NULL,NULL),(712,432,14,1,1,'2015',5,2,NULL,NULL),(713,433,14,1,1,'2015',6,3,NULL,NULL),(714,445,14,1,1,'2015',1,1,NULL,NULL),(715,446,14,1,1,'2015',2,1,NULL,NULL),(717,462,14,1,1,'2015',2,1,NULL,NULL),(718,464,14,1,1,'2015',6,3,NULL,NULL),(719,486,14,1,1,'2015',7,3,NULL,NULL),(720,497,14,1,1,'2015',2,1,NULL,NULL),(721,499,14,1,1,'2015',4,2,NULL,NULL),(722,507,14,1,1,'2015',2,1,NULL,NULL),(723,508,14,1,1,'2015',4,2,NULL,NULL),(724,509,14,1,1,'2015',6,3,NULL,NULL),(725,510,14,1,1,'2015',8,3,NULL,NULL),(726,540,14,1,1,'2015',5,2,NULL,NULL),(727,551,14,1,1,'2015',2,1,NULL,NULL),(729,570,14,1,1,'2015',4,2,NULL,NULL),(731,589,14,1,1,'2015',6,3,NULL,NULL),(732,600,14,1,1,'2015',8,3,NULL,NULL),(733,602,14,1,1,'2015',8,3,NULL,NULL),(734,605,14,1,1,'2015',8,3,NULL,NULL),(735,611,14,1,1,'2015',1,1,NULL,NULL),(736,641,14,1,1,'2015',1,1,NULL,NULL),(737,642,14,1,1,'2015',3,2,NULL,NULL),(738,643,14,1,1,'2015',5,2,NULL,NULL),(739,644,14,1,1,'2015',7,3,NULL,NULL),(740,3,15,1,1,'2015',5,2,NULL,NULL),(741,31,15,1,1,'2015',8,3,NULL,NULL),(742,92,15,1,1,'2015',6,3,NULL,NULL),(743,93,15,1,1,'2015',8,3,NULL,NULL),(744,99,15,1,1,'2015',7,3,NULL,NULL),(745,102,15,1,1,'2015',8,3,NULL,NULL),(746,117,15,1,1,'2015',3,2,NULL,NULL),(747,120,15,1,1,'2015',1,1,NULL,NULL),(748,130,15,1,1,'2015',4,2,NULL,NULL),(749,134,15,1,1,'2015',1,1,NULL,NULL),(750,140,15,1,1,'2015',8,3,NULL,NULL),(751,156,15,1,1,'2015',3,2,NULL,NULL),(752,164,15,1,1,'2015',4,2,NULL,NULL),(753,175,15,1,1,'2015',7,3,NULL,NULL),(754,207,15,1,1,'2015',5,2,NULL,NULL),(755,208,15,1,1,'2015',6,3,NULL,NULL),(756,209,15,1,1,'2015',7,3,NULL,NULL),(757,256,15,1,1,'2015',5,2,NULL,NULL),(758,260,15,1,1,'2015',2,1,NULL,NULL),(759,268,15,1,1,'2015',1,1,NULL,NULL),(760,269,15,1,1,'2015',2,1,NULL,NULL),(761,317,15,1,1,'2015',6,3,NULL,NULL),(762,363,15,1,1,'2015',3,2,NULL,NULL),(763,382,15,1,1,'2015',1,1,NULL,NULL),(764,383,15,1,1,'2015',3,2,NULL,NULL),(765,384,15,1,1,'2015',5,2,NULL,NULL),(766,385,15,1,1,'2015',7,3,NULL,NULL),(767,451,15,1,1,'2015',1,1,NULL,NULL),(768,452,15,1,1,'2015',2,1,NULL,NULL),(769,453,15,1,1,'2015',3,2,NULL,NULL),(770,463,15,1,1,'2015',4,2,NULL,NULL),(771,464,15,1,1,'2015',6,3,NULL,NULL),(772,472,15,1,1,'2015',7,3,NULL,NULL),(773,486,15,1,1,'2015',7,3,NULL,NULL),(774,497,15,1,1,'2015',2,1,NULL,NULL),(775,499,15,1,1,'2015',4,2,NULL,NULL),(776,507,15,1,1,'2015',2,1,NULL,NULL),(777,508,15,1,1,'2015',4,2,NULL,NULL),(778,509,15,1,1,'2015',6,3,NULL,NULL),(779,510,15,1,1,'2015',8,3,NULL,NULL),(780,540,15,1,1,'2015',5,2,NULL,NULL),(781,551,15,1,1,'2015',2,1,NULL,NULL),(782,569,15,1,1,'2015',3,2,NULL,NULL),(784,576,15,1,1,'2015',8,3,NULL,NULL),(785,590,15,1,1,'2015',6,3,NULL,NULL),(786,606,15,1,1,'2015',5,2,NULL,NULL),(787,607,15,1,1,'2015',6,3,NULL,NULL),(788,611,15,1,1,'2015',1,1,NULL,NULL),(789,641,15,1,1,'2015',1,1,NULL,NULL),(790,642,15,1,1,'2015',3,2,NULL,NULL),(791,643,15,1,1,'2015',5,2,NULL,NULL),(792,644,15,1,1,'2015',7,3,NULL,NULL),(793,2,16,1,1,'2015',4,2,NULL,NULL),(794,3,16,1,1,'2015',5,2,NULL,NULL),(795,40,16,1,1,'2015',8,3,NULL,NULL),(796,49,16,1,1,'2015',5,2,NULL,NULL),(797,52,16,1,1,'2015',6,3,NULL,NULL),(799,88,16,1,1,'2015',8,3,NULL,NULL),(800,117,16,1,1,'2015',3,2,NULL,NULL),(801,120,16,1,1,'2015',1,1,NULL,NULL),(802,143,16,1,1,'2015',6,3,NULL,NULL),(803,156,16,1,1,'2015',3,2,NULL,NULL),(804,164,16,1,1,'2015',2,1,NULL,NULL),(805,175,16,1,1,'2015',7,3,NULL,NULL),(807,205,16,1,1,'2015',7,3,NULL,NULL),(808,256,16,1,1,'2015',5,2,NULL,NULL),(809,260,16,1,1,'2015',1,1,NULL,NULL),(810,266,16,1,1,'2015',1,1,NULL,NULL),(811,267,16,1,1,'2015',2,1,NULL,NULL),(812,271,16,1,1,'2015',4,2,NULL,NULL),(813,317,16,1,1,'2015',6,3,NULL,NULL),(814,323,16,1,1,'2015',3,2,NULL,NULL),(816,372,16,1,1,'2015',7,3,NULL,NULL),(817,382,16,1,1,'2015',1,1,NULL,NULL),(818,383,16,1,1,'2015',3,2,NULL,NULL),(819,384,16,1,1,'2015',5,2,NULL,NULL),(820,385,16,1,1,'2015',7,3,NULL,NULL),(822,439,16,1,1,'2015',1,1,NULL,NULL),(823,440,16,1,1,'2015',2,1,NULL,NULL),(824,441,16,1,1,'2015',3,2,NULL,NULL),(825,468,16,1,1,'2015',6,3,NULL,NULL),(826,483,16,1,1,'2015',5,2,NULL,NULL),(827,484,16,1,1,'2015',6,3,NULL,NULL),(828,486,16,1,1,'2015',7,3,NULL,NULL),(829,497,16,1,1,'2015',2,1,NULL,NULL),(830,499,16,1,1,'2015',4,2,NULL,NULL),(831,507,16,1,1,'2015',2,1,NULL,NULL),(832,508,16,1,1,'2015',4,2,NULL,NULL),(833,509,16,1,1,'2015',6,3,NULL,NULL),(834,510,16,1,1,'2015',8,3,NULL,NULL),(835,516,16,1,1,'2015',4,2,NULL,NULL),(836,519,16,1,1,'2015',4,2,NULL,NULL),(837,520,16,1,1,'2015',3,2,NULL,NULL),(838,521,16,1,1,'2015',4,2,NULL,NULL),(839,524,16,1,1,'2015',7,3,NULL,NULL),(840,551,16,1,1,'2015',2,1,NULL,NULL),(841,588,16,1,1,'2015',8,3,NULL,NULL),(842,611,16,1,1,'2015',1,1,NULL,NULL),(843,641,16,1,1,'2015',1,1,NULL,NULL),(844,642,16,1,1,'2015',3,2,NULL,NULL),(845,643,16,1,1,'2015',5,2,NULL,NULL),(846,644,16,1,1,'2015',7,3,NULL,NULL),(847,3,17,1,1,'2015',5,2,NULL,NULL),(848,73,17,1,1,'2015',3,2,NULL,NULL),(849,94,17,1,1,'2015',3,2,NULL,NULL),(850,96,17,1,1,'2015',3,2,NULL,NULL),(852,117,17,1,1,'2015',3,2,NULL,NULL),(853,118,17,1,1,'2015',2,1,NULL,NULL),(854,120,17,1,1,'2015',1,1,NULL,NULL),(855,151,17,1,1,'2015',6,3,NULL,NULL),(856,156,17,1,1,'2015',3,2,NULL,NULL),(858,164,17,1,1,'2015',4,2,NULL,NULL),(859,175,17,1,1,'2015',7,3,NULL,NULL),(862,254,17,1,1,'2015',7,3,NULL,NULL),(863,256,17,1,1,'2015',5,2,NULL,NULL),(864,260,17,1,1,'2015',2,1,NULL,NULL),(867,317,17,1,1,'2015',6,3,NULL,NULL),(868,329,17,1,1,'2015',5,2,NULL,NULL),(869,368,17,1,1,'2015',1,1,NULL,NULL),(870,370,17,1,1,'2015',1,1,NULL,NULL),(871,379,17,1,1,'2015',6,3,NULL,NULL),(872,382,17,1,1,'2015',1,1,NULL,NULL),(873,383,17,1,1,'2015',3,2,NULL,NULL),(874,384,17,1,1,'2015',5,2,NULL,NULL),(875,385,17,1,1,'2015',7,3,NULL,NULL),(878,486,17,1,1,'2015',7,3,NULL,NULL),(879,497,17,1,1,'2015',2,1,NULL,NULL),(880,499,17,1,1,'2015',4,2,NULL,NULL),(881,507,17,1,1,'2015',2,1,NULL,NULL),(882,508,17,1,1,'2015',4,2,NULL,NULL),(883,509,17,1,1,'2015',6,3,NULL,NULL),(884,510,17,1,1,'2015',8,3,NULL,NULL),(885,539,17,1,1,'2015',7,3,NULL,NULL),(886,551,17,1,1,'2015',2,1,NULL,NULL),(891,611,17,1,1,'2015',1,1,NULL,NULL),(892,641,17,1,1,'2015',1,1,NULL,NULL),(893,642,17,1,1,'2015',3,2,NULL,NULL),(894,643,17,1,1,'2015',5,2,NULL,NULL),(895,644,17,1,1,'2015',7,3,NULL,NULL),(896,3,18,1,1,'2015',5,2,NULL,NULL),(897,27,18,1,1,'2015',3,2,NULL,NULL),(898,70,18,1,1,'2015',2,1,NULL,NULL),(899,117,18,1,1,'2015',3,2,NULL,NULL),(900,120,18,1,1,'2015',1,1,NULL,NULL),(901,144,18,1,1,'2015',6,3,NULL,NULL),(902,156,18,1,1,'2015',3,2,NULL,NULL),(903,157,18,1,1,'2015',4,2,NULL,NULL),(904,164,18,1,1,'2015',4,2,NULL,NULL),(905,167,18,1,1,'2015',4,2,NULL,NULL),(906,175,18,1,1,'2015',7,3,NULL,NULL),(907,232,18,1,1,'2015',3,2,NULL,NULL),(908,252,18,1,1,'2015',1,1,NULL,NULL),(909,256,18,1,1,'2015',5,2,NULL,NULL),(910,260,18,1,1,'2015',2,1,NULL,NULL),(911,299,18,1,1,'2015',8,3,NULL,NULL),(913,302,18,1,1,'2015',7,3,NULL,NULL),(914,303,18,1,1,'2015',1,1,NULL,NULL),(915,304,18,1,1,'2015',5,2,NULL,NULL),(916,317,18,1,1,'2015',6,3,NULL,NULL),(917,332,18,1,1,'2015',5,2,NULL,NULL),(918,334,18,1,1,'2015',6,3,NULL,NULL),(919,335,18,1,1,'2015',8,3,NULL,NULL),(920,339,18,1,1,'2015',7,3,NULL,NULL),(921,340,18,1,1,'2015',1,1,NULL,NULL),(922,341,18,1,1,'2015',6,3,NULL,NULL),(923,365,18,1,1,'2015',2,1,NULL,NULL),(924,382,18,1,1,'2015',1,1,NULL,NULL),(925,383,18,1,1,'2015',3,2,NULL,NULL),(926,384,18,1,1,'2015',5,2,NULL,NULL),(927,385,18,1,1,'2015',7,3,NULL,NULL),(928,466,18,1,1,'2015',6,3,NULL,NULL),(929,469,18,1,1,'2015',8,3,NULL,NULL),(930,486,18,1,1,'2015',7,3,NULL,NULL),(931,496,18,1,1,'2015',4,2,NULL,NULL),(932,497,18,1,1,'2015',2,1,NULL,NULL),(933,499,18,1,1,'2015',4,2,NULL,NULL),(934,507,18,1,1,'2015',2,1,NULL,NULL),(935,508,18,1,1,'2015',4,2,NULL,NULL),(936,509,18,1,1,'2015',6,3,NULL,NULL),(937,510,18,1,1,'2015',8,3,NULL,NULL),(938,518,18,1,1,'2015',8,3,NULL,NULL),(939,527,18,1,1,'2015',7,3,NULL,NULL),(940,528,18,1,1,'2015',3,2,NULL,NULL),(941,529,18,1,1,'2015',5,2,NULL,NULL),(942,551,18,1,1,'2015',2,1,NULL,NULL),(943,611,18,1,1,'2015',1,1,NULL,NULL),(944,641,18,1,1,'2015',1,1,NULL,NULL),(945,642,18,1,1,'2015',3,2,NULL,NULL),(946,643,18,1,1,'2015',5,2,NULL,NULL),(947,644,18,1,1,'2015',7,3,NULL,NULL),(948,652,18,1,1,'2015',8,3,NULL,NULL),(949,3,19,1,1,'2015',5,2,NULL,NULL),(951,34,19,1,1,'2015',4,2,NULL,NULL),(955,117,19,1,1,'2015',3,2,NULL,NULL),(956,120,19,1,1,'2015',1,1,NULL,NULL),(957,145,19,1,1,'2015',5,2,NULL,NULL),(958,156,19,1,1,'2015',3,2,NULL,NULL),(959,158,19,1,1,'2015',5,2,NULL,NULL),(960,164,19,1,1,'2015',4,2,NULL,NULL),(961,165,19,1,1,'2015',5,2,NULL,NULL),(962,175,19,1,1,'2015',7,3,NULL,NULL),(966,256,19,1,1,'2015',5,2,NULL,NULL),(967,260,19,1,1,'2015',2,1,NULL,NULL),(969,317,19,1,1,'2015',6,3,NULL,NULL),(970,350,19,1,1,'2015',1,1,NULL,NULL),(972,382,19,1,1,'2015',1,1,NULL,NULL),(973,383,19,1,1,'2015',3,2,NULL,NULL),(974,384,19,1,1,'2015',5,2,NULL,NULL),(975,385,19,1,1,'2015',7,3,NULL,NULL),(976,442,19,1,1,'2015',3,2,NULL,NULL),(977,486,19,1,1,'2015',7,3,NULL,NULL),(978,497,19,1,1,'2015',2,1,NULL,NULL),(979,498,19,1,1,'2015',1,1,NULL,NULL),(980,499,19,1,1,'2015',4,2,NULL,NULL),(981,507,19,1,1,'2015',2,1,NULL,NULL),(982,508,19,1,1,'2015',4,2,NULL,NULL),(983,509,19,1,1,'2015',6,3,NULL,NULL),(984,510,19,1,1,'2015',8,3,NULL,NULL),(985,533,19,1,1,'2015',6,3,NULL,NULL),(986,542,19,1,1,'2015',2,1,NULL,NULL),(987,543,19,1,1,'2015',3,2,NULL,NULL),(988,544,19,1,1,'2015',4,2,NULL,NULL),(989,549,19,1,1,'2015',7,3,NULL,NULL),(990,551,19,1,1,'2015',2,1,NULL,NULL),(992,566,19,1,1,'2015',7,3,NULL,NULL),(993,572,19,1,1,'2015',7,3,NULL,NULL),(996,601,19,1,1,'2015',6,3,NULL,NULL),(997,609,19,1,1,'2015',4,2,NULL,NULL),(998,611,19,1,1,'2015',1,1,NULL,NULL),(999,631,19,1,1,'2015',4,2,NULL,NULL),(1000,641,19,1,1,'2015',1,1,NULL,NULL),(1001,642,19,1,1,'2015',3,2,NULL,NULL),(1002,643,19,1,1,'2015',5,2,NULL,NULL),(1003,644,19,1,1,'2015',7,3,NULL,NULL),(1004,3,20,1,1,'2015',5,2,NULL,NULL),(1008,90,20,1,1,'2015',2,1,NULL,NULL),(1009,95,20,1,1,'2015',3,2,NULL,NULL),(1010,97,20,1,1,'2015',3,2,NULL,NULL),(1011,117,20,1,1,'2015',3,2,NULL,NULL),(1012,119,20,1,1,'2015',2,1,NULL,NULL),(1013,120,20,1,1,'2015',1,1,NULL,NULL),(1014,152,20,1,1,'2015',6,3,NULL,NULL),(1015,153,20,1,1,'2015',8,3,NULL,NULL),(1016,156,20,1,1,'2015',3,2,NULL,NULL),(1017,164,20,1,1,'2015',4,2,NULL,NULL),(1018,175,20,1,1,'2015',7,3,NULL,NULL),(1020,249,20,1,1,'2015',7,3,NULL,NULL),(1021,255,20,1,1,'2015',7,3,NULL,NULL),(1022,256,20,1,1,'2015',5,2,NULL,NULL),(1023,260,20,1,1,'2015',2,1,NULL,NULL),(1024,274,20,1,1,'2015',5,2,NULL,NULL),(1025,317,20,1,1,'2015',6,3,NULL,NULL),(1026,328,20,1,1,'2015',5,2,NULL,NULL),(1027,369,20,1,1,'2015',1,1,NULL,NULL),(1028,371,20,1,1,'2015',1,1,NULL,NULL),(1029,374,20,1,1,'2015',1,1,NULL,NULL),(1030,378,20,1,1,'2015',6,3,NULL,NULL),(1031,382,20,1,1,'2015',1,1,NULL,NULL),(1032,383,20,1,1,'2015',3,2,NULL,NULL),(1033,384,20,1,1,'2015',5,2,NULL,NULL),(1034,385,20,1,1,'2015',7,3,NULL,NULL),(1035,400,20,1,1,'2015',4,2,NULL,NULL),(1036,412,20,1,1,'2015',4,2,NULL,NULL),(1038,486,20,1,1,'2015',7,3,NULL,NULL),(1039,497,20,1,1,'2015',2,1,NULL,NULL),(1040,499,20,1,1,'2015',4,2,NULL,NULL),(1041,507,20,1,1,'2015',2,1,NULL,NULL),(1042,508,20,1,1,'2015',4,2,NULL,NULL),(1043,509,20,1,1,'2015',6,3,NULL,NULL),(1044,510,20,1,1,'2015',8,3,NULL,NULL),(1047,551,20,1,1,'2015',2,1,NULL,NULL),(1048,588,20,1,1,'2015',8,3,NULL,NULL),(1049,594,20,1,1,'2015',4,2,NULL,NULL),(1050,596,20,1,1,'2015',6,3,NULL,NULL),(1052,611,20,1,1,'2015',1,1,NULL,NULL),(1053,641,20,1,1,'2015',1,1,NULL,NULL),(1054,642,20,1,1,'2015',3,2,NULL,NULL),(1055,643,20,1,1,'2015',5,2,NULL,NULL),(1056,644,20,1,1,'2015',7,3,NULL,NULL),(1057,3,21,1,1,'2015',5,2,NULL,NULL),(1058,89,21,1,1,'2015',4,2,NULL,NULL),(1060,112,21,1,1,'2015',1,1,NULL,NULL),(1061,113,21,1,1,'2015',1,1,NULL,NULL),(1062,117,21,1,1,'2015',3,2,NULL,NULL),(1063,120,21,1,1,'2015',1,1,NULL,NULL),(1064,156,21,1,1,'2015',3,2,NULL,NULL),(1066,164,21,1,1,'2015',4,2,NULL,NULL),(1067,166,21,1,1,'2015',3,2,NULL,NULL),(1068,175,21,1,1,'2015',7,3,NULL,NULL),(1070,240,21,1,1,'2015',7,3,NULL,NULL),(1071,250,21,1,1,'2015',8,3,NULL,NULL),(1072,256,21,1,1,'2015',5,2,NULL,NULL),(1073,260,21,1,1,'2015',2,1,NULL,NULL),(1074,317,21,1,1,'2015',6,3,NULL,NULL),(1075,327,21,1,1,'2015',3,2,NULL,NULL),(1077,382,21,1,1,'2015',1,1,NULL,NULL),(1078,383,21,1,1,'2015',3,2,NULL,NULL),(1079,384,21,1,1,'2015',5,2,NULL,NULL),(1080,385,21,1,1,'2015',7,3,NULL,NULL),(1081,389,21,1,1,'2015',6,3,NULL,NULL),(1082,402,21,1,1,'2015',7,3,NULL,NULL),(1083,405,21,1,1,'2015',5,2,NULL,NULL),(1084,408,21,1,1,'2015',4,2,NULL,NULL),(1086,418,21,1,1,'2015',6,3,NULL,NULL),(1087,419,21,1,1,'2015',5,2,NULL,NULL),(1088,421,21,1,1,'2015',4,2,NULL,NULL),(1089,474,21,1,1,'2015',6,3,NULL,NULL),(1090,486,21,1,1,'2015',7,3,NULL,NULL),(1091,497,21,1,1,'2015',2,1,NULL,NULL),(1092,499,21,1,1,'2015',4,2,NULL,NULL),(1093,507,21,1,1,'2015',2,1,NULL,NULL),(1094,508,21,1,1,'2015',4,2,NULL,NULL),(1095,509,21,1,1,'2015',6,3,NULL,NULL),(1096,510,21,1,1,'2015',8,3,NULL,NULL),(1097,551,21,1,1,'2015',2,1,NULL,NULL),(1101,593,21,1,1,'2015',8,3,NULL,NULL),(1102,611,21,1,1,'2015',1,1,NULL,NULL),(1103,632,21,1,1,'2015',2,1,NULL,NULL),(1104,634,21,1,1,'2015',2,1,NULL,NULL),(1105,641,21,1,1,'2015',1,1,NULL,NULL),(1106,642,21,1,1,'2015',3,2,NULL,NULL),(1107,643,21,1,1,'2015',5,2,NULL,NULL),(1108,644,21,1,1,'2015',7,3,NULL,NULL),(1109,653,21,1,1,'2015',3,2,NULL,NULL),(1110,3,22,1,1,'2015',5,2,NULL,NULL),(1111,20,22,1,1,'2015',6,3,NULL,NULL),(1112,67,22,1,1,'2015',5,2,NULL,NULL),(1113,68,22,1,1,'2015',2,1,NULL,NULL),(1114,69,22,1,1,'2015',4,2,NULL,NULL),(1115,78,22,1,1,'2015',3,2,NULL,NULL),(1116,117,22,1,1,'2015',3,2,NULL,NULL),(1117,120,22,1,1,'2015',1,1,NULL,NULL),(1118,147,22,1,1,'2015',7,3,NULL,NULL),(1119,149,22,1,1,'2015',6,3,NULL,NULL),(1120,150,22,1,1,'2015',8,3,NULL,NULL),(1121,156,22,1,1,'2015',3,2,NULL,NULL),(1122,164,22,1,1,'2015',4,2,NULL,NULL),(1123,173,22,1,1,'2015',7,3,NULL,NULL),(1124,175,22,1,1,'2015',7,3,NULL,NULL),(1126,238,22,1,1,'2015',8,3,NULL,NULL),(1127,243,22,1,1,'2015',6,3,NULL,NULL),(1128,248,22,1,1,'2015',4,2,NULL,NULL),(1129,256,22,1,1,'2015',5,2,NULL,NULL),(1130,260,22,1,1,'2015',2,1,NULL,NULL),(1131,285,22,1,1,'2015',1,1,NULL,NULL),(1132,310,22,1,1,'2015',1,1,NULL,NULL),(1133,312,22,1,1,'2015',3,2,NULL,NULL),(1134,313,22,1,1,'2015',5,2,NULL,NULL),(1135,317,22,1,1,'2015',6,3,NULL,NULL),(1136,333,22,1,1,'2015',1,1,NULL,NULL),(1137,381,22,1,1,'2015',8,3,NULL,NULL),(1138,382,22,1,1,'2015',1,1,NULL,NULL),(1139,383,22,1,1,'2015',3,2,NULL,NULL),(1140,384,22,1,1,'2015',5,2,NULL,NULL),(1141,385,22,1,1,'2015',7,3,NULL,NULL),(1142,448,22,1,1,'2015',6,3,NULL,NULL),(1143,449,22,1,1,'2015',4,2,NULL,NULL),(1144,450,22,1,1,'2015',7,3,NULL,NULL),(1145,486,22,1,1,'2015',7,3,NULL,NULL),(1146,497,22,1,1,'2015',2,1,NULL,NULL),(1147,499,22,1,1,'2015',4,2,NULL,NULL),(1148,507,22,1,1,'2015',2,1,NULL,NULL),(1149,508,22,1,1,'2015',4,2,NULL,NULL),(1150,509,22,1,1,'2015',6,3,NULL,NULL),(1151,510,22,1,1,'2015',8,3,NULL,NULL),(1152,522,22,1,1,'2015',5,2,NULL,NULL),(1153,551,22,1,1,'2015',2,1,NULL,NULL),(1154,574,22,1,1,'2015',8,3,NULL,NULL),(1155,575,22,1,1,'2015',6,3,NULL,NULL),(1156,608,22,1,1,'2015',3,2,NULL,NULL),(1157,611,22,1,1,'2015',1,1,NULL,NULL),(1158,641,22,1,1,'2015',1,1,NULL,NULL),(1159,642,22,1,1,'2015',3,2,NULL,NULL),(1160,643,22,1,1,'2015',5,2,NULL,NULL),(1161,644,22,1,1,'2015',7,3,NULL,NULL),(1162,645,22,1,1,'2015',2,1,NULL,NULL),(1163,3,23,1,1,'2015',5,2,NULL,NULL),(1164,11,23,1,1,'2015',8,3,NULL,NULL),(1165,25,23,1,1,'2015',5,2,NULL,NULL),(1166,100,23,1,1,'2015',8,3,NULL,NULL),(1167,117,23,1,1,'2015',3,2,NULL,NULL),(1168,120,23,1,1,'2015',1,1,NULL,NULL),(1169,132,23,1,1,'2015',2,1,NULL,NULL),(1170,133,23,1,1,'2015',1,1,NULL,NULL),(1171,139,23,1,1,'2015',7,3,NULL,NULL),(1172,156,23,1,1,'2015',3,2,NULL,NULL),(1173,164,23,1,1,'2015',4,2,NULL,NULL),(1174,175,23,1,1,'2015',7,3,NULL,NULL),(1175,231,23,1,1,'2015',8,3,NULL,NULL),(1176,256,23,1,1,'2015',5,2,NULL,NULL),(1177,260,23,1,1,'2015',2,1,NULL,NULL),(1178,284,23,1,1,'2015',8,3,NULL,NULL),(1179,317,23,1,1,'2015',6,3,NULL,NULL),(1180,331,23,1,1,'2015',5,2,NULL,NULL),(1181,382,23,1,1,'2015',1,1,NULL,NULL),(1182,383,23,1,1,'2015',3,2,NULL,NULL),(1183,384,23,1,1,'2015',5,2,NULL,NULL),(1184,385,23,1,1,'2015',7,3,NULL,NULL),(1185,425,23,1,1,'2015',3,2,NULL,NULL),(1186,426,23,1,1,'2015',7,3,NULL,NULL),(1187,435,23,1,1,'2015',2,1,NULL,NULL),(1188,444,23,1,1,'2015',1,1,NULL,NULL),(1189,455,23,1,1,'2015',3,2,NULL,NULL),(1190,456,23,1,1,'2015',1,1,NULL,NULL),(1191,457,23,1,1,'2015',6,3,NULL,NULL),(1192,458,23,1,1,'2015',4,2,NULL,NULL),(1193,464,23,1,1,'2015',6,3,NULL,NULL),(1194,471,23,1,1,'2015',4,2,NULL,NULL),(1195,486,23,1,1,'2015',7,3,NULL,NULL),(1196,497,23,1,1,'2015',2,1,NULL,NULL),(1197,499,23,1,1,'2015',4,2,NULL,NULL),(1198,507,23,1,1,'2015',2,1,NULL,NULL),(1199,508,23,1,1,'2015',4,2,NULL,NULL),(1200,509,23,1,1,'2015',6,3,NULL,NULL),(1201,510,23,1,1,'2015',8,3,NULL,NULL),(1202,517,23,1,1,'2015',4,2,NULL,NULL),(1204,551,23,1,1,'2015',2,1,NULL,NULL),(1205,573,23,1,1,'2015',6,3,NULL,NULL),(1206,611,23,1,1,'2015',1,1,NULL,NULL),(1207,623,23,1,1,'2015',6,3,NULL,NULL),(1208,625,23,1,1,'2015',3,2,NULL,NULL),(1209,627,23,1,1,'2015',5,2,NULL,NULL),(1210,628,23,1,1,'2015',6,3,NULL,NULL),(1211,629,23,1,1,'2015',7,3,NULL,NULL),(1212,641,23,1,1,'2015',1,1,NULL,NULL),(1213,642,23,1,1,'2015',3,2,NULL,NULL),(1214,643,23,1,1,'2015',5,2,NULL,NULL),(1215,644,23,1,1,'2015',7,3,NULL,NULL),(1216,3,24,1,1,'2015',5,2,NULL,NULL),(1217,5,24,1,1,'2015',5,2,NULL,NULL),(1219,7,24,1,1,'2015',8,3,NULL,NULL),(1220,8,24,1,1,'2015',8,3,NULL,NULL),(1221,9,24,1,1,'2015',8,3,NULL,NULL),(1222,74,24,1,1,'2015',3,2,NULL,NULL),(1229,117,24,1,1,'2015',3,2,NULL,NULL),(1230,120,24,1,1,'2015',1,1,NULL,NULL),(1231,156,24,1,1,'2015',3,2,NULL,NULL),(1232,159,24,1,1,'2015',5,2,NULL,NULL),(1233,160,24,1,1,'2015',5,2,NULL,NULL),(1236,164,24,1,1,'2015',4,2,NULL,NULL),(1237,175,24,1,1,'2015',7,3,NULL,NULL),(1241,197,24,1,1,'2015',1,1,NULL,NULL),(1242,198,24,1,1,'2015',4,2,NULL,NULL),(1243,211,24,1,1,'2015',3,2,NULL,NULL),(1244,212,24,1,1,'2015',1,1,NULL,NULL),(1246,214,24,1,1,'2015',2,1,NULL,NULL),(1250,218,24,1,1,'2015',2,1,NULL,NULL),(1254,222,24,1,1,'2015',4,2,NULL,NULL),(1259,227,24,1,1,'2015',6,3,NULL,NULL),(1260,228,24,1,1,'2015',6,3,NULL,NULL),(1264,256,24,1,1,'2015',5,2,NULL,NULL),(1265,260,24,1,1,'2015',2,1,NULL,NULL),(1266,278,24,1,1,'2015',7,3,NULL,NULL),(1267,281,24,1,1,'2015',6,3,NULL,NULL),(1269,283,24,1,1,'2015',6,3,NULL,NULL),(1270,317,24,1,1,'2015',6,3,NULL,NULL),(1271,326,24,1,1,'2015',7,3,NULL,NULL),(1272,382,24,1,1,'2015',1,1,NULL,NULL),(1273,383,24,1,1,'2015',3,2,NULL,NULL),(1274,384,24,1,1,'2015',5,2,NULL,NULL),(1275,385,24,1,1,'2015',7,3,NULL,NULL),(1276,393,24,1,1,'2015',6,3,NULL,NULL),(1277,486,24,1,1,'2015',7,3,NULL,NULL),(1278,497,24,1,1,'2015',2,1,NULL,NULL),(1279,499,24,1,1,'2015',4,2,NULL,NULL),(1280,507,24,1,1,'2015',2,1,NULL,NULL),(1281,508,24,1,1,'2015',4,2,NULL,NULL),(1282,509,24,1,1,'2015',6,3,NULL,NULL),(1283,510,24,1,1,'2015',8,3,NULL,NULL),(1284,531,24,1,1,'2015',5,2,NULL,NULL),(1285,532,24,1,1,'2015',4,2,NULL,NULL),(1286,537,24,1,1,'2015',3,2,NULL,NULL),(1287,551,24,1,1,'2015',2,1,NULL,NULL),(1288,553,24,1,1,'2015',6,3,NULL,NULL),(1289,554,24,1,1,'2015',6,3,NULL,NULL),(1293,582,24,1,1,'2015',1,1,NULL,NULL),(1297,611,24,1,1,'2015',1,1,NULL,NULL),(1298,639,24,1,1,'2015',2,1,NULL,NULL),(1299,641,24,1,1,'2015',1,1,NULL,NULL),(1300,642,24,1,1,'2015',3,2,NULL,NULL),(1301,643,24,1,1,'2015',5,2,NULL,NULL),(1302,644,24,1,1,'2015',7,3,NULL,NULL),(1303,3,25,1,1,'2015',5,2,NULL,NULL),(1304,60,25,1,1,'2015',7,3,NULL,NULL),(1305,61,25,1,1,'2015',8,3,NULL,NULL),(1308,117,25,1,1,'2015',3,2,NULL,NULL),(1309,120,25,1,1,'2015',1,1,NULL,NULL),(1310,156,25,1,1,'2015',3,2,NULL,NULL),(1312,164,25,1,1,'2015',2,1,NULL,NULL),(1313,175,25,1,1,'2015',7,3,NULL,NULL),(1315,256,25,1,1,'2015',5,2,NULL,NULL),(1318,265,25,1,1,'2015',2,1,NULL,NULL),(1319,270,25,1,1,'2015',5,2,NULL,NULL),(1321,291,25,1,1,'2015',3,2,NULL,NULL),(1323,317,25,1,1,'2015',6,3,NULL,NULL),(1325,382,25,1,1,'2015',1,1,NULL,NULL),(1326,383,25,1,1,'2015',3,2,NULL,NULL),(1327,384,25,1,1,'2015',5,2,NULL,NULL),(1328,385,25,1,1,'2015',7,3,NULL,NULL),(1329,437,25,1,1,'2015',1,1,NULL,NULL),(1330,486,25,1,1,'2015',7,3,NULL,NULL),(1331,497,25,1,1,'2015',2,1,NULL,NULL),(1332,499,25,1,1,'2015',4,2,NULL,NULL),(1333,507,25,1,1,'2015',2,1,NULL,NULL),(1334,508,25,1,1,'2015',4,2,NULL,NULL),(1335,509,25,1,1,'2015',6,3,NULL,NULL),(1336,510,25,1,1,'2015',8,3,NULL,NULL),(1337,551,25,1,1,'2015',2,1,NULL,NULL),(1339,556,25,1,1,'2015',4,2,NULL,NULL),(1340,557,25,1,1,'2015',6,3,NULL,NULL),(1341,560,25,1,1,'2015',1,1,NULL,NULL),(1342,561,25,1,1,'2015',2,1,NULL,NULL),(1343,562,25,1,1,'2015',3,2,NULL,NULL),(1344,563,25,1,1,'2015',7,3,NULL,NULL),(1345,564,25,1,1,'2015',4,2,NULL,NULL),(1346,565,25,1,1,'2015',6,3,NULL,NULL),(1350,611,25,1,1,'2015',1,1,NULL,NULL),(1351,641,25,1,1,'2015',1,1,NULL,NULL),(1352,642,25,1,1,'2015',3,2,NULL,NULL),(1353,643,25,1,1,'2015',5,2,NULL,NULL),(1354,644,25,1,1,'2015',7,3,NULL,NULL),(1356,3,26,1,1,'2015',5,2,NULL,NULL),(1357,72,26,1,1,'2015',1,1,NULL,NULL),(1359,110,26,1,1,'2015',5,2,NULL,NULL),(1360,111,26,1,1,'2015',6,3,NULL,NULL),(1361,117,26,1,1,'2015',3,2,NULL,NULL),(1362,120,26,1,1,'2015',1,1,NULL,NULL),(1363,136,26,1,1,'2015',7,3,NULL,NULL),(1364,137,26,1,1,'2015',8,3,NULL,NULL),(1365,156,26,1,1,'2015',3,2,NULL,NULL),(1366,175,26,1,1,'2015',7,3,NULL,NULL),(1367,182,26,1,1,'2015',1,1,NULL,NULL),(1368,237,26,1,1,'2015',4,2,NULL,NULL),(1369,256,26,1,1,'2015',5,2,NULL,NULL),(1371,273,26,1,1,'2015',8,3,NULL,NULL),(1372,317,26,1,1,'2015',6,3,NULL,NULL),(1373,343,26,1,1,'2015',5,2,NULL,NULL),(1378,349,26,1,1,'2015',3,2,NULL,NULL),(1379,353,26,1,1,'2015',1,1,NULL,NULL),(1380,354,26,1,1,'2015',2,1,NULL,NULL),(1381,355,26,1,1,'2015',3,2,NULL,NULL),(1382,356,26,1,1,'2015',4,2,NULL,NULL),(1385,382,26,1,1,'2015',1,1,NULL,NULL),(1386,383,26,1,1,'2015',3,2,NULL,NULL),(1387,384,26,1,1,'2015',5,2,NULL,NULL),(1388,385,26,1,1,'2015',7,3,NULL,NULL),(1389,395,26,1,1,'2015',6,3,NULL,NULL),(1390,410,26,1,1,'2015',6,3,NULL,NULL),(1391,411,26,1,1,'2015',7,3,NULL,NULL),(1392,413,26,1,1,'2015',2,1,NULL,NULL),(1393,415,26,1,1,'2015',8,3,NULL,NULL),(1396,486,26,1,1,'2015',7,3,NULL,NULL),(1397,497,26,1,1,'2015',2,1,NULL,NULL),(1398,499,26,1,1,'2015',4,2,NULL,NULL),(1399,507,26,1,1,'2015',2,1,NULL,NULL),(1400,508,26,1,1,'2015',4,2,NULL,NULL),(1401,509,26,1,1,'2015',6,3,NULL,NULL),(1403,510,26,1,1,'2015',8,3,NULL,NULL),(1404,551,26,1,1,'2015',2,1,NULL,NULL),(1405,567,26,1,1,'2015',6,3,NULL,NULL),(1406,595,26,1,1,'2015',8,3,NULL,NULL),(1407,611,26,1,1,'2015',1,1,NULL,NULL),(1408,641,26,1,1,'2015',1,1,NULL,NULL),(1409,642,26,1,1,'2015',3,2,NULL,NULL),(1410,643,26,1,1,'2015',5,2,NULL,NULL),(1411,644,26,1,1,'2015',7,3,NULL,NULL),(1413,584,5,1,1,'2015',1,1,NULL,NULL),(1418,201,5,1,1,'2015',6,3,NULL,NULL),(1422,588,5,1,1,'2015',8,3,NULL,NULL),(1424,367,5,1,1,'2015',8,3,NULL,NULL),(1426,376,5,1,1,'2015',1,1,NULL,NULL),(1427,598,3,1,1,'2015',6,3,NULL,NULL),(1428,516,25,1,1,'2015',4,2,NULL,NULL),(1429,49,25,1,1,'2015',5,2,NULL,NULL),(1430,82,25,1,1,'2015',5,2,NULL,NULL),(1433,598,25,1,1,'2015',6,3,NULL,NULL),(1434,52,25,1,1,'2015',6,3,NULL,NULL),(1435,524,25,1,1,'2015',7,3,NULL,NULL),(1437,588,25,1,1,'2015',8,3,NULL,NULL),(1438,88,25,1,1,'2015',8,3,NULL,NULL),(1446,1,26,1,1,'2015',5,2,NULL,NULL),(1448,594,17,1,1,'2015',4,2,NULL,NULL),(1449,400,17,1,1,'2015',4,2,NULL,NULL),(1451,413,17,1,1,'2015',4,2,NULL,NULL),(1458,588,17,1,1,'2015',8,3,NULL,NULL),(1477,377,21,1,1,'2015',1,1,NULL,NULL),(1478,409,21,1,1,'2015',6,3,NULL,NULL),(1480,50,11,1,1,'2015',3,2,NULL,NULL),(1482,524,11,1,1,'2015',6,3,NULL,NULL),(1483,364,11,1,1,'2015',6,3,NULL,NULL),(1486,190,11,1,1,'2015',8,3,NULL,NULL),(1487,582,19,1,1,'2015',1,1,NULL,NULL),(1492,364,19,1,1,'2015',6,3,NULL,NULL),(1497,580,19,1,1,'2015',8,3,NULL,NULL),(1498,581,2,1,1,'2015',1,1,NULL,NULL),(1499,185,7,1,1,'2015',2,1,NULL,NULL),(1500,661,29,1,1,'2015',7,3,NULL,NULL),(1501,655,29,1,1,'2015',6,3,NULL,NULL),(1502,656,29,1,1,'2015',5,2,NULL,NULL),(1503,657,29,1,1,'2015',4,2,NULL,NULL),(1504,658,29,1,1,'2015',6,3,NULL,NULL),(1505,659,28,1,1,'2015',3,2,NULL,NULL),(1506,660,28,1,1,'2015',4,2,NULL,NULL),(1507,3,28,1,1,'2015',5,2,NULL,NULL),(1508,662,28,1,1,'2015',6,3,NULL,NULL),(1509,663,27,1,1,'2015',6,3,NULL,NULL),(1510,663,28,1,1,'2015',6,3,NULL,NULL),(1511,664,28,1,1,'2015',8,3,NULL,NULL),(1512,665,28,1,1,'2015',8,3,NULL,NULL),(1513,666,28,1,1,'2015',6,3,NULL,NULL),(1514,666,27,1,1,'2015',6,3,NULL,NULL),(1515,667,28,1,1,'2015',7,3,NULL,NULL),(1516,668,27,1,1,'2015',2,1,NULL,NULL),(1518,669,27,1,1,'2015',8,3,NULL,NULL),(1519,117,28,1,1,'2015',3,2,NULL,NULL),(1520,117,27,1,1,'2015',3,2,NULL,NULL),(1521,117,29,1,1,'2015',3,2,NULL,NULL),(1522,120,28,1,1,'2015',1,1,NULL,NULL),(1523,120,27,1,1,'2015',1,1,NULL,NULL),(1524,120,29,1,1,'2015',1,1,NULL,NULL),(1525,670,29,1,1,'2015',8,3,NULL,NULL),(1526,671,28,1,1,'2015',5,2,NULL,NULL),(1527,672,27,1,1,'2015',4,2,NULL,NULL),(1528,673,27,1,1,'2015',7,3,NULL,NULL),(1529,674,28,1,1,'2015',7,3,NULL,NULL),(1530,156,28,1,1,'2015',3,2,NULL,NULL),(1531,156,27,1,1,'2015',3,2,NULL,NULL),(1532,156,29,1,1,'2015',3,2,NULL,NULL),(1533,675,28,1,1,'2015',2,1,NULL,NULL),(1534,676,29,1,1,'2015',6,3,NULL,NULL),(1535,677,29,1,1,'2015',2,1,NULL,NULL),(1536,678,27,1,1,'2015',3,2,NULL,NULL),(1537,679,28,1,1,'2015',7,3,NULL,NULL),(1541,175,28,1,1,'2015',7,3,NULL,NULL),(1542,175,27,1,1,'2015',7,3,NULL,NULL),(1543,175,29,1,1,'2015',7,3,NULL,NULL),(1544,681,28,1,1,'2015',2,1,NULL,NULL),(1545,682,27,1,1,'2015',1,1,NULL,NULL),(1546,683,29,1,1,'2015',3,2,NULL,NULL),(1547,684,28,1,1,'2015',8,3,NULL,NULL),(1548,685,28,1,1,'2015',1,1,NULL,NULL),(1549,686,27,1,1,'2015',3,2,NULL,NULL),(1550,687,27,1,1,'2015',4,2,NULL,NULL),(1551,688,27,1,1,'2015',7,3,NULL,NULL),(1552,689,27,1,1,'2015',8,3,NULL,NULL),(1553,690,27,1,1,'2015',6,3,NULL,NULL),(1554,691,27,1,1,'2015',7,3,NULL,NULL),(1555,692,28,1,1,'2015',3,2,NULL,NULL),(1556,693,29,1,1,'2015',4,2,NULL,NULL),(1557,256,28,1,1,'2015',5,2,NULL,NULL),(1558,256,27,1,1,'2015',5,2,NULL,NULL),(1559,256,29,1,1,'2015',5,2,NULL,NULL),(1560,694,27,1,1,'2015',5,2,NULL,NULL),(1561,260,27,1,1,'2015',2,1,NULL,NULL),(1563,260,29,1,1,'2015',2,1,NULL,NULL),(1565,260,28,1,1,'2015',2,1,NULL,NULL),(1567,695,28,1,1,'2015',8,3,NULL,NULL),(1568,696,28,1,1,'2015',6,3,NULL,NULL),(1569,697,29,1,1,'2015',8,3,NULL,NULL),(1570,317,28,1,1,'2015',6,3,NULL,NULL),(1571,317,27,1,1,'2015',6,3,NULL,NULL),(1572,317,29,1,1,'2015',6,3,NULL,NULL),(1573,698,27,1,1,'2015',6,3,NULL,NULL),(1574,382,28,1,1,'2015',1,1,NULL,NULL),(1575,382,27,1,1,'2015',1,1,NULL,NULL),(1576,382,29,1,1,'2015',1,1,NULL,NULL),(1577,383,28,1,1,'2015',3,2,NULL,NULL),(1578,383,27,1,1,'2015',3,2,NULL,NULL),(1579,383,29,1,1,'2015',3,2,NULL,NULL),(1580,384,28,1,1,'2015',5,2,NULL,NULL),(1581,384,27,1,1,'2015',5,2,NULL,NULL),(1582,384,29,1,1,'2015',5,2,NULL,NULL),(1583,385,28,1,1,'2015',7,3,NULL,NULL),(1584,385,27,1,1,'2015',7,3,NULL,NULL),(1585,385,29,1,1,'2015',7,3,NULL,NULL),(1586,699,27,1,1,'2015',8,3,NULL,NULL),(1587,700,29,1,1,'2015',1,1,NULL,NULL),(1588,701,29,1,1,'2015',8,3,NULL,NULL),(1589,702,27,1,1,'2015',2,1,NULL,NULL),(1590,703,27,1,1,'2015',3,2,NULL,NULL),(1591,704,27,1,1,'2015',4,2,NULL,NULL),(1592,705,27,1,1,'2015',5,2,NULL,NULL),(1593,706,27,1,1,'2015',6,3,NULL,NULL),(1594,756,27,1,1,'2015',1,1,NULL,NULL),(1595,756,28,1,1,'2015',1,1,NULL,NULL),(1596,756,29,1,1,'2015',1,1,NULL,NULL),(1597,707,27,1,1,'2015',8,3,NULL,NULL),(1598,708,29,1,1,'2015',4,2,NULL,NULL),(1599,709,28,1,1,'2015',4,2,NULL,NULL),(1600,709,29,1,1,'2015',3,2,NULL,NULL),(1601,710,28,1,1,'2015',5,2,NULL,NULL),(1602,486,28,1,1,'2015',7,3,NULL,NULL),(1603,486,27,1,1,'2015',7,3,NULL,NULL),(1604,486,29,1,1,'2015',7,3,NULL,NULL),(1605,711,29,1,1,'2015',5,2,NULL,NULL),(1606,497,28,1,1,'2015',2,1,NULL,NULL),(1607,497,27,1,1,'2015',2,1,NULL,NULL),(1608,497,29,1,1,'2015',2,1,NULL,NULL),(1609,712,29,1,1,'2015',6,3,NULL,NULL),(1610,713,29,1,1,'2015',3,2,NULL,NULL),(1611,499,28,1,1,'2015',4,2,NULL,NULL),(1612,499,27,1,1,'2015',4,2,NULL,NULL),(1613,499,29,1,1,'2015',4,2,NULL,NULL),(1614,507,28,1,1,'2015',2,1,NULL,NULL),(1615,507,27,1,1,'2015',2,1,NULL,NULL),(1616,507,29,1,1,'2015',2,1,NULL,NULL),(1617,508,28,1,1,'2015',4,2,NULL,NULL),(1618,508,27,1,1,'2015',4,2,NULL,NULL),(1619,508,29,1,1,'2015',4,2,NULL,NULL),(1620,509,28,1,1,'2015',6,3,NULL,NULL),(1621,509,27,1,1,'2015',6,3,NULL,NULL),(1622,509,29,1,1,'2015',6,3,NULL,NULL),(1623,510,28,1,1,'2015',8,3,NULL,NULL),(1624,510,27,1,1,'2015',8,3,NULL,NULL),(1625,510,29,1,1,'2015',8,3,NULL,NULL),(1626,714,28,1,1,'2015',1,1,NULL,NULL),(1627,715,29,1,1,'2015',5,2,NULL,NULL),(1628,551,28,1,1,'2015',2,1,NULL,NULL),(1629,551,27,1,1,'2015',2,1,NULL,NULL),(1630,551,29,1,1,'2015',2,1,NULL,NULL),(1631,716,29,1,1,'2015',1,1,NULL,NULL),(1632,717,28,1,1,'2015',4,2,NULL,NULL),(1633,718,28,1,1,'2015',8,3,NULL,NULL),(1634,718,29,1,1,'2015',8,3,NULL,NULL),(1635,719,29,1,1,'2015',8,3,NULL,NULL),(1636,611,28,1,1,'2015',1,1,NULL,NULL),(1637,611,27,1,1,'2015',1,1,NULL,NULL),(1638,611,29,1,1,'2015',1,1,NULL,NULL),(1639,720,27,1,1,'2015',8,3,NULL,NULL),(1640,721,27,1,1,'2015',1,1,NULL,NULL),(1641,722,28,1,1,'2015',8,3,NULL,NULL),(1642,723,29,1,1,'2015',6,3,NULL,NULL),(1643,724,28,1,1,'2015',5,2,NULL,NULL),(1644,724,27,1,1,'2015',5,2,NULL,NULL),(1645,642,28,1,1,'2015',3,2,NULL,NULL),(1646,642,27,1,1,'2015',3,2,NULL,NULL),(1647,642,29,1,1,'2015',3,2,NULL,NULL),(1648,643,28,1,1,'2015',5,2,NULL,NULL),(1649,643,27,1,1,'2015',5,2,NULL,NULL),(1650,643,29,1,1,'2015',5,2,NULL,NULL),(1651,641,28,1,1,'2015',1,1,NULL,NULL),(1652,641,27,1,1,'2015',1,1,NULL,NULL),(1653,641,29,1,1,'2015',1,1,NULL,NULL),(1654,644,28,1,1,'2015',7,3,NULL,NULL),(1655,644,27,1,1,'2015',7,3,NULL,NULL),(1656,644,29,1,1,'2015',7,3,NULL,NULL),(1657,725,27,1,1,'2015',8,3,NULL,NULL),(1658,726,28,1,1,'2015',3,2,NULL,NULL),(1659,727,29,1,1,'2015',7,3,NULL,NULL),(1660,728,29,1,1,'2015',7,3,NULL,NULL),(1661,581,24,1,1,'2015',1,1,NULL,NULL),(1691,758,19,1,1,'2015',4,2,NULL,NULL),(1694,658,28,1,1,'2015',6,3,NULL,NULL),(1701,73,24,1,1,'2015',3,2,NULL,NULL),(1702,221,24,1,1,'2015',4,2,NULL,NULL),(1704,552,24,1,1,'2015',6,3,NULL,NULL),(1705,6,24,1,1,'2015',6,3,NULL,NULL),(1708,106,24,1,1,'2015',8,3,NULL,NULL),(1709,190,24,1,1,'2015',8,3,NULL,NULL),(1710,577,24,1,1,'2015',8,3,NULL,NULL),(1711,233,24,1,1,'2015',8,3,NULL,NULL),(1712,760,11,1,1,'2015',1,1,NULL,NULL),(1713,761,12,1,1,'2017',1,1,NULL,NULL),(1715,763,29,1,1,'2017',2,1,NULL,NULL),(1716,584,19,1,1,'2017',1,1,NULL,NULL),(1717,764,19,1,1,'2017',1,1,NULL,NULL),(1721,769,12,1,1,'2017',1,1,NULL,NULL),(1722,768,12,1,1,'2017',1,1,NULL,NULL),(1724,771,10,1,1,'2015',1,1,NULL,NULL),(1725,767,11,1,1,'2015',1,1,NULL,NULL),(1726,649,11,1,1,'2015',1,1,NULL,NULL),(1727,760,10,1,1,'2015',1,1,NULL,NULL),(1729,773,18,1,1,'2015',1,1,NULL,NULL),(1731,775,26,1,1,'2015',2,1,NULL,NULL),(1733,778,26,1,1,'2015',2,1,NULL,NULL),(1734,779,14,1,1,'2015',2,1,NULL,NULL),(1735,780,12,1,1,'2015',2,1,NULL,NULL),(1736,774,19,1,1,'2015',2,1,NULL,NULL),(1737,782,22,1,1,'2015',1,1,NULL,NULL),(1738,591,26,1,1,'Lenguas Extranjeras',2,1,NULL,NULL),(1739,783,14,1,1,'2015',3,2,NULL,NULL),(1740,10,14,1,1,'2015',3,2,NULL,NULL),(1741,785,14,1,1,'2015',3,2,NULL,NULL),(1742,786,14,1,1,'2015',2,1,NULL,NULL),(1744,787,14,1,1,'2015',2,1,NULL,NULL),(1745,789,14,1,1,'2015',3,2,NULL,NULL),(1746,569,14,1,1,'2015',3,2,NULL,NULL),(1747,206,14,1,1,'2015',4,2,NULL,NULL),(1748,790,14,1,1,'2015',4,2,NULL,NULL),(1749,791,14,1,1,'2015',4,2,NULL,NULL),(1750,792,14,1,1,'2015',5,2,NULL,NULL),(1751,793,14,1,1,'2015',5,2,NULL,NULL),(1752,794,14,1,1,'2015',5,2,NULL,NULL),(1753,795,14,1,1,'2015',5,2,NULL,NULL),(1755,362,14,1,1,'2015',6,3,NULL,NULL),(1756,800,14,1,1,'2015',6,3,NULL,NULL),(1757,801,14,1,1,'2015',6,3,NULL,NULL),(1758,802,14,1,1,'2015',6,3,NULL,NULL),(1759,799,14,1,1,'2015',6,3,NULL,NULL),(1760,797,14,1,1,'2015',6,3,NULL,NULL),(1761,798,14,1,1,'2015',6,3,NULL,NULL),(1762,803,14,1,1,'2015',6,3,NULL,NULL),(1763,804,14,1,1,'2015',6,3,NULL,NULL),(1764,805,14,1,1,'2015',6,3,NULL,NULL),(1765,101,14,1,1,'2015',7,3,NULL,NULL),(1767,807,14,1,1,'2015',7,3,NULL,NULL),(1768,808,14,1,1,'2015',7,3,NULL,NULL),(1769,809,14,1,1,'2015',7,3,NULL,NULL),(1770,810,14,1,1,'2015',8,3,NULL,NULL),(1771,811,14,1,1,'2015',8,3,NULL,NULL),(1772,812,14,1,1,'2015',8,3,NULL,NULL),(1773,571,14,1,1,'2015',8,3,NULL,NULL),(1774,813,14,1,1,'2015',8,3,NULL,NULL),(1775,814,14,1,1,'2015',8,3,NULL,NULL),(1776,815,14,1,1,'2015',8,3,NULL,NULL),(1777,102,14,1,1,'2015',8,3,NULL,NULL),(1778,817,14,1,1,'2015',8,3,NULL,NULL),(1779,818,14,1,1,'2015',8,3,NULL,NULL),(1780,819,14,1,1,'2015',8,3,NULL,NULL),(1781,820,14,1,1,'2015',8,3,NULL,NULL),(1782,821,14,1,1,'2015',6,3,NULL,NULL),(1783,822,14,1,1,'2015',8,3,NULL,NULL),(1784,773,2,1,1,'2015',1,1,NULL,NULL),(1785,104,7,1,1,'2015',1,1,NULL,NULL),(1786,824,21,1,1,'2015',2,1,NULL,NULL),(1787,823,21,1,1,'2015',2,1,NULL,NULL),(1788,826,28,1,1,'2015',2,1,NULL,NULL),(1789,826,29,1,1,'2015',2,1,NULL,NULL),(1791,829,26,1,1,'2015',3,2,NULL,NULL),(1793,832,26,1,1,'2015',6,3,NULL,NULL),(1794,830,20,1,1,'2015',3,2,NULL,NULL),(1795,831,3,1,1,'2015',3,2,NULL,NULL),(1796,827,18,1,1,'2015',2,1,NULL,NULL),(1797,828,18,1,1,'2015',2,1,NULL,NULL),(1798,833,18,1,1,'2015',2,1,NULL,NULL),(1799,834,22,1,1,'2015',2,1,NULL,NULL),(1800,835,22,1,1,'2015',2,1,NULL,NULL),(1801,836,21,1,1,'2015',2,1,NULL,NULL),(1802,837,21,1,1,'2015',2,1,NULL,NULL),(1803,842,21,1,1,'2015',1,1,NULL,NULL),(1804,841,21,1,1,'2015',1,1,NULL,NULL),(1805,843,21,1,1,'2015',1,1,NULL,NULL),(1806,765,10,1,1,'2015',2,1,NULL,NULL),(1808,838,8,1,1,'2015',2,1,NULL,NULL),(1809,839,8,1,1,'2015',2,1,NULL,NULL),(1810,770,12,1,1,'2015',1,1,NULL,NULL),(1811,840,12,1,1,'2015',2,1,NULL,NULL),(1813,844,18,1,1,'2015',1,1,NULL,NULL),(1814,845,12,1,1,'2015',6,3,NULL,NULL),(1815,846,12,1,1,'2015',3,2,NULL,NULL),(1816,581,18,1,1,'2015',1,1,NULL,NULL),(1817,78,25,1,1,'Química',3,2,NULL,NULL),(1818,53,19,1,1,'2015',3,2,NULL,NULL),(1819,847,26,1,1,'Lenguas Extranjeras',3,2,NULL,NULL),(1820,848,26,1,1,'Lenguas Extranjeras',3,2,NULL,NULL),(1821,849,26,1,1,'Lenguas Extranjeras',3,2,NULL,NULL),(1822,850,26,1,1,'Lenguas Extranjeras',4,2,NULL,NULL),(1823,851,26,1,1,'Lenguas Extranjeras',4,2,NULL,NULL),(1824,852,26,1,1,'Lenguas Extranjeras',4,2,NULL,NULL),(1825,853,26,1,1,'Lenguas Extranjeras',5,2,NULL,NULL),(1826,854,26,1,1,'Lenguas Extranjeras',5,2,NULL,NULL),(1827,855,26,1,1,'Lenguas Extranjeras',5,2,NULL,NULL),(1828,856,22,1,1,'Matemática',7,3,NULL,NULL),(1829,857,22,1,1,'Matemática',6,3,NULL,NULL),(1830,858,10,1,1,'Educación primaria',3,2,NULL,NULL),(1831,859,10,1,1,'Educación primaria',6,3,NULL,NULL),(1832,860,10,1,1,'Educación primaria',8,3,NULL,NULL),(1833,861,10,1,1,'Educación primaria',8,3,NULL,NULL),(1834,862,14,1,1,'Electricidad Industr',1,1,NULL,NULL),(1835,863,14,1,1,'Electricidad Industr',1,1,NULL,NULL),(1836,235,10,1,1,'Educación Primaria',8,3,NULL,NULL),(1837,864,8,1,1,'Educación Física',5,2,NULL,NULL),(1838,869,8,1,1,'Educación Física',6,3,NULL,NULL),(1839,868,8,1,1,'Educación Física',6,3,NULL,NULL),(1840,870,8,1,1,'Educación Física',7,3,NULL,NULL),(1841,871,8,1,1,'Educación Física',7,3,NULL,NULL),(1842,875,8,1,1,'2015',5,2,NULL,NULL),(1843,872,8,1,1,'2015',6,3,NULL,NULL),(1844,873,8,1,1,'2015',8,3,NULL,NULL),(1845,874,8,1,1,'2015',8,3,NULL,NULL),(1846,876,8,1,1,'2015',8,3,NULL,NULL),(1847,879,10,1,1,'2015',1,1,NULL,NULL),(1848,880,3,1,1,'2015',4,2,NULL,NULL),(1849,881,3,1,1,'2015',4,2,NULL,NULL),(1850,882,3,1,1,'2015',4,2,NULL,NULL),(1851,881,25,1,1,'2015',4,2,NULL,NULL),(1852,280,13,1,1,'2015',6,3,NULL,NULL),(1853,883,16,1,1,'2015',5,2,NULL,NULL),(1855,884,16,1,1,'2015',8,3,NULL,NULL),(1856,885,17,1,1,'2015',1,1,NULL,NULL),(1857,886,17,1,1,'2015',2,1,NULL,NULL),(1858,887,17,1,1,'2015',8,3,NULL,NULL),(1859,275,17,1,1,'2015',5,2,NULL,NULL),(1860,888,19,1,1,'2015',6,3,NULL,NULL),(1861,890,19,1,1,'2015',8,3,NULL,NULL),(1864,891,25,1,1,'2015',4,2,NULL,NULL),(1865,894,25,1,1,'2015',4,2,NULL,NULL),(1866,895,25,1,1,'2015',4,2,NULL,NULL),(1867,896,25,1,1,'2015',8,3,NULL,NULL),(1868,321,9,1,1,'2015',1,1,NULL,NULL),(1869,397,9,1,1,'2015',2,1,NULL,NULL),(1870,184,9,1,1,'2015',2,1,NULL,NULL),(1871,260,9,1,1,'2015',2,1,NULL,NULL),(1872,241,9,1,1,'2015',3,2,NULL,NULL),(1873,398,9,1,1,'2015',3,2,NULL,NULL),(1874,156,9,1,1,'2015',3,2,NULL,NULL),(1875,16,9,1,1,'2015',3,2,NULL,NULL),(1876,309,9,1,1,'2015',4,2,NULL,NULL),(1877,399,9,1,1,'2015',4,2,NULL,NULL),(1878,637,9,1,1,'2015',4,2,NULL,NULL),(1879,164,9,1,1,'2015',4,2,NULL,NULL),(1880,461,9,1,1,'2015',5,2,NULL,NULL),(1881,83,9,1,1,'2015',5,2,NULL,NULL),(1882,158,9,1,1,'2015',5,2,NULL,NULL),(1883,3,9,1,1,'2015',5,2,NULL,NULL),(1884,242,9,1,1,'2015',6,3,NULL,NULL),(1885,253,9,1,1,'2015',6,3,NULL,NULL),(1886,552,9,1,1,'2015',6,3,NULL,NULL),(1887,579,6,1,1,'2015',8,3,NULL,NULL),(1889,793,21,1,1,'2015',5,2,NULL,NULL),(1890,803,21,1,1,'2015',6,3,NULL,NULL),(1891,806,21,1,1,'2015',7,3,NULL,NULL),(1892,817,21,1,1,'2015',8,3,NULL,NULL),(1893,809,21,1,1,'2015',8,3,NULL,NULL),(1895,3,27,1,1,'2015',5,2,NULL,NULL),(1896,3,29,1,1,'2015',5,2,NULL,NULL),(1897,897,25,1,1,'2015',4,2,NULL,NULL),(1898,899,25,1,1,'2015',4,2,NULL,NULL),(1899,553,19,1,1,'2015',6,3,NULL,NULL),(1900,588,19,1,1,'2015',8,3,NULL,NULL),(1902,73,25,1,1,'2015',3,2,NULL,NULL),(1903,900,15,1,1,'2015',3,2,NULL,NULL),(1904,901,15,1,1,'2015',4,2,NULL,NULL),(1905,902,26,1,1,'2015',4,2,NULL,NULL),(1907,903,26,1,1,'2015',4,2,NULL,NULL),(1909,904,26,1,1,'2015',4,2,NULL,NULL),(1910,906,26,1,1,'2015',4,2,NULL,NULL),(1911,907,12,1,1,'2015',4,2,NULL,NULL),(1912,104,22,1,1,'2015',1,1,NULL,NULL),(1913,73,18,1,1,'2015',3,2,NULL,NULL),(1914,260,25,1,1,'2015',1,1,NULL,NULL),(1915,300,18,1,1,'2015',6,3,NULL,NULL),(1916,158,18,1,1,'2015',5,2,NULL,NULL),(1918,908,26,1,1,'2015',5,2,NULL,NULL),(1919,909,26,1,1,'2015',6,3,NULL,NULL),(1920,910,26,1,1,'2015',6,3,NULL,NULL),(1921,911,26,1,1,'2015',6,3,NULL,NULL),(1923,912,26,1,1,'2015',7,3,NULL,NULL),(1924,913,26,1,1,'2015',7,3,NULL,NULL),(1925,272,26,1,1,'2015',8,3,NULL,NULL),(1926,914,26,1,1,'2015',8,3,NULL,NULL),(1927,915,26,1,1,'2015',8,3,NULL,NULL),(1928,357,20,1,1,'2015',5,2,NULL,NULL),(1929,916,20,1,1,'2015',6,3,NULL,NULL),(1930,918,20,1,1,'2015',6,3,NULL,NULL),(1931,919,20,1,1,'2015',6,3,NULL,NULL),(1932,922,20,1,1,'2015',7,3,NULL,NULL),(1933,923,20,1,1,'2015',8,3,NULL,NULL),(1934,924,20,1,1,'2015',8,3,NULL,NULL),(1935,595,20,1,1,'2015',8,3,NULL,NULL),(1936,925,20,1,1,'2015',8,3,NULL,NULL),(1937,926,18,1,1,'2015',1,1,NULL,NULL),(1938,927,18,1,1,'2015',2,1,NULL,NULL),(1939,928,18,1,1,'2015',2,1,NULL,NULL),(1940,929,18,1,1,'2015',3,2,NULL,NULL),(1941,930,18,1,1,'2015',3,2,NULL,NULL),(1942,932,18,1,1,'2015',4,2,NULL,NULL),(1943,933,18,1,1,'2015',6,3,NULL,NULL),(1944,934,18,1,1,'2015',8,3,NULL,NULL),(1945,935,18,1,1,'2015',8,3,NULL,NULL),(1946,936,11,1,1,'2015',1,1,NULL,NULL),(1947,937,11,1,1,'2015',2,1,NULL,NULL),(1948,938,11,1,1,'2015',3,2,NULL,NULL),(1949,939,11,1,1,'2015',3,2,NULL,NULL),(1950,942,17,1,1,'2015',5,2,NULL,NULL),(1951,944,17,1,1,'2015',6,3,NULL,NULL),(1952,945,17,1,1,'2015',6,3,NULL,NULL),(1953,946,17,1,1,'2015',8,3,NULL,NULL),(1954,947,21,1,1,'2015',3,2,NULL,NULL),(1955,948,21,1,1,'2015',3,2,NULL,NULL),(1956,949,8,1,1,'2015',3,2,NULL,NULL),(1957,950,10,1,1,'2015',2,1,NULL,NULL),(1958,201,17,1,1,'2015',6,3,NULL,NULL),(1959,201,20,1,1,'2015',6,3,NULL,NULL),(1962,158,22,1,1,'2015',5,2,NULL,NULL),(1963,954,18,1,1,'2015',6,3,NULL,NULL),(1964,955,18,1,1,'2015',4,2,NULL,NULL),(1965,956,18,1,1,'2015',3,2,NULL,NULL),(1966,957,18,1,1,'2015',1,1,NULL,NULL),(1967,958,18,1,1,'2015',4,2,NULL,NULL),(1968,959,18,1,1,'2015',5,2,NULL,NULL),(1969,960,18,1,1,'2015',5,2,NULL,NULL),(1970,961,11,1,1,'2015',4,2,NULL,NULL),(1971,962,21,1,1,'2015',4,2,NULL,NULL),(1972,963,21,1,1,'2015',4,2,NULL,NULL),(1973,964,21,1,1,'2015',4,2,NULL,NULL),(1974,965,21,1,1,'2015',5,2,NULL,NULL),(1976,966,23,1,1,'2015',4,2,NULL,NULL),(1977,953,17,1,1,'2015',4,2,NULL,NULL),(1978,951,1,1,1,'2015',5,2,NULL,NULL),(1979,796,14,1,1,'2015',3,2,NULL,NULL),(1980,120,9,1,1,'2015',1,1,NULL,NULL),(1981,29,3,1,1,'2015',6,3,NULL,NULL),(1982,499,10,1,1,'2015',4,2,NULL,NULL),(1983,967,12,1,1,'2015',3,2,NULL,NULL),(1984,968,19,1,1,'2015',5,2,NULL,NULL),(1985,969,22,1,1,'2015',6,3,NULL,NULL),(1986,970,22,1,1,'2015',6,3,NULL,NULL),(1987,965,22,1,1,'2015',5,2,NULL,NULL),(1988,158,21,1,1,'2015',5,2,NULL,NULL),(1989,485,11,1,1,'2015',3,2,NULL,NULL),(1990,176,11,1,1,'2015',5,2,NULL,NULL),(1991,965,12,1,1,'2015',5,2,NULL,NULL),(1992,965,17,1,1,'2015',5,2,NULL,NULL),(1993,972,12,1,1,'2015',8,3,NULL,NULL),(1994,806,14,1,1,'2015',7,3,NULL,NULL),(1995,976,26,1,1,'2015',6,3,NULL,NULL),(1996,978,26,1,1,'2015',6,3,NULL,NULL),(1997,979,26,1,1,'2015',6,3,NULL,NULL),(1998,982,26,1,1,'2015',6,3,NULL,NULL),(2003,416,26,1,1,'2015',7,3,NULL,NULL),(2004,986,26,1,1,'2015',7,3,NULL,NULL),(2005,988,26,1,1,'2015',7,3,NULL,NULL),(2006,188,10,1,1,'2015',3,2,NULL,NULL),(2007,188,29,1,1,'2015',3,2,NULL,NULL),(2008,78,20,1,1,'2015',3,2,NULL,NULL),(2009,78,16,1,1,'2015',3,2,NULL,NULL),(2013,993,21,1,1,'2015',6,3,NULL,NULL),(2014,994,21,1,1,'2015',6,3,NULL,NULL),(2015,995,21,1,1,'2015',6,3,NULL,NULL),(2016,996,26,1,1,'2015',3,2,NULL,NULL),(2017,997,26,1,1,'2015',3,2,NULL,NULL),(2018,38,11,1,1,'2015',3,2,NULL,NULL),(2019,1010,4,1,1,'2015',8,3,NULL,NULL),(2020,773,5,1,1,'2015',1,1,NULL,NULL),(2021,1001,5,1,1,'2015',2,1,NULL,NULL),(2022,1002,5,1,1,'2015',2,1,NULL,NULL),(2023,1003,5,1,1,'2015',4,2,NULL,NULL),(2024,1004,5,1,1,'2015',4,2,NULL,NULL),(2025,1005,5,1,1,'2015',6,3,NULL,NULL),(2026,1006,5,1,1,'2015',6,3,NULL,NULL),(2027,1007,5,1,1,'2015',8,3,NULL,NULL),(2028,1008,5,1,1,'2015',8,3,NULL,NULL),(2029,1009,5,1,1,'2015',8,3,NULL,NULL),(2030,998,18,1,1,'2015',4,2,NULL,NULL),(2031,999,18,1,1,'2015',8,3,NULL,NULL),(2032,1000,18,1,1,'2015',8,3,NULL,NULL),(2035,1018,12,1,1,'2015',6,3,NULL,NULL),(2036,1019,12,1,1,'2015',8,3,NULL,NULL),(2037,1020,12,1,1,'2015',8,3,NULL,NULL),(2038,1017,11,1,1,'2015',5,2,NULL,NULL),(2039,1014,21,1,1,'2015',5,2,NULL,NULL),(2040,1015,21,1,1,'2015',7,3,NULL,NULL),(2041,1016,21,1,1,'2015',7,3,NULL,NULL),(2042,1021,12,1,1,'2015',8,3,NULL,NULL),(2043,1011,1,1,1,'2015',6,3,NULL,NULL),(2044,1011,2,1,1,'2015',6,3,NULL,NULL),(2045,1011,3,1,1,'2015',6,3,NULL,NULL),(2046,1011,4,1,1,'2015',6,3,NULL,NULL),(2047,1011,5,1,1,'2015',6,3,NULL,NULL),(2048,1011,6,1,1,'2015',6,3,NULL,NULL),(2049,1011,7,1,1,'2015',6,3,NULL,NULL),(2050,1011,8,1,1,'2015',6,3,NULL,NULL),(2051,1011,9,1,1,'2015',6,3,NULL,NULL),(2052,1011,10,1,1,'2015',6,3,NULL,NULL),(2053,1011,11,1,1,'2015',6,3,NULL,NULL),(2054,1011,12,1,1,'2015',6,3,NULL,NULL),(2056,1011,16,1,1,'2015',6,3,NULL,NULL),(2057,1011,17,1,1,'2015',6,3,NULL,NULL),(2059,1011,19,1,1,'2015',6,3,NULL,NULL),(2060,1011,20,1,1,'2015',6,3,NULL,NULL),(2061,1011,21,1,1,'2015',6,3,NULL,NULL),(2062,1011,22,1,1,'2015',6,3,NULL,NULL),(2063,1011,25,1,1,'2015',6,3,NULL,NULL),(2064,1011,27,1,1,'2015',6,3,NULL,NULL),(2065,1011,28,1,1,'2015',6,3,NULL,NULL),(2066,1011,29,1,1,'2015',6,3,NULL,NULL),(2069,881,4,1,1,'2015',4,2,NULL,NULL),(2074,881,16,1,1,'2015',4,2,NULL,NULL),(2077,881,25,1,1,'2015',4,2,NULL,NULL),(2078,1022,19,1,1,'2015',6,3,NULL,NULL),(2080,1024,25,1,1,'2015',6,3,NULL,NULL),(2081,1025,11,1,1,'2015',6,3,NULL,NULL),(2083,992,3,1,1,'2015',5,2,NULL,NULL),(2084,1027,11,1,1,'2015',6,3,NULL,NULL),(2085,1028,11,1,1,'2015',6,3,NULL,NULL),(2086,894,3,1,1,'2015',4,2,NULL,NULL),(2087,1029,11,1,1,'2015',6,3,NULL,NULL),(2088,1030,11,1,1,'2015',8,3,NULL,NULL),(2089,989,18,1,1,'2015',5,2,NULL,NULL),(2091,499,6,1,1,'2015',4,2,NULL,NULL),(2092,1032,6,1,1,'2015',8,3,NULL,NULL),(2093,1031,6,1,1,'2015',8,3,NULL,NULL),(2094,991,18,1,1,'2015',5,2,NULL,NULL),(2098,819,6,1,1,'2015',8,3,NULL,NULL),(2099,820,6,1,1,'2015',8,3,NULL,NULL),(2100,818,6,1,1,'2015',8,3,NULL,NULL),(2101,817,6,1,1,'2015',8,3,NULL,NULL),(2102,796,3,1,1,'2015',3,2,NULL,NULL),(2103,793,3,1,1,'2015',5,2,NULL,NULL),(2104,794,3,1,1,'2015',5,2,NULL,NULL),(2105,795,3,1,1,'2015',5,2,NULL,NULL),(2106,803,3,1,1,'2015',6,3,NULL,NULL),(2107,804,3,1,1,'2015',6,3,NULL,NULL),(2108,805,3,1,1,'2015',6,3,NULL,NULL),(2109,821,3,1,1,'2015',6,3,NULL,NULL),(2110,806,3,1,1,'2015',7,3,NULL,NULL),(2111,807,3,1,1,'2015',7,3,NULL,NULL),(2112,808,3,1,1,'2015',7,3,NULL,NULL),(2113,819,3,1,1,'2015',8,3,NULL,NULL),(2114,820,3,1,1,'2015',8,3,NULL,NULL),(2115,818,3,1,1,'2015',8,3,NULL,NULL),(2116,796,1,1,1,'2015',3,2,NULL,NULL),(2117,793,1,1,1,'2015',5,2,NULL,NULL),(2118,794,1,1,1,'2015',5,2,NULL,NULL),(2119,795,1,1,1,'2015',5,2,NULL,NULL),(2120,803,1,1,1,'2015',6,3,NULL,NULL),(2121,804,1,1,1,'2015',6,3,NULL,NULL),(2122,805,1,1,1,'2015',6,3,NULL,NULL),(2123,821,1,1,1,'2015',6,3,NULL,NULL),(2127,819,1,1,1,'2015',8,3,NULL,NULL),(2128,820,1,1,1,'2015',8,3,NULL,NULL),(2129,818,1,1,1,'2015',8,3,NULL,NULL),(2130,817,1,1,1,'2015',8,3,NULL,NULL),(2131,796,2,1,1,'2015',3,2,NULL,NULL),(2132,793,2,1,1,'2015',5,2,NULL,NULL),(2133,794,2,1,1,'2015',5,2,NULL,NULL),(2134,795,2,1,1,'2015',5,2,NULL,NULL),(2135,803,2,1,1,'2015',6,3,NULL,NULL),(2136,804,2,1,1,'2015',6,3,NULL,NULL),(2137,805,2,1,1,'2015',6,3,NULL,NULL),(2138,821,2,1,1,'2015',6,3,NULL,NULL),(2139,806,2,1,1,'2015',7,3,NULL,NULL),(2140,807,2,1,1,'2015',7,3,NULL,NULL),(2141,808,2,1,1,'2015',7,3,NULL,NULL),(2142,819,2,1,1,'2015',8,3,NULL,NULL),(2143,820,2,1,1,'2015',8,3,NULL,NULL),(2144,818,2,1,1,'2015',8,3,NULL,NULL),(2145,817,2,1,1,'2015',8,3,NULL,NULL),(2146,817,3,1,1,'2015',8,3,NULL,NULL),(2147,796,4,1,1,'2015',3,2,NULL,NULL),(2148,793,4,1,1,'2015',5,2,NULL,NULL),(2149,794,4,1,1,'2015',5,2,NULL,NULL),(2150,795,4,1,1,'2015',5,2,NULL,NULL),(2151,803,4,1,1,'2015',6,3,NULL,NULL),(2152,804,4,1,1,'2015',6,3,NULL,NULL),(2153,805,4,1,1,'2015',6,3,NULL,NULL),(2154,821,4,1,1,'2015',6,3,NULL,NULL),(2155,806,4,1,1,'2015',7,3,NULL,NULL),(2156,807,4,1,1,'2015',7,3,NULL,NULL),(2157,808,4,1,1,'2015',7,3,NULL,NULL),(2158,819,4,1,1,'2015',8,3,NULL,NULL),(2159,820,4,1,1,'2015',8,3,NULL,NULL),(2160,818,4,1,1,'2015',8,3,NULL,NULL),(2161,817,4,1,1,'2015',8,3,NULL,NULL),(2162,796,5,1,1,'2015',3,2,NULL,NULL),(2163,793,5,1,1,'2015',5,2,NULL,NULL),(2164,794,5,1,1,'2015',5,2,NULL,NULL),(2165,795,5,1,1,'2015',5,2,NULL,NULL),(2166,803,5,1,1,'2015',6,3,NULL,NULL),(2167,804,5,1,1,'2015',6,3,NULL,NULL),(2168,805,5,1,1,'2015',6,3,NULL,NULL),(2169,821,5,1,1,'2015',6,3,NULL,NULL),(2170,806,5,1,1,'2015',7,3,NULL,NULL),(2171,807,5,1,1,'2015',7,3,NULL,NULL),(2172,808,5,1,1,'2015',7,3,NULL,NULL),(2173,819,5,1,1,'2015',8,3,NULL,NULL),(2174,820,5,1,1,'2015',8,3,NULL,NULL),(2175,818,5,1,1,'2015',8,3,NULL,NULL),(2176,817,5,1,1,'2015',8,3,NULL,NULL),(2177,796,6,1,1,'2015',3,2,NULL,NULL),(2178,793,6,1,1,'2015',5,2,NULL,NULL),(2179,794,6,1,1,'2015',5,2,NULL,NULL),(2180,795,6,1,1,'2015',5,2,NULL,NULL),(2181,803,6,1,1,'2015',6,3,NULL,NULL),(2182,804,6,1,1,'2015',6,3,NULL,NULL),(2183,805,6,1,1,'2015',6,3,NULL,NULL),(2184,821,6,1,1,'2015',6,3,NULL,NULL),(2185,806,6,1,1,'2015',7,3,NULL,NULL),(2186,807,6,1,1,'2015',7,3,NULL,NULL),(2187,808,6,1,1,'2015',7,3,NULL,NULL),(2189,796,7,1,1,'2015',3,2,NULL,NULL),(2190,793,7,1,1,'2015',5,2,NULL,NULL),(2191,794,7,1,1,'2015',5,2,NULL,NULL),(2192,795,7,1,1,'2015',5,2,NULL,NULL),(2193,803,7,1,1,'2015',6,3,NULL,NULL),(2194,804,7,1,1,'2015',6,3,NULL,NULL),(2195,805,7,1,1,'2015',6,3,NULL,NULL),(2196,821,7,1,1,'2015',6,3,NULL,NULL),(2197,806,7,1,1,'2015',7,3,NULL,NULL),(2198,807,7,1,1,'2015',7,3,NULL,NULL),(2199,808,7,1,1,'2015',7,3,NULL,NULL),(2200,819,7,1,1,'2015',8,3,NULL,NULL),(2201,820,7,1,1,'2015',8,3,NULL,NULL),(2202,818,7,1,1,'2015',8,3,NULL,NULL),(2203,817,7,1,1,'2015',8,3,NULL,NULL),(2204,821,6,1,1,'2015',6,3,NULL,NULL),(2205,796,8,1,1,'2015',3,2,NULL,NULL),(2206,793,8,1,1,'2015',5,2,NULL,NULL),(2207,794,8,1,1,'2015',5,2,NULL,NULL),(2208,805,8,1,1,'2015',6,3,NULL,NULL),(2209,795,8,1,1,'2015',5,2,NULL,NULL),(2210,804,8,1,1,'2015',6,3,NULL,NULL),(2211,803,8,1,1,'2015',6,3,NULL,NULL),(2212,821,8,1,1,'2015',6,3,NULL,NULL),(2216,819,8,1,1,'2015',8,3,NULL,NULL),(2217,820,8,1,1,'2015',8,3,NULL,NULL),(2218,818,8,1,1,'2015',8,3,NULL,NULL),(2219,817,8,1,1,'2015',8,3,NULL,NULL),(2220,796,10,1,1,'2015',3,2,NULL,NULL),(2221,793,10,1,1,'2015',5,2,NULL,NULL),(2222,794,10,1,1,'2015',5,2,NULL,NULL),(2223,795,10,1,1,'2015',5,2,NULL,NULL),(2224,803,10,1,1,'2015',6,3,NULL,NULL),(2225,804,10,1,1,'2015',6,3,NULL,NULL),(2226,805,10,1,1,'2015',6,3,NULL,NULL),(2227,821,10,1,1,'2015',6,3,NULL,NULL),(2228,806,10,1,1,'2015',7,3,NULL,NULL),(2229,807,10,1,1,'2015',7,3,NULL,NULL),(2230,808,10,1,1,'2015',7,3,NULL,NULL),(2231,819,10,1,1,'2015',8,3,NULL,NULL),(2232,820,10,1,1,'2015',8,3,NULL,NULL),(2233,818,10,1,1,'2015',8,3,NULL,NULL),(2234,817,10,1,1,'2015',8,3,NULL,NULL),(2235,1034,11,1,1,'2015',6,3,NULL,NULL),(2236,1035,11,1,1,'2015',6,3,NULL,NULL),(2237,796,11,1,1,'2015',3,2,NULL,NULL),(2238,793,11,1,1,'2015',5,2,NULL,NULL),(2239,794,11,1,1,'2015',5,2,NULL,NULL),(2242,795,11,1,1,'2015',5,2,NULL,NULL),(2243,803,11,1,1,'2015',6,3,NULL,NULL),(2244,804,11,1,1,'2015',6,3,NULL,NULL),(2245,805,11,1,1,'2015',6,3,NULL,NULL),(2246,821,11,1,1,'2015',6,3,NULL,NULL),(2247,806,11,1,1,'2015',7,3,NULL,NULL),(2248,807,11,1,1,'2015',7,3,NULL,NULL),(2249,808,11,1,1,'2015',7,3,NULL,NULL),(2250,819,11,1,1,'2015',8,3,NULL,NULL),(2251,820,11,1,1,'2015',8,3,NULL,NULL),(2252,818,11,1,1,'2015',8,3,NULL,NULL),(2253,817,11,1,1,'2015',8,3,NULL,NULL),(2255,796,12,1,1,'2015',3,2,NULL,NULL),(2256,793,12,1,1,'2015',5,2,NULL,NULL),(2257,794,12,1,1,'2015',5,2,NULL,NULL),(2258,795,12,1,1,'2015',5,2,NULL,NULL),(2259,803,12,1,1,'2015',6,3,NULL,NULL),(2260,804,12,1,1,'2015',6,3,NULL,NULL),(2261,805,12,1,1,'2015',6,3,NULL,NULL),(2262,821,12,1,1,'2015',6,3,NULL,NULL),(2263,806,12,1,1,'2015',7,3,NULL,NULL),(2264,807,12,1,1,'2015',7,3,NULL,NULL),(2265,808,12,1,1,'2015',7,3,NULL,NULL),(2266,819,12,1,1,'2015',8,3,NULL,NULL),(2267,820,12,1,1,'2015',8,3,NULL,NULL),(2268,818,12,1,1,'2015',8,3,NULL,NULL),(2269,817,12,1,1,'2015',8,3,NULL,NULL),(2270,796,15,1,1,'2015',3,2,NULL,NULL),(2271,793,15,1,1,'2015',5,2,NULL,NULL),(2272,794,15,1,1,'2015',5,2,NULL,NULL),(2273,795,15,1,1,'2015',5,2,NULL,NULL),(2274,803,15,1,1,'2015',6,3,NULL,NULL),(2275,804,15,1,1,'2015',6,3,NULL,NULL),(2276,805,15,1,1,'2015',6,3,NULL,NULL),(2277,821,15,1,1,'2015',6,3,NULL,NULL),(2278,806,15,1,1,'2015',7,3,NULL,NULL),(2279,807,15,1,1,'2015',7,3,NULL,NULL),(2280,808,15,1,1,'2015',7,3,NULL,NULL),(2281,819,15,1,1,'2015',8,3,NULL,NULL),(2282,820,15,1,1,'2015',8,3,NULL,NULL),(2283,818,15,1,1,'2015',8,3,NULL,NULL),(2284,817,15,1,1,'2015',8,3,NULL,NULL),(2285,796,16,1,1,'2015',3,2,NULL,NULL),(2286,793,16,1,1,'2015',5,2,NULL,NULL),(2287,794,16,1,1,'2015',5,2,NULL,NULL),(2288,795,16,1,1,'2015',5,2,NULL,NULL),(2289,803,16,1,1,'2015',6,3,NULL,NULL),(2290,804,16,1,1,'2015',6,3,NULL,NULL),(2291,805,16,1,1,'2015',6,3,NULL,NULL),(2292,821,16,1,1,'2015',6,3,NULL,NULL),(2293,806,16,1,1,'2015',7,3,NULL,NULL),(2294,807,16,1,1,'2015',7,3,NULL,NULL),(2295,808,16,1,1,'2015',7,3,NULL,NULL),(2296,819,16,1,1,'2015',8,3,NULL,NULL),(2297,820,16,1,1,'2015',8,3,NULL,NULL),(2298,818,16,1,1,'2015',8,3,NULL,NULL),(2299,817,16,1,1,'2015',8,3,NULL,NULL),(2300,796,17,1,1,'2015',3,2,NULL,NULL),(2301,793,17,1,1,'2015',5,2,NULL,NULL),(2302,794,17,1,1,'2015',5,2,NULL,NULL),(2303,795,17,1,1,'2015',5,2,NULL,NULL),(2304,803,17,1,1,'2015',6,3,NULL,NULL),(2305,804,17,1,1,'2015',6,3,NULL,NULL),(2306,805,17,1,1,'2015',6,3,NULL,NULL),(2307,821,17,1,1,'2015',6,3,NULL,NULL),(2308,806,17,1,1,'2015',7,3,NULL,NULL),(2309,807,17,1,1,'2015',7,3,NULL,NULL),(2310,808,17,1,1,'2015',7,3,NULL,NULL),(2311,819,17,1,1,'2015',8,3,NULL,NULL),(2312,820,17,1,1,'2015',8,3,NULL,NULL),(2313,818,17,1,1,'2015',8,3,NULL,NULL),(2314,817,17,1,1,'2015',8,3,NULL,NULL),(2315,796,18,1,1,'2015',3,2,NULL,NULL),(2316,793,18,1,1,'2015',5,2,NULL,NULL),(2317,794,18,1,1,'2015',5,2,NULL,NULL),(2318,795,18,1,1,'2015',5,2,NULL,NULL),(2319,803,18,1,1,'2015',6,3,NULL,NULL),(2320,804,18,1,1,'2015',6,3,NULL,NULL),(2321,805,18,1,1,'2015',6,3,NULL,NULL),(2322,821,18,1,1,'2015',6,3,NULL,NULL),(2323,806,18,1,1,'2015',7,3,NULL,NULL),(2324,807,18,1,1,'2015',7,3,NULL,NULL),(2325,808,18,1,1,'2015',7,3,NULL,NULL),(2326,819,18,1,1,'2015',8,3,NULL,NULL),(2327,820,18,1,1,'2015',8,3,NULL,NULL),(2328,818,18,1,1,'2015',8,3,NULL,NULL),(2329,817,18,1,1,'2015',8,3,NULL,NULL),(2330,514,18,1,1,'2015',6,3,NULL,NULL),(2331,796,19,1,1,'2015',3,2,NULL,NULL),(2332,793,19,1,1,'2015',5,2,NULL,NULL),(2333,794,19,1,1,'2015',5,2,NULL,NULL),(2334,795,19,1,1,'2015',5,2,NULL,NULL),(2335,803,19,1,1,'2015',6,3,NULL,NULL),(2336,804,19,1,1,'2015',6,3,NULL,NULL),(2337,805,19,1,1,'2015',6,3,NULL,NULL),(2338,821,19,1,1,'2015',6,3,NULL,NULL),(2339,806,19,1,1,'2015',7,3,NULL,NULL),(2340,807,19,1,1,'2015',7,3,NULL,NULL),(2341,808,19,1,1,'2015',7,3,NULL,NULL),(2342,819,19,1,1,'2015',8,3,NULL,NULL),(2343,820,19,1,1,'2015',8,3,NULL,NULL),(2344,818,19,1,1,'2015',8,3,NULL,NULL),(2345,817,19,1,1,'2015',8,3,NULL,NULL),(2346,796,20,1,1,'2015',3,2,NULL,NULL),(2347,793,20,1,1,'2015',5,2,NULL,NULL),(2348,794,20,1,1,'2015',5,2,NULL,NULL),(2349,795,20,1,1,'2015',5,2,NULL,NULL),(2350,803,20,1,1,'2015',6,3,NULL,NULL),(2351,804,20,1,1,'2015',6,3,NULL,NULL),(2352,808,20,1,1,'2015',6,3,NULL,NULL),(2353,821,20,1,1,'2015',6,3,NULL,NULL),(2354,806,20,1,1,'2015',7,3,NULL,NULL),(2355,807,20,1,1,'2015',7,3,NULL,NULL),(2356,808,20,1,1,'2015',7,3,NULL,NULL),(2357,819,20,1,1,'2015',8,3,NULL,NULL),(2358,820,20,1,1,'2015',8,3,NULL,NULL),(2359,818,20,1,1,'2015',8,3,NULL,NULL),(2360,817,20,1,1,'2015',8,3,NULL,NULL),(2361,796,21,1,1,'2015',3,2,NULL,NULL),(2362,794,21,1,1,'2015',5,2,NULL,NULL),(2363,795,21,1,1,'2015',5,2,NULL,NULL),(2364,804,21,1,1,'2015',6,3,NULL,NULL),(2365,805,21,1,1,'2015',6,3,NULL,NULL),(2366,807,21,1,1,'2015',7,3,NULL,NULL),(2367,808,21,1,1,'2015',7,3,NULL,NULL),(2368,819,21,1,1,'2015',8,3,NULL,NULL),(2369,820,21,1,1,'2015',8,3,NULL,NULL),(2370,818,21,1,1,'2015',8,3,NULL,NULL),(2371,796,22,1,1,'2015',3,2,NULL,NULL),(2372,793,22,1,1,'2015',5,2,NULL,NULL),(2373,794,22,1,1,'2015',5,2,NULL,NULL),(2374,795,22,1,1,'2015',5,2,NULL,NULL),(2375,803,22,1,1,'2015',6,3,NULL,NULL),(2376,804,22,1,1,'2015',6,3,NULL,NULL),(2377,805,22,1,1,'2015',6,3,NULL,NULL),(2378,821,22,1,1,'2015',6,3,NULL,NULL),(2379,806,22,1,1,'2015',7,3,NULL,NULL),(2380,807,22,1,1,'2015',7,3,NULL,NULL),(2381,808,22,1,1,'2015',7,3,NULL,NULL),(2382,819,22,1,1,'2015',8,3,NULL,NULL),(2383,820,22,1,1,'2015',8,3,NULL,NULL),(2384,818,22,1,1,'2015',8,3,NULL,NULL),(2385,817,22,1,1,'2015',8,3,NULL,NULL),(2386,796,23,1,1,'2015',3,2,NULL,NULL),(2387,793,23,1,1,'2015',5,2,NULL,NULL),(2388,794,23,1,1,'2015',5,2,NULL,NULL),(2389,795,23,1,1,'2015',5,2,NULL,NULL),(2390,803,23,1,1,'2015',6,3,NULL,NULL),(2391,804,23,1,1,'2015',6,3,NULL,NULL),(2392,805,23,1,1,'2015',6,3,NULL,NULL),(2393,821,23,1,1,'2015',6,3,NULL,NULL),(2394,806,23,1,1,'2015',7,3,NULL,NULL),(2395,807,23,1,1,'2015',7,3,NULL,NULL),(2396,808,23,1,1,'2015',7,3,NULL,NULL),(2397,819,23,1,1,'2015',8,3,NULL,NULL),(2398,820,23,1,1,'2015',8,3,NULL,NULL),(2399,818,23,1,1,'2015',8,3,NULL,NULL),(2400,817,23,1,1,'2015',8,3,NULL,NULL),(2401,796,24,1,1,'2015',3,2,NULL,NULL),(2402,793,24,1,1,'2015',5,2,NULL,NULL),(2403,794,24,1,1,'2015',5,2,NULL,NULL),(2404,795,24,1,1,'2015',5,2,NULL,NULL),(2405,803,24,1,1,'2015',6,3,NULL,NULL),(2406,804,24,1,1,'2015',6,3,NULL,NULL),(2407,805,24,1,1,'2015',6,3,NULL,NULL),(2408,821,24,1,1,'2015',6,3,NULL,NULL),(2409,806,24,1,1,'2015',7,3,NULL,NULL),(2410,807,24,1,1,'2015',7,3,NULL,NULL),(2411,808,24,1,1,'2015',7,3,NULL,NULL),(2412,819,24,1,1,'2015',8,3,NULL,NULL),(2413,820,24,1,1,'2015',8,3,NULL,NULL),(2414,818,24,1,1,'2015',8,3,NULL,NULL),(2415,817,24,1,1,'2015',8,3,NULL,NULL),(2416,796,25,1,1,'2015',3,2,NULL,NULL),(2417,793,25,1,1,'2015',5,2,NULL,NULL),(2418,794,25,1,1,'2015',5,2,NULL,NULL),(2419,795,25,1,1,'2015',5,2,NULL,NULL),(2420,803,25,1,1,'2015',6,3,NULL,NULL),(2422,804,25,1,1,'2015',6,3,NULL,NULL),(2423,805,25,1,1,'2015',6,3,NULL,NULL),(2424,821,25,1,1,'2015',6,3,NULL,NULL),(2425,806,25,1,1,'2015',7,3,NULL,NULL),(2426,807,25,1,1,'2015',7,3,NULL,NULL),(2427,808,25,1,1,'2015',7,3,NULL,NULL),(2428,819,25,1,1,'2015',8,3,NULL,NULL),(2429,820,25,1,1,'2015',8,3,NULL,NULL),(2430,818,25,1,1,'2015',8,3,NULL,NULL),(2431,817,25,1,1,'2015',8,3,NULL,NULL),(2432,796,27,1,1,'2015',3,2,NULL,NULL),(2433,793,27,1,1,'2015',5,2,NULL,NULL),(2434,794,27,1,1,'2015',5,2,NULL,NULL),(2435,795,27,1,1,'2015',5,2,NULL,NULL),(2436,803,27,1,1,'2015',6,3,NULL,NULL),(2437,804,27,1,1,'2015',6,3,NULL,NULL),(2438,805,27,1,1,'2015',6,3,NULL,NULL),(2439,821,27,1,1,'2015',6,3,NULL,NULL),(2440,806,27,1,1,'2015',7,3,NULL,NULL),(2441,807,27,1,1,'2015',7,3,NULL,NULL),(2442,808,27,1,1,'2015',7,3,NULL,NULL),(2444,820,27,1,1,'2015',8,3,NULL,NULL),(2445,818,27,1,1,'2015',8,3,NULL,NULL),(2446,817,27,1,1,'2015',8,3,NULL,NULL),(2447,819,27,1,1,'2015',8,3,NULL,NULL),(2448,796,28,1,1,'2015',3,2,NULL,NULL),(2449,793,28,1,1,'2015',5,2,NULL,NULL),(2450,794,28,1,1,'2015',5,2,NULL,NULL),(2451,795,28,1,1,'2015',5,2,NULL,NULL),(2452,803,28,1,1,'2015',6,3,NULL,NULL),(2453,804,28,1,1,'2015',6,3,NULL,NULL),(2454,805,28,1,1,'2015',6,3,NULL,NULL),(2455,821,28,1,1,'2015',6,3,NULL,NULL),(2456,806,28,1,1,'2015',7,3,NULL,NULL),(2457,807,28,1,1,'2015',7,3,NULL,NULL),(2458,808,28,1,1,'2015',7,3,NULL,NULL),(2459,819,28,1,1,'2015',8,3,NULL,NULL),(2460,820,28,1,1,'2015',8,3,NULL,NULL),(2461,818,28,1,1,'2015',8,3,NULL,NULL),(2462,817,28,1,1,'2015',8,3,NULL,NULL),(2463,796,29,1,1,'2015',3,2,NULL,NULL),(2464,793,29,1,1,'2015',5,2,NULL,NULL),(2465,794,29,1,1,'2015',5,2,NULL,NULL),(2466,795,29,1,1,'2015',5,2,NULL,NULL),(2467,803,29,1,1,'2015',6,3,NULL,NULL),(2468,804,29,1,1,'2015',6,3,NULL,NULL),(2469,805,29,1,1,'2015',6,3,NULL,NULL),(2470,821,29,1,1,'2015',6,3,NULL,NULL),(2471,806,29,1,1,'2015',7,3,NULL,NULL),(2472,807,29,1,1,'2015',7,3,NULL,NULL),(2473,808,29,1,1,'2015',7,3,NULL,NULL),(2474,819,29,1,1,'2015',8,3,NULL,NULL),(2475,820,29,1,1,'2015',8,3,NULL,NULL),(2476,818,29,1,1,'2015',8,3,NULL,NULL),(2477,817,29,1,1,'2015',8,3,NULL,NULL),(2478,1023,25,1,1,'2015',8,3,NULL,NULL),(2479,1036,19,1,1,'2015',8,3,NULL,NULL),(2480,1011,18,1,1,'2015',6,3,NULL,NULL),(2481,1036,2,1,1,'2015',8,3,NULL,NULL),(2482,217,24,1,1,'2015',2,1,NULL,NULL),(2483,213,24,1,1,'2015',2,1,NULL,NULL),(2484,219,24,1,1,'2015',4,2,NULL,NULL),(2485,1037,24,1,1,'2015',4,2,NULL,NULL),(2486,223,24,1,1,'2015',4,2,NULL,NULL),(2487,220,24,1,1,'2015',4,2,NULL,NULL),(2488,162,24,1,1,'2015',5,2,NULL,NULL),(2489,161,24,1,1,'2015',5,2,NULL,NULL),(2490,1038,24,1,1,'2015',6,3,NULL,NULL),(2491,282,24,1,1,'2015',6,3,NULL,NULL),(2492,1039,8,1,1,'2015',1,1,NULL,NULL),(2493,1040,8,1,1,'2015',2,1,NULL,NULL),(2494,1041,8,1,1,'2015',2,1,NULL,NULL),(2495,1042,8,1,1,'2015',3,2,NULL,NULL),(2496,1043,8,1,1,'2015',3,2,NULL,NULL),(2497,1044,8,1,1,'2015',3,2,NULL,NULL),(2498,1045,8,1,1,'2015',4,2,NULL,NULL),(2499,1046,8,1,1,'2015',4,2,NULL,NULL),(2500,1047,8,1,1,'2015',4,2,NULL,NULL),(2501,1048,8,1,1,'2015',6,3,NULL,NULL),(2502,1049,8,1,1,'2015',6,3,NULL,NULL),(2503,1050,8,1,1,'2015',6,3,NULL,NULL),(2504,1051,8,1,1,'2015',6,3,NULL,NULL),(2505,1052,8,1,1,'2015',7,3,NULL,NULL),(2506,1053,8,1,1,'2015',8,3,NULL,NULL),(2507,1054,8,1,1,'2015',8,3,NULL,NULL),(2508,1055,8,1,1,'2015',8,3,NULL,NULL),(2509,260,25,1,1,'2015',1,1,NULL,NULL),(2510,806,8,1,1,'2015',7,3,NULL,NULL),(2511,807,8,1,1,'2015',7,3,NULL,NULL),(2512,808,8,1,1,'2015',7,3,NULL,NULL),(2513,164,28,1,1,'2015',4,2,NULL,NULL),(2514,164,29,1,1,'2015',4,2,NULL,NULL),(2515,164,27,1,1,'2015',4,2,NULL,NULL),(2516,796,9,1,1,'2015',3,2,NULL,NULL),(2517,793,9,1,1,'2015',5,2,NULL,NULL),(2518,794,9,1,1,'2015',5,2,NULL,NULL),(2519,795,9,1,1,'2015',5,2,NULL,NULL),(2520,803,9,1,1,'2015',6,3,NULL,NULL),(2521,804,9,1,1,'2015',6,3,NULL,NULL),(2522,805,9,1,1,'2015',6,3,NULL,NULL),(2523,821,9,1,1,'2015',6,3,NULL,NULL),(2524,806,9,1,1,'2015',7,3,NULL,NULL),(2525,807,9,1,1,'2015',7,3,NULL,NULL),(2526,808,9,1,1,'2015',7,3,NULL,NULL),(2527,819,9,1,1,'2015',8,3,NULL,NULL),(2528,820,9,1,1,'2015',8,3,NULL,NULL),(2529,818,9,1,1,'2015',8,3,NULL,NULL),(2530,817,9,1,1,'2015',8,3,NULL,NULL),(2531,793,13,1,1,'2015',5,2,NULL,NULL),(2532,794,13,1,1,'2015',5,2,NULL,NULL),(2533,795,13,1,1,'2015',5,2,NULL,NULL),(2534,112,13,1,1,'2015',3,2,NULL,NULL),(2535,803,13,1,1,'2015',6,3,NULL,NULL),(2536,804,13,1,1,'2015',6,3,NULL,NULL),(2537,805,13,1,1,'2015',6,3,NULL,NULL),(2538,821,13,1,1,'2015',6,3,NULL,NULL),(2539,806,13,1,1,'2015',7,3,NULL,NULL),(2540,807,13,1,1,'2015',7,3,NULL,NULL),(2541,808,13,1,1,'2015',7,3,NULL,NULL),(2542,817,13,1,1,'2015',8,3,NULL,NULL),(2543,819,13,1,1,'2015',8,3,NULL,NULL),(2544,818,13,1,1,'2015',8,3,NULL,NULL),(2545,820,13,1,1,'2015',8,3,NULL,NULL),(2546,968,3,1,1,'2015',5,2,NULL,NULL),(2547,968,8,1,1,'2015',5,2,NULL,NULL),(2548,1036,8,1,1,'2015',8,3,NULL,NULL),(2549,1036,10,1,1,'2015',8,3,NULL,NULL),(2550,1036,12,1,1,'2015',8,3,NULL,NULL),(2551,1056,11,1,1,'2015',8,3,NULL,NULL),(2552,1057,11,1,1,'2015',8,3,NULL,NULL),(2553,1058,17,1,1,'2015',8,3,NULL,NULL),(2554,1061,17,1,1,'2015',8,3,NULL,NULL),(2555,1059,17,1,1,'2015',8,3,NULL,NULL),(2556,1060,17,1,1,'2015',8,3,NULL,NULL),(2557,806,1,1,1,'2015',7,3,NULL,NULL),(2558,808,1,1,1,'2015',7,3,NULL,NULL),(2559,807,1,1,1,'2015',7,3,NULL,NULL),(2561,1036,1,1,1,'2015',8,3,NULL,NULL),(2562,1036,5,1,1,'2015',8,3,NULL,NULL),(2563,1062,8,1,1,'2015',8,3,NULL,NULL),(2564,1064,8,1,1,'2015',8,3,NULL,NULL),(2565,1063,22,1,1,'2015',4,2,NULL,NULL),(2566,1064,22,1,1,'2015',8,3,NULL,NULL),(2567,1064,1,1,1,'2015',8,3,NULL,NULL),(2568,1064,2,1,1,'2015',8,3,NULL,NULL),(2569,1064,3,1,1,'2015',8,3,NULL,NULL),(2570,1036,3,1,1,'2015',8,3,NULL,NULL),(2571,1064,4,1,1,'2015',8,3,NULL,NULL),(2572,1064,5,1,1,'2015',8,3,NULL,NULL),(2573,1064,6,1,1,'2015',8,3,NULL,NULL),(2574,1064,7,1,1,'2015',8,3,NULL,NULL),(2575,1064,9,1,1,'2015',8,3,NULL,NULL),(2576,1064,10,1,1,'2015',8,3,NULL,NULL),(2577,1064,11,1,1,'2015',8,3,NULL,NULL),(2578,1064,12,1,1,'2015',8,3,NULL,NULL),(2579,1064,13,1,1,'2015',8,3,NULL,NULL),(2580,1064,14,1,1,'2015',8,3,NULL,NULL),(2581,1064,15,1,1,'2015',8,3,NULL,NULL),(2582,1064,16,1,1,'2015',8,3,NULL,NULL),(2583,1064,17,1,1,'2015',8,3,NULL,NULL),(2584,1064,18,1,1,'2015',8,3,NULL,NULL),(2585,1064,19,1,1,'2015',8,3,NULL,NULL),(2586,1064,20,1,1,'2015',8,3,NULL,NULL),(2587,1064,21,1,1,'2015',8,3,NULL,NULL),(2588,1064,23,1,1,'2015',8,3,NULL,NULL),(2589,1064,24,1,1,'2015',8,3,NULL,NULL),(2590,1064,25,1,1,'2015',8,3,NULL,NULL),(2591,1064,26,1,1,'2015',8,3,NULL,NULL),(2592,1064,27,1,1,'2015',8,3,NULL,NULL),(2593,1064,28,1,1,'2015',8,3,NULL,NULL),(2594,1064,29,1,1,'2015',8,3,NULL,NULL);
/*!40000 ALTER TABLE `plan_estudio` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `prelacion`
--

DROP TABLE IF EXISTS `prelacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `prelacion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `plan_id` int(11) DEFAULT NULL,
  `curso_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_DCCF207DE899029B` (`plan_id`),
  KEY `IDX_DCCF207D87CB4A1F` (`curso_id`),
  CONSTRAINT `FK_DCCF207D87CB4A1F` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`),
  CONSTRAINT `FK_DCCF207DE899029B` FOREIGN KEY (`plan_id`) REFERENCES `plan_estudio` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `prelacion`
--

LOCK TABLES `prelacion` WRITE;
/*!40000 ALTER TABLE `prelacion` DISABLE KEYS */;
INSERT INTO `prelacion` VALUES (1,715,445),(2,1745,290),(3,1746,290),(4,729,569),(5,1750,570),(6,713,432),(7,1755,432),(8,699,206),(9,1765,433),(10,1771,362);
/*!40000 ALTER TABLE `prelacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `procesos`
--

DROP TABLE IF EXISTS `procesos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `procesos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lapso_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `codigo` varchar(5) NOT NULL,
  `descripcion` varchar(150) DEFAULT NULL,
  `fechainicial` date NOT NULL,
  `fechafinal` date NOT NULL,
  `estado` tinyint(1) DEFAULT NULL,
  `subsede_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E493B93F80B24165` (`lapso_id`),
  KEY `IDX_E493B93FE19F41BF` (`sede_id`),
  KEY `IDX_E493B93FAAFDE970` (`subsede_id`),
  CONSTRAINT `FK_E493B93F80B24165` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`),
  CONSTRAINT `FK_E493B93FAAFDE970` FOREIGN KEY (`subsede_id`) REFERENCES `subsede` (`id`),
  CONSTRAINT `FK_E493B93FE19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `procesos`
--

LOCK TABLES `procesos` WRITE;
/*!40000 ALTER TABLE `procesos` DISABLE KEYS */;
INSERT INTO `procesos` VALUES (2,1,1,'PI','Proceso De Inscripcion','2024-01-01','2025-12-31',1,NULL),(14,1,1,'PN','Proceso De Notas','2024-03-01','2025-12-31',1,NULL),(15,56,1,'PI',NULL,'2020-01-28','2025-04-28',NULL,NULL),(16,1,1,'PR',NULL,'2024-03-01','2025-12-31',NULL,NULL),(17,55,1,'PI',NULL,'2023-05-03','2023-06-10',NULL,NULL),(18,55,1,'PN',NULL,'2023-05-01','2023-06-10',NULL,NULL),(19,56,1,'PN',NULL,'2021-02-02','2025-04-23',NULL,NULL),(20,64,1,'PI',NULL,'2023-01-30','2025-04-30',NULL,NULL);
/*!40000 ALTER TABLE `procesos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `profesor`
--

DROP TABLE IF EXISTS `profesor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `profesor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sede_id` int(11) DEFAULT NULL,
  `cedula` varchar(20) NOT NULL,
  `primer_nombre` varchar(50) NOT NULL,
  `segundo_nombre` varchar(50) DEFAULT NULL,
  `primer_apellido` varchar(50) NOT NULL,
  `segundo_apellido` varchar(50) DEFAULT NULL,
  `nacionalidad` varchar(50) NOT NULL,
  `fecha_nacimiento` date NOT NULL,
  `lugar_nacimiento` varchar(50) NOT NULL,
  `sexo` varchar(20) NOT NULL,
  `direccion` longtext DEFAULT NULL,
  `telefono_movil` varchar(12) DEFAULT NULL,
  `telefono_local` varchar(12) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `estado_civil` varchar(20) NOT NULL,
  `salf` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_5B7406D97BF39BE0` (`cedula`),
  KEY `IDX_5B7406D9E19F41BF` (`sede_id`),
  CONSTRAINT `FK_5B7406D9E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1795 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `profesor`
--

LOCK TABLES `profesor` WRITE;
/*!40000 ALTER TABLE `profesor` DISABLE KEYS */;
INSERT INTO `profesor` VALUES (1230,1,'123456789','Pedro','Alejandro','Perez','Martin','V','2017-10-10','Caracas','m','sdfdsfsdsd','04248574965','04248578575','pedro@upel.edu.ve','s',NULL,'23181',1),(1780,1,'181481','aranado','adawpkd','dadoawopmk','aeodmkaow','admoawm','2017-10-11','amdawom','f','adw','ada','awdd','aadw@hotmail.com','s',NULL,'PTNgnyMjEo',1),(1781,1,'3434344','Andres','3434','3434','3434','3434','2017-12-26','3434','m','34343434434','3434','3434','34344@upel.edu.ve','s',NULL,'121212',1),(1783,1,'34343434','3434','3434','3434','3434','3434','2018-01-11','3434','m','3434','3434','3434','3434344@upel.edu.ve','s',NULL,'23181',1),(1784,1,'3434343434','3434','3434','3434','3434','3434','2018-01-12','3434','m','3434','3434','3434','34343434@upel.edu.ve','s',NULL,'Sy3xjce9b6',1),(1785,1,'121212122','1212121212','12121212','121212121','11212','1212','2018-03-24','1212','f','Merida','1021212','12121','121212121212@upel.edu.ve','s',NULL,'23181',1),(1786,1,'231811','231811','23181','23181','23181','23181','2018-04-02','23181','m','231811','231811','231811','231811@upel.edu.ve','s',NULL,'23181',1),(1787,1,'1313','1313','13','13','13','13','2018-05-18','13','m','13','1313','13','13@upel.edu.ve','s',NULL,'cJL8fyDHgp',1),(1788,1,'18738560','a','a','a','a','a','2019-05-08','a','m','adaw','041','021','arnaldo19@hotmail.com','s',NULL,'8aqIpoDfIj',1),(1789,1,'12345678','Juan',NULL,'Bejarano',NULL,'v','2019-05-30','c','m',NULL,'0',NULL,'Juanb@gmail.com','s',NULL,'12345',1),(1790,1,'121233','prueba',NULL,'pruebaa',NULL,'venezolana','1979-10-10','caracas','f','caracas','042425448745','02125648754','pruebaerror@gmail.com','s',NULL,'yaAoNeQna',1),(1791,1,'434343434','prueba','pruebaaa','pruebaa','pruebaaaaa','venezuela','1999-06-16','caracas','f','caraas','04245874587','02125487574','pruebaerror@gmail.com','s',NULL,'123456',1),(1792,1,'9595959','error','error2','error3','error4','venezuelona','1989-01-03','caracas','m','caracas','04245874587','02125487574','pruebaerror2@gmail.com','s',NULL,'123456',1),(1793,1,'5555555','prueba5',NULL,'prueba55',NULL,'venezolano','1989-02-09','caracas','f','caracas','042458696254','02125487421','prueba5@gmail.com','s',NULL,'123456',1),(1794,1,'21535638','Jessi',NULL,'Parra',NULL,'venezolana','1994-02-28','caracas','f','Casa','0414','0212','jessi@upel.com','s',NULL,'23181',1);
/*!40000 ALTER TABLE `profesor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `programa`
--

DROP TABLE IF EXISTS `programa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `programa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(15) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `programa`
--

LOCK TABLES `programa` WRITE;
/*!40000 ALTER TABLE `programa` DISABLE KEYS */;
INSERT INTO `programa` VALUES (1,'050','Pregrado');
/*!40000 ALTER TABLE `programa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `promociones`
--

DROP TABLE IF EXISTS `promociones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `promociones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sede_id` int(11) DEFAULT NULL,
  `nombre` varchar(80) NOT NULL,
  `fechapromocion` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_381BA77AE19F41BF` (`sede_id`),
  CONSTRAINT `FK_381BA77AE19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `promociones`
--

LOCK TABLES `promociones` WRITE;
/*!40000 ALTER TABLE `promociones` DISABLE KEYS */;
/*!40000 ALTER TABLE `promociones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `saldo_estudiante`
--

DROP TABLE IF EXISTS `saldo_estudiante`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `saldo_estudiante` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `espeestud_id` int(11) DEFAULT NULL,
  `monto` decimal(10,2) NOT NULL,
  `fechaCreacion` datetime NOT NULL,
  `fechaActualizacion` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_E087F13985179081` (`espeestud_id`),
  CONSTRAINT `FK_E087F13985179081` FOREIGN KEY (`espeestud_id`) REFERENCES `espe_estud` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `saldo_estudiante`
--

LOCK TABLES `saldo_estudiante` WRITE;
/*!40000 ALTER TABLE `saldo_estudiante` DISABLE KEYS */;
/*!40000 ALTER TABLE `saldo_estudiante` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sede`
--

DROP TABLE IF EXISTS `sede`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sede` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(500) NOT NULL,
  `ciudad` varchar(70) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_2A9BE2D120332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sede`
--

LOCK TABLES `sede` WRITE;
/*!40000 ALTER TABLE `sede` DISABLE KEYS */;
INSERT INTO `sede` VALUES (1,'rectorado','Rectorado','Caracas');
/*!40000 ALTER TABLE `sede` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessiones`
--

DROP TABLE IF EXISTS `sessiones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessiones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha` datetime NOT NULL,
  `estudiante_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_83B25B9FDB38439E` (`usuario_id`),
  KEY `IDX_83B25B9F59590C39` (`estudiante_id`),
  CONSTRAINT `FK_83B25B9F59590C39` FOREIGN KEY (`estudiante_id`) REFERENCES `estudiante` (`id`),
  CONSTRAINT `FK_83B25B9FDB38439E` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23951 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessiones`
--

LOCK TABLES `sessiones` WRITE;
/*!40000 ALTER TABLE `sessiones` DISABLE KEYS */;
INSERT INTO `sessiones` VALUES (11739,1,'2015-04-09 09:12:25',NULL),(11741,1,'2015-04-09 09:16:24',NULL),(11828,1,'2015-04-09 14:22:17',NULL),(11853,1,'2015-04-09 15:20:30',NULL),(11862,1,'2015-04-09 15:55:39',NULL),(11918,1,'2015-04-10 07:28:06',NULL),(11928,1,'2015-04-10 09:47:14',NULL),(11993,1,'2015-04-10 15:26:51',NULL),(12047,1,'2015-04-13 09:54:30',NULL),(12083,1,'2015-04-14 11:32:01',NULL),(12105,1,'2015-04-15 09:02:14',NULL),(12177,1,'2015-04-17 17:05:00',NULL),(12179,1,'2015-04-21 10:55:29',NULL),(12180,1,'2015-04-21 11:53:51',NULL),(12188,1,'2015-04-21 14:02:06',NULL),(12193,1,'2015-04-21 15:07:04',NULL),(12199,1,'2015-04-21 16:05:55',NULL),(12213,1,'2015-04-22 09:08:53',NULL),(12244,1,'2015-04-23 09:42:48',NULL),(12246,1,'2015-04-23 09:46:20',NULL),(12251,1,'2015-04-23 10:24:39',NULL),(12257,1,'2015-04-23 14:45:27',NULL),(12266,1,'2015-04-24 08:59:39',NULL),(12268,1,'2015-04-24 10:09:42',NULL),(12271,1,'2015-04-24 10:12:59',NULL),(12276,1,'2015-04-24 10:59:05',NULL),(12278,1,'2015-04-24 11:26:09',NULL),(12285,1,'2015-04-24 12:10:03',NULL),(12291,1,'2015-04-24 14:59:25',NULL),(12403,1,'2015-05-04 14:28:57',NULL),(12418,1,'2015-05-05 11:17:29',NULL),(12436,1,'2015-05-06 10:17:35',NULL),(12458,1,'2015-05-07 13:58:59',NULL),(12462,1,'2015-05-07 16:22:33',NULL),(12471,1,'2015-05-08 10:37:39',NULL),(12475,1,'2015-05-08 11:26:46',NULL),(12490,1,'2015-05-11 10:44:51',NULL),(12516,1,'2015-05-12 15:34:54',NULL),(12521,1,'2015-05-13 08:25:11',NULL),(12541,1,'2015-05-13 15:09:22',NULL),(12544,1,'2015-05-13 15:54:25',NULL),(12558,1,'2015-05-14 10:47:34',NULL),(12567,1,'2015-05-14 13:20:42',NULL),(12674,1,'2015-05-22 09:23:53',NULL),(12683,1,'2015-05-22 15:13:07',NULL),(12691,1,'2015-05-25 08:53:50',NULL),(12693,1,'2015-05-25 09:04:53',NULL),(12694,1,'2015-05-25 09:07:25',NULL),(12695,1,'2015-05-25 09:12:46',NULL),(12697,1,'2015-05-25 09:20:04',NULL),(12698,1,'2015-05-25 09:21:40',NULL),(12707,1,'2015-05-25 11:05:49',NULL),(12713,1,'2015-05-25 11:53:03',NULL),(12714,1,'2015-05-25 11:56:01',NULL),(12720,1,'2015-05-25 15:35:22',NULL),(12734,1,'2015-05-26 09:47:42',NULL),(12736,1,'2015-05-26 11:08:29',NULL),(12742,1,'2015-05-26 13:21:44',NULL),(12744,1,'2015-05-26 13:46:00',NULL),(12747,1,'2015-05-26 13:50:29',NULL),(12751,1,'2015-05-26 14:04:16',NULL),(12752,1,'2015-05-26 14:07:37',NULL),(12753,1,'2015-05-26 14:07:48',NULL),(12758,1,'2015-05-26 14:54:47',NULL),(12764,1,'2015-05-26 15:35:43',NULL),(12776,1,'2015-05-27 09:58:29',NULL),(12781,1,'2015-05-27 14:36:05',NULL),(12783,1,'2015-05-27 16:13:52',NULL),(12785,1,'2015-05-27 16:26:13',NULL),(12790,1,'2015-05-29 09:53:52',NULL),(12791,1,'2015-05-29 09:54:13',NULL),(12837,1,'2015-06-02 10:36:50',NULL),(12841,1,'2015-06-02 10:54:40',NULL),(12844,1,'2015-06-02 10:56:15',NULL),(12869,1,'2015-06-03 14:46:56',NULL),(12873,1,'2015-06-03 15:27:17',NULL),(12876,1,'2015-06-03 16:15:03',NULL),(12883,1,'2015-06-04 10:22:31',NULL),(12884,1,'2015-06-04 10:24:52',NULL),(12893,1,'2015-06-04 11:55:06',NULL),(12960,1,'2015-06-10 13:45:36',NULL),(12965,1,'2015-06-10 14:56:14',NULL),(12971,1,'2015-06-11 08:25:08',NULL),(12976,1,'2015-06-11 09:33:33',NULL),(12981,1,'2015-06-11 10:43:47',NULL),(12989,1,'2015-06-11 11:58:34',NULL),(12993,1,'2015-06-11 12:10:28',NULL),(13003,1,'2015-06-11 14:17:31',NULL),(13005,1,'2015-06-11 14:51:06',NULL),(13019,1,'2015-06-12 08:48:06',NULL),(13020,1,'2015-06-12 08:57:45',NULL),(13022,1,'2015-06-12 09:19:03',NULL),(13025,1,'2015-06-12 09:51:06',NULL),(13028,1,'2015-06-12 10:01:09',NULL),(13030,1,'2015-06-12 10:19:31',NULL),(13035,1,'2015-06-12 10:45:06',NULL),(13039,1,'2015-06-12 11:15:52',NULL),(13053,1,'2015-06-12 13:31:33',NULL),(13066,1,'2015-06-12 16:19:53',NULL),(13078,1,'2015-06-15 09:18:09',NULL),(13085,1,'2015-06-15 11:37:52',NULL),(13099,1,'2015-06-16 09:18:47',NULL),(13102,1,'2015-06-16 10:09:04',NULL),(13126,1,'2015-06-17 09:47:30',NULL),(13129,1,'2015-06-17 09:58:45',NULL),(13131,1,'2015-06-17 10:08:55',NULL),(13132,1,'2015-06-17 10:11:03',NULL),(13134,1,'2015-06-17 10:28:40',NULL),(13136,1,'2015-06-17 10:30:26',NULL),(13142,1,'2015-06-17 11:40:31',NULL),(13143,1,'2015-06-17 11:41:58',NULL),(13170,1,'2015-06-19 09:09:15',NULL),(13216,1,'2015-06-23 09:57:14',NULL),(13223,1,'2015-06-23 11:24:30',NULL),(13232,1,'2015-06-23 15:19:19',NULL),(13238,1,'2015-06-23 16:33:41',NULL),(13252,1,'2015-06-24 16:35:52',NULL),(13262,1,'2015-06-25 09:09:02',NULL),(13283,1,'2015-06-25 13:05:44',NULL),(13284,1,'2015-06-25 13:13:01',NULL),(13294,1,'2015-06-25 15:36:01',NULL),(13297,1,'2015-06-25 15:43:14',NULL),(13325,1,'2015-06-26 09:07:46',NULL),(13331,1,'2015-06-26 09:41:39',NULL),(13334,1,'2015-06-26 11:33:53',NULL),(13338,1,'2015-06-26 11:40:20',NULL),(13340,1,'2015-06-26 11:42:40',NULL),(13341,1,'2015-06-26 11:43:08',NULL),(13346,1,'2015-06-26 11:51:22',NULL),(13359,1,'2015-06-26 14:02:57',NULL),(13365,1,'2015-06-26 14:26:48',NULL),(13367,1,'2015-06-26 14:29:02',NULL),(13488,1,'2015-06-29 08:34:23',NULL),(13513,1,'2015-06-29 09:37:35',NULL),(13520,1,'2015-06-29 09:56:26',NULL),(13580,1,'2015-06-29 10:57:25',NULL),(13623,1,'2015-06-29 12:00:35',NULL),(13625,1,'2015-06-29 12:02:51',NULL),(14095,1,'2015-06-30 08:59:20',NULL),(14141,1,'2015-06-30 10:10:00',NULL),(14156,1,'2015-06-30 10:21:36',NULL),(14161,1,'2015-06-30 10:24:03',NULL),(15152,1,'2015-06-30 20:41:58',NULL),(15370,1,'2015-06-30 22:02:16',NULL),(15634,1,'2015-07-01 10:17:43',NULL),(15661,1,'2015-07-01 10:54:10',NULL),(15688,1,'2015-07-01 11:41:52',NULL),(15733,1,'2015-07-01 14:15:51',NULL),(15752,1,'2015-07-01 14:56:59',NULL),(15760,1,'2015-07-01 15:08:08',NULL),(15767,1,'2015-07-01 15:22:15',NULL),(15784,1,'2015-07-01 16:06:23',NULL),(15901,1,'2015-07-01 21:33:41',NULL),(15962,1,'2015-07-02 09:38:00',NULL),(15992,1,'2015-07-02 10:53:07',NULL),(15996,1,'2015-07-02 10:58:33',NULL),(16071,1,'2015-07-02 14:49:27',NULL),(16101,1,'2015-07-02 16:02:40',NULL),(16194,1,'2015-07-03 08:54:52',NULL),(16208,1,'2015-07-03 11:11:20',NULL),(16254,1,'2015-07-06 09:40:41',NULL),(16255,1,'2015-07-06 09:41:55',NULL),(16263,1,'2015-07-06 11:01:20',NULL),(16277,1,'2015-07-06 13:44:17',NULL),(16308,1,'2015-07-07 08:56:26',NULL),(16398,1,'2015-07-09 09:33:44',NULL),(16403,1,'2015-07-09 10:13:24',NULL),(16413,1,'2015-07-09 11:18:24',NULL),(16416,1,'2015-07-09 11:36:18',NULL),(16427,1,'2015-07-09 14:22:47',NULL),(16477,1,'2015-07-10 16:06:43',NULL),(16515,1,'2015-07-14 10:00:10',NULL),(16564,1,'2015-07-15 15:53:28',NULL),(16702,1,'2015-07-16 11:05:31',NULL),(16834,1,'2015-07-16 14:53:58',NULL),(17358,1,'2015-07-17 11:08:57',NULL),(17362,1,'2015-07-17 11:12:54',NULL),(17370,1,'2015-07-17 11:26:08',NULL),(17379,1,'2015-07-17 11:35:18',NULL),(17380,1,'2015-07-17 11:35:39',NULL),(17468,1,'2015-07-17 14:15:13',NULL),(17476,1,'2015-07-17 14:21:45',NULL),(17789,1,'2015-07-20 09:10:04',NULL),(17824,1,'2015-07-20 14:30:30',NULL),(17825,1,'2015-07-20 14:31:14',NULL),(17827,1,'2015-07-20 14:40:57',NULL),(17837,1,'2015-07-20 15:40:10',NULL),(17873,1,'2015-07-21 10:59:09',NULL),(17879,1,'2015-07-21 13:56:50',NULL),(17908,1,'2015-07-22 09:14:16',NULL),(17917,1,'2015-07-22 11:47:57',NULL),(17919,1,'2015-07-22 11:51:40',NULL),(17922,1,'2015-07-22 11:56:35',NULL),(17976,1,'2015-07-23 10:31:20',NULL),(18009,1,'2015-07-27 09:11:47',NULL),(18063,1,'2015-07-29 10:11:23',NULL),(18102,1,'2015-09-22 09:41:13',NULL),(18104,1,'2015-09-22 11:52:17',NULL),(18108,1,'2015-09-23 11:45:52',NULL),(18111,1,'2015-09-24 09:36:48',NULL),(18117,1,'2015-09-25 11:34:31',NULL),(18169,1,'2015-10-05 15:07:30',NULL),(18185,1,'2015-10-06 10:00:07',NULL),(18188,1,'2015-10-06 11:21:53',NULL),(18193,1,'2015-10-06 15:03:03',NULL),(18194,1,'2015-10-06 15:15:44',NULL),(18196,1,'2015-10-06 15:52:04',NULL),(18199,1,'2015-10-06 18:11:42',NULL),(18211,1,'2015-10-07 12:06:46',NULL),(18234,1,'2015-10-08 09:02:04',NULL),(18240,1,'2015-10-08 09:34:06',NULL),(18273,1,'2015-10-08 15:25:12',NULL),(18277,1,'2015-10-08 15:53:53',NULL),(18312,1,'2015-10-13 11:20:14',NULL),(18314,1,'2015-10-13 13:06:21',NULL),(18327,1,'2015-10-14 10:44:43',NULL),(18366,1,'2015-10-20 10:37:47',NULL),(18373,1,'2015-10-21 05:31:16',NULL),(18417,1,'2015-10-26 11:00:31',NULL),(18418,1,'2015-10-26 11:14:07',NULL),(18482,1,'2015-10-30 10:33:34',NULL),(18484,1,'2015-10-30 10:58:43',NULL),(18588,1,'2015-11-06 10:47:28',NULL),(18590,1,'2015-11-06 11:15:41',NULL),(18594,1,'2015-11-06 11:56:09',NULL),(18623,1,'2015-11-10 10:54:24',NULL),(18624,1,'2015-11-10 10:55:55',NULL),(18626,1,'2015-11-10 10:57:48',NULL),(18629,1,'2015-11-10 12:28:43',NULL),(18639,1,'2015-11-11 09:52:04',NULL),(18672,1,'2015-11-13 09:03:40',NULL),(18673,1,'2015-11-13 09:16:22',NULL),(18674,1,'2015-11-13 09:19:13',NULL),(18675,1,'2015-11-13 09:20:04',NULL),(18678,1,'2015-11-13 09:23:09',NULL),(18681,1,'2015-11-13 09:25:36',NULL),(18684,1,'2015-11-13 09:33:25',NULL),(18685,1,'2015-11-13 09:35:25',NULL),(18686,1,'2015-11-13 09:38:00',NULL),(18687,1,'2015-11-13 09:39:15',NULL),(18688,1,'2015-11-13 09:41:00',NULL),(18689,1,'2015-11-13 09:42:35',NULL),(18726,1,'2015-11-18 11:16:00',NULL),(18738,1,'2015-11-19 09:00:51',NULL),(18797,1,'2015-11-25 11:31:26',NULL),(18840,1,'2015-11-30 15:00:03',NULL),(18846,1,'2015-11-30 18:23:44',NULL),(18848,1,'2015-12-01 07:26:30',NULL),(18863,1,'2015-12-01 11:23:00',NULL),(18894,1,'2015-12-02 11:23:57',NULL),(18962,1,'2015-12-10 09:44:30',NULL),(18963,1,'2015-12-10 09:52:57',NULL),(18964,1,'2015-12-10 09:54:46',NULL),(18965,1,'2015-12-10 10:18:41',NULL),(18981,1,'2016-01-11 11:58:06',NULL),(19003,1,'2016-01-18 11:46:43',NULL),(19020,1,'2016-01-20 09:38:48',NULL),(19032,1,'2016-01-21 08:58:55',NULL),(19056,1,'2016-01-25 09:31:49',NULL),(19077,1,'2016-01-26 15:18:16',NULL),(19101,1,'2016-01-26 21:48:54',NULL),(19196,1,'2016-02-03 20:40:20',NULL),(19209,1,'2016-02-04 21:03:45',NULL),(19225,1,'2016-02-05 16:34:28',NULL),(19234,1,'2016-02-05 19:24:39',NULL),(19292,1,'2016-02-11 15:01:04',NULL),(19299,1,'2016-02-11 15:21:21',NULL),(19380,1,'2016-02-12 04:08:10',NULL),(19566,1,'2016-02-15 14:10:39',NULL),(19580,1,'2016-02-15 14:36:54',NULL),(19596,1,'2016-02-15 14:58:38',NULL),(19913,1,'2016-02-15 21:37:43',NULL),(20497,1,'2016-02-16 15:43:51',NULL),(20536,1,'2016-02-16 16:32:24',NULL),(20582,1,'2016-02-16 17:03:43',NULL),(20585,1,'2016-02-16 17:06:24',NULL),(21368,1,'2016-02-17 14:45:09',NULL),(21401,1,'2016-02-17 15:22:28',NULL),(21572,1,'2016-02-17 17:30:15',NULL),(21676,1,'2016-02-17 19:35:59',NULL),(21680,1,'2016-02-17 19:38:41',NULL),(21684,1,'2016-02-17 19:41:50',NULL),(21706,1,'2016-02-17 19:58:00',NULL),(21719,1,'2016-02-17 20:02:29',NULL),(21754,1,'2016-02-17 20:25:01',NULL),(21777,1,'2016-02-17 20:39:11',NULL),(21813,1,'2016-02-17 20:55:09',NULL),(22309,1,'2016-02-18 03:14:20',NULL),(22487,1,'2016-02-18 15:32:20',NULL),(22491,1,'2016-02-18 10:10:28',NULL),(22730,1,'2016-02-19 11:02:25',NULL),(22767,1,'2016-02-19 14:50:21',NULL),(22943,1,'2016-02-24 15:02:24',NULL),(22976,1,'2016-02-25 11:28:21',NULL),(23044,1,'2016-02-29 16:28:01',NULL),(23100,1,'2016-03-04 10:52:16',NULL),(23145,1,'2016-03-07 09:27:13',NULL),(23434,1,'2016-03-08 14:49:27',NULL),(23588,1,'2016-03-09 11:06:13',NULL),(23782,1,'2016-03-14 13:43:41',NULL),(23814,1,'2016-03-15 14:22:53',NULL),(23838,1,'2016-03-16 11:01:45',NULL),(23877,1,'2016-03-30 09:55:40',NULL),(23878,1,'2016-03-30 09:58:10',NULL),(23879,1,'2016-03-30 10:01:24',NULL),(23948,1,'2016-04-05 16:05:30',NULL),(23950,1,'2016-04-05 16:40:19',NULL);
/*!40000 ALTER TABLE `sessiones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessiones_detalles`
--

DROP TABLE IF EXISTS `sessiones_detalles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessiones_detalles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `modulo` varchar(20) NOT NULL,
  `accion` varchar(20) NOT NULL,
  `observacion` longtext NOT NULL,
  `fecha` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_2139D93B613FECDF` (`session_id`),
  CONSTRAINT `FK_2139D93B613FECDF` FOREIGN KEY (`session_id`) REFERENCES `sessiones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessiones_detalles`
--

LOCK TABLES `sessiones_detalles` WRITE;
/*!40000 ALTER TABLE `sessiones_detalles` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessiones_detalles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sub_items`
--

DROP TABLE IF EXISTS `sub_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sub_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `subitem` varchar(50) NOT NULL,
  `router` varchar(50) NOT NULL,
  `icono` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_D5A8DF4126F525E` (`item_id`),
  CONSTRAINT `FK_D5A8DF4126F525E` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sub_items`
--

LOCK TABLES `sub_items` WRITE;
/*!40000 ALTER TABLE `sub_items` DISABLE KEYS */;
INSERT INTO `sub_items` VALUES (1,1,'Nuevo Estudiante','app_estudiante_new','fa fa-user-plus'),(2,1,'Consultar Estudiante','app_estudiantes_index','fa fa-search'),(3,1,'Inscripción de Estudiante','app_admin_consul_estud_inscripcion','fa fa-files-o'),(4,2,'Consultar Profesor','app_admin_profesores','fa fa-search'),(5,2,'Nuevo Profesor','app_admin_new_profesor','fa fa-user-plus'),(6,3,'Nueva Oferta','app_new_oferta_academica','fa fa-calendar-plus-o'),(7,3,'Consultar Oferta','app_consult_oferta_academica','fa fa-search'),(8,NULL,'Asignación','app_asignacion_oferta_academica','fa fa-calendar-check-o'),(9,4,'Autoridades','app_admin_autoridades_index','fa fa-plus-circle'),(10,NULL,'Sede','app_admin_sede_index','fa fa-plus-circle'),(11,4,'Tipo de Estruc. Desc','app_admin_tiposubsede_index','fa fa-plus-circle'),(12,NULL,'Estruc. Desconcentrada','app_admin_subsede_index','fa fa-plus-circle'),(13,4,'Componentes','app_admin_componentes_index','fa fa-plus-circle'),(14,4,'Tipo de Unidad Curricular','app_admin_tipocursos_index','fa fa-plus-circle'),(15,4,'Áreas','app_admin_areas_index','fa fa-plus-circle'),(16,4,'Niveles','app_admin_niveles_index','fa fa-plus-circle'),(17,4,'Unidad Curricular','app_cursos','fa fa-plus-circle'),(18,4,'Planes de Estudios','app_plan_estudio_index','fa fa-plus-circle'),(19,4,'Período Académico','app_admin_lapsos_index','fa fa-plus-circle'),(20,4,'Cohortes','app_admin_cohorte_index','fa fa-plus-circle'),(21,4,'Procesos','app_admin_procesos_index','fa fa-plus-circle'),(22,5,'Configuración de Programa','app_admin_config_sistema_index','fa fa-gears'),(24,6,'Acta de Calificación','app_admin_listado_clases','fa fa-file-pdf-o'),(25,6,'Listado de Inscritos','app_admin_listado_inscritos','fa fa-file-pdf-o'),(26,6,'Récord Académico','app_admin_reports_form_record_academico','fa fa-file-pdf-o'),(27,6,'Planilla de inscripción','app_admin_form_planilla_inscripcion','fa fa-file-pdf-o'),(28,6,'Listado Pregrado','app_admin_listado_pregrado','fa fa-file-pdf-o'),(29,6,'Totales Inscritos','app_admin_reports_form_totales_inscritos','fa fa-file-pdf-o'),(30,6,'Prof. sin transcripción (Especifico)','app_admin_report_form_sintranscripcion','fa fa-file-pdf-o'),(31,6,'Prof. sin transcripción (General)','app_admin_report_form_sintranscripcion_general','fa fa-file-pdf-o'),(32,7,'Crear Usuario','app_usuarios_new','fa fa-user-plus'),(33,7,'Asignar Menú','app_menuusuarios_index','fa fa-check-square'),(34,7,'Lista de Usuarios','app_usuarios_show','fa fa-users'),(35,10,'Modificación','app_profesor_index','fa fa-search'),(36,10,'Inclusión','app_profesor_inclusion','fa fa-search'),(38,6,'Inscritos por U.C.','app_admin_inscritos_por_UC','fa fa-file-pdf-o'),(39,6,'Listado UDBE','app_admin_listado_UDBE','fa fa-file-pdf-o'),(40,1,'Editar Estudiante','app_estudiantes_editestu','fa fa-pencil'),(41,4,'Planes de Estudios (C)','app_plan_estudio_consulta','fa fa-plus-circle'),(42,2,'Restaurar Clave (P)','app_profesor_default','fa fa-refresh'),(43,7,'Restaurar Clave (U)','app_usuario_default','fa fa-refresh'),(45,6,'Ofertas Académicas','app_admin_reporte_oferta_academica','fa fa-file-excel-o'),(46,6,'Listado Pre-Inscritos','app_admin_reports_form_listado_pre_inscritos','fa fa-file-excel-o'),(48,6,'Constancia de Estudios','app_admin_form_planilla_constanciaestudio','fa fa-file-pdf-o'),(49,7,'Asignar Sub-Sedes','app_subsedeusuarios_index','fa fa-institution'),(50,1,'Asesoría del Estudiante','app_admin_consul_estud_asesoria','fa fa-files-o'),(51,3,'Consultar Oferta Curriculo','app_consultcurri_oferta_academica','fa fa-search'),(52,6,'Totales Asesorados (P.A.)','app_admin_reports_totales_inscritos_asesoria_p','fa fa-file-pdf-o'),(53,6,'Inscritos con Discapacidad','app_admin_inscritos_discapacidad','fa fa-file-pdf-o'),(54,1,'Cambio de Especialidad','app_estudiantes_cambio_especialidad','fa fa-exchange'),(55,6,'Totales Asesorados','app_admin_reports_totales_inscritos_asesoria_c','fa fa-file-pdf-o'),(56,6,'Totales Inscritos (P.A.)','app_admin_reports_totales_inscritos_p','fa fa-file-pdf-o'),(57,1,'Retiro de Unidad','app_admin_consul_estud_retiro','fa fa-remove'),(58,1,'Retiro de Período Académico','app_admin_estud_retiro_periodo','fa fa-times-circle'),(59,1,'Asignar Especialidad','app_estudiantes_new_especialidad','fa fa-plus-square'),(60,6,'Asesorados por U.C.','app_admin_asesorados_por_UC','fa fa-file-pdf-o'),(61,6,'Listado UDBE (P.A)','app_admin_reporte_listado_UDBE','fa fa-file-excel-o'),(62,11,'Documentos Graduandos','app_document_graduandos_index','fa fa-plus-circle'),(63,11,'Cierre','app_admin_cierre_grado','fa fa-database'),(64,11,'Listado de Graduandos','app_admin_grado_paramlistadograduando','fa fa-print'),(65,11,'Estadísticas Graduandos','app_admin_grado_estadisticasgraduandos','fa fa-print'),(66,11,'Record Académico Grado','app_admin_reports_form_record_academico','fa fa-print'),(67,11,'Documentos  Egresados ','app_egresados_index','fa fa-plus-circle'),(68,11,'Actualizar Calificaciones','app_estudiantes_historico_index','fa fa-database'),(69,11,'Gestionar promociones','app_admin_promociones_index','fa fa-plus-circle'),(70,11,'Gestionar Graduandos','app_gestionar_graduandos_index','fa fa-database'),(71,11,'Listado de Egresados','app_admin_grado_paramlistadoegresados','fa fa-print'),(72,2,'Editar Profesor','app_admin_profesores_list','fa fa-pencil'),(73,6,'Planilla de Asesoría','app_admin_form_planilla_asesoria','fa fa-file-pdf-o'),(74,6,'Inscritos por Etnia','app_admin_inscritos_etnia','fa fa-file-pdf-o');
/*!40000 ALTER TABLE `sub_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sub_sedes`
--

DROP TABLE IF EXISTS `sub_sedes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sub_sedes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sub_sedes`
--

LOCK TABLES `sub_sedes` WRITE;
/*!40000 ALTER TABLE `sub_sedes` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_sedes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subsede`
--

DROP TABLE IF EXISTS `subsede`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `subsede` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tiposubsede_id` int(11) DEFAULT NULL,
  `sede_id` int(11) DEFAULT NULL,
  `codigo` varchar(20) NOT NULL,
  `descripcion` varchar(80) NOT NULL,
  `vigente` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_F32E905A20332D99` (`codigo`),
  KEY `IDX_F32E905A50FF723` (`tiposubsede_id`),
  KEY `IDX_F32E905AE19F41BF` (`sede_id`),
  CONSTRAINT `FK_F32E905A50FF723` FOREIGN KEY (`tiposubsede_id`) REFERENCES `tipo_subsede` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subsede`
--

LOCK TABLES `subsede` WRITE;
/*!40000 ALTER TABLE `subsede` DISABLE KEYS */;
INSERT INTO `subsede` VALUES (1,2,1,'0100','Instituto Pedagógico de Caracas Sede Rectoral',1),(2,2,1,'0200','Instituto Pedagógico de Barquisimeto Sede Rectoral',1),(3,2,3,'0300','Instituto Pedagógico de Maracay Sede Rectoral',1),(4,2,5,'0400','Instituto Pedagógico de Maturín Sede Rectoral',1),(5,1,5,'0401','IPM San Antonio de Capayacuar',1),(6,2,6,'0500','Instituto Pedagógico de Miranda \"J.M. Siso Martinez Sede Rectoral',1),(7,1,6,'0501','IPMJMSM-Valles del Tuy',1),(8,1,6,'0502','IPMJMSM-Rio Chico',1),(9,2,7,'0600','Instituto de Mejoramiento Profesional del Magisterio Sede Rectoral',1),(10,1,7,'0601','IMPM Amazonas',1),(11,1,7,'0602','IMPM Amazonas - Puerto Ayacucho',1),(12,1,7,'0604','IMPM Amazonas - San Fernando de Atabapo',1),(13,1,7,'0605','IMPM Anzoátegui',1),(14,1,7,'0606','IMPM Anzoátegui - Barcelona',1),(15,1,7,'0608','IMPM Anzoátegui - Anaco',1),(16,1,7,'0610','IMPM Anzoátegui - El Tigre',1),(17,1,7,'0611','IMPM Apure',1),(18,1,7,'0612','IMPM Apure - San Fernando de Apure',1),(19,1,7,'0614','IMPM Apure - Achaguas',1),(20,1,7,'0616','IMPM Apure - Bruzual',1),(21,1,7,'0618','IMPM Apure - Elorza',1),(22,1,7,'0620','IMPM Apure - Guasdualito',1),(23,1,7,'0622','IMPM Apure - El Nula',1),(24,1,7,'0624','IMPM Apure - Mantecal',1),(25,1,7,'0625','IMPM Barinas',1),(26,1,7,'0627','IMPM Bolivar',1),(27,1,7,'0628','IMPM Bolivar - Ciudad Bolívar',1),(28,1,7,'0630','IMPM Bolivar - Piar',1),(29,1,7,'0632','IMPM Bolivar - Puerto Ordaz',1),(30,1,7,'0633','IMPM Valencia',1),(31,1,7,'0635','IMPM Cojedes - San Carlos',1),(32,1,7,'0637','IMPM Falcón',1),(33,1,7,'0638','IMPM Falcón - Coro',1),(34,1,7,'0640','IMPM Falcón - Puerto Cumarebo',1),(35,1,7,'0642','IMPM Falcón - Santa Cruz de Bucaral',1),(36,1,7,'0643','IMPM Punto Fijo',1),(37,1,7,'0645','IMPM Mérida',1),(38,1,7,'0646','IMPM Mérida - Mérida',1),(39,1,7,'0648','IMPM Mérida - El Vigía',1),(40,1,7,'0650','IMPM Mérida - Zea',1),(41,1,7,'0651','IMPM Miranda',1),(42,1,7,'0652','IMPM Miranda - Los Teques',1),(43,1,7,'0654','IMPM Miranda - Ocumare del Tuy',1),(44,1,7,'0656','IMPM Vargas - La Guaira',1),(45,1,7,'0658','IMPM Miranda - Carayaca',1),(46,1,7,'0659','IMPM  Miranda - Centro Atención Caracas',1),(47,1,7,'0661','IMPM Miranda - Higuerote',1),(48,1,7,'0663','IMPM Nueva Esparta - La Asunción',1),(49,1,7,'0665','IMPM Portuguesa',1),(50,1,7,'0666','IMPM Portuguesa - Guanare',1),(51,1,7,'0668','IMPM Portuguesa - Biscucuy',1),(52,1,7,'0669','IMPM Acarigua',1),(53,1,7,'0671','IMPM Sucre - Cumana',1),(54,1,7,'0673','IMPM Carúpano',1),(55,1,7,'0675','IMPM Táchira - San Cristobal',1),(56,1,7,'0677','IMPM Tucupita',1),(57,1,7,'0678','IMPM Tucupita - Tucupita',1),(58,1,7,'0680','IMPM Tucupita - Piacoa',1),(59,1,7,'0681','IMPM Trujillo - Valera',1),(60,1,7,'0683','IMPM Boconó',1),(61,1,7,'0685','IMPM Yaracuy - San Felipe',1),(62,1,7,'0687','IMPM Zulia',1),(63,1,7,'0688','IMPM Zulia - Maracaibo',1),(64,1,7,'0690','IMPM Zulia - Machiques',1),(65,2,2,'0700','Instituto Pedagógico Rural \"Gervasio Rubio\" Sede Rectoral',1),(66,1,2,'0701','IPRGR Encontrados',1),(67,1,2,'0702','IPRGR Sabana Mendoza',1),(68,2,8,'0800','Instituto Pedagógico Rural \"El Macaro\" Sede  Aragu',1),(69,1,8,'0801','IPRM Puerto Ayacucho',1),(70,1,8,'0802','IPRM San Fernando de Apure',1),(71,1,8,'0803','IPRM Santa Elena de Uairén',1),(72,1,8,'0804','IPRM Falcon - Yaracal',1),(73,1,8,'0806','IPRM Maracaibo',1),(74,1,8,'0812','IPRM Apure - Achaguas',1),(75,1,8,'0814','IPRM Falcon - Dabajuro',1),(76,1,8,'0815','IPRM Guarico - San Juan de los Morros',1),(77,1,1,'0210','IPB - Urachiche',1),(78,1,8,'0824','IPRM Falcon - Pueblo Nuevo de la Sierra',1),(79,1,8,'0825','IPRM Guarico - Valle de la Pascua',1),(80,1,8,'0835','IPRM Guarico - Altagracia de Orituco',1),(81,2,1,'1000','Universidad Pedagógica Experimental Libertador',1),(82,1,1,'0202','IPB - El Tocuyo',1),(83,1,1,'0204','IPB - Sanare',1),(84,1,1,'0206','IPB - Duaca',1),(85,1,1,'0208','IPB - Santa Ines',1),(86,1,8,'0834','IPRM Falcon - La Cruz de Taratara',1),(87,1,8,'0807','IPRM Delta Amacuro - Tucupita - San francisco de l',1),(88,1,8,'0816','IPRM Zulia - Machiques',1),(89,1,1,'0212','IPB - Carora',1),(90,1,1,'0214','IPB - Coro',1),(91,1,8,'0845','IPRM Guarico - Camaguan',1),(93,2,9,'1500','Rectorado',1);
/*!40000 ALTER TABLE `subsede` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subsede_usuario`
--

DROP TABLE IF EXISTS `subsede_usuario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `subsede_usuario` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usuario_id` int(11) DEFAULT NULL,
  `subsede_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_12174908A76ED395` (`usuario_id`),
  KEY `IDX_12174908AAFDE970` (`subsede_id`),
  KEY `IDX_4F3186D9DB38439E` (`usuario_id`),
  CONSTRAINT `FK_4F3186D9AAFDE970` FOREIGN KEY (`subsede_id`) REFERENCES `subsede` (`id`),
  CONSTRAINT `FK_4F3186D9DB38439E` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subsede_usuario`
--

LOCK TABLES `subsede_usuario` WRITE;
/*!40000 ALTER TABLE `subsede_usuario` DISABLE KEYS */;
INSERT INTO `subsede_usuario` VALUES (13,1,1),(14,1,2),(15,55,1),(16,55,2),(17,55,77),(18,55,81),(20,50,2),(21,50,77),(22,50,81),(23,50,82),(24,50,83),(25,50,84),(26,50,85),(27,50,89),(28,50,90),(36,58,84),(37,58,85),(38,58,1),(39,50,1),(40,53,1),(41,53,2),(50,1,81),(53,86,81),(54,86,2),(55,86,1);
/*!40000 ALTER TABLE `subsede_usuario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subsedeespe`
--

DROP TABLE IF EXISTS `subsedeespe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `subsedeespe` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `especialidad_id` int(11) DEFAULT NULL,
  `subsede_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_1FFC1FB916A490EC` (`especialidad_id`),
  KEY `IDX_1FFC1FB9AAFDE970` (`subsede_id`),
  CONSTRAINT `FK_1FFC1FB916A490EC` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`),
  CONSTRAINT `FK_1FFC1FB9AAFDE970` FOREIGN KEY (`subsede_id`) REFERENCES `subsede` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subsedeespe`
--

LOCK TABLES `subsedeespe` WRITE;
/*!40000 ALTER TABLE `subsedeespe` DISABLE KEYS */;
/*!40000 ALTER TABLE `subsedeespe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipo_estudiante`
--

DROP TABLE IF EXISTS `tipo_estudiante`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tipo_estudiante` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) NOT NULL,
  `descripcion` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipo_estudiante`
--

LOCK TABLES `tipo_estudiante` WRITE;
/*!40000 ALTER TABLE `tipo_estudiante` DISABLE KEYS */;
INSERT INTO `tipo_estudiante` VALUES (1,'BCH','Bachilleres'),(2,'DOC','Docente en Servicio'),(3,'EGR','Egresados Universitarios'),(4,'EST','Estudiantes de 5to. Año Secundaria');
/*!40000 ALTER TABLE `tipo_estudiante` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipo_exoneracion`
--

DROP TABLE IF EXISTS `tipo_exoneracion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tipo_exoneracion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipo_exoneracion`
--

LOCK TABLES `tipo_exoneracion` WRITE;
/*!40000 ALTER TABLE `tipo_exoneracion` DISABLE KEYS */;
INSERT INTO `tipo_exoneracion` VALUES (1,'Convenio Adminitrativo art. 73'),(2,'Convenio Profesores art. 11'),(3,'Convenio UCLA-UNEXPO-UPEL'),(4,'Convenio Personal de Servicio art. 73'),(5,'Convenio Especial'),(6,'Convenio por Mención art. 145');
/*!40000 ALTER TABLE `tipo_exoneracion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipo_ingreso`
--

DROP TABLE IF EXISTS `tipo_ingreso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tipo_ingreso` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(30) NOT NULL,
  `nombre` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_DF6205BF20332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipo_ingreso`
--

LOCK TABLES `tipo_ingreso` WRITE;
/*!40000 ALTER TABLE `tipo_ingreso` DISABLE KEYS */;
INSERT INTO `tipo_ingreso` VALUES (1,'01','NUEVO INGRESO'),(2,'02','REINGRESO'),(3,'03','TRASLADO'),(4,'04','EQUIVALENCIA'),(5,'05','EXONERADO MENCION HONORIFICA'),(6,'06','EXONERADO PERSONAL DOCENTE'),(7,'07','EXONERADO PERSONAL ADMINISTRAT'),(8,'08','EXONERADO PERSONAL DE SERVICIO'),(9,'09','CAMBIO DE ESPECIALIDAD'),(10,'10','NIVELACION'),(11,'11','REGULAR'),(12,'12','DOCENTES EN SERVICIO NO GRADUADO'),(13,'13','GRADUADO UNIVERSITARIO'),(14,'14','REVALIDA'),(15,'15','ACREDITACIÓN DE APRENDIZAJE POR COMPETENCIAS');
/*!40000 ALTER TABLE `tipo_ingreso` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipo_subsede`
--

DROP TABLE IF EXISTS `tipo_subsede`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tipo_subsede` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipo_subsede`
--

LOCK TABLES `tipo_subsede` WRITE;
/*!40000 ALTER TABLE `tipo_subsede` DISABLE KEYS */;
INSERT INTO `tipo_subsede` VALUES (1,'Extensión'),(2,'Sede Central'),(3,'Centro de Atención'),(4,'Convenio');
/*!40000 ALTER TABLE `tipo_subsede` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipocursos`
--

DROP TABLE IF EXISTS `tipocursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tipocursos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `descripcion` varchar(50) NOT NULL,
  `vigente` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_3EFC2C4C20332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipocursos`
--

LOCK TABLES `tipocursos` WRITE;
/*!40000 ALTER TABLE `tipocursos` DISABLE KEYS */;
INSERT INTO `tipocursos` VALUES (1,'UNCO','Unidad Curricular Obligatoria',1),(2,'UNCLE','Unidad Curricular de Libre Elección',1),(3,'ECU','Eje Curricular',1),(4,'NA','No Aplica',1);
/*!40000 ALTER TABLE `tipocursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `traslado`
--

DROP TABLE IF EXISTS `traslado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `traslado` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curso_id` int(11) DEFAULT NULL,
  `lapso_id` int(11) DEFAULT NULL,
  `especialidad_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `curso_id` (`curso_id`),
  KEY `lapso_id` (`lapso_id`),
  KEY `especialidad_id` (`especialidad_id`),
  CONSTRAINT `traslado_ibfk_1` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `traslado_ibfk_2` FOREIGN KEY (`lapso_id`) REFERENCES `lapso` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `traslado_ibfk_3` FOREIGN KEY (`especialidad_id`) REFERENCES `especialidad` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `traslado`
--

LOCK TABLES `traslado` WRITE;
/*!40000 ALTER TABLE `traslado` DISABLE KEYS */;
/*!40000 ALTER TABLE `traslado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `uc`
--

DROP TABLE IF EXISTS `uc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `uc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sede_id` int(11) DEFAULT NULL,
  `unidad` int(11) NOT NULL,
  `monto` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_C72AAFAEE19F41BF` (`sede_id`),
  CONSTRAINT `FK_C72AAFAEE19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `uc`
--

LOCK TABLES `uc` WRITE;
/*!40000 ALTER TABLE `uc` DISABLE KEYS */;
/*!40000 ALTER TABLE `uc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `universidades`
--

DROP TABLE IF EXISTS `universidades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `universidades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `ubicacion` varchar(100) NOT NULL,
  `siglas` varchar(10) DEFAULT NULL,
  `dependencia` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_C288303020332D99` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=510 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `universidades`
--

LOCK TABLES `universidades` WRITE;
/*!40000 ALTER TABLE `universidades` DISABLE KEYS */;
INSERT INTO `universidades` VALUES (1,'0000000001','Universidad Central de Venezuela','Maracay','UCV','Oficiales'),(2,'0000000002','Universidad Central de Venezuela','Cagua','UCV','Oficiales'),(3,'0000000003','Universidad de Carabobo','Valencia','UC','Oficiales'),(4,'0000000004','Universidad de Carabobo','Maracay','UC','Oficiales'),(5,'0000000005','Universidad Nacional Experimental de Los Llanos Occidentales Ezequiel Zamora','San Carlos','UNELLEZ','Oficiales'),(6,'0000000006','Universidad Nacional Experimental Sim','Maracay','UNESR','Oficiales'),(7,'0000000007','Universidad Nacional Experimental Sim','Canoabo','UNESR','Oficiales'),(8,'0000000008','Universidad Nacional Experimental Sim','San Carlos','UNESR','Oficiales'),(9,'0000000009','UPEL Instituto Pedag','Maracay','UPEL - IUP','Oficiales'),(10,'0000000010','UPEL Instituto Pedag','Maracay','UPEL - IPR','Oficiales'),(11,'0000000011','Universidad Nacional Experimental Polit','Maracay','UNEFA','Oficiales'),(12,'0000000012','Universidad Nacional Experimental Polit','Puerto Cabello','UNEFA','Oficiales'),(13,'0000000013','Universidad Tecnol','Guacara','UNITEC','Privadas'),(14,'0000000014','Universidad Bicentenaria de Aragua','Turmero','UBA','Privadas'),(15,'0000000015','Universidad Jos','Valencia','UJAP','Privadas'),(16,'0000000016','Universidad Arturo Michelena','San Diego (Edo. Carabobo)','UAM','Privadas'),(17,'0000000017','Instituto Universitario de Tecnolog','Valencia','IUTV',''),(18,'0000000018','Instituto Universitario Experimental de Tecnolog','La Victoria','IUET-LV',''),(19,'0000000019','Instituto Universitario de Tecnolog','Puerto Cabello','IUTPC',''),(20,'0000000020','Instituto Universitario de Tecnolog','Valencia','IUTSI',''),(21,'0000000021','Instituto Universitario de Tecnolog','Extensi','IUTA','Privadas'),(22,'0000000022','Instituto Universitario de Tecnolog','Extensi','IUTA','Privadas'),(23,'0000000023','Instituto Universitario de Tecnolog','Valencia','IUTEPAL',''),(24,'0000000024','Instituto Universitario de Tecnolog','Extensi','IUTEPAL','Privadas'),(25,'0000000025','Instituto Universitario de Tecnolog','Ampliaci','IUTEPAL',''),(26,'0000000026','Instituto Universitario de Tecnolog','Valencia','IUTI',''),(27,'0000000027','Instituto Universitario de Tecnolog','Valencia','IUTEPI','Privadas'),(28,'0000000028','Instituto Universitario de Tecnolog','La Victoria','IUTAR','Privadas'),(29,'0000000029','Instituto Universitario de Tecnolog','Cagua','IUTEPAS','Privadas'),(30,'0000000030','Instituto Universitario de Tecnolog','Maracay','IUTLEAC','Privadas'),(31,'0000000031','Colegio Universitario de Administraci','Valencia','CUAM','Privadas'),(32,'0000000032','Instituto Universitario Carlos Soublette','Maracay','IUNICS','Privadas'),(33,'0000000033','Instituto Universitario de Ciencias Administrativas y Fiscales','Maracay','IUCAF','Privadas'),(34,'0000000034','Escuela de Aviaci','Maracay','EAM','Oficiales'),(35,'0000000035','Instituto Universitario de Tecnolog','Maracay','ESCUTEAVIA',''),(36,'0000000036','Instituto Universitario de Tecnolog','Maracay','','Oficiales'),(37,'0000000037','Universidad Centro Occidental Lisandro Alvarado','Barquisimeto','UCLA','Oficiales'),(38,'0000000038','Universidad Centro Occidental Lisandro Alvarado','Carora','UCLA','Oficiales'),(39,'0000000039','Universidad Centro Occidental Lisandro Alvarado','El Tocuyo','UCLA','Oficiales'),(40,'0000000040','Universidad del Zulia','Punto Fijo','LUZ','Oficiales'),(41,'0000000041','Universidad Central de Venezuela','Centro Regional Barquisimeto','UCV','Oficiales'),(42,'0000000042','Universidad Central de Venezuela','Centro Regional Barquisimeto P.E.U.S.A.','UCV','Oficiales'),(43,'0000000043','Universidad Nacional Experimental Francisco de Miranda','Coro','UNEFM','Oficiales'),(44,'0000000044','Universidad Nacional Experimental de Los Llanos Occidentales Ezequiel Zamora','Guanare','UNELLEZ','Oficiales'),(45,'0000000045','Universidad Nacional Abierta','Centro Local Lara','UNA','Oficiales'),(46,'0000000046','Universidad Nacional Abierta','Unidad de Apoyo Carora','UNA','Oficiales'),(47,'0000000047','Universidad Nacional Abierta','Centro Local Portuguesa','UNA','Oficiales'),(48,'0000000048','Universidad Nacional Abierta','Unidad de Apoyo Biscucuy','UNA','Oficiales'),(49,'0000000049','Universidad Nacional Abierta','Unidad de Apoyo Tur','UNA','Oficiales'),(50,'0000000050','Universidad Nacional Abierta','Centro Local Falc','UNA','Oficiales'),(51,'0000000051','Universidad Nacional Abierta','Unidad de Apoyo Punto Fijo','UNA','Oficiales'),(52,'0000000052','Universidad Nacional Abierta','Unidad de Apoyo Churuguara','UNA','Oficiales'),(53,'0000000053','Universidad Nacional Abierta','Unidad de Apoyo Capat','UNA','Oficiales'),(54,'0000000054','Universidad Nacional Abierta','Centro Local Yaracuy','UNA','Oficiales'),(55,'0000000055','Universidad Nacional Experimental Sim','Barquisimeto','UNESR','Oficiales'),(56,'0000000056','Universidad Nacional Experimental Sim','Araure','UNESR','Oficiales'),(57,'0000000057','Universidad Nacional Experimental Sim','Coro','UNESR','Oficiales'),(58,'0000000058','Universidad Nacional Experimental Polit','Vice Rectorado de Barquisimeto','UNEXPO','Oficiales'),(59,'0000000059','Universidad Nacional Experimental Polit','Carora','UNEXPO','Oficiales'),(60,'0000000060','UPEL Instituto Pedag','Barquisimeto','UPEL - IPB','Oficiales'),(61,'0000000061','Universidad Nacional Experimental del Yaracuy','San Felipe','UNEY','Oficiales'),(62,'0000000062','Universidad Ferm','Cabudare','UFT','Privadas'),(63,'0000000063','Universidad Yacamb','Barquisimeto','UY','Privadas'),(64,'0000000064','Instituto Universitario de Tecnolog','Coro','IUTAG','Oficiales'),(65,'0000000065','Instituto Universitario de Tecnolog','San Felipe','IUTY','Oficiales'),(66,'0000000066','Instituto Universitario de Tecnolog','Acarigua','IUTEP',''),(67,'0000000067','Instituto Universitario de Tecnolog','Ampliaci','IUTEP',''),(68,'0000000068','Instituto Universitario de Tecnolog','Ampliaci','IUTEP',''),(69,'0000000069','Instituto Universitario Experimental de Tecnolog','Barquisimeto','IUTAEB',''),(70,'0000000070','Instituto Universitario de Tecnolog','Punto Fijo','IUTJLCH','Privadas'),(71,'0000000071','Instituto Universitario de Tecnolog','Extensi','IUTEPI','Privadas'),(72,'0000000072','Colegio Universitario Ferm','Barquisimeto','CUFT','Privadas'),(73,'0000000073','Colegio Universitario Ferm','Extensi','CUFT','Privadas'),(74,'0000000074','Instituto Universitario Adventista de Venezuela','Nirgua','IUA','Privadas'),(75,'0000000075','Universidad Nacional Experimental de Los Llanos Centrales R','San Juan De Los Morros','UNERG','Oficiales'),(76,'0000000076','Universidad Nacional Experimental de Los Llanos Occidentales Ezequiel Zamora','Apure','UNELLEZ','Oficiales'),(77,'0000000077','Universidad Nacional Experimental de Los Llanos Occidentales Ezequiel Zamora','Guasdualito','UNELLEZ','Oficiales'),(78,'0000000078','Universidad Nacional Experimental Sim','San Juan de Los Morros','UNESR','Oficiales'),(79,'0000000079','Universidad Nacional Experimental Sim','Valle de La Pascua','UNESR','Oficiales'),(80,'0000000080','Universidad Nacional Experimental Sim','Zaraza','UNESR','Oficiales'),(81,'0000000081','Universidad Nacional Experimental Sim','Apure','UNESR','Oficiales'),(82,'0000000082','Universidad Nacional Abierta','Centro Local Apure','UNA','Oficiales'),(83,'0000000083','Universidad Nacional Abierta','Unidad de Apoyo Guasdualito','UNA','Oficiales'),(84,'0000000084','Universidad Nacional Abierta','Unidad de Apoyo Elorza','UNA','Oficiales'),(85,'0000000085','Universidad Nacional Abierta','Unidad de Apoyo Valle de la Pascua','UNA','Oficiales'),(86,'0000000086','Universidad Nacional Abierta','Centro Local Gu','UNA',''),(87,'0000000087','Instituto Universitario de Tecnolog','Valle De La Pascua','IUTLL','Oficiales'),(88,'0000000088','Instituto Universitario de Tecnolog','Extensi','IUTLL','Oficiales'),(89,'0000000089','Instituto Universitario de Tecnolog','Extensi','IUTLL','Oficiales'),(90,'0000000090','Instituto Universitario de Tecnolog','San Fernando de Apure','IUTAP',''),(91,'0000000091','Universidad de Oriente','Ciudad Bol','UDO','Oficiales'),(92,'0000000092','Universidad de Oriente','Unidad Experimental Puerto Ordaz','UDO','Oficiales'),(93,'0000000093','Universidad Central de Venezuela','Centro Regional Ciudad Bol','UCV','Oficiales'),(94,'0000000094','Universidad Central de Venezuela','Centro Regional Puerto Ayacucho','UCV','Oficiales'),(95,'0000000095','Universidad Nacional Experimental de Guayana','Puerto Ordaz','UNEG','Oficiales'),(96,'0000000096','Universidad Nacional Experimental de Guayana','Upata','UNEG','Oficiales'),(97,'0000000097','Universidad Nacional Experimental Sim','Ciudad Bol','UNESR','Oficiales'),(98,'0000000098','Universidad Nacional Experimental Polit','Vice Rectorado de Puerto Ordaz','UNEXPO','Oficiales'),(99,'0000000099','Universidad Nacional Abierta','Centro Local Bol','UNA','Oficiales'),(100,'0000000100','Universidad Nacional Abierta','Unidad de Apoyo Guasipati','UNA','Oficiales'),(101,'0000000101','Universidad Nacional Abierta','Centro Local Delta Amacuro','UNA','Oficiales'),(102,'0000000102','Universidad Nacional Abierta','Centro Local Puerto Amazonas','UNA','Oficiales'),(103,'0000000103','Instituto Universitario de Tecnolog','Tucupita','IUTDM','Oficiales'),(104,'0000000104','Instituto Universitario de Tecnolog','Ciudad Bolivar','IUTEB','Oficiales'),(105,'0000000105','Instituto Universitario de Tecnolog','Extensi','IUTPEC','Privadas'),(106,'0000000106','Universidad Central de Venezuela','Caracas','UCV','Oficiales'),(107,'0000000107','Universidad Nacional Experimental Sim','Caracas','USB','Oficiales'),(108,'0000000108','Universidad Nacional Experimental Sim','Litoral','USB','Oficiales'),(109,'0000000109','Universidad Nacional Experimental Sim','Caracas: El Valle','UNESR','Oficiales'),(110,'0000000111','Universidad Nacional Experimental Sim','Programa CEPAP','UNESR','Oficiales'),(111,'0000000112','Universidad Nacional Experimental Sim','Caracas: Caricuao','UNESR','Oficiales'),(112,'0000000113','Universidad Nacional Experimental Sim','Caracas: Palo Verde','UNESR','Oficiales'),(113,'0000000114','Universidad Nacional Experimental Sim','Los Teques','UNESR','Oficiales'),(114,'0000000115','Universidad Nacional Experimental Sim','Valles del Tuy','UNESR','Oficiales'),(115,'0000000116','Universidad Nacional Abierta','Caracas','UNA','Oficiales'),(116,'0000000117','Universidad Nacional Abierta','Centro Local Metropolitano','UNA','Oficiales'),(117,'0000000118','Universidad Nacional Abierta','Unidad de Apoyo Vargas','UNA','Oficiales'),(118,'0000000119','Universidad Nacional Abierta','Unidad de Apoyo San Antonio de los Altos','UNA','Oficiales'),(119,'0000000120','Universidad Nacional Abierta','Unidad de Apoyo Valles del Tuy (Santa Lucia)','UNA','Oficiales'),(120,'0000000121','Universidad Nacional Abierta','Unidad de Apoyo Barlovento (Caucagua)','UNA','Oficiales'),(121,'0000000122','Universidad Pedag','Caracas','UPEL','Oficiales'),(122,'0000000123','UPEL Instituto Pedag','Caracas','UPEL - IPC','Oficiales'),(123,'0000000124','UPEL Instituto Pedag','Caracas','UPEL - IPM','Oficiales'),(124,'0000000125','UPEL Instituto de Mejoramiento Profesional del Magisterio','Caracas','UPEL - IMP','Oficiales'),(125,'0000000126','Universidad Nacional Experimental Polit','Vice Rectorado \"Luis Caballero Mej','UNEXPO','Oficiales'),(126,'0000000127','Universidad Nacional Experimental Polit','Vice Rectorado \"Luis Caballero Mej','UNEXPO','Oficiales'),(127,'0000000128','Universidad Nacional Experimental Polit','Vice-Rectorado \"Luis Caballero Mej','UNEXPO',''),(128,'0000000129','Universidad Nacional Experimental Polit','Caracas','UNEFA','Oficiales'),(129,'0000000130','Universidad Nacional Experimental Mar','Catia La Mar','UMC','Oficiales'),(130,'0000000131','Universidad Metropolitana','Caracas','UNIMET','Privadas'),(131,'0000000132','Universidad Cat','Caracas','UCAB','Privadas'),(132,'0000000133','Universidad Santa Mar','Caracas','USM','Privadas'),(133,'0000000134','Universidad Jos','Caracas','UJMV','Privadas'),(134,'0000000135','Universidad Nueva Esparta','Caracas - Los Naranjos','UNE','Privadas'),(135,'0000000136','Universidad Alejandro de Humboldt','Caracas','UAH','Privadas'),(136,'0000000137','Universidad Monte','Caracas','UMA','Privadas'),(137,'0000000138','Universidad Cat','Caracas','USR','Privadas'),(138,'0000000139','Instituto Universitario Pedag','Caracas','IUPMA','Privadas'),(139,'0000000140','Instituto Universitario de Tecnolog','Caracas','IUTFRP','Oficiales'),(140,'0000000141','Instituto Universitario de Tecnolog','Caracas','ENAHP','Oficiales'),(141,'0000000142','Instituto Universitario de Tecnolog','Caracas','IUTOMS','Oficiales'),(142,'0000000143','Instituto Universitario de Tecnolog','Caracas','IUTB','Oficiales'),(143,'0000000144','Instituto Universitario de Tecnolog','Caracas','IUTAJS','Privadas'),(144,'0000000145','Instituto Universitario de Tecnolog','Caracas','IUTIRLA','Privadas'),(145,'0000000150','Instituto Universitario de Tecnolog','Caracas','IUTV','Privadas'),(146,'0000000152','Instituto Universitario de Tecnolog','Caracas','IUTAV','Privadas'),(147,'0000000153','Instituto Universitario de Tecnolog','Guatire','IUTECP','Privadas'),(148,'0000000154','Instituto Universitario de Tecnolog','Guatire','IUTRBF','Privadas'),(149,'0000000155','Instituto Universitario de Tecnolog','Ocumare de Tuy','IUTTOL','Privadas'),(150,'0000000156','Instituto Universitario de Tecnolog','Caracas','IUTI','Privadas'),(151,'0000000157','Instituto Universitario de Tecnolog','Regi','IUTA','Privadas'),(152,'0000000158','Colegio Universitario de Caracas','Caracas','CUC','Oficiales'),(153,'0000000159','Colegio Universitario Francisco de Miranda','Caracas','CUFM','Oficiales'),(154,'0000000160','Colegio Universitario de Los Teques Cecilio Acosta','Los Teques','CULTCA','Oficiales'),(155,'0000000161','Colegio Universitario Profesor Jos','Caracas','CUJLP','Oficiales'),(156,'0000000162','Colegio Universitario de Enfermer','Caracas','CUEAMC','Oficiales'),(157,'0000000163','Colegio Universitario de Rehabilitaci','Caracas','CUR','Oficiales'),(158,'0000000164','Colegio Universitario de Enfermer','Caracas','CUECRV','Privadas'),(159,'0000000165','Colegio Universitario de Enfermer','Caracas.','CUECMC','Privadas'),(160,'0000000166','Colegio Universitario Monse','Caracas','CUMT','Privadas'),(161,'0000000167','Colegio Universitario Jean Piaget','Caracas','CUJP','Privadas'),(162,'0000000168','Colegio Universitario de Psicopedagog','Caracas','CUP','Privadas'),(163,'0000000169','Colegio Universitario Ferm','Extensi','CUFT','Privadas'),(164,'0000000170','Instituto Universitario de la Polic','Caracas','IUPM','Oficiales'),(165,'0000000171','Instituto Universitario de Polic','Caracas','IUPC',''),(166,'0000000172','Instituto Universitario de Estudios Musicales','Caracas','IUDEM',''),(167,'0000000173','Instituto Universitario de Teatro','Caracas','IUDET',''),(168,'0000000174','Instituto Universitario de Estudios Superiores de Artes Pl','Caracas','IUESAPAR',''),(169,'0000000175','Instituto Universitario de Danza','Caracas','IUDANZA',''),(170,'0000000176','Instituto Universitario Nacional de Estudios Penitenciarios','Caracas','IUNEP','Oficiales'),(171,'0000000177','Instituto Universitario de Barlovento','Higuerote','IUB',''),(172,'0000000178','Instituto Universitario AVEPANE','Caracas','IUAVEPANE','Privadas'),(173,'0000000179','Instituto Universitario de Seguros','Caracas','IUS','Privadas'),(174,'0000000180','Instituto Universitario de Relaciones P','Caracas','IURP','Privadas'),(175,'0000000181','Instituto Universitario de la Audici','Caracas','IVAL','Privadas'),(176,'0000000182','Instituto Universitario de Mercadotecnia','Caracas','ISUM','Privadas'),(177,'0000000183','Instituto Universitario YMCA Lope Mendoza','Caracas','IUYLM','Privadas'),(178,'0000000184','Instituto Universitario de Nuevas Profesiones','Caracas','IUNP','Privadas'),(179,'0000000186','Instituto Universitario de Dise','Caracas','IUDLM','Privadas'),(180,'0000000187','Instituto Universitario Jes','Caracas','IUJO','Privadas'),(181,'0000000188','Instituto Universitario de Profesiones Gerenciales','Caracas','IUPG','Privadas'),(182,'0000000189','Instituto Universitario de Gerencia y Tecnolog','Caracas','IUGT','Privadas'),(183,'0000000190','Instituto Universitario de Tecnolog','Caracas','IUAA','Privadas'),(184,'0000000191','Instituto Universitario de Administraci','Caracas','IUDAG','Privadas'),(185,'0000000192','Instituto Universitario Salesiano Padre Ojeda','Los Teques','IUSPO','Privadas'),(186,'0000000193','Academia Militar de Venezuela','Caracas','AMV','Oficiales'),(187,'0000000194','Escuela de Formaci','Caracas','EFOFAC',''),(188,'0000000195','Escuela Naval de Venezuela','Meseta de Mamo','ENV','Oficiales'),(189,'0000000196','Instituto Universitario Militar de Comunicaciones y Electr','Caracas','IUM ESCOEL',''),(190,'0000000197','Instituto Universitario Militar Escuela de Sub-Oficiales de la Armada','Catia la Mar (Edo.Vargas)','IUM ESOAR',''),(191,'0000000198','Universidad de Los Andes','M','ULA','Oficiales'),(192,'0000000199','Universidad de Los Andes','T','ULA','Oficiales'),(193,'0000000200','Universidad de Los Andes','Trujillo','ULA','Oficiales'),(194,'0000000201','Universidad Nacional Experimental de Los Llanos Occidentales Ezequiel Zamora','Barinas','UNELLEZ','Oficiales'),(195,'0000000202','Universidad Nacional Experimental de Los Llanos Occidentales Ezequiel Zamora','Santa B','UNELLEZ','Oficiales'),(196,'0000000203','Universidad Nacional Experimental del T','San Crist','UNET','Oficiales'),(197,'0000000204','Universidad Nacional Experimental Sim','El Vig','UNESR','Oficiales'),(198,'0000000205','Universidad Nacional Experimental Sim','Valera','UNESR','Oficiales'),(199,'0000000206','Universidad Nacional Experimental Sim','La Grita','UNESR','Oficiales'),(200,'0000000207','Universidad Nacional Abierta','Centro Local M','UNA','Oficiales'),(201,'0000000208','Universidad Nacional Abierta','Unidad de Apoyo Tovar','UNA','Oficiales'),(202,'0000000209','Universidad Nacional Abierta','Centro Local San Crist','UNA','Oficiales'),(203,'0000000210','Universidad Nacional Abierta','Centro Local Trujillo','UNA','Oficiales'),(204,'0000000211','Universidad Nacional Abierta','Unidad de Apoyo Bocon','UNA','Oficiales'),(205,'0000000212','Universidad Nacional Abierta','Centro Local Barinas','UNA','Oficiales'),(206,'0000000213','UPEL Instituto Pedag','Rubio','UPEL - IPR','Oficiales'),(207,'0000000214','Universidad Cat','San Crist','UCAT','Privadas'),(208,'0000000215','Universidad Valle del Momboy','Valera','UVM','Privadas'),(209,'0000000216','Instituto Universitario de Tecnolog','San Crist','IUTAIRA','Oficiales'),(210,'0000000217','Instituto Universitario de Tecnolog','Col','IUTAIRA','Oficiales'),(211,'0000000218','Instituto Universitario de Tecnolog','Valera','IUTET','Oficiales'),(212,'0000000219','Instituto Universitario de Tecnolog','Extensi','IUTET','Oficiales'),(213,'0000000220','Instituto Universitario de Tecnolog','Extensi','IUTRB','Oficiales'),(214,'0000000221','Instituto Universitario de Tecnolog','Extensi','IUTET','Oficiales'),(215,'0000000222','Instituto Universitario de Tecnolog','Ejido','IUTE',''),(216,'0000000223','Instituto Universitario de Tecnolog','Extensi','IUTI','Privadas'),(217,'0000000224','Instituto Universitario de Tecnolog','El Vig','IUTCM',''),(218,'0000000225','Instituto Universitario Experimental de Tecnolog','Ciudad Bolivia (Estado Barinas)','IUETASB',''),(219,'0000000226','Instituto Universitario de Tecnolog','Extensi','IUTEPAL','Privadas'),(220,'0000000227','Instituto Universitario de Tecnolog','Valera','UNIHER','Privadas'),(221,'0000000228','Instituto Universitario de Tecnolog','Valera','IUTEMBI','Privadas'),(222,'0000000229','Instituto Universitario de Tecnolog','Barinas','IUTAC','Privadas'),(223,'0000000230','Instituto Universitario de Tecnolog','Rubio','IUTLA','Privadas'),(224,'0000000231','Colegio Universitario Hotel Escuela de Los Andes Venezolanos','M','CUHELAV',''),(225,'0000000232','Instituto Universitario de la Frontera','San Antonio del T','IUFRONT','Privadas'),(226,'0000000233','Instituto Universitario Gran Colombia','San Cristobal','IUGC','Privadas'),(227,'0000000234','Instituto Universitario Eclesi','San Crist','IUESTA','Privadas'),(228,'0000000236','Universidad de Oriente','Cuman','UDO','Oficiales'),(229,'0000000237','Universidad de Oriente','Sucre - Cuman','UDO','Oficiales'),(230,'0000000238','Universidad de Oriente','Sucre - Car','UDO','Oficiales'),(231,'0000000239','Universidad de Oriente','Anzo','UDO','Oficiales'),(232,'0000000240','Universidad de Oriente','Nueva Esparta','UDO','Oficiales'),(233,'0000000241','Universidad de Oriente','Monagas','UDO','Oficiales'),(234,'0000000242','Universidad Central de Venezuela','Centro Regional Barcelona','UCV','Oficiales'),(235,'0000000243','Universidad Nacional Experimental Sim','Matur','UNESR','Oficiales'),(236,'0000000244','Universidad Nacional Experimental Sim','Barcelona','UNESR','Oficiales'),(237,'0000000245','Universidad Nacional Abierta','Centro Local Anzoategui','UNA','Oficiales'),(238,'0000000246','Universidad Nacional Abierta','Unidad de Apoyo El Tigre','UNA','Oficiales'),(239,'0000000247','Universidad Nacional Abierta','Unidad de Apoyo Anaco','UNA','Oficiales'),(240,'0000000248','Universidad Nacional Abierta','Centro Local Sucre','UNA','Oficiales'),(241,'0000000249','Universidad Nacional Abierta','Unidad de Apoyo Car','UNA','Oficiales'),(242,'0000000250','Universidad Nacional Abierta','Unidad de Apoyo G','UNA','Oficiales'),(243,'0000000251','Universidad Nacional Abierta','Unidad de Apoyo Cariaco','UNA','Oficiales'),(244,'0000000252','Universidad Nacional Abierta','Centro Local Monagas','UNA','Oficiales'),(245,'0000000253','Universidad Nacional Abierta','Unidad de Apoyo Punta de Mata','UNA','Oficiales'),(246,'0000000254','Universidad Nacional Abierta','Unidad de Apoyo Caripito','UNA','Oficiales'),(247,'0000000255','Universidad Nacional Abierta','Unidad de Apoyo Temblador','UNA','Oficiales'),(248,'0000000256','Universidad Nacional Abierta','Centro Local Nueva Esparta','UNA','Oficiales'),(249,'0000000257','UPEL Instituto Pedag','Maturin','UPEL - IPM','Oficiales'),(250,'0000000258','Universidad de Margarita','El Valle','UNIMAR','Privadas'),(251,'0000000259','Universidad Nororiental Gran Mariscal de Ayacucho','Barcelona','UGMA','Privadas'),(252,'0000000260','Instituto Universitario Polit','Barcelona','IUPSM','Privadas'),(253,'0000000261','Instituto Universitario de Tecnolog','Cumana','IUTC',''),(254,'0000000262','Instituto Universitario de Tecnolog','Extensi','IUTC',''),(255,'0000000263','Instituto Universitario de Tecnolog','Caripito','IUTC',''),(256,'0000000264','Instituto Universitario de Tecnolog','El Tigre','IUTJAA','Oficiales'),(257,'0000000265','Instituto Universitario de Tecnolog','Extensi','IUTJAA','Oficiales'),(258,'0000000266','Instituto Universitario de Tecnolog','Extensi','IUTJAA','Oficiales'),(259,'0000000267','Instituto Universitario de Tecnolog','Extensi','IUTJAA','Oficiales'),(260,'0000000268','Instituto Universitario de Tecnolog','Car','IUTJNV',''),(261,'0000000269','Instituto Universitario de Tecnolog','Punta de Piedras','IUTEMAR','Privadas'),(262,'0000000270','Instituto Universitario de Tecnolog','Anaco','IUTA','Privadas'),(263,'0000000271','Instituto Universitario de Tecnolog','Extensi','IUTA','Oficiales'),(264,'0000000272','Instituto Universitario de Tecnolog','Pto. La Cruz','IUTHEPI','Privadas'),(265,'0000000273','Instituto Universitario de Tecnolog','Pto. La Cruz','IUTSO','Privadas'),(266,'0000000274','Instituto Universitario de Tecnolog','Extensi','IUTEPAL.','Privadas'),(267,'0000000275','Instituto Universitario de Tecnolog','Barcelona','IUTGPMF','Privadas'),(268,'0000000276','Instituto Universitario Insular','Porlamar','IUI',''),(269,'0000000277','Universidad del Zulia','Maracaibo','LUZ','Oficiales'),(270,'0000000278','Universidad del Zulia','Cabimas','LUZ','Oficiales'),(271,'0000000279','Universidad Nacional Experimental Rafael Mar','Cabimas','UNERMB','Oficiales'),(272,'0000000280','Universidad Nacional Experimental Sur del Lago Jes','Col','UNESUR','Oficiales'),(273,'0000000281','Universidad Nacional Abierta','Centro Local Zulia','UNA','Oficiales'),(274,'0000000282','Universidad Nacional Abierta','Unidad de Apoyo Santa B','UNA','Oficiales'),(275,'0000000283','Universidad Rafael Urdaneta','Maracaibo','URU','Privadas'),(276,'0000000284','Universidad Cat','Maracaibo','UNICA','Privadas'),(277,'0000000285','Universidad Dr. Rafael Belloso Chac','Maracaibo','URBE','Privadas'),(278,'0000000286','Instituto Universitario de Tecnolog','Maracaibo','IUTM','Oficiales'),(279,'0000000287','Instituto Universitario de Tecnolog','Extensi','IUTM','Oficiales'),(280,'0000000288','Instituto Universitario de Tecnolog','Extensi','IUTM','Oficiales'),(281,'0000000289','Instituto Universitario de Tecnolog','Cabimas','IUTC','Oficiales'),(282,'0000000290','Instituto Universitario de Tecnolog','Extensi','IUTC','Oficiales'),(283,'0000000291','Instituto Universitario de Tecnolog','Extensi','IUTEPAL','Privadas'),(284,'0000000292','Instituto Universitario de Tecnolog','Maracaibo','IUTPEC','Privadas'),(285,'0000000293','Instituto Universitario de Tecnolog','Extensi','IUTI','Privadas'),(286,'0000000294','Instituto Universitario de Tecnolog','Maracaibo','UNIR','Privadas'),(287,'0000000295','Colegio Universitario Dr. Rafael Belloso Chac','Maracaibo','CUNIBE','Privadas'),(288,'0000000296','Instituto Universitario Jes','Maracaibo','IUJEL','Privadas'),(289,'0000000297','Instituto Universitario de Educaci','Maracaibo','IUNE','Privadas'),(290,'0000000298','Universidad Nacional Abierta','Centro Local Aragua','UNA','Oficiales'),(291,'0000000299','Universidad Nacional Abierta','Centro Local Cojedes','UNA','Oficiales'),(292,'0000000300','Universidad Nacional Abierta','Centro Local Carabobo','UNA','Oficiales'),(293,'0000000301','Universidad Nacional Abierta','Unidad de Apoyo Puerto Cabello','UNA','Oficiales'),(294,'0000000302','Colegio Universitario de Administraci','Extensi','CUAM','Privadas'),(295,'0000000303','Colegio Universitario de Administraci','Ampliaci','CUAM',''),(296,'0000000304','Colegio Universitario de Administraci','Extensi','CUAM','Oficiales'),(297,'0000000305','Colegio Universitario de Administraci','Extensi','CUAM','Privadas'),(298,'0000000306','Colegio Universitario de Administraci','Extensi','CUAM','Privadas'),(299,'0000000307','Colegio Universitario de Administraci','Extensi','CUAM','Privadas'),(300,'0000000308','Instituto Universitario de Tecnolog','Extensi','IUTI','Privadas'),(301,'0000000309','Instituto Universitario de Tecnolog','Ampliaci','IUTI','Oficiales'),(302,'0000000310','Universidad Bicentenaria de Aragua','San Antonio de Los Altos','UBA','Privadas'),(303,'0000000311','Universidad Bicentenaria de Aragua','San Fernando de Apure','UBA','Privadas'),(304,'0000000312','Universidad Nororiental Gran Mariscal de Ayacucho','Anaco','UGMA','Oficiales'),(305,'0000000313','Universidad Nororiental Gran Mariscal de Ayacucho','El Tigre','UGMA','Oficiales'),(306,'0000000314','Universidad Nororiental Gran Mariscal de Ayacucho','Cuman','UGMA','Privadas'),(307,'0000000315','Universidad Nororiental Gran Mariscal de Ayacucho','Matur','UGMA','Privadas'),(308,'0000000316','Universidad Nororiental Gran Mariscal de Ayacucho','Ciudad Bol','UGMA','Privadas'),(309,'0000000317','Universidad Nororiental Gran Mariscal de Ayacucho','Ciudad Guayana','UGMA','Oficiales'),(310,'0000000318','Universidad Cat','Los Teques','UCAB','Privadas'),(311,'0000000319','Universidad Cat','Ciudad Guayana','UCAB','Privadas'),(312,'0000000320','Universidad Cat','Coro','UCAB','Privadas'),(313,'0000000321','Instituto Universitario de Tecnolog','Ampliaci','IUTEPAL',''),(314,'0000000322','Colegio Universitario Monse','Extensi','CUMT','Privadas'),(315,'0000000323','Colegio Universitario Monse','Extensi','CUMT','Privadas'),(316,'0000000324','Colegio Universitario Monse','Extensi','CUMT','Privadas'),(317,'0000000325','Colegio Universitario Monse','Ampliaci','CUMT',''),(318,'0000000326','Colegio Universitario Monse','Extensi','CUMT','Privadas'),(319,'0000000327','Colegio Universitario Monse','Extensi','CUMT','Privadas'),(320,'0000000328','Colegio Universitario de Psicopedagog','Extensi','CUP','Privadas'),(321,'0000000329','Colegio Universitario Ferm','Extensi','CUFT','Oficiales'),(322,'0000000330','Instituto Universitario Carlos Soublette','Extensi','IUNICS','Oficiales'),(323,'0000000331','Instituto Universitario de la Frontera','Ampliaci','IUFRONT',''),(324,'0000000332','Instituto Universitario de la Frontera','Ampliaci','IUFRONT',''),(325,'0000000333','Instituto Universitario de la Frontera','Extensi','IUFRONT','Privadas'),(326,'0000000334','Instituto Universitario de Mercadotecnia','Extensi','ISUM',''),(327,'0000000335','Instituto Universitario de Nuevas Profesiones','Extensi','IUNP','Privadas'),(328,'0000000336','Instituto Universitario de Tecnolog','Ampliaci','IUTAJS',''),(329,'0000000337','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(330,'0000000338','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(331,'0000000339','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(332,'0000000340','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(333,'0000000341','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(334,'0000000342','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(335,'0000000343','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(336,'0000000344','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(337,'0000000345','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(338,'0000000346','Instituto Universitario de Tecnolog','Extensi','IUTAJS',''),(339,'0000000347','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(340,'0000000348','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(341,'0000000349','Instituto Universitario de Tecnolog','Extensi','IUTAJS','Privadas'),(342,'0000000350','Instituto Universitario de Tecnolog','Ampliaci','IUTAR',''),(343,'0000000351','Instituto Universitario de Tecnolog','Ampliaci','IUTAR',''),(344,'0000000352','Instituto Universitario de Tecnolog','Extensi','IUTCM',''),(345,'0000000353','Instituto Universitario de Tecnolog','Ampliaci','IUTA',''),(346,'0000000354','Instituto Universitario de Tecnolog','Ampliaci','IUTA',''),(347,'0000000355','Instituto Universitario de Tecnolog','Extensi','IUTV','Privadas'),(348,'0000000356','Instituto Universitario de Tecnolog','Extensi','IUTEMAR','Privadas'),(349,'0000000357','Instituto Universitario de Tecnolog','Extensi','IUTEMAR',''),(350,'0000000358','Instituto Universitario de Tecnolog','Extensi','IUTEMAR','Oficiales'),(351,'0000000359','Instituto Universitario de Tecnolog','Ampliaci','IUTIRLA','Privadas'),(352,'0000000360','Instituto Universitario de Tecnolog','Extensi','IUTIRLA','Privadas'),(353,'0000000361','Instituto Universitario de Tecnolog','Extensi','IUTIRLA','Privadas'),(354,'0000000362','Instituto Universitario de Tecnolog','Extensi','IUTIRLA','Privadas'),(355,'0000000363','Instituto Universitario de Tecnolog','Extensi','IUTIRLA','Privadas'),(356,'0000000364','Instituto Universitario de Tecnolog','Extensi','IUTIRLA','Privadas'),(357,'0000000365','Instituto Universitario de Tecnolog','Extensi','IUTIRLA','Privadas'),(358,'0000000366','Instituto Universitario de Tecnolog','Extensi','IUTIRLA','Privadas'),(359,'0000000367','Instituto Universitario de Tecnolog','Extensi','IUTIRLA','Privadas'),(360,'0000000368','Instituto Universitario de Tecnolog','Extensi','IUTIRLA','Oficiales'),(361,'0000000369','Instituto Universitario de Tecnolog','Ampliaci','IUTEPI',''),(362,'0000000370','Instituto Universitario de Tecnolog','Extensi','IUTPEC','Oficiales'),(363,'0000000371','Instituto Universitario de Tecnolog','Ampliaci','UNIR',''),(364,'0000000372','Instituto Universitario Jes','Extensi','IUJEL','Privadas'),(365,'0000000373','Instituto Universitario Pedag','Extensi','IUPMA','Privadas'),(366,'0000000374','Instituto Universitario Pedag','Extensi','IUPMA','Privadas'),(367,'0000000375','Instituto Universitario Pedag','Extensi','IUPMA','Privadas'),(368,'0000000376','Instituto Universitario Pedag','Extensi','IUPMA','Privadas'),(369,'0000000377','Instituto Universitario Pedag','Extensi','IUPMA','Privadas'),(370,'0000000378','Instituto Universitario Pedag','Extensi','IUPMA','Privadas'),(371,'0000000379','Instituto Universitario Pedag','Extensi','IUPMA','Privadas'),(372,'0000000380','Instituto Universitario Pedag','Extensi','IUPMA','Oficiales'),(373,'0000000381','Instituto Universitario Pedag','Extensi','IUPMA','Oficiales'),(374,'0000000382','Instituto Universitario Pedag','Extensi','IUPMA','Privadas'),(375,'0000000383','Instituto Universitario Pedag','Extensi','IUPMA','Oficiales'),(376,'0000000384','Instituto Universitario Polit','Extensi','IUPSM',''),(377,'0000000385','Instituto Universitario Polit','Extensi','IUPSM',''),(378,'0000000386','Instituto Universitario Polit','Extensi','IUPSM',''),(379,'0000000387','Instituto Universitario Polit','Extensi','IUPSM','Privadas'),(380,'0000000388','Instituto Universitario Polit','Extensi','IUPSM','Oficiales'),(381,'0000000389','Instituto Universitario Polit','Extensi','IUPSM','Privadas'),(382,'0000000390','Instituto Universitario Polit','Extensi','IUPSM',''),(383,'0000000391','Instituto Universitario Polit','Extensi','IUPSM','Privadas'),(384,'0000000392','Instituto Universitario Polit','Extensi','IUPSM',''),(385,'0000000393','Instituto Universitario Polit','Extensi','IUPSM',''),(386,'0000000394','Instituto Universitario Polit','Extensi','IUPSM','Privadas'),(387,'0000000395','Instituto Universitario Polit','Extensi','IUPSM','Privadas'),(388,'0000000396','Universidad Santa Mar','Sede Oriente','USM','Privadas'),(389,'0000000397','Universidad Santa Mar','Sede Amazonas','USM','Privadas'),(390,'0000000398','Instituto Universitario de Tecnolog','Extensi','IUTE',''),(391,'0000000399','Instituto Universitario de Tecnolog','Ampliaci','IUTEPAL',''),(392,'0000000400','Universidad Nacional Experimental de Los Llanos Centrales R','Zaraza','UNERG','Oficiales'),(393,'0000000401','Universidad Nacional Experimental de Los Llanos Centrales R','Calabozo','UNERG','Oficiales'),(394,'0000000402','Universidad Yacamb','Araure - Acarigua','UY','Privadas'),(395,'0000000403','Instituto Universitario de Educaci','Extensi','IUNE',''),(396,'0000000404','Universidad Dr. Jos','Maracaibo','UJGH','Privadas'),(397,'0000000405','Universidad Alonso de Ojeda','Ciudad Ojeda','UAO','Privadas'),(398,'0000000406','Instituto Universitario de Tecnolog','Apure','IUTMM','Privadas'),(399,'0000000407','Instituto Universitario de Tecnolog','Tumeremo','IUTEMAR','Privadas'),(400,'0000000408','Instituto Universitario Carlos Soublette','Valencia','IUNICS','Privadas'),(401,'0000000409','Instituto Universitario de Tecnolog','San Joaquin','IUTA','Oficiales'),(402,'0000000410','Universidad Nueva Esparta','Caracas - Centro','UNE','Privadas'),(403,'0000000411','Instituto Universitario de Tecnolog','Los Teques','IUTRBF','Privadas'),(404,'0000000412','Universidad Nacional Experimental Rafael Mar','Ciudad Ojeda','UNERMB','Oficiales'),(405,'0000000413','Universidad Nacional Experimental Rafael Mar','Mene Grande','UNERMB','Oficiales'),(406,'0000000414','Universidad Nacional Experimental Rafael Mar','Puertos de Altagracia','UNERMB','Oficiales'),(407,'0000000415','Instituto Universitario de Tecnolog','Mariara','IUTAM','Privadas'),(408,'0000000416','Instituto Universitario de Tecnolog','Maracay','POLYCOM','Privadas'),(409,'0000000417','Instituto Universitario de Educaci','Valera','IUNE',''),(410,'0000000418','Instituto Universitario de Tecnolog','C','IUTJMC','Privadas'),(411,'0000000419','Instituto Universitario de Tecnolog','Extensi','IUTIRLA',''),(412,'0000000420','Universidad Nacional Abierta','Unidad de Apoyo Caripe','UNA','Oficiales'),(413,'0000000422','Universidad Bolivariana de Venezuela','Caracas','UBV','Oficiales'),(414,'0000000423','Universidad Bolivariana de Venezuela','Zulia','UBV','Oficiales'),(415,'0000000424','Universidad Panamericana del Puerto','Puerto Cabello','UPAP','Privadas'),(416,'0000000425','Instituto Universitario Experimental de Tecnolog','Extensi','IUET-LV',''),(417,'0000000427','Instituto Universitario de Tecnolog','Extensi','IUTPC','Oficiales'),(418,'0000000428','Instituto Universitario de Tecnolog','Tucan','IUTE',''),(419,'0000000429','Universidad Bicentenaria de Aragua','Puerto Ordaz','UBA','Privadas'),(420,'0000000430','Instituto Universitario de Tecnolog','Extensi','IUTEMBI','Privadas'),(421,'0000000431','Universidad de Oriente','Anaco','UDO','Oficiales'),(422,'0000000432','Instituto Universitario de Tecnolog','Barinitas','IUTEBA',''),(423,'0000000433','Universidad de Falc','Carirubana','UDEFA','Privadas'),(424,'0000000447','Instituto Universitario San Francisco','Maracaibo','IUSFRA','Privadas'),(425,'0000000448','Instituto Universitario de Tecnolog','Puerto Ayacucho','IUTA','Privadas'),(426,'0000000451','Universidad Santa Mar','Barinas','USMB','Privadas'),(427,'0000000452','Universidad Bolivariana de Venezuela','Ciudad Bolivar','UBV','Oficiales'),(428,'0000000453','Universidad Bolivariana de Venezuela','Punto Fijo','UBV','Oficiales'),(429,'0000000454','Universidad Privada Alejandro de Humboldt','Valencia','','Privadas'),(430,'0000000455','Universidad Nacional Experimental de Guayana','Ciudad Bolivar','UNEG','Oficiales'),(431,'0000000456','Instituto Militar Universitario de Tecnologia de la Guardia Nacional','Ramo Verde','IMUGN',''),(432,'0000000457','Universidad Ferm','Portuguesa-Araure','UFT','Privadas'),(433,'0000000458','Instituto Universitario de Tecnolog','Socop','IUTAC','Oficiales'),(434,'0000000459','Colegio Universitario Padre Isa','Naguanagua','CUPIO','Privadas'),(435,'0000000461','Instituto Militar Universitario de Tecnolog','Cordero','IMUTGNC',''),(436,'0000000462','Instituto Militar Universitario de Tecnolog','Punta de Mata','IMUGNPM',''),(437,'0000000463','Instituto Militar Universitario de Tecnolog','Michelena','IMUGNM',''),(438,'0000000464','Instituto Militar Universitario de Tecnolog','El Yaque','IMUGNEY',''),(439,'0000000465','Instituto Militar Universitario de Tecnolog','Guanta','IMUGNG','Oficiales'),(440,'0000000466','Instituto Militar Universitario de Tecnolog','La Guaira','IMUTGN',''),(441,'0000000467','Instituto Militar Universitario de Tecnolog','La Encrucijada','IMUGNLE',''),(442,'0000000468','Instituto Militar Universitario de Tecnolog','Santa B','IMUGNB',''),(443,'0000000469','Universidad Nacional Experimental de las Artes (UNEARTE)','Caracas','','Oficiales'),(444,'0000000471','Universidad Deportiva del Sur','San Carlos','','Oficiales'),(445,'0000000474','Universidad Nacional Experimental Polit','N','','Oficiales'),(446,'0000000475','Instituto Universitario Jes','Barquisimeto','','Privadas'),(447,'0000000476','Universidad Nacional Experimental de Guayana','Guasipati','','Oficiales'),(448,'0000000477','Universidad Nacional Experimental de Guayana','El Callao','','Oficiales'),(449,'0000000479','Universidad Bolivariana de Venezuela','Carabobo','','Oficiales'),(450,'0000000481','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(451,'0000000482','Universidad Nacional Experimental Polit','N','','Oficiales'),(452,'0000000483','Universidad Nacional Experimental Polit','N','','Oficiales'),(453,'0000000484','Universidad Nacional Experimental Polit','N','','Oficiales'),(454,'0000000485','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(455,'0000000486','Universidad Nacional Experimental Polit','N','','Oficiales'),(456,'0000000487','Universidad Nacional Experimental Polit','N','','Oficiales'),(457,'0000000488','Universidad Nacional Experimental Polit','N','','Oficiales'),(458,'0000000489','Universidad Nacional Experimental Polit','N','','Oficiales'),(459,'0000000490','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(460,'0000000491','Universidad Nacional Experimental Polit','N','','Oficiales'),(461,'0000000492','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(462,'0000000493','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(463,'0000000494','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(464,'0000000495','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(465,'0000000496','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(466,'0000000497','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(467,'0000000498','Universidad Nacional Experimental Polit','N','','Oficiales'),(468,'0000000499','Universidad Nacional Experimental Polit','N','','Oficiales'),(469,'0000000500','Universidad Nacional Experimental Polit','N','','Oficiales'),(470,'0000000501','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(471,'0000000502','Universidad Nacional Experimental de Guayana','Caicara del Orinoco','','Oficiales'),(472,'0000000503','Universidad Nacional Experimental Sur del Lago Jes','N','','Oficiales'),(473,'0000000504','Instituto Universitario Latinoamericano de Agroecolog','Barinas','','Oficiales'),(474,'0000000505','Universidad Bolivariana de los Trabajadores Jes','Maturin -Monagas','','Oficiales'),(475,'0000000507','Universidad Nacional Experimental de la Seguridad','Caracas','','Oficiales'),(476,'0000000508','Universidad de Oriente','Extensi','','Oficiales'),(477,'0000000510','Universidad Bolivariana de Venezuela','Monagas','','Oficiales'),(478,'0000000511','Instituto Universitario Jes','Guanarito','','Privadas'),(479,'0000000524','Universidad Polit','La Victoria','','Oficiales'),(480,'0000000525','Universidad Polit','Barinas','','Oficiales'),(481,'0000000526','Universidad Polit','Higuerote','','Oficiales'),(482,'0000000527','Universidad Polit','La Fr','','Oficiales'),(483,'0000000528','Universidad Polit','Barquisimeto','','Oficiales'),(484,'0000000529','Universidad Militar Bolivariana de Venezuela','Distrito Capital','','Oficiales'),(485,'0000000531','UMBV - Academia Militar de la Aviaci','Aragua','','Oficiales'),(486,'0000000533','UMBV - Academia Militar de la Aviaci','Aragua','','Oficiales'),(487,'0000000534','Universidad Polit','Barinitas','','Oficiales'),(488,'0000000535','Universidad Polit','Socop','','Oficiales'),(489,'0000000536','Universidad Nacional Experimental Polit','Trujillo- Sede Betijoque','','Oficiales'),(490,'0000000537','Universidad Nacional Experimental Polit','Sede Juan Griego','','Oficiales'),(491,'0000000538','Universidad Nacional Experimental Polit','Sede Guanare','','Oficiales'),(492,'0000000539','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(493,'0000000540','Universidad Nacional Experimental Polit','Sede Zaraza','','Oficiales'),(494,'0000000542','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(495,'0000000543','Universidad Nacional Experimental Polit','Extensi','','Oficiales'),(496,'0000000544','Universidad Nacional Experimental Polit','N','','Oficiales'),(497,'0000000545','Universidad Nacional Experimental Polit','N','','Oficiales'),(498,'0000000546','Universidad Nacional Experimental Polit','N','','Oficiales'),(499,'0000000547','Universidad Nacional Experimental Polit','N','','Oficiales'),(500,'0000000548','Universidad Nacional Experimental Polit','N','','Oficiales'),(501,'0000000549','Universidad Nacional Experimental Polit','N','','Oficiales'),(502,'0000000550','Universidad Nacional Experimental Polit','N','','Oficiales'),(503,'0000000551','Universidad Polit','Caripito','','Oficiales'),(504,'0000000552','Universidad Polit','Acarigua','','Oficiales'),(505,'0000000553','Universidad Polit','Cuman','','Oficiales'),(506,'0000000554','Universidad Polit','Car','','Oficiales'),(507,'0000000555','Universidad Polit','Ejido','','Oficiales'),(508,'0000000556','Universidad Nacional Experimental Polit','Gu','','Oficiales'),(509,'0000000557','Universidad Polit','Punta de Mata','','Oficiales');
/*!40000 ALTER TABLE `universidades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `usuarios`
--

DROP TABLE IF EXISTS `usuarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sede_id` int(11) DEFAULT NULL,
  `cedula` varchar(12) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `apellido` varchar(50) NOT NULL,
  `salf` varchar(255) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_EF687F27BF39BE0` (`cedula`),
  KEY `IDX_EF687F2E19F41BF` (`sede_id`),
  CONSTRAINT `FK_EF687F2E19F41BF` FOREIGN KEY (`sede_id`) REFERENCES `sede` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `usuarios`
--

LOCK TABLES `usuarios` WRITE;
/*!40000 ALTER TABLE `usuarios` DISABLE KEYS */;
INSERT INTO `usuarios` VALUES (1,1,'18897528','Administrador','upel',NULL,'23181','adminsige18@upel.edu.ve'),(48,1,'1234567','ControlEstudioRectorado','',NULL,'23181','controlestrectorado@upel.edu.ve'),(49,1,'21072129','Jose Manuel','Cuevas',NULL,'23181','jcuevasinfante17@gmail.com'),(50,1,'18738560','Arnaldo','Avila',NULL,'upel2025','arnaldo19_89@hotmail.com'),(53,1,'123456','Betsi','Betsi',NULL,'ccp#2025','betsicurri@upel.edu.ve'),(54,NULL,'14163851','usuario clave','profesores',NULL,'Mc3640800','cestebanc@upel.edu.ve'),(55,NULL,'27376742','Asesoria','Rectorado',NULL,'27376742','asesoriaRectorado@gmail.com'),(56,NULL,'10489599','Gaby G','Bejarano',NULL,'upel2023','mbejarano@upel.edu.ve'),(57,NULL,'12382136','Darwin','Linares',NULL,'dl1234','dlinares@upel.edu.ve'),(58,NULL,'22500247','pepe','jjj',NULL,'123456','pj@gmail.com'),(61,NULL,'12345678','Administrador','Curriculo',NULL,'ccp#2025','curriculoipb@upel.edu.ve'),(63,NULL,'12345671','Administrador','Curriculo',NULL,'ccp#2025','curriculoipc@upel.edu.ve'),(64,NULL,'12345672','Administrador','Curriculo',NULL,'ccp#2025','curriculoipm@upel.edu.ve'),(65,NULL,'12345673','Administrador','Curriculo',NULL,'ccp#2025','curriculoipmar@upel.edu.ve'),(66,NULL,'12345674','Administrador','Curriculo',NULL,'ccp#2025','curriculoimpm@upel.edu.ve'),(67,NULL,'12345675','Administrador','Curriculo',NULL,'ccp#2025','curriculoipsiso@upel.edu.ve'),(69,NULL,'12345676','Administrador','Curriculo',NULL,'ccp#2025','curriculoiprubio@upel.edu.ve'),(71,NULL,'12345677','Administrador','Curriculo',NULL,'ccp#2025','curriculoipmacaro@upel.edu.ve'),(72,NULL,'121514','Ejemplo','Uno',NULL,'121514','ejemplo@hotmail.com'),(76,NULL,'13537829','Nombre','Apellido',NULL,'123147','jjjttt@hotmail.com'),(77,NULL,'87351','Administrador','Rectorado',NULL,'123456','admin@ipc.upel'),(78,NULL,'87352','Administrador','Rectorado',NULL,'123456','admin@ipb.upel'),(79,NULL,'87353','Administrador','Rectorado',NULL,'123456','admin@ipmar.upel'),(80,NULL,'87354','Administrador','Rectorado',NULL,'123456','admin@ipmat.upel'),(81,NULL,'87355','Administrador','Rectorado',NULL,'123456','admin@siso.upel'),(82,NULL,'87356','Administrador','Rectorado',NULL,'123456','admin@impm.upel'),(83,NULL,'87357','Administrador','Rectorado',NULL,'123456','admin@macaro.upel'),(84,NULL,'87358','Administrador','Rectorado',NULL,'123456','admin@rubio.upel'),(85,NULL,'87359','Administrador','Rectorado',NULL,'upel2023','admin@rectorado.upel'),(86,NULL,'1353782','joseline','tovar',NULL,'23181','joselineti@gmail.com');
/*!40000 ALTER TABLE `usuarios` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-12-27 10:52:25
